;;; GNU Guix --- Functional package management for GNU
;;; Copyright © 2014 John Darrington <jmd@gnu.org>
;;; Copyright © 2015 Taylan Ulrich Bayırlı/Kammer <taylanbayirli@gmail.com>
;;; Copyright © 2015 Mark H Weaver <mhw@netris.org>
;;; Copyright © 2016 Federico Beffa <beffa@fbengineering.ch>
;;; Copyright © 2016, 2017 Nikita <nikita@n0.is>
;;; Copyright © 2016, 2017 Andy Patterson <ajpatter@uwaterloo.ca>
;;; Copyright © 2017, 2019, 2020 Ricardo Wurmus <rekado@elephly.net>
;;; Copyright © 2017-2020, 2022, 2023 Efraim Flashner <efraim@flashner.co.il>
;;; Copyright © 2017, 2019 Tobias Geerinckx-Rice <me@tobias.gr>
;;; Copyright © 2018 Benjamin Slade <slade@jnanam.net>
;;; Copyright © 2018 Alex Vong <alexvong1995@gmail.com>
;;; Copyright © 2018, 2020, 2021, 2022 Pierre Neidhardt <mail@ambrevar.xyz>
;;; Copyright © 2018, 2019 Pierre Langlois <pierre.langlois@gmx.com>
;;; Copyright © 2019, 2020 Katherine Cox-Buday <cox.katherine.e@gmail.com>
;;; Copyright © 2019 Jesse Gildersleve <jessejohngildersleve@protonmail.com>
;;; Copyright © 2019-2025 Guillaume Le Vaillant <glv@posteo.net>
;;; Copyright © 2019 Brett Gilio <brettg@gnu.org>
;;; Copyright © 2020, 2024, 2025 Konrad Hinsen <konrad.hinsen@fastmail.net>
;;; Copyright © 2020 Dimakis Dimakakos <me@bendersteed.tech>
;;; Copyright © 2020 Oleg Pykhalov <go.wigust@gmail.com>
;;; Copyright © 2020, 2021, 2022 Adam Kandur <rndd@tuta.io>
;;; Copyright © 2020-2025 Sharlatan Hellseher <sharlatanus@gmail.com>
;;; Copyright © 2021, 2022 Aurora <rind38@disroot.org>
;;; Copyright © 2021 Matthew James Kraai <kraai@ftbfs.org>
;;; Copyright © 2021-2025 André A. Gomes <andremegafone@gmail.com>
;;; Copyright © 2021, 2022, 2023 Cage <cage-dev@twistfold.it>
;;; Copyright © 2021 Cameron Chaparro <cameron@cameronchaparro.com>
;;; Copyright © 2021, 2024, 2025 Charles Jackson <charles.b.jackson@protonmail.com>
;;; Copyright © 2021, 2022 Foo Chuan Wei <chuanwei.foo@hotmail.com>
;;; Copyright © 2021-2025 jgart <jgart@dismail.de>
;;; Copyright © 2021 Aleksandr Vityazev <avityazev@posteo.org>
;;; Copyright © 2021 Jacob MacDonald <jaccarmac@gmail.com>
;;; Copyright © 2022 Jai Vetrivelan <jaivetrivelan@gmail.com>
;;; Copyright © 2022, 2023, 2024 Paul A. Patience <paul@apatience.com>
;;; Copyright © 2022 Thomas Albers Raviola <thomas@thomaslabs.org>
;;; Copyright © 2022 Arun Isaac <arunisaac@systemreboot.net>
;;; Copyright © 2022 Trevor Richards <trev@trevdev.ca>
;;; Copyright © 2022, 2023 Artyom Bologov <mail@aartaka.me>
;;; Copyright © 2023, 2024 Roman Scherer <roman@burningswell.com>
;;; Copyright © 2023 ykonai <mail@ykonai.net>
;;; Copyright © 2023 Gabriel Hondet <gabriel.hondet@cominety.net>
;;; Copyright © 2023 Raven Hallsby <karl@hallsby.com>
;;; Copyright © 2024 Michal Atlas <michal_atlas+git@posteo.net>
;;; Copyright © 2024 Carlo Zancanaro <carlo@zancanaro.id.au>
;;; Copyright © 2024 Nik Gaffney <nik@fo.am>
;;; Copyright © 2024 Grigory Shepelev <shegeley@gmail.com>
;;; Copyright © 2025 Junker <dk@junkeria.club>
;;; Copyright © 2025 Simen Endsjø <contact@simendsjo.me>
;;; Copyright © 2025 Ashish SHUKLA <ashish.is@lostca.se>
;;;
;;; This file is part of GNU Guix.
;;;
;;; GNU Guix is free software; you can redistribute it and/or modify it
;;; under the terms of the GNU General Public License as published by
;;; the Free Software Foundation; either version 3 of the License, or (at
;;; your option) any later version.
;;;
;;; GNU Guix is distributed in the hope that it will be useful, but
;;; WITHOUT ANY WARRANTY; without even the implied warranty of
;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;; GNU General Public License for more details.
;;;
;;; You should have received a copy of the GNU General Public License
;;; along with GNU Guix.  If not, see <http://www.gnu.org/licenses/>.

;;; This file only contains Common Lisp libraries.
;;; Common Lisp compilers and tooling go to lisp.scm.
;;; Common Lisp applications should go to the most appropriate file,
;;; e.g. StumpWM is in wm.scm.
;;; Common Lisp libraries related to code testing facilities go
;;; to lisp-check.scm.

(define-module (gnu packages lisp-xyz)
  #:use-module (gnu packages)
  #:use-module (guix gexp)
  #:use-module ((guix licenses) #:prefix license:)
  #:use-module (guix packages)
  #:use-module (guix download)
  #:use-module (guix git-download)
  #:use-module (guix hg-download)
  #:use-module (guix utils)
  #:use-module (guix build-system asdf)
  #:use-module (guix build-system gnu)
  #:use-module (guix build-system trivial)
  #:use-module (guix build-system emacs)
  #:use-module (gnu packages audio)
  #:use-module (gnu packages autotools)
  #:use-module (gnu packages base)
  #:use-module (gnu packages c)
  #:use-module (gnu packages compression)
  #:use-module (gnu packages databases)
  #:use-module (gnu packages enchant)
  #:use-module (gnu packages figlet)
  #:use-module (gnu packages file)
  #:use-module (gnu packages fonts)
  #:use-module (gnu packages fontutils)
  #:use-module (gnu packages freedesktop)
  #:use-module (gnu packages game-development)
  #:use-module (gnu packages gcc)
  #:use-module (gnu packages gl)
  #:use-module (gnu packages glib)
  #:use-module (gnu packages gnome)
  #:use-module (gnu packages gnupg)
  #:use-module (gnu packages graphics)
  #:use-module (gnu packages graphviz)
  #:use-module (gnu packages gtk)
  #:use-module (gnu packages image)
  #:use-module (gnu packages imagemagick)
  #:use-module (gnu packages kerberos)
  #:use-module (gnu packages libevent)
  #:use-module (gnu packages libffi)
  #:use-module (gnu packages linux)
  #:use-module (gnu packages lisp)
  #:use-module (gnu packages lisp-check)
  #:use-module (gnu packages maths)
  #:use-module (gnu packages mp3)
  #:use-module (gnu packages mpi)
  #:use-module (gnu packages ncurses)
  #:use-module (gnu packages networking)
  #:use-module (gnu packages package-management)
  #:use-module (gnu packages pkg-config)
  #:use-module (gnu packages python)
  #:use-module (gnu packages python-xyz)
  #:use-module (gnu packages readline)
  #:use-module (gnu packages rsync)
  #:use-module (gnu packages sdl)
  #:use-module (gnu packages serialization)
  #:use-module (gnu packages sqlite)
  #:use-module (gnu packages statistics)
  #:use-module (gnu packages tcl)
  #:use-module (gnu packages texinfo)
  #:use-module (gnu packages tls)
  #:use-module (gnu packages uml)
  #:use-module (gnu packages version-control)
  #:use-module (gnu packages video)
  #:use-module (gnu packages web)
  #:use-module (gnu packages webkit)
  #:use-module (gnu packages xdisorg)
  #:use-module (gnu packages xiph)
  #:use-module (gnu packages xml)
  #:use-module (gnu packages xorg)
  #:use-module (ice-9 match)
  #:use-module (srfi srfi-1)
  #:use-module (srfi srfi-19))

(define-public sbcl-3b-bmfont
  (let ((commit "332c2262705f161627fc18add0310451a42799af")
        (revision "3"))
    (package
      (name "sbcl-3b-bmfont")
      (version (git-version "0.0.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/3b/3b-bmfont/")
               (commit commit)))
         (file-name (git-file-name "cl-3b-bmfont" version))
         (sha256
          (base32 "11wnqa1wx9vji6cmxl5m5qnf12mqc6n7d5g8038r1wayq88bxia6"))))
      (build-system asdf-build-system/sbcl)
      (arguments
       `(#:asd-systems '("3b-bmfont"
                         "3b-bmfont/common"
                         "3b-bmfont/json"
                         "3b-bmfont/text"
                         "3b-bmfont/xml")))
      (inputs
       (list sbcl-alexandria
             sbcl-cxml
             sbcl-flexi-streams
             sbcl-jsown
             sbcl-parse-number
             sbcl-split-sequence))
      (home-page "https://github.com/3b/3b-bmfont/")
      (synopsis "Read/write bmfont metadata files")
      (description
       "This is a Common Lisp library which provides functionality to
read/write Bit Map Font (BMF) into text, JSON and XML.")
      (license license:expat))))

(define-public ecl-3b-bmfont
  (sbcl-package->ecl-package sbcl-3b-bmfont))

(define-public cl-3b-bmfont
  (sbcl-package->cl-source-package sbcl-3b-bmfont))

(define sbcl-3b-bmfont/shinmera
  (let ((commit "58e529d24b7799d56b4b3f9c8a953b585d42c7d2")
        (revision "1"))
    (package (inherit sbcl-3b-bmfont)
             (version (git-version "0.0.1" revision commit))
             (source
              (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/Shinmera/3b-bmfont/")
                      (commit commit)))
                (file-name (git-file-name "3b-bmfont2" version))
                (sha256
                 (base32 "17zby669b64rhxhk2szamzdgvispimh6ici05xa6x2vz4rvk71jq")))))))

(define-public sbcl-3bmd
  (let ((commit "e68b2d442f29b4534c1c8e2f2cdf7583643a2fc5")
        (revision "4"))
    (package
      (name "sbcl-3bmd")
      (version (git-version "0.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/3b/3bmd")
               (commit commit)))
         (sha256
          (base32 "12xqih1gnwsn1baqm7bq3kxss73phn06gvd0v1h1vwsjd1xgpq3g"))
         (file-name (git-file-name "cl-3bmd" version))))
      (build-system asdf-build-system/sbcl)
      (arguments
       `(#:asd-systems
         '("3bmd"
           "3bmd-ext-definition-lists"
           "3bmd-ext-math"
           "3bmd-ext-tables"
           "3bmd-ext-wiki-links"
           "3bmd-youtube"
           "3bmd-ext-code-blocks")
         #:phases
         (modify-phases %standard-phases
           (add-after 'unpack 'fix-python3-path
             (lambda _
               (substitute* "code-blocks.lisp"
                 (("python3") (which "python3"))))))))
      (native-inputs
       (list sbcl-fiasco))
      (inputs
       (list python
             python-pygments
             sbcl-alexandria
             sbcl-colorize
             sbcl-split-sequence
             sbcl-esrap))
      (home-page "https://github.com/3b/3bmd")
      (synopsis "Markdown processor in Command Lisp using esrap parser")
      (description
       "This is a Common Lisp Markdown to HTML converter, using @command{esrap}
for parsing, and grammar based on @command{peg-markdown}.")
      (license license:expat))))

(define-public cl-3bmd
  (sbcl-package->cl-source-package sbcl-3bmd))

(define-public ecl-3bmd
  (sbcl-package->ecl-package sbcl-3bmd))

(define-public sbcl-3bz
  (let ((commit "569614c40408f3aefc77ba233e0e4bd66d3850ad")
        (revision "1"))
    (package
      (name "sbcl-3bz")
      (version (git-version "0.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/3b/3bz")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "0kvvlvf50jhhw1s510f3clpr1a68632bq6d698yxcrx722igcrg4"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-alexandria
             sbcl-babel
             sbcl-cffi
             sbcl-mmap
             sbcl-nibbles
             sbcl-trivial-features))
      (home-page "https://github.com/3b/3bz")
      (synopsis "Deflate decompression for Common Lisp")
      (description
       "3bz is an implementation of Deflate decompression (RFC 1951) optionally
with zlib (RFC 1950) or gzip (RFC 1952) wrappers, with support for reading from
foreign pointers (for use with mmap and similar, etc), and from CL octet
vectors and streams.")
      (license license:expat))))

(define-public cl-3bz
  (sbcl-package->cl-source-package sbcl-3bz))

(define-public ecl-3bz
  (sbcl-package->ecl-package sbcl-3bz))

(define-public sbcl-3d-math
  (let ((commit "3831b1706d225def95a7301ef48b393b563f0114")
        (revision "0"))
    (package
      (name "sbcl-3d-math")
      (version (git-version "1.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/Shinmera/3d-math")
               (commit commit)))
         (file-name (git-file-name "cl-3d-math" version))
         (sha256
          (base32 "052vzx5j7bag9dxvl0j0wrm244js1djldyn31rwxgkq7965rmi5r"))))
      (build-system asdf-build-system/sbcl)
      (native-inputs
       (list sbcl-parachute))
      (inputs
       (list sbcl-documentation-utils
             sbcl-type-templates))
      (home-page "https://shinmera.github.io/3d-math/")
      (synopsis "Linear algebra for 2D and 3D computations")
      (description
       "The @code{3d-math} library implements types, operators, and algorithms
commonly used in math for 2D and 3D graphics.  It supersedes and combines the
prior libraries @code{3d-vectors}, @code{3d-matrices}, @code{3d-quaternions},
and @code{3d-transforms}.  The new API is largely but not entirely backwards
compatible, and adds new functionality.")
      (license license:zlib))))

(define-public cl-3d-math
  (sbcl-package->cl-source-package sbcl-3d-math))

(define-public ecl-3d-math
  (sbcl-package->ecl-package sbcl-3d-math))

(define-public sbcl-3d-matrices
  (let ((commit "bc1ffa08dcf4732523e09adcf9deba4ddeb559ff")
        (revision "3"))
    (package
      (name "sbcl-3d-matrices")
      (version (git-version "1.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://codeberg.org/shinmera/3d-matrices")
               (commit commit)))
         (file-name (git-file-name "cl-3d-matrices" version))
         (sha256
          (base32 "0jzckgb5lsmh1gn1f4mczjfc5ckkw01a73wrl1shyb9sil93a751"))))
      (build-system asdf-build-system/sbcl)
      (native-inputs
       (list sbcl-parachute))
      (inputs
       (list sbcl-3d-vectors sbcl-documentation-utils))
      (home-page "https://codeberg.org/shinmera/3d-matrices")
      (synopsis "Utility library implementing 2x2, 3x3, 4x4 and NxM matrices")
      (description
       "@code{3D-MATRICES} is a library implementing common matrix operations,
mainly intended as the counterpiece to @code{3d-vectors} and thus being aimed at
operations in 3D space.")
      (license license:zlib))))

(define-public cl-3d-matrices
  (sbcl-package->cl-source-package sbcl-3d-matrices))

(define-public ecl-3d-matrices
  (sbcl-package->ecl-package sbcl-3d-matrices))

(define-public clasp-3d-matrices
  (sbcl-package->clasp-package sbcl-3d-matrices))

(define-public sbcl-3d-quaternions
  (let ((commit "f477801d1c85020f8173d2951a54e7be10460048")
        (revision "1"))
    (package
      (name "sbcl-3d-quaternions")
      (version (git-version "1.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://codeberg.org/shinmera/3d-quaternions")
               (commit commit)))
         (file-name (git-file-name "cl-3d-quaternions" version))
         (sha256
          (base32 "1vyagfn432d8gzhfcg1wy38zygks78by8q75qiybv4iarg41lm8i"))))
      (build-system asdf-build-system/sbcl)
      (native-inputs
       (list sbcl-parachute))
      (inputs
       (list sbcl-3d-matrices sbcl-3d-vectors sbcl-documentation-utils))
      (home-page "https://codeberg.org/shinmera/3d-quaternions")
      (synopsis "Quaternion and dual-quaternion functionality in Common Lisp")
      (description
       "This is a library for quaternions.  It contains most of the quaternion
operations one would usually expect out of such a library and offers them both
in non-modifying and modifying versions where applicable.  It also tries to be
efficient where plausible.  Each quaternion is made up of @code{float}s, which
by default are @code{single-float}s, as they do not require value boxing on
most modern systems and compilers.")
      (license license:zlib))))

(define-public cl-3d-quaternions
  (sbcl-package->cl-source-package sbcl-3d-quaternions))

(define-public ecl-3d-quaternions
  (package
    (inherit (sbcl-package->ecl-package sbcl-3d-quaternions))
    (arguments
     ;; See <https://codeberg.org/shinmera/3d-quaternions/issues/1>.
     (list #:tests? #f))))

(define-public clasp-3d-quaternions
  (sbcl-package->clasp-package sbcl-3d-quaternions))

(define-public sbcl-3d-spaces
  (let ((commit "a93f4915affcf65617366297ad8bd2ec77bae702")
        (revision "0"))
    (package
      (name "sbcl-3d-spaces")
      (version (git-version "1.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/Shirakumo/3d-spaces")
               (commit commit)))
         (file-name (git-file-name "cl-3d-spaces" version))
         (sha256
          (base32 "1m5cg5zy1731dcgkm1p4m53z1zsp387xligxh32pdrnrhc2lzhmf"))))
      (build-system asdf-build-system/sbcl)
      (native-inputs
       (list sbcl-parachute))
      (inputs
       (list sbcl-3d-math
             sbcl-documentation-utils
             sbcl-for
             sbcl-trivial-extensible-sequences))
      (home-page "https://shirakumo.github.io/3d-spaces/")
      (synopsis "Implementations of various spatial query structures")
      (description
       "The 3D-Spaces library implements a number of spatial query data
structures; structures that can answer spatial range queries for optimized
lookup, particularly suited for games.")
      (license license:zlib))))

(define-public cl-3d-spaces
  (sbcl-package->cl-source-package sbcl-3d-spaces))

(define-public ecl-3d-spaces
  (sbcl-package->ecl-package sbcl-3d-spaces))

(define-public sbcl-3d-transforms
  (let ((commit "86e7e99fa9027c1d230adc83f3a2a74a2b83eb08")
        (revision "1"))
    (package
      (name "sbcl-3d-transforms")
      (version (git-version "1.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://codeberg.org/shinmera/3d-transforms")
               (commit commit)))
         (file-name (git-file-name "cl-3d-transforms" version))
         (sha256
          (base32 "04z532aq5rwfg3z7nijxzxikmcv504d6xx7gwmc7blk7z3mjk7dd"))))
      (build-system asdf-build-system/sbcl)
      (native-inputs
       (list sbcl-parachute))
      (inputs
       (list sbcl-3d-matrices
             sbcl-3d-quaternions
             sbcl-3d-vectors
             sbcl-documentation-utils))
      (home-page "https://shinmera.com/docs/3d-transforms")
      (synopsis
       "Common structure to encapsulate spatial transformations in Common Lisp")
      (description
       "This is a library that uses the other 3d-* math libraries to present an
encapsulation for a spatial transformation.  It offers convenience functions for
operating on such transformations and for converting between them and the
alternative 4x4 matrix representation.")
      (license license:zlib))))

(define-public cl-3d-transforms
  (sbcl-package->cl-source-package sbcl-3d-transforms))

;; TODO: Build failure:
;; https://codeberg.org/shinmera/3d-quaternions/issues/1
;;
;; (define-public ecl-3d-transforms
;;   (sbcl-package->ecl-package sbcl-3d-transforms))

(define-public clasp-3d-transforms
  (sbcl-package->clasp-package sbcl-3d-transforms))

(define-public sbcl-3d-vectors
  (let ((commit "fc751c65b2285e971c348539bfbc3cbb58b253b0")
        (revision "3"))
    (package
      (name "sbcl-3d-vectors")
      (version (git-version "3.1.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://codeberg.org/shinmera/3d-vectors")
               (commit commit)))
         (file-name (git-file-name "cl-3d-vectors" version))
         (sha256
          (base32 "0im0c4yv3bmlipbpfqfcbkdpqknr4468xjvdmrr01pchc8r4m11j"))))
      (build-system asdf-build-system/sbcl)
      (native-inputs
       (list sbcl-parachute))
      (inputs
       (list sbcl-documentation-utils))
      (home-page "https://shinmera.github.io/3d-vectors/")
      (synopsis "Utility library implementing 2D, 3D, and 4D vectors")
      (description
       "@code{3D-VECTORS} is a library for vector math in 3D space.  It contains
most of the vector operations one would usually expect out of such a library and
offers them both in non-modifying and modifying versions where applicable.")
      (license license:zlib))))

(define-public cl-3d-vectors
  (sbcl-package->cl-source-package sbcl-3d-vectors))

(define-public ecl-3d-vectors
  (sbcl-package->ecl-package sbcl-3d-vectors))

(define-public clasp-3d-vectors
  (sbcl-package->clasp-package sbcl-3d-vectors))

(define-public sbcl-40ants-asdf-system
  (let ((commit "91ed8a4430552f58563d84182b97b25e9e1e8dbe")
        (revision "1"))
    (package
      (name "sbcl-40ants-asdf-system")
      (version (git-version "0.3.2" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
                (url "https://github.com/40ants/40ants-asdf-system")
                (commit commit)))
         (sha256
          (base32 "0wi575m0s0a9fvp1wy5ga760f71la16z1633qk6s2f87rwcjs8kw"))
         (file-name (git-file-name "cl-40ants-asdf-system" version))))
      (build-system asdf-build-system/sbcl)
      (native-inputs (list sbcl-rove))
      (home-page "https://40ants.com/40ants-asdf-system/")
      (synopsis "Alternative to asdf:package-inferred-system")
      (description
       "@code{40ants-asdf-system} provides a class for being used instead of
@code{asdf:package-inferred-system} in 40ANT systems.")
      (license license:bsd-3))))

(define-public cl-40ants-asdf-system
  (sbcl-package->cl-source-package sbcl-40ants-asdf-system))

(define-public ecl-40ants-asdf-system
  (sbcl-package->ecl-package sbcl-40ants-asdf-system))

(define-public sbcl-40ants-doc
  (package
    (name "sbcl-40ants-doc")
    (version "0.24.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
              (url "https://github.com/40ants/doc")
              (commit (string-append "v" version))))
       (sha256
        (base32 "04hhf16ylv417xz2jvf6s0ybbv0pwjscarvqnpbn8by4wmchvkjl"))
       (file-name (git-file-name "cl-40ants-doc" version))))
    (build-system asdf-build-system/sbcl)
    (arguments
     '(#:asd-systems '("40ants-doc"
                       "40ants-doc-full")))
    (inputs
     (list sbcl-cl-fad
           sbcl-cl-str
           sbcl-commondoc-markdown
           sbcl-dexador
           sbcl-docs-config
           sbcl-jonathan
           sbcl-lass
           sbcl-log4cl
           sbcl-named-readtables
           sbcl-pythonic-string-reader
           sbcl-rove
           sbcl-serapeum
           sbcl-slime-swank
           sbcl-slynk
           sbcl-spinneret
           sbcl-stem
           sbcl-tmpdir
           sbcl-which
           sbcl-xml-emitter))
    (home-page "https://40ants.com/doc/")
    (synopsis "Exploratory programming environment and documentation generator")
    (description
     "@code{40ants-doc} provides a rudimentary explorable programming
environment.  The narrative primarily lives in so-called sections that mix
Markdown docstrings with references to functions, variables, etc., all of
which should probably have their own docstrings.

The primary focus is on making code easily explorable by using SLIME's
@kbd{M-.} (@code{slime-edit-definition}).  Generating documentation in
Markdown or HTML format from sections and all the referenced items is also
implemented.

With the simplistic tools provided, one may obtain results similar to literate
programming, but documentation is generated from code, not the other way
around, and there is no support for chunking.  Code comes first, code must
look pretty, documentation is code.

@code{40ants-doc} is a fork of MGL-PAX with fewer dependencies (only
@code{named-readtables} and @code{pythonic-string-reader}) for the core
system, and additional features in the full system.")
    (license license:expat)))

(define-public cl-40ants-doc
  (sbcl-package->cl-source-package sbcl-40ants-doc))

(define-public ecl-40ants-doc
  (sbcl-package->ecl-package sbcl-40ants-doc))

(define-public sbcl-40ants-plantuml
  (let ((commit "928a074051491273450c70a290b11db27fd379e7")
        (revision "0"))
    (package
      (name "sbcl-40ants-plantuml")
      (version (git-version "0.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
                (url "https://github.com/40ants/plantuml")
                (commit commit)))
         (sha256
          (base32 "0bi3i0cw16aa38xp04xwirdfvwjz862q5yzghpprddi1q5mvxpbf"))
         (file-name (git-file-name "cl-40ants-plantuml" version))))
      (build-system asdf-build-system/sbcl)
      (arguments
       (list
        #:phases
        #~(modify-phases %standard-phases
            (add-after 'unpack 'fix-paths
              (lambda* (#:key inputs #:allow-other-keys)
                (substitute* "src/core.lisp"
                  (("/usr/share/plantuml/plantuml.jar")
                   (search-input-file inputs "/bin/plantuml"))))))))
      (native-inputs (list sbcl-rove))
      (inputs
       (list graphviz
             plantuml
             sbcl-40ants-asdf-system
             sbcl-serapeum))
      (home-page "https://40ants.com/plantuml/")
      (synopsis "Wrapper around PlantUML jar library")
      (description
       "@code{40ants-plantuml} provides a wrapper around the PlantUML jar library.")
      (license license:unlicense))))

(define-public cl-40ants-plantuml
  (sbcl-package->cl-source-package sbcl-40ants-plantuml))

(define-public ecl-40ants-plantuml
  (sbcl-package->ecl-package sbcl-40ants-plantuml))

(define-public sbcl-abstract-classes
  (let ((commit "7fa74f1e057f9ba7c1ffecff14f049f979e45267")
        (revision "1"))
    (package
      (name "sbcl-abstract-classes")
      (version (git-version "1.7.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://bitbucket.org/eeeickythump/cl-abstract-classes")
               (commit commit)))
         (file-name (git-file-name "cl-abstract-classes" version))
         (sha256
          (base32 "06lby4i6xbbgs7kgb0f3fqybvyskyg6djhrf967lnysv7hn3zpg9"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       `(("closer-mop" ,sbcl-closer-mop)))
      (arguments
       `(#:asd-systems '("abstract-classes" "singleton-classes")))
      (home-page "https://bitbucket.org/eeeickythump/cl-abstract-classes")
      (synopsis "Abstract, final, and singleton metaclasses for CLOS")
      (description
       "This package provides Common Lisp extension to the MOP to allow
abstract, final and singleton classes.")
      (license license:public-domain))))

(define-public ecl-abstract-classes
  (sbcl-package->ecl-package sbcl-abstract-classes))

(define-public cl-abstract-classes
  (sbcl-package->cl-source-package sbcl-abstract-classes))

(define-public sbcl-access
  (let ((commit "a4f87fc1007f5c9a0a2abfddc1c23a77e87096f8")
        (revision "1"))
    (package
      (name "sbcl-access")
      (version (git-version "1.6.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/AccelerationNet/access")
               (commit commit)))
         (file-name (git-file-name "cl-access" version))
         (sha256
          (base32 "0zdjqhb9rvnlq6nzmsp7372gi91k1rq9bz510m6hcki7g3r01iv5"))))
      (build-system asdf-build-system/sbcl)
      (native-inputs
       (list sbcl-lisp-unit2))
      (inputs
       (list sbcl-alexandria
             sbcl-cl-ppcre
             sbcl-closer-mop
             sbcl-iterate))
      (synopsis
       "Common lisp library to unify access to dictionary-like structures")
      (description
       "This is a Common lisp library to unify access to the most common
dictionary-like data structures.")
      (home-page "https://github.com/AccelerationNet/access")
      (license license:bsd-3))))

(define-public ecl-access
  (sbcl-package->ecl-package sbcl-access))

(define-public cl-access
  (sbcl-package->cl-source-package sbcl-access))

(define-public sbcl-acclimation
  (let ((commit "4d51150902568fcd59335f4cc4cfa022df6116a5"))
    (package
      (name "sbcl-acclimation")
      (version (git-version "0.0.0" "1" commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/robert-strandh/Acclimation")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "1aw7rarjl8ai57h0jxnp9hr3dka7qrs55mmbl1p6rhd6xj8mp9wq"))))
      (build-system asdf-build-system/sbcl)
      (home-page "https://github.com/robert-strandh/Acclimation")
      (synopsis "Internationalization library for Common Lisp")
      (description "This project is meant to provide tools for
internationalizing Common Lisp programs.

One important aspect of internationalization is of course the language used in
error messages, documentation strings, etc.  But with this project we provide
tools for all other aspects of internationalization as well, including dates,
weight, temperature, names of physical quantities, etc.")
      (license license:bsd-2))))

(define-public cl-acclimation
  (sbcl-package->cl-source-package sbcl-acclimation))

(define-public ecl-acclimation
  (sbcl-package->ecl-package sbcl-acclimation))

(define-public sbcl-ecclesia
  (let ((commit "605debb6f28f120243da66c281274011e292ce46"))
    (package
      (name "sbcl-ecclesia")
      (version (git-version "0.0.0" "0" commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/s-expressionists/Ecclesia")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "0lmy03lqk82301b86pli9qd6493q6fr7vd5h29j4gwc778awbmf5"))))
      (build-system asdf-build-system/sbcl)
      (inputs (list sbcl-acclimation))
      (home-page "https://github.com/s-expressionists/Ecclesia")
      (synopsis "Utilities for parsing Lisp code")
      (description "This library contains utilities for parsing Common Lisp
code.")
      (license license:bsd-2))))

(define-public cl-ecclesia
  (sbcl-package->cl-source-package sbcl-ecclesia))

(define-public ecl-ecclesia
  (sbcl-package->ecl-package sbcl-ecclesia))

(define-public sbcl-acl-compat
  ;; There does not seem to be proper releases.
  (let ((commit "cac1d6920998ddcbee8310a873414732e707d8e5"))
    (package
      (name "sbcl-acl-compat")
      (version (git-version "0.1.1" "1" commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "git://git.code.sf.net/p/portableaserve/git")
               (commit commit)))
         (file-name (git-file-name "acl-compat" version))
         (sha256
          (base32 "0ak6mqp84sjr0a7h5svr16vra4bf4fcx6wpir0n88dc1vjwy5xqa"))))
      (build-system asdf-build-system/sbcl)
      (arguments
       `(#:phases
         (modify-phases %standard-phases
           (add-after 'unpack 'cd-acl-compat
             (lambda _
               (chdir "acl-compat")
               #t)))))
      (inputs
       `(("puri" ,sbcl-puri)
         ("cl-ppcre" ,sbcl-cl-ppcre)
         ("ironclad" ,sbcl-ironclad)
         ("cl-fad" ,sbcl-cl-fad)))
      (home-page "https://sourceforge.net/projects/portableaserve/")
      (synopsis "AllegroServe, a web server written in Common Lisp")
      (description
       "The server part of AllegroServe can be used either as a standalone web
server or a module loaded into an application to provide a user interface to
the application.  AllegroServe's proxy ability allows it to run on the gateway
machine between some internal network and the Internet.  AllegroServe's client
functions allow Lisp programs to explore the web.")
      (license license:llgpl))))

(define-public cl-acl-compat
  (sbcl-package->cl-source-package sbcl-acl-compat))

(define-public sbcl-common-macros
  (let ((commit "f261a4a07c52e5c560d90154393bd49421ece740")
        (revision "0"))
    (package
      (name "sbcl-common-macros")
      (version (git-version "0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
                (url "https://github.com/robert-strandh/Common-macros")
                (commit commit)))
         (file-name (git-file-name "cl-common-macros" version))
         (sha256
          (base32
           "0rn0rnccjgxsrf828bw740vs8psjjxb5x4hmk8rnqiz5p3y0lvph"))))
      (build-system asdf-build-system/sbcl)
      (arguments
       '(#:asd-systems '("common-macro-definitions")))
      (inputs
       (list sbcl-ecclesia))
      (home-page "https://github.com/robert-strandh/Common-macros")
      (synopsis "Portable Common Lisp macro definitions")
      (description
       "This library defines most Common Lisp standard macros that can be
defined in a portable way and that can generate portable code.  Some of these
macros may not be good enough as the final version for a typical
implementation, but they will work.")
      (license license:bsd-2))))

(define-public cl-common-macros
  (sbcl-package->cl-source-package sbcl-common-macros))

(define-public ecl-common-macros
  (sbcl-package->ecl-package sbcl-common-macros))

(define-public clasp-common-macros
  (sbcl-package->clasp-package sbcl-common-macros))

(define-public sbcl-adopt
  (package
    (name "sbcl-adopt")
    (version "1.2.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/sjl/adopt")
             (commit (string-append "v" version))))
       (file-name (git-file-name "cl-adopt" version))
       (sha256
        (base32 "16kzkai96qk7vmclp8wxc9aghhnisw8gg9s7hra68300bgj86wzr"))))
    (build-system asdf-build-system/sbcl)
    (native-inputs (list sbcl-1am))
    (inputs (list sbcl-bobbin sbcl-split-sequence))
    (home-page "https://hg.stevelosh.com/adopt")
    (synopsis "Common Lisp option parsing library")
    (description
     "@acronym{ADOPT, A Damn OPTion} is a simple UNIX-style option parser in
Common Lisp, heavily influenced by Python's @code{optparse} and
@code{argparse}.")
    (license license:expat)))

(define-public cl-adopt
  (sbcl-package->cl-source-package sbcl-adopt))

(define-public ecl-adopt
  (sbcl-package->ecl-package sbcl-adopt))

(define-public sbcl-agnostic-lizard
  (let ((commit "fe1a1d7d80c8b56163754e0e5b3653fd750ad298")
        (revision "2"))
    (package
      (name "sbcl-agnostic-lizard")
      (version (git-version "0.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://gitlab.common-lisp.net/mraskin/agnostic-lizard")
               (commit commit)))
         (file-name (git-file-name "cl-agnostic-lizard" version))
         (sha256
          (base32 "0amzshh6v3mp24j0h2cinv4zvdlg4kih04md5biakwhnmcw4j4pr"))))
      (build-system asdf-build-system/sbcl)
      (synopsis "Almost correct portable code walker for Common Lisp")
      (description
       "Agnostic Lizard is a portable implementation of a code walker and in
particular of the macroexpand-all function (and macro) that makes a best
effort to be correct while not expecting much beyond what the Common Lisp
standard requires.

It aims to be implementation-agnostic and to climb the syntax trees.")
      (home-page "https://gitlab.common-lisp.net/mraskin/agnostic-lizard")
      (license license:gpl3+))))

(define-public cl-agnostic-lizard
  (sbcl-package->cl-source-package sbcl-agnostic-lizard))

(define-public ecl-agnostic-lizard
  (sbcl-package->ecl-package sbcl-agnostic-lizard))

(define-public sbcl-agutil
  (let ((commit "df188d754d472da9faa1601a48f1f37bb7b34d68"))
    (package
      (name "sbcl-agutil")
      (version (git-version "0.0.1" "1" commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/alex-gutev/agutil/")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "1xpnyzksk2xld64b6lw6rw0gn5zxlb77jwna59sd4yl7kxhxlfpf"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-alexandria sbcl-trivia))
      (home-page "https://github.com/alex-gutev/agutil/")
      (synopsis "Collection of Common Lisp utilities")
      (description "A collection of Common Lisp utility functions and macros
mostly not found in other utility packages.")
      (license license:expat))))

(define-public cl-agutil
  (sbcl-package->cl-source-package sbcl-agutil))

(define-public ecl-agutil
  (sbcl-package->ecl-package sbcl-agutil))

(define-public sbcl-alea
  (package
    (name "sbcl-alea")
    (version "1.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/eXodiquas/alea")
             (commit (string-append "v" version))))
       (file-name (git-file-name "cl-alea" version))
       (sha256
        (base32 "0nd9fdjli22ygfw3c8k9nh7d36c92866hics5aij6x7ly1q781gz"))))
    (build-system asdf-build-system/sbcl)
    (native-inputs (list sbcl-fiveam))
    (synopsis "Dice rolling library")
    (description
     "This package provides a Common Lisp library for dice rolling and working
with dice-roll statistics.")
    (home-page "https://github.com/eXodiquas/alea")
    (license license:expat)))

(define-public cl-alea
  (sbcl-package->cl-source-package sbcl-alea))

(define-public ecl-alea
  (sbcl-package->ecl-package sbcl-alea))

(define-public sbcl-alexa
  (package
    (name "sbcl-alexa")
    (version "2.1.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/quil-lang/alexa")
             (commit (string-append "v" version))))
       (file-name (git-file-name "cl-alexa" version))
       (sha256
        (base32 "1y9jyz9gfmd02h492kf7v3mmpbhc0yfh4ka2rzd1vczq6fl8qgqv"))))
    (build-system asdf-build-system/sbcl)
    (native-inputs (list sbcl-fiasco))
    (inputs (list sbcl-alexandria sbcl-cl-ppcre))
    (synopsis "Lexical Analyzer Generator for Common Lisp")
    (description
     "ALEXA is a tool similar to lex or flex for generating lexical analyzers.
Unlike tools like lex, however, ALEXA defines a domain-specific language
within your Lisp program, so you don't need to invoke a separate tool.")
    (home-page "https://github.com/quil-lang/alexa")
    (license license:bsd-3)))

(define-public ecl-alexa
  (sbcl-package->ecl-package sbcl-alexa))

(define-public cl-alexa
  (sbcl-package->cl-source-package sbcl-alexa))

(define-public sbcl-alexandria
  (let ((commit "009b7e532071d9777bdbd63b82d776555da95916")
        (revision "0"))
    (package
      (name "sbcl-alexandria")
      (version (git-version "1.4" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://gitlab.common-lisp.net/alexandria/alexandria.git")
               (commit commit)))
         (file-name (git-file-name "cl-alexandria" version))
         (sha256
          (base32 "0pdj779j3nwzn8f1661vf00rrjrbks1xgiq0rvwjw6qyxsfqfnl9"))))
      (build-system asdf-build-system/sbcl)
      (arguments
       (list #:phases
             #~(modify-phases %standard-phases
                 (add-after 'build 'build-doc
                   (lambda _
                     (with-directory-excursion "doc"
                       (invoke "make" "info")
                       (install-file "alexandria.info"
                                     (string-append #$output "/share/info"))))))))
      (native-inputs
       (list sbcl-rt texinfo))
      (synopsis "Collection of portable utilities for Common Lisp")
      (description
       "Alexandria is a collection of portable utilities.  It does not contain
conceptual extensions to Common Lisp.  It is conservative in scope, and
portable between implementations.")
      (home-page "https://common-lisp.net/project/alexandria/")
      (license license:public-domain))))

(define-public cl-alexandria
  (sbcl-package->cl-source-package sbcl-alexandria))

(define-public ecl-alexandria
  (let ((pkg (sbcl-package->ecl-package sbcl-alexandria)))
    (package
      (inherit pkg)
      (outputs '("out"))
      (arguments
       (substitute-keyword-arguments (package-arguments pkg)
         ((#:phases phases)
          `(modify-phases ,phases
             (delete 'build-doc))))))))

(define-public clasp-alexandria
  (let ((pkg (sbcl-package->clasp-package sbcl-alexandria)))
    (package
      (inherit pkg)
      (outputs '("out"))
      (arguments
       (substitute-keyword-arguments (package-arguments pkg)
         ((#:phases phases)
          `(modify-phases ,phases
             (delete 'build-doc))))))))

(define-public sbcl-alexandria-plus
  (let ((commit "adafb09838a84895bedb119f8253b89b6a04a2c5")
        (revision "0"))
    (package
      (name "sbcl-alexandria-plus")
      ;; Version is stated in the ASD file.
      (version (git-version "1.1.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/Symbolics/alexandria-plus")
               (commit commit)))
         (file-name (git-file-name "cl-alexandria-plus" version))
         (sha256
          (base32 "1w9r19610h599303gqlx2x5n8mmdynss2gyl7xilg5h6v8z3hkfl"))))
      (build-system asdf-build-system/sbcl)
      (arguments
       '(#:asd-systems '("alexandria+")))
      (native-inputs
       (list sbcl-parachute))
      (inputs
       (list sbcl-alexandria))
      (home-page "https://symbolics.github.io/alexandria-plus/")
      (synopsis "Conservative set of extensions to Alexandria utilities")
      (description
       "@code{cl-alexandria-plus} is a conservative set of extensions to
@code{cl-alexandria} utilities.")
      (license license:ms-pl))))

(define-public cl-alexandria-plus
  (sbcl-package->cl-source-package sbcl-alexandria-plus))

(define-public ecl-alexandria-plus
  (sbcl-package->ecl-package sbcl-alexandria-plus))

(define-public clasp-alexandria-plus
  (sbcl-package->clasp-package sbcl-alexandria-plus))

(define-public sbcl-alloy
  (let ((commit "628974de537affb5b44ad548347f67c16efffcfc")
        (revision "3"))
    (package
      (name "sbcl-alloy")
      (version (git-version "0.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/Shirakumo/alloy")
               (commit commit)))
         (file-name (git-file-name "cl-alloy" version))
         (sha256
          (base32 "0fx294qwxshgijss000pbjbnbwxqvxyw6p3mva36qljhbbkw2fxy"))))
      (build-system asdf-build-system/sbcl)
      (native-inputs
       (list sbcl-alexandria sbcl-parachute))
      (inputs
       (list sbcl-array-utils sbcl-closer-mop sbcl-documentation-utils
             sbcl-float-features sbcl-colored sbcl-stealth-mixin
             sbcl-cl-opengl sbcl-font-discovery sbcl-uax-14 sbcl-sdf))
      (arguments
       ;; Dismiss alloy-svg, since it is not completed:
       ;; https://github.com/Shirakumo/alloy/issues/24
       '(#:asd-systems '("alloy"
                         "alloy-animation"
                         "alloy-opengl"
                         "alloy-opengl-msdf"
                         "alloy-opengl-png"
                         "alloy-simple"
                         "alloy-simple-presentations"
                         "alloy-windowing")))
      (home-page "https://shirakumo.github.io/alloy/")
      (synopsis
       "Common Lisp user interface protocol and toolkit implementation")
      (description
       "Alloy is a user interface toolkit.  It is defined through a set of
protocols that allow for a clear interface, as well as a standardised way to
integrate Alloy into a target backend.")
      (license license:zlib))))

(define-public cl-alloy
  (sbcl-package->cl-source-package sbcl-alloy))

(define-public ecl-alloy
  (sbcl-package->ecl-package sbcl-alloy))

(define-public sbcl-amb
  (let ((commit "884bef69a1ea02f3b9deae0341e1a038ff31b896")
        (revision "0"))
    (package
     (name "sbcl-amb")
     (version (git-version "1.0.0" revision commit))
     (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/phoe/amb")
               (commit commit)))
         (file-name (git-file-name "cl-amb" version))
         (sha256
          (base32 "1klh1aakklj1famrff0sccnwlv8238b1q446288aqnqgxxw6pf21"))))
     (build-system asdf-build-system/sbcl)
     (inputs
       (list sbcl-alexandria))
     (native-inputs
       (list sbcl-parachute))
     (synopsis "Implementation of John McCarthy's ambiguous operator")
     (description
      "@code{cl-amb} provides an implementation of John McCarthy's ambiguous
operator in portable Common Lisp.")
     (home-page "https://github.com/phoe/amb/")
     (license license:expat))))

(define-public cl-amb
  (sbcl-package->cl-source-package sbcl-amb))

(define-public ecl-amb
  (sbcl-package->ecl-package sbcl-amb))

(define-public clasp-amb
  (sbcl-package->clasp-package sbcl-amb))

(define-public sbcl-anaphora
  (package
    (name "sbcl-anaphora")
    (version "0.9.8")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/tokenrove/anaphora")
             (commit version)))
       (sha256
        (base32 "1ds5ab0rzkrhfl29xpvmvyxmkdyj9mi19p330pz603lx95njjc0b"))
       (file-name (git-file-name "cl-anaphora" version))))
    (build-system asdf-build-system/sbcl)
    (native-inputs
     (list sbcl-rt))
    (synopsis "The anaphoric macro collection from Hell")
    (description
     "Anaphora is the anaphoric macro collection from Hell: it includes many
new fiends in addition to old friends like @command{aif} and
@command{awhen}.")
    (home-page "https://github.com/tokenrove/anaphora")
    (license license:public-domain)))

(define-public cl-anaphora
  (sbcl-package->cl-source-package sbcl-anaphora))

(define-public ecl-anaphora
  (sbcl-package->ecl-package sbcl-anaphora))

(define-public clasp-anaphora
  (sbcl-package->clasp-package sbcl-anaphora))

;;; Split the antik package in two to work around the circular dependency
;;; between antik/antik and antik/gsll.
(define-public sbcl-antik-base
  (let ((commit "e4711a69b3d6bf37b5727af05c3cfd03e8428ba3")
        (revision "1"))
    (package
      (name "sbcl-antik-base")
      (version (git-version "0.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://gitlab.common-lisp.net/antik/antik.git")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "047ga2c38par2xbgg4qx6hwv06qhf1c1f67as8xvir6s80lip1km"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       `(("alexandria" ,sbcl-alexandria)
         ("cffi" ,sbcl-cffi)
         ("cl-ppcre" ,sbcl-cl-ppcre)
         ("drakma" ,sbcl-drakma)
         ("fare-utils" ,sbcl-fare-utils)
         ("iterate" ,sbcl-iterate)
         ("metabang-bind" ,sbcl-metabang-bind)
         ("named-readtables" ,sbcl-named-readtables)
         ("split-sequence" ,sbcl-split-sequence)
         ("static-vectors" ,sbcl-static-vectors)
         ("trivial-garbage" ,sbcl-trivial-garbage)
         ("trivial-utf-8" ,sbcl-trivial-utf-8)))
      (native-inputs
       (list sbcl-lisp-unit))
      (arguments
       '(#:asd-systems '("antik-base"
                         "foreign-array")
         #:phases
         (modify-phases %standard-phases
           (add-after 'unpack 'fix-build
             (lambda _
               (for-each delete-file
                         '("antik.asd"
                           "physical-dimension.asd"
                           "science-data.asd"))
               #t)))))
      (synopsis "Scientific and engineering computation in Common Lisp")
      (description
       "Antik provides a foundation for scientific and engineering
computation in Common Lisp.  It is designed not only to facilitate
numerical computations, but to permit the use of numerical computation
libraries and the interchange of data and procedures, whether
foreign (non-Lisp) or Lisp libraries.  It is named after the
Antikythera mechanism, one of the oldest examples of a scientific
computer known.")
      (home-page "https://common-lisp.net/project/antik/")
      (license license:gpl3))))

(define-public cl-antik-base
  (sbcl-package->cl-source-package sbcl-antik-base))

(define-public ecl-antik-base
  (let ((pkg (sbcl-package->ecl-package sbcl-antik-base)))
    (package
      (inherit pkg)
      (arguments
       (substitute-keyword-arguments (package-arguments pkg)
         ((#:phases phases)
          `(modify-phases ,phases
             (add-after 'unpack 'fix-readtable
               (lambda _
                 (substitute* "input-output/readtable.lisp"
                   (("#-ccl")
                    "#-(or ccl ecl)"))
                 #t)))))))))

(define-public sbcl-antik
  (package
    (inherit sbcl-antik-base)
    (name "sbcl-antik")
    (inputs
     `(("antik-base" ,sbcl-antik-base)
       ("gsll" ,sbcl-gsll)))
    (arguments
     '(#:asd-systems '("antik"
                       "science-data")
       #:phases
         (modify-phases %standard-phases
           (add-after 'unpack 'fix-build
             (lambda _
               (for-each delete-file
                         '("antik-base.asd"
                           "foreign-array.asd"))
               #t)))))))

(define-public cl-antik
  (sbcl-package->cl-source-package sbcl-antik))

(define-public sbcl-anypool
  (let ((commit "5389ec945882e87f2fc1d3e852c91aaf176556e5")
        (revision "1"))
    (package
      (name "sbcl-anypool")
      (version (git-version "0.1.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/fukamachi/anypool")
               (commit commit)))
         (file-name (git-file-name "cl-anypool" version))
         (sha256
          (base32 "1ffssc5fzh7gj0z94xxfb3mk5cwja65lrhxyfgib15a6yxqf1kk1"))))
      (build-system asdf-build-system/sbcl)
      (native-inputs
       (list sbcl-rove))
      (inputs
       (list sbcl-bordeaux-threads
             sbcl-cl-speedy-queue))
      (arguments
       '(#:asd-systems '("anypool"
                         "anypool/middleware")))
      (home-page "https://github.com/fukamachi/anypool")
      (synopsis "General-purpose connection pooling library")
      (description
       "This package provides a general-purpose connection pooling library for
Common Lisp.")
      (license license:bsd-2))))

(define-public cl-anypool
  (sbcl-package->cl-source-package sbcl-anypool))

(define-public ecl-anypool
  (sbcl-package->ecl-package sbcl-anypool))

(define-public sbcl-april
  (let ((commit "bdd74f168ec82f28fe4ab692f2c0af39441a5701")
        (revision "3"))
    (package
      (name "sbcl-april")
      (version (git-version "1.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/phantomics/april")
               (commit commit)))
         (file-name (git-file-name "cl-april" version))
         (sha256
          (base32 "0hvlp2286z1ksa7jr7r661kdr0lpfv25n5chl72jrzq5zz70lidx"))
         (modules '((guix build utils)))
         (snippet '(begin
                     ;; Remove bundled Apache-relicensed MaxPC.
                     (delete-file-recursively "maxpc-apache")
                     ;; Ensure references are to upstream MaxPC.
                     (substitute* "vex/vex.asd"
                       (("maxpc-apache") "maxpc"))))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-alexandria
             sbcl-array-operations
             sbcl-cl-ppcre
             sbcl-cl-unicode
             sbcl-lparallel
             sbcl-maxpc
             sbcl-parse-number
             sbcl-prove
             sbcl-random-state
             sbcl-serapeum
             sbcl-simple-date-time
             sbcl-symbol-munger
             sbcl-trivia))
      (home-page "https://github.com/phantomics/april")
      (synopsis "Array Programming Re-Imagined in Lisp")
      (description
       "April compiles a subset of the APL programming language into
Common Lisp.  Leveraging Lisp's powerful macros and numeric processing
faculties, it brings APL's expressive potential to bear for Lisp developers.
Replace hundreds of lines of number-crunching code with a single line of
APL.")
      (license license:asl2.0))))

(define-public cl-april
  (sbcl-package->cl-source-package sbcl-april))

(define-public ecl-april
  (sbcl-package->ecl-package sbcl-april))

(define-public sbcl-archive
  (let ((commit "631271c091ed02994bec3980cb288a2cf32c7cdc")
        (revision "1"))
    (package
      (name "sbcl-archive")
      (version (git-version "0.9" revision commit))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/sharplispers/archive")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "0pvsc9fmybx7rxd0kmzq4shi6hszdpwdc1sfy7jwyfxf8n3hnv4p"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-cl-fad sbcl-trivial-gray-streams))
      (synopsis "Common Lisp library for tar and cpio archives")
      (description
       "This is a Common Lisp library to read and write disk-based file
archives such as those generated by the tar and cpio programs on Unix.")
      (home-page "https://github.com/sharplispers/archive")
      (license license:bsd-3))))

(define-public cl-archive
  (sbcl-package->cl-source-package sbcl-archive))

(define-public ecl-archive
  (sbcl-package->ecl-package sbcl-archive))

(define-public sbcl-arnesi
  (let ((commit "1e7dc4cb2cad8599113c7492c78f4925e839522e")
        (revision "1"))
    (package
      (name "sbcl-arnesi")
      (version (git-version "2.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/AccelerationNet/arnesi")
               (commit commit)))
         (file-name (git-file-name "arnesi" version))
         (sha256
          (base32 "0jgj2xgd1gq6rf8ia43lkmbrbxnp8rgs053br9azfa25ygk3ikbh"))))
      (build-system asdf-build-system/sbcl)
      (arguments
       ;; FIXME: (Sharlatan-20210523T190315+0100): Tests failed on
       ;; special-lisp-var-rebount-in/cc
       ;;
       ;; ; processing (TEST SPECIAL-LISP-VAR-REBOUND-IN/CC ...)
       ;; ; wrote .../sbcl/arnesi/t/call-cc-tmp5GEXGEG5.fasl
       ;; ; compilation finished in 0:00:00.028
       ;; Unhandled SIMPLE-ERROR in thread
       ;; #<SB-THREAD:THREAD "main thread" RUNNING {100B768173}>:
       ;; Sorry, No walker for the special operater DECLARE defined.
       ;;
       ;; Backtrace for: #<SB-THREAD:THREAD "main thread" RUNNING {100B768173}>
       ;; 0: (SB-DEBUG::DEBUGGER-DISABLED-HOOK #<SIMPLE-ERROR "Sorry,
       ;; No walker for the special operater ~S defined."
       ;; {1001FAF9D3}> #<unused argument> :QUIT T)
       ;;
       `(#:tests? #f))
      (native-inputs
       (list sbcl-fiveam))
      (inputs
       `(("cl-ppcre" ,sbcl-cl-ppcre)
         ("collectors" ,sbcl-collectors)
         ("swank" ,sbcl-slime-swank)))
      (home-page "https://github.com/AccelerationNet/arnesi")
      (synopsis "Common Lisp utility suite")
      (description
       "ARNESI is Common Lisp utilities library similar to ALEXANDRIA, ANAPHORA
or GOLDEN-UTILS.")
      (license license:bsd-3))))

(define-public ecl-arnesi
  (sbcl-package->ecl-package sbcl-arnesi))

(define-public cl-arnesi
  (sbcl-package->cl-source-package sbcl-arnesi))

(define-public sbcl-array-operations
  (let ((commit "75cbc3b1adb2e3ce2109489753d0f290b071e81b")
        (revision "0"))
    (package
      (name "sbcl-array-operations")
      (version (git-version "0.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/bendudson/array-operations")
               (commit commit)))
         (file-name (git-file-name "array-operations" version))
         (sha256
          (base32 "0ip49hhq32w80qsc7jmspyda5r2rsszvw0mk2r3341cld78sz9ya"))))
      (build-system asdf-build-system/sbcl)
      (native-inputs
       (list sbcl-alexandria sbcl-clunit2))
      (inputs
       (list sbcl-let-plus))
      (synopsis "Simple array operations library for Common Lisp")
      (description
       "This library is a collection of functions and macros for manipulating
Common Lisp arrays and performing numerical calculations with them.")
      (home-page "https://github.com/bendudson/array-operations")
      (license license:expat))))

(define-public cl-array-operations
  (sbcl-package->cl-source-package sbcl-array-operations))

(define-public ecl-array-operations
  (sbcl-package->ecl-package sbcl-array-operations))

(define-public sbcl-array-utils
  (let ((commit "16e108a516a1e6662adaa59f05841b8d251c250f")
        (revision "1"))
    (package
      (name "sbcl-array-utils")
      (version (git-version "1.3.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri
          (git-reference
           (url "https://codeberg.org/shinmera/array-utils")
           (commit commit)))
         (file-name (git-file-name "cl-array-utils" version))
         (sha256
          (base32 "0xacdjirb4bkszilmyyg7fzinka71f14z30nz2jwi7a88b8lxk1g"))))
      (build-system asdf-build-system/sbcl)
      (native-inputs
       (list sbcl-parachute))
      (inputs
       (list sbcl-documentation-utils))
      (synopsis "Tiny collection of array and vector utilities for Common Lisp")
      (description
       "A miniature toolkit that contains some useful shifting/popping/pushing
functions for arrays and vectors.  Originally from Plump.")
      (home-page "https://shinmera.com/docs/array-utils")
      (license license:zlib))))

(define-public cl-array-utils
  (sbcl-package->cl-source-package sbcl-array-utils))

(define-public ecl-array-utils
  (sbcl-package->ecl-package sbcl-array-utils))

(define-public clasp-array-utils
  (sbcl-package->clasp-package sbcl-array-utils))

(define-public sbcl-arrow-macros
  ;; The latest upstream version tag is dated (pushed in 2020), use the latest
  ;; commit instead.
  (let ((commit "16bdfd31298182099c7d70df4598104e5a38b05e")
        (revision "0"))
    (package
      (name "sbcl-arrow-macros")
      (version (git-version "0.2.7" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/hipeta/arrow-macros")
               (commit commit)))
         (file-name (git-file-name "arrow-macros" version))
         (sha256
          (base32 "0q4vpysk4h9ghs5zmnzzilky9jyz7i8n0x0p98nq528crbrkh6c4"))))
      (build-system asdf-build-system/sbcl)
      (native-inputs (list sbcl-fiveam))
      (home-page "https://github.com/hipeta/arrow-macros/")
      (synopsis "Clojure-like arrow macros in Common Lisp")
      (description
       "Arrow-macros provides clojure-like arrow macros (ex. ->, ->>) and diamond wands
in swiss-arrows.")
      (license license:expat))))

(define-public cl-arrow-macros
  (sbcl-package->cl-source-package sbcl-arrow-macros))

(define-public ecl-arrow-macros
  (sbcl-package->ecl-package sbcl-arrow-macros))

(define-public sbcl-arrows
  (let ((commit "df7cf0067e0132d9697ac8b1a4f1b9c88d4f5382")
        (revision "0"))
    (package
      (name "sbcl-arrows")
      (version (git-version "0.2.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://gitlab.com/Harleqin/arrows.git")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "042k9vkssrqx9nhp14wdzm942zgdxvp35mba0p2syz98i75im2yy"))))
      (build-system asdf-build-system/sbcl)
      (native-inputs
       (list sbcl-hu.dwim.stefil))
      (synopsis "Clojure-like arrow macros for Common Lisp")
      (description
       "This library implements the @code{->} and @code{->>} macros from
Clojure, as well as several expansions on the idea.")
      (home-page "https://gitlab.com/Harleqin/arrows")
      (license license:public-domain))))

(define-public cl-arrows
  (sbcl-package->cl-source-package sbcl-arrows))

(define-public ecl-arrows
  (sbcl-package->ecl-package sbcl-arrows))

(define-public asdf-cli
  (package
    (name "asdf-cli")
    (version "0.2.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://git.sr.ht/~charje/asdf-cli")
             (commit (string-append "v" version))))
       (file-name (git-file-name "asdf-cli" version))
       (sha256
        (base32 "1x925sl7q7m8c0larysqswlvmzm26fi39cwd45snl1z71rdgkmaw"))))
    (build-system asdf-build-system/sbcl)
    (arguments
     (list
      #:tests? #f ; There are no tests.
      #:asd-systems ''("charje.asdf-cli")
      #:phases
      #~(modify-phases %standard-phases
          (replace 'build
            (lambda _
              (setenv "HOME" (getcwd))
              ;; TEMPLATES is a buildtime option for asdf-cli to show where
              ;; the templates are installed.
              (setenv "TEMPLATES"
                      (string-append
                       #$output
                       "/share/common-lisp/sbcl/asdf-cli/src/templates/"))
              (invoke "./build")))
          (add-after 'build 'install
            (lambda _
              (let ((bin (string-append #$output "/bin")))
                (install-file "asdf" bin)))))))
    (inputs
     (list sbcl-alexandria
           sbcl-charje.loop
           sbcl-cl-annot
           sbcl-cl-fad
           sbcl-cl-semver
           sbcl-cl-str
           sbcl-command-line-args))
    (propagated-inputs
     (list sbcl
           cl-quickproject))
    (home-page "https://git.sr.ht/~charje/asdf-cli")
    (synopsis "Access ASDF from the command line")
    (description
     "Command line interface (CLI) that wraps Common Lisp ASDF (Common Lisp
build system) and Common Lisp quickproject for building and creating new
Common Lisp (ASDF) projects from the command line.")
    (license license:agpl3+)))

(define-public sbcl-asdf-finalizers
  (let ((commit "7f537f6c598b662ae987c6acc268dd27c25977e0")
        (revision "1"))
    (package
      (name "sbcl-asdf-finalizers")
      (version (git-version "0.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://gitlab.common-lisp.net/asdf/asdf-finalizers")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "1w56c9yjjydjshsgqxz57qlp2v3r4ilbisnsgiqphvxnhvd41y0v"))))
      (build-system asdf-build-system/sbcl)
      (native-inputs
       `(("fare-utils" ,sbcl-fare-utils)
         ("hu.dwim.stefil" ,sbcl-hu.dwim.stefil)))
      (home-page "https://gitlab.common-lisp.net/asdf/asdf-finalizers")
      (synopsis "Enforced calling of finalizers for Lisp code")
      (description "This library allows you to implement and enforce proper
finalization of compile-time constructs while building Lisp source files.

It produces two systems: asdf-finalizers and list-of.")
      (license license:expat))))

(define-public cl-asdf-finalizers
  (sbcl-package->cl-source-package sbcl-asdf-finalizers))

(define-public ecl-asdf-finalizers
  (sbcl-package->ecl-package sbcl-asdf-finalizers))

(define-public sbcl-asd-generator
  (let ((commit "27f94971a7c68c4dcb51e3f6be4142743d0c44e8")
        (revision "0"))
    (package
      (name "sbcl-asd-generator")
      (version (git-version "1.0" revision commit))
      (source
        (origin
          (method git-fetch)
          (uri (git-reference
                (url "https://github.com/phoe/asd-generator")
                (commit commit)))
          (sha256
           (base32 "0yiybl7b9x1f85v0drj0yw9821y3yfhya4n6gycnv5vvx6jp9by4"))
          (file-name (git-file-name "cl-asd-generator" commit))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-cl-fad
             sbcl-iterate
             sbcl-alexandria
             sbcl-trivia))
      (home-page "https://github.com/phoe/asd-generator")
      (synopsis "Automatic generator for .asd files")
      (description
       "This package provides an automatic generator for ASDF's .asd files.")
      (license license:gpl3+))))

(define-public cl-asd-generator
  (sbcl-package->cl-source-package sbcl-asd-generator))

(define-public ecl-asd-generator
  (sbcl-package->ecl-package sbcl-asd-generator))

(define-public sbcl-asdf-system-connections
  (let ((commit "9f085240febccccff99d9d3bb687fcaafffd3f5e")
        (revision "1"))
    (package
      (name "sbcl-asdf-system-connections")
      (version (git-version "0.8.4" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/gwkkwg/asdf-system-connections")
               (commit commit)))
         (file-name (git-file-name "cl-asdf-system-connections" version))
         (sha256
          (base32 "06kg0m8bv383qq3r34x0f8hz6p6zxcw02qn7kj960vcnrp5a5b3y"))))
      (build-system asdf-build-system/sbcl)
      (home-page "https://github.com/gwkkwg/asdf-system-connections")
      (synopsis "Common Lisp ASDF system auto-loading extension")
      (description
       "This package provides a Common Lisp ASDF system auto-loading
extension.")
      (license license:expat))))

(define-public cl-asdf-system-connections
  (sbcl-package->cl-source-package sbcl-asdf-system-connections))

(define-public ecl-asdf-system-connections
  (sbcl-package->ecl-package sbcl-asdf-system-connections))

(define-public sbcl-aserve
  ;; There does not seem to be proper releases.
  (let ((commit "cac1d6920998ddcbee8310a873414732e707d8e5")
        (revision "2"))
    (package
      (name "sbcl-aserve")
      (version (git-version "1.2.50" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               ;; https://github.com/franzinc/aserve/ seems to be incompatible
               ;; with SBCL, etc.
               (url "git://git.code.sf.net/p/portableaserve/git")
               (commit commit)))
         (file-name (git-file-name "aserve" version))
         (sha256
          (base32 "0ak6mqp84sjr0a7h5svr16vra4bf4fcx6wpir0n88dc1vjwy5xqa"))
         (patches (search-patches
                   ;; Add HTML5 elements to htmlgen.
                   ;; Adapted from https://github.com/franzinc/aserve/ commits:
                   ;; * e47bd763: "rfe12668: add HTML 5 elements to htmlgen"
                   ;; * 7371ce59: "fix bugs in rfe12668 implementation"
                   "sbcl-aserve-add-HTML-5-elements.patch"
                   "sbcl-aserve-fix-rfe12668.patch"))))
      (build-system asdf-build-system/sbcl)
      (arguments
       `(#:phases
         (modify-phases %standard-phases
           (add-after 'unpack 'cd-aserve
             (lambda _
               (chdir "aserve")
               #t))
           (add-after 'cd-aserve 'fix-asd
             (lambda _
               (substitute* "aserve.asd"
                 ((" :force t") ""))
               #t))
           (add-after 'cd-aserve 'fix-tests
             (lambda _
               (substitute* "test/t-aserve.cl"
                 (("\\(asdf:oos 'asdf:load-op :ptester\\)") ""))
               #t)))))
      (inputs
       `(("acl-compat" ,sbcl-acl-compat)))
      (home-page
       "https://franz.com/support/documentation/current/doc/aserve/aserve.html")
      (synopsis "AllegroServe, a web server written in Common Lisp")
      (description
       "The server part of AllegroServe can be used either as a standalone web
server or a module loaded into an application to provide a user interface to
the application.  AllegroServe's proxy ability allows it to run on the gateway
machine between some internal network and the Internet.  AllegroServe's client
functions allow Lisp programs to explore the web.")
      (license license:llgpl))))

(define-public cl-aserve
  (sbcl-package->cl-source-package sbcl-aserve))

(define-public sbcl-asn1
  (let ((commit "b0388fa98878b20069ef266cc9cbd5aac13c4a69")
        (revision "0"))
    (package
      (name "sbcl-asn1")
      (build-system asdf-build-system/sbcl)
      (version (git-version "0.1.0" revision commit))
      (home-page "https://github.com/fukamachi/asn1")
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url home-page)
               (commit commit)))
         (file-name (git-file-name "cl-asn1" version))
         (sha256
          (base32 "16gs4xznmg19ii0cg7g2yxrk9ls5vah8ynjj80s99rv8wi3789z1"))))
      (native-inputs (list sbcl-cl-base64 sbcl-rove))
      (inputs
        (list sbcl-trivia
              sbcl-fast-io
              sbcl-ironclad))
      (synopsis "ASN.1 decoder for Common Lisp")
      (description "This package provides an ASN.1 encoder/decoder for
Common Lisp.")
      (license license:bsd-2))))

(define-public cl-asn1
  (sbcl-package->cl-source-package sbcl-asn1))

(define-public ecl-asn1
  (sbcl-package->ecl-package sbcl-asn1))

(define-public sbcl-assoc-utils
  (let ((commit "74af16a3c0f10ad35e406167de02984744fc7854")
        (revision "1"))
    (package
      (name "sbcl-assoc-utils")
      (version (git-version "0.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/fukamachi/assoc-utils")
               (commit commit)))
         (file-name (git-file-name "cl-assoc-utils" version))
         (sha256
          (base32 "1yac1v7zmdxj0p6rvwrrhyqvy7yjfhmqbchkwqhhr89gpjvvaick"))))
      (build-system asdf-build-system/sbcl)
      (arguments
       '(#:asd-systems '("assoc-utils-test" "assoc-utils")))
      (native-inputs
       (list sbcl-prove))
      (home-page "https://github.com/fukamachi/assoc-utils")
      (synopsis "Utilities for manipulating association lists in Common Lisp")
      (description
       "@code{assoc-utils} provides utilities for manipulating association
lists in Common Lisp.")
      (license license:public-domain))))

(define-public cl-assoc-utils
  (sbcl-package->cl-source-package sbcl-assoc-utils))

(define-public ecl-assoc-utils
  (sbcl-package->ecl-package sbcl-assoc-utils))

(define-public sbcl-atomichron
  (let ((commit "5b3578bbad8c37ab559e56924d98c373efe11de5")
        (revision "0"))
    (package
      (name "sbcl-atomichron")
      (version (git-version "0.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/no-defun-allowed/atomichron")
               (commit commit)))
         (file-name (git-file-name "cl-atomichron" version))
         (sha256
          (base32 "1fmmhb3pbv7j4d1cc02zv24bpd0kd2agfjjcj46w3gmv1bb0hva1"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-atomics sbcl-bordeaux-threads))
      (home-page "https://github.com/no-defun-allowed/atomichron")
      (synopsis "Atomic metering library for Common Lisp")
      (description
       "@code{atomichron} is a Common Lisp library which implements a time
meter which tracks how many times a form is evaluated, and how long evaluation
takes.  It uses atomic instructions so that meters will present correct
results in the presence of multiple threads, while trying to minimize
synchronization latency.")
      (license license:bsd-2))))

(define-public cl-atomichron
  (sbcl-package->cl-source-package sbcl-atomichron))

(define-public ecl-atomichron
  (sbcl-package->ecl-package sbcl-atomichron))

(define-public sbcl-atomics
  ;; No release in years.
  (let ((commit "5b36bf251fee2f80e34cbf6802c9eb08ce3675f6")
        (revision "3"))
    (package
      (name "sbcl-atomics")
      (version (git-version "1.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://codeberg.org/shinmera/atomics")
               (commit commit)))
         (file-name (git-file-name "cl-atomics" version))
         (sha256
          (base32 "0lmrqn2yzrs1qxd0asjpwk50hdcp2hkkbcpzc4lkm3xbxnwxrwg2"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-documentation-utils))
      (native-inputs
       (list sbcl-parachute))
      (home-page "https://shinmera.com/docs/atomics")
      (synopsis "Common Lisp portability layer for atomic operations")
      (description
       "This is a library for access to atomic operation primitives such as
compare-and-swap.  It aims to be a rather thin layer over what the
implementations offer.")
      (license license:zlib))))

(define-public cl-atomics
  (sbcl-package->cl-source-package sbcl-atomics))

(define-public ecl-atomics
  (sbcl-package->ecl-package sbcl-atomics))

(define-public clasp-atomics
  (sbcl-package->clasp-package sbcl-atomics))

(define-public sbcl-authentic
  (let ((commit "4e9194dda227b98f56dda1c2a2480efcc2d1f973")
        (revision "2"))
    (package
      (name "sbcl-authentic")
      (version (git-version "0.1.2" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/charje/cl-authentic")
               (commit commit)))
         (file-name (git-file-name "cl-authentic" version))
         (sha256
          (base32 "0ncsxrybnx0pjsndv3j8w4lphlpcsld8sxg3c5b46fb3a8nd4ssf"))))
      (build-system asdf-build-system/sbcl)
      (native-inputs
       (list sbcl-fiveam))
      (inputs
       (list sbcl-clsql sbcl-ironclad))
      (home-page "https://github.com/charje/cl-authentic")
      (synopsis "User/password management for Common Lisp applications")
      (description "Authentic provides a light-weight and extendible
solution to user/password management for Common Lisp applications.  It has
features such as safe password storage in a database, password reset, user
confirmation tokens, and user authentication.")
      (license license:llgpl))))

(define-public ecl-authentic
  (sbcl-package->ecl-package sbcl-authentic))

(define-public cl-authentic
  (sbcl-package->cl-source-package sbcl-authentic))

(define-public sbcl-babel
  ;; No release since 2014.
  (let ((commit "627d6a60d0ffc82a3687b39ba8a99128031504d9")
        (revision "3"))
    (package
      (name "sbcl-babel")
      (version (git-version "0.5.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/cl-babel/babel")
               (commit commit)))
         (file-name (git-file-name "cl-babel" version))
         (sha256
          (base32 "1sndap9ykyyvrzlqm9smgqy49r3n67l926yg0hb7pm00plj0y380"))))
      (build-system asdf-build-system/sbcl)
      (native-inputs
       (list sbcl-hu.dwim.stefil))
      (inputs
       (list sbcl-alexandria sbcl-trivial-features))
      (home-page "https://common-lisp.net/project/babel/")
      (synopsis "Charset encoding and decoding library")
      (description "Babel is a charset encoding and decoding library, not unlike
GNU libiconv, but completely written in Common Lisp.")
      (license (list license:bsd-2 license:expat)))))

(define-public cl-babel
  (sbcl-package->cl-source-package sbcl-babel))

(define-public ecl-babel
  (sbcl-package->ecl-package sbcl-babel))

(define-public clasp-babel
  (sbcl-package->clasp-package sbcl-babel))

(define-public sbcl-binary-types
  (let ((commit "a17caf8890f11fdc56f6ea3a21260bf0fb9c589c"))
    (package
      (name "sbcl-binary-types")
      (version (git-version "1.2" "2" commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/Ferada/binary-types/")
               (commit commit)))
         (file-name (git-file-name "binary-types" version))
         (sha256
          (base32 "1bh65p9vg2kgh4m8q1a4jiyncnp5prdzh0d0l4pzh3jvfhgbm0gh"))))
      (build-system asdf-build-system/sbcl)
      (home-page "https://github.com/Ferada/binary-types/")
      (synopsis "Read and write binary records for Common Lisp")
      (description
       "Binary-types is a Common Lisp package for reading and writing binary
files.  Binary-types provides macros that are used to declare the mapping
between Lisp objects and some binary (i.e. octet-based) representation.")
      (license license:bsd-3))))

(define-public cl-binary-types
  (sbcl-package->cl-source-package sbcl-binary-types))

(define-public ecl-binary-types
  (sbcl-package->ecl-package sbcl-binary-types))

(define-public sbcl-binascii
  (let ((commit "0fb0a9e5773148fd04d50efef08c1cc10f6fc487")
        (revision "1"))
    (package
      (name "sbcl-binascii")
      (version (git-version "1.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/sharplispers/binascii")
               (commit commit)))
         (file-name (git-file-name "cl-binascii" version))
         (sha256
          (base32 "000rcdl8qshr7n48zq9bzrc4lkjx4ylb3r3w9x9syhiwfla9j4b7"))
         (modules '((guix build utils)))
         (snippet
          ;; Unbundle the RT test framework.
          '(begin
             (delete-file "tests/rt.lisp")
             (substitute* "binascii.asd"
               ((":depends-on \\(binascii\\)")
                ":depends-on (binascii rt)")
               (("\\(:file \"rt\"\\)")
                "")
               (("\\(:file \"tests\" :depends-on \\(\"rt\"\\)\\)")
                "(:file \"tests\")"))))))
      (build-system asdf-build-system/sbcl)
      (native-inputs
       (list sbcl-rt))
      (home-page "https://github.com/sharplispers/binascii")
      (synopsis "Common Lisp library of ASCII encoding schemes for binary data")
      (description
       "@code{binascii} is a Common Lisp library for converting binary data
to ASCII text of some kind.  Such conversions are common in email protocols
(for encoding attachments to support old non-8-bit clean transports) or
encoding binary data in HTTP and XML applications.  @code{binascii} supports
the encodings described in RFC 4648: base64, base32, base16, and variants.
It also supports base85, used in Adobe's PostScript and PDF document formats,
and a variant called ascii85, used by git for binary diff files.")
      (license license:bsd-3))))

(define-public cl-binascii
  (sbcl-package->cl-source-package sbcl-binascii))

(define-public clasp-binascii
  (sbcl-package->clasp-package sbcl-binascii))

(define-public sbcl-binding-arrows
  ;; Fork of sbcl-arrows that does not have a new tag.
  (let ((commit "46bcba8bb1ff27cd5caab3bda36f000d0489a4f2")
        (revision "2"))
    (package
     (name "sbcl-binding-arrows")
     (version (git-version "1.0.0" revision commit))
     (source
      (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/phoe/binding-arrows")
             (commit commit)))
       (file-name (git-file-name "cl-binding-arrows" version))
       (sha256
        (base32 "0kzybw5qlb49czh9v2lnxniz9jzqx306a6lnarfv59x48a7cch22"))))
     (build-system asdf-build-system/sbcl)
     (native-inputs
      (list sbcl-hu.dwim.stefil))
     (home-page "https://github.com/phoe/binding-arrows")
     (synopsis "Threading macros based on binding anonymous variables")
     (description
      "This system implements binding threading macros -- a kind of threading
macros with different semantics than classical, Clojure core threading macros
or their extension, swiss-arrows.  Two Common Lisp implementations of those are
@code{arrows} and @code{arrow-macros}.

This system is a fork of @code{arrows} with changes in semantics that make it
impossible to merge back upstream.")
     (license license:expat))))

(define-public ecl-binding-arrows
  (sbcl-package->ecl-package sbcl-binding-arrows))

(define-public clasp-binding-arrows
  (sbcl-package->clasp-package sbcl-binding-arrows))

(define-public cl-binding-arrows
  (sbcl-package->cl-source-package sbcl-binding-arrows))

(define-public sbcl-binpack
  (let ((commit "e67f56bb697bdeac81e28e1cca4a5d117a9cf125")
        (revision "1"))
    (package
     (name "sbcl-binpack")
     (version (git-version "0.0.1" revision commit))
     (source
      (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/lispgames/binpack")
             (commit commit)))
       (file-name (git-file-name "binpack" version))
       (sha256
        (base32 "1pcnsg60pqywd3k72m5pwimq01sm3jyvc1c3rbkij740r7grdxi1"))))
     (build-system asdf-build-system/sbcl)
     (native-inputs
      (list sbcl-parachute))
     (inputs
      (list sbcl-alexandria))
     (home-page "https://github.com/lispgames/binpack")
     (synopsis "Common Lisp rectangle packer for sprite/texture atlases")
     (description
      "This library features a rectangle packer for sprite and texture atlases.")
     (license license:expat))))

(define-public cl-binpack
  (sbcl-package->cl-source-package sbcl-binpack))

(define-public ecl-binpack
  (sbcl-package->ecl-package sbcl-binpack))

(define-public clasp-binpack
  (sbcl-package->clasp-package sbcl-binpack))

(define-public sbcl-birch
  (let ((commit "30cd24260675c6c4e276daaf28be8d02ac15dd8f")
        (revision "0"))
    (package
      (name "sbcl-birch")
      (version (git-version "1.0.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/jorams/birch")
               (commit commit)))
         (file-name (git-file-name "cl-birch" version))
         (sha256
          (base32 "1b24xng92ra7420s3zy44pybk4h7xg4kjwdk35arl46badgi28r1"))))
      (build-system asdf-build-system/sbcl)
      (inputs (list sbcl-alexandria
                    sbcl-cl+ssl
                    sbcl-flexi-streams
                    sbcl-split-sequence
                    sbcl-usocket))
      (native-inputs (list sbcl-prove))
      (home-page "https://github.com/jorams/birch")
      (synopsis "Common Lisp IRC client library")
      (description "Birch is a simple Common Lisp IRC client library.  It
makes use of CLOS for event handling.")
      (license (list license:expat)))))

(define-public cl-birch
  (sbcl-package->cl-source-package sbcl-birch))

(define-public ecl-birch
  (sbcl-package->ecl-package sbcl-birch))

(define-public sbcl-bit-smasher
  ;; No release.
  (let ((commit "c2dcb3b5ec0e485484be681fe17c4e81e58790d9"))
    (package
      (name "sbcl-bit-smasher")
      (version (git-version "1.0.2" "1" commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/thephoeron/bit-smasher/")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "0wjmwn06fjpw0rlpaksf3ab727p8fnzj58z7jajl3m0wqd4ii74w"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       `(("cl-base64" ,sbcl-cl-base64)
         ("cl-base58" ,sbcl-cl-base58)))
      (home-page "https://github.com/thephoeron/bit-smasher/")
      (synopsis "Handle bit vectors, bit vector arithmetic, and type conversions")
      (description
       "Utility library for handling bit vectors, bit vector arithmetic, and
universal integer type conversions between bit-vectors, byte-vectors, octals,
decimals, and hexadecimal notation.")
      (license license:expat))))

(define-public cl-bit-smasher
  (sbcl-package->cl-source-package sbcl-bit-smasher))

(define-public ecl-bit-smasher
  (sbcl-package->ecl-package sbcl-bit-smasher))

(define-public sbcl-bknr-datastore
  (let ((commit "c98d44f47cc88d19ff91ca3eefbd9719a8ace022")
        (revision "1"))
    (package
      (name "sbcl-bknr-datastore")
      (version (git-version "0.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/hanshuebner/bknr-datastore")
               (commit commit)))
         (file-name (git-file-name "bknr-datastore" version))
         (sha256
          (base32 "1vi3w65fnczqvswkm381n6liqfrzjrg40y698qvj7skj28dm5vrm"))))
      (build-system asdf-build-system/sbcl)
      (arguments
       `(#:asd-systems
         '("bknr.datastore"
           "bknr.impex"
           "bknr.indices"
           "bknr.skip-list"
           "bknr.utils"
           "bknr.xml")
         #:phases
         (modify-phases %standard-phases
           (add-after 'unpack 'enter-source-directory
             (lambda _
               (chdir "src")
               #t)))))
      (native-inputs
       `(("cl-store" ,sbcl-cl-store)
         ("fiveam" ,sbcl-fiveam)
         ("unit-test" ,sbcl-unit-test)))
      (inputs
       `(("alexandria" ,sbcl-alexandria)
         ("bordeaux-threads" ,sbcl-bordeaux-threads)
         ("closer-mop" ,sbcl-closer-mop)
         ("cl-interpol" ,sbcl-cl-interpol)
         ("cl-ppcre" ,sbcl-cl-ppcre)
         ("cxml" ,sbcl-cxml)
         ("flexi-streams" ,sbcl-flexi-streams)
         ("md5" ,sbcl-md5)
         ("trivial-utf-8" ,sbcl-trivial-utf-8)
         ("yason" ,sbcl-yason)))
      (home-page "https://github.com/hanshuebner/bknr-datastore")
      (synopsis "In-memory database for Common Lisp")
      (description
       "BKNR.DATASTORE is an in-memory CLOS based database with transactions
for Common Lisp.")
      (license license:bsd-0))))

(define-public cl-bknr-datastore
  (sbcl-package->cl-source-package sbcl-bknr-datastore))

;; NOTE: (Sharlatan-20210429T191426+0100):
;; There is no port for ECL in upstream yet
;; (define-public ecl-bknr-datastore
;;   (sbcl-package->ecl-package sbcl-bknr-datastore))

(define-public sbcl-black-tie
  (let ((commit "26381ca1b1d6846cfa2ad662da37302d30e24a97")
        (revision "0"))
    (package
      (name "sbcl-black-tie")
      (version (git-version "0.2" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://codeberg.org/aerique/black-tie")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "0a1zczxp4wkqs4cmwc4rnsgwwc2h4zqmg58cjykfzz4jh31fa43a"))))
      (build-system asdf-build-system/sbcl)
      (home-page "https://codeberg.org/aerique/black-tie")
      (synopsis "Noise library for Common Lisp")
      (description "This package provides a noise library for Common Lisp.")
      (license license:bsd-3))))

(define-public ecl-black-tie
  (sbcl-package->ecl-package sbcl-black-tie))

(define-public cl-black-tie
  (sbcl-package->cl-source-package sbcl-black-tie))

(define-public clasp-black-tie
  (sbcl-package->clasp-package sbcl-black-tie))

(define-public sbcl-blackbird
  (let ((commit "d361f81c1411dec07f6c2dcb11c78f7aea9aaca8")
        (revision "1"))
    (package
      (name "sbcl-blackbird")
      (version (git-version "0.5.2" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/orthecreedence/blackbird")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "0xfds5yaya64arzr7w1x38karyz11swzbhxx1afldpradj9dh19c"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-vom))
      (native-inputs
       (list sbcl-cl-async sbcl-fiveam))
      (synopsis "Promise implementation for Common Lisp")
      (description
       "This is a standalone promise implementation for Common Lisp.  It is
the successor to the now-deprecated cl-async-future project.")
      (home-page "https://orthecreedence.github.io/blackbird/")
      (license license:expat))))

(define-public cl-blackbird
  (sbcl-package->cl-source-package sbcl-blackbird))

(define-public ecl-blackbird
  (sbcl-package->ecl-package sbcl-blackbird))

(define-public sbcl-bobbin
  (let ((commit "b454e8241b24ceab674eeeae464c8082b1b6d8ce")
        (revision "0"))
    (package
      (name "sbcl-bobbin")
      (version (git-version "1.0.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/sjl/bobbin")
               (commit commit)))
         (file-name (git-file-name "cl-bobbin" version))
         (sha256
          (base32 "02lw7w8cbvnxw5acbz405rb5lcqsf4fx7dvj5ldr0lhgbyv1mjnm"))))
      (build-system asdf-build-system/sbcl)
      (native-inputs
       (list sbcl-1am))
      (inputs
       (list sbcl-split-sequence))
      (home-page "https://docs.stevelosh.com/bobbin/")
      (synopsis "Simple (word) wrapping utilities for strings")
      (description
       "Bobbin is a simple word-wrapping library for strings in Common Lisp.
It aims to be simple, work nicely for the majority of cases, and degrade
gracefully for edge cases.  It is not particularly concerned with speed — if
you need very high-performance word wrapping, Bobbin is not for you.")
      (license license:expat))))

(define-public cl-bobbin
  (sbcl-package->cl-source-package sbcl-bobbin))

(define-public ecl-bobbin
  (sbcl-package->ecl-package sbcl-bobbin))

(define-public sbcl-bodge-blobs-support
  (let ((commit "c5034ca5f4fc3a44dbadeba215a09afd59a404b0")
        (revision "1"))
    (package
     (name "sbcl-bodge-blobs-support")
     (version (git-version "1.0.0" revision commit))
     (source
      (origin
        (method git-fetch)
        (uri (git-reference
              (url "https://github.com/borodust/bodge-blobs-support")
              (commit commit)))
        (file-name (git-file-name "bodge-blobs-support" version))
        (sha256
         (base32 "02nd1x6y1akp1ymv1y4z9ympwbnpd1drwi4f86xbjszxqff6jyj8"))))
     (build-system asdf-build-system/sbcl)
     (native-inputs
      (list sbcl-trivial-features))
     (inputs
      (list sbcl-cffi sbcl-alexandria))
     (home-page "https://github.com/borodust/bodge-blobs-support")
     (synopsis "Common Lisp utilities for blob packages")
     (description
      "This is a Common Lisp library for simplifying packaging and loading of
compiled foreign library collection.")
     (license license:unlicense))))

(define-public cl-bodge-blobs-support
  (sbcl-package->cl-source-package sbcl-bodge-blobs-support))

(define-public ecl-bodge-blobs-support
  (sbcl-package->ecl-package sbcl-bodge-blobs-support))

(define-public sbcl-bodge-math
  (let ((commit "9159b7faf88d440024c07110dbef2abddb20b9af")
        (revision "1"))
    (package
     (name "sbcl-bodge-math")
     (version (git-version "1.0.0" revision commit))
     (source
      (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/borodust/bodge-math")
             (commit commit)))
       (file-name (git-file-name "bodge-math" version))
       (sha256
        (base32 "0r3vnl9lywn4ksy34apcv6j825qp7l1naddawr14v4lwacndb80v"))))
     (build-system asdf-build-system/sbcl)
     (inputs
      (list sbcl-bodge-utilities sbcl-rtg-math))
     (home-page "https://github.com/borodust/bodge-math")
     (synopsis "Common Lisp core math utilities of BODGE library collection")
     (description
      "This Common Lisp package contains the core math utilities of the
@emph{Bodge} library collection.")
     (license license:expat))))

(define-public ecl-bodge-math
  (sbcl-package->ecl-package sbcl-bodge-math))

(define-public cl-bodge-math
  (sbcl-package->cl-source-package sbcl-bodge-math))

(define-public sbcl-bodge-queue
  (let ((commit "948c9a501dcd412689952d09eb7453ec2722336a")
        (revision "0"))
    (package
      (name "sbcl-bodge-queue")
      (version (git-version "0.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/borodust/bodge-queue")
               (commit commit)))
         (file-name (git-file-name "bodge-queue" version))
         (sha256
          (base32 "148hjikqk8v2m30mj15xh89zni6szf9z3prav580qk9dqr8djjdr"))))
      (build-system asdf-build-system/sbcl)
      (native-inputs
       (list sbcl-fiveam))
      (home-page "https://github.com/borodust/bodge-queue")
      (synopsis "Simple queue for Common Lisp")
      (description "This Common Lisp library provides a simple FIFO
implementation with no external dependencies.")
      (license license:expat))))

(define-public cl-bodge-queue
  (sbcl-package->cl-source-package sbcl-bodge-queue))

(define-public ecl-bodge-queue
  (sbcl-package->ecl-package sbcl-bodge-queue))

(define-public sbcl-bodge-utilities
  (let ((commit "6304bac4abe06d53579e2c0fc4437d14ff077d9f")
        (revision "1"))
    (package
     (name "sbcl-bodge-utilities")
     (version (git-version "1.0.0" revision commit))
     (source
      (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/borodust/bodge-utilities")
             (commit commit)))
       (file-name (git-file-name "bodge-utilities" version))
       (sha256
        (base32 "1z1blj05q71vzh323qwyn9p3xs7v0mq2yhwfyzza5libp37wqm3c"))))
     (build-system asdf-build-system/sbcl)
     (inputs
      (list sbcl-alexandria
            sbcl-cffi
            sbcl-claw
            sbcl-dissect
            sbcl-local-time
            sbcl-log4cl
            sbcl-split-sequence
            sbcl-static-vectors
            sbcl-trivial-gray-streams))
     (home-page "https://github.com/borodust/bodge-utilities")
     (synopsis "Common Lisp utilities library for CL-BODGE")
     (description
      "This Common Lisp library provides utilities for the @emph{Bodge} library
collection.")
     (license license:expat))))

(define-public cl-bodge-utilities
  (sbcl-package->cl-source-package sbcl-bodge-utilities))

(define-public ecl-bodge-utilities
  (sbcl-package->ecl-package sbcl-bodge-utilities))

(define-public sbcl-boost-json
  (let ((commit "eca166f5ff1f10bad14e00b9fd5bf9fcf3691a47")
        (revision "0"))
    (package
      (name "sbcl-boost-json")
      (version (git-version "1.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/cl-boost/json")
               (commit commit)))
         (file-name (git-file-name "cl-boost-json" version))
         (sha256
          (base32 "12k0470899qsll2qixksxf2vrhjmskk3nzp1di9k04n1b29nrakd"))))
      (build-system asdf-build-system/sbcl)
      (arguments
       '(#:phases
         (modify-phases %standard-phases
           ;; See <https://github.com/cl-boost/json/pull/2>.
           (add-after 'unpack 'fix-decode-symbol
             (lambda _
               (substitute* '("decode.lisp" "encode.lisp")
                 (("formfeed") "page")))))))
      (home-page "https://github.com/cl-boost/json")
      (synopsis "JSON encoding and decoding for Common Lisp")
      (description
       "BOOST-JSON is a simple JSON parsing library for Common Lisp.")
      (license license:asl2.0))))

(define-public cl-boost-json
  (sbcl-package->cl-source-package sbcl-boost-json))

(define-public ecl-boost-json
 (sbcl-package->ecl-package sbcl-boost-json))

(define-public sbcl-boost-lexer
  (let ((commit "139ca9e9580f890698deec05061e495376b7735a")
        (revision "0"))
    (package
      (name "sbcl-boost-lexer")
      (version (git-version "1.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/cl-boost/lexer")
               (commit commit)))
         (file-name (git-file-name "cl-boost-lexer" version))
         (sha256
          (base32 "01vsczb5cn62k2hkkn39xwh5fjn2x0b507n7afia98jnhhk3d5x4"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-boost-re))
      (home-page "https://github.com/cl-boost/lexer")
      (synopsis "String tokenizing for Common Lisp")
      (description
       "BOOST-LEXER is a tokenizer for Common Lisp that makes heavy use of
BOOST-RE.")
      (license license:asl2.0))))

(define-public cl-boost-lexer
  (sbcl-package->cl-source-package sbcl-boost-lexer))

(define-public ecl-boost-lexer
  (sbcl-package->ecl-package sbcl-boost-lexer))

(define-public sbcl-boost-parse
  (let ((commit "c8f7e536b950752f3e35003e7ee0446e0fd51b50")
        (revision "0"))
    (package
      (name "sbcl-boost-parse")
      (version (git-version "1.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/cl-boost/parse")
               (commit commit)))
         (file-name (git-file-name "cl-boost-parse" version))
         (sha256
          (base32 "0djnp392n9wgpr9r2ycnwkglad5mn285yvr53jx3g7anm2p8r0vf"))))
      (build-system asdf-build-system/sbcl)
      (home-page "https://github.com/cl-boost/parse")
      (synopsis "Monadic parsing for Common Lisp")
      (description
       "BOOST-PARSE is a simple token parsing library for Common Lisp.")
      (license license:asl2.0))))

(define-public cl-boost-parse
  (sbcl-package->cl-source-package sbcl-boost-parse))

(define-public ecl-boost-parse
  (sbcl-package->ecl-package sbcl-boost-parse))

(define-public sbcl-boost-re
  (let ((commit "d279fc58abf76d0c40aa6cde42e17a0591bc2c5d")
        (revision "0"))
    (package
      (name "sbcl-boost-re")
      (version (git-version "1.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/cl-boost/re")
               (commit commit)))
         (file-name (git-file-name "cl-boost-re" version))
         (sha256
          (base32 "1h9c2rdhw6m1pm67gqbj46y2vb1kc3i1c9y3l4qhgfz14dbk80a2"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-boost-parse))
      (home-page "https://github.com/cl-boost/re")
      (synopsis "Lua-style string pattern matching for Common Lisp")
      (description
       "BOOST-RE is a small, portable, lightweight, and quick, regular
expression library for Common Lisp.  It is a non-recursive, backtracking VM.")
      (license license:asl2.0))))

(define-public cl-boost-re
  (sbcl-package->cl-source-package sbcl-boost-re))

(define-public ecl-boost-re
  (sbcl-package->ecl-package sbcl-boost-re))

(define-public sbcl-bordeaux-fft
  (let ((commit "4a1f5600cae59bdabcb32de4ee2d7d73a9450d6e")
        (revision "0"))
    (package
      (name "sbcl-bordeaux-fft")
      (version (git-version "1.0.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/ahefner/bordeaux-fft")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "0j584w6kq2k6r8lp2i14f9605rxhp3r15s33xs08iz1pndn6iwqf"))))
      (build-system asdf-build-system/sbcl)
      (home-page "http://vintage-digital.com/hefner/software/bordeaux-fft/")
      (synopsis "Fast Fourier Transform for Common Lisp")
      (description
       "The Bordeaux-FFT library provides a reasonably efficient implementation
of the Fast Fourier Transform and its inverse for complex-valued inputs, in
portable Common Lisp.")
      (license license:gpl2+))))

(define-public cl-bordeaux-fft
  (sbcl-package->cl-source-package sbcl-bordeaux-fft))

(define-public ecl-bordeaux-fft
  (sbcl-package->ecl-package sbcl-bordeaux-fft))

(define-public sbcl-bordeaux-threads
  (package
    (name "sbcl-bordeaux-threads")
    (version "0.9.3")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/sionescu/bordeaux-threads")
                    (commit (string-append "v" version))))
              (sha256
               (base32 "0pp3w5hsph47sqagr4j2pbg3ddb29jx93zg8kvxsp2c4flp0qz0f"))
              (file-name (git-file-name "cl-bordeaux-threads" version))))
    (inputs (list sbcl-alexandria
                  sbcl-global-vars
                  sbcl-trivial-features
                  sbcl-trivial-garbage))
    (native-inputs (list sbcl-fiveam))
    (build-system asdf-build-system/sbcl)
    (arguments
     (list
       #:phases
       #~(modify-phases %standard-phases
           (add-after 'unpack 'adjust-test-sleep
             (lambda _
               ;; 0.001 is too short for some slower machines.
               (substitute* '("test/tests-v1.lisp"
                              "test/tests-v2.lisp")
                 (("sleep 0\\.001") "sleep 0.002")))))))
    (synopsis "Portable shared-state concurrency library for Common Lisp")
    (description "BORDEAUX-THREADS is a proposed standard for a minimal
MP/Threading interface.  It is similar to the CLIM-SYS threading and lock
support.")
    (home-page "https://common-lisp.net/project/bordeaux-threads/")
    (license license:x11)))

(define-public cl-bordeaux-threads
  (sbcl-package->cl-source-package sbcl-bordeaux-threads))

(define-public ecl-bordeaux-threads
  (sbcl-package->ecl-package sbcl-bordeaux-threads))

(define-public sbcl-bst
  (let ((commit "8545aed0d504df2829ad139566feeabe22305388")
        (revision "0"))
    (package
      (name "sbcl-bst")
      (version (git-version "2.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://codeberg.org/glv/bst")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "18ig7rvxcra69437g0i8sxyv7c5dg26jqnx1rc2f9pxmihdprgk8"))))
      (build-system asdf-build-system/sbcl)
      (native-inputs
       (list sbcl-alexandria sbcl-fiveam))
      (synopsis "Binary search tree for Common Lisp")
      (description
       "BST is a Common Lisp library for working with binary search trees that
can contain any kind of values.")
      (home-page "https://codeberg.org/glv/bst")
      (license license:gpl3))))

(define-public cl-bst
  (sbcl-package->cl-source-package sbcl-bst))

(define-public ecl-bst
  (sbcl-package->ecl-package sbcl-bst))

(define-public sbcl-bt-semaphore
  (let ((commit "46b4bf315590f510d2d4ec5ca8908efbe68007e9")
        (revision "0"))
    (package
      (name "sbcl-bt-semaphore")
      (version (git-version "0.6.3" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/r-moeritz/bt-semaphore")
               (commit commit)))
         (sha256
          (base32 "0rl7yp36225z975hg069pywwlpchwn4086cgxwsi2db5mhghpr7l"))
         (file-name (git-file-name "cl-bt-semaphore" version))))
      (build-system asdf-build-system/sbcl)
      (inputs (list sbcl-bordeaux-threads))
      (native-inputs (list sbcl-clunit))
      (synopsis "Semaphore implementation for @code{bordeaux-threads}")
      (description
       "@code{bt-semaphore} is a semaphore implementation for use with
@code{bordeaux-threads}.")
      (home-page "https://github.com/r-moeritz/bt-semaphore")
      (license license:expat))))

(define-public cl-bt-semaphore
  (sbcl-package->cl-source-package sbcl-bt-semaphore))

(define-public ecl-bt-semaphore
  (sbcl-package->ecl-package sbcl-bt-semaphore))

(define-public sbcl-bubble-operator-upwards
  (let ((commit "846275a318b960de81b62caecb1e31930f70aef6")
        (revision "0"))
    (package
      (name "sbcl-bubble-operator-upwards")
      (version (git-version "1.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/Hexstream/bubble-operator-upwards")
               (commit commit)))
         (file-name (git-file-name "cl-bubble-operator-upwards" version))
         (sha256
          (base32 "0ybsy29ms3yrxgr7f2146lr6z4vm070dvdyzvwwxjh4dgm9na7bi"))))
      (build-system asdf-build-system/sbcl)
      (native-inputs
       (list sbcl-parachute))
      (home-page "https://www.hexstreamsoft.com/libraries/bubble-operator-upwards/")
      (synopsis "Function that bubbles an operator upwards in a form")
      (description
       "@code{bubble-operator-upwards} is a function that bubbles an operator
upwards in a form, demultiplexing all alternative branches by way of
cartesian product.")
      (license license:unlicense))))

(define-public cl-bubble-operator-upwards
  (sbcl-package->cl-source-package sbcl-bubble-operator-upwards))

(define-public ecl-bubble-operator-upwards
  (sbcl-package->ecl-package sbcl-bubble-operator-upwards))

(define-public clasp-bubble-operator-upwards
  (sbcl-package->clasp-package sbcl-bubble-operator-upwards))

(define-public sbcl-burgled-batteries3
  (let ((commit "f65f454d13bb6c40e17e9ec62e41eb5069e09760")
        (revision "2"))
    (package
      (name "sbcl-burgled-batteries3")
      (version (git-version "0.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/snmsts/burgled-batteries3")
               (commit commit)))
         (file-name (git-file-name "cl-burgled-batteries3" version))
         (sha256
          (base32
           "1nzn7jawrfajyzwfnzrg2cmn9xxadcqh4szbpg0jggkhdkdzz4wa"))
         (patches
          (search-patches "sbcl-burgled-batteries3-fix-signals.patch"))))
      (build-system asdf-build-system/sbcl)
      (arguments
       `(#:tests? #f
         #:modules (((guix build python-build-system) #:select (python-version))
                    ,@%asdf-build-system-modules)
         #:imported-modules ((guix build python-build-system)
                             ,@%asdf-build-system-modules)
         #:phases
         (modify-phases (@ (guix build asdf-build-system) %standard-phases)
           (add-after 'unpack 'set-*cpython-include-dir*-var
             (lambda* (#:key inputs #:allow-other-keys)
               (let ((python (assoc-ref inputs "python")))
                 (setenv "BB_PYTHON3_INCLUDE_DIR"
                         (string-append python "/include/python"
                                        (python-version python)))
                 (setenv "BB_PYTHON3_DYLIB"
                         (string-append python "/lib/libpython3.so"))
                 #t)))
           (add-after 'unpack 'adjust-for-python-3.10
             (lambda _
               ;; These methods are no longer part of the public API.
               (substitute* "ffi-interface.lisp"
                 ((".*PyEval_ReInitThreads.*") "")
                 ((".*\"PyErr_Warn\".*") "")
                 ((".*\"PyFloat_ClearFreeList\".*") "")
                 ((".*\"PyParser_SimpleParseString\".*") "")
                 ((".*\"PyParser_SimpleParseStringFlags\".*") "")
                 ((".*\"PyParser_SimpleParseStringFlagsFilename\".*") "")
                 ((".*\"PyParser_SimpleParseFile\".*") "")
                 ((".*\"PyParser_SimpleParseFileFlags\".*") "")
                 ((".*\"PyLong_FromUnicode\".*") "")
                 ((".*\"PyUnicodeEncodeError_Create\".*") "")
                 ((".*\"PyUnicodeTranslateError_Create\".*") "")))))))
      (native-inputs
       (list sbcl-cl-fad sbcl-lift sbcl-cl-quickcheck))
      (inputs
       (list python
             sbcl-alexandria
             sbcl-cffi
             sbcl-parse-declarations
             sbcl-trivial-garbage))
      (synopsis "Bridge between Python and Lisp (FFI bindings, etc.)")
      (description
       "This package provides a shim between Python3 (specifically, the
CPython implementation of Python) and Common Lisp.")
      (home-page "https://github.com/snmsts/burgled-batteries3")
      (license license:expat))))

(define-public cl-burgled-batteries3
  (sbcl-package->cl-source-package sbcl-burgled-batteries3))

(define-public ecl-burgled-batteries3
  (sbcl-package->ecl-package sbcl-burgled-batteries3))

(define-public sbcl-cache-while
  (let ((commit "38e9ffbdb2c894670c366c1e5802ffcc8cfd43a7")
        (revision "1"))
    (package
      (name "sbcl-cache-while")
      (version (git-version "0.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/charje/cache-while")
               (commit commit)))
         (file-name (git-file-name "cache-while" version))
         (sha256
          (base32 "1qil68rfn5irmkb0jk1f6g1zy80wgc3skl8cr4rfgh7ywgm5izx3"))))
      (build-system asdf-build-system/sbcl)
      (home-page "https://github.com/charje/cache-while")
      (synopsis "Temporary / one-time caching macro for Common Lisp")
      (description
       "This is a Common Lisp macro for defining temporary caches that
invalidate based on expressions evaluating to different values.")
      (license license:llgpl))))

(define-public cl-cache-while
  (sbcl-package->cl-source-package sbcl-cache-while))

(define-public ecl-cache-while
  (sbcl-package->ecl-package sbcl-cache-while))

(define-public clasp-cache-while
  (sbcl-package->clasp-package sbcl-cache-while))

(define-public sbcl-cacle
  (let ((commit "4cbe8cfe227d2e097eaced14766f4f37aa05e617")
        (revision "1"))
    (package
      (name "sbcl-cacle")
      (version (git-version "1.0.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/jlahd/cacle")
               (commit commit)))
         (file-name (git-file-name "cl-cacle" version))
         (sha256
          (base32 "0h0dk0sfkfl8g0sbrs76ydb9l4znssqhx8nc5k1sg7zxpni5a4qy"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-bordeaux-threads))
      (home-page "https://github.com/jlahd/cacle")
      (synopsis "Extensible cache services for Common Lisp")
      (description "This package provides a generic cache management facility
with configurable and extensible cache replacement policies.  The
actual cached data can be stored anywhere, with cacle taking charge of
keeping track of which entry is to be discarded next when more space
is needed for a new entry.")
      (license (list license:expat)))))

(define-public cl-cacle
  (sbcl-package->cl-source-package sbcl-cacle))

(define-public ecl-cacle
  (sbcl-package->ecl-package sbcl-cacle))

(define-public sbcl-calispel
  (let ((commit "e9f2f9c1af97f4d7bb4c8ac25fb2a8f3e8fada7a"))
    (package
      (name "sbcl-calispel")
      (version (git-version "0.1" "1" commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               ;; This fork replaces the dependency on the obsolete
               ;; eager-future with eager-future2.
               (url "https://github.com/hawkir/calispel")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "08bmf3pi7n5hadpmqqkg65cxcj6kbvm997wcs1f53ml1nb79d9z8"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-jpl-queues sbcl-bordeaux-threads))
      (native-inputs
       (list sbcl-eager-future2))
      (synopsis "Thread-safe message-passing channels in Common Lisp")
      (description
       "Calispel is a Common Lisp library for thread-safe message-passing
channels, in the style of the occam programming language, also known as
communicating sequential processes (CSP).  See
@url{https://en.wikipedia.org/wiki/Communicating_sequential_processes}.

Calispel channels let one thread communicate with another, facilitating
unidirectional communication of any Lisp object.  Channels may be unbuffered,
where a sender waits for a receiver (or vice versa) before either operation can
continue, or channels may be buffered with flexible policy options.

Because sending and receiving on a channel may block, either operation can time
out after a specified amount of time.

A syntax for alternation is provided (like @code{ALT} in occam, or Unix
@code{select()}): given a sequence of operations, any or all of which may
block, alternation selects the first operation that doesn't block and executes
associated code.  Alternation can also time out, executing an \"otherwise\"
clause if no operation becomes available within a set amount of time.

Calispel is a message-passing library, and as such leaves the role of
threading abstractions and utilities left to be filled by complementary
libraries such as Bordeaux-Threads and Eager Future.")
      (home-page "https://www.thoughtcrime.us/software/calispel/")
      (license license:isc))))

(define-public cl-calispel
  (sbcl-package->cl-source-package sbcl-calispel))

(define-public ecl-calispel
  (sbcl-package->ecl-package sbcl-calispel))

(define-public sbcl-calm
  (package
    (name "sbcl-calm")
    (version "0.0.35")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/VitoVan/calm")
             (commit version)))
       (file-name (git-file-name "cl-calm" version))
       (sha256
        (base32 "1k1kwpiq7ikk1mgfi26sd968d623jl6xffngd9vwswnaiwihk4dp"))))
    (build-system asdf-build-system/sbcl)
    (inputs
     (list sbcl-cl-cairo2
           sbcl-cl-str
           sbcl-sdl2
           sbcl-sdl2-image
           sbcl-sdl2-mixer
           sbcl-slime-swank))
    (home-page "https://github.com/VitoVan/calm")
    (synopsis "Vector graphic library for Common Lisp")
    (description
     "This package provides a SDL2 based vector graphic library for Common
Lisp.")
    (license license:gpl2)))

(define-public cl-calm
  (sbcl-package->cl-source-package sbcl-calm))

(define-public ecl-calm
  (sbcl-package->ecl-package sbcl-calm))

(define-public sbcl-cambl
  (let ((commit "c21b8afe8869401d618efc9f0ef406a28d89c3b7")
        (revision "2"))
    (package
      (name "sbcl-cambl")
      (version (git-version "4.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/jwiegley/cambl")
               (commit commit)))
         (file-name (git-file-name "cl-cambl" version))
         (sha256
          (base32 "1jp0i0pwdvzg689wx2rhm2ajm4w8b55rw6q6jas3498myy2gif4d"))))
      (build-system asdf-build-system/sbcl)
      (native-inputs
       (list sbcl-xlunit))
      (inputs
       (list sbcl-alexandria
             sbcl-cl-containers
             sbcl-local-time
             sbcl-periods))
      (synopsis "Commoditized amounts and balances for Common Lisp")
      (description
       "CAMBL is a Common Lisp library providing a convenient facility for
working with commoditized values.  It does not allow compound units (and so is
not suited for scientific operations) but does work rather nicely for the
purpose of financial calculations.")
      (home-page "https://github.com/jwiegley/cambl")
      (license license:bsd-3))))

(define-public cl-cambl
  (sbcl-package->cl-source-package sbcl-cambl))

(define-public ecl-cambl
  (sbcl-package->ecl-package sbcl-cambl))

(define-public sbcl-canonicalized-initargs
  (package
    (name "sbcl-canonicalized-initargs")
    (version "2.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/Hexstream/canonicalized-initargs")
             (commit (string-append "v" version))))
       (file-name (git-file-name "cl-canonicalized-initargs" version))
       (sha256
        (base32 "0jmmjw86x9mmlfla4kdmdqf1fjrj0p2fmv1lc4k555mcf67mj2fq"))))
    (build-system asdf-build-system/sbcl)
    (native-inputs
     (list sbcl-parachute))
    (inputs
     (list sbcl-cesdi
           sbcl-closer-mop
           sbcl-compatible-metaclasses
           sbcl-enhanced-defclass
           sbcl-enhanced-typep))
    (home-page
     "https://www.hexstreamsoft.com/libraries/canonicalized-initargs/")
    (synopsis "Standard way to canonicalize slot values")
    (description
     "This package provides a standard way to canonicalize slot values.")
    (license license:unlicense)))

(define-public cl-canonicalized-initargs
  (sbcl-package->cl-source-package sbcl-canonicalized-initargs))

(define-public ecl-canonicalized-initargs
  (sbcl-package->ecl-package sbcl-canonicalized-initargs))

(define-public sbcl-caveman
  (let ((commit "35cd8bc6c322f9d88498405fc26168a1fb42ae1c") ; No release since 2012
        (revision "2"))
    (package
      (name "sbcl-caveman")
      (version (git-version "2.4.0" revision commit))
      (home-page "https://8arrow.org/caveman/")
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/fukamachi/caveman/")
               (commit commit)))
         (file-name (git-file-name "cl-caveman" version))
         (sha256
          (base32 "1wvjm9m1fnapg0r9imhhcwgnhhqkkccnj3c0iw9yg1f72d7zhm2w"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       `(("ningle" ,cl-ningle)
         ("lack" ,sbcl-lack)
         ("cl-project" ,sbcl-cl-project)
         ("dbi" ,sbcl-dbi)
         ("sxql" ,sbcl-sxql)
         ("cl-syntax" ,sbcl-cl-syntax)
         ("myway" ,sbcl-myway)
         ("quri" ,sbcl-quri)))
      (native-inputs
       `(("usocket" ,sbcl-usocket)
         ("dexador" ,sbcl-dexador)
         ("lack" ,sbcl-lack)
         ("trivial-types" ,sbcl-trivial-types)
         ("prove" ,sbcl-prove)))
      (arguments
       `(#:asd-systems '("caveman2"
                         "caveman2-db"
                         "caveman2-test"
                         "caveman-middleware-dbimanager")
         ;; TODO: Tests fail with:
         ;; writing /gnu/store/...-sbcl-caveman-2.4.0-1.faa5f7e/share/common-lisp/sbcl-source/caveman2/v2/t/tmp/myapp573/tests/myapp573.lisp
         ;; While evaluating the form starting at line 38, column 0
         ;;   of #P"/tmp/guix-build-sbcl-caveman-2.4.0-1.faa5f7e.drv-0/source/v2/t/caveman.lisp":
         ;; Unhandled ASDF/FIND-COMPONENT:MISSING-COMPONENT in thread #<SB-THREAD:THREAD "main thread" RUNNING
         ;;                                                              {10009F8083}>:
         ;;   Component "myapp573" not found
         ;;
         ;; The above myapp573 component name is randomly generated by
         ;; gensym on each test run. `(asdf:load-system *app-name*)` tries
         ;; to load this component and fails.
         ;; TODO: Ask fukamachi how to go around this.
         #:tests? #f))
      (synopsis "Lightweight web application framework in Common Lisp")
      (description "Caveman is intended to be a collection of common parts for
web applications.  Caveman2 has three design goals:

@itemize
@item Be extensible.
@item Be practical.
@item Don't force anything.
@end itemize\n")
      (license license:llgpl))))

(define-public cl-caveman
  (package
    (inherit
     (sbcl-package->cl-source-package sbcl-caveman))
    (propagated-inputs
     `(("ningle" ,cl-ningle)))))

(define-public ecl-caveman
  (sbcl-package->ecl-package sbcl-caveman))

(define-public sbcl-cblas
  (let ((commit "1eb97919ccf0ec3add7724e1a21872580bd0cdc6")
        (revision "1"))
    (package
      (name "sbcl-cblas")
      (version (git-version "0.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/digikar99/cl-cblas")
               (commit commit)))
         (file-name (git-file-name "cl-cblas" version))
         (sha256
          (base32 "1bd2w51r71pgm6sc6m2fms4j1bbnli023j4w3rbxw9cln0g7badp"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list openblas
             sbcl-cffi
             sbcl-cl-autowrap))
      (arguments
       (list #:phases
             #~(modify-phases %standard-phases
                 (add-after 'unpack 'fix-paths
                   (lambda* (#:key inputs #:allow-other-keys)
                     (substitute* "src/shared-object.lisp"
                       (("/usr/.*/libopenblas\\.so")
                        (search-input-file inputs "/lib/libopenblas.so"))
                       (("\"libopenblas\\.so\"")
                        (string-append "\""
                                       (search-input-file inputs
                                                          "/lib/libopenblas.so")
                                       "\""))))))))
      (synopsis "Common Lisp bindings for CBLAS")
      (description
       "This package provides Common Lisp bindings to access the linear
algebra libraries using the CBLAS API.  Currently the OpenBLAS implementation
is used.")
      (home-page "https://github.com/digikar99/cl-cblas")
      (license license:expat))))

(define-public cl-cblas
  (sbcl-package->cl-source-package sbcl-cblas))

(define-public sbcl-cells
  (let ((commit "e8542b17fddd6340c1e237ce482a52327c8ead8e"))
    (package
      (name "sbcl-cells")
      (version (git-version "3.0" "1" commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/kennytilton/cells")
               (commit commit)))
         (file-name (git-file-name "cl-cells" version))
         (sha256
          (base32 "0rkzvwq38lwb1045w54kw020pb9i63hxiawwhqkf8k1inhak3fdk"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-utils-kt))
      (arguments
       ;; Tests fail with #<TYPE-ERROR expected-type: STREAM datum: NIL>.
       '(#:tests? #f))
      (home-page "https://github.com/kennytilton/cells")
      (synopsis "Common Lisp implementation of the dataflow programming paradigm")
      (description
       "Cells is a mature, stable extension to CLOS allowing one to create
classes whose instances can have slot values determined by instance-specific
formulas.")
      (license license:llgpl))))

(define-public cl-cells
  (sbcl-package->cl-source-package sbcl-cells))

(define-public ecl-cells
  (sbcl-package->ecl-package sbcl-cells))

(define-public sbcl-cephes
  (let ((commit "d87146fa38c8425ffb5fe425eee5eb3e818bacd4")
        (revision "0"))
    (package
      (name "sbcl-cephes")
      (version (git-version "1.2" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/Lisp-Stat/cephes.cl")
               (commit commit)))
         (file-name (git-file-name "cl-cephes" version))
         (sha256
          (base32 "09adls1lwwzwm1jmvhf11arwlsy5w0bi2rmniahas824mysv77lr"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-cffi))
      (arguments
       (list #:phases
             #~(modify-phases %standard-phases
                 ;; ECL has issues making the shared library automatically,
                 ;; so we make it explicitly.
                 (add-before 'build 'build-shared-library
                   (lambda _
                     (with-directory-excursion
                         (string-append #$output "/share/common-lisp/"
                                        (%lisp-type) "/cephes/scipy-cephes")
                       (invoke "make")
                       ;; Remove temporary object files.
                       (for-each delete-file (find-files "." "\\.o$"))))))))
      (home-page "https://lisp-stat.github.io/cephes.cl/")
      (synopsis "Common Lisp wrapper for the Cephes Mathematical Library")
      (description
       "This package provides a common lisp CFFI wrapper for the SciPy version
of Cephes special functions.")
      (license license:ms-pl))))

(define-public cl-cephes
  (sbcl-package->cl-source-package sbcl-cephes))

(define-public ecl-cephes
  (sbcl-package->ecl-package sbcl-cephes))

(define-public sbcl-cepl
  (let ((commit "d1a10b6c8f4cedc07493bf06aef3a56c7b6f8d5b")
        (revision "1"))
    (package
     (name "sbcl-cepl")
     (version (git-version "0.0.0" revision commit))
     (source
      (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/cbaggers/cepl")
             (commit commit)))
       (file-name (git-file-name "cepl" version))
       (sha256
        (base32 "0izbw2advqm3wailj3dpq6zqfrfirwn14pw5qmqh8i71r51xwmm2"))))
     (build-system asdf-build-system/sbcl)
     (inputs
      `(("alexandria" ,sbcl-alexandria)
        ("bordeaux-threads" ,sbcl-bordeaux-threads)
        ("cffi" ,sbcl-cffi)
        ("cl-opengl" ,sbcl-cl-opengl)
        ("cl-ppcre" ,sbcl-cl-ppcre)
        ("documentation-utils" ,sbcl-documentation-utils)
        ("float-features" ,sbcl-float-features)
        ("ieee-floats" ,sbcl-ieee-floats)
        ("split-sequence" ,sbcl-split-sequence)
        ("varjo" ,sbcl-varjo)))
     (propagated-inputs
      (list sbcl-quickproject))
     (home-page "https://github.com/cbaggers/cepl")
     (synopsis "Development playground to work with OpenGL")
     (description
      "CEPL (Code Evaluate Play Loop ) is a lispy and REPL-friendly Common Lisp
library for working with OpenGL.

Its definition of success is making the user feel that GPU programming has
always been part of the languages standard.

The usual approach to using CEPL is to start it at the beginning of your Lisp
session and leave it open for the duration of your work.  You can then treat the
window it creates as just another output for your graphics, analogous to how
@code{*standard-output*} is treated for text.")
     (license license:bsd-2))))

(define-public cl-cepl
  (sbcl-package->cl-source-package sbcl-cepl))

(define-public ecl-cepl
  (sbcl-package->ecl-package sbcl-cepl))

(define-public sbcl-cesdi
  (package
    (name "sbcl-cesdi")
    (version "1.0.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/Hexstream/cesdi")
             (commit version)))
       (file-name (git-file-name "cl-cesdi" version))
       (sha256
        (base32 "02f2pz5rw79ljkkx1ywh8nkpjj4g3z3s1lyvzqb8krbnx11wl0q9"))))
    (build-system asdf-build-system/sbcl)
    (native-inputs
     (list sbcl-parachute))
    (inputs
     (list sbcl-closer-mop))
    (home-page "https://www.hexstreamsoft.com/libraries/cesdi/")
    (synopsis "Ergonomic initialization of effective slot definition objects")
    (description
     "This package provides a @code{compute-effective-slot-definition-initargs}
generic function that allows for more ergonomic initialization of effective slot
definition objects.")
    (license license:unlicense)))

(define-public cl-cesdi
  (sbcl-package->cl-source-package sbcl-cesdi))

(define-public ecl-cesdi
  (sbcl-package->ecl-package sbcl-cesdi))

(define-public clasp-cesdi
  (sbcl-package->clasp-package sbcl-cesdi))

(define-public sbcl-cf
  (let ((commit "0aa0dd67f59f88e0dbd50ebe25690fcdaafee4c5")
        (revision "0"))
    (package
      (name "sbcl-cf")
      (version (git-version "1.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://codeberg.org/glv/cl-cf")
               (commit commit)))
         (file-name (git-file-name "cl-cf" version))
         (sha256
          (base32 "0bacgspfqvkdr430yax9dk61pavcajz9kv9lb12rg5qcrqd1vpmb"))))
      (build-system asdf-build-system/sbcl)
      (native-inputs (list sbcl-fiveam))
      (synopsis "Continued fractions library")
      (description "CF is a Common Lisp library for doing computations using
continued fractions.")
      (home-page "https://codeberg.org/glv/cl-cf")
      (license license:gpl3+))))

(define-public cl-cf
  (sbcl-package->cl-source-package sbcl-cf))

(define-public ecl-cf
  (sbcl-package->ecl-package sbcl-cf))

(define-public sbcl-cffi
  (let ((commit "32c90d4a9a01e809f591276c058e5b3c7f39b154")
        (revision "2"))
    (package
      (name "sbcl-cffi")
      (version (git-version "0.24.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/cffi/cffi")
               (commit commit)))
         (file-name (git-file-name "cl-cffi" version))
         (sha256
          (base32 "1b2j32rapgw8rn7m9sm2k8r8x9jds7vshkm90i5lw9v4xnp8x4m7"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list libffi
             sbcl-alexandria
             sbcl-babel
             sbcl-trivial-features))
      (native-inputs
       (list pkg-config
             sbcl-bordeaux-threads
             sbcl-rt))
      (arguments
       (list ;; Some tests will not work on riscv64 because a function of SBCL
             ;; is not implemented yet for riscv.
             ;; See <https://bugs.launchpad.net/sbcl/+bug/2069265>
             #:tests? (not (target-riscv64?))
             #:phases
             #~(modify-phases %standard-phases
                 (add-after 'unpack 'fix-paths
                   (lambda* (#:key inputs #:allow-other-keys)
                     (substitute* "libffi/libffi.lisp"
                       (("libffi.so.8" all)
                        (search-input-file inputs (string-append "/lib/" all))))
                     (substitute* "toolchain/c-toolchain.lisp"
                       (("\"cc\"")
                        (format #f "~S" (which "gcc"))))))
                 (add-after 'build 'install-headers
                   (lambda _
                     (install-file "grovel/common.h"
                                   (string-append #$output
                                                  "/include/grovel")))))
             #:asd-systems ''("cffi"
                              "cffi-libffi"
                              "cffi-uffi-compat")))
      (home-page "https://common-lisp.net/project/cffi/")
      (synopsis "Common Foreign Function Interface for Common Lisp")
      (description "The Common Foreign Function Interface (CFFI)
purports to be a portable foreign function interface for Common Lisp.
The CFFI library is composed of a Lisp-implementation-specific backend
in the CFFI-SYS package, and a portable frontend in the CFFI
package.")
      (license license:expat))))

(define-public cl-cffi
  (sbcl-package->cl-source-package sbcl-cffi))

(define-public ecl-cffi
  (sbcl-package->ecl-package sbcl-cffi))


(define-public sbcl-cffi-c-ref
  (let ((commit "8123cbb6034c5f7921a0766107cfb8c4e8efd5ce")
        (revision "0"))
    (package
      (name "sbcl-cffi-c-ref")
      (version (git-version "1.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/borodust/cffi-c-ref")
               (commit commit)))
         (sha256
          (base32 "1a3pp6xcisabqir3rp1gvvjfdxcvpm8yr35p38nri9azsinmmc7z"))
         (file-name (git-file-name "cffi-c-ref" version))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-alexandria sbcl-cffi))
      (synopsis "Streamlined access to foreign memory")
      (description
       "This Common Lisp library provides macros to access foreign memory.")
      (home-page "https://github.com/borodust/cffi-c-ref")
      (license license:expat))))

(define-public cl-cffi-c-ref
  (sbcl-package->cl-source-package sbcl-cffi-c-ref))

(define-public ecl-cffi-c-ref
  (sbcl-package->ecl-package sbcl-cffi-c-ref))

(define-public sbcl-cffi-object
  (package
    (name "sbcl-cffi-object")
    (version "1.0.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/bohonghuang/cffi-object")
             (commit "b9e4f8f7eed44cfa5319fd086f282efbcf3ed705")))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1mvxqaq800803mhhra28kjzvkcg7b9jfnlw7662qnps99b0m8y2p"))))
    (build-system asdf-build-system/sbcl)
    (native-inputs
     (list sbcl-parachute
           sbcl-cffi-ops))
    (inputs
     (list sbcl-alexandria
           sbcl-cffi
           sbcl-trivial-garbage))
    (home-page "https://github.com/bohonghuang/cffi-object")
    (synopsis "Enables fast and convenient interoperation with foreign
objects")
    (description "Enables fast and convenient interoperation with foreign
objects.")
    (license license:asl2.0)))

;; Error detected:
;; Unknown CFFI type :OBJECT
#;(define-public ecl-cffi-object
  (sbcl-package->ecl-package sbcl-cffi-object))

(define-public cl-cffi-object
  (sbcl-package->cl-source-package sbcl-cffi-object))

(define-public sbcl-cffi-ops
  (package
    (name "sbcl-cffi-ops")
    (version "1.0.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/bohonghuang/cffi-ops")
             (commit "79a36a643c10459e3ea6a7a22dfa7f9b62233e61")))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0hi3svwfb7m1wq892wlrsgj52jkh3x6msnimax28221baj6g64gg"))))
    (build-system asdf-build-system/sbcl)
    (native-inputs
     (list sbcl-parachute))
    (inputs
     (list sbcl-alexandria
           sbcl-cffi
           sbcl-arrow-macros
           sbcl-trivial-macroexpand-all))
    (home-page "https://github.com/bohonghuang/cffi-ops")
    (synopsis "Helps writing concise CFFI-related code")
    (description "Helps writing concise CFFI-related code.")
    (license license:asl2.0)))

(define-public ecl-cffi-ops
  (sbcl-package->ecl-package sbcl-cffi-ops))

(define-public cl-cffi-ops
  (sbcl-package->cl-source-package sbcl-cffi-ops))

(define-public sbcl-chanl
  (let ((commit "56e90a126c78b39bb621a01585e8d3b985238e8c")
        (revision "1"))
    (package
      (name "sbcl-chanl")
      (version (git-version "0.4.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/zkat/chanl")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "0b1cf6c12qx5cy1fw2z42jgh566rp3l8nv5qf0qqc569s7bgmrh4"))))
      (build-system asdf-build-system/sbcl)
      (native-inputs
       (list sbcl-fiveam))
      (inputs
       (list sbcl-bordeaux-threads))
      (arguments
       ;; Disable flaky tests
       (list #:tests? #f))
      (synopsis "Portable channel-based concurrency for Common Lisp")
      (description "Common Lisp library for channel-based concurrency.  In
a nutshell, you create various threads sequentially executing tasks you need
done, and use channel objects to communicate and synchronize the state of these
threads.")
      (home-page "https://github.com/zkat/chanl")
      (license (list license:expat license:bsd-3)))))

(define-public cl-chanl
  (sbcl-package->cl-source-package sbcl-chanl))

(define-public ecl-chanl
  (sbcl-package->ecl-package sbcl-chanl))

(define-public sbcl-charje.documentation
  (package
    (name "sbcl-charje.documentation")
    (version "0.0.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://git.sr.ht/~charje/documentation")
             (commit (string-append "v" version))))
       (sha256
        (base32
         "149r9qdz5dyxsamhf5miaa9njr7kn7nc0ic448k133rs3nnwagqc"))
       (file-name (git-file-name "cl-charje.documentation" version))))
    (build-system asdf-build-system/sbcl)
    (inputs
     (list sbcl-alexandria))
    (home-page "https://git.sr.ht/~charje/documentation")
    (synopsis "Docstring parsing library for Common Lisp")
    (description "Charje.documentation can used to parse Common Lisp
docstrings the charje way, or it can be used to create custom docstring
parsers.  Docstring parsers are composed using mixin classes and
initialization methods.")
    (license license:agpl3+)))

(define-public cl-charje.documentation
  (sbcl-package->cl-source-package sbcl-charje.documentation))

(define-public ecl-charje.documentation
  (sbcl-package->ecl-package sbcl-charje.documentation))

(define-public clasp-charje.documentation
  (sbcl-package->clasp-package sbcl-charje.documentation))

(define-public sbcl-charje.loop
  (package
    (name "sbcl-charje.loop")
    (version "1.1.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://git.sr.ht/~charje/loop")
             (commit (string-append "v" version))))
       (file-name (git-file-name "cl-charje.loop" version))
       (sha256
        (base32
         "111y4g9l39s6pmbwglas9ivz7lzpzxbix1d52d7iapmpx61nim0f"))))
    (build-system asdf-build-system/sbcl)
    (inputs
     (list sbcl-alexandria
           sbcl-binding-arrows
           sbcl-parse-declarations))
    (home-page "https://git.sr.ht/~charje/loop")
    (synopsis "Loop abstraction for Common Lisp that is consistent for
different kinds of data")
    (description "Loop has a consistent interface unlike other looping
abstractions and ANSI list operations.  You can define your own efters and
gatherers that integrate tightly into other operations.  All operations are
non-consing when possible.")
    (license license:agpl3+)))

(define-public cl-charje.loop
  (sbcl-package->cl-source-package sbcl-charje.loop))

(define-public ecl-charje.loop
  (sbcl-package->ecl-package sbcl-charje.loop))

(define-public clasp-charje.loop
  (sbcl-package->clasp-package sbcl-charje.loop))

(define-public sbcl-charje.lambda-list
  (package
    (name "sbcl-charje.lambda-list")
    (version "0.0.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
              (url "https://git.sr.ht/~charje/lambda-list")
              (commit (string-append "v" version))))
       (file-name (git-file-name "cl-charje.lambda-list" version))
       (sha256
        (base32
         "1yb96w6alaqg7lllwpl9m5lmcq6r03bhcn84wnhxdzmy3vh93dkd"))))
    (build-system asdf-build-system/sbcl)
    (inputs
     (list
      sbcl-binding-arrows
      sbcl-charje.loop
      sbcl-ctype))
    (home-page "https://git.sr.ht/~charje/lambda-list")
    (synopsis "Common Lisp lambda list parsing and manipulation library")
    (description
     "charje.lambda-list can parse every kind of lambda list defined in the
ANSI Common Lisp standard.  Parsing yields only one object that has all the
parsed parts of the lambda list inside.  New kinds of lambda lists can be made
too.")
    (license license:agpl3+)))

(define-public cl-charje.lambda-list
  (sbcl-package->cl-source-package sbcl-charje.lambda-list))

;; TODO: Waiting on next ecl release.
;; See: https://gitlab.com/embeddable-common-lisp/ecl/-/issues/750
;; (define-public ecl-charje.lambda-list
;;   (sbcl-package->ecl-package sbcl-charje.lambda-list))

(define-public clasp-charje.lambda-list
  (sbcl-package->clasp-package sbcl-charje.lambda-list))

(define-public sbcl-chemboy
  (package
    (name "sbcl-chemboy")
    (version "0.3")
    (source
     (origin
       (method url-fetch)
       (uri (string-append
             "https://common-lisp.net/project/chemboy/chemboy-"
             version ".tar.gz"))
       (sha256
        (base32 "0lr134l16mjcgdj3fm2yff4chlfbihn1sji7q80y7lnr176zgs7d"))))
    (build-system asdf-build-system/sbcl)
    (inputs
     `(("chemical-compounds" ,sbcl-chemical-compounds)
       ("periodic-table" ,sbcl-periodic-table)))
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'fix-files
           (lambda _
             ;; Fix incorrect version number.
             (substitute* "chemboy.asd"
               ((":version \"0.2\"")
                (string-append ":version \"" ,version "\"")))
             ;; Remove incorrect declaration of string type.
             (substitute* "query-parsing.lisp"
               (("\\(declare \\(simple-base-string string\\)")
                "(declare"))
             ;; Fix incorrect function calls.
             (substitute* "conversions.lisp"
               (("\\(pprint-compound element s\\)")
                "(pprint-compound element :stream s)")
               (("\\(pprint-compound parsed-compound s\\)")
                "(pprint-compound parsed-compound :stream s)")))))))
    (home-page "https://common-lisp.net/project/chemboy/")
    (synopsis "Common Lisp program for doing basic chemistry calculations")
    (description
     "Chemboy is a Common Lisp program for doing basic chemistry calculations.
This package provides the text-based interface for Chemboy.")
    (license license:llgpl)))

(define-public cl-chemboy
  (sbcl-package->cl-source-package sbcl-chemboy))

(define-public ecl-chemboy
  (sbcl-package->ecl-package sbcl-chemboy))

(define-public sbcl-chemical-compounds
  (package
    (name "sbcl-chemical-compounds")
    (version "1.0.2")
    (source
     (origin
       (method url-fetch)
       (uri (string-append
             "https://common-lisp.net/project/chemboy/chemical-compounds-"
             version ".tar.gz"))
       (sha256
        (base32 "12fd8a6ay5qlsq4givzgh9d55mbg4ci2vvmymig6pjl2ms64v0pf"))))
    (build-system asdf-build-system/sbcl)
    (inputs
     `(("periodic-table" ,sbcl-periodic-table)))
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'fix-files
           (lambda _
             ;; Fix incorrect version number.
             (substitute* "chemical-compounds.asd"
               ((":version \"1.0.1\"")
                (string-append ":version \"" ,version "\"")))
             ;; Remove incorrect declaration of string type.
             (substitute* "parsing.lisp"
               (("\\(declare \\(simple-base-string string\\)")
                "(declare")))))))
    (home-page "https://common-lisp.net/project/chemboy/")
    (synopsis "Chemical formula parser and pretty-printer for Common Lisp")
    (description
     "It can sometimes be useful to be able to parse chemical compounds in a
user-friendly syntax into easy-to-manipulate s-expressions.  You also want to
be able to go in reverse.  You could probably write your own parser — or you
could just install the chemical-compounds package.")
    (license license:llgpl)))

(define-public cl-chemical-compounds
  (sbcl-package->cl-source-package sbcl-chemical-compounds))

(define-public ecl-chemical-compounds
  (sbcl-package->ecl-package sbcl-chemical-compounds))

(define-public clasp-chemical-compounds
  (sbcl-package->clasp-package sbcl-chemical-compounds))

(define-public sbcl-chipz
  (let ((version "0.8")
        (commit "82a17d39c78d91f6ea63a03aca8f9aa6069a5e11")
        (revision "2"))
    (package
      (name "sbcl-chipz")
      (version (git-version version revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/sharplispers/chipz")
               (commit commit)))
         (file-name (git-file-name "cl-chipz" version))
         (sha256
          (base32 "1n4f22i9j8iapjd6yx1z348rggcybvg9h794kx9libjgz4bs371h"))))
      (build-system asdf-build-system/sbcl)
      (native-inputs
       (list sbcl-flexi-streams))
      (home-page "http://method-combination.net/lisp/chipz/")
      (synopsis
       "Common Lisp library for decompressing deflate, zlib, gzip, and bzip2
data")
      (description
       "DEFLATE data, defined in RFC1951, forms the core of popular
compression formats such as zlib (RFC 1950) and gzip (RFC 1952).  As such,
Chipz also provides for decompressing data in those formats as well.  BZIP2 is
the format used by the popular compression tool bzip2.")
      ;; The author describes it as "MIT-like"
      (license license:expat))))

(define-public cl-chipz
  (sbcl-package->cl-source-package sbcl-chipz))

(define-public ecl-chipz
  (sbcl-package->ecl-package sbcl-chipz))

(define-public clasp-chipz
  (sbcl-package->clasp-package sbcl-chipz))

(define-public sbcl-chirp
  (let ((commit "49050a0765736ffbed82ccd09cafdfdcf42884c1")
        (revision "2"))
    (package
      (name "sbcl-chirp")
      (version (git-version "0.2.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://codeberg.org/shinmera/chirp")
               (commit commit)))
         (file-name (git-file-name "chirp" version))
         (sha256
          (base32 "0f6syqam0vsldnqdbccfzx4zqw0jcqyv8yw947qlm9n8zpkhhm06"))))
      (build-system asdf-build-system/sbcl)
      (arguments
       `(#:asd-systems '("chirp-core" "chirp-dexador" "chirp-drakma" "chirp")))
      (inputs
       `(("alexandria" ,sbcl-alexandria)
         ("babel" ,sbcl-babel)
         ("cl-base64" ,sbcl-cl-base64)
         ("cl-ppcre" ,sbcl-cl-ppcre)
         ("dexador" ,sbcl-dexador)
         ("drakma" ,sbcl-drakma)
         ("flexi-streams" ,sbcl-flexi-streams)
         ("ironclad" ,sbcl-ironclad)
         ("local-time" ,sbcl-local-time)
         ("split-sequence" ,sbcl-split-sequence)
         ("uuid" ,sbcl-uuid)
         ("yason" ,sbcl-yason)))
      (home-page "https://codeberg.org/shinmera/chirp")
      (synopsis "Twitter client library for Common Lisp")
      (description
       "This package provides a Common Lisp Twitter client featuring full API
coverage.")
      (license license:zlib))))

(define-public cl-chirp
  (sbcl-package->cl-source-package sbcl-chirp))

(define-public ecl-chirp
  (sbcl-package->ecl-package sbcl-chirp))

(define-public sbcl-chlorophyll
  (let ((commit "f2a50ad36d2fb11823c0e5a8da08a0de89c5c35f")
        (revision "1"))
    (package
      (name "sbcl-chlorophyll")
      (version (git-version "0.0.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/gorozhin/chlorophyll")
               (commit commit)))
         (file-name (git-file-name "cl-chlorophyll" version))
         (sha256
          (base32 "1hgl8sjsmyqx4gs77q4p94b63zgpxk1wi9w9niki8j0213dr1s3y"))))
      (build-system asdf-build-system/sbcl)
      (native-inputs (list sbcl-fiveam))
      (inputs (list sbcl-alexandria))
      (home-page "https://github.com/gorozhin/chlorophyll")
      (synopsis "ANSI escape code library for Common Lisp")
      (description
       "This package provides a Common Lisp system CHLOROPHYLL which
implements an ANSI escape code functionality.")
      (license license:expat))))

(define-public cl-chlorophyll
  (sbcl-package->cl-source-package sbcl-chlorophyll))

(define-public ecl-chlorophyll
  (sbcl-package->ecl-package sbcl-chlorophyll))

(define-public sbcl-chronicity
  (package
    (name "sbcl-chronicity")
    (version "0.4.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/chaitanyagupta/chronicity")
             (commit (string-append "v" version))))
       (file-name (git-file-name "chronicity" version))
       (sha256
        (base32 "0rzrl9is2v1aqbm0sym0qx3blnpd0bl13dkkmll6mb3983k2mkax"))))
    (build-system asdf-build-system/sbcl)
    (native-inputs
     (list sbcl-lisp-unit))
    (inputs
     (list sbcl-cl-interpol sbcl-cl-ppcre sbcl-local-time))
    (home-page "https://github.com/chaitanyagupta/chronicity")
    (synopsis "Natural language date and time parser for Common Lisp")
    (description
     "CHRONICITY is Common Lisp natural language date and time parser inspired
by Ruby's @code{Chronic}.")
    (license license:bsd-3)))

(define-public ecl-chronicity
  (sbcl-package->ecl-package sbcl-chronicity))

(define-public cl-chronicity
  (sbcl-package->cl-source-package sbcl-chronicity))

(define-public sbcl-chunga
  (package
    (name "sbcl-chunga")
    (version "1.1.7")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
              (url "https://github.com/edicl/chunga")
              (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0jzn3nyb3f22gm983rfk99smqs3mhb9ivjmasvhq9qla5cl9pyhd"))))
    (build-system asdf-build-system/sbcl)
    (inputs
     (list sbcl-trivial-gray-streams))
    (home-page "https://edicl.github.io/chunga/")
    (synopsis "Portable chunked streams for Common Lisp")
    (description
     "Chunga implements streams capable of chunked encoding on demand as
defined in RFC 2616.")
    (license license:bsd-2)))

(define-public cl-chunga
  (sbcl-package->cl-source-package sbcl-chunga))

(define-public ecl-chunga
  (sbcl-package->ecl-package sbcl-chunga))

(define-public sbcl-ciel
  (let ((commit "0b26d64dcd91a3a2aa962842629a853261dd30fe")
        (revision "0"))
    (package
      (name "sbcl-ciel")
      (version (git-version "0.2.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/ciel-lang/CIEL")
               (commit commit)))
         (file-name (git-file-name "cl-ciel" version))
         (sha256
          (base32 "0gm8slnz4jw98rkijnh2dp6x629xdnfk8z7j35g03j6ypr56v06h"))))
      (build-system asdf-build-system/sbcl)
      (native-inputs
       (list sbcl-fiveam))
      (inputs
       (list sbcl-access
             sbcl-alexandria
             sbcl-arrow-macros
             sbcl-bordeaux-threads
             sbcl-cl-ansi-text
             sbcl-cl-cron
             sbcl-cl-csv
             sbcl-cl-ftp
             sbcl-cl-json-pointer
             sbcl-cl-ppcre
             sbcl-cl-reexport
             sbcl-cl-str
             sbcl-clesh
             sbcl-clingon
             sbcl-closer-mop
             sbcl-cmd
             sbcl-dbi
             sbcl-defstar
             sbcl-dexador
             sbcl-dissect
             sbcl-easy-routes
             sbcl-file-finder
             sbcl-file-notify
             sbcl-for
             sbcl-fset
             sbcl-generic-cl
             sbcl-hunchentoot
             sbcl-local-time
             sbcl-log4cl
             sbcl-lparallel
             sbcl-lquery
             sbcl-metabang-bind
             sbcl-modf
             sbcl-moira
             sbcl-named-readtables
             sbcl-parse-float
             sbcl-parse-number
             sbcl-printv
             sbcl-progressons
             sbcl-pythonic-string-reader
             sbcl-quicksearch
             sbcl-quri
             sbcl-repl-utilities
             sbcl-secret-values
             sbcl-serapeum
             sbcl-shasht
             sbcl-shlex
             sbcl-spinneret
             sbcl-sxql
             sbcl-termp
             sbcl-trivia
             sbcl-trivial-arguments
             sbcl-trivial-do
             sbcl-trivial-monitored-thread
             sbcl-trivial-package-local-nicknames
             sbcl-trivial-types
             sbcl-vgplot
             sbcl-which))
      (outputs '("out" "image"))
      (arguments
       (list
        #:phases
        #~(modify-phases %standard-phases
            (add-after 'create-asdf-configuration 'build-image
              (lambda* (#:key outputs #:allow-other-keys)
                (build-image
                 (string-append (assoc-ref outputs "image") "/bin/ciel")
                 outputs
                 #:dependencies '("ciel")))))))
      (home-page "http://ciel-lang.org/")
      (synopsis "CIEL Is an Extended Lisp")
      (description
       "CIEL is a ready-to-use collection of libraries providing: a binary, to
run CIEL scripts; a simple full-featured REPL for the terminal; a Lisp library
and a core image.")
      (license license:expat))))

(define-public cl-ciel
  (sbcl-package->cl-source-package sbcl-ciel))

(define-public ecl-ciel
  ;; Remove the "image" output and the build phase "build-image"
  ;; (which fails because ECL has no support for images).
  (let ((pkg (sbcl-package->ecl-package sbcl-ciel)))
    (package
      (inherit pkg)
      (outputs '("out"))
      (arguments
       (substitute-keyword-arguments (package-arguments pkg)
         ((#:phases phases)
          `(modify-phases ,phases
             (delete 'build-image))))))))

(define-public sbcl-ciel-repl
  (let ((commit "0b26d64dcd91a3a2aa962842629a853261dd30fe")
        (revision "0"))
    (package
      (name "sbcl-ciel-repl")
      (version (git-version "0.2.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/ciel-lang/CIEL")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "0gm8slnz4jw98rkijnh2dp6x629xdnfk8z7j35g03j6ypr56v06h"))
         (patches (search-patches "sbcl-ciel-repl.patch"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-ciel
             sbcl-cl-readline
             sbcl-lisp-critic
             sbcl-magic-ed))
      (arguments
       (list
        #:asd-systems ''("ciel/repl")
        #:phases
        #~(modify-phases %standard-phases
            ;; The built-in scripts require special care. They are
            ;; read from src/scripts in the current directory.
            ;; When the binary is built, the current directory is
            ;; {out}/bin, so the scripts have to be copied there,
            ;; but that copy must be deleted after the binary has been
            ;; built, otherwise it would end up in the package.
            (add-after 'create-asdf-configuration 'install-scripts
              (lambda _
                (let ((dir (string-append #$output "/bin/src/scripts")))
                  (for-each (lambda (file)
                              (install-file file dir))
                            (find-files "src/scripts" "\\.lisp$")))))
            (add-after 'install-scripts 'build-program
              (lambda* (#:key outputs #:allow-other-keys)
                (build-program
                 (string-append #$output "/bin/ciel")
                 outputs
                 #:entry-program '((ciel::main))
                 #:dependencies '("ciel/repl")
                 #:compress? #t)))
            (add-after 'build-program 'delete-scripts
              (lambda _
                (let ((dir (string-append #$output "/bin/src")))
                  (delete-file-recursively dir))))
            ;; Remove everything except the binary.
            (add-after 'delete-scripts 'delete-lisp-files
              (lambda _
                (let ((dir (string-append #$output "/etc")))
                  (delete-file-recursively dir))
                (let ((dir (string-append #$output "/lib")))
                  (delete-file-recursively dir))
                (let ((dir (string-append #$output "/share")))
                  (delete-file-recursively dir))
                (let ((dir (string-append #$output "/.asd-files")))
                  (delete-file-recursively dir)))))))
      (home-page "http://ciel-lang.org/")
      (synopsis "Terminal REPL for CIEL")
      (description
       "This package provides CIEL as a precompiled binary and a full-featured
REPL for the terminal.")
      (license license:expat))))

(define-public sbcl-circular-streams
  (let ((commit "e770bade1919c5e8533dd2078c93c3d3bbeb38df")
        (revision "1"))
    (package
     (name "sbcl-circular-streams")
     (version (git-version "0.1.0" revision commit))
     (source
      (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/fukamachi/circular-streams")
             (commit commit)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1wpw6d5cciyqcf92f7mvihak52pd5s47kk4qq6f0r2z2as68p5rs"))))
     (build-system asdf-build-system/sbcl)
     (arguments
      ;; The tests depend on cl-test-more which is now prove. Prove
      ;; tests aren't working for some reason.
      `(#:tests? #f))
     (inputs
      (list sbcl-fast-io sbcl-trivial-gray-streams))
     (home-page "https://github.com/fukamachi/circular-streams")
     (synopsis "Circularly readable streams for Common Lisp")
     (description
      "Circular-Streams allows you to read streams circularly by wrapping real
streams.  Once you reach end-of-file of a stream, its file position will be
reset to 0 and you're able to read it again.")
     (license license:llgpl))))

(define-public cl-circular-streams
  (sbcl-package->cl-source-package sbcl-circular-streams))

(define-public ecl-circular-streams
  (sbcl-package->ecl-package sbcl-circular-streams))

(define-public sbcl-cl-abnf
  ;; There are no releases
  (let ((commit "ba1fbb104dedbdaddb1ef93d2e4da711bd96cd70")
        (revision "1"))
    (package
     (name "sbcl-cl-abnf")
     (version (git-version "0.0.0" revision commit))
     (source
      (origin
        (method git-fetch)
        (uri (git-reference
              (url "https://github.com/dimitri/cl-abnf")
              (commit commit)))
        (file-name (git-file-name "cl-abnf" version))
        (sha256
         (base32 "0f09nsndxa90acm71zd4qdnp40v705a4sqm04mnv9x76h6dlggmz"))))
     (build-system asdf-build-system/sbcl)
     (inputs
      `(("cl-ppcre" ,sbcl-cl-ppcre)
        ("esrap" ,sbcl-esrap)))
     (arguments
      `(#:asd-systems '("abnf")))
     (home-page "https://github.com/dimitri/cl-abnf")
     (synopsis "ABNF parser generator for Common Lisp")
     (description "This Common Lisp library implements a parser generator for
the ABNF grammar format as described in RFC2234.  The generated parser is a
regular expression scanner provided by the cl-ppcre lib, which means that we
can't parse recursive grammar definition.  One such definition is the ABNF
definition as given by the RFC.  Fortunately, as you have this lib, you most
probably don't need to generate another parser to handle that particular ABNF
grammar.")
     (license license:expat))))

(define-public cl-abnf
  (sbcl-package->cl-source-package sbcl-cl-abnf))

(define-public ecl-cl-abnf
  (sbcl-package->ecl-package sbcl-cl-abnf))

(define-public sbcl-cl-algebraic-data-type
  (let ((commit "b2568428193a512d141d6b615772d50ceb5f9bca"))
    (package
      (name "sbcl-cl-algebraic-data-type")
      (version (git-version "1.2.0" "1" commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/stylewarning/cl-algebraic-data-type")
               (commit commit)))
         (file-name (git-file-name "cl-algebraic-data-type" version))
         (sha256
          (base32 "1lnqxcv8pd5z8n0g5p2l0dbljx9pqiv18hxl0vhsh7ldhkrjv2jx"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-alexandria
             sbcl-global-vars))
      (arguments
       '(#:tests? #f))                  ; No tests.
      (home-page "https://github.com/stylewarning/cl-algebraic-data-type")
      (synopsis "Common Lisp library for algebraic data types")
      (description
       "CL-ALGEBRAIC-DATA-TYPE, or ADT, is a library for defining algebraic
data types in a similar spirit to Haskell or Standard ML, as well as for
operating on them.")
      (license license:bsd-3))))

(define-public cl-algebraic-data-type
  (sbcl-package->cl-source-package sbcl-cl-algebraic-data-type))

(define-public ecl-algebraic-data-type
  (sbcl-package->ecl-package sbcl-cl-algebraic-data-type))

(define-public sbcl-cl-all
  (let ((commit "8db710a4a92a25ca7c8f09fe1ad91a48ad6bd0c9")
        (revision "1"))
    (package
      (name "sbcl-cl-all")
      (version (git-version "2.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://codeberg.org/shinmera/cl-all")
               (commit commit)))
         (file-name (git-file-name "cl-all" version))
         (sha256
          (base32 "08jsbnkapijn0v4n5h9g6s87i279xmg4fnbw6jajylrg512n38cx"))))
      (build-system asdf-build-system/sbcl)
      (outputs '("out" "bin"))
      (arguments
       (list
        #:phases
        #~(modify-phases %standard-phases
            (add-after 'create-asdf-configuration 'build-program
              (lambda* (#:key outputs #:allow-other-keys)
                (build-program
                 (string-append (assoc-ref outputs "bin") "/bin/cl-all")
                 outputs
                 #:entry-program '((cl-all:toplevel arguments))
                 #:compress? #t))))))
      (home-page "https://shinmera.com/docs/cl-all")
      (synopsis "Evaluate Common Lisp expressions in multiple implementations")
      (description "@samp{cl-all} is a library and script for evaluating Common
Lisp expressions in multiple implementations.")
      (license license:zlib))))

(define-public cl-all
  (sbcl-package->cl-source-package sbcl-cl-all))

(define-public sbcl-cl-ana
  (let ((commit "848185eed1ed65bab3a124870c122f761ce0d87e")
        (revision "2"))
    (package
      (name "sbcl-cl-ana")
      (version (git-version "0.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/ghollisjr/cl-ana")
               (commit commit)))
         (file-name (git-file-name "cl-ana" version))
         (sha256
          (base32 "026agqsxq3pg2k9jmy2wysil2z0yn5rykzzhr8rqxsspdwz51z1y"))))
      (build-system asdf-build-system/sbcl)
      (native-inputs
       (list openmpi ;; for hdf-cffi
             pkg-config
             sbcl-cl-fad))
      (inputs
       (list gsl
             hdf5-parallel-openmpi
             libffi
             sbcl-antik
             sbcl-cffi
             sbcl-cl-csv
             sbcl-closer-mop
             sbcl-external-program
             sbcl-gsll
             sbcl-iterate
             sbcl-alexandria
             sbcl-split-sequence))
      (propagated-inputs
       (list gnuplot)) ;; for gnuplot-interface
      (arguments
       (list #:phases
             #~(modify-phases %standard-phases
                 (add-after 'unpack 'fix-paths
                   (lambda* (#:key inputs #:allow-other-keys)
                     (substitute* "hdf-cffi/src/library.lisp"
                       (("libhdf5.so")
                        (search-input-file inputs "/lib/libhdf5.so")))
                     (substitute* (list "gsl-cffi/gsl-cffi.lisp"
                                        "spline/spline.lisp")
                       (("libgsl.so")
                        (search-input-file inputs "/lib/libgsl.so")))))
                 (add-after 'fix-paths 'fix-newer-hdf5-compatibility
                   (lambda _
                     (substitute* (list "hdf-cffi/src/h5-grovel.lisp"
                                        "hdf-cffi/src/h5a-grovel.lisp"
                                        "hdf-cffi/src/h5d-grovel.lisp"
                                        "hdf-cffi/src/h5f-grovel.lisp"
                                        "hdf-cffi/src/h5g-grovel.lisp"
                                        "hdf-cffi/src/h5i-grovel.lisp"
                                        "hdf-cffi/src/h5l-grovel.lisp"
                                        "hdf-cffi/src/h5o-grovel.lisp"
                                        "hdf-cffi/src/h5p-grovel.lisp"
                                        "hdf-cffi/src/h5pl-grovel.lisp"
                                        "hdf-cffi/src/h5r-grovel.lisp"
                                        "hdf-cffi/src/h5s-grovel.lisp"
                                        "hdf-cffi/src/h5t-grovel.lisp"
                                        "hdf-cffi/src/h5z-grovel.lisp")
                       (("_H5private_H")
                        "H5private_H")))))))
      (synopsis "Common Lisp data analysis library")
      (description
       "CL-ANA is a data analysis library in Common Lisp providing tabular and
binned data analysis along with nonlinear least squares fitting and
visualization.")
      (home-page "https://github.com/ghollisjr/cl-ana")
      (license license:gpl3))))

(define-public cl-ana
  (sbcl-package->cl-source-package sbcl-cl-ana))

(define-public sbcl-cl-annot
  (let ((commit "c99e69c15d935eabc671b483349a406e0da9518d")
        (revision "1"))
    (package
      (name "sbcl-cl-annot")
      (version (git-version "0.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/m2ym/cl-annot")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "1wq1gs9jjd5m6iwrv06c2d7i5dvqsfjcljgbspfbc93cg5xahk4n"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-alexandria))
      (home-page "https://github.com/m2ym/cl-annot")
      (synopsis "Python-like Annotation Syntax for Common Lisp")
      (description
       "@code{cl-annot} is an general annotation library for Common Lisp.")
      (license license:llgpl))))

(define-public cl-annot
  (sbcl-package->cl-source-package sbcl-cl-annot))

(define-public ecl-cl-annot
  (sbcl-package->ecl-package sbcl-cl-annot))

(define-public clasp-cl-annot
  (sbcl-package->clasp-package sbcl-cl-annot))

(define-public sbcl-cl-ansi-text
  (let ((commit "8b129d83c7511b54cdd9d4123825a2d06349b25c"))
    (package
      (name "sbcl-cl-ansi-text")
      (version (git-version "2.0.1" "1" commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/pnathan/cl-ansi-text")
               (commit commit)))
         (sha256
          (base32
           "0nk7ajqfa937w1iy3zy86jjbw8yffm05cqs4wxkgl97v6kmmya14"))
         (file-name (git-file-name "cl-ansi-text" version))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-alexandria sbcl-cl-colors2))
      (native-inputs
       (list sbcl-fiveam))
      (synopsis "ANSI terminal color implementation for Common Lisp")
      (description
       "@command{cl-ansi-text} provides utilities which enable printing to an
ANSI terminal with colored text.  It provides the macro @command{with-color}
which causes everything printed in the body to be displayed with the provided
color.  It further provides functions which will print the argument with the
named color.")
      (home-page "https://github.com/pnathan/cl-ansi-text")
      (license license:llgpl))))

(define-public cl-ansi-text
  (sbcl-package->cl-source-package sbcl-cl-ansi-text))

(define-public ecl-cl-ansi-text
  (sbcl-package->ecl-package sbcl-cl-ansi-text))

(define-public sbcl-cl-ascii-table
  (let ((commit "d9f5e774a56fad1b416e4dadb8f8a5b0e84094e2")
        (revision "1"))
    (package
      (name "sbcl-cl-ascii-table")
      (version (git-version "0.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/telephil/cl-ascii-table")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "125fdif9sgl7k0ngjhxv0wjas2q27d075025hvj2rx1b1x948z4s"))))
      (build-system asdf-build-system/sbcl)
      (synopsis "Library to make ascii-art tables")
      (description
       "This is a Common Lisp library to present tabular data in ascii-art
tables.")
      (home-page "https://github.com/telephil/cl-ascii-table")
      (license license:expat))))

(define-public cl-ascii-table
  (sbcl-package->cl-source-package sbcl-cl-ascii-table))

(define-public ecl-cl-ascii-table
  (sbcl-package->ecl-package sbcl-cl-ascii-table))

(define-public clasp-cl-ascii-table
  (sbcl-package->clasp-package sbcl-cl-ascii-table))

(define-public sbcl-cl-async
  (let ((commit "f6423e44404a44434d803605e0d2e17199158e28")
        (revision "1"))
    (package
      (name "sbcl-cl-async")
      (version (git-version "0.6.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/orthecreedence/cl-async")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "11xi9dxb8mjgwzrkj88i0xkgk26z9w9ddxzbv6xsvfc1d4x5cf4x"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       `(("babel" ,sbcl-babel)
         ("bordeaux-threads" ,sbcl-bordeaux-threads)
         ("cffi" ,sbcl-cffi)
         ("cl-libuv" ,sbcl-cl-libuv)
         ("cl-ppcre" ,sbcl-cl-ppcre)
         ("fast-io" ,sbcl-fast-io)
         ("openssl" ,openssl)
         ("static-vectors" ,sbcl-static-vectors)
         ("trivial-features" ,sbcl-trivial-features)
         ("trivial-gray-streams" ,sbcl-trivial-gray-streams)
         ("vom" ,sbcl-vom)))
      (arguments
       `(#:asd-systems '("cl-async"
                         "cl-async-repl"
                         "cl-async-ssl")
         #:phases
         (modify-phases %standard-phases
           (add-after 'unpack 'fix-paths
             (lambda* (#:key inputs #:allow-other-keys)
               (substitute* "src/ssl/package.lisp"
                 (("libcrypto\\.so")
                  (search-input-file inputs "/lib/libcrypto.so"))
                 (("libssl\\.so")
                  (search-input-file inputs "/lib/libssl.so"))))))))
      (synopsis "Asynchronous operations for Common Lisp")
      (description
       "Cl-async is a library for general purpose, non-blocking programming in
Common Lisp.  It uses the libuv library as backend.")
      (home-page "https://orthecreedence.github.io/cl-async/")
      (license license:expat))))

(define-public cl-async
  (sbcl-package->cl-source-package sbcl-cl-async))

(define-public ecl-cl-async
  (sbcl-package->ecl-package sbcl-cl-async))

(define-public sbcl-cl-async-future
  (let ((commit "ee36c22a69a9516407458d2ed8b475f1fc473959")
        (revision "1"))
    (package
      (name "sbcl-cl-async-future")
      (version (git-version "0.4.4.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/orthecreedence/cl-async-future")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "0z0sc7qlzzxk99f4l26zp6rai9kv0kj0f599sxai5s44p17zbbvh"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-blackbird))
      (native-inputs
       (list sbcl-cl-async sbcl-eos))
      (synopsis "Futures implementation for Common Lisp")
      (description
       "This is futures implementation for Common Lisp.  It plugs in nicely
to cl-async.")
      (home-page "https://orthecreedence.github.io/cl-async/future")
      (license license:expat))))

(define-public cl-async-future
  (sbcl-package->cl-source-package sbcl-cl-async-future))

(define-public ecl-cl-async-future
  (sbcl-package->ecl-package sbcl-cl-async-future))

(define libasyncprocess
  (let ((commit "3b16b91d417530dac03559980fb5703206e20c55")
        (revision "2"))
    (package
      (name "libasyncprocess")
      (version (git-version "0.0.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/lem-project/async-process")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "0ykbkmcf46rgiphsb8c03xf9l4l23xn1rppm51mviz7brs0zx7g4"))
         (modules '((guix build utils)))
         (snippet
          ;; Delete precompiled artifacts.
          `(begin
             (for-each delete-file-recursively
                       (list "static"
                             "static_old0001-819cbf6"))))))
      (build-system gnu-build-system)
      (arguments
       (list
        #:phases
        #~(modify-phases %standard-phases
            (replace 'bootstrap
              (lambda _
                (invoke "libtoolize")
                (invoke "aclocal")
                (invoke "autoheader")
                (invoke "automake" "-a")
                (invoke "autoconf"))))))
      (native-inputs (list autoconf automake libtool))
      (home-page "https://github.com/lem-project/async-process")
      (synopsis "C library component for @code{cl-async-process}")
      (description
       "This package provides the C library component for @code{cl-async-process}.")
      (license license:expat))))

(define-public sbcl-async-process
  (package
    (inherit libasyncprocess)
    (name "sbcl-async-process")
    (build-system asdf-build-system/sbcl)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'fix-paths
            (lambda* (#:key inputs #:allow-other-keys)
              (substitute* "src/async-process.lisp"
                (("libasyncprocess\\.so")
                 (search-input-file inputs
                                    "/lib/async-process/libasyncprocess.so"))))))))
    (inputs
     (modify-inputs (package-inputs libasyncprocess)
       (prepend libasyncprocess sbcl-cffi)))
    (home-page "https://github.com/lem-project/async-process")
    (synopsis "Asynchronous process execution for Common Lisp")
    (description "This library provides an asynchronous process
execution mechanism for Common Lisp.")))

(define-public cl-async-process
  (sbcl-package->cl-source-package sbcl-async-process))

(define-public ecl-async-process
  (sbcl-package->ecl-package sbcl-async-process))

(define-public sbcl-cl-autowrap
  (let ((revision "3")
        (commit "4bba9e37b59cd191dea150a89aef7245a40b1c9d"))
    ;; no tagged branches
    (package
      (name "sbcl-cl-autowrap")
      (version (git-version "1.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/rpav/cl-autowrap")
               (commit commit)))
         (file-name (git-file-name "cl-autowrap" version))
         (sha256
          (base32 "1sfvhyrwm9dhxi0y42xp7mx8mvs6lmq3bzxdx34frxni5srcgly0"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list libffi
             sbcl-alexandria
             sbcl-cffi
             sbcl-cl-json
             sbcl-cl-ppcre
             sbcl-defpackage-plus
             sbcl-trivial-features))
      (arguments
       (list #:asd-systems ''("cl-autowrap" "cl-plus-c" "cl-autowrap/libffi")
             #:phases
             #~(modify-phases %standard-phases
                 (add-after 'unpack 'fix-paths
                   (lambda* (#:key inputs #:allow-other-keys)
                     (substitute* "autowrap-libffi/library.lisp"
                       (("libffi.so")
                        (search-input-file inputs "lib/libffi.so"))))))))
      (home-page "https://github.com/rpav/cl-autowrap")
      (synopsis "FFI wrapper generator for Common Lisp")
      (description "This is a c2ffi-based wrapper generator for Common Lisp.")
      (license license:bsd-2))))

(define-public cl-autowrap
  (sbcl-package->cl-source-package sbcl-cl-autowrap))

(define-public ecl-cl-autowrap
  (sbcl-package->ecl-package sbcl-cl-autowrap))

(define-public sbcl-cl-base16
  (let ((commit "ae4b7f416c0c91f6323e901be912c0f7378fe3da")
        (revision "0"))
    (package
      (name "sbcl-cl-base16")
      (version (git-version "0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/tpine/cl-base16")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "0m7ndmk4xhizn3q3ywjvw8sg4pfgp6lrd0wac5d1bf7wbw6afh5q"))))
      (build-system asdf-build-system/sbcl)
      (arguments
       (list
        #:phases
        #~(modify-phases %standard-phases
            (add-after 'unpack 'patch-git-executable
              (lambda* (#:key inputs #:allow-other-keys)
                (substitute* "builder.lisp"
                  (("\"git")
                   (string-append "\"" (search-input-file inputs
                                                          "/bin/git")))))))))
      (inputs
       (list git
             sbcl-cl-yaml
             sbcl-cl-mustache
             sbcl-cl-slug
             sbcl-trivial-shell))
      (synopsis "Common Lisp base 16 implementation")
      (description
       "This package provides an implementation of a base 16 builder for Common Lisp.")
      (home-page "https://github.com/tpine/cl-base16")
      (license license:gpl3+))))

(define-public cl-base16
  (sbcl-package->cl-source-package sbcl-cl-base16))

(define-public ecl-cl-base16
  (sbcl-package->ecl-package sbcl-cl-base16))

(define-public sbcl-cl-base32
  (let ((commit "8cdee06fab397f7b0a19583b57e7f0c98405be85")
        (revision "1"))
    (package
      (name "sbcl-cl-base32")
      (version (git-version "0.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/hargettp/cl-base32")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "17jrng8jb05d64ggyd11hp308c2fl5drvf9g175blgrkkl8l4mf8"))))
      (build-system asdf-build-system/sbcl)
      (native-inputs
       (list sbcl-lisp-unit))
      (synopsis "Common Lisp library for base32 encoding and decoding")
      (description
       "This package provides functions for base32 encoding and decoding as
defined in RFC4648.")
      (home-page "https://github.com/hargettp/cl-base32")
      (license license:expat))))

(define-public cl-base32
  (sbcl-package->cl-source-package sbcl-cl-base32))

(define-public ecl-cl-base32
  (sbcl-package->ecl-package sbcl-cl-base32))

(define-public sbcl-cl-base58
  (let ((commit "f446835b4104896e0eed6a61d2ceb4ad22f589d8")
        (revision "1"))
    (package
      (name "sbcl-cl-base58")
      (version (git-version "0.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/eudoxia0/cl-base58/")
               (commit commit)))
         (file-name (git-file-name "cl-base58" version))
         (sha256
          (base32 "01wiiyz1jzxx3zhxi2hpq5n8hv28g1mn0adk793vwjzh4v5bi5zz"))))
      (build-system asdf-build-system/sbcl)
      (arguments
       '(#:asd-systems '("cl-base58-test" "cl-base58")
         #:phases
         (modify-phases %standard-phases
           (add-after 'unpack 'fix-tests
             (lambda _
               (substitute* "cl-base58-test.asd"
                 (("cl-test-more")
                  "prove"))
               #t)))))
      (native-inputs
       (list sbcl-prove))
      (home-page "https://github.com/eudoxia0/cl-base58")
      (synopsis "Implementation of base58 for Common Lisp")
      (description
       "This library implements the @code{base58} encoding algorithm.  It's
basically @code{base64} but with a smaller alphabet (58, as in the name) that
doesn't include similar looking characters, among other things.  See
@url{https://github.com/bitcoin/bitcoin/blob/master/src/base58.h} for a full
reference.")
      (license license:expat))))

(define-public cl-base58
  (sbcl-package->cl-source-package sbcl-cl-base58))

(define-public ecl-cl-base58
  (sbcl-package->ecl-package sbcl-cl-base58))

(define-public sbcl-cl-base64
  (let ((commit "577683b18fd880b82274d99fc96a18a710e3987a"))
    (package
      (name "sbcl-cl-base64")
      (version (git-version "3.3.4" "1" commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "http://git.kpe.io/cl-base64.git/")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "12jj54h0fs6n237cvnp8v6hn0imfksammq22ys6pi0gwz2w47rbj"))
         (modules '((guix build utils)))
         (snippet
          ;; The useless bundled debian folder drags `make' into the closure.
          `(begin
             (delete-file-recursively "debian")
             #t))))
      (build-system asdf-build-system/sbcl)
      (native-inputs                    ; For tests.
       (list sbcl-ptester sbcl-kmrcl))
      (home-page "http://files.kpe.io/cl-base64/")
      (synopsis
       "Common Lisp package to encode and decode base64 with URI support")
      (description
       "This package provides highly optimized base64 encoding and decoding.
Besides conversion to and from strings, integer conversions are supported.
Encoding with Uniform Resource Identifiers is supported by using a modified
encoding table that uses only URI-compatible characters.")
      (license license:bsd-3))))

(define-public cl-base64
  (sbcl-package->cl-source-package sbcl-cl-base64))

(define-public ecl-cl-base64
  (sbcl-package->ecl-package sbcl-cl-base64))

(define-public sbcl-cl-bnf
  (let ((commit "ce009e3d60697bc376116e988f29ec0cbb1e9c84")
        (revision "0"))
    (package
      (name "sbcl-cl-bnf")
      (version (git-version "0.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/diasbruno/cl-bnf")
               (commit commit)))
         (file-name (git-file-name "cl-bnf" version))
         (sha256
          (base32 "0aa7hnkj71f37lxzlhsppwcmk3yv42hclq08c4jrdnv8jmdb8r0l"))))
      (build-system asdf-build-system/sbcl)
      (inputs (list sbcl-flexi-streams sbcl-utf8-input-stream))
      (home-page "https://github.com/diasbruno/cl-bnf")
      (synopsis "BNF parser in Common Lisp")
      (description "This package provides a @acronym{BNF, Backus–Naur form}
parser in Common Lisp.")
      (license (list license:expat)))))

(define-public cl-bnf
  (sbcl-package->cl-source-package sbcl-cl-bnf))

(define-public ecl-cl-bnf
  (sbcl-package->ecl-package sbcl-cl-bnf))

(define-public sbcl-cl-cairo2
  (let ((commit "41ae45aac86553c46f4bb460f80e1fb620930f5b")
        (revision "1"))
    (package
      (name "sbcl-cl-cairo2")
      (version (git-version "0.6" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/rpav/cl-cairo2")
               (commit commit)))
         (file-name (git-file-name "cl-cairo2" version))
         (sha256
          (base32 "0cpfgyxw6pz7y033dlya8c4vjmkpw127zdq3a9xclp9q8jbdlb7q"))))
      (build-system asdf-build-system/sbcl)
      (arguments
       `(#:asd-systems '(;; "cl-cairo2-gtk2" ; cl-gtk2 is not packed and quite old.
                         ;; "cl-cairo2-quartz" ; Failing when enabled.
                         ;; "cl-cairo2-xlib" ; cl-xcb-xlib is not packed yet and quite old.
                         ;; "cl-cairo2-xcb"
                         "cl-cairo2")
         #:phases
         (modify-phases %standard-phases
           (add-after 'unpack 'fix-paths
             (lambda* (#:key inputs #:allow-other-keys)
               (substitute* "src/load-libraries.lisp"
                 (("libcairo.so.2")
                  (search-input-file inputs "/lib/libcairo.so.2"))))))))
      (inputs
       (list cairo
             sbcl-cffi
             sbcl-cl-colors
             sbcl-cl-freetype2
             sbcl-cl-utilities
             sbcl-metabang-bind
             sbcl-trivial-features
             sbcl-trivial-garbage))
      (home-page "https://github.com/rpav/cl-cairo2")
      (synopsis "Cairo bindings for Common Lisp")
      (description
       "This package provides CFFI bindings for Common Lisp to the Cairo
C library.")
      (license license:boost1.0))))

(define-public cl-cairo2
  (sbcl-package->cl-source-package sbcl-cl-cairo2))

(define-public ecl-cl-cairo2
  (sbcl-package->ecl-package sbcl-cl-cairo2))

(define-public sbcl-cl-cffi-gtk
  (let ((commit "1700fe672c65455c1fc33061ec92a3df84287ec7")
        (revision "3"))
    (package
      (name "sbcl-cl-cffi-gtk")
      (version (git-version "3.8.8" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/sharplispers/cl-cffi-gtk/")
               (commit commit)))
         (file-name (git-file-name "cl-cffi-gtk" version))
         (sha256
          (base32 "1cn2f6b62axjzdzfv971218ably32dvqfdy499li25vjd8nb2qm3"))))
      (build-system asdf-build-system/sbcl)
      (native-inputs
       (list sbcl-fiveam))
      (inputs
       (list cairo
             gdk-pixbuf
             glib
             gtk+
             pango
             sbcl-bordeaux-threads
             sbcl-cffi
             sbcl-closer-mop
             sbcl-iterate
             sbcl-trivial-features
             sbcl-trivial-garbage))
      (arguments
       (list
        ;; TODO: Tests fail with memory fault.
        ;; See https://github.com/Ferada/cl-cffi-gtk/issues/24.
        #:tests? #f
        #:phases
        #~(modify-phases %standard-phases
            (add-after 'unpack 'fix-paths
              (lambda* (#:key inputs #:allow-other-keys)
                (substitute* "glib/glib.init.lisp"
                  (("libglib-[0-9.]*\\.so" all)
                   (search-input-file inputs (string-append "/lib/" all)))
                  (("libgthread-[0-9.]*\\.so" all)
                   (search-input-file inputs (string-append "/lib/" all))))
                (substitute* "gobject/gobject.init.lisp"
                  (("libgobject-[0-9.]*\\.so" all)
                   (search-input-file inputs (string-append "/lib/" all))))
                (substitute* "gio/gio.init.lisp"
                  (("libgio-[0-9.]*\\.so" all)
                   (search-input-file inputs (string-append "/lib/" all))))
                (substitute* "cairo/cairo.init.lisp"
                  (("libcairo\\.so" all)
                   (search-input-file inputs (string-append "/lib/" all))))
                (substitute* "pango/pango.init.lisp"
                  (("libpango-[0-9.]*\\.so" all)
                   (search-input-file inputs (string-append "/lib/" all)))
                  (("libpangocairo-[0-9.]*\\.so" all)
                   (search-input-file inputs (string-append "/lib/" all))))
                (substitute* "gdk-pixbuf/gdk-pixbuf.init.lisp"
                  (("libgdk_pixbuf-[0-9.]*\\.so" all)
                   (search-input-file inputs (string-append "/lib/" all))))
                (substitute* "gdk/gdk.init.lisp"
                  (("libgdk-[0-9]\\.so" all)
                   (search-input-file inputs (string-append "/lib/" all))))
                (substitute* "gdk/gdk.package.lisp"
                  (("libgtk-[0-9]\\.so" all)
                   (search-input-file inputs (string-append "/lib/" all)))))))))
      (home-page "https://github.com/sharplispers/cl-cffi-gtk/")
      (synopsis "Common Lisp binding for GTK+3")
      (description
       "@command{cl-cffi-gtk} is a Lisp binding to GTK+ 3 (GIMP Toolkit) which
is a library for creating graphical user interfaces.")
      (license license:lgpl3))))

(define-public cl-cffi-gtk
  (sbcl-package->cl-source-package sbcl-cl-cffi-gtk))

(define-public ecl-cl-cffi-gtk
  (sbcl-package->ecl-package sbcl-cl-cffi-gtk))

(define-public sbcl-cl-change-case
  (let ((commit "45c70b601125889689e0c1c37d7e727a3a0af022")
        (revision "1"))
    (package
      (name "sbcl-cl-change-case")
      (version (git-version "0.2.0" revision commit))
      (home-page "https://github.com/rudolfochrist/cl-change-case")
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url home-page)
               (commit commit)))
         (file-name (git-file-name "cl-change-case" version))
         (sha256
          (base32 "0qmk341zzcsbf8sq0w9ix3r080zg4ri6vzxym63lhdjfzwz3y8if"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-cl-ppcre sbcl-cl-ppcre-unicode))
      (native-inputs
       (list sbcl-fiveam))
      (synopsis
       "Convert Common Lisp strings between camelCase, PascalCase and more")
      (description
       "@code{cl-change-case} is a library to convert strings between
camelCase, PascalCase, snake_case, param-case, CONSTANT_CASE and more.")
      (license license:llgpl))))

(define-public cl-change-case
  (sbcl-package->cl-source-package sbcl-cl-change-case))

(define-public ecl-cl-change-case
  (sbcl-package->ecl-package sbcl-cl-change-case))

(define-public sbcl-cl-charms
  (let ((commit "64aba59d89f85bc5c9402e445873965338a66a02")
        (revision "1"))
    (package
      (name "sbcl-cl-charms")
      (version (git-version "0.2.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/HiTECNOLOGYs/cl-charms")
               (commit commit)))
         (file-name (git-file-name "cl-charms" version))
         (sha256
          (base32 "1jczaypa9dhxr34yyhsxb6lrdnircjx8am4iqkc3shfpjn32q323"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       `(("alexandria" ,sbcl-alexandria)
         ("cffi" ,sbcl-cffi)
         ("ncurses" ,ncurses)))
      (arguments
       '(#:phases
         (modify-phases %standard-phases
           (add-after 'unpack 'fix-paths
             (lambda* (#:key inputs #:allow-other-keys)
               (substitute* "src/low-level/curses-bindings.lisp"
                 (("libncursesw.so")
                  (string-append (assoc-ref inputs "ncurses")
                                 "/lib/libncursesw.so"))))))))
      (home-page "https://github.com/HiTECNOLOGYs/cl-charms")
      (synopsis "Interface to libcurses in Common Lisp")
      (description
       "@code{cl-charms} is an interface to libcurses in Common Lisp.  It
provides both a raw, low-level interface to libcurses via CFFI, and a more
higher-level lispier interface.")
      (license license:expat))))

(define-public cl-charms
  (sbcl-package->cl-source-package sbcl-cl-charms))

(define-public ecl-cl-charms
  (sbcl-package->ecl-package sbcl-cl-charms))

(define-public sbcl-cl-collider
  (let ((commit "7e0ebb0756dda0a34401abafcd5ee22e043ce4c4")
        (revision "1"))
    (package
     (name "sbcl-cl-collider")
     (version (git-version "2025-08-18" revision commit))
     (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/byulparan/cl-collider")
               (commit commit)))
         (file-name (git-file-name "cl-collider" version))
         (sha256
          (base32 "19i8fn7l5gm9k0ypb9kpn919hv86swdq2426vg4vb2r13h49b6vm"))))
     (build-system asdf-build-system/sbcl)
     (arguments
       (list #:phases
             #~(modify-phases %standard-phases
                 (add-after 'unpack 'patch-executables-and-paths
                   (lambda* (#:key inputs #:allow-other-keys)
                     (substitute* "server.lisp"
                       (("/usr/local/lib/SuperCollider/plugins")
                        (search-input-directory
                         inputs "/lib/SuperCollider/plugins"))
                       (("which scsynth")
                        (string-append
                         "which "
                         (search-input-file inputs "/bin/scsynth")))
                       (("jack_connect")
                        (search-input-file inputs "/bin/jack_connect"))))))))
     (inputs
       (list jack-1
             supercollider
             sbcl-alexandria
             sbcl-bordeaux-threads
             sbcl-cffi
             sbcl-cl-ppcre
             sbcl-flexi-streams
             sbcl-ieee-floats ; sc-osc dependencies.
             sbcl-named-readtables
             sbcl-osc
             sbcl-pileup
             sbcl-simple-inferiors ; For ecl.
             sbcl-split-sequence
             sbcl-usocket))
     (synopsis "SuperCollider client for CommonLisp")
     (description "This package provides a SuperCollider client for
Common Lisp.")
     (home-page "https://github.com/byulparan/cl-collider/")
     (license license:public-domain))))

(define-public cl-collider
  (sbcl-package->cl-source-package sbcl-cl-collider))

(define-public ecl-cl-collider
  (sbcl-package->ecl-package sbcl-cl-collider))

(define-public sbcl-cl-colors
  (let ((commit "827410584553f5c717eec6182343b7605f707f75"))
    (package
      (name "sbcl-cl-colors")
      (version (git-version "0.0.0" "1" commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/tpapp/cl-colors")
               (commit commit)))
         (sha256
          (base32
           "0l446lday4hybsm9bq3jli97fvv8jb1d33abg79vbylpwjmf3y9a"))
         (file-name (git-file-name "cl-colors" version))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-alexandria sbcl-let-plus))
      (synopsis "Simple color library for Common Lisp")
      (description
       "This is a very simple color library for Common Lisp, providing

@itemize
@item Types for representing colors in HSV and RGB spaces.
@item Simple conversion functions between the above types (and also
hexadecimal representation for RGB).
@item Some predefined colors (currently X11 color names – of course the
library does not depend on X11).Because color in your terminal is nice.
@end itemize

This library is no longer supported by its author.")
      (home-page "https://github.com/tpapp/cl-colors")
      (license license:boost1.0))))

(define-public cl-colors
  (sbcl-package->cl-source-package sbcl-cl-colors))

(define-public ecl-cl-colors
  (sbcl-package->ecl-package sbcl-cl-colors))

(define-public sbcl-cl-colors-ng
  (package
    (name "sbcl-cl-colors-ng")
    (version "0.0.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://codeberg.org/cage/cl-colors-ng.git")
             (commit "310e6495e2658d33a7500455fd461074748ef805")))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "0lnrawzygxzb9yp1bsjwwlyyp0axms5f5rv0aa4nlhxh5syv5fg8"))))
    (build-system asdf-build-system/sbcl)
    (native-inputs
     (list sbcl-clunit2))
    (inputs
     (list sbcl-alexandria
           sbcl-cl-ppcre
           sbcl-parse-number))
    (synopsis "Simple color library for Common Lisp")
    (description "Simple color library for Common Lisp.")
    (license license:boost1.0)
    (home-page "https://codeberg.org/cage/cl-colors-ng.git")))

(define-public ecl-cl-colors-ng
  (sbcl-package->ecl-package sbcl-cl-colors-ng))

(define-public cl-colors-ng
  (sbcl-package->cl-source-package sbcl-cl-colors-ng))

(define-public sbcl-cl-colors2
  (package
    (name "sbcl-cl-colors2")
    (version "0.6.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://codeberg.org/cage/cl-colors2")
             (commit (string-append "v" version))))
       (file-name (git-file-name "cl-colors2" version))
       (sha256
        (base32 "053bidgbqziv5visdq09gy8zf30cvqh1w06l23yygn1yrg7m7302"))))
    (build-system asdf-build-system/sbcl)
    (native-inputs
     (list sbcl-clunit2))
    (inputs
     (list sbcl-alexandria sbcl-cl-ppcre sbcl-parse-number))
    (synopsis "Color library for Common Lisp")
    (description
     "This is a very simple color library for Common Lisp, providing:

@itemize
@item Types for representing colors in HSV, HSL, and RGB spaces.
@item Simple conversion functions between the above types.
@item Function printing colors to HEX, RGB, RGBA, and HSL.
@item Predefined colors from X11, SVG, and GDK.
@end itemize\n")
    (home-page "https://codeberg.org/cage/cl-colors2")
    (license license:boost1.0)))

(define-public cl-colors2
  (sbcl-package->cl-source-package sbcl-cl-colors2))

(define-public ecl-cl-colors2
  (sbcl-package->ecl-package sbcl-cl-colors2))

(define-public clasp-cl-colors2
  (sbcl-package->clasp-package sbcl-cl-colors2))

(define-public sbcl-cl-conspack
  (let ((commit "6e529d7b3a7223ef1bb5c7b9f18384ba67b50b09")
        (revision "2"))
    (package
     (name "sbcl-cl-conspack")
     (version (git-version "0.0.0" revision commit))
     (source
      (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/conspack/cl-conspack")
             (commit commit)))
       (file-name (git-file-name "cl-conspack" version))
       (sha256
        (base32 "0y5wp5c89ph44k2xjppy1c1jf2ac3q9yrk22da2rkwnbxn0h1a8d"))))
     (build-system asdf-build-system/sbcl)
     (arguments
      '(#:asd-test-systems '("cl-conspack-test")))
     (native-inputs
      (list sbcl-fiveam))
     (inputs
       (list sbcl-alexandria
             sbcl-closer-mop
             sbcl-fast-io
             sbcl-ieee-floats
             sbcl-trivial-garbage
             sbcl-trivial-utf-8))
     (home-page "https://github.com/conspack/cl-conspack")
     (synopsis "CONSPACK implementation for Common Lisp")
     (description
      "This package provides a CONSPACK implementation for Common Lisp.")
     (license license:bsd-3))))

(define-public cl-conspack
  (sbcl-package->cl-source-package sbcl-cl-conspack))

(define-public ecl-cl-conspack
  (sbcl-package->ecl-package sbcl-cl-conspack))

(define-public sbcl-cl-cont
  (let ((commit "fc1fa7e6eb64894fdca13e688e6015fad5290d2a")
        (revision "1"))
    (package
      (name "sbcl-cl-cont")
      (version (git-version "0.3.8" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://gitlab.common-lisp.net/cl-cont/cl-cont.git")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "1zf8zvb0i6jm3hhfks4w74hibm6avgc6f9s1qwgjrn2bcik8lrvz"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-alexandria sbcl-closer-mop))
      (native-inputs
       (list sbcl-rt))
      (synopsis "Delimited continuations for Common Lisp")
      (description
       "This is a library that implements delimited continuations by
transforming Common Lisp code to continuation passing style.")
      (home-page "https://common-lisp.net/project/cl-cont/")
      (license license:llgpl))))

(define-public cl-cont
  (sbcl-package->cl-source-package sbcl-cl-cont))

(define-public ecl-cl-cont
  (sbcl-package->ecl-package sbcl-cl-cont))

(define-public clasp-cl-cont
  (sbcl-package->clasp-package sbcl-cl-cont))

(define-public sbcl-cl-containers
  (let ((commit "781ebfe0888bae46f07c018f7d473898b1bd4f5f")
        (revision "4"))
    (package
      (name "sbcl-cl-containers")
      (version (git-version "0.12.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/hraban/cl-containers")
               (commit commit)))
         (file-name (git-file-name "cl-containers" version))
         (sha256
          (base32
           "1nrql8s1j123v5gscy99lxvhlzp0ijig9x94w30v3lwfa58hf90l"))))
      (build-system asdf-build-system/sbcl)
      (native-inputs
       (list sbcl-lift))
      (inputs
       (list sbcl-asdf-system-connections
             sbcl-metatilities-base
             sbcl-moptilities))
      (arguments
       '(#:asd-systems '("cl-containers"
                         "cl-containers/with-moptilities"
                         "cl-containers/with-utilities")
         #:phases
         (modify-phases %standard-phases
           (add-after 'unpack 'relax-version-checks
             (lambda _
               (substitute* "cl-containers.asd"
                 (("\\(:version \"metatilities-base\" \"0\\.6\\.6\"\\)")
                  "\"metatilities-base\""))
               (substitute* "cl-containers-test.asd"
                 (("\\(:version \"lift\" \"1\\.7\\.0\"\\)")
                  "\"lift\""))
               #t)))))
      (synopsis "Container library for Common Lisp")
      (description
       "Common Lisp ships with a set of powerful built in data structures
including the venerable list, full featured arrays, and hash-tables.
CL-containers enhances and builds on these structures by adding containers
that are not available in native Lisp (for example: binary search trees,
red-black trees, sparse arrays and so on), and by providing a standard
interface so that they are simpler to use and so that changing design
decisions becomes significantly easier.")
      (home-page "https://common-lisp.net/project/cl-containers/")
      (license license:expat))))

(define-public cl-containers
  (sbcl-package->cl-source-package sbcl-cl-containers))

(define-public ecl-cl-containers
  (sbcl-package->ecl-package sbcl-cl-containers))

(define-public sbcl-cl-cookie
  (let ((commit "cea55aed8b9ad25fafd13defbcb9fe8f41b29546")
        (revision "1"))
    (package
      (name "sbcl-cl-cookie")
      (build-system asdf-build-system/sbcl)
      (version (git-version "0.9.10" revision commit))
      (home-page "https://github.com/fukamachi/cl-cookie")
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url home-page)
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "090g7z75h98zvc1ldx0vh4jn4086dhjm2w30jcwkq553qmyxwl8h"))))
      (inputs
       `(("proc-parse" ,sbcl-proc-parse)
         ("alexandria" ,sbcl-alexandria)
         ("quri" ,sbcl-quri)
         ("cl-ppcre" ,sbcl-cl-ppcre)
         ("local-time" ,sbcl-local-time)))
      (native-inputs
       (list sbcl-prove))
      (arguments
       '(#:asd-systems '("cl-cookie-test" "cl-cookie")))
      (synopsis "HTTP cookie manager for Common Lisp")
      (description "cl-cookie is a Common Lisp library featuring parsing of
cookie headers, cookie creation, cookie jar creation and more.")
      (license license:bsd-2))))

(define-public cl-cookie
  (sbcl-package->cl-source-package sbcl-cl-cookie))

(define-public ecl-cl-cookie
  (sbcl-package->ecl-package sbcl-cl-cookie))

(define-public sbcl-cl-coroutine
  (let ((commit "de098f8d5debd8b14ef6864b5bdcbbf5ddbcfd72")
        (revision "1"))
    (package
      (name "sbcl-cl-coroutine")
      (version (git-version "0.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/takagi/cl-coroutine")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "1cqdhdjxffgfs116l1swjlsmcbly0xgcgrckvaajd566idj9yj4l"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       `(("alexandria" ,sbcl-alexandria)
         ("cl-cont" ,sbcl-cl-cont)))
      (native-inputs
       (list sbcl-prove))
      (arguments
       `(;; TODO: Fix the tests. They fail with:
         ;; "Component CL-COROUTINE-ASD::CL-COROUTINE-TEST not found"
         #:tests? #f
         #:phases
         (modify-phases %standard-phases
           (add-after 'unpack 'fix-tests
             (lambda _
               (substitute* "cl-coroutine-test.asd"
                 (("cl-test-more")
                  "prove"))
               #t)))))
      (synopsis "Coroutine library for Common Lisp")
      (description
       "This is a coroutine library for Common Lisp implemented using the
continuations of the @code{cl-cont} library.")
      (home-page "https://github.com/takagi/cl-coroutine")
      (license license:llgpl))))

(define-public cl-coroutine
  (sbcl-package->cl-source-package sbcl-cl-coroutine))

(define-public ecl-cl-coroutine
  (sbcl-package->ecl-package sbcl-cl-coroutine))

(define-public sbcl-cl-cpus
  (package
    (name "sbcl-cl-cpus")
    (version "0.0.3")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/muyinliu/cl-cpus")
             (commit (string-append "v" version))))
       (file-name (git-file-name "cl-cpus" version))
       (sha256
        (base32 "0sdaff9hpsx7bpkkkqavmxmrrlc2d61gmqjjgn8xchncng4a0rf8"))))
    (build-system asdf-build-system/sbcl)
    (inputs
     (list sbcl-cffi))
    (home-page "https://github.com/muyinliu/cl-cpus")
    (synopsis "Common Lisp feature to get number of CPUs")
    (description
     "This package provides a Common Lisp system which has only one function to
return the CPU count of the current system.")
    (license license:isc)))

(define-public cl-cpus
  (sbcl-package->cl-source-package sbcl-cl-cpus))

(define-public ecl-cl-cpus
  (sbcl-package->ecl-package sbcl-cl-cpus))

(define-public sbcl-cl-cron
  (let ((commit "092aef5d5666fb43c04258e4043f609670a20456")
        (revision "0"))
    (package
      (name "sbcl-cl-cron")
      (version (git-version "0.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/ciel-lang/cl-cron")
               (commit commit)))
         (file-name (git-file-name "cl-cron" version))
         (sha256
          (base32 "0y4li8j2h1nbpldpqm39ld9kgs4a7biy94h49n27l59l7mn1jd0d"))))
      (build-system asdf-build-system/sbcl)
      (inputs
        (list sbcl-bordeaux-threads))
      (home-page "https://github.com/ciel-lang/cl-cron/")
      (synopsis "Run cron like jobs in Common Lisp")
      (description
       "@code{cl-cron} is a simple tool that provides cron like facilities
directly inside of Common Lisp.")
      (license license:gpl3+))))

(define-public cl-cron
  (sbcl-package->cl-source-package sbcl-cl-cron))

(define-public ecl-cl-cron
  (sbcl-package->ecl-package sbcl-cl-cron))

(define-public sbcl-cl-css
  (let ((commit "8fe654c8f0cf95b300718101cce4feb517f78e2f"))
    (package
      (name "sbcl-cl-css")
      (version (git-version "0.1" "1" commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/inaimathi/cl-css/")
               (commit commit)))
         (file-name (git-file-name "cl-css" version))
         (sha256
          (base32
           "1lc42zi2sw11fl2589sc19nr5sd2p0wy7wgvgwaggxa5f3ajhsmd"))))
      (build-system asdf-build-system/sbcl)
      (home-page "https://github.com/inaimathi/cl-css/")
      (synopsis "Non-validating, inline CSS generator for Common Lisp")
      (description
       "This is a dead-simple, non validating, inline CSS generator for Common
Lisp.  Its goals are axiomatic syntax, simple implementation to support
portability, and boilerplate reduction in CSS.")
      (license license:expat))))

(define-public cl-css
  (sbcl-package->cl-source-package sbcl-cl-css))

(define-public ecl-cl-css
  (sbcl-package->ecl-package sbcl-cl-css))

(define-public sbcl-cl-csv
  (let ((commit "68ecb5d816545677513d7f6308d9e5e8d2265651")
        (revision "2"))
    (package
      (name "sbcl-cl-csv")
      (version (git-version "1.0.6" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/AccelerationNet/cl-csv")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "0gcmlbwx5m3kwgk12qi80w08ak8fgdnvyia429fz6gnxmhg0k54x"))))
      (build-system asdf-build-system/sbcl)
      (arguments
       ;; See: https://github.com/AccelerationNet/cl-csv/pull/34
       `(#:tests? #f))
      (inputs
       `(("alexandria" ,sbcl-alexandria)
         ("cl-interpol" ,sbcl-cl-interpol)
         ("iterate" ,sbcl-iterate)))
      (native-inputs
       (list sbcl-lisp-unit2))
      (synopsis "Common lisp library for comma-separated values")
      (description
       "This is a Common Lisp library providing functions to read/write CSV
from/to strings, streams and files.")
      (home-page "https://github.com/AccelerationNet/cl-csv")
      (license license:bsd-3))))

(define-public cl-csv
  (sbcl-package->cl-source-package sbcl-cl-csv))

(define-public ecl-cl-csv
  (sbcl-package->ecl-package sbcl-cl-csv))

(define-public sbcl-cl-data-structures
  (let ((commit "d11e589a3ddc6c32fcbd8be7e9f8e3471bc4d5dd")
        (revision "3"))
    (package
      (name "sbcl-cl-data-structures")
      (version (git-version "1.4.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/sirherrbatka/cl-data-structures")
               (commit commit)))
         (file-name (git-file-name "cl-data-structures" version))
         (sha256
          (base32 "12pdk3634nz51z4x2gly06h2j8bykqwxwfadsyq7r4ybzs3z8d73"))))
      (build-system asdf-build-system/sbcl)
      (native-inputs
       (list sbcl-prove))
      (inputs
       (list sbcl-alexandria
             sbcl-bordeaux-threads
             sbcl-cl-ppcre
             sbcl-closer-mop
             sbcl-documentation-utils-extensions
             sbcl-flexichain
             sbcl-iterate
             sbcl-lparallel
             sbcl-metabang-bind
             sbcl-more-conditions
             sbcl-serapeum
             sbcl-trivial-garbage))
      (synopsis "Data Structures and streaming algorithms for Common Lisp")
      (description
       "CL-DATA-STRUCTURES is a Common Lisp library providing a portable
collection of mutable and immutable data structures (dictionaries, sets,
queues, sequences) and algorithms.")
      (home-page "https://sirherrbatka.github.io/cl-data-structures/main.html")
      (license license:bsd-2))))

(define-public cl-data-structures
  (sbcl-package->cl-source-package sbcl-cl-data-structures))

(define-public ecl-cl-data-structures
  (sbcl-package->ecl-package sbcl-cl-data-structures))

(define-public sbcl-cl-debug
  (let ((commit "b334280806104ee7f7d3aec666bf7e08d2f89b31")
        (revision "1"))
    (package
     (name "sbcl-cl-debug")
      (version (git-version "1.0.0" revision commit))
     (source
      (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/kmx-io/cl-debug")
             (commit commit)))
       (file-name (git-file-name "cl-debug" version))
       (sha256
        (base32 "0w5vxbjsgr3zfpivdmghmhzxskfdvm1p34c8whwps2xlhypxsa78"))))
     (build-system asdf-build-system/sbcl)
     (home-page "https://github.com/kmx-io/cl-debug")
     (synopsis "Common Lisp cross-package debugging facility")
     (description
      "CL-DEBUG provides a unified way to enable or disable debug-specific code.
Debugging code can be enabled or disabled relative to program features denoted
by either a symbol or a keyword.")
     (license license:isc))))

(define-public cl-debug
  (sbcl-package->cl-source-package sbcl-cl-debug))

(define-public ecl-cl-debug
  (sbcl-package->ecl-package sbcl-cl-debug))

(define-public sbcl-cl-dejavu
  (let ((commit "9d68ced4edee6f96fead42cb4835d0ff4a158373")
        (revision "1"))
    (package
      (name "sbcl-cl-dejavu")
      (version (git-version "0.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/dkochmanski/cl-dejavu")
               (commit commit)))
         (file-name (git-file-name "cl-dejavu" version))
         (sha256
          (base32 "1lbxiq21bxj8r11c58cqskgn8gnl2p8q1ydkhdsv7i7xnhv2y7r0"))))
      (build-system asdf-build-system/sbcl)
      (home-page "https://github.com/dkochmanski/cl-dejavu")
      (synopsis "DejaVu fonts for Common Lisp")
      (description
       "This is a repackage of the original DejaVu Fonts with some convenience
functions.")
      (license (list license:cc0
                     (license:x11-style "http://dejavu-fonts.org/"))))))

(define-public cl-dejavu
  (sbcl-package->cl-source-package sbcl-cl-dejavu))

(define-public ecl-dejavu
  (sbcl-package->ecl-package sbcl-cl-dejavu))

(define-public sbcl-cl-difflib
  (let ((commit "98eb335c693f1881584b83ca7be4a0fe05355c4e")
        (revision "0"))
    (package
      (name "sbcl-cl-difflib")
      (version (git-version "0.2" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/wiseman/cl-difflib")
               (commit commit)))
         (file-name
          (git-file-name name version))
         (sha256
          (base32 "08if0abhqg191xcz9s7xv8faqq51nswzp8hw423fkqjzr24pmq48"))))
      (build-system asdf-build-system/sbcl)
      ;; Due to the age of this library tests use some deprecated
      ;; functionality and keep failing.
      (arguments
       '(#:tests? #f))
      (home-page "https://github.com/wiseman/cl-difflib")
      (synopsis "Compute differences between pairs of sequences")
      (description
       "A Common Lisp library for computing differences between
sequences based on the Python difflib module.")
      (license license:expat))))

(define-public cl-difflib
  (sbcl-package->cl-source-package sbcl-cl-difflib))

(define-public ecl-cl-difflib
  (sbcl-package->ecl-package sbcl-cl-difflib))

(define-public sbcl-cl-diskspace
  (let ((commit "2dce2d0387d58221c452bd76c7b9b7a7de81ef55")
        (revision "1"))
    (package
      (name "sbcl-cl-diskspace")
      (version (git-version "0.3.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/muyinliu/cl-diskspace")
               (commit commit)))
         (file-name (git-file-name "cl-diskspace" version))
         (sha256
          (base32 "0l19hxqw6b8i5i1jdbr45k1xib9axcwdagsp3y8wkb35g6wwc0s7"))))
      (build-system asdf-build-system/sbcl)
      (arguments
       `(#:phases
         (modify-phases %standard-phases
           (add-after 'unpack 'fix-paths
             (lambda* (#:key inputs #:allow-other-keys)
               (substitute* "src/unix/cl-diskspace-list-all-disks-with-df.lisp"
                 (("grep")
                  (search-input-file inputs "/bin/grep")))
               (substitute* "src/unix/cl-diskspace-list-all-disks-with-df.lisp"
                 (("/bin/df")
                  (which "df")))
               #t)))))
      (inputs
       `(("cl-ppcre" ,sbcl-cl-ppcre)
         ("cffi" ,sbcl-cffi)
         ("grep" ,grep)))
      (home-page "https://github.com/muyinliu/cl-diskspace")
      (synopsis "Disk space information library for Common Lisp")
      (description
       "CL-DISKSPACE is a Common Lisp library to list disks with the command
line tool @code{df} and get disk space information using @code{statvfs}.")
      (license license:isc))))

(define-public cl-diskspace
  (sbcl-package->cl-source-package sbcl-cl-diskspace))

(define-public ecl-cl-diskspace
  (sbcl-package->ecl-package sbcl-cl-diskspace))

(define-public sbcl-cl-docutils
  (let ((commit "756b5ad42360e84d8225fa69815bdd1623ceaa40")
        (revision "1"))
    (package
      (name "sbcl-cl-docutils")
      (version (git-version "0.1.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri
          (git-reference
           (url "https://github.com/willijar/cl-docutils/")
           (commit commit)))
         (file-name (git-file-name "cl-docutils" version))
         (sha256
          (base32
           "132bxlj0jlhiabi29mygmkcbbgyb5s1yz1xdfhm3pgrf9f8605gg"))))
      (build-system asdf-build-system/sbcl)
      (arguments
       '(#:asd-systems '("docutils")))
      (inputs
       (list sbcl-cl-ppcre
             sbcl-data-format-validation
             sbcl-trivial-gray-streams))
      (synopsis "Document utilities and Restructured text parser")
      (description
       "@code{cl-docutils} is a Common Lisp implementation of the Docutils text
processing system for processing plaintext into presentational formats such as
HTML and LaTeX.  It is based upon the Python Docutils reference implementation
but uses Common Lisp idioms making it easier to extend and more flexible.  As
with the reference implementation it includes a parser for the reStructured
text plaintext markup syntax which is suitable for marking up documentation
and for use as user markup for collaborative web sites.  It is successfully
used to support a higher education peer-review assessment and online tutorial
system.")
      (home-page "http://www.jarw.org.uk/lisp/cl-docutils.html")
      (license license:gpl3))))

(define-public cl-docutils
  (sbcl-package->cl-source-package sbcl-cl-docutils))

(define-public ecl-cl-docutils
  (sbcl-package->ecl-package sbcl-cl-docutils))

(define-public sbcl-cl-dot
  (let ((commit "73dfbb6e015a28ebed873266e4e8190e509b43de")
        (revision "0"))
    (package
      (name "sbcl-cl-dot")
      (version (git-version "0.9.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/michaelw/cl-dot")
               (commit commit)))
         (file-name (git-file-name "cl-dot" version))
         (sha256
          (base32 "0mcvzqfcg5rzr8rz8aa2yr2jl3ifflaksvps08zj71hbhiacqpxa"))))
      (build-system asdf-build-system/sbcl)
      (home-page "https://github.com/michaelw/cl-dot")
      (synopsis "Generate Graphviz dot output from arbitrary Lisp data")
      (description
       "CL-DOT is a Common Lisp library for generating Graphviz dot output from
arbitrary Lisp data.")
      (license license:expat))))

(define-public cl-dot
  (sbcl-package->cl-source-package sbcl-cl-dot))

(define-public ecl-cl-dot
  (sbcl-package->ecl-package sbcl-cl-dot))

(define-public sbcl-cl-dotenv
  (let ((commit "a093f5b330269f6e6f72f51ef638cca186aee44e")
        (revision "0"))
    (package
      (name "sbcl-cl-dotenv")
      (version (git-version "0.1.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/ollelauribostrom/cl-dotenv/")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "0cdbk886aizsnqqs3z4jfn8nyrnxj4yb3y00av49xc4h83h6xn53"))))
      (build-system asdf-build-system/sbcl)
      (native-inputs (list sbcl-prove))
      (inputs (list sbcl-alexandria sbcl-serapeum))
      (home-page "https://github.com/ollelauribostrom/cl-dotenv/")
      (synopsis "Load environment variables from .env files in Common Lisp")
      (description
       "@code{cl-dotenv} is a utility library for loading @file{.env} files in
Common Lisp.")
      (license license:expat))))

(define-public cl-dotenv
  (sbcl-package->cl-source-package sbcl-cl-dotenv))

(define-public ecl-cl-dotenv
  (sbcl-package->ecl-package sbcl-cl-dotenv))

(define-public sbcl-cl-emb
  (let ((commit "fd8652174d048d4525a81f38cdf42f4fa519f840")
        (revision "1"))
    (package
      (name "sbcl-cl-emb")
      (version (git-version "0.4.3" revision commit))
      (home-page "https://common-lisp.net/project/cl-emb/")
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/38a938c2/cl-emb")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "1xcm31n7afh5316lwz8iqbjx7kn5lw0l11arg8mhdmkx42aj4gkk"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-cl-ppcre))
      (synopsis "Templating system for Common Lisp")
      (description "A mixture of features from eRuby and HTML::Template.  You
could name it \"Yet Another LSP\" (LispServer Pages) but it's a bit more than
that and not limited to a certain server or text format.")
      (license license:llgpl))))

(define-public cl-emb
  (sbcl-package->cl-source-package sbcl-cl-emb))

(define-public ecl-cl-emb
  (sbcl-package->ecl-package sbcl-cl-emb))

(define-public sbcl-cl-environments
  (package
    (name "sbcl-cl-environments")
    (version "0.4")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/alex-gutev/cl-environments")
             (commit (string-append "v" version))))
       (file-name (git-file-name "cl-environments" version))
       (sha256
        (base32 "10jxj043d2dw5vc0i0lz0lsa4qszn8him5is8jdhl4nsyfcazmky"))))
    (build-system asdf-build-system/sbcl)
    (inputs
     (list sbcl-alexandria sbcl-anaphora sbcl-collectors sbcl-optima))
    (native-inputs
     (list sbcl-prove))
    (home-page "https://github.com/alex-gutev/cl-environments")
    (synopsis "Implements the Common Lisp standard environment access API")
    (description
     "This library provides a uniform API, as specified in Common Lisp the
Language 2, for accessing information about variable and function bindings
from implementation-defined lexical environment objects.  All major Common
Lisp implementations are supported, even those which don't support the CLTL2
environment access API.")
    (license license:expat)))

(define-public cl-environments
  (sbcl-package->cl-source-package sbcl-cl-environments))

(define-public ecl-cl-environments
  (sbcl-package->ecl-package sbcl-cl-environments))

(define-public sbcl-cl-ewkb
  (let ((commit "e2c7976cdc2074d63038ecd7179025ccb8d8f0b7")
        (revision "0"))
    (package
      (name "sbcl-cl-ewkb")
      (version (git-version "0.2" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/filonenko-mikhail/cl-ewkb")
               (commit commit)))
         (file-name (git-file-name "cl-ewkb" version))
         (sha256
          (base32 "1n1zm4i11638vh1a4m71690p4lpikkk0rp42j2yfvs5d9wi67cr1"))))
      (build-system asdf-build-system/sbcl)
      (inputs (list sbcl-ieee-floats sbcl-flexi-streams))
      (home-page "https://github.com/filonenko-mikhail/cl-ewkb")
      (synopsis "Common Lisp PostGIS EWKB library")
      (description "This package is a geospatial library, based on cl-wkb,
that implements the OGC Well-Known Binary geographic geometry data model with
PostGIS 3d, 4d extensions, and provides WKB and EWKB encoding and decoding
functionality.")
      (license (list license:expat)))))

(define-public cl-ewkb
  (sbcl-package->cl-source-package sbcl-cl-ewkb))

(define-public ecl-cl-ewkb
  (sbcl-package->ecl-package sbcl-cl-ewkb))

(define-public sbcl-cl-fad
  ;; No release since 2019
  (let ((commit "3f4d32d3aa1093966046d001411a852eb8f4b535")
        (revision "1"))
    (package
      (name "sbcl-cl-fad")
      (version (git-version "0.7.6" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/edicl/cl-fad/")
               (commit commit)))
         (sha256
          (base32 "0a1xqldrq170lflnns3xp6swpnvsvllf5vq0h7sz8jqh4riqlny6"))
         (file-name (git-file-name "cl-fad" version))))
      (build-system asdf-build-system/sbcl)
      (native-inputs
       (list sbcl-cl-ppcre sbcl-unit-test))
      (inputs
       (list sbcl-alexandria sbcl-bordeaux-threads))
      (synopsis "Portable pathname library for Common Lisp")
      (description
       "CL-FAD (for \"Files and Directories\") is a thin layer atop Common
Lisp's standard pathname functions.  It is intended to provide some
unification between current CL implementations on Windows, OS X, Linux, and
Unix.  Most of the code was written by Peter Seibel for his book Practical
Common Lisp.")
      (home-page "https://edicl.github.io/cl-fad/")
      (license license:bsd-2))))

(define-public cl-fad
  (sbcl-package->cl-source-package sbcl-cl-fad))

(define-public ecl-cl-fad
  (sbcl-package->ecl-package sbcl-cl-fad))

(define-public sbcl-cl-fast-ecs
  (package
    (name "sbcl-cl-fast-ecs")
    (version "0.8.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://gitlab.com/lockie/cl-fast-ecs")
             (commit version)))
       (file-name (git-file-name "cl-fast-ecs" version))
       (sha256
        (base32 "09fv58pgfa1byplzzh4mzriwwnnn5i2ib8z19dbnbl7y8zy568hi"))))
    (build-system asdf-build-system/sbcl)
    (native-inputs
     (list graphviz-minimal
           sbcl-cl-mock
           sbcl-parachute
           sbcl-trivial-coverage))
    (inputs
     (list sbcl-alexandria
           sbcl-closer-mop
           sbcl-global-vars
           sbcl-trivial-adjust-simple-array))
    (home-page "https://lockie.gitlab.io/cl-fast-ecs/")
    (synopsis "Blazingly fast Entity-Component-System microframework")
    (description
     "CL-FAST-ECS is a Common Lisp library providing an implementation of the
@acronym{ECS, Entity-Component-System} pattern, primarily focused on speed and
interactive development.

ECS is an architectural data-oriented design pattern that allows for the
effective processing of a large number of in-game objects while keeping the code
and data separated.  This provides flexibility in the way that game objects are
built at runtime.")
    (license license:expat)))

(define-public cl-fast-ecs
  (sbcl-package->cl-source-package sbcl-cl-fast-ecs))

(define-public ecl-cl-fast-ecs
    (sbcl-package->ecl-package sbcl-cl-fast-ecs))

(define-public sbcl-cl-fastcgi
  (let ((commit "de8b49b26de9863996ec18db28af8ab7e8ac4e20")
        (revision "2"))
    (package
      (name "sbcl-cl-fastcgi")
      (version (git-version "0.2" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/KDr2/cl-fastcgi/")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "0xgmhx766q4nmrvn5z7ag3ikpr9phlh8ypi8b14azshq9lqbq0m7"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       `(("usocket" ,sbcl-usocket)
         ("cffi" ,sbcl-cffi)
         ("fcgi" ,fcgi)))
      (arguments
       `(#:phases
         (modify-phases %standard-phases
           (add-after 'unpack 'fix-paths
             (lambda* (#:key inputs #:allow-other-keys)
               (substitute* "cl-fastcgi.lisp"
                 (("\"libfcgi.so\"")
                  (string-append
                   "\""
                   (assoc-ref inputs "fcgi") "/lib/libfcgi.so\""))))))))
      (home-page "https://kdr2.com/project/cl-fastcgi.html")
      (synopsis "FastCGI wrapper for Common Lisp")
      (description
       "CL-FastCGI is a generic version of SB-FastCGI, targeting to run on
mostly Common Lisp implementation.")
      (license license:bsd-2))))

(define-public cl-fastcgi
  (sbcl-package->cl-source-package sbcl-cl-fastcgi))

(define-public ecl-cl-fastcgi
  (sbcl-package->ecl-package sbcl-cl-fastcgi))

(define-public sbcl-cl-flac
  (let ((commit "d094d33d3cc2cf263263b917798d338eded3c532")
        (revision "0"))
    (package
      (name "sbcl-cl-flac")
      (version (git-version "1.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/Shirakumo/cl-flac")
               (commit commit)))
         (file-name (git-file-name "cl-flac" version))
         (sha256
          (base32 "1dgr5xqf175hzq3sxpbixxia2k2g3rz0pn6msch4dnvk7a1naqlc"))
         (modules '((guix build utils)))
         (snippet
          ;; Delete bundled libraries.
          `(begin
             (delete-file-recursively "static")))))
      (build-system asdf-build-system/sbcl)
      (arguments
       `(#:phases
         (modify-phases %standard-phases
           (add-after 'unpack 'fix-paths
             (lambda* (#:key inputs #:allow-other-keys)
               (substitute* "low-level.lisp"
                 (("libflac.so")
                  (search-input-file inputs "/lib/libFLAC.so"))))))))
      (inputs
       (list flac
             sbcl-cffi
             sbcl-documentation-utils
             sbcl-trivial-features
             sbcl-trivial-garbage))
      (home-page "https://shirakumo.github.io/cl-flac")
      (synopsis "CFFI bindings to libflac for Common Lisp")
      (description "This package provides CFFI bindings to the @code{libflac}
audio library for Common Lisp.")
      (license license:zlib))))

(define-public cl-flac
  (sbcl-package->cl-source-package sbcl-cl-flac))

(define-public ecl-cl-flac
  (sbcl-package->ecl-package sbcl-cl-flac))

(define-public sbcl-cl-fond
  (let ((commit "dac975cbc73f231b400d5b8d8539b16330239a4a")
        (revision "1"))
    (package
      (name "sbcl-cl-fond")
      (version (git-version "1.1.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/Shirakumo/cl-fond")
               (commit commit)))
         (file-name (git-file-name "cl-fond" version))
         (sha256
          (base32 "03ygcw1azb44bhdsqcq99xi4ci0by76ap5jf5l2d1vfxq04v8grq"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-alexandria
             sbcl-cffi
             sbcl-cl-opengl
             sbcl-documentation-utils
             sbcl-trivial-features
             sbcl-trivial-garbage))
      (home-page "https://shirakumo.github.io/cl-fond/")
      (synopsis "Bindings to libfond, a simple text rendering engine for OpenGL")
      (description "This is a Common Lisp bindings library to libfond, a
simple OpenGL text rendering engine.")
      (license license:zlib))))

(define-public cl-fond
  (sbcl-package->cl-source-package sbcl-cl-fond))

(define-public ecl-cl-fond
  (sbcl-package->ecl-package sbcl-cl-fond))

(define-public sbcl-cl-form-types
  (package
    (name "sbcl-cl-form-types")
    (version "0.3.2")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/alex-gutev/cl-form-types")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "0k4j657vfh4zblp9a7d3z15r82yyz4fzqh8vfn2s7ljsj1dmhp2n"))))
    (build-system asdf-build-system/sbcl)
    (inputs
     (list sbcl-agutil
           sbcl-anaphora
           sbcl-arrows
           sbcl-cl-environments
           sbcl-introspect-environment
           sbcl-optima))
    (native-inputs
     (list sbcl-fiveam))
    (home-page "https://github.com/alex-gutev/cl-form-types")
    (synopsis "Determine the types of Common Lisp forms")
    (description "This library provides functions for determining the value
types of Common Lisp forms, based on type information contained in the
environment.

In order for this library to work the values types of variables and return
types of functions have to be declared.

Macros and symbol-macros are fully expanded and all special forms, except
@code{CATCH}, are supported.")
    (license license:expat)))

(define-public cl-form-types
  (sbcl-package->cl-source-package sbcl-cl-form-types))

(define-public ecl-cl-form-types
  (let ((pkg (sbcl-package->ecl-package sbcl-cl-form-types)))
    (package
      (inherit pkg)
      (arguments
       ;; FIXME: Syntax error in declaration (TYPE T (FORM &KEY STRICT
       ;; EXPAND-COMPILER-MACROS (TEST (QUOTE FORM-TYPE=))))
       ;; An error occurred during initialization: COMPILE-FILE-ERROR while...
       ;; See <https://github.com/alex-gutev/cl-form-types/issues/22>.
       '(#:tests? #f)))))

(define-public sbcl-cl-freetype2
  (let ((commit "8bcb232b319a66fb700eaea88d0b308a837bce04")
        (revision "1"))
    (package
      (name "sbcl-cl-freetype2")
      (version (git-version "1.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/rpav/cl-freetype2")
               (commit commit)))
         (file-name (git-file-name "cl-freetype2" version))
         (sha256
          (base32 "1nhq3qslja0bcgpbmzfycqhd4vw1l58zh4ia15m1h6535qxliy0q"))))
      (build-system asdf-build-system/sbcl)
      (native-inputs
       (list sbcl-fiveam))
      (inputs
       (list freetype
             sbcl-alexandria
             sbcl-cffi
             sbcl-trivial-garbage))
      (arguments
       `(#:phases
         (modify-phases %standard-phases
           (add-after 'unpack 'fix-paths
             (lambda* (#:key inputs #:allow-other-keys)
               (substitute* "src/ffi/ft2-lib.lisp"
                 (("\"libfreetype\"")
                  (string-append "\"" (assoc-ref inputs "freetype")
                                 "/lib/libfreetype\"")))
               (substitute* "src/ffi/grovel/grovel-freetype2.lisp"
                 (("-I/usr/include/freetype")
                  (string-append "-I" (assoc-ref inputs "freetype")
                                 "/include/freetype")))
               #t)))))
      (home-page "https://github.com/rpav/cl-freetype2")
      (synopsis "Common Lisp bindings for Freetype 2")
      (description
       "This is a general Freetype 2 wrapper for Common Lisp using CFFI.  It's
geared toward both using Freetype directly by providing a simplified API, as
well as providing access to the underlying C structures and functions for use
with other libraries which may also use Freetype.")
      (license license:bsd-3))))

(define-public cl-freetype2
  (sbcl-package->cl-source-package sbcl-cl-freetype2))

(define-public ecl-cl-freetype2
  (sbcl-package->ecl-package sbcl-cl-freetype2))

(define-public sbcl-cl-ftp
  (let ((commit "530f1ec06427c69966d83c86638be628eacb9502")
        (revision "0"))
    (package
      (name "sbcl-cl-ftp")
      (version (git-version "1.6.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/pinterface/cl-ftp")
               (commit commit)))
         (file-name (git-file-name "cl-ftp" version))
         (sha256
          (base32  "0q5x9g419crvaf106q33k0xkh4xvglzjyjhibz9siymcngyc7zdh"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-split-sequence
             sbcl-usocket))
      (synopsis "FTP client for Common Lisp")
      (description
       "CL-FTP is a library which provides FTP client functionality
to a Common Lisp program.  CL-FTP uses the USOCKET package for network
sockets and the SPLIT-SEQUENCE package for some parsing needs.")
      (home-page "https://github.com/pinterface/cl-ftp")
      (license license:expat))))

(define-public cl-ftp
  (sbcl-package->cl-source-package sbcl-cl-ftp))

(define-public ecl-cl-ftp
  (sbcl-package->ecl-package sbcl-cl-ftp))

(define-public sbcl-cl-gamepad
  (let ((commit "d5b99fbaa2e39294d23061699e8f1e761eda7205")
        (revision "3"))
    (package
      (name "sbcl-cl-gamepad")
      (version (git-version "3.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/Shirakumo/cl-gamepad")
               (commit commit)))
         (file-name (git-file-name "cl-gamepad" version))
         (sha256
          (base32 "0y6kg9wq92p07i1chm1v7j7p77iqc5c985pdvmmivcip8zmd4hm4"))))
      (build-system asdf-build-system/sbcl)
      (arguments
       `(#:tests? #f ; No tests
         #:phases
         (modify-phases %standard-phases
           (add-after 'unpack 'patch-evdev-lib-path
             (lambda* (#:key inputs #:allow-other-keys)
               (substitute* "evdev-cffi.lisp"
                 (("libevdev.so")
                  (search-input-file inputs "/lib/libevdev.so"))))))))
      (inputs
       (list libevdev
             sbcl-cffi
             sbcl-documentation-utils
             sbcl-trivial-features))
      (home-page "https://shirakumo.github.io/cl-gamepad/")
      (synopsis "Library for access to gamepads and joystick input devices")
      (description
       "This is a library to provide cross-platform access to gamepads,
joysticks, and other such HID devices.")
      (license license:zlib))))

(define-public cl-gamepad
  (sbcl-package->cl-source-package sbcl-cl-gamepad))

(define-public ecl-cl-gamepad
  (sbcl-package->ecl-package sbcl-cl-gamepad))

(define-public sbcl-cl-geometry
  (let ((commit "24eddedc47b931cec27361752736ef0b54fc9984"))
    (package
      (name "sbcl-cl-geometry")
      (version (git-version "0.0.3" "1" commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/vydd/cl-geometry")
               (commit commit)))
         (file-name (git-file-name "cl-cl-geometry" version))
         (sha256
          (base32 "188xrd8plvc34gz7q01zmkdrzxbpwzln103l5dl78pa4a6vzz34h"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-iterate
             sbcl-trees))
      (home-page "https://github.com/lispgames/cl-geometry/")
      (synopsis "Simple two dimensional computational geometry in Common Lisp")
      (description
       "This is a system for two dimensional computational geometry for Common Lisp.

Note: the system assumes exact rational arithmetic, so no floating point
coordinates are allowed.  This is not checked when creating geometric
objects.")
      ;; The .asd says BSD-style but the LICENSE.txt is expat.
      (license license:expat))))

(define-public cl-cl-geometry
  (sbcl-package->cl-source-package sbcl-cl-geometry))

(define-public ecl-cl-geometry
  (sbcl-package->ecl-package sbcl-cl-geometry))

(define-public sbcl-cl-glfw3
  (let ((commit "32c3f34d592d55ee7ce932ed85804c1a9c4158c6")
        (revision "1"))
    (package
      (name "sbcl-cl-glfw3")
      (version (git-version "0.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/AlexCharlton/cl-glfw3")
               (commit commit)))
         (file-name (git-file-name "cl-glfw3" version))
         (sha256
          (base32 "1wzr43nckdx4rlgxzhm1r4kfc264q969mc43y0js9ramh7l8gba5"))))
      (build-system asdf-build-system/sbcl)
      (arguments
       `(#:phases
         (modify-phases %standard-phases
           (add-after 'unpack 'patch-glfw-lib-path
             (lambda* (#:key inputs #:allow-other-keys)
               (substitute* "glfw-bindings.lisp"
                 (("libglfw.so.3" _)
                  (search-input-file inputs "/lib/libglfw.so.3"))))))))
      (inputs
       `(("alexandria" ,sbcl-alexandria)
         ("cffi" ,sbcl-cffi)
         ("cl-opengl" ,sbcl-cl-opengl)
         ("glfw" ,glfw)
         ("trivial-main-thread" ,sbcl-trivial-main-thread)))
      (home-page "https://github.com/AlexCharlton/cl-glfw3")
      (synopsis "Common Lisp bindings to GLFW version 3.x")
      (description
       "This package provides a Common Lisp bindings to @code{glfw}, an OpenGL
application development library.")
      (license license:bsd-2))))

(define-public cl-glfw3
  (sbcl-package->cl-source-package sbcl-cl-glfw3))

(define-public ecl-cl-glfw3
  (sbcl-package->ecl-package sbcl-cl-glfw3))

(define-public sbcl-cl-glib
  (let ((commit "9e52827cce1cbb3962536b6a5e628febab593f57")
        (revision "1"))
    (package
      (name "sbcl-cl-glib")
      (version (git-version "1.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/bohonghuang/cl-glib")
               (commit commit)))
         (file-name (git-file-name "cl-glib" version))
         (sha256
          (base32 "0dxa493zdp1p93cahhpp3yaggn3j3kkn90mdw99g4ld7scmiglp4" ))))
      (build-system asdf-build-system/sbcl)
      (arguments
       '(#:asd-systems '("cl-gio" "cl-glib" "cl-gobject")))
      (inputs
       (list glib
             gobject-introspection
             sbcl-bordeaux-threads
             sbcl-cl-gobject-introspection-wrapper))
      (home-page "https://github.com/bohonghuang/cl-glib")
      (synopsis "Glib, GIO and Gobject bindings for Common Lisp")
      (description "This library provides Glib, GIO and Gobject bindings for
Common Lisp via Gobject Introspection.")
      (license license:lgpl3+))))

(define-public cl-glib
  (sbcl-package->cl-source-package sbcl-cl-glib))

(define-public ecl-cl-glib
  (sbcl-package->ecl-package sbcl-cl-glib))

(define-public sbcl-cl-gltf
  (let ((commit "7a3af05a7f491d8973b217f096806ef12a97474b")
        (revision "1"))
    (package
      (name "sbcl-cl-gltf")
      (version (git-version "2.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/Shirakumo/cl-gltf")
               (commit commit)))
         (file-name (git-file-name "cl-gltf" version))
         (sha256
          (base32 "1d64fg2l2c0wns3wpp1xypd8687gnp3k70fv9fb48m1kpzg4kvrh"))))
      (build-system asdf-build-system/sbcl)
      (arguments
       ;; No tests provided.
       `(#:tests? #f))
      (inputs
       (list sbcl-documentation-utils
             sbcl-cffi
             sbcl-jzon
             sbcl-mmap
             sbcl-nibbles
             sbcl-qbase64
             sbcl-static-vectors
             sbcl-trivial-extensible-sequences))
      (home-page "https://shirakumo.github.io/cl-gltf/")
      (synopsis "Common Lisp parser for glTF file format")
      (description
       "This package provides a Common Lisp parser for glTF file format.")
      (license license:zlib))))

(define-public cl-gltf
  (sbcl-package->cl-source-package sbcl-cl-gltf))

;; FIXME: ECL part is failing
;; ;;; Internal error:
;;
;; ** There is no package with the name SEQUENCE.An error occurred during
;; initialization: COMPILE-FILE-ERROR while compiling #<cl-source-file
;; "trivial-extensible-sequences" "fallback">.
;;
;; See <https://github.com/Shirakumo/cl-gltf/issues/3>
;;
;; (define-public ecl-cl-gltf
;;   (sbcl-package->ecl-package sbcl-cl-gltf))

(define-public sbcl-cl-gobject-introspection
  (let ((commit "4908a84c16349929b309c50409815ff81fb9b3c4")
        (revision "4"))
    (package
      (name "sbcl-cl-gobject-introspection")
      (version (git-version "0.3" revision commit))
      (home-page "https://github.com/andy128k/cl-gobject-introspection")
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url home-page)
               (commit commit)))
         (file-name (git-file-name "cl-gobject-introspection" version))
         (sha256
          (base32 "0iw8fciydh9bi2svq30hi029df16arpspk0mjzh0cm1c6kjm9dcj"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list glib
             gobject-introspection
             sbcl-alexandria
             sbcl-cffi
             sbcl-iterate
             sbcl-trivial-garbage))
      (native-inputs
       (list sbcl-fiveam))
      (arguments
       '(#:phases
         (modify-phases %standard-phases
           (add-after 'unpack 'fix-paths
             (lambda* (#:key inputs #:allow-other-keys)
               (substitute* "src/init.lisp"
                 (("libgobject-2\\.0\\.so")
                  (search-input-file inputs "/lib/libgobject-2.0.so"))
                 (("libgirepository-1\\.0\\.so")
                  (search-input-file inputs
                                     "/lib/libgirepository-1.0.so"))))))))
      (synopsis "Common Lisp bindings to GObject Introspection")
      (description
       "This library is a bridge between Common Lisp and GObject
Introspection, which enables Common Lisp programs to access the full interface
of C+GObject libraries without the need of writing dedicated bindings.")
      (license (list license:bsd-3
                     ;; Tests are under a different license.
                     license:llgpl)))))

(define-public cl-gobject-introspection
  (sbcl-package->cl-source-package sbcl-cl-gobject-introspection))

(define-public ecl-cl-gobject-introspection
  (sbcl-package->ecl-package sbcl-cl-gobject-introspection))

(define-public sbcl-cl-gobject-introspection-wrapper
  (let ((commit "2d197cba7e7d734ac8a2e181e5e709e5b218bada")
        (revision "1"))
    (package
      (name "sbcl-cl-gobject-introspection-wrapper")
      (version (git-version "1.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/bohonghuang/cl-gobject-introspection-wrapper")
               (commit commit)))
         (file-name (git-file-name "cl-gobject-introspection-wrapper" version))
         (sha256
          (base32 "05np2zs5806ib6qfz7d6knyaz6llxgwvjqavl1fsz5hcga40296s"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-alexandria
             sbcl-cl-gobject-introspection
             sbcl-cl-ppcre))
      (home-page
       "https://github.com/bohonghuang/cl-gobject-introspection-wrapper")
      (synopsis
       "Wrap and call GObject Introspection FFI function in Common Lisp")
      (description
       "This library converts the elements from GObject Introspection into
Common Lisp-style definitions, based on cl-gobject-introspection.")
      (license license:lgpl3+))))

(define-public cl-gobject-introspection-wrapper
  (sbcl-package->cl-source-package sbcl-cl-gobject-introspection-wrapper))

(define-public ecl-cl-gobject-introspection-wrapper
  (sbcl-package->ecl-package sbcl-cl-gobject-introspection-wrapper))

(define-public sbcl-cl-gopher
  (let ((commit "0899e7fa2134206f9d9778c7d53c49b7a59ff070")
        (revision "3"))
    (package
      (name "sbcl-cl-gopher")
      (version (git-version "0.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/knusbaum/cl-gopher")
               (commit commit)))
         (file-name (git-file-name "cl-gopher" version))
         (sha256
          (base32 "1ky4s33m5d0wvdaqji12pxr93qqfl5x62zjp3m4ihbdj0ws3yw2f"))
         (snippet
          '(begin
             ;; These files are mostly examples (that assume Quicklisp) which
             ;; drag the SBCL package into the CL package.
             (for-each delete-file
                       '("cl-gopher-network.lsh"
                         "cl-gopher-start.lsh"))
             #t))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-bordeaux-threads
             sbcl-drakma
             sbcl-flexi-streams
             sbcl-quri
             sbcl-split-sequence
             sbcl-usocket))
      (home-page "https://github.com/knusbaum/cl-gopher")
      (synopsis "Gopher protocol library in Common Lisp")
      (description
       "@code{cl-gopher} is a Common Lisp library for interacting with the
Gopher protocol.

It is suitable for building both clients and servers, and provides a sample
client.")
      (license license:bsd-2))))

(define-public cl-gopher
  (sbcl-package->cl-source-package sbcl-cl-gopher))

(define-public ecl-cl-gopher
  (sbcl-package->ecl-package sbcl-cl-gopher))

(define-public sbcl-cl-graph
  (let ((commit "c617de35390cb02db88bc5b5febffafdb8947ae8")
        (revision "2"))
    (package
      (name "sbcl-cl-graph")
      (version (git-version "0.10.2" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/hraban/cl-graph")
               (commit commit)))
         (file-name (git-file-name "cl-graph" version))
         (sha256
          (base32 "0g1abkph9zb0m9zz6q2471ml9q9acdhwyapk8ra3bisqpwlxvpyf"))))
      (build-system asdf-build-system/sbcl)
      (arguments
       ;; TODO: (Sharlatan-20221118T215839+0000): Tests failed
       ;;
       ;; https://github.com/gwkkwg/cl-graph/issues/17
       ;;
       `(#:tests? #f
         #:asd-systems '("cl-graph" "cl-graph+hu.dwim.graphviz")))
      (native-inputs
       (list sbcl-lift sbcl-moptilities))
      (inputs
       (list sbcl-cl-containers
             sbcl-cl-mathstats
             sbcl-dynamic-classes
             sbcl-hu.dwim.graphviz
             sbcl-metabang-bind
             sbcl-metacopy
             sbcl-metatilities-base))
      (home-page "https://github.com/gwkkwg/cl-graph")
      (synopsis "Graph manipulation utilities for Common Lisp")
      (description
       "This package provides a Common Lisp library for manipulating graphs
and running graph algorithms.")
      (license license:expat))))

(define-public cl-cl-graph
  (sbcl-package->cl-source-package sbcl-cl-graph))

;; NOTE: (Sharlatan-20221118T214734+0000): No ECL support
;;
;; ecl-cl-graph

(define-public sbcl-cl-grnm
  (let ((commit "778a312e9eb3d3de7541457b516ea3d9055a15aa")
        (revision "0"))
    (package
      (name "sbcl-cl-grnm")
      (version (git-version "0.1.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/quil-lang/cl-grnm")
               (commit commit)))
         (file-name (git-file-name "cl-grnm" version))
         (sha256
          (base32 "1hb5n37n3x2ylrghcqsia2g9a6f5wg24l659jiz4ncpi5bsv4m3s"))))
      (build-system asdf-build-system/sbcl)
      (synopsis "Common Lisp implementation of (grid restrained) Nelder-Mead")
      (description
       "These common lisp sources contain two variants of the Nelder-Mead
algorithm.  The original algorithm and a provably convergent, reliable variant
by A. Bürmen et al, called the @acronym{GRNMA, Grid Restrained Nelder Mead
Algorithm}.")
      (home-page "https://github.com/quil-lang/cl-grnm")
      (license license:expat))))

(define-public cl-grnm
  (sbcl-package->cl-source-package sbcl-cl-grnm))

(define-public ecl-cl-grnm
  (sbcl-package->ecl-package sbcl-cl-grnm))

(define-public sbcl-cl-gserver
  (package
    (name "sbcl-cl-gserver")
    (version "1.8.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/mdbergmann/cl-gserver")

             ;; The "1.8.0" tag must have been moved from
             ;; c83d92a66102faa514b546029a9bd2078b95dc0f to
             ;; 90832f02f0556463e332cd055c3c1be58f323aea, 22 commits later!
             (commit "c83d92a66102faa514b546029a9bd2078b95dc0f")))
       (file-name (git-file-name "cl-gserver" version))
       (sha256
        (base32 "1bfz7z8v417dvsp1jz76ir3ihcs8g7zis2d56xx1dpzqzjd95g7z"))))
    (build-system asdf-build-system/sbcl)
    (inputs
     (list sbcl-alexandria
           sbcl-bordeaux-threads
           sbcl-lparallel
           sbcl-cl-speedy-queue
           sbcl-log4cl
           sbcl-cl-str
           sbcl-blackbird
           sbcl-cl-hamt
           sbcl-binding-arrows
           sbcl-atomics))
    (native-inputs
     (list sbcl-fiveam sbcl-cl-mock))
    (home-page "https://mdbergmann.github.io/cl-gserver/index.html")
    (synopsis "Actor framework for easy access to state and async operations")
    (description
     "@code{cl-gserver} is a 'message passing' library / framework with actors
similar to Erlang or Akka.  It supports creating reactive systems for parallel
computing and event based message handling.")
    (license license:agpl3)))

(define-public cl-gserver
  (sbcl-package->cl-source-package sbcl-cl-gserver))

(define-public ecl-cl-gserver
  (sbcl-package->ecl-package sbcl-cl-gserver))

(define-public sbcl-cl-gss
  (let ((commit "60086f4fd3b82316352e7f2288edbd58f03e08c5")
        (revision "1"))
    (package
      (name "sbcl-cl-gss")
      (version (git-version "0.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/lokedhs/cl-gss")
               (commit commit)))
         (file-name (git-file-name "cl-gss" version))
         (sha256
          (base32 "0zhxxn3zarird255s9i56bz0fm6dkv00mn8bbsjrhskg3wpcg4pb"))))
      (build-system asdf-build-system/sbcl)
      (arguments
       (list
        #:phases
        #~(modify-phases %standard-phases
            (add-after 'unpack 'patch-gss-lib-path
              (lambda* (#:key inputs #:allow-other-keys)
                (substitute* "src/functions.lisp"
                  (("libgssapi_krb5.so")
                   (search-input-file inputs "/lib/libgssapi_krb5.so"))))))))
      (inputs
       (list mit-krb5
             sbcl-cffi
             sbcl-trivial-garbage
             sbcl-trivial-utf-8))
      (home-page "https://github.com/lokedhs/cl-gss")
      (synopsis "Common Lisp CFFI bindings to Generic Security Service (GSS)")
      (description
       "This package provides Common Lisp bindings to GSSAPI, which is
designed to provide a standard API to authentication services.  The API itself
is generic, and the system can provide different underlying implementations.
The most common one is Kerberos, which has several implementations, the most
common of which is probably Active Directory.")
      (license license:bsd-3))))

(define-public cl-gss
  (sbcl-package->cl-source-package sbcl-cl-gss))

(define-public ecl-cl-gss
  (sbcl-package->ecl-package sbcl-cl-gss))

(define-public sbcl-cl-gtk4
  (let ((commit "c05d3ec6849e9319c6655f6d77dda086064dd295")
        (revision "2"))
    (package
      (name "sbcl-cl-gtk4")
      (version (git-version "1.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/bohonghuang/cl-gtk4")
               (commit commit)))
         (file-name (git-file-name "cl-gtk4" version))
         (sha256
          (base32 "05r1zw9jhhliflkbamw96gp585xc1cz7dx28sz67mki34mc19s8v"))))
      (build-system asdf-build-system/sbcl)
      (arguments
       '(#:asd-systems '("cl-gtk4" "cl-gdk4")))
      ;; propagate because it at least requires the typelib files at runtime
      (propagated-inputs (list gtk))
      (inputs
       (list gobject-introspection
             sbcl-cl-glib
             sbcl-cl-gobject-introspection-wrapper))
      (home-page "https://github.com/bohonghuang/cl-gtk4")
      (synopsis "GTK4 bindings for Common Lisp")
      (description
       "This library provides GTK4 bindings for Common Lisp via Gobject
Introspection, in the cl-gtk4 ASDF system.")
      (license license:lgpl3))))

(define-public cl-gtk4
  (sbcl-package->cl-source-package sbcl-cl-gtk4))

(define-public ecl-cl-gtk4
  (sbcl-package->ecl-package sbcl-cl-gtk4))

(define-public sbcl-cl-hamt
  ;; No release
  (let ((commit "7a99eaaca1f952029def9ad5a2b80a612a712208"))
    (package
      (name "sbcl-cl-hamt")
      (version (git-version "0.0.0" "1" commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/danshapero/cl-hamt/")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "1ycbd73ykfj5j9sdhlzamyv18qbjj6xqf7fhm4fa0nsyr6sr3rf5"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-cl-murmurhash))
      (native-inputs
       (list sbcl-fiveam))
      (home-page "https://github.com/danshapero/cl-hamt")
      (synopsis "Dictionary & set data structure using hash array-mapped tries")
      (description
       "This library provides purely functional dictionaries and sets in
Common Lisp based on the hash array-mapped trie data structure.")
      (license license:bsd-3))))

(define-public cl-hamt
  (sbcl-package->cl-source-package sbcl-cl-hamt))

(define-public ecl-cl-hamt
  (sbcl-package->ecl-package sbcl-cl-hamt))

(define-public sbcl-cl-hash-util
  (let ((commit "7f88cb7579b2af8c21022554f46dddd6ce6a5fc2")
        (revision "0"))
    (package
      (name "sbcl-cl-hash-util")
      (version (git-version "0.1.7" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/orthecreedence/cl-hash-util")
               (commit commit)))
         (file-name (git-file-name name commit))
         (sha256
          (base32 "1xab7v2mav241rs8w68qmg485g4f75nrac3hjcnm0cb19ickbs1m"))))
      (build-system asdf-build-system/sbcl)
      (arguments
       (list
        #:asd-systems ''("cl-hash-util")))
      (native-inputs
       (list sbcl-fiveam))
      (inputs
       (list))
      (home-page "https://github.com/orthecreedence/cl-hash-util")
      (synopsis "Small hash utility library for Common Lisp")
      (description "Very basic library for dealing with CL's hash tables.  The
idea was spawned through working with enough JSON APIs and config files, causing
a lot of headaches in the process.")
      (license license:expat))))

(define-public ecl-cl-hash-util
  (sbcl-package->ecl-package sbcl-cl-hash-util))

(define-public cl-hash-util
  (sbcl-package->cl-source-package sbcl-cl-hash-util))

(define-public sbcl-cl-heap
  (package
    (name "sbcl-cl-heap")
    (version "0.1.6")
    (source
     (origin
       (method url-fetch)
       (uri (string-append "https://common-lisp.net/project/cl-heap/releases/"
                           "cl-heap_" version ".tar.gz"))
       (sha256
        (base32
         "163hb07p2nxz126rpq3cj5dyala24n0by5i5786n2qcr1w0bak4i"))))
    (build-system asdf-build-system/sbcl)
    (native-inputs
     (list sbcl-xlunit))
    (arguments
     '(#:asd-test-systems '("cl-heap-tests")))
    (synopsis "Heap and priority queue data structures for Common Lisp")
    (description
     "CL-HEAP provides various implementations of heap data structures (a
binary heap and a Fibonacci heap) as well as an efficient priority queue.")
    (home-page "https://common-lisp.net/project/cl-heap/")
    (license license:gpl3+)))

(define-public cl-heap
  (sbcl-package->cl-source-package sbcl-cl-heap))

(define-public ecl-cl-heap
  (sbcl-package->ecl-package sbcl-cl-heap))

(define-public sbcl-cl-hooks
  (let ((commit "5b638083f3b4f1221a52631d9c8a0a265565cac7")
        (revision "1"))
    (package
      (name "sbcl-cl-hooks")
      (build-system asdf-build-system/sbcl)
      (version (git-version "0.2.1" revision commit))
      (home-page "https://github.com/scymtym/architecture.hooks")
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url home-page)
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "0bg3l0a28lw5gqqjp6p6b5nhwqk46sgkb7184w5qbfngw1hk8x9y"))))
      (inputs
       (list sbcl-alexandria sbcl-let-plus sbcl-trivial-garbage
             sbcl-closer-mop))
      (native-inputs
       (list sbcl-fiveam))
      (synopsis "Hooks extension point mechanism (as in Emacs) for Common Lisp")
      (description "A hook, in the present context, is a certain kind of
extension point in a program that allows interleaving the execution of
arbitrary code with the execution of a the program without introducing any
coupling between the two.  Hooks are used extensively in the extensible editor
Emacs.

In the Common LISP Object System (CLOS), a similar kind of extensibility is
possible using the flexible multi-method dispatch mechanism.  It may even seem
that the concept of hooks does not provide any benefits over the possibilities
of CLOS.  However, there are some differences:

@itemize

@item There can be only one method for each combination of specializers and
qualifiers.  As a result this kind of extension point cannot be used by
multiple extensions independently.
@item Removing code previously attached via a @code{:before}, @code{:after} or
@code{:around} method can be cumbersome.
@item There could be other or even multiple extension points besides @code{:before}
and @code{:after} in a single method.
@item Attaching codes to individual objects using eql specializers can be
cumbersome.
@item Introspection of code attached a particular extension point is
cumbersome since this requires enumerating and inspecting the methods of a
generic function.
@end itemize

This library tries to complement some of these weaknesses of method-based
extension-points via the concept of hooks.")
      (license license:llgpl))))

(define-public cl-hooks
  (sbcl-package->cl-source-package sbcl-cl-hooks))

(define-public ecl-cl-hooks
  (sbcl-package->ecl-package sbcl-cl-hooks))

(define-public sbcl-cl-html-diff
  (let ((commit "5a0b39d1c524278d6f60851d7786bb2585614310")
        (revision "0"))
    (package
      (name "sbcl-cl-html-diff")
      (version (git-version "0.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/wiseman/cl-html-diff")
               (commit commit)))
         (file-name
          (git-file-name name version))
         (sha256
          (base32 "1varnijivzd4jpimn1cz8p5ks713zzha5cgl4vmb0xr8ahravwzb"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-cl-difflib))
      (home-page "https://github.com/wiseman/cl-html-diff")
      (synopsis "Generate a human-readable diff of two HTML documents")
      (description
       "A Common Lisp library for generating a human-readable diff of two
HTML documents.")
      (license license:expat))))

(define-public cl-html-diff
  (sbcl-package->cl-source-package sbcl-cl-html-diff))

(define-public ecl-cl-html-diff
  (sbcl-package->ecl-package sbcl-cl-html-diff))

(define-public sbcl-cl-html5-parser
  (let ((commit "74a92eb3a183a0afd089ea33350e816e6b9aeefa")
        (revision "1"))
    (package
      (name "sbcl-cl-html5-parser")
      (version (git-version "0.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/rotatef/cl-html5-parser")
               (commit commit)))
         (file-name (git-file-name "cl-html5-parser" version))
         (sha256
          (base32 "04if61wigylsmn996rbfl8ylsd0d9hzdmg7p2wiglncibjzcl5k9"))))
      (build-system asdf-build-system/sbcl)
      (native-inputs
       (list sbcl-json-streams sbcl-split-sequence sbcl-stefil))
      (inputs
       (list sbcl-cl-ppcre sbcl-flexi-streams sbcl-string-case))
      (synopsis "HTML5 parser for Common Lisp")
      (description "This a Common Lisp library to parse HTML5 documents.")
      (home-page "https://github.com/rotatef/cl-html5-parser")
      (license license:lgpl3+))))

(define-public cl-html5-parser
  (sbcl-package->cl-source-package sbcl-cl-html5-parser))

(define-public ecl-cl-html5-parser
  (sbcl-package->ecl-package sbcl-cl-html5-parser))

(define-public sbcl-cl-https-everywhere
  ;; No release.
  ;; Don't forget to update the https-everywhere input.
  (let ((commit "cbcc73b985a5b1c0ce0d4ec38bc982a0538d4bd8"))
    (package
      (name "sbcl-cl-https-everywhere")
      (version (git-version "0.0.0" "1" commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/ruricolist/cl-https-everywhere/")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "1wcvx1icwym1ncd6wl1wxzkyyndrm796caalbklvjd4a2cbl3xxi"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       `(("alexandria" ,sbcl-alexandria)
         ("global-vars" ,sbcl-global-vars)
         ("parenscript" ,sbcl-parenscript)
         ("cl-markdown" ,sbcl-cl-markdown)
         ("cl-tld" ,sbcl-cl-tld)
         ("fxml" ,sbcl-fxml)
         ("overlord" ,sbcl-overlord)
         ("ppcre" ,sbcl-cl-ppcre)
         ("serapeum" ,sbcl-serapeum)
         ("trivial-gray-streams" ,sbcl-trivial-gray-streams)
         ("vernacular" ,sbcl-vernacular)))
      (native-inputs
       `(("fiveam" ,sbcl-fiveam)
         ("https-everywhere"
          ,(let ((version "2021.7.13"))
             (origin
               (method git-fetch)
               (uri (git-reference
                     (url "https://github.com/EFForg/https-everywhere")
                     (commit version)))
               (file-name (git-file-name "https-everywhere" version))
               (sha256
                (base32
                 "1k5gj29imhxf47sv3d8rxyrgr6k65scp2fm040va3nfshayslzia")))))))
      (arguments
       `(#:phases
         (modify-phases %standard-phases
           (add-after 'unpack 'link-https-everywhere-repo
             (lambda* (#:key inputs #:allow-other-keys)
               (let ((https-everywhere (assoc-ref inputs "https-everywhere")))
                 (symlink https-everywhere "https-everywhere"))))
           (add-after 'unpack 'fix-overlord-build
             ;; Upstream bugs?  See
             ;; https://github.com/ruricolist/cl-https-everywhere/issues/1.
             (lambda* (#:key outputs #:allow-other-keys)
               (let* ((out (assoc-ref outputs "out"))
                      (rulesets.xml (string-append out "/share/common-lisp/" (%lisp-type)
                                                   "/cl-https-everywhere/rulesets.xml")))
                 (substitute* "build.lisp"
                   (("\\(depends-on https-everywhere-version\\)") "")
                   ;; Don't rebuild the rulesets just because the timestamp is epoch.
                   (("\\(vernacular:require-default :cl-https-everywhere/rulesets-file \"rulesets.xml\"\\)")
                    (format #f "(if (uiop:file-exists-p ~s)
      (compile-rulesets ~s)
      (vernacular:require-default :cl-https-everywhere/rulesets-file \"rulesets.xml\"))"
                            rulesets.xml
                            rulesets.xml))
                   (("\\(uiop:parse-unix-namestring \"https-everywhere/src/chrome/content/rules/\\*\\.xml\")")
                    "\"https-everywhere/src/chrome/content/rules/*.xml\"")
                   (("\\(out temp :external-format :utf-8\\)")
                    "(out temp :external-format :utf-8 :if-exists :supersede)")))
               #t)))))
      (home-page "https://github.com/ruricolist/cl-https-everywhere/")
      (synopsis "Use HTTPS Everywhere rules from Lisp")
      (description
       "CL-HTTPS-EVERYWHERE parses HTTPS Everywhere rulesets and makes them
available for use in Lisp programs.")
      (license (list license:expat
                     ;; For the ruleset
                     license:gpl2+)))))

(define-public cl-https-everywhere
  (sbcl-package->cl-source-package sbcl-cl-https-everywhere))

(define-public sbcl-cl-i18n
  (let ((commit "acb162a12dac50fc46d83da8934fce85d19e31c4")
        (revision "3"))
    (package
      (name "sbcl-cl-i18n")
      (version (git-version "0.5.5" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://codeberg.org/cage/cl-i18n")
               (commit commit)))
         (file-name (git-file-name "cl-i18n" version))
         (sha256
          (base32 "1y29cirmlyc406a45sdx39spvnjzbs772c977075ccicz46qaxz7"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-alexandria sbcl-babel sbcl-cl-ppcre-unicode))
      (synopsis "Internationalisation framework for Common Lisp")
      (description
       "This is a Gettext-style internationalisation framework for Common
Lisp.")
      (home-page "https://codeberg.org/cage/cl-i18n")
      (license license:llgpl))))

(define-public cl-i18n
  (sbcl-package->cl-source-package sbcl-cl-i18n))

(define-public ecl-cl-i18n
  (sbcl-package->ecl-package sbcl-cl-i18n))

(define-public sbcl-cl-iconv
  (let ((commit "54900c3f00e19da15a9c65451bddde839d0a7f75")
        (revision "0"))
    (package
      (name "sbcl-cl-iconv")
      (version (git-version "0.3" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/quek/cl-iconv")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "1lpw95c02inifhdh9kkab9q92i5w9zd788dww1wly2p0a6kyx9wg"))))
      (build-system asdf-build-system/sbcl)
      ;; The project is called cl-iconv but the system is declared as iconv.
      (arguments
       '(#:asd-systems '("iconv")
         #:phases
         (modify-phases %standard-phases
           (add-after 'unpack 'fix-paths
             (lambda* (#:key inputs #:allow-other-keys)
               (substitute* "iconv.lisp"
                 (("libiconv.so")
                  (search-input-file inputs "/lib/libiconv.so"))))))))
      (native-inputs (list sbcl-ptester))
      (inputs (list libiconv sbcl-cffi))
      (home-page "https://github.com/quek/cl-iconv")
      (synopsis "@command{iconv} library for Common Lisp")
      (description
       "This package provides CFFI bindings to convert between different
character encodings using iconv.")
      (license license:bsd-3))))

(define-public cl-iconv
  (sbcl-package->cl-source-package sbcl-cl-iconv))

(define-public ecl-cl-iconv
  (sbcl-package->ecl-package sbcl-cl-iconv))

(define-public sbcl-cl-indentify
  (let ((commit "eb770f434defa4cd41d84bca822428dfd0dbac53"))
    (package
      (name "sbcl-cl-indentify")
      (version (git-version "0.1" "1" commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/yitzchak/cl-indentify")
               (commit commit)))
         (file-name (git-file-name name commit))
         (sha256
          (base32 "0ha36bhg474vr76vfhr13szc8cfdj1ickg92k1icz791bqaqg67p"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-alexandria sbcl-command-line-arguments
             sbcl-trivial-gray-streams))
      (native-inputs
       (list sbcl-trivial-escapes sbcl-rove))
      (home-page "https://github.com/yitzchak/cl-indentify")
      (synopsis "Code beautifier for Common Lisp")
      (description
       "A library and command line utility to automatically indent Common Lisp
source files.")
      (license license:expat))))

(define-public cl-indentify
  (sbcl-package->cl-source-package sbcl-cl-indentify))

(define-public ecl-cl-indentify
  (sbcl-package->ecl-package sbcl-cl-indentify))

(define-public sbcl-cl-inflector
  (let ((commit "f1ab16919ccce3bd82a0042677d9616dde2034fe")
        (revision "1"))
    (package
      (name "sbcl-cl-inflector")
      (version (git-version "0.2" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/AccelerationNet/cl-inflector")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "1xwwlhik1la4fp984qnx2dqq24v012qv4x0y49sngfpwg7n0ya7y"))))
      (build-system asdf-build-system/sbcl)
      (native-inputs
       (list sbcl-lisp-unit2))
      (inputs
       (list sbcl-alexandria sbcl-cl-ppcre))
      (home-page "https://github.com/AccelerationNet/cl-inflector")
      (synopsis "Library to pluralize/singularize English and Portuguese words")
      (description
       "This is a common lisp library to easily pluralize and singularize
English and Portuguese words.  This is a port of the ruby ActiveSupport
Inflector module.")
      (license license:expat))))

(define-public cl-inflector
  (sbcl-package->cl-source-package sbcl-cl-inflector))

(define-public ecl-cl-inflector
  (sbcl-package->ecl-package sbcl-cl-inflector))

(define-public sbcl-cl-ini
  (let ((commit "e630acb405022a7ae11969bf908669fee1191ab7")
        (revision "0"))
    (package
      (name "sbcl-cl-ini")
      (version (git-version "0.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/compufox/cl-ini")
               (commit commit)))
         (file-name (git-file-name "sbcl-cl-ini" version))
         (sha256
          (base32
           "12vy3gspqn0wmkyz5id1xrgv1scgb16m7pkvmbmi19vlpj2iyq7p"))))
      (build-system asdf-build-system/sbcl)
      (native-inputs (list sbcl-prove))
      (inputs (list sbcl-cl-str))
      (home-page "https://github.com/compufox/cl-ini")
      (synopsis "INI file parser for Common Lisp")
      (description
       "Parse INI formatted files into a Common Lisp list structure.")
      (license license:expat))))

(define-public cl-ini
  (sbcl-package->cl-source-package sbcl-cl-ini))

(define-public ecl-cl-ini
  (sbcl-package->ecl-package sbcl-cl-ini))

(define-public sbcl-cl-inotify
  (let ((commit "66f29e01ec28355ebba8292411b4de90eebd76a3")
        (revision "0"))
    (package
      (name "sbcl-cl-inotify")
      (version (git-version "0.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/Ferada/cl-inotify")
               (commit commit)))
         (file-name (git-file-name "cl-inotify" version))
         (sha256
          (base32 "0d3bvp5lqnddzhk1w9yyli03njbkhc8d129a058g0j49kgd47c7v"))))
     (build-system asdf-build-system/sbcl)
     (native-inputs (list sbcl-fiveam))
     (inputs
       (list libfixposix
             sbcl-binary-types
             sbcl-cffi
             sbcl-osicat
             sbcl-trivial-utf-8))
     (synopsis "Common Lisp interface to the Linux inotify API")
     (description
      "@code{cl-inotify} uses @code{cl-cffi} to provide a Common Lisp
interface to the Linux inotify API.")
     (home-page "https://github.com/Ferada/cl-inotify/")
     (license license:bsd-2))))

(define-public cl-inotify
  (sbcl-package->cl-source-package sbcl-cl-inotify))

(define-public ecl-cl-inotify
  (sbcl-package->ecl-package sbcl-cl-inotify))

(define-public sbcl-cl-interpol
  (let ((commit "70a1137f41dd8889004dbab9536b1adeac2497aa")
        (revision "1"))
    (package
      (name "sbcl-cl-interpol")
      (version (git-version "0.2.7" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/edicl/cl-interpol")
               (commit commit)))
         (file-name (git-file-name "cl-interpol" version))
         (sha256
          (base32
           "1kr00zf62m7la7rxa2m5w49r9cyzamc106hvjcc8ffmi7a4jw490"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-cl-unicode sbcl-named-readtables))
      (native-inputs
       (list sbcl-flexi-streams))
      (synopsis "String interpolation for Common Lisp")
      (description
       "CL-INTERPOL is a library for Common Lisp which modifies the
reader so that you can have interpolation within strings similar to
Perl or Unix Shell scripts.  It also provides various ways to insert
arbitrary characters into literal strings even if your editor/IDE
doesn't support them.")
      (home-page "https://edicl.github.io/cl-interpol/")
      (license license:bsd-3))))

(define-public cl-interpol
  (sbcl-package->cl-source-package sbcl-cl-interpol))

(define-public ecl-cl-interpol
  (sbcl-package->ecl-package sbcl-cl-interpol))

(define-public sbcl-cl-ipfs-api2
  (let ((commit "3ee52c80023bcc662f7d01276ea0a5814bd0011b")
        (revision "0"))
    (package
      (name "sbcl-cl-ipfs-api2")
      (version (git-version "0.51" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/JadedCtrl/cl-ipfs-api2")
               (commit commit)))
         (file-name (git-file-name "cl-ipfs-api2" version))
         (sha256
          (base32 "1h0csxk4db1hid793mk5kz3nbjyl7z4ic1zk2wy46k1vz5lnnsph"))))
      (build-system asdf-build-system/sbcl)
      (arguments
       '(#:tests? #f)) ; There are no tests.
      (inputs
       (list sbcl-arnesi
             sbcl-drakma
             sbcl-yason))
      (home-page "https://github.com/JadedCtrl/cl-ipfs-api2/")
      (synopsis "Bindings for the IPFS HTTP API")
      (description
       "@code{cl-sbcl-cl-ipfs-api2} is a pretty simple set of IPFS bindings
for Common Lisp, using the HTTP API for (almost) everything, except for pubsub
(which uses the locally installed go-ipfs program).")
      (license license:lgpl3))))

(define-public cl-ipfs-api2
  (sbcl-package->cl-source-package sbcl-cl-ipfs-api2))

(define-public ecl-cl-ipfs-api2
  (sbcl-package->ecl-package sbcl-cl-ipfs-api2))

(define-public sbcl-cl-irc
  (let ((commit "963823537c7bfcda2edd4c44d172192da6722175")
        (revision "0"))
    (package
      (name "sbcl-cl-irc")
      (version (git-version "0.9.2" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://salsa.debian.org/common-lisp-team/cl-irc.git")
               (commit commit)))
         (file-name (git-file-name "cl-irc" version))
         (sha256
          (base32 "1b3nqbb4pj377lxl47rfgrs82pidadnrc65l48bk553c2f59b52w"))))
      (build-system asdf-build-system/sbcl)
      (native-inputs
       (list sbcl-rt))
      (inputs
       `(("cl+ssl" ,sbcl-cl+ssl)
         ("flexi-streams" ,sbcl-flexi-streams)
         ("split-sequence" ,sbcl-split-sequence)
         ("usocket" ,sbcl-usocket)))
      (arguments
       `(#:asd-test-systems '("cl-irc-test")))
      (synopsis "IRC client library for Common Lisp")
      (description "@code{cl-irc} is a Common Lisp IRC client library that
features (partial) DCC, CTCP and all relevant commands from the IRC
RFCs (RFC2810, RFC2811 and RFC2812).

Features:
@itemize
@item implements all commands in the RFCs
@item extra convenience commands such as op/deop, ban, ignore, etc.
@item partial DCC SEND/CHAT support
@item event driven model with hooks makes interfacing easy
@item the user can keep multiple connections
@item all CTCP commands
@end itemize\n")
      (home-page "https://common-lisp.net/project/cl-irc/")
      (license license:bsd-2))))

(define-public cl-irc
  (sbcl-package->cl-source-package sbcl-cl-irc))

(define-public ecl-cl-irc
  (sbcl-package->ecl-package sbcl-cl-irc))

(define-public sbcl-cl-isaac
  (let ((commit "9cd88f39733be753facbf361cb0e08b9e42ff8d5")
        (revision "0"))
    (package
      (name "sbcl-cl-isaac")
      (version (git-version "1.0.7" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/thephoeron/cl-isaac")
               (commit commit)))
         (file-name (git-file-name "cl-isaac" version))
         (sha256
          (base32 "0ig1mf8iridfr7vci9gy499194h0hda0xki5s6g0y04g85ibnpw9"))))
      (build-system asdf-build-system/sbcl)
      (native-inputs (list sbcl-prove))
      (home-page "https://github.com/thephoeron/cl-isaac/")
      (synopsis "Fast cryptographic random number generators")
      (description "This is an optimized Common Lisp library of Bob Jenkins'
ISAAC-32 and ISAAC-64 algorithms, which are fast cryptographic random number
generators: Indirection, Shift, Accumulate, Add, and Count.")
      (license license:bsd-0))))

(define-public cl-isaac
  (sbcl-package->cl-source-package sbcl-cl-isaac))

(define-public ecl-cl-isaac
  (sbcl-package->ecl-package sbcl-cl-isaac))

(define-public sbcl-cl-jpeg
  (let ((commit "ec557038128df6895fbfb743bfe8faf8ec2534af")
        (revision "1"))
    (package
      (name "sbcl-cl-jpeg")
      (version (git-version "2.8" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/sharplispers/cl-jpeg")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "1bkkiqz8fqldlj1wbmrccjsvxcwj98h6s4b6gslr3cg2wmdv5xmy"))))
      (build-system asdf-build-system/sbcl)
      (synopsis "JPEG image library for Common Lisp")
      (description
       "This is a baseline JPEG codec written in Common Lisp.  It can be used
for reading and writing JPEG image files.")
      (home-page "https://github.com/sharplispers/cl-jpeg")
      (license license:bsd-3))))

(define-public cl-jpeg
  (sbcl-package->cl-source-package sbcl-cl-jpeg))

(define-public ecl-cl-jpeg
  (sbcl-package->ecl-package sbcl-cl-jpeg))

(define-public sbcl-cl-json
  (package
    (name "sbcl-cl-json")
    (version "0.6.0")
    (source
      (origin
        (method git-fetch)
        (uri (git-reference
              (url "https://github.com/sharplispers/cl-json")
              (commit (string-append "v" version))))
        (file-name (git-file-name "cl-json" version))
        (sha256
         (base32 "12vakz47d1i7pywgb9cm2364fzykidc9m7l7b6n9lx0gn2qx9ar5"))))
    (build-system asdf-build-system/sbcl)
    (native-inputs
     (list sbcl-fiveam))
    (home-page "https://github.com/sharplispers/cl-json")
    (synopsis "JSON encoder and decoder for Common-Lisp")
    (description "@command{cl-json} provides an encoder of Lisp objects
to JSON format and a corresponding decoder of JSON data to Lisp
objects.  Both the encoder and the decoder are highly customizable; at the
same time, the default settings ensure a very simple mode of operation,
similar to that provided by @command{yason} or @command{st-json}.")
    (license license:expat)))

(define-public cl-json
  (sbcl-package->cl-source-package sbcl-cl-json))

(define-public ecl-cl-json
  (sbcl-package->ecl-package sbcl-cl-json))

(define-public sbcl-cl-json-pointer
  (let ((commit "f6760e2a02972783f96b92a15f801e14a6828e0c")
        (revision "0"))
    (package
      (name "sbcl-cl-json-pointer")
      (version (git-version "0.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/y2q-actionman/cl-json-pointer")
               (commit commit)))
         (file-name (git-file-name "cl-json-pointer" version))
         (sha256
          (base32 "0b7a755wc2ghsd1pv7d32877b21h4nssp41xs017anbmj55czb2h"))))
      (build-system asdf-build-system/sbcl)
      (arguments
      ;; FIXME: Component "cl-json-pointer/test" not found.
       `(#:tests? #f
         #:asd-systems '("cl-json-pointer" "cl-json-pointer/synonyms")))
      (inputs
       (list sbcl-alexandria
             sbcl-boost-json
             sbcl-cl-json
             sbcl-closer-mop
             sbcl-st-json))
      (home-page "https://github.com/y2q-actionman/cl-json-pointer")
      (synopsis "JSON Pointer processor for Common Lisp")
      (description "
This package provides a JSON
Pointer (@url{https://tools.ietf.org/html/rfc6901,RFC6901}) implementation for
Common Lisp.  This library aims to be independent from any JSON libraries (as much
as possible).")
      (license license:expat))))

(define-public cl-json-pointer
  (sbcl-package->cl-source-package sbcl-cl-json-pointer))

(define-public ecl-cl-json-pointer
  (sbcl-package->ecl-package sbcl-cl-json-pointer))

(define-public sbcl-cl-ledger
  (let ((commit "b0174f5634e389fb022ae72cc527a13b719655bd")
        (revision "2"))
    (package
      (name "sbcl-cl-ledger")
      (version (git-version "4.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/ledger/cl-ledger")
               (commit commit)))
         (file-name (git-file-name "cl-ledger" version))
         (sha256
          (base32 "02zg53j8d7lpyafif9kplp6clchz4id429j0dc5w80wvcwfal123"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-cambl
             sbcl-cl-ppcre
             sbcl-local-time
             sbcl-periods))
      (arguments
       (list #:phases
             #~(modify-phases %standard-phases
                 (add-after 'unpack 'fix-system-definition
                   (lambda _
                     (substitute* "cl-ledger.asd"
                       (("  :build-operation program-op") "")
                       (("  :build-pathname \"cl-ledger\"") "")
                       (("  :entry-point \"ledger::main\"") "")))))))
      (synopsis "Common Lisp port of the Ledger accounting system")
      (description
       "CL-Ledger is a Common Lisp port of the Ledger double-entry accounting
system.")
      (home-page "https://github.com/ledger/cl-ledger")
      (license license:bsd-3))))

(define-public cl-ledger
  (sbcl-package->cl-source-package sbcl-cl-ledger))

(define-public ecl-cl-ledger
  (sbcl-package->ecl-package sbcl-cl-ledger))

(define-public sbcl-cl-lex
  (let ((commit "f2dbbe25ef553005fb402d9a6203180c3fa1093b")
        (revision "1"))
    (package
      (name "sbcl-cl-lex")
      (version (git-version "1.1.3" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/djr7C4/cl-lex")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "1kg50f76bfpfxcv4dfivq1n9a0xlsra2ajb0vd68lxwgbidgyc2y"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-cl-ppcre))
      (synopsis "Common Lisp macros for generating lexical analyzers")
      (description
       "This is a Common Lisp library providing a set of macros for generating
lexical analyzers automatically.  The lexers generated using @code{cl-lex} can
be used with @code{cl-yacc}.")
      (home-page "https://github.com/djr7C4/cl-lex")
      (license license:gpl3))))

(define-public cl-lex
  (sbcl-package->cl-source-package sbcl-cl-lex))

(define-public ecl-cl-lex
  (sbcl-package->ecl-package sbcl-cl-lex))

(define-public sbcl-cl-liballegro
  (let ((commit "49f632ce97fc4f835bf5d450588793234b980a64")
        (revision "1"))
    (package
      (name "sbcl-cl-liballegro")
      (version (git-version "0.2.15" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/resttime/cl-liballegro")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "0brbr7i342s0gadlnzd3a61w2b9ihhx60l19ararnc2asvyhmz7x"))))
      (build-system asdf-build-system/sbcl)
      (arguments
       `(#:phases
         (modify-phases %standard-phases
           (add-after 'unpack 'patch-allegro-lib-path
             (lambda* (#:key inputs #:allow-other-keys)
               (let ((allegro-lib-path (string-append
                                        (assoc-ref inputs "allegro") "/lib/")))
                 (substitute* "src/library.lisp"
                   (("lib \".so\"" all)
                    (string-append "\"" allegro-lib-path "\"" " lib \".so\"")))))))))
      (inputs
       `(("allegro" ,allegro)
         ("cffi" ,sbcl-cffi)
         ("float-features" ,sbcl-float-features)
         ("trivial-garbage" ,sbcl-trivial-garbage)
         ("trivial-main-thread" ,sbcl-trivial-main-thread)))
      (home-page "https://github.com/resttime/cl-liballegro")
      (synopsis "Allegro 5 game programming library bindings for Common Lisp")
      (description
       "This package provides CFFI bindings and interface to Allegro 5 game
developing library for Common Lisp.")
      (license license:zlib))))

(define-public cl-liballegro
  (sbcl-package->cl-source-package sbcl-cl-liballegro))

(define-public ecl-cl-liballegro
  (sbcl-package->ecl-package sbcl-cl-liballegro))

(define-public sbcl-cl-libsvm-format
  (let ((commit "3300f84fd8d9f5beafc114f543f9d83417c742fb")
        (revision "0"))
    (package
      (name "sbcl-cl-libsvm-format")
      (version (git-version "0.1.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/masatoi/cl-libsvm-format")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "0284aj84xszhkhlivaigf9qj855fxad3mzmv3zfr0qzb5k0nzwrg"))))
      (build-system asdf-build-system/sbcl)
      (native-inputs
       (list sbcl-prove))
      (inputs
       (list sbcl-alexandria))
      (synopsis "LibSVM data format reader for Common Lisp")
      (description
       "This Common Lisp library provides a fast reader for data in LibSVM
format.")
      (home-page "https://github.com/masatoi/cl-libsvm-format")
      (license license:expat))))

(define-public cl-libsvm-format
  (sbcl-package->cl-source-package sbcl-cl-libsvm-format))

(define-public ecl-cl-libsvm-format
  (sbcl-package->ecl-package sbcl-cl-libsvm-format))

(define-public sbcl-cl-libuv
  (let ((commit "32100c023c518038d0670a103eaa4d50dd785d29")
        (revision "1"))
    (package
      (name "sbcl-cl-libuv")
      (version (git-version "0.1.6" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/orthecreedence/cl-libuv")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "1kwix4si8a8hza34ab2k7whrh7z0yrmx39v2wc3qblv9m244jkh1"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       `(("alexandria" ,sbcl-alexandria)
         ("cffi" ,sbcl-cffi)
         ("libuv" ,libuv)))
      (arguments
       `(#:phases
         (modify-phases %standard-phases
           (add-after 'unpack 'fix-paths
             (lambda* (#:key inputs #:allow-other-keys)
               (substitute* "lib.lisp"
                 (("/usr/lib/libuv.so")
                  (search-input-file inputs "/lib/libuv.so")))))
           (add-after 'fix-paths 'fix-system-definition
             (lambda _
               (substitute* "cl-libuv.asd"
                 (("#:cffi #:alexandria")
                  "#:cffi #:cffi-grovel #:alexandria"))
               #t)))))
      (synopsis "Common Lisp bindings to libuv")
      (description
       "This library provides low-level libuv bindings for Common Lisp.")
      (home-page "https://github.com/orthecreedence/cl-libuv")
      (license license:expat))))

(define-public cl-libuv
  (sbcl-package->cl-source-package sbcl-cl-libuv))

(define-public ecl-cl-libuv
  (sbcl-package->ecl-package sbcl-cl-libuv))

(define-public sbcl-cl-libxml2
  (let ((commit "8d03110c532c1a3fe15503fdfefe82f60669e4bd"))
    (package
      (name "sbcl-cl-libxml2")
      (version (git-version "0.3.4" "1" commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/archimag/cl-libxml2")
               (commit commit)))
         (file-name (git-file-name "cl-libxml2" version))
         (sha256
          (base32 "09049c13cfp5sc6x9lrw762jd7a9qkfq5jgngqgrzn4kn9qscarw"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       `(("alexandria" ,sbcl-alexandria)
         ("cffi" ,sbcl-cffi)
         ("flexi-streams" ,sbcl-flexi-streams)
         ("garbage-pools" ,sbcl-garbage-pools)
         ("iterate" ,sbcl-iterate)
         ("metabang-bind" ,sbcl-metabang-bind)
         ("puri" ,sbcl-puri)
         ;; Non-Lisp inputs:
         ("libxml2" ,libxml2)
         ("libxslt" ,libxslt)))
      (native-inputs
       (list sbcl-lift))
      (arguments
       `(#:tests? #f ; FIXME: Tests get stuck indefinitely
         #:phases
         (modify-phases %standard-phases
           (add-after 'unpack 'fix-paths
             (lambda* (#:key inputs outputs #:allow-other-keys)
               (substitute* "tree/xtree.lisp"
                 (("libxml2.so.2")
                  (string-append (assoc-ref inputs "libxml2") "/lib/libxml2.so")))
               (let ((libxslt (assoc-ref inputs "libxslt")))
                 (substitute* "xslt/xslt.lisp"
                   (("libxslt.so.1")
                    (string-append libxslt "/lib/libxslt.so"))
                   (("libexslt.so.0")
                    (string-append libxslt "/lib/libexslt.so"))
                   (("cllibxml2.so")
                    (string-append (assoc-ref outputs "out") "/lib/cllibxml2.so"))))
               #t))
           (add-before 'build 'build-helper-library
             (lambda* (#:key inputs outputs #:allow-other-keys)
               (let ((prefix-dir (string-append (assoc-ref outputs "out"))))
                 (mkdir-p (string-append prefix-dir "/lib"))
                 (invoke "make" "-C" "foreign" "install"
                         "INSOPTS="
                         (string-append "PREFIX=" prefix-dir))
                 #t)))
           (add-after 'unpack 'fix-tests
             (lambda _
               (substitute* '("cl-libxml2.asd" "cl-libxslt.asd" "xfactory.asd")
                 ((" :force t") ""))
               #t)))))
      (home-page "https://web.archive.org/web/20160121073421/http://cl-libxml2.googlecode.com/svn/doc/index.html")
      (synopsis "High-level wrapper around libxml2 and libxslt libraries")
      (description
       "cl-libxml2 is high-level Common Lisp wrapper around the @code{libxml2}
and @code{libxslt} libraries.

@itemize
@item Interfaces for tree manipulation (like @code{cxml-stp}).
@item Interface for HTML 4.0 non-validating parsers.
@item Specific APIs to process HTML trees, especially serialization.
@item XPath API.
@item XSLT API.
@item Custom URL resolvers.
@item XPath extension functions.
@item XSLT extension elements.
@item Translates @code{libxml2} and @code{libxslt} errors to Lisp conditions.
@item Extends the Common Lisp @code{iterate} library with custom drivers for
child nodes enumeration, etc.
@item The @code{XFACTORY} system provides a simple and compact syntax for XML generation.
@end itemize\n")
      (license license:llgpl))))

(define-public cl-libxml2
  (sbcl-package->cl-source-package sbcl-cl-libxml2))

(define-public ecl-cl-libxml2
  (sbcl-package->ecl-package sbcl-cl-libxml2))

(define-public sbcl-cl-libyaml
  (let ((commit "a7fe9f68bddfd00b7ca467b65b3b41b276336843")
        (revision "1"))
    (package
      (name "sbcl-cl-libyaml")
      (version (git-version "0.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/eudoxia0/cl-libyaml")
               (commit commit)))
         (file-name (git-file-name "cl-libyaml" version))
         (sha256
          (base32
           "06pvmackyhq03rjmihpx6w63m6cy8wx78ll5xpwwvd85bgrqq817"))))
      (build-system asdf-build-system/sbcl)
      (native-inputs
       (list sbcl-fiveam))
      (inputs
       `(("cffi" ,sbcl-cffi)
         ("libyaml" ,libyaml)))
      (arguments
       '(#:phases
         (modify-phases %standard-phases
           (add-after 'unpack 'fix-paths
             (lambda* (#:key inputs #:allow-other-keys)
               (substitute* "src/library.lisp"
                 (("libyaml.so")
                  (string-append (assoc-ref inputs "libyaml")
                                 "/lib/libyaml.so"))))))))
      (home-page "https://github.com/eudoxia0/cl-libyaml")
      (synopsis "Libyaml bindings for Common Lisp")
      (description
        "This is a binding to the libyaml library.  It's not meant as
a full library for YAML, just a bare binding with a couple of utility macros.
For a YAML parser and emitter using this, check out cl-yaml.")
      (license license:expat))))

(define-public cl-libyaml
  (sbcl-package->cl-source-package sbcl-cl-libyaml))

(define-public ecl-cl-libyaml
  (sbcl-package->ecl-package sbcl-cl-libyaml))

(define-public sbcl-cl-locale
  (let ((commit "0a36cc0dcf5e0a8c8bf97869cd6199980ca25eec")
        (revision "1"))
    (package
      (name "sbcl-cl-locale")
      (version (git-version "0.1.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/fukamachi/cl-locale")
               (commit commit)))
         (file-name (git-file-name "cl-locale" version))
         (sha256
          (base32 "1rhannhpsw1yg1fpflam483a3w9qb1izgyvmnmiddv3dn4qsmn9p"))))
      (build-system asdf-build-system/sbcl)
      (arguments
       '(#:asd-systems '("cl-locale-test" "cl-locale")))
      (native-inputs
       `(("prove" ,sbcl-prove)
         ("flexi-streams" ,sbcl-flexi-streams)))
      (inputs
       `(("anaphora" ,sbcl-anaphora)
         ("arnesi" ,sbcl-arnesi)
         ("cl-annot" ,sbcl-cl-annot)
         ("cl-syntax" ,sbcl-cl-syntax)))
      (home-page "https://github.com/fukamachi/cl-locale")
      (synopsis "Internalization library for Common Lisp")
      (description
       "This package provides a Common Lisp translation library similar to
CL-I18N and CL-L10N.")
      (license license:llgpl))))

(define-public cl-locale
  (sbcl-package->cl-source-package sbcl-cl-locale))

(define-public ecl-cl-locale
  (sbcl-package->ecl-package sbcl-cl-locale))

(define-public sbcl-cl-log
  (let ((commit "8f4b766d51e02245c310526cf1e4534ce634f837")
        (revision "1"))
    (package
     (name "sbcl-cl-log")
     (version "1.0.1")
     (source
      (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/nicklevine/cl-log")
             (commit commit)))
       (sha256
        (base32 "1r3z9swy1b59swvaa5b97is9ysrfmjvjjhhw56p7p5hqg93b92ak"))
       (file-name (git-file-name "cl-log" version))))
     (build-system asdf-build-system/sbcl)
     (synopsis "Common Lisp general purpose logging utility")
     (description "CL-LOG is a general purpose logging utility, loosely modelled
in some respects after Gary King's Log5.  Its features include: logging to
several destinations at once, via \"messengers\", each messenger is tailored to
accept some log messages and reject others, and this tailoring can be changed
on-the-fly, very rapid processing of messages which are rejected by all
messengers, fully independent use of the utility by several different
sub-systems in an application, support for messengers which cl:format text to a
stream, support for messengers which do not invoke cl:format, timestamps in
theory accurate to internal-time-units-per-second.")
     (home-page "https://github.com/nicklevine/cl-log")
     (license license:expat))))

(define-public cl-log
  (sbcl-package->cl-source-package sbcl-cl-log))

(define-public ecl-cl-log
  (sbcl-package->ecl-package sbcl-cl-log))

(define-public sbcl-cl-markdown
  ;; The latest changes with fixes are not released yet, see
  ;; https://github.com/hraban/cl-markdown/issues/9
  (let ((commit "3788802199228b49d0e06c3feb80c1c22af05cfc")
        (revision "0"))
    (package
      (name "sbcl-cl-markdown")
      (version (git-version "0.10.6" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/hraban/cl-markdown")
               (commit commit)))
         (file-name (git-file-name "cl-markdown" version))
         (sha256
          (base32 "1algqwmafipyf194cx9wfhg0pdx1ppx6s444p1pm8yaycbsyla1v"))))
      (build-system asdf-build-system/sbcl)
      (native-inputs
       (list sbcl-lift sbcl-trivial-shell))
      (inputs
       (list sbcl-anaphora
             sbcl-cl-containers
             sbcl-cl-ppcre
             sbcl-dynamic-classes
             sbcl-metabang-bind
             sbcl-metatilities-base))
      (home-page "https://common-lisp.net/project/cl-markdown/")
      (synopsis "Common Lisp rewrite of Markdown")
      (description
       "This is an implementation of a Markdown parser in Common Lisp.")
      (license license:expat))))

(define-public cl-markdown
  (sbcl-package->cl-source-package sbcl-cl-markdown))

(define-public ecl-cl-markdown
  (let ((pkg (sbcl-package->ecl-package sbcl-cl-markdown)))
    (package
      (inherit pkg)
      (arguments
       ;; XXX: Tests fail with "The function LIFT::GET-BACKTRACE-AS-STRING is
       ;; undefined" on ECL.
       ;; See https://github.com/hraban/cl-markdown/issues/11
       '(#:tests? #f)))))

(define-public sbcl-cl-markless
  (let ((commit "a0e145c03103bd3bf7e275d5ac0e19e8381eb844")
        (revision "1"))
    (package
      (name "sbcl-cl-markless")
      (version (git-version "1.1.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/Shirakumo/cl-markless")
               (commit commit)))
         (file-name (git-file-name "cl-markless" version))
         (sha256
          (base32 "154ax1yk0b1035yij29c5pgfn7ifghrxy821mk68wyljg8afgvh5"))))
      (build-system asdf-build-system/sbcl)
      (native-inputs
       (list sbcl-parachute))
      (inputs
       (list sbcl-3bmd
             sbcl-babel
             sbcl-command-line-arguments
             sbcl-documentation-utils
             sbcl-plump
             sbcl-trivial-gray-streams
             sbcl-trivial-indent
             sbcl-trivial-mimes
             sbcl-zip))
      (arguments
       '(#:asd-systems '("cl-markless"
                         "cl-markless-plump"
                         "cl-markless-epub"
                         "cl-markless-markdown"
                         "cl-markless-standalone")))
      (home-page "https://shirakumo.github.io/cl-markless/")
      (synopsis "Parser implementation for Markless")
      (description "This is an implementation of the \"Markless
standard\" (@url{https://github.com/shirakumo/markless}) at version 1.0.  It
handles the parsing of plaintext from a stream into an abstract syntax tree
composed out of strings and component objects.  From there the AST can be
easily compiled into a target markup language like HTML.")
      (license license:zlib))))

(define-public cl-markless
  (sbcl-package->cl-source-package sbcl-cl-markless))

(define-public ecl-cl-markless
  (sbcl-package->ecl-package sbcl-cl-markless))

(define-public sbcl-cl-markup
  (let ((commit "e0eb7debf4bdff98d1f49d0f811321a6a637b390"))
    (package
      (name "sbcl-cl-markup")
      (version (git-version "0.1" "1" commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/arielnetworks/cl-markup/")
               (commit commit)))
         (file-name (git-file-name "cl-markup" version))
         (sha256
          (base32
           "10l6k45971dl13fkdmva7zc6i453lmq9j4xax2ci6pjzlc6xjhp7"))))
      (build-system asdf-build-system/sbcl)
      (home-page "https://github.com/arielnetworks/cl-markup/")
      (synopsis "Markup generation library for Common Lisp")
      (description
       "A modern markup generation library for Common Lisp that features:

@itemize
@item Fast (even faster through compiling the code)
@item Safety
@item Support for multiple document types (markup, xml, html, html5, xhtml)
@item Output with doctype
@item Direct output to stream
@end itemize\n")
      (license license:lgpl3+))))

(define-public cl-markup
  (sbcl-package->cl-source-package sbcl-cl-markup))

(define-public ecl-cl-markup
  (sbcl-package->ecl-package sbcl-cl-markup))

(define-public sbcl-cl-mathstats
  (let ((commit "4df38ea1b9de069cf939919253565a9ca9538eca")
        (revision "1"))
    (package
      (name "sbcl-cl-mathstats")
      (version (git-version "0.8.2" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/hraban/cl-mathstats")
               (commit commit)))
         (file-name (git-file-name "cl-mathstats" version))
         (sha256
          (base32 "0gsjvmkmnxc4hp5z9mkm5vsllywqyg7kx8jgz88vnx47yj3va1s8"))))
      (build-system asdf-build-system/sbcl)
      (native-inputs
       (list sbcl-lift))
      (inputs
       (list sbcl-cl-containers sbcl-metatilities-base))
      (home-page "https://github.com/hraban/cl-mathstats")
      (synopsis "Common Lisp collection of mathematical routines")
      (description
       "This package provides Common Lisp math and statistics routines.")
      (license license:expat))))

(define-public cl-mathstats
  (sbcl-package->cl-source-package sbcl-cl-mathstats))

(define-public ecl-cl-mathstats
  (sbcl-package->ecl-package sbcl-cl-mathstats))

(define-public sbcl-cl-messagepack
  (let ((commit "8ff2060ed20677feef8ac01558690df0aeac30b6")
        (revision "0"))
    (package
      (name "sbcl-cl-messagepack")
      (version (git-version "0.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/mbrezu/cl-messagepack")
               (commit commit)))
         (file-name (git-file-name "cl-messagepack" version))
         (sha256
          (base32 "1hjd1q18lz46k46afz94ljflp76mfr30d6z4jrsgd26y2lc4gchc"))))
      (build-system asdf-build-system/sbcl)
      (native-inputs (list sbcl-cl-json sbcl-fiveam))
      (inputs (list sbcl-babel sbcl-closer-mop sbcl-flexi-streams))
      (synopsis "Common Lisp implementation of MessagePack")
      (description
       "This is a Common Lisp implementation of the MessagePack
(@url{http://msgpack.org/}) serialization/deserialization format,
implemented according to
@url{http://wiki.msgpack.org/display/MSGPACK/Format+specification}.")
      (home-page "https://github.com/mbrezu/cl-messagepack")
      (license license:bsd-2))))

(define-public cl-messagepack
  (sbcl-package->cl-source-package sbcl-cl-messagepack))

(define-public ecl-cl-messagepack
  (sbcl-package->ecl-package sbcl-cl-messagepack))

(define-public sbcl-cl-mime
  (let ((commit "d30a28e0a40393bd3af7d138daa05319ed2e9d07")
        (revision "1"))
    (package
      (name "sbcl-cl-mime")
      ;; One commit says "update to cl-mime-0.5.3", even though the .asd is at 0.5.1.
      (version (git-version "0.5.3" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               ;; Maintained fork according to http://www.cliki.net/CL-MIME:
               (url "https://github.com/40ants/cl-mime")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "0qn8if0fj6vzc897pqqqs0m1y107gmzqngpqhqmwrcsp1ckj5k0v"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-cl-ppcre sbcl-cl-base64 sbcl-cl-qprint))
      (native-inputs
       (list sbcl-rove))
      (home-page "https://github.com/40ants/cl-mime/")
      (synopsis "Read and print MIME content in Common Lisp")
      (description
       "This is a Common Lisp library for reading and printing MIME content.
It supports automatic conversion between 7-bit, quoted-printable and base64
encodings.")
      (license license:lgpl2.1))))

(define-public cl-mime
  (sbcl-package->cl-source-package sbcl-cl-mime))

(define-public ecl-cl-mime
  (sbcl-package->ecl-package sbcl-cl-mime))

(define-public sbcl-cl-mimeparse
  (let ((commit "93cbdf6f6fe8a2eb5f652f8adec453eb98ea0547")
        (revision "0"))
    (package
      (name "sbcl-cl-mimeparse")
      (version (git-version "0.0.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/mmontone/cl-mimeparse")
               (commit commit)))
         (file-name (git-file-name "cl-mimeparse" version))
         (sha256
          (base32 "0gdkpi3620va0a3q56svcn1q9f5w0pqfhx30lnldg8fjnrdfiwkk"))))
      (build-system asdf-build-system/sbcl)
      (arguments
       '(#:asd-test-systems '("cl-mimeparse-tests")))
      (native-inputs
       (list sbcl-rt))
      (inputs
       (list sbcl-cl-ppcre sbcl-parse-number))
      (home-page "https://github.com/mmontone/cl-mimeparse/")
      (synopsis "Common Lisp library for parsing MIME types")
      (description
       "This package provides a library for parsing MIME types, in the spirit
of http://code.google.com/p/mimeparse/, with a Common Lisp flavor.")
      (license license:expat))))

(define-public cl-mimeparse
  (sbcl-package->cl-source-package sbcl-cl-mimeparse))

(define-public ecl-cl-mimeparse
  (sbcl-package->ecl-package sbcl-cl-mimeparse))

(define-public clasp-cl-mimeparse
  (sbcl-package->clasp-package sbcl-cl-mimeparse))

(define-public sbcl-cl-mixed
  ;; There are no releases, but this commit is entitled
  ;; "Bump to libmixed-2.4.0".
  (let ((commit "3da661ae199be94f822e3f9ef6bf03bc6456652b")
        (revision "1"))
    (package
      (name "sbcl-cl-mixed")
      (version (git-version "2.1.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/Shirakumo/cl-mixed")
               (commit commit)))
         (file-name (git-file-name "cl-mixed" version))
         (sha256
          (base32 "0i7bb2b3a9i4kgp7dzzs5211xj56zzcpwkjlfxpslfp7iz0685y0"))
         (modules '((guix build utils)))
         (snippet
          ;; Delete bundled libraries.
          `(begin
             (delete-file-recursively "static")))))
      (build-system asdf-build-system/sbcl)
      (arguments
       '(#:asd-systems '("cl-mixed"
                         "cl-mixed-examples"
                         "cl-mixed-flac"
                         "cl-mixed-vorbis"
                         "cl-mixed-alsa"
                         "cl-mixed-jack"
                         "cl-mixed-mpg123"
                         "cl-mixed-mpt"
                         "cl-mixed-out123"
                         "cl-mixed-pulse"
                         "cl-mixed-sdl2"
                         "cl-mixed-wav")
         #:phases
         (modify-phases %standard-phases
           (add-after 'unpack 'fix-paths
             (lambda* (#:key inputs #:allow-other-keys)
               (substitute* "low-level.lisp"
                 (("libmixed.so.2")
                  (search-input-file inputs "/lib/libmixed.so.2"))))))))
      (inputs
       (list libmixed
             sbcl-alexandria
             sbcl-cffi
             sbcl-cl-flac
             sbcl-cl-mpg123
             sbcl-cl-out123
             sbcl-cl-vorbis
             sbcl-documentation-utils
             sbcl-sdl2
             sbcl-static-vectors
             sbcl-trivial-features))
      (home-page "https://shirakumo.github.io/cl-mixed/")
      (synopsis "Extended audio library for Common Lisp")
      (description
       "This package provides CFFI binding to @code{libmixed} audio library for
Common Lisp with support of other audio formats available on GNU/Linux systems:

@itemize

@item @acronym{Alsa, Advanced Linux Sound Architecture}
@item @acronym{Jack, JackAudio toolkit}
@item @acronym{Openmpt, Libopenmpt playback drain for tracker files}
@item @acronym{PulseAudio, PulseAudio based playback drain}
@item Flac (via CL-FLAC)
@item Mpg123 (via CL-MPG123)
@item Ogg/vorbis (via CL-VORBIS)
@item Out123 (via CL-OUT123)
@item WAV

@end itemize")
      (license license:zlib))))

(define-public cl-mixed
  (sbcl-package->cl-source-package sbcl-cl-mixed))

(define-public ecl-cl-mixed
  (sbcl-package->ecl-package sbcl-cl-mixed))

(define-public sbcl-cl-modio
  (let ((commit "b1322bbfb306f5fbd39ef3141150a213603c5d22")
        (revision "2"))
    (package
      (name "sbcl-cl-modio")
      (version (git-version "1.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://codeberg.org/shinmera/cl-modio")
               (commit commit)))
         (sha256
          (base32 "11njccizmpak57fxprvf84xbx45r03xgyrqbdjdhwrj1r1k9fdny"))
         (file-name (git-file-name "cl-modio" version))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-alexandria
             sbcl-zippy
             sbcl-jzon
             sbcl-cl-ppcre
             sbcl-drakma
             sbcl-documentation-utils
             sbcl-language-codes))
      (synopsis "Client library for the mod.io API")
      (description "This is a client library to interact with the
\"mod.io\" (@url{https://mod.io}) platform to manage \"mods\" or extensions
for games and other applications.  It covers the full v1 API and includes
convenience methods to make interacting with the API as well as syncing mods
and so on easy.")
      (home-page "https://codeberg.org/shinmera/cl-modio")
      (license license:zlib))))

(define-public cl-modio
  (sbcl-package->cl-source-package sbcl-cl-modio))

(define-public ecl-cl-modio
  (sbcl-package->ecl-package sbcl-cl-modio))

(define-public sbcl-cl-morse
  (package
    (name "sbcl-cl-morse")
    (version "1.0.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/em7/cl-morse")
             (commit (string-append "v" version))))
       (file-name (git-file-name "cl-morse" version))
       (sha256
        (base32 "01sh34nhbsx2dsrb2r1vkd4j8lzm9gjd5jfi8a4cs4m3djjwhh5i"))))
    (build-system asdf-build-system/sbcl)
    (inputs (list sbcl-cl-ppcre))
    (native-inputs (list sbcl-fiveam))
    (home-page "https://github.com/em7/cl-morse")
    (synopsis "Morse code translation library for Common Lisp")
    (description
     "@code{cl-morse} is a Morse code translation library for Common Lisp.")
    (license license:bsd-3)))

(define-public cl-morse
  (sbcl-package->cl-source-package sbcl-cl-morse))

(define-public ecl-cl-morse
  (sbcl-package->ecl-package sbcl-cl-morse))

(define-public sbcl-cl-mount-info
  (let ((commit "2024f5037a7f63db3e3587dc9972cd7b9318f06b")
        (revision "1"))
    (package
     (name "sbcl-cl-mount-info")
     (version (git-version "0.0.1" revision commit))
     (source
      (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://notabug.org/cage/cl-mount-info.git")
             (commit commit)))
       (file-name (git-file-name "cl-mount-info" version))
       (sha256
        (base32 "0vza9gj9q42nzb5v8aj22lmn4aqx9vrddsb5a343nbwfz89hbh9x"))))
     (build-system asdf-build-system/sbcl)
     (inputs
      (list sbcl-alexandria sbcl-cffi sbcl-cl-ppcre))
     (home-page "https://notabug.org/cage/cl-mount-info.git")
     (synopsis "Library to get information about mounted filesystems")
     (description
      "CL-MOUNT-INFO is a Common Lisp wrapper around @code{getmntent(3)} and
related C functions to get information about the mounted file system.")
     (license license:lgpl3))))

(define-public cl-mount-info
  (sbcl-package->cl-source-package sbcl-cl-mount-info))

(define-public ecl-cl-mount-info
  (sbcl-package->ecl-package sbcl-cl-mount-info))

(define-public sbcl-cl-mpg123
  (let ((commit "5f042c839d2ea4a2ff2a7b60c839d8633d64161d")
        (revision "1"))
    (package
      (name "sbcl-cl-mpg123")
      (version (git-version "1.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/Shirakumo/cl-mpg123")
               (commit commit)))
         (file-name (git-file-name "cl-mpg123" version))
         (sha256
          (base32 "1hl721xaczxck008ax2y3jpkm509ry1sg3lklh2k76764m3ndrjf"))
         (modules '((guix build utils)))
         (snippet
          '(begin
             ;; Remove bundled pre-compiled libraries.
             (delete-file-recursively "static")
             #t))))
      (build-system asdf-build-system/sbcl)
      (arguments
       `(#:asd-systems '("cl-mpg123" "cl-mpg123-example")
         #:phases
         (modify-phases %standard-phases
           (add-after 'unpack 'fix-paths
             (lambda* (#:key inputs #:allow-other-keys)
               (substitute* "low-level.lisp"
                 (("libmpg123.so" all)
                  (string-append (assoc-ref inputs "libmpg123")
                                 "/lib/" all))))))))
      (inputs
       `(("cffi" ,sbcl-cffi)
         ("cl-out123" ,sbcl-cl-out123)
         ("documentation-utils" ,sbcl-documentation-utils)
         ("libmpg123" ,mpg123)
         ("trivial-features" ,sbcl-trivial-features)
         ("trivial-garbage" ,sbcl-trivial-garbage)
         ("verbose" ,sbcl-verbose)))
      (home-page "https://shirakumo.github.io/cl-mpg123/")
      (synopsis "Common Lisp bindings to libmpg123")
      (description
       "This is a bindings and wrapper library to @code{libmpg123} allowing for
convenient, extensive, and fast decoding of MPEG1/2/3 (most prominently mp3)
files.")
      (license license:zlib))))

(define-public cl-mpg123
  (sbcl-package->cl-source-package sbcl-cl-mpg123))

(define-public ecl-cl-mpg123
  (sbcl-package->ecl-package sbcl-cl-mpg123))

(define-public sbcl-cl-murmurhash
  ;; No release.
  (let ((commit "5433f5e95f1cce63a81259a471150834c6a59364")
        (revision "1"))
    (package
      (name "sbcl-cl-murmurhash")
      (version (git-version "0.0.0" revision commit))
      (home-page "https://github.com/ruricolist/cl-murmurhash/")
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url home-page)
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "0251r0mpjm0y3qsm4lm7ncvrkxvgwc53spdm1p2mpayhvkkqqsws"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-babel))
      (native-inputs
       (list sbcl-fiveam))
      (synopsis "32-bit version of Murmurhash3 for Common Lisp")
      (description
       "This Common Lisp package offers an implementation of the 32-bit
variant of MurmurHash3 (@url{https://github.com/aappleby/smhasher}), a fast
non-crytographic hashing algorithm.")
      (license license:expat))))

(define-public cl-murmurhash
  (sbcl-package->cl-source-package sbcl-cl-murmurhash))

(define-public ecl-cl-murmurhash
  (sbcl-package->ecl-package sbcl-cl-murmurhash))

(define-public sbcl-cl-mustache
  (package
    (name "sbcl-cl-mustache")
    (version "0.12.1")
    (source
     (origin
      (method git-fetch)
      (uri (git-reference
            (url "https://github.com/kanru/cl-mustache")
            (commit (string-append "v" version))))
      (file-name (git-file-name "cl-mustache" version))
      (sha256
       (base32 "149xbb6wxq1napliwm9cv729hwcgfnjli6y8hingfixz7f10lhks"))))
    (build-system asdf-build-system/sbcl)
    (home-page "https://github.com/kanru/cl-mustache")
    (synopsis "Common Lisp Mustache template renderer")
    (description "This is a Common Lisp implementation for the Mustache
template system.  More details on the standard are available at
@url{https://mustache.github.io}.")
    (license license:expat)))

(define-public cl-mustache
  (sbcl-package->cl-source-package sbcl-cl-mustache))

(define-public ecl-cl-mustache
  (sbcl-package->ecl-package sbcl-cl-mustache))

(define-public sbcl-cl-mysql
  (let ((commit "ab56c279c1815aec6ca0bfe85164ff7e85cfb6f9")
        (revision "1"))
    (package
      (name "sbcl-cl-mysql")
      (version (git-version "0.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/hackinghat/cl-mysql")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "0dg5ynx2ww94d0qfwrdrm7plkn43h64hs4iiq9mj2s1s4ixnp3lr"))))
      (build-system asdf-build-system/sbcl)
      (native-inputs
       (list sbcl-stefil))
      (inputs
       `(("cffi" ,sbcl-cffi)
         ("mariadb-lib" ,mariadb "lib")))
      (arguments
       `(#:tests? #f ; TODO: Tests require a running server
         #:phases
         (modify-phases %standard-phases
           (add-after 'unpack 'fix-paths
             (lambda* (#:key inputs #:allow-other-keys)
               (substitute* "system.lisp"
                 (("libmysqlclient_r" all)
                  (string-append (assoc-ref inputs "mariadb-lib")
                                 "/lib/"
                                 all)))
               #t)))))
      (synopsis "Common Lisp wrapper for MySQL")
      (description
       "@code{cl-mysql} is a Common Lisp implementation of a MySQL wrapper.")
      (home-page "http://www.hackinghat.com/index.php/cl-mysql")
      (license license:expat))))

(define-public cl-mysql
  (sbcl-package->cl-source-package sbcl-cl-mysql))

(define-public ecl-cl-mysql
  (sbcl-package->ecl-package sbcl-cl-mysql))

(define-public sbcl-cl-num-utils
  (let ((commit "97a88cd34540acf52e872a82ebfef3da0a34fa12")
        (revision "1"))
    (package
      (name "sbcl-cl-num-utils")
      (version (git-version "0.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/tpapp/cl-num-utils")
               (commit commit)))
         (file-name (git-file-name "cl-num-utils" version))
         (sha256
          (base32 "15ihsxxs76xnldmqfsbxybckqjwrxwcpphgghiwzr2mnbqjpdqkh"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-anaphora sbcl-alexandria sbcl-array-operations
             sbcl-cl-slice sbcl-let-plus))
      (native-inputs
       (list sbcl-clunit))
      (home-page "https://github.com/tpapp/cl-num-utils")
      (synopsis "Numerical utilities for Common Lisp")
      (description
       "@code{cl-num-utils} implements simple numerical functions for Common
Lisp, including:
@itemize
@item @code{num=}, a comparison operator for floats
@item simple arithmeric functions, like @code{sum} and @code{l2norm}
@item elementwise operations for arrays
@item intervals
@item special matrices and shorthand for their input
@item sample statistics
@item Chebyshev polynomials
@item univariate rootfinding
@end itemize")
      (license license:boost1.0))))

(define-public cl-num-utils
  (sbcl-package->cl-source-package sbcl-cl-num-utils))

(define-public ecl-cl-num-utils
  (sbcl-package->ecl-package sbcl-cl-num-utils))

(define-public sbcl-cl-octet-streams
  (package
    (name "sbcl-cl-octet-streams")
    (version "1.2")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://codeberg.org/glv/cl-octet-streams")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1hffh98bv4w5yrchagzwqrc43d2p473pvw7ka4kyyvhrr52dk2f8"))))
    (build-system asdf-build-system/sbcl)
    (native-inputs
     (list sbcl-fiveam))
    (inputs
     (list sbcl-trivial-gray-streams))
    (synopsis "In-memory octet streams for Common Lisp")
    (description
     "CL-octet-streams is a library implementing in-memory octet
streams for Common Lisp.  It was inspired by the trivial-octet-streams and
cl-plumbing libraries.")
    (home-page "https://codeberg.org/glv/cl-octet-streams")
    (license license:gpl3+)))

(define-public cl-octet-streams
  (sbcl-package->cl-source-package sbcl-cl-octet-streams))

(define-public ecl-cl-octet-streams
  (sbcl-package->ecl-package sbcl-cl-octet-streams))

(define-public sbcl-cl-online-learning
  (let ((commit "87fbef8a340219e853adb3a5bf44a0470da76964")
        (revision "1"))
    (package
      (name "sbcl-cl-online-learning")
      (version (git-version "0.5" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/masatoi/cl-online-learning")
               (commit commit)))
         (file-name (git-file-name "cl-online-learning" version))
         (sha256
          (base32
           "1lfq04lnxivx59nq5dd02glyqsqzf3vdn4s9b8wnaln5fs8g2ph9"))))
      (build-system asdf-build-system/sbcl)
      (native-inputs
       (list sbcl-prove))
      (inputs
       `(("cl-libsvm-format" ,sbcl-cl-libsvm-format)
         ("cl-store" ,sbcl-cl-store)))
      (home-page "https://github.com/masatoi/cl-online-learning")
      (synopsis "Online Machine Learning for Common Lisp")
      (description
       "This library contains a collection of machine learning algorithms for
online linear classification written in Common Lisp.")
      (license license:expat))))

(define-public cl-online-learning
  (sbcl-package->cl-source-package sbcl-cl-online-learning))

(define-public ecl-cl-online-learning
  (sbcl-package->ecl-package sbcl-cl-online-learning))

(define-public sbcl-cl-opengl
  (let ((commit "e2d83e0977b7e7ac3f3d348d8ccc7ccd04e74d59")
        (revision "1"))
    (package
      (name "sbcl-cl-opengl")
      (version (git-version "0.1.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/3b/cl-opengl")
               (commit commit)))
         (file-name (git-file-name "cl-opengl" version))
         (sha256
          (base32 "0mhqmll09f079pnd6mgswz9nvr6h5n27d4q7zpmm2igf1v460id7"))))
      (build-system asdf-build-system/sbcl)
      (arguments
       `(#:asd-systems '("cl-opengl" "cl-glu" "cl-glut")
         #:phases
         (modify-phases %standard-phases
           (add-after 'unpack 'patch-lib-path
             (lambda* (#:key inputs #:allow-other-keys)
               (substitute* "gl/library.lisp"
                 (("libGL.so" all)
                  (search-input-file inputs "/lib/libGL.so")))
               (substitute* "glu/library.lisp"
                 (("libGLU.so" all)
                  (search-input-file inputs "/lib/libGLU.so")))
               (substitute* "glut/library.lisp"
                 (("libglut.so" all)
                  (search-input-file inputs "/lib/libglut.so"))))))))
      (inputs
       `(("alexandria" ,sbcl-alexandria)
         ("cffi" ,sbcl-cffi)
         ("float-features" ,sbcl-float-features)
         ("freeglut" ,freeglut)
         ("glu" ,glu)
         ("mesa" ,mesa)))
      (home-page "https://github.com/3b/cl-opengl")
      (synopsis "Common Lisp bindings to OpenGL, GLU and GLUT APIs")
      (description
       "This package provides a set of bindings and utilities for accessing the
OpenGL (Mesa), GLU and GLUT (FreeGLUT) APIs using CFFI.")
      (license license:bsd-3))))

(define-public cl-opengl
  (sbcl-package->cl-source-package sbcl-cl-opengl))

(define-public ecl-cl-opengl
  (sbcl-package->ecl-package sbcl-cl-opengl))

(define-public sbcl-cl-out123
  (let ((commit "41771bfd419e7349ad569f8e6fcd8a26d6f9e5b7")
        (revision "2"))
    (package
      (name "sbcl-cl-out123")
      (version (git-version "1.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/Shirakumo/cl-out123")
               (commit commit)))
         (file-name (git-file-name "cl-out123" version))
         (sha256
          (base32 "0ahgc5l5lbpl3ini4pn5crh8b7dlr386pxczl0d4h6djhccxzs4w"))
         (modules '((guix build utils)))
         (snippet
          '(begin
             ;; Remove bundled pre-compiled libraries.
             (delete-file-recursively "static")))))
      (build-system asdf-build-system/sbcl)
      (arguments
       `(#:tests? #f ; No tests
         #:phases
         (modify-phases %standard-phases
           (add-after 'unpack 'fix-paths
             (lambda* (#:key inputs #:allow-other-keys)
               (substitute* "low-level.lisp"
                 (("libout123.so")
                  (search-input-file inputs "/lib/libout123.so"))))))))
      (inputs
       (list mpg123
             sbcl-bordeaux-threads
             sbcl-cffi
             sbcl-documentation-utils
             sbcl-trivial-features
             sbcl-trivial-garbage))
      (home-page "https://shirakumo.github.io/cl-out123/")
      (synopsis "Common Lisp bindings to libout123")
      (description
       "This is a bindings library to @code{libout123} which allows easy
cross-platform audio playback.")
      (license license:zlib))))

(define-public cl-out123
  (sbcl-package->cl-source-package sbcl-cl-out123))

(define-public ecl-cl-out123
  (sbcl-package->ecl-package sbcl-cl-out123))

(define-public sbcl-cl-package-locks
  (let ((commit "96a358ede7cef416d61d2f699e724fe1d9de602c")
        (revision "1"))
    (package
      (name "sbcl-cl-package-locks")
      (version (git-version "0.0.2" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/elliottjohnson/cl-package-locks")
               (commit commit)))
         (file-name (git-file-name "cl-package-locks" version))
         (sha256
          (base32 "0g3gfljnvpgd66ccd2sqawlkwqx4a0wsdrg5180va61w869cgxqq"))))
      (build-system asdf-build-system/sbcl)
      (home-page "https://github.com/elliottjohnson/cl-package-locks")
      (synopsis "Compatibility layer for dealing with package locks")
      (description
       "This is a Common Lisp library providing a unified way to work with
package locks across supported Common Lisp implementations.")
      (license license:expat))))

(define-public cl-package-locks
  (sbcl-package->cl-source-package sbcl-cl-package-locks))

(define-public ecl-cl-package-locks
  (sbcl-package->ecl-package sbcl-cl-package-locks))

(define-public clasp-cl-package-locks
  (sbcl-package->clasp-package sbcl-cl-package-locks))

(define-public sbcl-cl-pango
  (let ((commit "ee4904d19ce22d00eb2fe17a4fe42e5df8ac8701")
        (revision "0"))
    (package
      (name "sbcl-cl-pango")
      (version (git-version "0.5" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/BradWBeer/cl-pango")
               (commit commit)))
         (file-name (git-file-name "cl-pango" version))
         (sha256
          (base32 "0zkn4yn8nkkjr0x1vcy856cvbmnyhdidqz0in8xvd2i93jvw5w0i"))))
      (build-system asdf-build-system/sbcl)
      (arguments
       (list
        #:phases
        #~(modify-phases %standard-phases
            (add-after 'unpack 'fix-paths
              (lambda* (#:key inputs #:allow-other-keys)
                (substitute* "library.lisp"
                  (("libpango-1.0.so")
                   (search-input-file inputs "/lib/libpango-1.0.so"))
                  (("libpangocairo-1.0.so")
                   (search-input-file inputs "/lib/libpangocairo-1.0.so"))))))))
      (inputs
       (list pango
             sbcl-cffi
             sbcl-cl-cairo2
             sbcl-xmls))
      (home-page "https://github.com/BradWBeer/cl-pango")
      (synopsis "Pango bindings for Common Lisp")
      (description
       "This package provides Common Lisp bindings to the pango text layout
library.")
      (license license:expat))))

(define-public cl-pango
  (sbcl-package->cl-source-package sbcl-cl-pango))

(define-public ecl-cl-pango
  (let ((pkg (sbcl-package->ecl-package sbcl-cl-pango)))
    (package
      (inherit pkg)
      (inputs
       (list pango
             ecl-cffi
             ecl-cl-cairo2
             ecl-xmls)))))

(define-public sbcl-cl-pass
  (let ((commit "e58e97c0c0588dc742c061208afb9bc31e4dbd34")
        (revision "1"))
    (package
      (name "sbcl-cl-pass")
      (version (git-version "0.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/eudoxia0/cl-pass")
               (commit commit)))
         (file-name (git-file-name "cl-pass" version))
         (sha256
          (base32 "05qx4jrkxqbqi72cxgswbpnifbdvp9mh7apc7566v522899bh0hb"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-ironclad sbcl-trivial-utf-8 sbcl-split-sequence))
      (native-inputs
       (list sbcl-fiveam))
      (home-page "https://github.com/eudoxia0/cl-pass")
      (synopsis "Password hashing and verification library")
      (description
       "@code{cl-pass} is a password hashing and verification library.")
      (license license:expat))))

(define-public cl-pass
  (sbcl-package->cl-source-package sbcl-cl-pass))

(define-public ecl-cl-pass
  (sbcl-package->ecl-package sbcl-cl-pass))

(define-public sbcl-cl-pcg
  (let ((commit "8263d85ab0ca17fb05637a4430c2d564456bce8f")
        (revision "1"))
    (package
      (name "sbcl-cl-pcg")
      (version (git-version "1.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/sjl/cl-pcg")
               (commit commit)))
         (file-name (git-file-name "cl-pcg" version))
         (sha256
          (base32 "0s57wvvlvshp1gcp9i9d3qcmqhswnxps3i0y7wbb0v8i1a3p46m4"))))
      (build-system asdf-build-system/sbcl)
      (native-inputs
       (list sbcl-1am))
      (home-page "https://github.com/sjl/cl-pcg")
      (synopsis "Permuted congruential generators in Common Lisp")
      (description
       "This is a bare-bones Permuted Congruential Generator implementation in
pure Common Lisp.")
      (license license:expat))))

(define-public cl-pcg
  (sbcl-package->cl-source-package sbcl-cl-pcg))

(define-public ecl-cl-pcg
  (let ((pkg (sbcl-package->ecl-package sbcl-cl-pcg)))
    (package
      (inherit pkg)
      (arguments
       (substitute-keyword-arguments (package-arguments pkg)
         ;; Tests are failing on ECL with:
         ;; PCG.TEST::TEST-REWINDAn error occurred during initialization:
         ;; 40502229875678917802724098623316930025 is not of type
         ;; (INTEGER 0 2305843009213693951)
         ((#:tests? _ #f) #f))))))

(define-public clasp-cl-pcg
  (sbcl-package->clasp-package sbcl-cl-pcg))

(define-public sbcl-cl-pdf
  (let ((commit "0a1cd33b658c7101766781c534455d4d9e5972bf")
        (revision "4"))
    (package
      (name "sbcl-cl-pdf")
      (version (git-version "2.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/mbattyani/cl-pdf")
               (commit commit)))
         (file-name (git-file-name "cl-pdf" version))
         (sha256
          (base32 "1x88fvk3kxi3k6a84iajb6myw67z8n3plfidq8d4c26ymiz0kvfm"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-iterate sbcl-zpb-ttf))
      (arguments
       `(#:asd-systems '("cl-pdf" "cl-pdf-parser")))
      (home-page "https://github.com/mbattyani/cl-pdf")
      (synopsis "Common Lisp library for generating PDF files")
      (description
       "CL-PDF is a cross-platform Common Lisp library for generating PDF
files.")
      (license license:bsd-2))))

(define-public cl-pdf
  (sbcl-package->cl-source-package sbcl-cl-pdf))

(define-public ecl-cl-pdf
  (sbcl-package->ecl-package sbcl-cl-pdf))

(define-public sbcl-cl-permutation
  (let ((commit "20c10e9ca56452d2fafc3ec0984dcdf78b4f4b19")
        (revision "0"))
    (package
      (name "sbcl-cl-permutation")
      (version (git-version "0.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/stylewarning/cl-permutation")
               (commit commit)))
         (file-name (git-file-name "cl-permutation" version))
         (sha256
          (base32 "0i932g0k50y24hxizni6zfya4kcw77yk3b0llivm9g50s7fxj9dk"))))
      (build-system asdf-build-system/sbcl)
      (native-inputs (list sbcl-fiasco))
      (inputs
       (list sbcl-alexandria
             sbcl-bordeaux-fft
             sbcl-cl-algebraic-data-type
             sbcl-cl-cont
             sbcl-closer-mop
             sbcl-iterate
             sbcl-priority-queue))
      (synopsis "Permutations and permutation groups in Common Lisp")
      (description
       "This is a Commin Lisp library for operating on permutations and
permutation groups.")
      (home-page "https://github.com/stylewarning/cl-permutation")
      (license license:bsd-3))))

(define-public cl-permutation
  (sbcl-package->cl-source-package sbcl-cl-permutation))

(define-public ecl-cl-permutation
  (sbcl-package->ecl-package sbcl-cl-permutation))

(define-public sbcl-cl-portaudio
  (let ((commit "c50cd061c25216a736f684e45101f5c0188a384f")
        (revision "1"))
    (package
      (name "sbcl-cl-portaudio")
      (version (git-version "1.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/filonenko-mikhail/cl-portaudio")
               (commit commit)))
         (file-name (git-file-name "cl-portaudio" version))
         (sha256
          (base32 "177c6bgf30caj5qpzfnzhbamax7c5zm2p4911mw7fay94vjs7zyb"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list portaudio sbcl-cffi sbcl-ffa))
      (arguments
       (list #:tests? #f ; Tests need access to sound cards
             #:phases
             #~(modify-phases %standard-phases
                 (add-after 'unpack 'fix-paths
                   (lambda* (#:key inputs #:allow-other-keys)
                     (substitute* "src/portaudio.lisp"
                       (("libportaudio\\.so")
                        (search-input-file inputs "/lib/libportaudio.so"))))))))
      (synopsis "Common Lisp bindings to portaudio")
      (description
       "This package provides audio input and output functions to Common Lisp
using bindings to the portaudio library.")
      (home-page "https://github.com/filonenko-mikhail/cl-portaudio")
      (license license:expat))))

(define-public cl-portaudio
  (sbcl-package->cl-source-package sbcl-cl-portaudio))

(define-public ecl-cl-portaudio
  (sbcl-package->ecl-package sbcl-cl-portaudio))

(define-public sbcl-cl-posix-mqueue
  (let ((commit "8977370c7206d1f62bd1be80f4254af40654b83f")
        (revision "1"))
    (package
      (name "sbcl-cl-posix-mqueue")
      (version (git-version "0.1.2" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/xFA25E/cl-posix-mqueue")
               (commit commit)))
         (file-name (git-file-name "cl-posix-mqueue" version))
         (sha256
          (base32 "04519rg8vc782z097dzlb8nx0skab2fy2zd0m60r6mz2nw8xdvh6"))))
      (build-system asdf-build-system/sbcl)
      (arguments
       `(#:phases
         (modify-phases %standard-phases
           (add-after 'unpack 'patch-librt-path
             (lambda* (#:key inputs #:allow-other-keys)
               (substitute* "src/spec.lisp"
                 (("librt.so" all)
                  (string-append (assoc-ref inputs "glibc") "/lib/" all))))))))
      (native-inputs
       `(("cl-ppcre" ,sbcl-cl-ppcre)
         ("rove" ,sbcl-rove)))
      (inputs
       `(("alexandria" ,sbcl-alexandria)
         ("babel" ,sbcl-babel)
         ("cffi" ,sbcl-cffi)
         ("glibc" ,glibc)
         ("local-time" ,sbcl-local-time)))
      (home-page "https://github.com/xFA25E/cl-posix-mqueue")
      (synopsis "Common Lisp binding to POSIX mqueue")
      (description
       "This package provides Common Lisp bindings to POSIX message queue, an
@acronym{IPC, Inter-Process Communication} method that is easy to use and quick
to setup.")
      (license license:gpl3))))

(define-public cl-posix-mqueue
  (sbcl-package->cl-source-package sbcl-cl-posix-mqueue))

(define-public ecl-cl-posix-mqueue
  (sbcl-package->ecl-package sbcl-cl-posix-mqueue))

(define-public sbcl-cl-ppcre
  (package
    (name "sbcl-cl-ppcre")
    (version "2.1.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/edicl/cl-ppcre")
             (commit (string-append "v" version))))
       (file-name (git-file-name "cl-ppcre" version))
       (sha256
        (base32 "0dwvr29diqzcg5n6jvbk2rnd90i05l7n828hhw99khmqd0kz7xsi"))))
    (build-system asdf-build-system/sbcl)
    (native-inputs
     (list sbcl-flexi-streams))
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'disable-ppcre-unicode
           ;; cl-ppcre and cl-ppcre-unicode are put in different packages
           ;; to work around the circular dependency between edicl/cl-ppcre
           ;; and edicl/cl-unicode.
           (lambda _
             (delete-file "cl-ppcre-unicode.asd")
             #t)))))
    (synopsis "Portable regular expression library for Common Lisp")
    (description "CL-PPCRE is a portable regular expression library for Common
Lisp, which is compatible with perl.  It is pretty fast, thread-safe, and
compatible with ANSI-compliant Common Lisp implementations.")
    (home-page "http://weitz.de/cl-ppcre/")
    (license license:bsd-2)))

(define-public cl-ppcre
  (sbcl-package->cl-source-package sbcl-cl-ppcre))

(define-public ecl-cl-ppcre
  (sbcl-package->ecl-package sbcl-cl-ppcre))

(define-public clasp-cl-ppcre
  (sbcl-package->clasp-package sbcl-cl-ppcre))

(define-public sbcl-cl-ppcre-unicode
  (package (inherit sbcl-cl-ppcre)
    (name "sbcl-cl-ppcre-unicode")
    (inputs
     (list sbcl-cl-ppcre sbcl-cl-unicode))
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'disable-ppcre
           ;; cl-ppcre and cl-ppcre-unicode are put in different packages
           ;; to work around the circular dependency between edicl/cl-ppcre
           ;; and edicl/cl-unicode.
           (lambda _
             (delete-file "cl-ppcre.asd")
             #t)))))))

(define-public cl-ppcre-unicode
  (sbcl-package->cl-source-package sbcl-cl-ppcre-unicode))

(define-public ecl-cl-ppcre-unicode
  (sbcl-package->ecl-package sbcl-cl-ppcre-unicode))

(define-public sbcl-cl-prevalence
  (let ((commit "e6b27640ce89ae5f8af38beb740e319bb6cd2368")
        (revision "6"))
    (package
      (name "sbcl-cl-prevalence")
      (build-system asdf-build-system/sbcl)
      (version (git-version "5" revision commit))
      (home-page "https://github.com/40ants/cl-prevalence")
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url home-page)
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "1lb957ivshgp56phqhvhsmnc4r55x5shvi3mpsan2xsm4hvqspp0"))))
      (inputs
       (list sbcl-moptilities sbcl-s-sysdeps sbcl-s-xml))
      (native-inputs
       (list sbcl-fiveam sbcl-find-port))
      (arguments
       (list #:phases
             #~(modify-phases %standard-phases
                 (add-after 'unpack 'fix-build-with-usocket-bt2
                   (lambda _
                     ;; See https://github.com/40ants/cl-prevalence/pull/27
                     (substitute* "src/master-slave.lisp"
                       (("stop-process \\(bt:thread-name server-thread\\)")
                        "stop-process (bt2:thread-name server-thread)")))))))
      (synopsis "Implementation of object prevalence for Common Lisp")
      (description "This Common Lisp library implements object prevalence (see
@url{https://en.wikipedia.org/wiki/System_prevalence}).  It allows
for (de)serializing to and from s-exps as well as XML.  Serialization of arbitrary
classes and cyclic data structures are supported.")
      (license license:llgpl))))

(define-public cl-prevalence
  (sbcl-package->cl-source-package sbcl-cl-prevalence))

(define-public ecl-cl-prevalence
  (sbcl-package->ecl-package sbcl-cl-prevalence))

(define-public sbcl-cl-progress-bar
  (let ((commit "9374170858663c8fe829e9fb5a29bd2cb48d95ae"))
    (package
      (name "sbcl-cl-progress-bar")
      (version (git-version "0.0.0" "1" commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/sirherrbatka/cl-progress-bar/")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "1ldb4qhmx431n3lsq71ynwb9ybazbfqd55icjbhi06mj52ngndir"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-bordeaux-threads sbcl-documentation-utils-extensions))
      (home-page "https://github.com/sirherrbatka/cl-progress-bar/")
      (synopsis "Progress bars in Common Lisp")
      (description
       "This library provides almost the same code as used inside Quicklisp
for drawning progress bars")
      (license license:expat))))

(define-public cl-progress-bar
  (sbcl-package->cl-source-package sbcl-cl-progress-bar))

(define-public ecl-cl-progress-bar
  (sbcl-package->ecl-package sbcl-cl-progress-bar))

(define-public sbcl-cl-project
  (let ((commit "151107014e534fc4666222d57fec2cc8549c8814")
        (revision "1"))
    (package
      (name "sbcl-cl-project")
      (version (git-version "0.3.1" revision commit))
      (home-page "https://github.com/fukamachi/cl-project")
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url home-page)
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "1rmh6s1ncv8s2yrr14ja9wisgg745sq6xibqwb341ikdicxdp26y"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       `(("cl-emb" ,sbcl-cl-emb)
         ("cl-ppcre" ,sbcl-cl-ppcre)
         ("local-time" ,sbcl-local-time)
         ("prove" ,sbcl-prove)))
      (arguments
       ;; Tests depend on caveman, which in turns depends on cl-project.
       '(#:tests? #f))
      (synopsis "Generate a skeleton for modern Common Lisp projects")
      (description "This library provides a modern project skeleton generator.
In contract with other generators, CL-Project generates one package per file
and encourages unit testing by generating a system for unit testing, so you
can begin writing unit tests as soon as the project is generated.")
      (license license:llgpl))))

(define-public cl-project
  (sbcl-package->cl-source-package sbcl-cl-project))

(define-public ecl-cl-project
  (sbcl-package->ecl-package sbcl-cl-project))

(define-public sbcl-cl-punch
  (package
    (name "sbcl-cl-punch")
    (version "0.2")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/windymelt/cl-punch")
             (commit (string-append "v" version))))
       (file-name (git-file-name "cl-punch" version))
       (sha256
        (base32 "1vmbaz9y9lq4wvi8mfbyif8vc9yfk2i0qd3ysbzl152wx32dbzs3"))))
    (build-system asdf-build-system/sbcl)
    (native-inputs
     (list sbcl-prove))
    (inputs
     (list sbcl-cl-syntax))
    (home-page "https://github.com/windymelt/cl-punch")
    (synopsis "Anonymous lambda literal in Common Lisp, respecting Scala")
    (description
     "CL-PUNCH is a Scala-like anonymous lambda literal.")
    (license license:expat )))

(define-public cl-punch
  (sbcl-package->cl-source-package sbcl-cl-punch))

(define-public ecl-cl-punch
  (sbcl-package->ecl-package sbcl-cl-punch))

(define-public sbcl-cl-qprint
  (let ((commit "bfe398551cbfb7ca84a9ba59a26a1116ac5c06eb")
        (revision "1"))
    (package
      (name "sbcl-cl-qprint")
      (version (git-version "0.9.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/eugeneia/cl-qprint/")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "099h0rrdzxnlmn8avi72mg2dl0kccp7w01b2p9nwyy4b8yr32cir"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-flexi-streams))
      (home-page "https://github.com/eugeneia/cl-qprint/")
      (synopsis "Implementation of the quoted-printable encoding")
      (description
       "This Common Lisp library implements the quoted-printable encoding as
described in RFC 2045 (see @url{http://tools.ietf.org/html/rfc2045}).")
      (license license:lgpl2.1))))

(define-public cl-qprint
  (sbcl-package->cl-source-package sbcl-cl-qprint))

(define-public ecl-cl-qprint
  (sbcl-package->ecl-package sbcl-cl-qprint))

(define-public sbcl-cl-qrencode
  (package
    (name "sbcl-cl-qrencode")
    (version "0.1.2")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/jnjcc/cl-qrencode")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1l5k131dchbf6cj8a8xqa731790p01p3qa1kdy2wa9dawy3ymkxr"))))
    (build-system asdf-build-system/sbcl)
    (native-inputs
     (list sbcl-lisp-unit))
    (inputs
     (list sbcl-zpng))
    (synopsis "QR code encoder for Common Lisp")
    (description
     "This Common Lisp library provides function to make QR codes and to save
them as PNG files.")
    (home-page "https://github.com/jnjcc/cl-qrencode")
    (license license:gpl2+)))

(define-public cl-qrencode
  (sbcl-package->cl-source-package sbcl-cl-qrencode))

(define-public ecl-cl-qrencode
  (sbcl-package->ecl-package sbcl-cl-qrencode))

(define-public sbcl-cl-randist
  (package
    (name "sbcl-cl-randist")
    (version "0.4.2")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/lvaruzza/cl-randist")
             (commit "f088a54b540a7adefab7c04094a6103f9edda3d0")))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "0l8hyd6nbxb7f50vyxz3rbbm7kgr1fnadc40jywy4xj5vi5kpj5g"))))
    (build-system asdf-build-system/sbcl)
    (synopsis "Random distributions for Common Lisp")
    (description
     "Manual translation from C to Common Lisp of some random number
generation functions from the GSL library.")
    (home-page "https://github.com/lvaruzza/cl-randist")
    (license license:bsd-2)
    (arguments
     `(#:tests? #f))))

(define-public cl-randist
  (sbcl-package->cl-source-package sbcl-cl-randist))

(define-public ecl-cl-randist
  (sbcl-package->ecl-package sbcl-cl-randist))

(define-public sbcl-cl-random
  (let ((commit "5bb65911037f95a4260bd29a594a09df3849f4ea")
        (revision "1"))
    (package
      (name "sbcl-cl-random")
      (version (git-version "0.0.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/tpapp/cl-random")
               (commit commit)))
         (file-name (git-file-name "cl-random" version))
         (sha256
          (base32 "0jn80xphyvyp2v72acr6b8a2f6dw06myr5vrjfl14brsvks7wr89"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-alexandria
             sbcl-anaphora
             sbcl-array-operations
             sbcl-cl-rmath
             sbcl-cl-slice
             sbcl-gsll
             sbcl-let-plus
             sbcl-lla
             sbcl-numerical-utilities))
      (native-inputs
       (list sbcl-clunit))
      (arguments
       (list #:phases
             #~(modify-phases %standard-phases
                 (add-after 'unpack 'fix-build
                   ;; Fixes to use numerical-utils instead of the deprecated
                   ;; cl-num-utils.
                   (lambda _
                     (substitute* (list "cl-random.asd"
                                        "src/package.lisp")
                       (("cl-num-utils")
                        "num-utils"))
                     (substitute* (list "src/continuous-time.lisp"
                                        "src/internals.lisp"
                                        "src/random.lisp"
                                        "src/univariate.lisp")
                       (("clnu:")
                        "nu:")))))))
      (home-page "https://github.com/tpapp/cl-random")
      (synopsis "Random variates for Common Lisp")
      (description
       "@code{cl-random} is a library for generating random draws from various
commonly used distributions, and for calculating statistical functions, such as
density, distribution and quantiles for these distributions.")
      (license license:expat))))

(define-public cl-random
  (sbcl-package->cl-source-package sbcl-cl-random))

(define-public ecl-cl-random
  (sbcl-package->ecl-package sbcl-cl-random))

(define-public sbcl-cl-random-forest
  (let ((commit "fedb36ce99bb6f4d7e3a7dd6d8b058f331308f91")
        (revision "1"))
    (package
      (name "sbcl-cl-random-forest")
      (version (git-version "0.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/masatoi/cl-random-forest")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "0wqh4dxy5hrvm14jgyfypwhdw35f24rsksid4blz5a6l2z16rlmq"))))
      (build-system asdf-build-system/sbcl)
      (native-inputs
       `(("prove" ,sbcl-prove)
         ("trivial-garbage" ,sbcl-trivial-garbage)))
      (inputs
       `(("alexandria" ,sbcl-alexandria)
         ("cl-libsvm-format" ,sbcl-cl-libsvm-format)
         ("cl-online-learning" ,sbcl-cl-online-learning)
         ("lparallel" ,sbcl-lparallel)))
      (arguments
       `(#:tests? #f)) ; The tests download data from the Internet
      (synopsis "Random Forest and Global Refinement for Common Lisp")
      (description
       "CL-random-forest is an implementation of Random Forest for multiclass
classification and univariate regression written in Common Lisp.  It also
includes an implementation of Global Refinement of Random Forest.")
      (home-page "https://github.com/masatoi/cl-random-forest")
      (license license:expat))))

(define-public cl-random-forest
  (sbcl-package->cl-source-package sbcl-cl-random-forest))

(define-public ecl-cl-random-forest
  (sbcl-package->ecl-package sbcl-cl-random-forest))

(define-public sbcl-cl-raylib
  (let ((commit "985ceebef4cb56c651cddc23bd71812f2be38c2d")
        (revision "0"))
    (package
      (name "sbcl-cl-raylib")
      (version (git-version "0.0.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/longlene/cl-raylib")
               (commit commit)))
         (file-name (git-file-name "cl-raylib" version))
         (sha256
          (base32 "1kighj35g6dn426mhr2ppz3gm49v1q4n42ydn619pclrqwyrnc2z"))))
      (build-system asdf-build-system/sbcl)
      (arguments
       `(#:tests? #f ; no tests https://github.com/longlene/cl-raylib/issues/40
         #:phases
         (modify-phases %standard-phases
           (add-after 'unpack 'fix-paths
             (lambda* (#:key inputs #:allow-other-keys)
               (substitute* "src/library.lisp"
                 (("libraylib\\.so")
                  (search-input-file inputs "/lib/libraylib.so"))))))))
      (inputs
       (list raylib
             sbcl-3d-matrices
             sbcl-3d-vectors
             sbcl-alexandria
             sbcl-cffi))
      (home-page "https://github.com/longlene/cl-raylib")
      (synopsis "Common Lisp bindings to raylib")
      (description "This package provides Common Lisp CFFI bindings to the
Raylib game development library.")
      (license license:expat))))

(define-public cl-raylib
  (sbcl-package->cl-source-package sbcl-cl-raylib))

(define-public ecl-cl-raylib
  (sbcl-package->ecl-package sbcl-cl-raylib))

(define-public sbcl-cl-rdkafka
  (package
    (name "sbcl-cl-rdkafka")
    (version "1.1.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/SahilKang/cl-rdkafka")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "0z2g0k0xy8k1p9g93h8dy9wbygaq7ziwagm4yz93zk67mhc0b84v"))))
    (build-system asdf-build-system/sbcl)
    (arguments
     `(#:tests? #f ; Attempts to connect to locally running Kafka
       #:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'fix-paths
           (lambda* (#:key inputs #:allow-other-keys)
             (substitute* "src/low-level/librdkafka-bindings.lisp"
               (("librdkafka" all)
                (string-append (assoc-ref inputs "librdkafka") "/lib/"
                               all))))))))
    (inputs
     `(("bordeaux-threads" ,sbcl-bordeaux-threads)
       ("cffi" ,sbcl-cffi)
       ("librdkafka" ,librdkafka)
       ("lparallel" ,sbcl-lparallel)
       ("trivial-garbage" ,sbcl-trivial-garbage)))
    (home-page "https://github.com/SahilKang/cl-rdkafka")
    (synopsis "Common Lisp client library for Apache Kafka")
    (description "A Common Lisp client library for Apache Kafka.")
    (license license:gpl3)))

(define-public cl-rdkafka
  (sbcl-package->cl-source-package sbcl-cl-rdkafka))

(define-public ecl-cl-rdkafka
  (sbcl-package->ecl-package sbcl-cl-rdkafka))

(define-public sbcl-cl-readline
  (let ((commit "8438c9ebd92ccc95ebab9cc9cbe6c72d44fccc58")
        (revision "1"))
    (package
      (name "sbcl-cl-readline")
      (version (git-version "0.1.2" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/vindarel/cl-readline")
               (commit commit)))
         (file-name (git-file-name "cl-readline" version))
         (sha256
          (base32 "14iskvqfw71ssaav483vmqw62lrpznysjs800gjjppxs785p1fa0"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       `(("alexandria" ,sbcl-alexandria)
         ("cffi" ,sbcl-cffi)
         ("readline" ,readline)))
      (arguments
       '(#:phases
         (modify-phases %standard-phases
           (add-after 'unpack 'fix-paths
             (lambda* (#:key inputs #:allow-other-keys)
               (substitute* "cl-readline.lisp"
                 (("libreadline.so")
                  (string-append (assoc-ref inputs "readline")
                                 "/lib/libreadline.so"))))))))
      (home-page "https://github.com/vindarel/cl-readline")
      (synopsis "Common Lisp bindings to the GNU Readline library")
      (description
        "The Readline library provides a set of functions for use by
applications that allow users to edit command lines as they are typed in.
Both Emacs and vi editing modes are available.  The Readline library includes
additional functions to maintain a list of previously-entered command lines, to
recall and perhaps reedit those lines, and perform csh-like history expansion on
previous commands.")
      (license license:gpl3+))))

(define-public cl-readline
  (sbcl-package->cl-source-package sbcl-cl-readline))

(define-public ecl-cl-readline
  (sbcl-package->ecl-package sbcl-cl-readline))

(define-public sbcl-cl-redis
  (let ((commit "06ff30e9f5b7bc2b4c0f4d18ce1823f0de4d32a7")
        (revision "1"))
    (package
      (name "sbcl-cl-redis")
      (version (git-version "2.3.8" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/vseloved/cl-redis")
               (commit commit)))
         (file-name (git-file-name "cl-redis" version))
         ;; https://github.com/vseloved/cl-redis/pull/42
         (patches (search-patches "sbcl-cl-redis-replace-sbcl-specific-calls.patch"))
         (sha256
          (base32 "1jb82zpiwx7ri86z0xqdynr3m40jnlzinyc0b47lvpbqs7cydrrg"))))
      (build-system asdf-build-system/sbcl)
      (arguments
       '(#:phases
         (modify-phases %standard-phases
           (add-before 'check 'start-redis
             (lambda _
               (system "redis-server --port 6379 &"))))))
      (native-inputs
       (list sbcl-bordeaux-threads
             sbcl-flexi-streams
             redis
             sbcl-should-test))
      (inputs
       (list sbcl-babel
             sbcl-cl-ppcre
             sbcl-cl+ssl
             sbcl-flexi-streams
             sbcl-rutils
             sbcl-usocket))
      (home-page "https://github.com/vseloved/cl-redis")
      (synopsis "Common Lisp client for Redis")
      (description "This is a Common Lisp wrapper for interacting with the
Redis data structure store.")
      (license license:expat))))

(define-public cl-redis
  (sbcl-package->cl-source-package sbcl-cl-redis))

(define-public ecl-cl-redis
  (let ((pkg (sbcl-package->ecl-package sbcl-cl-redis)))
    (package
      (inherit pkg)
      (arguments
       (substitute-keyword-arguments (package-arguments pkg)
         ;; Tests are failing on ECL with:
         ;;   Test L-COMMANDS: An error occurred during initialization:
         ;;   Protocol not found: "tcp".
         ((#:tests? _ #f) #f))))))

(define-public sbcl-cl-reexport
  (let ((commit "03ad7a0e7307e510b3b25a622d3c5f8a077879b4")
        (revision "2"))
    (package
      (name "sbcl-cl-reexport")
      (build-system asdf-build-system/sbcl)
      (version (git-version "0.1" revision commit))
      (home-page "https://github.com/takagi/cl-reexport")
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/takagi/cl-reexport")
               (commit commit)))
         (file-name (git-file-name "cl-reexport" version))
         (sha256
          (base32
           "02la6z3ickhmh2m87ymm2ijh9nkn7l6slskj99l8a1rhps394qqc"))))
      (inputs
       (list sbcl-alexandria))
      (native-inputs
       (list sbcl-prove))
      (synopsis "Reexport external symbols in other Common Lisp packages")
      (description
       "Cl-reexport makes a package reexport symbols which are external
symbols in other Common Lisp packages.  This functionality is intended to be
used with (virtual) hierarchical packages.")
      (license license:llgpl))))

(define-public cl-reexport
  (sbcl-package->cl-source-package sbcl-cl-reexport))

(define-public ecl-cl-reexport
  (sbcl-package->ecl-package sbcl-cl-reexport))

(define-public sbcl-cl-rmath
  (let ((commit "f6add1edda31547691d08e36ccf6c17305161aca")
        (revision "1"))
    (package
      (name "sbcl-cl-rmath")
      (version (git-version "0.0.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/tpapp/cl-rmath")
               (commit commit)))
         (file-name (git-file-name "cl-rmath" version))
         (sha256
          (base32 "1ld8vbpy10paymx2hn0mcgd21i7cjhdrayln1jx0kayqxm12mmk4"))))
      (build-system asdf-build-system/sbcl)
      (arguments
       `(#:phases
         (modify-phases %standard-phases
           (add-after 'unpack 'fix-paths
             (lambda* (#:key inputs #:allow-other-keys)
               (substitute* "cl-rmath.lisp"
                 (("\\(cffi:define-foreign-library librmath" all)
                  (string-append all "\n"
                                 "  (:unix \""
                                 (assoc-ref inputs "librmath")
                                 "/lib/libRmath.so\")"))))))))
      (inputs
       `(("cffi" ,sbcl-cffi)
         ("librmath" ,rmath-standalone)))
      (home-page "https://github.com/tpapp/cl-rmath")
      (synopsis "Common Lisp wrapper for libRmath")
      (description
       "@code{cl-rmath} is a simple, autogenerated foreign interface for the
standalone R API @code{libRmath}.  There has been no effort to provide a
high-level interface for the original library, instead, this library is meant
to serve as a building block for such an interface.")
      (license license:boost1.0))))

(define-public cl-rmath
  (sbcl-package->cl-source-package sbcl-cl-rmath))

(define-public ecl-cl-rmath
  (sbcl-package->ecl-package sbcl-cl-rmath))

(define-public sbcl-cl-semver
  (let ((commit "b125d2c49ea6d370302dde73a6e0841c0e928184")
        (revision "0"))
    (package
      (name "sbcl-cl-semver")
      (version (git-version "0.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/cldm/cl-semver")
               (commit commit)))
         (file-name (git-file-name "cl-semver" version))
         (sha256
          (base32 "1zlcn7lrpvjiixgqm4yxnqqwak1hxfmxmchkpvrly41yhl586ril"))))
      (build-system asdf-build-system/sbcl)
      (native-inputs (list sbcl-stefil))
      (inputs
       (list sbcl-alexandria
             sbcl-esrap
             sbcl-named-readtables))
      (home-page "https://github.com/cldm/cl-semver")
      (synopsis "Semantic version handling in Common Lisp")
      (description
       "This package provides a Common Lisp implementation of the semantic
versioning specification: @url{http://semver.org}.")
      (license license:expat))))

(define-public ecl-cl-semver
  (let ((pkg (sbcl-package->ecl-package sbcl-cl-semver)))
    (package
      (inherit pkg)
      (arguments
       (substitute-keyword-arguments (package-arguments pkg)
         ;; TODO: https://github.com/cldm/cl-semver/issues/9
         ((#:tests? _ #f) #f))))))

(define-public cl-semver
  (sbcl-package->cl-source-package sbcl-cl-semver))

(define-public sbcl-cl-setlocale
  (let ((commit "f660d07dac72bc3e99caae1c6c8a789991e2694c")
        (revision "0"))
    (package
      (name "sbcl-cl-setlocale")
      (version (git-version "0.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/shamazmazum/cl-setlocale")
               (commit commit)))
         (file-name (git-file-name "cl-setlocale" version))
         (sha256
          (base32 "0g1b89yj6n42ayf2074krk3h9yvglqxn54a6i3sxgpsqww2ll2a1"))))
      (build-system asdf-build-system/sbcl)
      (native-inputs (list sbcl-fiveam))
      (inputs (list sbcl-cffi))
      (home-page "https://github.com/shamazmazum/cl-setlocale")
      (synopsis "Common Lisp wrapper around setlocale")
      (description
       "This library provides a tiny Common Lisp wrapper around setlocale(3)
and can be used in conjunction with other FFI wrappers like cl-charms.")
      (license license:bsd-2))))

(define-public cl-setlocale
  (sbcl-package->cl-source-package sbcl-cl-setlocale))

(define-public ecl-cl-setlocale
  (sbcl-package->ecl-package sbcl-cl-setlocale))

(define-public sbcl-cl-slice
  (let ((commit "c531683f287216aebbb0affbe090611fa1b5d697")
        (revision "1"))
    (package
      (name "sbcl-cl-slice")
      (version (git-version "0.1.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/tpapp/cl-slice")
               (commit commit)))
         (file-name (git-file-name "cl-slice" version))
         (sha256
          (base32 "1ybznf4y5lda6bn163jcvj281qzhm24dfcwhbgxmm5n6f27gdccl"))))
      (build-system asdf-build-system/sbcl)
      (native-inputs
       (list sbcl-clunit))
      (inputs
       (list sbcl-alexandria sbcl-anaphora sbcl-let-plus))
      (home-page "https://github.com/tpapp/cl-slice")
      (synopsis "Array slices for Common Lisp")
      (description
       "This package provides a DSL for array slices in Common Lisp.")
      (license license:expat))))

(define-public cl-slice
  (sbcl-package->cl-source-package sbcl-cl-slice))

(define-public ecl-cl-slice
  (sbcl-package->ecl-package sbcl-cl-slice))

(define-public sbcl-cl-slug
  (let ((commit "ffb229d10f0d3f7f54e706791725225e200bf749")
        (revision "1"))
    (package
      (name "sbcl-cl-slug")
      (version (git-version "0.4.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/EuAndreh/cl-slug")
               (commit commit)))
         (file-name (git-file-name "cl-slug" version))
         (sha256
          (base32 "1asdq6xllmsvfw5fky9wblqcx9isac9jrrlkfl7vyxcq1wxrnflx"))))
      (build-system asdf-build-system/sbcl)
      (native-inputs
       (list sbcl-prove))
      (inputs
       `(("ppcre" ,sbcl-cl-ppcre)))
      (home-page "https://github.com/EuAndreh/cl-slug")
      (synopsis "Multi-language slug formatter")
      (description
       "This is a small Common Lisp library to make slugs, mainly for URIs,
from English and beyond.")
      (license license:llgpl))))

(define-public cl-slug
  (sbcl-package->cl-source-package sbcl-cl-slug))

(define-public ecl-cl-slug
  (sbcl-package->ecl-package sbcl-cl-slug))

(define-public sbcl-cl-smtp
  (let ((commit "ed47d326fad867ee11323fa3a0f307b5d40e8f2b")
        (revision "0"))
    (package
      (name "sbcl-cl-smtp")
      (version (git-version "20191031.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://gitlab.common-lisp.net/cl-smtp/cl-smtp")
               (commit commit)))
         (file-name (git-file-name "cl-smtp" version))
         (sha256
          (base32 "0vjjfapcrdc5671jz2d24h8zvpz7skq1x6pi9fvw6ls5sgms6fr0"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-cl+ssl
             sbcl-cl-base64
             sbcl-flexi-streams
             sbcl-trivial-gray-streams
             sbcl-usocket))
      (home-page "https://gitlab.common-lisp.net/cl-smtp/cl-smtp")
      (synopsis "Simple Common Lisp SMTP client")
      (description "This package provides a client for SMTP.")
      (license license:llgpl))))

(define-public cl-smtp
  (sbcl-package->cl-source-package sbcl-cl-smtp))

(define-public ecl-cl-smtp
  (sbcl-package->ecl-package sbcl-cl-smtp))

(define-public sbcl-cl-spark
  (let ((commit "4e34bcebdcf8e45265986eb43ad4ad03bb41a581")
        (revision "1"))
    (package
      (name "sbcl-cl-spark")
      (version (git-version "0.1.13" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/tkych/cl-spark")
               (commit commit)))
         (file-name (git-file-name "cl-spark" version))
         (sha256
          (base32 "0my1fsgi2rjaqkpk934f2bjy63pmnj7faza3fzvnk6k3l66y19nk"))))
      (build-system asdf-build-system/sbcl)
      (native-inputs
       (list sbcl-fiveam))
      (synopsis "Common Lisp library to make histograms")
      (description "This is a Common Lisp library to make histograms using
UTF-8 block characters.")
      (home-page "https://github.com/tkych/cl-spark")
      (license license:expat))))

(define-public cl-spark
  (sbcl-package->cl-source-package sbcl-cl-spark))

(define-public ecl-cl-spark
  (sbcl-package->ecl-package sbcl-cl-spark))

(define-public sbcl-cl-speedy-queue
  (let ((commit "0425c7c62ad3b898a5ec58cd1b3e74f7d91eec4b")
        (revision "1"))
    (package
      (name "sbcl-cl-speedy-queue")
      (version (git-version "0.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/zkat/cl-speedy-queue")
               (commit commit)))
         (file-name (git-file-name "cl-speedy-queue" version))
         (sha256
          (base32 "0czhnvxn9lvbjz9h1lb7y18nqrsq3drq5icd3lqdaa07362alriq"))))
      (build-system asdf-build-system/sbcl)
      (home-page "https://github.com/zkat/cl-speedy-queue")
      (synopsis "Lightweight optimized queue for Common Lisp")
      (description
       "This is a lightweight, non-consing, optimized queue implementation for
Common Lisp.")
      (license license:expat))))

(define-public cl-speedy-queue
  (sbcl-package->cl-source-package sbcl-cl-speedy-queue))

(define-public ecl-cl-speedy-queue
  (sbcl-package->ecl-package sbcl-cl-speedy-queue))

(define-public sbcl-cl-sqlite
  (package
    (name "sbcl-cl-sqlite")
    (version "0.2.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/dmitryvk/cl-sqlite")
             (commit version)))
       (file-name (git-file-name "cl-sqlite" version))
       (sha256
        (base32
         "08iv7b4m0hh7qx2cvq4f510nrgdld0vicnvmqsh9w0fgrcgmyg4k"))))
    (build-system asdf-build-system/sbcl)
    (inputs
     `(("iterate" ,sbcl-iterate)
       ("cffi" ,sbcl-cffi)
       ("sqlite" ,sqlite)))
    (native-inputs
     `(("fiveam" ,sbcl-fiveam)
       ("bordeaux-threads" ,sbcl-bordeaux-threads)))
    (arguments
     `(#:asd-systems '("sqlite")
       #:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'fix-paths
           (lambda* (#:key inputs #:allow-other-keys)
             (substitute* "sqlite-ffi.lisp"
               (("libsqlite3" all) (string-append
                                    (assoc-ref inputs "sqlite")"/lib/" all))))))))
    (home-page "https://common-lisp.net/project/cl-sqlite/")
    (synopsis "Common Lisp binding for SQLite")
    (description
     "The @command{cl-sqlite} package is an interface to the SQLite embedded
relational database engine.")
    (license license:public-domain)))

(define-public cl-sqlite
  (sbcl-package->cl-source-package sbcl-cl-sqlite))

(define-public ecl-cl-sqlite
  (sbcl-package->ecl-package sbcl-cl-sqlite))

(define-public sbcl-cl+ssl
  (let ((commit "17d5cdd65405f1d26e26f3e875e70027d0c8eedb")
        (revision "6"))
    (package
      (name "sbcl-cl+ssl")
      (version (git-version "0.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/cl-plus-ssl/cl-plus-ssl")
               (commit commit)))
         (file-name (git-file-name "cl+ssl" version))
         (sha256
          (base32 "0v0kx2m5355jkdshmj0z923c5rlvdl2n11rb3hjbv3kssdfsbs0s"))))
      (build-system asdf-build-system/sbcl)
      (arguments
       '(#:phases
         (modify-phases %standard-phases
           (add-after 'unpack 'fix-paths
             (lambda* (#:key inputs #:allow-other-keys)
               (substitute* "src/reload.lisp"
                 (("libssl.so" all)
                  (string-append
                   (assoc-ref inputs "openssl") "/lib/" all))
                 (("libcrypto.so" all)
                  (string-append
                   (assoc-ref inputs "openssl") "/lib/" all)))))
           (add-after 'fix-paths 'fix-tests
             (lambda _
               ;; Disable coverall support in tests because of a circular
               ;; dependency: cl+ssl -> cl-coverall -> dexador
               ;;          -> clack -> hunchentoot -> cl+ssl
               (substitute* "cl+ssl.test.asd"
                 (("\\(:feature \\(:or :sbcl :ccl\\) :cl-coveralls\\)")
                  "")))))))
      (native-inputs
       (list ;sbcl-cl-coveralls
             sbcl-fiveam
             sbcl-trivial-sockets))
      (inputs
       (list openssl
             sbcl-alexandria
             sbcl-bordeaux-threads
             sbcl-cffi
             sbcl-flexi-streams
             sbcl-trivial-features
             sbcl-trivial-garbage
             sbcl-trivial-gray-streams
             sbcl-usocket))
      (home-page "https://common-lisp.net/project/cl-plus-ssl/")
      (synopsis "Common Lisp bindings to OpenSSL")
      (description
       "This library is a fork of SSL-CMUCL.  The original SSL-CMUCL source
code was written by Eric Marsden and includes contributions by Jochen Schmidt.
Development into CL+SSL was done by David Lichteblau.")
      (license license:expat))))

(define-public cl-cl+ssl
  (sbcl-package->cl-source-package sbcl-cl+ssl))

(define-public ecl-cl+ssl
  ;; The trivial-sockets system used for the tests doesn't support ECL, so we
  ;; remove it from native-inputs and disable the tests.
  (let ((pkg (sbcl-package->ecl-package sbcl-cl+ssl)))
    (package
      (inherit pkg)
      (native-inputs
       (modify-inputs (package-native-inputs pkg)
         (delete "sbcl-trivial-sockets")))
      (arguments
       (substitute-keyword-arguments (package-arguments pkg)
         ((#:tests? _ #f) #f))))))

(define-public sbcl-cl-steamworks
  (let ((commit "95f25ae89d6ecc1a9461720d91d208e537eb8f17")
        (revision "2"))
    (package
      (name "sbcl-cl-steamworks")
      (version (git-version "1.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://codeberg.org/shinmera/cl-steamworks")
               (commit commit)))
         (sha256
          (base32 "1h9qz603ab62sw0j7yyixb20z05pfgxqpg8mhd8zxhgmfm7cccy7"))
         (file-name (git-file-name "cl-steamworks" version))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-alexandria
             sbcl-babel
             sbcl-cffi
             sbcl-documentation-utils
             sbcl-float-features
             sbcl-pathname-utils
             sbcl-trivial-features
             sbcl-trivial-garbage
             sbcl-trivial-gray-streams))
      (synopsis "Wrapper for the Valve SteamWorks API")
      (description "This is a wrapper library to allow you to interface with
the Valve SteamWorks API.")
      (home-page "https://shinmera.com/docs/cl-steamworks")
      (license license:zlib))))

(define-public cl-steamworks
  (sbcl-package->cl-source-package sbcl-cl-steamworks))

(define-public ecl-cl-steamworks
  (sbcl-package->ecl-package sbcl-cl-steamworks))

(define-public sbcl-cl-store
  (let ((commit "c787337a16ea8cf8a06227f35933a4ec774746b3")
        (revision "1"))
    (package
      (name "sbcl-cl-store")
      (version (git-version "0.8.11" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/skypher/cl-store")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "194srkg8nrym19c6i7zbnkzshc1qhqa82m53qnkirz9fw928bqxr"))))
      (build-system asdf-build-system/sbcl)
      (native-inputs
       (list sbcl-rt))
      (synopsis "Common Lisp library to serialize data")
      (description
       "CL-STORE is a portable serialization package which should give you the
ability to store all Common Lisp data types into streams.")
      (home-page "https://www.common-lisp.net/project/cl-store/")
      (license license:expat))))

(define-public cl-store
  (sbcl-package->cl-source-package sbcl-cl-store))

(define-public ecl-cl-store
  (sbcl-package->ecl-package sbcl-cl-store))

(define-public sbcl-cl-str
  (package
    (name "sbcl-cl-str")
    (version "0.21")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/vindarel/cl-str")
                    (commit version)))
              (sha256
               (base32 "0r9niyvkj7jyc93rxys6pgqazzpl1ybfryjn8jig721xhjxrsblm"))
              (file-name (git-file-name name version))))
    (build-system asdf-build-system/sbcl)
    (inputs
     `(("cl-ppcre" ,sbcl-cl-ppcre)
       ("cl-ppcre-unicode" ,sbcl-cl-ppcre-unicode)
       ("cl-change-case" ,sbcl-cl-change-case)))
    (native-inputs
     (list sbcl-prove))
    (arguments
     `(#:asd-systems '("str")))
    (home-page "https://vindarel.github.io/cl-str")
    (synopsis "Modern, consistent and terse Common Lisp string manipulation library")
    (description "A modern and consistent Common Lisp string manipulation
library that focuses on modernity, simplicity and discoverability:
@code{(str:trim s)} instead of @code{(string-trim '(#\\Space ...) s)}), or
@code{str:concat strings} instead of an unusual format construct; one
discoverable library instead of many; consistency and composability, where
@code{s} is always the last argument, which makes it easier to feed pipes and
arrows.")
    (license license:expat)))

(define-public cl-str
  (sbcl-package->cl-source-package sbcl-cl-str))

(define-public ecl-cl-str
  (sbcl-package->ecl-package sbcl-cl-str))

(define-public sbcl-cl-strftime
  ;; No release.
  (let ((commit "21cb57f2595faa26d687893963f24ec41822b63c"))
    (package
      (name "sbcl-cl-strftime")
      (version (git-version "0.0.0" "1" commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/ruricolist/cl-strftime/")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "00c8hq7vzgb89ab3q7mrp60x743kiqmsk1g51ynhxlqhph2bnslf"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-alexandria sbcl-local-time sbcl-cl-ppcre sbcl-serapeum))
      (native-inputs
       (list sbcl-fiveam sbcl-cffi))
      (home-page "https://github.com/ruricolist/cl-strftime")
      (synopsis "Common Lisp compiler for the strftime language")
      (description
       "CL-STRFTIME is a Common Lisp compiler for the strftime “language.”")
      (license license:expat))))

(define-public cl-strftime
  (sbcl-package->cl-source-package sbcl-cl-strftime))

(define-public ecl-cl-strftime
  (sbcl-package->ecl-package sbcl-cl-strftime))

(define-public sbcl-cl-string-match
  (let ((revision "1")
        (changeset "5048480a61243e6f1b02884012c8f25cdbee6d97"))
    (package
      (name "sbcl-cl-string-match")
      (version (git-version "0" revision changeset))
      (source
       (origin
         (method hg-fetch)
         (uri (hg-reference
               (url "https://github.com/vityok/cl-string-match")
               (changeset changeset)))
         (sha256
          (base32
           "01wn5qx562w43ssy92xlfgv79w7p0nv0wbl76mpmba131n9ziq2y"))
         (file-name (git-file-name "cl-string-match" version))))
      (build-system asdf-build-system/sbcl)
      (inputs
       `(("alexandria" ,sbcl-alexandria)
         ("babel" ,sbcl-babel)
         ("iterate" ,sbcl-iterate)
         ("jpl-queues" ,sbcl-jpl-queues)
         ("jpl-util" ,sbcl-jpl-util)
         ("mgl-pax" ,sbcl-mgl-pax)
         ("parse-float" ,sbcl-parse-float)
         ("proc-parse" ,sbcl-proc-parse)
         ("yacc" ,sbcl-cl-yacc)))
      ;; TODO: Tests are not evaluated properly.
      (native-inputs
       ;; For testing:
       (list sbcl-lisp-unit))
      (arguments
       `(#:tests? #f
         #:phases
         (modify-phases %standard-phases
           (add-after 'unpack 'fix-dependency
             (lambda _
               (substitute* "cl-string-match.asd"
                 ((":mgl-pax")
                  ":mgl-pax/document")))))))
      (synopsis "Set of utilities to manipulate strings in Common Lisp")
      (description
       "@command{cl-strings} is a small, portable, dependency-free set of
utilities that make it even easier to manipulate text in Common Lisp.  It has
100% test coverage and works at least on sbcl, ecl, ccl, abcl and clisp.")
      (home-page "https://github.com/vityok/cl-string-match")
      (license license:bsd-3))))

(define-public cl-string-match
  (sbcl-package->cl-source-package sbcl-cl-string-match))

(define-public ecl-cl-string-match
  (sbcl-package->ecl-package sbcl-cl-string-match))

(define-public sbcl-cl-strings
  (let ((revision "1")
        (commit "93ec4177fc51f403a9f1ef0a8933f36d917f2140"))
    (package
      (name "sbcl-cl-strings")
      (version (git-version "0.0.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/diogoalexandrefranco/cl-strings")
               (commit commit)))
         (sha256
          (base32 "1j8hs54fn0wsf5zfzhhgiva47n9hsmfa74iinahz6nmcs8iy75aj"))
         (file-name (git-file-name "cl-strings" version))))
      (build-system asdf-build-system/sbcl)
      (synopsis "Set of utilities to manipulate strings in Common Lisp")
      (description
       "@command{cl-strings} is a small, portable, dependency-free set of
utilities that make it even easier to manipulate text in Common Lisp.  It has
100% test coverage and works at least on sbcl, ecl, ccl, abcl and clisp.")
      (home-page "https://github.com/diogoalexandrefranco/cl-strings")
      (license license:expat))))

(define-public cl-strings
  (sbcl-package->cl-source-package sbcl-cl-strings))

(define-public ecl-cl-strings
  (sbcl-package->ecl-package sbcl-cl-strings))

(define-public clasp-cl-strings
  (sbcl-package->clasp-package sbcl-cl-strings))

(define-public sbcl-cl-svg
  (let ((commit "1e988ebd2d6e2ee7be4744208828ef1b59e5dcdc")
        (revision "1"))
    (package
      (name "sbcl-cl-svg")
      (version (git-version "0.0.3" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/wmannis/cl-svg")
               (commit commit)))
         (file-name (git-file-name "cl-svg" version))
         (sha256
          (base32 "11rmzimy6j7ln7q5y1h2kw1225rsfb6fpn89qjcq7h5lc8fay0wz"))))
      (build-system asdf-build-system/sbcl)
      (home-page "https://github.com/wmannis/cl-svg")
      (synopsis "Write SVG file format")
      (description
       "This package provides the @code{CL-SVG} Common Lisp system to produce
Scalable Vector Graphics files.")
      (license license:expat))))

(define-public cl-svg
  (sbcl-package->cl-source-package sbcl-cl-svg))

(define-public ecl-cl-svg
  (sbcl-package->ecl-package sbcl-cl-svg))

(define-public sbcl-cl-sxml
  (let ((commit "e5542b1d9bd6cee03ae27547d00660ccfbb60109")
        (revision "1"))
    (package
      (name "sbcl-cl-sxml")
      (version (git-version "0.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/eadmund/cl-sxml")
               (commit commit)))
         (file-name (git-file-name "cl-sxml" version))
         (sha256
          (base32 "1105s9whidq1lf0lli2wdhcfcs5gwzxa0h1x3izx4mp2p7psvciz"))))
      (build-system asdf-build-system/sbcl)
      (inputs (list sbcl-cxml))
      (native-inputs
       (list sbcl-fiveam
             sbcl-flexi-streams))
      (home-page "https://github.com/eadmund/cl-sxml")
      (synopsis "SXML parsing for Common Lisp")
      (description
       "@code{CL-SXML} implements Oleg Kiselyov’s SXML, an S-expression-based
rendering of the XML Infoset.")
      (license license:gpl3+))))

(define-public cl-sxml
  (sbcl-package->cl-source-package sbcl-cl-sxml))

(define-public ecl-cl-sxml
  (sbcl-package->ecl-package sbcl-cl-sxml))

(define-public sbcl-cl-syntax
  (package
    (name "sbcl-cl-syntax")
    (version "0.0.3")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/m2ym/cl-syntax")
             (commit "03f0c329bbd55b8622c37161e6278366525e2ccc")))
       (file-name (git-file-name "cl-syntax" version))
       (sha256
        (base32 "17ran8xp77asagl31xv8w819wafh6whwfc9p6dgx22ca537gyl4y"))))
    (build-system asdf-build-system/sbcl)
    (inputs
     `(("cl-annot" ,sbcl-cl-annot)
       ("cl-interpol" ,sbcl-cl-interpol)
       ("named-readtables" ,sbcl-named-readtables)
       ("trivial-types" ,sbcl-trivial-types)))
    (arguments
     '(#:asd-systems '("cl-syntax"
                       "cl-syntax-annot"
                       "cl-syntax-interpol")))
    (home-page "https://github.com/m2ym/cl-syntax")
    (synopsis "Reader Syntax Conventions for Common Lisp and SLIME")
    (description
     "CL-SYNTAX provides Reader Syntax Conventions for Common Lisp and SLIME.")
    (license license:llgpl)))

(define-public cl-syntax
  (sbcl-package->cl-source-package sbcl-cl-syntax))

(define-public ecl-cl-syntax
  (sbcl-package->ecl-package sbcl-cl-syntax))

(define-public sbcl-cl-syslog
  (let ((commit "d5d46f777f0735938e6f650cf17d814b88b70305")
        (revision "0"))
    (package
      (name "sbcl-cl-syslog")
      (version (git-version "0.2.4" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/mmaul/cl-syslog")
               (commit commit)))
         (file-name (git-file-name "cl-syslog" version))
         (sha256
          (base32 "1qcz55jiqwk91b01hsahxnha884f6zf2883j2m51sqph0mvj69mh"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-alexandria
             sbcl-babel
             sbcl-cffi
             sbcl-global-vars
             sbcl-local-time
             sbcl-split-sequence
             sbcl-usocket))
      (arguments
       (list #:tests? #f))
      (synopsis "Common Lisp interface to local and remote Syslog facilities")
      (description "@code{cl-syslog} is a Common Lisp library that provides
access to the syslog logging facility.")
      (home-page "https://cl-syslog.common-lisp.dev/")
      (license license:bsd-3))))

(define-public cl-syslog
  (sbcl-package->cl-source-package sbcl-cl-syslog))

(define-public ecl-cl-syslog
  (sbcl-package->ecl-package sbcl-cl-syslog))

(define-public sbcl-cl-template
  (let ((commit "46193a9a389bb950530e579eae7e6e5a18184832")
        (revision "0"))
    (package
     (name "sbcl-cl-template")
     (version (git-version "0.0.1" revision commit))
     (home-page "https://github.com/alpha123/cl-template")
     (source
      (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/alpha123/cl-template")
             (commit commit)))
       (file-name (git-file-name "cl-template" version))
       (sha256
        (base32 "1rhg023a2nxsk5x6abd6i0a8sh36aj0bgsh80w60m3b7xlsva2x2"))))
     (build-system asdf-build-system/sbcl)
     (native-inputs
      (list sbcl-fiveam))
     (synopsis "Template engine for Common Lisp")
     (description "@code{cl-template} is a template engine for Common Lisp,
taking inspiration from Ruby's ERb module.")
     (license license:expat))))

(define-public cl-template
  (sbcl-package->cl-source-package sbcl-cl-template))

(define-public ecl-cl-template
  (sbcl-package->ecl-package sbcl-cl-template))

(define-public sbcl-cl-tga
  (let ((commit "4dc2f7b8a259b9360862306640a07a23d4afaacc")
        (revision "0"))
    (package
      (name "sbcl-cl-tga")
      (version (git-version "0.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/fisxoj/cl-tga")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "03k3npmn0xd3fd2m7vwxph82av2xrfb150imqrinlzqmzvz1v1br"))))
      (build-system asdf-build-system/sbcl)
      (home-page "https://github.com/fisxoj/cl-tga")
      (synopsis "TGA file loader for Common Lisp")
      (description
       "Cl-tga was written to facilitate loading @emph{.tga} files into OpenGL
programs.  It's a very simple library, and, at the moment, only supports
non-RLE encoded forms of the files.")
      (license license:expat))))

(define-public cl-tga
  (sbcl-package->cl-source-package sbcl-cl-tga))

(define-public ecl-cl-tga
  (sbcl-package->ecl-package sbcl-cl-tga))

(define-public sbcl-cl-tld
  ;; No release.
  (let ((commit "f5014da8d831fa9481d4181d4450f10a52850c75"))
    (package
      (name "sbcl-cl-tld")
      (version (git-version "0.1" "2" commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/lu4nx/cl-tld")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "0sxnn35gzdby1ixil6zbjg72vli9fcspwzsqimqk455310syx9iv"))))
      (build-system asdf-build-system/sbcl)
      (home-page "https://github.com/lu4nx/cl-tld/")
      (synopsis "Extract the Top Level Domain from domains, in Common Lisp")
      (description
       "This library extracts the TLD (Top Level Domain) from domains.  The
information is taken from @url{https://publicsuffix.org}.")
      (license license:public-domain))))

(define-public cl-tld
  (sbcl-package->cl-source-package sbcl-cl-tld))

(define-public ecl-cl-tld
  (sbcl-package->ecl-package sbcl-cl-tld))

(define-public sbcl-cl-tls
  (let ((commit "2ab4fc3ae7e79e451126a9bb6bc38ca2cd2cb4ba")
        (revision "0"))
    (package
      (name "sbcl-cl-tls")
      (version (git-version "0.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/shrdlu68/cl-tls")
               (commit commit)))
         (file-name (git-file-name "cl-tls" version))
         (sha256
          (base32 "1j6gwv21ibkk6xd1xxm54wgwp09dzqg60b8z72hivpnq8gwm0ba7"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-alexandria
             sbcl-babel
             sbcl-cl-base64
             sbcl-fast-io
             sbcl-ironclad))
      (home-page "https://github.com/shrdlu68/cl-tls")
      (synopsis "Implementation of Transport Layer Security Protocols")
      (description "This package provides prototype Common Lisp
implementations of TLS, RFC5246, ASN.1, x{501,509}, and PKCS{1,3,5,8}.")
      (license license:bsd-3))))

(define-public cl-tls
  (sbcl-package->cl-source-package sbcl-cl-tls))

(define-public ecl-cl-tls
  (sbcl-package->ecl-package sbcl-cl-tls))

(define-public sbcl-cl-typesetting
  (let ((commit "86eba981fc4254addebecf765578ec350d6e3b75")
        (revision "1"))
    (package
      (name "sbcl-cl-typesetting")
      (version (git-version "0.8.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/mbattyani/cl-typesetting")
               (commit commit)))
         (file-name (git-file-name "cl-typesetting" version))
         (sha256
          (base32 "0fcs5mq0gxfczbrg7ay8r4bf5r4g6blvpdbjkhcl8dapcikyn35h"))))
      (build-system asdf-build-system/sbcl)
      (arguments
       ;; NOTE: (Sharlatan-20210515T213014+0100): Circular dependencies with
       ;; cl-typegraph
       `(#:tests? #f))
      (inputs
       `(("cl-pdf" ,sbcl-cl-pdf)
         ("xmls" ,sbcl-xmls)))
      (home-page "https://github.com/mbattyani/cl-typesetting")
      (synopsis "Stand-alone Common Lisp typesetting system")
      (description
       "CL-TYPESETTING is a cross-platform Common Lisp typesetting library for
all kind of typesetting applications.")
      (license license:bsd-2))))

(define-public cl-typesetting
  (sbcl-package->cl-source-package sbcl-cl-typesetting))

(define-public ecl-cl-typesetting
  (sbcl-package->ecl-package sbcl-cl-typesetting))

(define-public sbcl-cl-uglify-js
  ;; There have been many bug fixes since the 2010 release.
  (let ((commit "429c5e1d844e2f96b44db8fccc92d6e8e28afdd5")
        (revision "1"))
    (package
      (name "sbcl-cl-uglify-js")
      (version (git-version "0.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/mishoo/cl-uglify-js")
               (commit commit)))
         (file-name (git-file-name "cl-uglify-js" version))
         (sha256
          (base32
           "0k39y3c93jgxpr7gwz7w0d8yknn1fdnxrjhd03057lvk5w8js27a"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-parse-js sbcl-cl-ppcre sbcl-cl-ppcre-unicode
             sbcl-parse-number sbcl-iterate))
      (home-page "https://github.com/mishoo/cl-uglify-js")
      (synopsis "JavaScript compressor library for Common Lisp")
      (description "This is a Common Lisp version of UglifyJS, a JavaScript
compressor.  It works on data produced by @code{parse-js} to generate a
@dfn{minified} version of the code.  Currently it can:

@itemize
@item reduce variable names (usually to single letters)
@item join consecutive @code{var} statements
@item resolve simple binary expressions
@item group most consecutive statements using the @code{sequence} operator (comma)
@item remove unnecessary blocks
@item convert @code{IF} expressions in various ways that result in smaller code
@item remove some unreachable code
@end itemize\n")
      (license license:zlib))))

(define-public cl-uglify-js
  (sbcl-package->cl-source-package sbcl-cl-uglify-js))

(define-public ecl-cl-uglify-js
  (sbcl-package->ecl-package sbcl-cl-uglify-js))

(define-public uglify-js
  (package
    (inherit sbcl-cl-uglify-js)
    (name "uglify-js")
    (build-system trivial-build-system)
    (arguments
     `(#:modules ((guix build utils))
       #:builder
       (let* ((bin    (string-append (assoc-ref %outputs "out") "/bin/"))
              (script (string-append bin "uglify-js")))
         (use-modules (guix build utils))
         (mkdir-p bin)
         (with-output-to-file script
           (lambda _
             (format #t "#!~a/bin/sbcl --script

 (require :asdf)
 (asdf:initialize-source-registry
  #p\"~a/etc/common-lisp/source-registry.conf.d/\")
 (asdf:initialize-output-translations
  #p\"~a/etc/common-lisp/asdf-output-translations.conf.d/\")"
                     (assoc-ref %build-inputs "sbcl")
                     (assoc-ref %build-inputs "sbcl-cl-uglify-js")
                     (assoc-ref %build-inputs "sbcl-cl-uglify-js"))
             ;; FIXME: cannot use progn here because otherwise it fails to
             ;; find cl-uglify-js.
             (for-each
              write
              '(;; Quiet, please!
                (let ((*standard-output* (make-broadcast-stream))
                      (*error-output* (make-broadcast-stream)))
                  (asdf:load-system :cl-uglify-js))
                (let ((file (cadr *posix-argv*)))
                  (if file
                      (format t "~a"
                              (cl-uglify-js:ast-gen-code
                               (cl-uglify-js:ast-mangle
                                (cl-uglify-js:ast-squeeze
                                 (with-open-file (in file)
                                                 (parse-js:parse-js in))))
                               :beautify nil))
                      (progn
                       (format *error-output*
                               "Please provide a JavaScript file.~%")
                       (sb-ext:exit :code 1))))))))
         (chmod script #o755)
         #t)))
    (inputs
     (list sbcl sbcl-cl-uglify-js))
    (synopsis "JavaScript compressor")))

(define-public sbcl-cl-unicode
  (package
    (name "sbcl-cl-unicode")
    (version "0.1.6")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/edicl/cl-unicode")
                    (commit (string-append "v" version))))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "0ykx2s9lqfl74p1px0ik3l2izd1fc9jd1b4ra68s5x34rvjy0hza"))))
    (build-system asdf-build-system/sbcl)
    (native-inputs
     (list sbcl-flexi-streams))
    (inputs
     (list sbcl-cl-ppcre))
    (home-page "http://weitz.de/cl-unicode/")
    (synopsis "Portable Unicode library for Common Lisp")
    (description "CL-UNICODE is a portable Unicode library Common Lisp, which
is compatible with perl.  It is pretty fast, thread-safe, and compatible with
ANSI-compliant Common Lisp implementations.")
    (license license:bsd-2)))

(define-public cl-unicode
  (sbcl-package->cl-source-package sbcl-cl-unicode))

(define-public ecl-cl-unicode
  (sbcl-package->ecl-package sbcl-cl-unicode))

(define-public clasp-cl-unicode
  (sbcl-package->clasp-package sbcl-cl-unicode))

(define-public sbcl-cl-unification
  (let ((commit "01079f34d197495880aa49ab727d63774d83035c")
        (revision "1"))
    (package
      (name "sbcl-cl-unification")
      (version (git-version "0.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://gitlab.common-lisp.net/cl-unification/cl-unification")
               (commit commit)))
         (file-name (git-file-name "cl-unification" version))
         (sha256
          (base32 "0nhqamn3qgg38i6aw2pshffdwr2hzslycg8ficmn333gw0h9rf4g"))))
      (build-system asdf-build-system/sbcl)
      (native-inputs
       (list sbcl-ptester))
      (inputs
       (list sbcl-cl-ppcre))
      (home-page "https://common-lisp.net/project/cl-unification/")
      (synopsis "Unification framework for Common Lisp")
      (description
       "This package provides a framework to unify arbitrary
Common Lisp objects while constructing bindings for placeholders
(unification variables) in a template sublanguage.")
      (license license:bsd-0))))

(define-public cl-unification
  (sbcl-package->cl-source-package sbcl-cl-unification))

(define-public ecl-cl-unification
  (let ((pkg (sbcl-package->ecl-package sbcl-cl-unification)))
    (package
      (inherit pkg)
      (arguments
       (substitute-keyword-arguments (package-arguments pkg)
         ;; The tests fail on ECL with:
         ;;   "In MAKE-ARRAY: the elements in :INITIAL-CONTENTS do not match
         ;;    the array dimensions."
         ((#:tests? _ #f) #f))))))

(define-public sbcl-cl-utilities
  (let ((commit "dce2d2f6387091ea90357a130fa6d13a6776884b")
        (revision "1"))
    (package
      (name "sbcl-cl-utilities")
      (version (git-version "0.0.0" revision commit))
      (source
       (origin
         (method url-fetch)
         (uri
          (string-append
           "https://gitlab.common-lisp.net/cl-utilities/cl-utilities/-/"
           "archive/" commit "/cl-utilities-" commit ".tar.gz"))
         (sha256
          (base32 "1r46v730yf96nk2vb24qmagv9x96xvd08abqwhf02ghgydv1a7z2"))))
      (build-system asdf-build-system/sbcl)
      (arguments
       '(#:phases
         (modify-phases %standard-phases
           (add-after 'unpack 'fix-paths
             (lambda* (#:key inputs #:allow-other-keys)
               (substitute* "rotate-byte.lisp"
                 (("in-package :cl-utilities)" all)
                  "in-package :cl-utilities)\n\n#+sbcl\n(require :sb-rotate-byte)")))))))
      (home-page "https://common-lisp.net/project/cl-utilities")
      (synopsis "Collection of semi-standard utilities")
      (description
       "On Cliki.net <http://www.cliki.net/Common%20Lisp%20Utilities>, there
is a collection of Common Lisp Utilities, things that everybody writes since
they're not part of the official standard.  There are some very useful things
there; the only problems are that they aren't implemented as well as you'd
like (some aren't implemented at all) and they aren't conveniently packaged
and maintained.  It takes quite a bit of work to carefully implement utilities
for common use, commented and documented, with error checking placed
everywhere some dumb user might make a mistake.")
      (license license:public-domain))))

(define-public cl-utilities
  (sbcl-package->cl-source-package sbcl-cl-utilities))

(define-public ecl-cl-utilities
  (sbcl-package->ecl-package sbcl-cl-utilities))

(define-public clasp-cl-utilities
  (sbcl-package->clasp-package sbcl-cl-utilities))

(define-public sbcl-cl-variates
  (let ((commit "4e7548754d8a8731a42487fae31174db4bf36d47")
        (revision "0"))
    (package
      (name "sbcl-cl-variates")
      (version "0.9.0")
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://gitlab.common-lisp.net/cl-variates/cl-variates")
               (commit commit)))
         (file-name (git-file-name "cl-variates" version))
         (sha256
          (base32 "03wnvfi3yfflpvi0mr732r834msij4vrwdbgf6csh0b8kqxl47zn"))))
      (build-system asdf-build-system/sbcl)
      ;; USE-PACKAGE #<PACKAGE "CL-VARIATES"> causes name-conflicts in
      ;; #<PACKAGE "CL-VARIATES-TEST"> between the following symbols:
      ;; CL-VARIATES:RANDOM-ELEMENT, LIFT:RANDOM-ELEMENT
      (arguments (list #:tests? #f))
      (native-inputs (list sbcl-lift))
      (home-page "https://gitlab.common-lisp.net/cl-variates/cl-variates")
      (synopsis "Portable Common Lisp Random Number Generation")
      (description "The variates package provides portable random number
generation as well as numerous distributions.")
      (license license:expat))))

(define-public cl-variates
  (sbcl-package->cl-source-package sbcl-cl-variates))

(define-public ecl-cl-variates
  (sbcl-package->ecl-package sbcl-cl-variates))

(define-public sbcl-cl-vectors
  (package
    (name "sbcl-cl-vectors")
    (version "0.1.5")
    (source
     (origin
       (method url-fetch)
       (uri (string-append "http://projects.tuxee.net/cl-vectors/"
                           "files/cl-vectors-" version ".tar.gz"))
       (sha256
        (base32
         "04lhwi0kq8pkwhgd885pk80m1cp9sfvjjn5zj70s1dnckibhdmqh"))))
    (build-system asdf-build-system/sbcl)
    (inputs
     `(("zpb-ttf" ,sbcl-zpb-ttf)))
    (arguments
     '(#:asd-systems '("cl-vectors"
                       "cl-paths"
                       "cl-paths-ttf"
                       "cl-aa"
                       "cl-aa-misc")))
    (home-page "http://projects.tuxee.net/cl-vectors/")
    (synopsis "Create, transform and render anti-aliased vectorial paths")
    (description
     "This is a pure Common Lisp library to create, transform and render
anti-aliased vectorial paths.")
    (license license:expat)))

(define-public cl-vectors
  (sbcl-package->cl-source-package sbcl-cl-vectors))

(define-public ecl-cl-vectors
  (sbcl-package->ecl-package sbcl-cl-vectors))

(define-public sbcl-cl-vorbis
  (let ((commit "c5835cd7091aea9e2e389ad359d244542d637758")
        (revision "0"))
    (package
      (name "sbcl-cl-vorbis")
      (version (git-version "1.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/Shirakumo/cl-vorbis")
               (commit commit)))
         (file-name (git-file-name "cl-vorbis" version))
         (sha256
          (base32 "0713pl5c2khfpf8m3h1l2y0ilack7akf580h70jq6qcrnq3h4b40"))
         (modules '((guix build utils)))
         (snippet
          ;; Delete bundled libraries, GlibC and Vorbis sources.
          `(begin
             (delete-file-recursively "static")
             (for-each delete-file '("glibc-2.13.h"
                                     "stb_vorbis.c"
                                     "stb_vorbis_patch.c"))))))
      (build-system asdf-build-system/sbcl)
      (arguments
       `(#:phases
         (modify-phases %standard-phases
           (add-after 'unpack 'fix-paths
             (lambda* (#:key inputs #:allow-other-keys)
               (substitute* "low-level.lisp"
                 (("libvorbis-lin-amd64.so")
                  (search-input-file inputs "/lib/libvorbis.so"))))))))
      (inputs
       (list libvorbis
             sbcl-cffi
             sbcl-documentation-utils
             sbcl-static-vectors
             sbcl-trivial-features
             sbcl-trivial-garbage))
      (home-page "https://shirakumo.github.io/cl-vorbis/")
      (synopsis "OGG/Vorbis decoding using stb_vorbis for Common Lisp")
      (description "This package provides CFFI bindings for the
@code{stb_vorbis} audio library to Common Lisp.")
      (license license:zlib))))

(define-public cl-vorbis
  (sbcl-package->cl-source-package sbcl-cl-vorbis))

(define-public ecl-cl-vorbis
  (sbcl-package->ecl-package sbcl-cl-vorbis))

(define-public sbcl-cl-wayland
  (let ((commit "a92a5084b64102f538ab90212e99c7863e5338ae")
        (revision "0"))
    (package
      (name "sbcl-cl-wayland")
      (version (git-version "0.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/sdilts/cl-wayland")
               (commit commit)))
         (file-name (git-file-name "cl-wayland" version))
         (sha256
          (base32 "1r4fn9dc0dz2b30k8z243yacx1y5z21qk4zh2ildj7ak51qx53zf"))))
      (build-system asdf-build-system/sbcl)
      (arguments
       (list #:phases
             #~(modify-phases %standard-phases
                 (add-after 'unpack 'fix-paths
                   (lambda* (#:key inputs #:allow-other-keys)
                     (substitute* "wayland-server-core.lisp"
                       (("libwayland-server.so")
                        (search-input-file inputs
                                           "/lib/libwayland-server.so"))))))))
      (inputs
       (list sbcl-cffi
             sbcl-closer-mop
             wayland))
      (home-page "https://github.com/sdilts/cl-wayland")
      (synopsis "Common Lisp FFI bindings for libwayland")
      (description
       "This package provides Common Lisp FFI bindings for libwayland,
primarily for the mahogany window manager.")
      (license license:bsd-3))))

(define-public cl-wayland
  (sbcl-package->cl-source-package sbcl-cl-wayland))

(define-public ecl-cl-wayland
  (sbcl-package->ecl-package sbcl-cl-wayland))

(define-public sbcl-cl-webkit
  (package
    (name "sbcl-cl-webkit")
    (version "3.5.10")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/joachifm/cl-webkit")
             (commit version)))
       (file-name (git-file-name "cl-webkit" version))
       (sha256
        (base32
         "0bn8idvbi58kg0g76lanvjzkgnkcy41yn9vbp7f80q9fa7w892rq"))))
    (build-system asdf-build-system/sbcl)
    (inputs
     `(("cffi" ,sbcl-cffi)
       ("cl-cffi-gtk" ,sbcl-cl-cffi-gtk)
       ("webkitgtk" ,webkitgtk-for-gtk3)))
    (native-inputs
     `(;; Tests seem to need Xorg.
       ;; ("xorg-server" ,xorg-server-for-tests)
       ("calispel" ,sbcl-calispel)
       ("fiveam" ,sbcl-fiveam)
       ("float-features" ,sbcl-float-features)))
    (arguments
     `(#:asd-systems '("cl-webkit2")
       #:tests? #f                      ; TODO: Tests hang, why?
       #:phases
       (modify-phases %standard-phases
         ;; The following phase is needed for tests:
         ;; (add-before 'check 'start-xorg-server
         ;;   (lambda* (#:key inputs #:allow-other-keys)
         ;;     ;; The test suite requires a running X server.
         ;;     (system (string-append (assoc-ref inputs "xorg-server")
         ;;                            "/bin/Xvfb :1 &"))
         ;;     (setenv "DISPLAY" ":1")
         ;;     #t))
         (add-after 'unpack 'fix-paths
           (lambda* (#:key inputs #:allow-other-keys)
             (substitute* "webkit2/webkit2.init.lisp"
               (("libwebkit2gtk" all)
                (string-append
                 (assoc-ref inputs "webkitgtk") "/lib/" all))))))))
    (home-page "https://github.com/joachifm/cl-webkit")
    (synopsis "Binding to WebKitGTK+ for Common Lisp")
    (description
     "@command{cl-webkit} is a binding to WebKitGTK+ for Common Lisp,
currently targeting WebKit version 2.  The WebKitGTK+ library adds web
browsing capabilities to an application, leveraging the full power of the
WebKit browsing engine.")
    (license license:expat)))

(define-public cl-webkit
  (sbcl-package->cl-source-package sbcl-cl-webkit))

(define-public ecl-cl-webkit
  (sbcl-package->ecl-package sbcl-cl-webkit))

(define-public sbcl-cl-who
  (let ((version "1.1.4")
        (commit "07dafe9b351c32326ce20b5804e798f10d4f273d")
        (revision "3"))
    (package
      (name "sbcl-cl-who")
      (version (git-version version revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/edicl/cl-who")
               (commit commit)))
         (file-name (git-file-name "cl-who" version))
         (sha256
          (base32
           "1rdvs113q6d46cblwhsv1vmm31p952wyzkyibqix0ypadpczlgp5"))))
      (build-system asdf-build-system/sbcl)
      (native-inputs
       (list sbcl-flexi-streams))
      (home-page "https://edicl.github.io/cl-who/")
      (synopsis "Yet another Lisp markup language")
      (description
       "There are plenty of Lisp Markup Languages out there - every Lisp
programmer seems to write at least one during his career - and CL-WHO (where
WHO means \"with-html-output\" for want of a better acronym) is probably just
as good or bad as the next one.")
      (license license:bsd-2))))

(define-public cl-who
  (sbcl-package->cl-source-package sbcl-cl-who))

(define-public ecl-cl-who
  (sbcl-package->ecl-package sbcl-cl-who))

(define-public sbcl-cl-xkb
  (let ((commit "3807a264d04ac242ea65991b19b5fb3f894c6e46")
        (revision "1"))
    (package
      (name "sbcl-cl-xkb")
      (version (git-version "0.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/malcolmstill/cl-xkb")
               (commit commit)))
         (file-name (git-file-name "cl-xkb" version))
         (sha256
          (base32 "002bskv0dvq2hahz7dah2zwwkp2zrkf98w7lm96jmqfn8vyp4k75"))))
      (build-system asdf-build-system/sbcl)
      (arguments
       (list
        #:phases
        #~(modify-phases %standard-phases
            (add-after 'unpack 'add-xkbcommon
              (lambda* (#:key inputs #:allow-other-keys)
                (substitute* "cl-xkb.lisp"
                  (("/usr/lib64/libxkbcommon.so.0")
                   (search-input-file inputs "/lib/libxkbcommon.so"))))))))
      (native-inputs
       (list pkg-config))
      (inputs
       (list libxkbcommon
             sbcl-cffi))
      (home-page "https://github.com/malcolmstill/cl-xkb")
      (synopsis "Common Lisp wrapper for @code{libxkbcommon}")
      (description
       "@code{cl-xkb} is a Common Lisp wrapper for the libxkbcommon keyboard
handling library.

The library currently supports these xkb modules:

@itemize
@item Keysyms
@item Library Context
@item Include Paths
@item Logging Handling
@item Keymap Creation
@item Keymap Components
@item Keyboard State
@item Compose and dead-keys support
@end itemize")
      (license license:bsd-3))))

(define-public cl-xkb
  (sbcl-package->cl-source-package sbcl-cl-xkb))

(define-public ecl-cl-xkb
  (sbcl-package->ecl-package sbcl-cl-xkb))

(define-public sbcl-cl-xmlspam
  (let ((commit "ea06abcca2a73a9779bcfb09081e56665f94e22a"))
    (package
      (name "sbcl-cl-xmlspam")
      (build-system asdf-build-system/sbcl)
      (version (git-version "0.0.0" "1" commit))
      (home-page "https://github.com/rogpeppe/cl-xmlspam")
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url home-page)
               (commit commit)))
         (file-name (string-append name "-" version))
         (sha256
          (base32
           "0w4rqvrgdgk3fwfq3kx4r7wwdr2bv3b6n3bdqwsiriw9psqzpz2s"))))
      (inputs
       (list sbcl-cxml sbcl-cl-ppcre))
      (synopsis "Concise, regexp-like pattern matching on streaming XML for Common Lisp")
      (description "CXML does an excellent job at parsing XML elements, but what
do you do when you have a XML file that's larger than you want to fit in
memory, and you want to extract some information from it?  Writing code to deal
with SAX events, or even using Klacks, quickly becomes tedious.
@code{cl-xmlspam} (for XML Stream PAttern Matcher) is designed to make it easy
to write code that mirrors the structure of the XML that it's parsing.  It
also makes it easy to shift paradigms when necessary - the usual Lisp control
constructs can be used interchangeably with pattern matching, and the full
power of CXML is available when necessary.")
      (license license:bsd-3))))

(define-public cl-xmlspam
  (sbcl-package->cl-source-package sbcl-cl-xmlspam))

(define-public ecl-cl-xmlspam
  (sbcl-package->ecl-package sbcl-cl-xmlspam))

(define-public sbcl-cl-yacc
  (package
    (name "sbcl-cl-yacc")
    (version "0.3")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/jech/cl-yacc")
             (commit (string-append "cl-yacc-" version))))
       (sha256
        (base32
         "16946pzf8vvadnyfayvj8rbh4zjzw90h0azz2qk1mxrvhh5wklib"))
       (file-name (string-append "cl-yacc-" version "-checkout"))))
    (build-system asdf-build-system/sbcl)
    (arguments
     `(#:asd-systems '("yacc")))
    (synopsis "LALR(1) parser generator for Common Lisp, similar in spirit to Yacc")
    (description
     "CL-Yacc is a LALR(1) parser generator for Common Lisp, similar in spirit
to AT&T Yacc, Berkeley Yacc, GNU Bison, Zebu, lalr.cl or lalr.scm.

CL-Yacc uses the algorithm due to Aho and Ullman, which is the one also used
by AT&T Yacc, Berkeley Yacc and Zebu.  It does not use the faster algorithm due
to DeRemer and Pennello, which is used by Bison and lalr.scm (not lalr.cl).")
    (home-page "https://www.irif.fr/~jch//software/cl-yacc/")
    (license license:expat)))

(define-public cl-yacc
  (sbcl-package->cl-source-package sbcl-cl-yacc))

(define-public ecl-cl-yacc
  (sbcl-package->ecl-package sbcl-cl-yacc))

(define-public sbcl-cl-yaml
  (let ((commit "c3202be9a753c51f3bc79538a5a498a8865192aa")
        (revision "1"))
    (package
      (name "sbcl-cl-yaml")
      (version (git-version "0.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/eudoxia0/cl-yaml")
               (commit commit)))
         (file-name (git-file-name "cl-yaml" version))
         (sha256
          (base32 "1izjg0v6rf7dh069bbnnr67l30lsqj86wdk7y9ggbgiwh6v9j185"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-alexandria sbcl-cl-libyaml sbcl-cl-ppcre
             sbcl-parse-number))
      (native-inputs
       (list sbcl-cl-fad sbcl-fiveam sbcl-generic-comparability
             sbcl-trivial-benchmark sbcl-yason))
      (home-page "https://github.com/eudoxia0/cl-yaml")
      (synopsis "YAML parser for Common Lisp")
      (description
        "This is a YAML parser and emitter for Common Lisp built on top of
libyaml.")
      (license license:expat))))

(define-public cl-yaml
  (sbcl-package->cl-source-package sbcl-cl-yaml))

(define-public ecl-cl-yaml
  (sbcl-package->ecl-package sbcl-cl-yaml))

(define-public sbcl-cl-z85
  (let ((commit "85b3951a9cfa2603acb6aee15567684f9a108098")
        (revision "1"))
    (package
      (name "sbcl-cl-z85")
      (version (git-version "1.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://codeberg.org/glv/cl-z85")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "0r27pidjaxbm7k1rr90nnajwl5xm2kp65g1fv0fva17lzy45z1mp"))))
      (build-system asdf-build-system/sbcl)
      (native-inputs
       (list sbcl-cl-octet-streams sbcl-fiveam))
      (synopsis "Common Lisp library for Z85 encoding and decoding")
      (description
       "This package provides functions to encode or decode byte vectors or
byte streams using the Z85 format, which is a base-85 encoding used by
ZeroMQ.")
      (home-page "https://codeberg.org/glv/cl-z85")
      (license license:gpl3+))))

(define-public cl-z85
  (sbcl-package->cl-source-package sbcl-cl-z85))

(define-public ecl-cl-z85
  (sbcl-package->ecl-package sbcl-cl-z85))

(define-public sbcl-clache
  (let ((commit "112976729565e1035532389ca25090ae99badd07"))
    (package
      (name "sbcl-clache")
      (version (git-version "0.2.1" "1" commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/html/clache/")
               (commit commit)))
         (file-name (git-file-name "cl-clache" version))
         (sha256
          (base32 "0wxg004bsay58vr6xr6mlk7wj415qmvisqxvpnjsg6glfwca86ys"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-alexandria
             sbcl-babel
             sbcl-cl-annot
             sbcl-cl-fad
             sbcl-cl-store
             sbcl-cl-syntax
             sbcl-ironclad
             sbcl-trivial-garbage))
      (native-inputs
       (list sbcl-prove))
      (arguments
       `(#:phases
         (modify-phases %standard-phases
           (add-after 'unpack 'fix-tests
             (lambda _
               (substitute* "clache-test.asd"
                 (("cl-test-more") "prove"))
               #t)))))
      (home-page "https://github.com/html/clache/")
      (synopsis "General caching facility for Common Lisp")
      (description
       "CLACHE provides a general caching facility for Common Lisp.  The API is
similar to the standard hash-table interface.")
      (license license:llgpl))))

(define-public cl-clache
  (sbcl-package->cl-source-package sbcl-clache))

(define-public ecl-clache
  (sbcl-package->ecl-package sbcl-clache))

(define-public sbcl-clack
  (let ((commit "4916ebb243d42d1b52f8030db146215033b1b71e")
        (revision "1"))
    (package
      (name "sbcl-clack")
      (version (git-version "2.1.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/fukamachi/clack")
               (commit commit)))
         (file-name (git-file-name "cl-clack" version))
         (sha256
          (base32 "0kgymwvv1ghzvl4jryl3fxf0kf44i6z19izcf1rf0k4cidx093a7"))))
      (build-system asdf-build-system/sbcl)
      (arguments
       ;; Only the handler for hunchentoot is included. The other
       ;; two Web servers supported by clack, toot and wookie,
       ;; have not yet been packaged for Guix.
       '(#:asd-systems '("clack"
                         "clack-handler-hunchentoot"
                         "clack-socket")))
      (inputs
       (list sbcl-alexandria
             sbcl-bordeaux-threads
             sbcl-flexi-streams
             sbcl-hunchentoot
             sbcl-lack
             sbcl-split-sequence
             sbcl-slime-swank
             sbcl-usocket))
      (home-page "https://github.com/fukamachi/clack")
      (synopsis "Web Application Environment for Common Lisp")
      (description
       "Clack is a web application environment for Common Lisp inspired by
Python's WSGI and Ruby's Rack.")
      (license license:expat))))

(define-public cl-clack
  (sbcl-package->cl-source-package sbcl-clack))

(define-public ecl-clack
  (sbcl-package->ecl-package sbcl-clack))

(define-public sbcl-clad
  (let ((commit "1ff6f417d4ee3836d1edd96923d4b03f3cafa849")
        (revision "0"))
    (package
      (name "sbcl-clad")
      (version
       ;; There's no version, but there's a timestamp
       (git-version "2023-01-21" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://gitlab.common-lisp.net/mantoniotti/CLAD")
               (commit commit)))
         (file-name (git-file-name "cl-clad" version))
         (sha256
          (base32 "184mhdq7pxd6hd4rzv8z4lfbwnkyhgm5bdn3xsqaav2j0d1dqm6i"))
         (modules '((guix build utils)))
         (snippet
          ;; Delete compiled ABCL files.
          '(begin
             (delete-file "clad-package.abcl")
             (delete-file "clad.abcl")))))
      (build-system asdf-build-system/sbcl)
      (synopsis "Library providing standard locations on the file system")
      (description
       "The Common Lisp Application Directories (CLAD) library is
a simple API collection that provides access to a set of @emph{standard}
Common Lisp folders on a per-application or per-library basis.")
      (home-page "https://gitlab.common-lisp.net/mantoniotti/CLAD")
      (license license:expat)))) ;the mit-modern-variant is used

(define-public cl-clad
  (sbcl-package->cl-source-package sbcl-clad))

(define-public sbcl-clamp
  (let ((commit "02b8f3953e5753cc61a719807c82f3795cd28fe1"))
    (package
      (name "sbcl-clamp")
      (version (git-version "0.3" "1" commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/arclanguage/Clamp")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "0fdr9nqfmmpxm6hvjdxi1jkclya9xlnrw1yc3cn1m4ww3f50p31m"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       `(("iterate" ,sbcl-iterate)
         ("cl-syntax" ,sbcl-cl-syntax)))
      (native-inputs
       `(("cl-unit" ,sbcl-clunit)
         ("check-it" ,sbcl-check-it)))
      (arguments
       `(#:phases
         (modify-phases %standard-phases
           (add-after 'unpack 'fix-build
             (lambda _
               (substitute* "clamp.asd"
                 (("\\(:file \"read\"     :depends-on \\(\"aliases\"\\)\\)")
                  "(:file \"read\"     :depends-on (\"aliases\" \"base\"))"))
               #t)))))
      (home-page "https://github.com/arclanguage/Clamp")
      (synopsis "Common Lisp with Arc macros and procedures")
      (description
       "Clamp is an attempt to bring the powerful, but verbose, language of
Common Lisp up to the terseness of Arc.

There are two parts to Clamp.  There is the core of Clamp, which implements
the utilities of Arc that are easily converted from Arc to Common Lisp.  The
other part is the \"experimental\" part.  It contains features of Arc that are
not so easy to copy (ssyntax, argument destructuring, etc.).")
      (license license:artistic2.0))))

(define-public cl-clamp
  (sbcl-package->cl-source-package sbcl-clamp))

(define-public ecl-clamp
  (sbcl-package->ecl-package sbcl-clamp))

(define-public sbcl-class-options
  (package
    (name "sbcl-class-options")
    (version "1.0.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/Hexstream/class-options")
             (commit (string-append "v" version))))
       (file-name (git-file-name "cl-class-options" version))
       (sha256
        (base32 "1dkgr1vbrsra44jznzz2bvdf8nlpdrrkjcqrfs8aa7axksda3bqk"))))
    (build-system asdf-build-system/sbcl)
    (native-inputs
     (list sbcl-enhanced-boolean sbcl-parachute))
    (inputs
     (list sbcl-closer-mop sbcl-enhanced-find-class))
    (home-page "https://www.hexstreamsoft.com/libraries/class-options/")
    (synopsis "Accessing defining class and its options during modification")
    (description
     "This package provides easy access to the defining class and its options
during initialization or reinitialization of its subcomponents.")
    (license license:unlicense)))

(define-public cl-class-options
  (sbcl-package->cl-source-package sbcl-class-options))

(define-public ecl-class-options
  (sbcl-package->ecl-package sbcl-class-options))

(define-public clasp-class-options
  (sbcl-package->clasp-package sbcl-class-options))

(define-public sbcl-classimp
  (let ((commit "6c74f3808e00781a2662f37ddc26ccbbf2687b6b")
        (revision "1"))
    (package
      (name "sbcl-classimp")
      (version (git-version "0.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/3b/classimp")
               (commit commit)))
         (file-name (git-file-name "cl-classimp" version))
         (sha256
          (base32 "1sq34s5yrljh7fffllsscay7xi11lg03alrkyrh6xfwa2w7cnqmx"))))
      (build-system asdf-build-system/sbcl)
      (arguments
       (list
        #:phases
        #~(modify-phases %standard-phases
            (add-after 'unpack 'patch-assimp-lib-path
              (lambda* (#:key inputs #:allow-other-keys)
                (substitute* "library.lisp"
                  (("libassimp.so.5" _)
                   (search-input-file inputs "/lib/libassimp.so.5"))))))))
      (inputs
       (list assimp
             sbcl-cffi
             sbcl-split-sequence))
      (home-page "https://github.com/3b/classimp")
      (synopsis "Common Lisp CFFI bindings for Open Asset Import Library")
      (description
       "This package provides CFFI bindings to the @acronym{ASSIMP, Asset
Import} library for Common Lisp.")
      (license license:expat))))

(define-public cl-classimp
  (sbcl-package->cl-source-package sbcl-classimp))

(define-public ecl-classimp
  (sbcl-package->ecl-package sbcl-classimp))

(define-public sbcl-clavier
  (let ((commit "9b1424eaad131e114a45b400784079124b5e2321")
        (revision "1"))
    (package
      (name "sbcl-clavier")
      (version (git-version "0.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/mmontone/clavier")
               (commit commit)))
         (file-name (git-file-name "cl-clavier" version))
         (sha256
          (base32 "1gjd0rhxs2x7gn3fw1hnxivmm4ca4f1wxlg0fqv8fdfabgzsvl5y"))))
      (build-system asdf-build-system/sbcl)
      (native-inputs (list sbcl-stefil))
      (inputs
       (list sbcl-alexandria
             sbcl-chronicity
             sbcl-cl-fad
             sbcl-cl-ppcre
             sbcl-closer-mop))
      (home-page "https://github.com/mmontone/clavier/")
      (synopsis "General purpose validation library")
      (description "Clavier is a general purpose validation library for
Common Lisp.")
      (license license:expat))))

(define-public cl-clavier
  (sbcl-package->cl-source-package sbcl-clavier))

(define-public ecl-clavier
  (sbcl-package->ecl-package sbcl-clavier))

(define-public sbcl-claw
  (let ((revision "0")
        (commit "3cd4a96fca95eb9e8d5d069426694669f81b2250"))
    (package
      (name "sbcl-claw")
      (version (git-version "1.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/borodust/claw")
               (commit commit)))
         (file-name (git-file-name "claw" version))
         (sha256
          (base32 "146yv0hc4hmk72562ssj2d41143pp84dcbd1h7f4nx1c7hf2bb0d"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-alexandria
             sbcl-cffi
             sbcl-cl-json
             sbcl-cl-ppcre
             sbcl-claw-support
             sbcl-local-time
             sbcl-trivial-features))
      (home-page "https://github.com/borodust/claw")
      (synopsis "Autowrapper for Common Lisp")
      (description
       "This is a Common Lisp autowrapping facility for quickly creating clean
and lean bindings to C libraries.")
      (license license:bsd-2))))

(define-public cl-claw
  (sbcl-package->cl-source-package sbcl-claw))

(define-public ecl-claw
  (sbcl-package->ecl-package sbcl-claw))

(define-public sbcl-claw-raylib
  (package
    (name "sbcl-claw-raylib")
    (version "1.0.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
              ;; The prebuild branch of the original repository is reset when
              ;; there are changes. We use a fork which maintains a stable
              ;; reference to the prebuild commit.
              (url "https://github.com/simendsjo/claw-raylib")
              (commit "prebuild-raylib-5.5-and-raygui-4.0")))
       (file-name (git-file-name name version))
       (sha256
        (base32 "19xaxcinw4lxsp4snaa2azcxz9hwii729gfpcv2vdw7qlzc9cg9g"))))
    (build-system asdf-build-system/sbcl)
    (arguments
     (list
      #:asd-systems
      ''("claw-raylib"
         "claw-raylib/examples")
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'fix-paths
            (lambda _
              (substitute* "library.lisp"
                (("libraylib\\.so")
                 (string-append #$(this-package-input "raylib") "/lib/libraylib.so"))
                (("libraygui\\.so")
                 (string-append #$(this-package-input "raygui") "/lib/libraygui.so")))))
          (add-before 'build 'build-libraries
            (lambda _
              ;; Converted from the "Compile the adapters" in the README
              (let ((lib (string-append #$output "/share/common-lisp/sbcl/claw-raylib/lib")))
                (invoke #$(cc-for-target) "-O3" "-fPIC" "-shared"
                        "-o" (string-append lib "/libraylib-adapter.so")
                        (string-append lib "/libraylib-adapter.x86_64-pc-linux-gnu.c"))
                (invoke #$(cc-for-target) "-O3" "-fPIC" "-shared"
                        "-o" (string-append lib "/librlgl-adapter.so")
                        (string-append lib "/librlgl-adapter.x86_64-pc-linux-gnu.c"))
                (invoke #$(cc-for-target) "-O3" "-fPIC" "-shared"
                        "-o" (string-append lib "/libraygui-adapter.so")
                        (string-append lib "/libraygui-adapter.x86_64-pc-linux-gnu.c"))))))))
    (inputs
     (list sbcl-alexandria
           sbcl-global-vars
           sbcl-cffi
           sbcl-cffi-ops
           sbcl-cffi-object
           raylib
           raygui))
    (home-page "https://github.com/bohonghuang/claw-raylib")
    (synopsis "Fully auto-generated Common Lisp bindings to Raylib and Raygui")
    (description "Fully auto-generated Common Lisp bindings to Raylib and
Raygui.")
    (license license:asl2.0)))

;; This does not work yet
#;(define-public ecl-claw-raylib
  (sbcl-package->ecl-package sbcl-claw-raylib))

;; This does not work yet
#;(define-public cl-claw-raylib
  (sbcl-package->cl-source-package sbcl-claw-raylib))

(define-public sbcl-claw-support
  (package
    (name "sbcl-claw-support")
    (version "1.0.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/borodust/claw-support")
             (commit "9a15c8bed04585f45e6a461bcda1b475144dbd0b")))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1my2ka7h72ipx5n3b465g6kjkasrhsvhqlijwcg6dhlzs5yygl23"))))
    (build-system asdf-build-system/sbcl)
    (home-page "https://github.com/borodust/claw-support")
    (synopsis "Support routines for claw")
    (description
     "This package provides support routines for the @code{claw} Common Lisp
package.")
    (license license:expat)))

(define-public cl-claw-support
  (sbcl-package->cl-source-package sbcl-claw-support))

(define-public ecl-claw-support
  (sbcl-package->ecl-package sbcl-claw-support))

(define-public sbcl-claw-utils
  (let ((revision "0")
        (commit "efe25016501973dc369f067a64c7d225802bc56f"))
    (package
      (name "sbcl-claw-utils")
      ;; version is not specified
      (version (git-version "0.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/borodust/claw-utils")
               (commit commit)))
         (file-name (git-file-name "claw-utils" version))
         (sha256
          (base32 "01df3kyf2qs3czi332dnz2s35x2j0fq46vgmsw7wjrrvnqc22mk5"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-alexandria sbcl-cffi sbcl-claw))
      (home-page "https://github.com/borodust/claw-utils")
      (synopsis "Utilities for easier autowrapping")
      (description
       "This Common Lisp library contains various handy utilities to help
autowrapping with @code{claw}.")
      (license license:expat))))

(define-public cl-claw-utils
  (sbcl-package->cl-source-package sbcl-claw-utils))

(define-public ecl-claw-utils
  (sbcl-package->ecl-package sbcl-claw-utils))

(define-public sbcl-clawk
  (let ((commit "3a91634df686417114044a98c063cbe76bfac7b6"))
    (package
      (name "sbcl-clawk")
      (version (git-version "4" "1" commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/sharplispers/clawk")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "1ph3xjqilvinvgr9q3w47zxqyz1sqnq030nlx7kgkkv8j3bnqk7a"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-regex))
      (home-page "https://github.com/sharplispers/clawk")
      (synopsis "Common Lisp AWK")
      (description
       "CLAWK is an AWK implementation embedded into Common Lisp.")
      (license license:bsd-2))))

(define-public cl-clawk
  (sbcl-package->cl-source-package sbcl-clawk))

(define-public ecl-clawk
  (sbcl-package->ecl-package sbcl-clawk))

(define-public sbcl-clesh
  (let ((commit "44e96e04a72e5bc006dc4eb02ce8962348dd4a11"))
    (package
      (name "sbcl-clesh")
      (version (git-version "0.0.0" "1" commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/Neronus/Clesh")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "012ry02djnqyvvs61wbbqj3saz621w2l9gczrywdxhi5p4ycx318"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-trivial-shell sbcl-named-readtables))
      (home-page "https://github.com/Neronus/Clesh")
      (synopsis "Embed shell code in Common Lisp")
      (description
       "This is a very short and simple program, written in Common Lisp, that
extends Common Lisp to embed shell code in a manner similar to Perl's
backtick.  It has been forked from SHELISP.")
      (license license:bsd-2))))

(define-public cl-clesh
  (sbcl-package->cl-source-package sbcl-clesh))

(define-public ecl-clesh
  (sbcl-package->ecl-package sbcl-clesh))

(define-public sbcl-clinenoise
  (let ((commit "46e21f99d06a55d93eaa382cf652d55d457032ef")
        (revision "1"))
    (package
      (name "sbcl-clinenoise")
      (version (git-version "0.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/jasom/clinenoise")
               (commit commit)))
         (file-name (git-file-name "clinenoise" version))
         (sha256
          (base32 "0ydlirfk4dbpqqjwwph99v5swcrhd8v9g8q24fvs35wn2vm08lh1"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-alexandria sbcl-cffi sbcl-split-sequence))
      (home-page "https://github.com/jasom/clinenoise")
      (synopsis "Port of linenoise to Common Lisp")
      (description
       "This package provides a trivial line-input library for VT-like
terminals.")
      (license license:bsd-2))))

(define-public cl-clinenoise
  (sbcl-package->cl-source-package sbcl-clinenoise))

(define-public ecl-clinenoise
  (sbcl-package->ecl-package sbcl-clinenoise))

(define-public sbcl-clingon
  (let ((commit "f2a730f1073e41d78557019085fbb0c662fd3189")
        (revision "1"))
    (package
      (name "sbcl-clingon")
      (version (git-version "0.5.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/dnaeon/clingon")
               (commit commit)))
         (file-name (git-file-name "cl-clingon" version))
         (sha256
          (base32 "0p8i9bkzzy4v0pg15dldrl73xri4kxyxa7si82bawh1dnnm53jgc"))))
      (build-system asdf-build-system/sbcl)
      (native-inputs
       (list sbcl-rove))
      (inputs
       (list sbcl-bobbin
             sbcl-cl-reexport
             sbcl-split-sequence
             sbcl-with-user-abort))
      (arguments
       (list #:tests? #f)) ; FIXME: Tests run forever
      (home-page "https://github.com/dnaeon/clingon")
      (synopsis "Command-line option parsing library for Common Lisp")
      (description
       "@code{clingon} is a command-line option parsing library for Common
Lisp.  Its features include:
@itemize
@item Support for subcommands
@item Support for command aliases
@item Support for short and long options
@item Related options may be grouped into categories
@item Short options may be collapsed into a single argument, as in
@option{-xyz}
@item Long options support the notations @option{--long-opt arg} and
@option{--long-opt=arg}
@item Automatic generation of help/usage information for commands and
subcommands
@item Out-of-the-box support for @option{--version} and @option{--help}
@item Support for various kinds of options including string, integer,
boolean, switch, enum, list, counter, filepath, etc.
@item Subcommands can look up global options defined in parent commands
@item Support for required options
@item Options can be initialized via environment variables
@item Single interface for creating options using @code{CLINGON:MAKE-OPTION}
@item Generate documentation for your command-line application
@item Support for @code{pre-hook} and @code{post-hook} actions for commands,
which allow invoking functions before and after the respective handler of the
command is executed
@item Support for Bash and Zsh completions
@item Extensibility, so if you don't find something you need you can extend it
by developing a new option kind, or even a new mechanism for initializing
options, e.g., by looking up an external key/value store
@end itemize")
      (license license:bsd-2))))

(define-public cl-clingon
  (sbcl-package->cl-source-package sbcl-clingon))

(define-public ecl-clingon
  (sbcl-package->ecl-package sbcl-clingon))

(define-public sbcl-clip
  (let ((commit "7afa68702fbb99c47ed115ea0faccd97a29d9b2e")
        (revision "1"))
    (package
      (name "sbcl-clip")
      (version (git-version "0.7.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/shinmera/clip")
               (commit commit)))
         (file-name (git-file-name "clip" version))
         (sha256
          (base32 "13kkajkva2shm19fvn4yashsw18l6imv2rmy3hmpcky7g5ay7bv3"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-array-utils sbcl-lquery))
      (home-page "https://shinmera.github.io/clip/")
      (synopsis "Common Lisp HTML templating engine")
      (description
       "Clip is an attempt at a templating library that allows you to write
templates in a way that is both accessible to direct webdesign and
flexible.  The main idea is to incorporate transformation commands into an HTML
file through tags and attributes.  Clip is heavily dependent on Plump and
lQuery.")
      (license license:zlib))))

(define-public cl-clip
  (sbcl-package->cl-source-package sbcl-clip))

(define-public ecl-clip
  (sbcl-package->ecl-package sbcl-clip))

(define-public sbcl-clml
  (let ((commit "95505b54c8c7b4b27f500c3be97fa5732f4b51a8")
        (revision "0"))
    (package
      (name "sbcl-clml")
      (version (git-version "0.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/mmaul/clml")
               (commit commit)))
         (file-name (git-file-name "clml" version))
         (sha256
          (base32 "006pii59nmpc61n7p7h8ha5vjg6x0dya327i58z0rnvxs249h345"))
         ;; TODO: Remove this when the patch has been merged upstream.
         (patches (search-patches "sbcl-clml-fix-types.patch"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-alexandria
             sbcl-array-operations
             sbcl-cl-fad
             sbcl-cl-ppcre
             sbcl-drakma
             sbcl-introspect-environment
             sbcl-iterate
             sbcl-lparallel
             sbcl-parse-number
             sbcl-split-sequence
             sbcl-trivial-garbage))
      (synopsis "Common Lisp machine learning library")
      (description
       "CLML (Common Lisp Machine Learning) is a high performance and large
scale statistical machine learning package")
      (home-page "https://mmaul.github.io/clml/")
      (license license:llgpl))))

(define-public cl-clml
  (sbcl-package->cl-source-package sbcl-clml))

(define-public sbcl-clobber
  (let ((commit "212721c24a8bb792714314ba52dfe818641f2e98")
        (revision "0"))
    (package
      (name "sbcl-clobber")
      (version (git-version "0.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/robert-strandh/Clobber")
               (commit commit)))
         (file-name (git-file-name "cl-clobber" version))
         (sha256
          (base32 "0pqzfn2wqbzzwlwc3l84iv3i3wa9zfgnh14mq67h9qkib8wjzx3n"))))
      (build-system asdf-build-system/sbcl)
      (home-page "https://github.com/robert-strandh/Clobber")
      (synopsis "Common Lisp Library for transaction-oriented databases")
      (description
       "CLOBBER is an alternative to so-called @emph{object prevalence}, and in
particular to @code{cl-prevalence}.  Clobber is both simpler, more flexible, and
more robust than systems based on object prevalence.")
      (license license:bsd-2))))

(define-public cl-clobber
  (sbcl-package->cl-source-package sbcl-clobber))

(define-public ecl-clobber
  (sbcl-package->ecl-package sbcl-clobber))

(define-public sbcl-clog
  (package
    (name "sbcl-clog")
    (version "1.2")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/rabbibotton/clog")
             (commit (string-append "v" version))))
       (file-name (git-file-name "cl-clog" version))
       (sha256
        (base32 "0f4i6571nm0j704zgnh60sc9slifs11byb2gs8gamqjcfh931dap"))))
    (build-system asdf-build-system/sbcl)
    (inputs
     (list sbcl-3bmd
           sbcl-alexandria
           sbcl-bordeaux-threads
           sbcl-cl-ppcre
           sbcl-cl-sqlite
           sbcl-cl-template
           sbcl-clack
           sbcl-closer-mop
           sbcl-colorize
           sbcl-dbi
           sbcl-hunchentoot
           sbcl-lack
           sbcl-mgl-pax
           sbcl-parse-float
           sbcl-quri
           sbcl-trivial-open-browser
           sbcl-websocket-driver))
    (arguments
     '(#:asd-systems '("clog" "clog/docs" "clog/tools")
       #:phases (modify-phases %standard-phases
                  (add-after 'unpack 'fix-symbol-name
                    (lambda _
                      (substitute* "source/clog-docs.lisp"
                        (("clog:@CLOG-MANUAL")
                         "clog::@CLOG_MANUAL")))))))
    (home-page "https://github.com/rabbibotton/clog")
    (synopsis "Common Lisp Omnificent GUI")
    (description
     "This package provides a Common Lisp web framework for building GUI
applications.  CLOG can take the place, or work along side, most cross platform
GUI frameworks and website frameworks.  The CLOG package starts up the
connectivity to the browser or other websocket client (often a browser embedded
in a native template application).")
    (license license:bsd-3)))

(define-public cl-clog
  (sbcl-package->cl-source-package sbcl-clog))

(define-public ecl-clog
  (sbcl-package->ecl-package sbcl-clog))

(define-public sbcl-clop
  (let ((commit "c0c3fe7efa5ac95ba1644febfb2c2acab757fcda")
        (revision "0"))
    (package
      (name "sbcl-clop")
      ;; ASD file indicates 0.1.0, but changelog 1.0.1.
      (version (git-version "1.0.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/sheepduke/clop")
               (commit commit)))
         (file-name (git-file-name "cl-clop" version))
         (sha256
          (base32 "1q7rlizr8gcbfz4a9660gdbw7d2zbld18akjpibg54j7jh5kb8gc"))))
      (build-system asdf-build-system/sbcl)
      (native-inputs
       (list sbcl-fiveam))
      (inputs
       (list sbcl-alexandria
             sbcl-cl-str
             sbcl-esrap
             sbcl-local-time
             sbcl-parse-number))
      (home-page "https://github.com/sheepduke/clop")
      (synopsis "TOML parser for Common Lisp")
      (description
       "Clop is a Common Lisp library for parsing strings in the TOML
configuration file format.")
      (license license:expat))))

(define-public cl-clop
  (sbcl-package->cl-source-package sbcl-clop))

(define-public ecl-clop
  (sbcl-package->ecl-package sbcl-clop))

(define-public sbcl-closer-mop
  (let ((commit "7b86f2add029208ebc74ec6a41c2ccfd3c382dbc")
        (revision "3"))
    (package
      (name "sbcl-closer-mop")
      (version (git-version  "1.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/pcostanza/closer-mop")
               (commit commit)))
         (sha256
          (base32 "1fzxdpq873rpagmj3h9bgv7n95h4p03pnxrklbxp06sxb26xyi16"))
         (file-name (git-file-name "cl-closer-mop" version ))))
      (build-system asdf-build-system/sbcl)
      (home-page "https://github.com/pcostanza/closer-mop")
      (synopsis "Rectifies absent or incorrect CLOS MOP features")
      (description "Closer to MOP is a compatibility layer that rectifies many
of the absent or incorrect CLOS MOP features across a broad range of Common
Lisp implementations.")
      (license license:expat))))

(define-public cl-closer-mop
  (sbcl-package->cl-source-package sbcl-closer-mop))

(define-public ecl-closer-mop
  (sbcl-package->ecl-package sbcl-closer-mop))

(define-public clasp-closer-mop
  (sbcl-package->clasp-package sbcl-closer-mop))

(define-public sbcl-clostrum
  (let ((commit "c85d38bde9d093f1f132574e9b98b8d64683cd51")
        (revision "0"))
    (package
      (name "sbcl-clostrum")
      (version (git-version "0.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/s-expressionists/Clostrum")
               (commit commit)))
         (file-name (git-file-name "cl-clostrum" commit))
         (sha256
          (base32 "10alsdnpzbgic75xghwjp414sqwg4npvp69zn0r4l8ms0ki9zr1x"))))
      (build-system asdf-build-system/sbcl)
      (native-inputs (list sbcl-fiveam))
      (home-page "https://github.com/s-expressionists/Clostrum")
      (synopsis "First Class Global Environments")
      (description
       "This package provides first-class global environments for
Common Lisp.")
      (license license:bsd-2))))

(define-public cl-clostrum
  (sbcl-package->cl-source-package sbcl-clostrum))

(define-public ecl-clostrum
  (sbcl-package->ecl-package sbcl-clostrum))

(define sbcl-closure-common
  (let ((commit "e3c5f5f454b72b01b89115e581c3c52a7e201e5c")
        (revision "1"))
    (package
      (name "sbcl-closure-common")
      (build-system asdf-build-system/sbcl)
      (version (git-version "20101006" revision commit))
      (home-page "https://common-lisp.net/project/cxml/")
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/sharplispers/closure-common")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "0k5r2qxn122pxi301ijir3nayi9sg4d7yiy276l36qmzwhp4mg5n"))))
      (inputs
       `(("trivial-gray-streams" ,sbcl-trivial-gray-streams)
         ("babel" ,sbcl-babel)))
      (synopsis "Support Common Lisp library for CXML")
      (description "Closure-common is an internal helper library.  The name
Closure is a reference to the web browser it was originally written for.")
      ;; TODO: License?
      (license #f))))

(define-public sbcl-closure-template
  ;; There are no releases since 2015.
  (let ((commit "f1983aa525045691e128027d2a2d74831c873d6e")
        (revision "0"))
    (package
      (name "sbcl-closure-template")
      (version (git-version "0.2.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/archimag/cl-closure-template")
               (commit commit)))
         (file-name (git-file-name "cl-closure-template" version))
         (sha256
          (base32 "16h0fs6bjjd4n9pbkwcprpgyj26vsw2akk3q08m7xmsmqi05dppv"))))
      (build-system asdf-build-system/sbcl)
      (native-inputs (list sbcl-lift))
      (inputs
       (list sbcl-alexandria
             sbcl-babel
             sbcl-closer-mop
             sbcl-esrap
             sbcl-iterate
             sbcl-parse-number
             sbcl-split-sequence))
      (synopsis "Lisp implementation of Google Closure Templates")
      (description
       "This package provides a Common Lisp implementation of Google
Closure Templates.")
      (home-page "https://github.com/archimag/cl-closure-template/")
      (license license:llgpl))))

(define-public cl-closure-template
  (sbcl-package->cl-source-package sbcl-closure-template))

(define-public ecl-closure-template
  (let ((pkg (sbcl-package->ecl-package sbcl-closure-template)))
    (package
      (inherit pkg)
      ;; The test suite fails under ecl because the function
      ;;    LIFT::GET-BACKTRACE-AS-STRING
      ;; (from ecl-lift) is undefined. Lift's support for ecl
      ;; seems to be incomplete.
      (arguments (list #:tests? #false)))))

(define-public sbcl-clsql
  (package
    (name "sbcl-clsql")
    (version "6.7.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "http://git.kpe.io/clsql.git")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1v1k3s5bsy3lgd9gk459bzpb1r0kdjda25s29samxw4gsgf1fqvp"))
       (modules '((guix build utils)))
       (snippet
        '(begin
           ;; The useless bundled debian folder drags `make' into the closure.
           (delete-file-recursively "debian")
           ;; Other Makefiles that drag `make'.
           (for-each delete-file
                     '("Makefile"
                       "db-db2/Makefile"
                       "db-mysql/Makefile"
                       "db-odbc/Makefile"
                       "db-oracle/Makefile"
                       "db-sqlite/Makefile"
                       "doc/Makefile"
                       "examples/sqlite3/init-func/Makefile"
                       "sql/Makefile"
                       "tests/Makefile"
                       "uffi/Makefile"
                       "uffi/Makefile.32+64bits"))
           ;; Remove precompiled libraries.
           (delete-file "db-mysql/clsql_mysql.dll")
           (delete-file "uffi/clsql_uffi.dll")
           (delete-file "uffi/clsql_uffi.lib")
           #t))))
    (build-system asdf-build-system/sbcl)
    (native-inputs
     `(("rt" ,sbcl-rt)))
    (inputs
     `(("cffi" ,sbcl-cffi)
       ("md5" ,sbcl-md5)
       ("mariadb-dev" ,mariadb "dev")
       ("mariadb-lib" ,mariadb "lib")
       ("postgresql" ,postgresql)
       ("postmodern" ,sbcl-postmodern)
       ("sqlite" ,sqlite)
       ("uffi" ,sbcl-uffi)
       ("zlib" ,zlib)))
    (arguments
     `(#:asd-systems '("clsql"
                       "clsql-uffi"
                       "clsql-sqlite3"
                       "clsql-postgresql"
                       "clsql-postgresql-socket3"
                       "clsql-mysql")
       #:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'fix-permissions
           (lambda _
             (make-file-writable "doc/html.tar.gz")
             #t))
         (add-after 'unpack 'fix-build
           (lambda _
             (substitute* "clsql-uffi.asd"
               (("\\(:version uffi \"2.0\"\\)")
                "uffi"))
             (substitute* "db-postgresql/postgresql-api.lisp"
               (("\\(data :cstring\\)")
                "(data :string)"))
             #t))
         (add-after 'unpack 'fix-paths
           (lambda* (#:key inputs outputs #:allow-other-keys)
             (substitute* "db-sqlite3/sqlite3-loader.lisp"
               (("libsqlite3")
                (string-append (assoc-ref inputs "sqlite")
                               "/lib/libsqlite3")))
             (substitute* "db-postgresql/postgresql-loader.lisp"
               (("libpq")
                (string-append (assoc-ref inputs "postgresql")
                               "/lib/libpq")))
             (let ((lib (string-append "#p\""
                                       (assoc-ref outputs "out")
                                       "/lib/\"")))
               (substitute* "clsql-mysql.asd"
                 (("#p\"/usr/lib/clsql/clsql_mysql\\.so\"")
                  lib))
               (substitute* "db-mysql/mysql-loader.lisp"
                 (("libmysqlclient" all)
                  (string-append (assoc-ref inputs "mariadb-lib") "/lib/" all))
                 (("clsql-mysql-system::\\*library-file-dir\\*")
                  lib)))
             #t))
         (add-before 'build 'build-helper-library
           (lambda* (#:key inputs outputs #:allow-other-keys)
             (let* ((mariadb-dev (assoc-ref inputs "mariadb-dev"))
                    (mariadb-lib (assoc-ref inputs "mariadb-lib"))
                    (inc-dir (string-append mariadb-dev "/include/mysql"))
                    (lib-dir (string-append mariadb-lib "/lib"))
                    (shared-lib-dir (string-append (assoc-ref outputs "out")
                                                   "/lib"))
                    (shared-lib (string-append shared-lib-dir
                                               "/clsql_mysql.so")))
               (mkdir-p shared-lib-dir)
               (invoke "gcc" "-fPIC" "-shared"
                       "-I" inc-dir
                       "db-mysql/clsql_mysql.c"
                       "-Wl,-soname=clsql_mysql"
                       "-L" lib-dir "-lmariadb" "-lz"
                       "-o" shared-lib)
               #t)))
         (add-after 'unpack 'fix-tests
           (lambda _
             (substitute* "clsql.asd"
               (("clsql-tests :force t")
                "clsql-tests"))
             #t)))))
    (synopsis "Common Lisp SQL Interface library")
    (description
     "@code{clsql} is a Common Lisp interface to SQL RDBMS based on the
Xanalys CommonSQL interface for Lispworks.  It provides low-level database
interfaces as well as a functional and an object oriented interface.")
    (home-page "https://clsql.kpe.io/")
    (license license:llgpl)))

(define-public cl-clsql
  (package
    (inherit (sbcl-package->cl-source-package sbcl-clsql))
    (native-inputs
     `(("rt" ,cl-rt)))
    (inputs
     (list (list mariadb "dev") postgresql sqlite zlib))
    (propagated-inputs
     `(("cffi" ,cl-cffi)
       ("md5" ,cl-md5)
       ("postmodern" ,cl-postmodern)
       ("uffi" ,cl-uffi)))
    (arguments
     `(#:phases
       ;; asdf-build-system/source has its own phases and does not inherit
       ;; from asdf-build-system/sbcl phases.
       (modify-phases %standard-phases/source
         (add-after 'unpack 'fix-permissions
           (lambda _
             (make-file-writable "doc/html.tar.gz")
             #t)))))))

(define-public ecl-clsql
  (let ((pkg (sbcl-package->ecl-package sbcl-clsql)))
    (package
      (inherit pkg)
      (inputs
       (alist-delete "uffi" (package-inputs pkg)))
      (arguments
       (substitute-keyword-arguments (package-arguments pkg)
         ((#:asd-systems asd-systems '())
          `(cons "clsql-cffi" ,asd-systems)))))))

(define-public sbcl-clss
  (let ((revision "3")
        (commit "cd5f603e8207ec23c147c5cfda636ef8273a7525"))
    (package
      (name "sbcl-clss")
      (version (git-version "0.3.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri
          (git-reference
           (url "https://codeberg.org/shinmera/clss")
           (commit commit)))
         (sha256
          (base32 "15wh1zafamxc5z5hni9ni72xg4n24am2xfqv7fwwhfw1sl06bcm2"))
         (file-name (git-file-name name version))))
      (inputs
       (list sbcl-array-utils sbcl-plump))
      (build-system asdf-build-system/sbcl)
      (synopsis "DOM tree searching engine based on CSS selectors")
      (description "CLSS is a DOM traversal engine based on CSS
selectors.  It makes use of the Plump-DOM and is used by lQuery.")
      (home-page "https://codeberg.org/shinmera/clss")
      (license license:zlib))))

(define-public cl-clss
  (sbcl-package->cl-source-package sbcl-clss))

(define-public ecl-clss
  (sbcl-package->ecl-package sbcl-clss))

(define-public sbcl-cluffer
  (let ((commit "4aad29c276a58a593064e79972ee4d77cae0af4a"))
    (package
      (name "sbcl-cluffer")
      (version (git-version "0.0.0" "1" commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/robert-strandh/cluffer")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "1bcg13g7qb3dr8z50aihdjqa6miz5ivlc9wsj2csgv1km1mak2kj"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-acclimation sbcl-clump))
      (arguments
       `(#:phases
         (modify-phases %standard-phases
           (add-after 'strip 'unpatch-shebangs
             (lambda* (#:key outputs #:allow-other-keys)
               ;; The documentation Makefile rely on shell scripts.
               ;; TODO: Build it!
               ;; In the mean time, remove the shabang as it adds bash to the
               ;; closure.
               (let* ((out (assoc-ref outputs "out"))
                      (build-aux (string-append
                                  out "/share/")))
                 (substitute* (find-files build-aux)
                   (("^#!.*/bin/sh") "#!/bin/sh")
                   (("^#!.*/bin/bash") "#!/bin/bash"))))))))
      (home-page "https://github.com/robert-strandh/cluffer")
      (synopsis "Common Lisp library providing a protocol for text-editor buffers")
      (description "Cluffer is a library for representing the buffer of a text
editor.  As such, it defines a set of CLOS protocols for client code to
interact with the buffer contents in various ways, and it supplies different
implementations of those protocols for different purposes.")
      (license license:bsd-2))))

(define-public cl-cluffer
  (sbcl-package->cl-source-package sbcl-cluffer))

(define-public ecl-cluffer
  (sbcl-package->ecl-package sbcl-cluffer))

(define-public sbcl-clump
  (let ((commit "1ea4dbac1cb86713acff9ae58727dd187d21048a"))
    (package
      (name "sbcl-clump")
      (version (git-version "0.0.0" "1" commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/robert-strandh/Clump")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "1639msyagsswj85gc0wd90jgh8588j3qg5q70by9s2brf2q6w4lh"))))
      (inputs
       (list sbcl-acclimation))
      (build-system asdf-build-system/sbcl)
      (home-page "https://github.com/robert-strandh/Clump")
      (synopsis "Collection of tree implementations for Common Lisp")
      (description "The purpose of this library is to provide a collection of
implementations of trees.

In contrast to existing libraries such as cl-containers, it does not impose a
particular use for the trees.  Instead, it aims for a stratified design,
allowing client code to choose between different levels of abstraction.

As a consequence of this policy, low-level interfaces are provided where
the concrete representation is exposed, but also high level interfaces
where the trees can be used as search trees or as trees that represent
sequences of objects.")
      (license license:bsd-2))))

(define-public cl-clump
  (sbcl-package->cl-source-package sbcl-clump))

(define-public ecl-clump
  (sbcl-package->ecl-package sbcl-clump))

(define-public sbcl-cluster
  (let ((commit "b040e97578f3027d7d8c7652c74917726574c43e")
        (revision "0"))
    (package
      (name "sbcl-cluster")
      (version (git-version "0.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/robert-strandh/Cluster")
               (commit commit)))
         (file-name (git-file-name "cl-cluster" commit))
         (sha256
          (base32 "0ixbr3wm7d3m8mgzasd95rxvs9kip6ngr5s1zk7j3604mcfssqyi"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-acclimation
             sbcl-split-sequence))
      (home-page "https://github.com/robert-strandh/Cluster")
      (synopsis "Assembler with input in the form of standard instances")
      (description
       "Cluster is an assembler (initially for x86 and x86-64) with a difference.
To avoid the issue of defining a syntax, the input to Cluster is a list
of standard objects (i.e., instances of the class STANDARD-OBJECT),
as opposed to a character file or S-expressions.")
      (license license:bsd-2))))

(define-public cl-cluster
  (sbcl-package->cl-source-package sbcl-cluster))

(define-public ecl-cluster
  (sbcl-package->ecl-package sbcl-cluster))

(define-public sbcl-clx
  (let ((version "0.7.7"))
    (package
      (name "sbcl-clx")
      (version version)
      (source
       (origin
         (method git-fetch)
         (uri
          (git-reference
           (url "https://github.com/sharplispers/clx")
           (commit version)))
         (sha256
          (base32 "12cqmr1h5sn79fifn2jzcx1y1vsc1kf0q231axqc5aa4xg04g2b0"))
         (file-name (git-file-name "cl-clx" version))))
      (build-system asdf-build-system/sbcl)
      (native-inputs
       (list sbcl-fiasco xorg-server-for-tests))
      (arguments
       (list #:phases
             #~(modify-phases %standard-phases
                 (add-before 'check 'prepare-test-environment
                   (lambda _
                     (system "Xvfb :1 &")
                     (setenv "DISPLAY" ":1"))))))
      (home-page "https://www.cliki.net/portable-clx")
      (synopsis "X11 client library for Common Lisp")
      (description "CLX is an X11 client library for Common Lisp.  The code was
originally taken from a CMUCL distribution, was modified somewhat in order to
make it compile and run under SBCL, then a selection of patches were added
from other CLXes around the net.")
      (license license:x11))))

(define-public cl-clx
  (sbcl-package->cl-source-package sbcl-clx))

(define-public ecl-clx
  (sbcl-package->ecl-package sbcl-clx))

(define-public sbcl-clx-truetype
  (let ((commit "c6e10a918d46632324d5863a8ed067a83fc26de8")
        (revision "1"))
    (package
      (name "sbcl-clx-truetype")
      (version (git-version "0.0.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/l04m33/clx-truetype")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "079hyp92cjkdfn6bhkxsrwnibiqbz4y4af6nl31lzw6nm91j5j37"))
         (modules '((guix build utils)))
         (snippet
          '(begin
             (substitute* "package.lisp"
               ((":export") ":export\n   :+font-cache-filename+"))
             #t))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-clx
             sbcl-zpb-ttf
             sbcl-cl-vectors
             sbcl-cl-fad
             sbcl-cl-store
             sbcl-trivial-features))
      (home-page "https://github.com/l04m33/clx-truetype")
      (synopsis "Antialiased TrueType font rendering using CLX and XRender")
      (description "CLX-TrueType is pure common lisp solution for
antialiased TrueType font rendering using CLX and XRender extension.")
      (license license:expat))))

(define-public cl-clx-truetype
  (sbcl-package->cl-source-package sbcl-clx-truetype))

(define-public ecl-clx-truetype
  (sbcl-package->ecl-package sbcl-clx-truetype))

(define-public sbcl-clx-xembed
  (let ((commit "a5c4b844d31ee68ffa58c933cc1cdddde6990743")
        (revision "1"))
    (package
      (name "sbcl-clx-xembed")
      (version (git-version "0.1" revision commit))
      (home-page "https://github.com/laynor/clx-xembed")
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/laynor/clx-xembed")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "1abx4v36ycmfjdwpjk4hh8058ya8whwia7ds9vd96q2qsrs57f12"))))
      (build-system asdf-build-system/sbcl)
      (arguments
       `(#:asd-systems '("xembed")))
      (inputs
       (list sbcl-clx))
      (synopsis "CL(x) xembed protocol implementation")
      (description "CL(x) xembed protocol implementation")
      ;; MIT License
      (license license:expat))))

(define-public cl-clx-xembed
  (sbcl-package->cl-source-package sbcl-clx-xembed))

(define-public ecl-clx-xembed
  (sbcl-package->ecl-package sbcl-clx-xembed))

(define-public sbcl-cmd
  (let ((commit "0164d574ba236e2001ee1d9dba3f4774c7512a8c")
        (revision "8"))
    (package
      (name "sbcl-cmd")
      (version (git-version "0.0.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/ruricolist/cmd/")
               (commit commit)))
         (file-name (git-file-name "cl-cmd" version))
         (sha256
          (base32 "03wbckzmz6pqdlz7pyar6nfg4vs4bl0b2np7n3kk3qhjbrdakc4m"))))
      (build-system asdf-build-system/sbcl)
      (arguments
       (list #:phases
             #~(modify-phases %standard-phases
                 (add-after 'unpack 'fix-paths
                   (lambda* (#:key inputs #:allow-other-keys)
                     (let ((bin (string-append (assoc-ref inputs "coreutils")
                                               "/bin"))
                           (ps-bin (string-append (assoc-ref inputs "procps")
                                                  "/bin")))
                       (substitute* "cmd.lisp"
                         (("\\(def \\+env\\+ \"env\"\\)")
                          (format #f "(def +env+ \"~a/env\")" bin))
                         (("\\(def \\+kill\\+ \"kill\"\\)")
                          (format #f "(def +kill+ \"~a/kill\")" bin))
                         (("\\(def \\+ps\\+ \"ps\"\\)")
                          (format #f "(def +ps+ \"~a/ps\")" ps-bin))
                         (("\\(def \\+pwd\\+ \"pwd\"\\)")
                          (format #f "(def +pwd+ \"~a/pwd\")" bin))
                         (("\\(def \\+sh\\+ \"/bin/sh\"\\)")
                          (format #f "(def +sh+ \"~a\")" (which "sh")))
                         (("\\(def \\+tr\\+ \"tr\"\\)")
                          (format #f "(def +tr+ \"~a/tr\")" bin)))))))))
      (inputs
       (list coreutils
             procps
             sbcl-alexandria
             sbcl-serapeum
             sbcl-shlex
             sbcl-trivia))
      (home-page "https://github.com/ruricolist/cmd")
      (synopsis "Conveniently run external programs from Common Lisp")
      (description
       "A utility for running external programs, built on UIOP.
Cmd is designed to be natural to use, protect against shell interpolation and
be usable from multi-threaded programs.")
      (license license:expat))))

(define-public cl-cmd
  (sbcl-package->cl-source-package sbcl-cmd))

(define-public ecl-cmd
  (sbcl-package->ecl-package sbcl-cmd))

(define-public sbcl-cmn
  (package
    (name "sbcl-cmn")
    (version "2021.11.22")
    (source
     (origin
       (method url-fetch)
       (uri "https://ccrma.stanford.edu/software/cmn/cmn.tar.gz")
       (file-name (string-append "cmn-" version ".tar.gz"))
       (sha256
        (base32 "04j1l57cdyfi2zzxqwmvmf1hl899ffgs3bl4r42ba47zsw45kq14"))))
    (build-system asdf-build-system/sbcl)
    (home-page "https://ccrma.stanford.edu/software/cmn/")
    (synopsis "Western music notation package written in Common Lisp")
    (description
     "CMN provides a package of functions to hierarchically describe a musical
score.  When evaluated, the musical score is rendered to an image.")
    (license license:expat)))

(define-public cl-cmn
  (sbcl-package->cl-source-package sbcl-cmn))

(define-public ecl-cmn
  (sbcl-package->ecl-package sbcl-cmn))

(define-public sbcl-coalton
  (let ((commit "939342495f55991812c2c2767322c5e51e755216")
        (revision "4"))
    (package
      (name "sbcl-coalton")
      (version (git-version "0.0.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/coalton-lang/coalton")
               (commit commit)))
         (file-name (git-file-name "cl-coalton" version))
         (sha256
          (base32 "08qzj3v4fvn9h87whyqg650rpap8lva7jr94d1akv6m2z62l5q68"))))
      (build-system asdf-build-system/sbcl)
      (native-inputs
       (list sbcl-fiasco))
      (inputs
       (list sbcl-alexandria
             sbcl-concrete-syntax-tree
             sbcl-eclector
             sbcl-float-features
             sbcl-fset
             sbcl-named-readtables
             sbcl-trivial-garbage))
      (home-page "https://coalton-lang.github.io")
      (synopsis "Dialect of ML in Common Lisp")
      (description
       "Coalton is a dialect of ML embedded in Common Lisp.  It emphasizes
practicality and interoperability with Lisp, and is intended to be a DSL that
allows one to gradually make their programs safer.")
      (license license:expat))))

(define-public cl-coalton
  (sbcl-package->cl-source-package sbcl-coalton))

(define-public ecl-coalton
  (sbcl-package->ecl-package sbcl-coalton))

(define-public sbcl-coleslaw
  (let ((commit "e7e68ce6020d13b14bf212890a7d8973d7af3b40")
        (revision "0"))
    (package
      (name "sbcl-coleslaw")
      (version (git-version "0.9.7" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/coleslaw-org/coleslaw")
               (commit commit)))
         (file-name (git-file-name "cl-coleslaw" version))
         (sha256
          (base32 "1w21a272q4x7nlr4kbmwwvkjvb4hpnw869byvy47vv361y7pimws"))))
      (build-system asdf-build-system/sbcl)
      (outputs '("out" "bin"))
      (arguments
       '(#:asd-systems '("coleslaw" "coleslaw-cli")
         #:phases
         (modify-phases %standard-phases
           (add-after 'unpack 'fix-paths
             (lambda _
               (substitute* "plugins/publish-gh-pages.sh"
                 (("^rsync\\b") (which "rsync")))
               (substitute* '("plugins/rsync.lisp"
                              "src/coleslaw.lisp")
                 (("\\brun-program \"rsync\\b")
                  (string-append "run-program \"" (which "rsync"))))))
           (add-after 'create-asdf-configuration 'build-program
             (lambda* (#:key outputs #:allow-other-keys)
               (build-program
                (string-append (assoc-ref outputs "bin") "/bin/coleslaw")
                outputs
                #:dependencies '("coleslaw-cli")
                #:entry-program '((apply (function coleslaw-cli::main)
                                   arguments))
                #:compress? #t))))))
      (native-inputs
       (list sbcl-prove))
      (inputs
       (list rsync
             sbcl-3bmd
             sbcl-alexandria
             sbcl-cl-fad
             sbcl-cl-ppcre
             sbcl-cl-unicode
             sbcl-clack
             sbcl-closer-mop
             sbcl-closure-template
             sbcl-inferior-shell
             sbcl-local-time
             sbcl-trivia))
      (home-page "https://github.com/coleslaw-org/coleslaw")
      (synopsis "Static site generator")
      (description
       "Coleslaw is a static site generator written in Common Lisp.")
      (license license:bsd-2))))

(define-public cl-coleslaw
  (sbcl-package->cl-source-package sbcl-coleslaw))

(define-public ecl-coleslaw
  (sbcl-package->ecl-package sbcl-coleslaw))

(define-public sbcl-collectors
  (let ((commit "4c5e70cf399381de8fb485d4ed5a5c8fd7555146")
        (revision "2"))
    (package
      (name "sbcl-collectors")
      (version (git-version "1.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/AccelerationNet/collectors")
               (commit commit)))
         (file-name (git-file-name "cl-collectors" version))
         (sha256
          (base32 "1kc9q05wyp8yjz5wqc73nar7l49vcnfhj4924li81v76hlb03665"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-alexandria sbcl-closer-mop sbcl-symbol-munger))
      (native-inputs
       (list sbcl-lisp-unit2))
      (home-page "https://github.com/AccelerationNet/collectors/")
      (synopsis "Common lisp library providing collector macros")
      (description "A small collection of common lisp macros to make
collecting values easier.")
      (license license:bsd-3))))

(define-public cl-collectors
  (sbcl-package->cl-source-package sbcl-collectors))

(define-public ecl-collectors
  (sbcl-package->ecl-package sbcl-collectors))

(define-public sbcl-colored
  (let ((commit "54e6184da4aca380cc7240c417f1e2a0d76b3a84")
        (revision "2"))
    (package
      (name "sbcl-colored")
      (version (git-version "1.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://codeberg.org/shinmera/colored")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "1n9k8rh2p7kb2ikxpgw8sywaxw0n5m3iky808dwc4hqz04piqmmh"))))
      (build-system asdf-build-system/sbcl)
      (native-inputs
       (list sbcl-parachute))
      (inputs
       (list sbcl-documentation-utils))
      (synopsis "Colour representation, conversion, and operation for Common Lisp")
      (description
       "This is a library for representing and mapping colours between their
various spaces.")
      (home-page "https://shinmera.com/docs/colored")
      (license license:zlib))))

(define-public cl-colored
  (sbcl-package->cl-source-package sbcl-colored))

(define-public ecl-colored
  (sbcl-package->ecl-package sbcl-colored))

(define-public sbcl-colorize
  (let ((commit "ea676b584e0899cec82f21a9e6871172fe3c0eb5"))
    (package
      (name "sbcl-colorize")
      (version (git-version "0.0.0" "1" commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/kingcons/colorize")
               (commit commit)))
         (sha256
          (base32
           "1pdg4kiaczmr3ivffhirp7m3lbr1q27rn7dhaay0vwghmi31zcw9"))
         (file-name (git-file-name "colorize" version))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-alexandria sbcl-split-sequence sbcl-html-encode))
      (synopsis "Common Lisp for syntax highlighting")
      (description
       "@command{colorize} is a Lisp library for syntax highlighting
supporting the following languages: Common Lisp, Emacs Lisp, Scheme, Clojure,
C, C++, Java, Python, Erlang, Haskell, Objective-C, Diff, Webkit.")
      (home-page "https://github.com/kingcons/colorize")
      ;; TODO: Missing license?
      (license license:expat))))

(define-public cl-colorize
  (sbcl-package->cl-source-package sbcl-colorize))

(define-public ecl-colorize
  (sbcl-package->ecl-package sbcl-colorize))

(define-public sbcl-com.gigamonkeys.binary-data
  (let ((commit "22e908976d7f3e2318b7168909f911b4a00963ee")
        (revision "0"))
    (package
      (name "sbcl-com.gigamonkeys.binary-data")
      (version (git-version "0.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/gigamonkey/monkeylib-binary-data")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "072v417vmcnvmyh8ddq9vmwwrizm7zwz9dpzi14qy9nsw8q649zw"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-alexandria))
      (home-page "https://github.com/gigamonkey/monkeylib-binary-data")
      (synopsis "Common Lisp library for reading and writing binary data")
      (description
       "This a Common Lisp library for reading and writing binary data.  It is
based on code from chapter 24 of the book @emph{Practical Common Lisp}.")
      (license license:bsd-3))))

(define-public cl-com.gigamonkeys.binary-data
  (sbcl-package->cl-source-package sbcl-com.gigamonkeys.binary-data))

(define-public ecl-com.gigamonkeys.binary-data
  (sbcl-package->ecl-package sbcl-com.gigamonkeys.binary-data))

(define-public sbcl-command-line-args
  (package
    (name "sbcl-command-line-args")
    (version "0.1.3")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://git.sr.ht/~whereiseveryone/command-line-args")
             (commit (string-append "v" version))))
       (file-name (git-file-name "cl-command-line-args" version))
       (sha256
        (base32 "1vzybqnqwrfl8b708h8wx8xsm1ml5c3r0lcx23615hb4p800iagf"))))
    (build-system asdf-build-system/sbcl)
    (arguments
     '(#:asd-systems '("whereiseveryone.command-line-args")))
    (inputs
     (list sbcl-alexandria
           sbcl-charje.documentation
           sbcl-cl-str
           sbcl-serapeum
           sbcl-trivia))
    (home-page "https://git.sr.ht/~whereiseveryone/command-line-args")
    (synopsis "Automatically generate command line interfaces")
    (description "Command-Line-Args provides a main macro (@code{command})
that wraps a @code{defun} form and creates a new function that parses the
command line arguments.  It has support for command-line options, positional,
and variadic arguments.  It also generates a basic help message.  The
interface is meant to be easy and non-intrusive.")
    (license license:agpl3+)))

(define-public cl-command-line-args
  (sbcl-package->cl-source-package sbcl-command-line-args))

(define-public ecl-command-line-args
  (let ((pkg (sbcl-package->ecl-package sbcl-command-line-args)))
    (package
      (inherit pkg)
      (arguments
       (substitute-keyword-arguments (package-arguments pkg)
         ;; The tests only work on SBCL.
         ((#:tests? _ #f) #f))))))

(define-public sbcl-command-line-arguments
  (let ((commit "fbac862fb01c0e368141204f3f639920462c23fe")
        (revision "1"))
    (package
      (name "sbcl-command-line-arguments")
      (version (git-version "2.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/fare/command-line-arguments")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "054m1ikndzqf72mb9ajaa64136cwr3bgag4yfbi1574a9vq75mjq"))))
      (build-system asdf-build-system/sbcl)
      (home-page "https://github.com/fare/command-line-arguments")
      (synopsis "Trivial command-line argument parsing library for Common Lisp")
      (description "This is a library to abstract away the parsing of
Unix-style command-line arguments.  Use it in conjunction with asdf:program-op
or cl-launch for portable processing of command-line arguments.")
      (license license:expat))))

(define-public cl-command-line-arguments
  (sbcl-package->cl-source-package sbcl-command-line-arguments))

(define-public ecl-command-line-arguments
  (sbcl-package->ecl-package sbcl-command-line-arguments))

(define-public clasp-command-line-arguments
  (sbcl-package->clasp-package sbcl-command-line-arguments))

(define-public sbcl-common-doc
  (let ((commit "bcde4cfee3d34482d9830c8f9ea45454c73cf5aa")
        (revision "0"))
    (package
      (name "sbcl-common-doc")
      (version (git-version "0.2.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/CommonDoc/common-doc")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "0bzc4w37cq5mbkd15vxziks6nq58yad04mki4nwy5w6pza7z0faa"))))
      (build-system asdf-build-system/sbcl)
      (native-inputs
       (list sbcl-fiveam))
      (inputs
       (list sbcl-alexandria
             sbcl-anaphora
             sbcl-cl-ppcre
             sbcl-closer-mop
             sbcl-local-time
             sbcl-quri
             sbcl-split-sequence
             sbcl-trivial-shell
             sbcl-trivial-types))
      (home-page "https://github.com/CommonDoc/common-doc")
      (synopsis "Framework for representing and manipulating documents")
      (description "Framework for representing and manipulating documents.")
      (license license:expat))))

(define-public ecl-common-doc
  (sbcl-package->ecl-package sbcl-common-doc))

(define-public cl-common-doc
  (sbcl-package->cl-source-package sbcl-common-doc))

(define-public sbcl-common-html
  (let ((commit "96987bd9db21639ed55d1b7d72196f9bc58243fd")
        (revision "0"))
    (package
      (name "sbcl-common-html")
      (version (git-version "0.1.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/CommonDoc/common-html")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "1i11w4l95nybz5ibnaxrnrkfhch2s9wynqrg6kx6sl6y47khq1xz"))))
      (build-system asdf-build-system/sbcl)
      (native-inputs
       (list sbcl-fiveam))
      (inputs
       (list sbcl-alexandria
             sbcl-anaphora
             sbcl-common-doc
             sbcl-plump))
      (home-page "https://github.com/CommonDoc/common-html")
      (synopsis "HTML parser/emitter for CommonDoc")
      (description "HTML parser/emitter for CommonDoc.")
      (license license:expat))))

(define-public ecl-common-html
  (sbcl-package->ecl-package sbcl-common-html))

(define-public cl-common-html
  (sbcl-package->cl-source-package sbcl-common-html))

(define-public sbcl-common-lisp-jupyter
  (let ((commit "3555a009f6d8734751bda1feadc8a09e7b0099b6")
        (revision "0"))
    (package
      (name "sbcl-common-lisp-jupyter")
      (version (git-version "1.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/yitzchak/common-lisp-jupyter")
               (commit commit)))
         (file-name (git-file-name "cl-common-lisp-jupyter" commit))
         (sha256
          (base32 "05nj171jad9819iq137i7vxgxyxz1sr3p4qxgr2k7z1ihq5kb0gw"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-alexandria
             sbcl-babel
             sbcl-bordeaux-threads
             sbcl-cl-base64
             sbcl-cl-indentify
             sbcl-closer-mop
             sbcl-dissect
             sbcl-eclector
             sbcl-ironclad
             sbcl-multilang-documentation
             sbcl-nontrivial-gray-streams
             sbcl-puri
             sbcl-pzmq
             sbcl-shasht
             sbcl-trivial-do
             sbcl-trivial-features
             sbcl-trivial-mimes))
      (home-page "https://yitzchak.github.io/common-lisp-jupyter/")
      (synopsis "Common Lisp kernel for Jupyter")
      (description
       "This is a Common Lisp kernel for Jupyter along with a library for
building Jupyter kernels, based on Maxima-Jupyter which was based on
@code{cl-jupyter}.")
      (license license:expat))))

(define-public cl-common-lisp-jupyter
  (sbcl-package->cl-source-package sbcl-common-lisp-jupyter))

(define-public ecl-common-lisp-jupyter
  (sbcl-package->ecl-package sbcl-common-lisp-jupyter))

(define-public sbcl-commondoc-markdown
  (let ((commit "7abd28806bec33f291b982684d143edddb5cc32a")
        (revision "0"))
    (package
      (name "sbcl-commondoc-markdown")
      (version (git-version "0.5.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/40ants/commondoc-markdown")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "12n8yx8jhz8713r63gmrymplm1mfczm7q7a343d13wl6gng1gjs1"))))
      (build-system asdf-build-system/sbcl)
      (native-inputs
       (list sbcl-hamcrest))
      (inputs
       (list sbcl-3bmd
             sbcl-cl-str
             sbcl-common-doc
             sbcl-common-html
             sbcl-ironclad
             sbcl-plump))
      (home-page "https://github.com/40ants/commondoc-markdown")
      (synopsis "Converts Markdown text into CommonDoc nodes and vice versa")
      (description "Converts Markdown text into CommonDoc nodes and vice
versa.")
      (license license:unlicense))))

(define-public ecl-commondoc-markdown
  (sbcl-package->ecl-package sbcl-commondoc-markdown))

(define-public cl-commondoc-markdown
  (sbcl-package->cl-source-package sbcl-commondoc-markdown))

(define-public sbcl-compatible-metaclasses
  (package
    (name "sbcl-compatible-metaclasses")
    (version "1.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/Hexstream/compatible-metaclasses")
             (commit (string-append "v" version))))
       (file-name (git-file-name "cl-compatible-metaclasses" version))
       (sha256
        (base32 "17cf74j400cl6sjslfhkv13lir85k705v63mx3dd4y6dl5hvsdh6"))))
    (build-system asdf-build-system/sbcl)
    (native-inputs
     (list sbcl-parachute))
    (inputs
     (list sbcl-class-options
           sbcl-closer-mop
           sbcl-enhanced-find-class))
    (home-page "https://www.hexstreamsoft.com/libraries/compatible-metaclasses/")
    (synopsis "Simplifies class mixins by validating superclasses")
    (description
     "This library validates superclasses according to a simple substitution
model, thereby greatly simplifying the definition of class mixins.")
    (license license:unlicense)))

(define-public cl-compatible-metaclasses
  (sbcl-package->cl-source-package sbcl-compatible-metaclasses))

(define-public ecl-compatible-metaclasses
  (sbcl-package->ecl-package sbcl-compatible-metaclasses))

(define-public clasp-compatible-metaclasses
  (sbcl-package->clasp-package sbcl-compatible-metaclasses))

(define-public sbcl-compiler-macro
  (let ((commit "7796bda64aec5af3ca175170ad3565167868789c")
        (revision "0"))
    (package
      (name "sbcl-compiler-macro")
      (version (git-version "0.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/Bike/compiler-macro")
               (commit commit)))
         (file-name (git-file-name "cl-compiler-macro" version))
         (sha256
          (base32 "13sswps7s0qy6939mvj8q57hkx0qkga6rl6xjhjr7pk7by0xdsjq"))))
      (build-system asdf-build-system/sbcl)
      (native-inputs
       (list sbcl-fiveam))
      (inputs
       (list sbcl-introspect-environment))
      (home-page "https://github.com/Bike/compiler-macro")
      (synopsis "Common Lisp compiler macro utilities")
      (description "This library is a collection of utilities for writing
compiler macros.  It is intended to make it possible to make compiler macros
much more useful, by granting them access to lexical type information, making
the protocol for declining expansion more convenient, and establishing some
information for signaling optimization advice to programmers.  Some utilities
to support this, especially for reasoning on types, are also included.")
      (license license:cc0))))

(define-public cl-compiler-macro
  (sbcl-package->cl-source-package sbcl-compiler-macro))

(define-public ecl-compiler-macro
  (sbcl-package->ecl-package sbcl-compiler-macro))

(define-public sbcl-compiler-macro-notes
  (package
    (name "sbcl-compiler-macro-notes")
    (version "0.3.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/digikar99/compiler-macro-notes")
             (commit (string-append "v" version))))
       (file-name (git-file-name "cl-compiler-macro-notes" version))
       (sha256
        (base32 "0pchhvk14fx54p7qq92dnf0g4jnapqr6p2a4za6bhzd8im1d9gad"))))
    (build-system asdf-build-system/sbcl)
    (inputs
     (list sbcl-alexandria
           sbcl-cl-environments))
    (home-page "https://github.com/digikar99/compiler-macro-notes")
    (synopsis "Macros and conditions for use within macros and compiler-macros")
    (description
     "Alternative to the @code{compiler-macro} library:

@itemize
@item Here, we do not treat compiler notes as warnings, but instead these are
a separate class of conditions.  These are also not errors.
@item Two main condition classes are provided: compiler-macro-notes:note and
compiler-macro-notes:optimization-failure-note.  While the latter is a subclass
of the former, the latter notes are printed in a slightly different manner to
the former.
@item To be able to correctly print the expansion path that led to the
condition, user code is expected to avoid performing a nonlocal exit to a
place outside with-notes.
@end itemize\n")
    (license license:expat)))

(define-public cl-compiler-macro-notes
  (sbcl-package->cl-source-package sbcl-compiler-macro-notes))

(define-public ecl-compiler-macro-notes
  (sbcl-package->ecl-package sbcl-compiler-macro-notes))

(define-public sbcl-computable-reals
  (let ((commit "fdc73d75e79d0a4ce6d01c822c950ae2eb137d39"))
    (package
      (name "sbcl-computable-reals")
      (version (git-version "1.1.0" "1" commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/stylewarning/computable-reals")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "0f12axi53x14l12dgf4a1lfq3p1fx7fh7sjfc0db3lk88ph9qfwl"))))
      (build-system asdf-build-system/sbcl)
      (home-page "https://github.com/stylewarning/computable-reals")
      (synopsis "Arbitrary-precision, re-computing real-numbers in Common Lisp")
      (description
       "This library provides arbitrary precision (floating point) real
numbers in Common Lisp.")
      (license license:bsd-3))))

(define-public cl-computable-reals
  (sbcl-package->cl-source-package sbcl-computable-reals))

(define-public ecl-computable-reals
  (sbcl-package->ecl-package sbcl-computable-reals))

(define-public sbcl-concrete-syntax-tree
  (let ((commit "37291727196a3bc88a7be67c1427c52078d4b82c")
        (revision "0"))
    (package
      (name "sbcl-concrete-syntax-tree")
      (version (git-version "0.2.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/s-expressionists/Concrete-Syntax-Tree")
               (commit commit)))
         (file-name (git-file-name "cl-concrete-syntax-tree" commit))
         (sha256
          (base32 "15q9jyqsh2z921li9my8c840cj2ci7k217x5frfiyk0kymkx4rgv"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-acclimation))
      (arguments
       '(#:asd-systems '("concrete-syntax-tree"
                         "concrete-syntax-tree-destructuring"
                         "concrete-syntax-tree-source-info")))
      (home-page "https://github.com/s-expressionists/Concrete-Syntax-Tree")
      (synopsis "Parse Common Lisp code into a concrete syntax tree")
      (description
       "This library is intended to solve the problem of source tracking for
Common Lisp code.

By \"source tracking\", it is meant that code elements that have a known
origin in the form of a position in a file or in an editor buffer are
associated with some kind of information about this origin.

Since the exact nature of such origin information depends on the Common Lisp
implementation and the purpose of wanting to track that origin, the library
does not impose a particular structure of this information.  Instead, it
provides utilities for manipulating source code in the form of what is called
concrete syntax trees (CSTs for short) that preserve this information about
the origin.")
      (license license:bsd-2))))

(define-public cl-concrete-syntax-tree
  (sbcl-package->cl-source-package sbcl-concrete-syntax-tree))

(define-public ecl-concrete-syntax-tree
  (sbcl-package->ecl-package sbcl-concrete-syntax-tree))

(define-public sbcl-concurrent-hash-tables
  (let ((commit "6ad539b8970ff94b1e1369b59065ed7d0660904c")
        (revision "1"))
    (package
      (name "sbcl-concurrent-hash-tables")
      (version (git-version "0.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/no-defun-allowed/concurrent-hash-tables")
               (commit commit)))
         (file-name (git-file-name "cl-concurrent-hash-tables" version))
         (sha256
          (base32 "0wgbv3wl33rlfbywmjag0gk7igzfksmib30r8cbnd5n47ic09iip"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-atomics sbcl-bordeaux-threads))
      (home-page "https://github.com/no-defun-allowed/concurrent-hash-tables")
      (synopsis "Portability library for concurrent hash tables in Common Lisp")
      (description "@code{concurrent-hash-tables} is a Common Lisp portability
library wrapping some implementations of concurrent hash tables which do not
have to be entirely locked in their operation, including
@code{42nd-at-threadmill}, @code{luckless}, and a fallback, segmented hash
table.")
      (license license:bsd-2))))

(define-public cl-concurrent-hash-tables
  (sbcl-package->cl-source-package sbcl-concurrent-hash-tables))

(define-public ecl-concurrent-hash-tables
  (sbcl-package->ecl-package sbcl-concurrent-hash-tables))

(define-public sbcl-conduit-packages
  (package
   (name "sbcl-conduit-packages")
   (version "2.0.0")
   (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/tfeb/conduit-packages")
             (commit (string-append "v" version))))
       (file-name (git-file-name "cl-conduit-packages" version))
       (sha256
        (base32 "1n783in84mrk9lnc3nshwsgxhb8y0dk6ys9z6jlxkv0jpjxhpjjc"))))
   (build-system asdf-build-system/sbcl)
   (arguments '(#:asd-systems '("org.tfeb.conduit-packages")))
   (synopsis "Conduit packages for Common Lisp")
   (description "This library defines a way of treating Common Lisp
packages as conduits which can sit between one or more implementation
packages and users of those packages.")
   (home-page "https://github.com/tfeb/conduit-packages/")
   (license license:expat)))

(define-public cl-conduit-packages
  (sbcl-package->cl-source-package sbcl-conduit-packages))

(define-public ecl-conduit-packages
  (sbcl-package->ecl-package sbcl-conduit-packages))

(define-public clasp-conduit-packages
  (sbcl-package->clasp-package sbcl-conduit-packages))

(define-public sbcl-conium
  (let ((commit "089adfd8759ec7973bb6f67b98d7a246e67aeb05")
        (revision "1"))
    (package
      (name "sbcl-conium")
      (version (git-version "0.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/sharplispers/conium")
               (commit commit)))
         (file-name (git-file-name "conium" version))
         (sha256
          (base32 "0y31za8xr8734p2pf8mrw1jd1fksh2d4y1p12wwjyn8hxxsvsx1w"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-closer-mop))
      (home-page "https://github.com/sharplispers/conium")
      (synopsis "Portability library for debugger- and compiler-related tasks")
      (description
       "Conium is a portability library for debugger- and compiler-related
tasks in Common Lisp.  It is fork of SWANK-BACKEND.")
      (license license:public-domain))))

(define-public cl-conium
  (sbcl-package->cl-source-package sbcl-conium))

(define-public ecl-conium
  (sbcl-package->ecl-package sbcl-conium))

(define-public clasp-conium
  (sbcl-package->clasp-package sbcl-conium))

(define-public sbcl-constantfold
  (let ((commit "0ff1d97a3fbcb89264f6a2af6ce62b73e7b421f4")
        (revision "1"))
    (package
      (name "sbcl-constantfold")
      (version (git-version "0.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/numcl/constantfold")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "153h0569z6bff1qbad0bdssplwwny75l7ilqwcfqfdvzsxf9jh06"))))
      (build-system asdf-build-system/sbcl)
      (synopsis "Support library for numcl")
      (description
       "Support library for numcl.  Registers a function as an
additional form that is considered as a candidate for a constant.")
      (home-page "https://github.com/numcl/constantfold")
      (license license:lgpl3+)
      (inputs
       `(("trivia" ,sbcl-trivia)
         ("alexandria" ,sbcl-alexandria)
         ("iterate" ,sbcl-iterate)
         ("lisp-namespace" ,sbcl-lisp-namespace)))
      (native-inputs
       (list sbcl-fiveam)))))

(define-public cl-constantfold
  (sbcl-package->cl-source-package sbcl-constantfold))

(define-public ecl-constantfold
  (sbcl-package->ecl-package sbcl-constantfold))

(define-public sbcl-contextl
  ;; No release since 2013.
  (let ((commit "f4fb3f59b0844788613fc4d1cc0d2b08df9488bb")
        (revision "2"))
    (package
      (name "sbcl-contextl")
      (version (git-version "1.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/pcostanza/contextl/")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "0apgznz4g6lpmd86lq7w0xddfjgnirk83ig7p0j6i93xadhy9wh0"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-closer-mop sbcl-lw-compat))
      (home-page "https://github.com/pcostanza/contextl")
      (synopsis "Context-oriented programming for Common Lisp")
      (description "ContextL is a CLOS extension for Context-Oriented
Programming (COP).

Find overview of ContextL's features in an overview paper:
@url{http://www.p-cos.net/documents/contextl-soa.pdf}.  See also this general
overview article about COP which also contains some ContextL examples:
@url{http://www.jot.fm/issues/issue_2008_03/article4/}.")
      (license license:expat))))

(define-public cl-contextl
  (sbcl-package->cl-source-package sbcl-contextl))

(define-public ecl-contextl
  (sbcl-package->ecl-package sbcl-contextl))

(define-public sbcl-core-gp
  (let ((commit "90ec1c4599a19c5a911be1f703f78d5108aee160")
        (revision "1"))
    (package
      (name "sbcl-core-gp")
      (version (git-version "0.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/jorgetavares/core-gp")
               (commit commit)))
         (file-name (git-file-name "cl-core-gp" version))
         (sha256
          (base32 "0nzlb2gwqisa1amlpl4zc5xxph2g3qwhfyaxchci67d31rzws6l3"))))
      (build-system asdf-build-system/sbcl)
      (home-page "https://github.com/jorgetavares/core-gp")
      (synopsis "Common Lisp library for genetic programming")
      (description
       "@code{core-gp} is a Common Lisp library for genetic programming (GP)
algorithms.  It allows standard GP, strongly-typed GP, grammatical evolution as
well as standard genetic algorithms.")
      (license license:expat))))

(define-public cl-core-gp
  (sbcl-package->cl-source-package sbcl-core-gp))

(define-public ecl-core-gp
  (sbcl-package->ecl-package sbcl-core-gp))

(define-public clasp-core-gp
  (sbcl-package->clasp-package sbcl-core-gp))

(define-public sbcl-croatoan
  (let ((commit "470055739ef6ece42655ef0f3878a87a9e3e9b78")
        (revision "2"))
    (package
      (name "sbcl-croatoan")
      (version (git-version "0.3" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://codeberg.org/McParen/croatoan")
               (commit commit)))
         (file-name (git-file-name "cl-croatoan" version))
         (sha256
          (base32 "04776x4i8inxs8n4mgy9xf0q39bzv4mfz4cl880sxwk6mnhwnn4c"))))
      (build-system asdf-build-system/sbcl)
      (arguments
       '(#:phases
         (modify-phases %standard-phases
           (add-after 'unpack 'fix-paths
             (lambda* (#:key inputs #:allow-other-keys)
               (substitute* "ncurses/ncurses.lisp"
                 (("libncursesw.so")
                  (search-input-file inputs "/lib/libncursesw.so"))))))))
      (inputs
       (list ncurses
             sbcl-cffi
             sbcl-trivial-gray-streams
             sbcl-bordeaux-threads))
      (synopsis "Common Lisp bindings for the ncurses terminal library")
      (description "Croatoan provides high-level Common Lisp CLOS bindings for
the ncurses terminal library.")
      (home-page "https://codeberg.org/McParen/croatoan")
      (license license:expat))))

(define-public cl-croatoan
  (sbcl-package->cl-source-package sbcl-croatoan))

(define-public ecl-croatoan
  (sbcl-package->ecl-package sbcl-croatoan))

(define-public sbcl-crypto-shortcuts
  (let ((commit "9b77282d7d52ff89753bd71b5584169b53942dbc")
        (revision "2"))
    (package
      (name "sbcl-crypto-shortcuts")
      (version (git-version "2.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://codeberg.org/shinmera/crypto-shortcuts")
               (commit commit)))
         (file-name (git-file-name "crypto-shortcuts" version))
         (sha256
          (base32 "1b0dzf84xzw444kib1744sls4l24zh3nx1cz77xbc8qphic0m0ms"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-cl-base64 sbcl-cl-base32 sbcl-flexi-streams sbcl-ironclad))
      (synopsis "Collection of common cryptography functions")
      (description
       "This is a collection of common cryptography functions for Common
Lisp.")
      (home-page "https://shinmera.com/docs/crypto-shortcuts")
      (license license:zlib))))

(define-public cl-crypto-shortcuts
  (sbcl-package->cl-source-package sbcl-crypto-shortcuts))

(define-public ecl-crypto-shortcuts
  (sbcl-package->ecl-package sbcl-crypto-shortcuts))

(define-public sbcl-css-lite
  (let ((commit "6ee4e6212ed56943d665df163d2a834b122e6273")
        (revision "0"))
    (package
      (name "sbcl-css-lite")
      (version "0.01")
      (source
        (origin
          (method git-fetch)
          (uri (git-reference
                (url "https://github.com/paddymul/css-lite")
                (commit commit)))
          (sha256
           (base32 "1lyvw7hcy09k5qs6icky23s13psqxncyc73hdyiimb66p0jx6k0d"))
          (file-name (git-file-name "cl-css-lite" commit))))
      (build-system asdf-build-system/sbcl)
      (home-page "https://github.com/paddymul/css-lite")
      (synopsis "CSS grammar for Lisp")
      (description
       "@code{cl-css-lite} is a library for generating CSS from an s-exp based
syntax.  When compiled with Parenscript loaded in the Lisp image, it
also provides the same CSS generation facilities in Parenscript-generated
JavaScript code.")
      (license license:bsd-3))))

(define-public cl-css-lite
  (sbcl-package->cl-source-package sbcl-css-lite))

(define-public ecl-css-lite
  (sbcl-package->ecl-package sbcl-css-lite))

(define-public clasp-css-lite
  (sbcl-package->clasp-package sbcl-css-lite))

(define-public sbcl-ctype
  (let ((commit "6eb84dfbf1d41f251cc0c09f6e69a2b9415fd3d6"))
    (package
      (name "sbcl-ctype")
      (version (git-version "0.0.0" "4" commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/s-expressionists/ctype")
               (commit commit)))
         (file-name (git-file-name "cl-ctype" version))
         (sha256
          (base32 "0sn81ax3imgbkgrd8yjrqknyl2sf36mrylbbdyxvpkyx9nyp80v6"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-alexandria))
      (arguments
       '(#:asd-systems '("ctype" "ctype/tfun" "ctype/ext")))
      (home-page "https://github.com/s-expressionists/ctype")
      (synopsis "Common Lisp type system implementation")
      (description
       "This system is an implementation of the Common Lisp type system;
particularly @code{cl:typep} and @code{cl:subtypep}.")
      (license license:bsd-2))))

(define-public cl-ctype
  (sbcl-package->cl-source-package sbcl-ctype))

;; FIXME: https://github.com/s-expressionists/ctype/issues/31
;; (define-public ecl-ctype
;;   (sbcl-package->ecl-package sbcl-ctype))

(define-public clasp-ctype
  (sbcl-package->clasp-package sbcl-ctype))

(define-public sbcl-curry-compose-reader-macros
  (let ((commit "beaa92dedf392726c042184bfd6149fa8d9e6ac2")
        (revision "0"))
    (package
      (name "sbcl-curry-compose-reader-macros")
      (version (git-version "1.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri
          (git-reference
           (url "https://github.com/eschulte/curry-compose-reader-macros")
           (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "0rv9bl8xrad5wfcg5zs1dazvnpmvqz6297lbn8bywsrcfnlf7h98"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-alexandria sbcl-named-readtables))
      (synopsis "Reader macros for partial application and composition")
      (description
       "This Common Lisp library provides reader macros for concise expression
of function partial application and composition.")
      (home-page "https://eschulte.github.io/curry-compose-reader-macros/")
      (license license:public-domain))))

(define-public cl-curry-compose-reader-macros
  (sbcl-package->cl-source-package sbcl-curry-compose-reader-macros))

(define-public ecl-curry-compose-reader-macros
  (sbcl-package->ecl-package sbcl-curry-compose-reader-macros))

(define-public clasp-curry-compose-reader-macros
  (sbcl-package->clasp-package sbcl-curry-compose-reader-macros))

(define-public sbcl-custom-hash-table
  (let ((commit "f26983133940f5edf826ebbc8077acc04816ddfa"))
    (package
      (name "sbcl-custom-hash-table")
      (version (git-version "0.3" "1" commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/metawilm/cl-custom-hash-table")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "1k4mvrpbqqds2fwjxp1bxmrfmr8ch4dkwhnkbw559knbqshvrlj5"))))
      (build-system asdf-build-system/sbcl)
      (arguments
       '(#:asd-systems '("cl-custom-hash-table")))
      (home-page "https://github.com/metawilm/cl-custom-hash-table")
      (synopsis "Custom hash tables for Common Lisp")
      (description "This library allows creation of hash tables with arbitrary
@code{test}/@code{hash} functions, in addition to the @code{test} functions
allowed by the standard (@code{EQ}, @code{EQL}, @code{EQUAL} and
@code{EQUALP}), even in implementations that don't support this functionality
directly.")
      (license license:expat))))

(define-public cl-custom-hash-table
  (sbcl-package->cl-source-package sbcl-custom-hash-table))

(define-public ecl-custom-hash-table
  (sbcl-package->ecl-package sbcl-custom-hash-table))

(define-public clasp-custom-hash-table
  (sbcl-package->clasp-package sbcl-custom-hash-table))

(define-public sbcl-cxml
  (let ((commit "00b22bf4c4cf11c993d5866fae284f95ab18e6bf")
        (revision "1"))
    (package
      (name "sbcl-cxml")
      (version (git-version "0.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/sharplispers/cxml")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "13kif7rf3gqdycsk9zq0d7y0g9y81krkl0z87k0p2fkbjfgrph37"))))
      (build-system asdf-build-system/sbcl)
    (inputs
     (list sbcl-closure-common sbcl-puri sbcl-trivial-gray-streams))
    (synopsis "Common Lisp XML parser")
    (description "CXML implements a namespace-aware, validating XML 1.0
parser as well as the DOM Level 2 Core interfaces.  Two parser interfaces are
offered, one SAX-like, the other similar to StAX.")
    (home-page "https://common-lisp.net/project/cxml/")
    (license license:llgpl))))

(define-public cl-cxml
  (sbcl-package->cl-source-package sbcl-cxml))

(define-public ecl-cxml
  (sbcl-package->ecl-package sbcl-cxml))

(define-public sbcl-cxml-rng
  (let ((commit "bdcfeb92798694b2935a8321e641d8803e814b7b")
        (revision "1"))
    (package
      (name "sbcl-cxml-rng")
      (version (git-version "0.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "http://www.lichteblau.com/git/cxml-rng.git")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "1rld038hmvm0whaffkszd5ks7mg44z1vfbgddal434df8sgspzql"))))
      (build-system asdf-build-system/sbcl)
    (inputs
     (list sbcl-cxml sbcl-cl-ppcre sbcl-cl-yacc sbcl-parse-number
           sbcl-cl-base64))
    (synopsis "Relax NG for Closure XML (CXML)")
    (description "An implementation of Relax NG schema validation written in
Common Lisp, including support for compact syntax, DTD Compatibility, and the
XSD type library.")
    (home-page "http://www.lichteblau.com/cxml-rng/")
    (license license:bsd-2))))

(define-public cl-cxml-rng
  (sbcl-package->cl-source-package sbcl-cxml-rng))

;; FIXME: Fails on ECL with
;; In function STRUCTURE-SET, the value of the first argument is
;;   #<empty  0x7fffeb0fd440>
;; which is not of the expected type %TYPED-PATTERN.
;; (define-public ecl-cxml-rng
;;   (sbcl-package->ecl-package sbcl-cxml-rng))

(define-public sbcl-daemon
  (let ((commit "d5652f4332c3cee21e9bf83b9237129605004597")
        (revision "1"))
    (package
      (name "sbcl-daemon")
      (version (git-version "0.0.4" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/snmsts/daemon")
               (commit commit)))
         (file-name (git-file-name "daemon" version))
         (sha256
          (base32 "1kdxfnhh9fz34j8qs7pn7mwjz3v33q4v9nh0hqkyzraq5xs2j3f4"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-trivial-features))
      (home-page "https://github.com/snmsts/daemon")
      (synopsis "Daemonize Common Lisp processes")
      (description
       "DAEMON provides the functionality of daemonizing Common Lisp processes
on UNIX like platforms.")
      (license license:expat))))

(define-public cl-daemon
  (sbcl-package->cl-source-package sbcl-daemon))

(define-public ecl-daemon
  (sbcl-package->ecl-package sbcl-daemon))

(define-public sbcl-damn-fast-priority-queue
  (let ((commit "f4c03741d05c757aed245b41a5c3f8c7096cc1d2")
        (revision "0"))
    (package
     (name "sbcl-damn-fast-priority-queue")
     (version (git-version "0.0.2" revision commit))
     (source
      (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/phoe/damn-fast-priority-queue")
             (commit commit)))
       (file-name (git-file-name "damn-fast-priority-queue" version))
       (sha256
        (base32 "0ch4yma51r2lnsjpr45mxga7sf03l3c76l6ijffm1rq2g9ywaksa"))))
     (build-system asdf-build-system/sbcl)
     (inputs
      (list sbcl-alexandria))
     (arguments
      `(#:asd-systems '("damn-fast-priority-queue"
                        "damn-fast-stable-priority-queue")))
     (synopsis "Fast priority queue")
     (description
      "A heap-based priority queue whose first and foremost priority is speed.")
     (home-page "https://github.com/phoe/damn-fast-priority-queue")
     (license license:expat))))

(define-public cl-damn-fast-priority-queue
  (sbcl-package->cl-source-package sbcl-damn-fast-priority-queue))

(define-public ecl-damn-fast-priority-queue
  (sbcl-package->ecl-package sbcl-damn-fast-priority-queue))

(define-public clasp-damn-fast-priority-queue
  (sbcl-package->clasp-package sbcl-damn-fast-priority-queue))

(define-public sbcl-data-format-validation
  (let ((commit "95d44766e829582598f9dcdc5c23719c462d5bfb")
        (revision "1"))
    (package
      (name "sbcl-data-format-validation")
      (version (git-version "0.2.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri
          (git-reference
           (url "https://github.com/willijar/cl-data-format-validation/")
           (commit commit)))
         (file-name (git-file-name "data-format-validation" version))
         (sha256
          (base32
           "0zmk47xmicyqvp1impn8kgh5373ysmx3gfpqcvbi9r31qsir2nqa"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-cl-ppcre))
      (synopsis "Validation and conversion between user and internal data")
      (description
       "@code{data-format-validation} is a library for Common Lisp providing a
consistent regular interface for converting (and validating) external data (in
the form of strings usually) into internal data types and for formatting
internal data back into external presentable strings, all according to a
conversion or type specification.")
      (home-page "http://www.jarw.org.uk/lisp/cl-data-format-validation.html")
      (license license:gpl3))))

(define-public sbcl-data-frame
  (let ((commit "6f02e58312654ddf19d686f234dcf699fc4cd0f5")
        (revision "0"))
    (package
      (name "sbcl-data-frame")
      (version (git-version "1.1.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/Lisp-Stat/data-frame")
               (commit commit)))
         (file-name (git-file-name "cl-data-frame" version))
         (sha256
          (base32 "0bs1jh66bml25bj1lxdzz8cjhj3g060yyd5ggqsnsr4l2j0zyszv"))))
      (build-system asdf-build-system/sbcl)
      (native-inputs (list sbcl-clunit2))
      (inputs
       (list sbcl-alexandria
             sbcl-alexandria-plus
             sbcl-anaphora
             sbcl-array-operations
             sbcl-duologue
             sbcl-let-plus
             sbcl-numerical-utilities
             sbcl-select
             sbcl-serapeum
             sbcl-statistics))
      (home-page "https://lisp-stat.dev/docs/manuals/data-frame/")
      (synopsis "Data frames for Common Lisp")
      (description "This package provides data frames for Common Lisp, a
two-dimensional array-like structure in which each column contains values
of one variable and each row contains one set of values from each column.")
      (license license:ms-pl))))

(define-public cl-data-frame
  (sbcl-package->cl-source-package sbcl-data-frame))

;; The data-frame system depends on the sb-cltl2 system, which is only
;; available with SBCL.
;; (define-public ecl-data-frame
;;   (sbcl-package->ecl-package sbcl-data-frame))

(define-public sbcl-data-lens
  (let ((commit "801bc1e0331f19fdc38be314c86ccac9362fde78")
        (revision "0"))
    (package
     (name "sbcl-data-lens")
     (version (git-version "0.0.0" revision commit))
     (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/fiddlerwoaroof/data-lens")
               (commit commit)))
         (file-name (git-file-name "cl-data-lens" version))
         (sha256
          (base32 "1w4rvhcnss037q0bb1j70kdlhfh9085hy95d9q56sk519alhzhrp"))))
     (build-system asdf-build-system/sbcl)
     (native-inputs
      (list sbcl-fiveam))
     (inputs
       (list sbcl-cl-ppcre
             sbcl-alexandria
             sbcl-serapeum))
     (synopsis "Functional utilities for Common Lisp")
     (description
      "The @code{cl-data-lens} library provides a language for expressing data
manipulations as the composition of more primitive operations.")
     (home-page "https://fiddlerwoaroof.github.io/data-lens/")
     (license license:asl2.0))))

(define-public cl-data-lens
  (sbcl-package->cl-source-package sbcl-data-lens))

(define-public ecl-data-lens
  (sbcl-package->ecl-package sbcl-data-lens))

(define-public sbcl-data-sift
  (let ((commit "fd617d8200cdcc1b87ecf45ab59bb38e8b16ef7e")
        (revision "1"))
    (package
      (name "sbcl-data-sift")
      (version (git-version "0.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/archimag/data-sift")
               (commit commit)))
         (file-name (git-file-name "cl-data-sift" version))
         (sha256
          (base32 "1v7gf0x4ibjzp0c56n9m77hxdgwcm9356zlk5n4l3fx4i0hj6146"))))
      (build-system asdf-build-system/sbcl)
      (arguments
       ;; All test cases test a function that has been removed.
       `(#:tests? #f))
      (inputs
       `(("alexandria" ,sbcl-alexandria)
         ("cl-ppcre" ,sbcl-cl-ppcre)
         ("parse-number" ,sbcl-parse-number)
         ("puri" ,sbcl-puri)))
      (native-inputs
       (list sbcl-lift))
      (home-page "https://github.com/archimag/data-sift")
      (synopsis
       "Common Lisp library for validation and transformation of string data")
      (description
       "@code{DATA-SIFT} is a Common Lisp data validation and transformation
library inspired by @code{cl-data-format-validation} and WTForms validators.")
      (license license:llgpl))))

(define-public cl-data-sift
  (sbcl-package->cl-source-package sbcl-data-sift))

(define-public ecl-data-sift
  (sbcl-package->ecl-package sbcl-data-sift))

(define-public sbcl-datafly
  (let ((commit "adece27fcbc4b5ea39ad1a105048b6b7166e3b0d")
        (revision "1"))
    (package
      (name "sbcl-datafly")
      (version (git-version "0.1" revision commit))
      (home-page "https://github.com/fukamachi/datafly")
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url home-page)
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "16b78kzmglp2a4nxlxxl7rpf5zaibsgagn0p3c56fsxvx0c4hszv"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       `(("alexandria" ,sbcl-alexandria)
         ("iterate" ,sbcl-iterate)
         ("optima" ,sbcl-optima)
         ("trivial-types" ,sbcl-trivial-types)
         ("closer-mop" ,sbcl-closer-mop)
         ("cl-syntax" ,sbcl-cl-syntax)
         ("sxql" ,sbcl-sxql)
         ("dbi" ,sbcl-dbi)
         ("babel" ,sbcl-babel)
         ("local-time" ,sbcl-local-time)
         ("function-cache" ,sbcl-function-cache)
         ("jonathan" ,sbcl-jonathan)
         ("kebab" ,sbcl-kebab)
         ("log4cl" ,sbcl-log4cl)))
      (native-inputs
       (list sbcl-prove))
      (arguments
       ;; TODO: Tests fail with
       ;; While evaluating the form starting at line 22, column 0
       ;;   of #P"/tmp/guix-build-sbcl-datafly-0.1-1.adece27.drv-0/source/t/datafly.lisp":
       ;; Unhandled SQLITE:SQLITE-ERROR in thread #<SB-THREAD:THREAD "main thread" RUNNING
       ;; {10009F8083}>:
       ;;   Error when binding parameter 1 to value NIL.
       ;; Code RANGE: column index out of range.
       `(#:tests? #f))
      (synopsis "Lightweight database library for Common Lisp")
      (description "Datafly is a lightweight database library for Common Lisp.")
      (license license:bsd-3))))

(define-public cl-datafly
  (sbcl-package->cl-source-package sbcl-datafly))

(define-public ecl-datafly
  (sbcl-package->ecl-package sbcl-datafly))

(define-public sbcl-db3
  (let ((commit "38e5ad35f025769fb7f8dcdc6e56df3e8efd8e6d")
        (revision "1"))
    (package
      (name "sbcl-db3")
      (version (git-version "0.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/dimitri/cl-db3")
               (commit commit)))
         (file-name (git-file-name "cl-db3" version))
         (sha256
          (base32 "1i7j0mlri6kbklcx1lsm464s8kmyhhij5c4xh4aybrw8m4ixn1s5"))))
      (build-system asdf-build-system/sbcl)
      (home-page "https://github.com/dimitri/cl-db3")
      (synopsis "Common Lisp library to read dBase III database files")
      (description
       "This is a Common Lisp library for processing data found in dBase III
database files (dbf and db3 files).")
      (license license:public-domain))))

(define-public cl-db3
  (sbcl-package->cl-source-package sbcl-db3))

(define-public ecl-db3
  (sbcl-package->ecl-package sbcl-db3))

(define-public sbcl-dbi
  (let ((commit "be4df4f236391f4e4150a1fe77f8acc92b9f3996")
        (revision "3"))
    (package
      (name "sbcl-dbi")
      (version (git-version "0.11.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/fukamachi/cl-dbi")
               (commit commit)))
         (file-name (git-file-name "cl-dbi" version))
         (sha256
          (base32 "0n3lh0rng5gbbb9aqcrszvc99f80j5zk1hdrcvz20qg6c31hhjl6"))))
      (build-system asdf-build-system/sbcl)
      (native-inputs
       `(("alexandria" ,sbcl-alexandria)
         ("rove" ,sbcl-rove)
         ("trivial-types" ,sbcl-trivial-types)))
      (inputs
       `(("bordeaux-threads" ,sbcl-bordeaux-threads)
         ("cl-mysql" ,sbcl-cl-mysql)
         ("cl-sqlite" ,sbcl-cl-sqlite)
         ("closer-mop" ,sbcl-closer-mop)
         ("postmodern" ,sbcl-postmodern)
         ("split-sequence" ,sbcl-split-sequence)
         ("trivial-garbage" ,sbcl-trivial-garbage)))
      (arguments
       `(#:asd-systems '("dbi"
                         "dbd-mysql"
                         "dbd-postgres"
                         "dbd-sqlite3")))
      (synopsis "Database independent interface for Common Lisp")
      (description
       "@code{dbi} is a Common Lisp library providing a database independent
interface for MySQL, PostgreSQL and SQLite.")
      (home-page "https://github.com/fukamachi/cl-dbi")
      (license license:llgpl))))

(define-public cl-dbi
  (sbcl-package->cl-source-package sbcl-dbi))

(define-public ecl-dbi
  (sbcl-package->ecl-package sbcl-dbi))

(define-public sbcl-dbus
  (let ((commit "8bba6a0942232e9d7fa915b33bbe32dfedc5abb9")
        (revision "2"))
    (package
      (name "sbcl-dbus")
      (version (git-version "20231105" revision commit))
      (home-page "https://github.com/death/dbus")
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url home-page)
               (commit commit)))
         (file-name (git-file-name "cl-dbus" version))
         (sha256
          (base32
           "1y880074m9g0swxrzpbplmkdxc6r62gzyigglf4x2i0zyss3gf65"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-alexandria
             sbcl-trivial-garbage
             sbcl-babel
             sbcl-iolib
             sbcl-ieee-floats
             sbcl-flexi-streams
             sbcl-cl-xmlspam
             sbcl-ironclad))
      (synopsis "D-Bus client library for Common Lisp")
      (description "This is a Common Lisp library that publishes D-Bus
objects as well as send and notify other objects connected to a bus.")
      (license license:bsd-2))))

(define-public cl-dbus
  (sbcl-package->cl-source-package sbcl-dbus))

(define-public ecl-dbus
  (sbcl-package->ecl-package sbcl-dbus))

(define-public sbcl-decimals
  (package
    (name "sbcl-decimals")
    (version "2021")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/tlikonen/cl-decimals")
             (commit version)))
       (file-name (git-file-name "cl-decimals" version))
       (sha256
        (base32 "0wn5hq1pwd3wpjqqhpjzarcdk1q6416g8y447iaf55j5nbhlmbn6"))))
    (build-system asdf-build-system/sbcl)
    (home-page "https://github.com/tlikonen/cl-decimals")
    (synopsis "Decimal number parser and formatting package for Common Lisp")
    (description "This Common Lisp package offers functions for parsing and
formatting decimal numbers.  The package's main interface are the functions
@code{parse-decimal-number} and @code{format-decimal-number}.  The former is
for parsing strings for decimal numbers and the latter for pretty-printing
them as strings.")
    (license license:cc0)))

(define-public cl-decimals
  (sbcl-package->cl-source-package sbcl-decimals))

(define-public ecl-decimals
  (sbcl-package->ecl-package sbcl-decimals))

(define-public sbcl-deeds
  (let ((revision "2")
        (commit "c63502b9ca3bd7946411686ac98b040c0c6b3e1c"))
    (package
      (name "sbcl-deeds")
      (version (git-version "1.1.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://codeberg.org/shinmera/deeds")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "1kx5x783cxw5whfwl1akwmzybh6dbrrjmygqmigirqcwdmxk5h8c"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-bordeaux-threads sbcl-closer-mop sbcl-form-fiddle
             sbcl-lambda-fiddle))
      (home-page "https://shinmera.com/docs/deeds")
      (synopsis "Extensible Event Delivery System")
      (description
       "@code{deeds} allows for efficient event delivery to multiple handlers
with a complex event filtering system.")
      (license license:zlib))))

(define-public cl-deeds
  (sbcl-package->cl-source-package sbcl-deeds))

(define-public ecl-deeds
  (sbcl-package->ecl-package sbcl-deeds))

(define-public sbcl-definitions
  (let ((commit "869796051d97bf67779f192733d52714929b48f1")
        (revision "2"))
    (package
      (name "sbcl-definitions")
      (version (git-version "1.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://codeberg.org/shinmera/definitions")
               (commit commit)))
         (file-name (git-file-name "cl-definitions" version))
         (sha256
          (base32 "0vd32rj87f8icqglpkylgr0bs2m4qjsii3wd5i5ixiy5dz3918md"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-documentation-utils))
      (home-page "https://shinmera.com/docs/definitions")
      (synopsis "General definitions reflection library")
      (description
       "This system implements a general definitions introspection library.
It gives you the ability to retrieve definitions or bindings associated with
designators such as symbols, packages, and names in general.  For instance, it
allows you to retrieve all function, type, variable, method, etc. definitions
of a symbol.")
      (license license:zlib))))

(define-public cl-definitions
  (sbcl-package->cl-source-package sbcl-definitions))

(define-public ecl-definitions
  (sbcl-package->ecl-package sbcl-definitions))

(define-public clasp-definitions
  (sbcl-package->clasp-package sbcl-definitions))

(define-public sbcl-definitions-systems
  (package
    (name "sbcl-definitions-systems")
    (version "2.0.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/Hexstream/definitions-systems")
             (commit (string-append "v" version))))
       (file-name (git-file-name "cl-definitions-systems" version))
       (sha256
        (base32 "009392mj0qdq4jy0dw5r41schnygwj286759yvyg7xja30a0psfq"))))
    (build-system asdf-build-system/sbcl)
    (native-inputs
     (list sbcl-parachute))
    (inputs
     (list sbcl-canonicalized-initargs
           sbcl-enhanced-defclass
           sbcl-enhanced-find-class
           sbcl-shared-preferences))
    (home-page "https://www.hexstreamsoft.com/libraries/definitions-systems/")
    (synopsis "Unified extensible way of processing named definitions")
    (description
     "@code{definitions-systems} provides a simple unified extensible way of
processing named definitions.")
    (license license:unlicense)))

(define-public cl-definitions-systems
  (sbcl-package->cl-source-package sbcl-definitions-systems))

(define-public ecl-definitions-systems
  (sbcl-package->ecl-package sbcl-definitions-systems))

(define-public sbcl-deflate
  (package
    (name "sbcl-deflate")
    (version "1.0.3")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/pmai/Deflate")
             (commit (string-append "release-" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1jpdjnxh6cw2d8hk70r2sxn92is52s9b855irvwkdd777fdciids"))))
    (build-system asdf-build-system/sbcl)
    (home-page "https://github.com/pmai/Deflate")
    (synopsis "Native deflate decompression for Common Lisp")
    (description
     "This library is an implementation of Deflate (RFC 1951) decompression,
with optional support for ZLIB-style (RFC 1950) and gzip-style (RFC 1952)
wrappers of deflate streams.  It currently does not handle compression.")
    (license license:expat)))

(define-public cl-deflate
  (sbcl-package->cl-source-package sbcl-deflate))

(define-public ecl-deflate
  (sbcl-package->ecl-package sbcl-deflate))

(define-public clasp-deflate
  (sbcl-package->clasp-package sbcl-deflate))

(define-public sbcl-defpackage-plus
  (let ((revision "0")
        (commit "5492e27e0bdb7b75fa5177ea4388519dc7a75f11"))
    (package
      (name "sbcl-defpackage-plus")
      (version (git-version "1.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/rpav/defpackage-plus")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "0lzljvf343xb6mlh6lni2i27hpm5qd376522mk6hr2pa20vd6rdq"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-alexandria))
      (home-page "https://github.com/rpav/defpackage-plus")
      (synopsis "Extensible @code{DEFPACKAGE} variant with version support")
      (description
       "@code{DEFPACKAGE-PLUS} is an extensible @code{DEFPACKAGE} variant with
predictable cross-platform behavior and some utilities useful for versioning.")
      (license license:bsd-2))))

(define-public cl-defpackage-plus
  (sbcl-package->cl-source-package sbcl-defpackage-plus))

(define-public ecl-defpackage-plus
  (sbcl-package->ecl-package sbcl-defpackage-plus))

(define-public clasp-defpackage-plus
  (sbcl-package->clasp-package sbcl-defpackage-plus))

(define-public sbcl-defstar
  (let ((commit "132829dac9f84fa7202a0c5793aa6accb8d2662a"))
    (package
      (name "sbcl-defstar")
      (version (git-version "1.0.0" "1" commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "http://bitbucket.org/eeeickythump/defstar/")
               (commit commit)))
         (file-name (git-file-name "cl-defstar" version))
         (sha256
          (base32 "0n6m3aqvdfnsrhlhqjcy72d1i55lbkjg13ij5c7vw003p1n78wxi"))))
      (build-system asdf-build-system/sbcl)
      (home-page "http://bitbucket.org/eeeickythump/defstar/")
      (synopsis "Easy inline (return) type declarations for functions")
      (description
       "Defstar is a collection of Common Lisp macros that can be used in
place of @code{defun}, @code{defmethod}, @code{defgeneric}, @code{defvar},
@code{defparameter}, @code{flet}, @code{labels}, @code{let*} and
@code{lambda}.  Each macro has the same name as the form it replaces, with a
star added at the end, e.g. @code{defun}. (the exception is the @code{let*}
replacement, which is called @code{*let}).")
      (license license:gpl3))))

(define-public cl-defstar
  (sbcl-package->cl-source-package sbcl-defstar))

(define-public ecl-defstar
  (sbcl-package->ecl-package sbcl-defstar))

(define-public clasp-defstar
  (sbcl-package->clasp-package sbcl-defstar))

(define-public sbcl-deploy
  (let ((commit "9b20e64fe924b9e31832304d87a3a72c383dc6d8")
        (revision "2"))
    (package
      (name "sbcl-deploy")
      (version (git-version "1.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/Shinmera/deploy")
               (commit commit)))
         (file-name (git-file-name "deploy" version))
         (sha256
          (base32 "07pfkibaridihg8lbq2czwa4iqifqk24n6rx7bfnv7i49p1ppja1"))))
      (build-system asdf-build-system/sbcl)
      (native-inputs
       (list sbcl-cl-mpg123 sbcl-cl-out123))
      (inputs
       (list sbcl-cffi sbcl-documentation-utils sbcl-trivial-features))
      (home-page "https://shinmera.github.io/deploy/")
      (synopsis "Deployment tools for standalone Common Lisp application")
      (description
       "This is a system to help you easily and quickly deploy standalone
common lisp applications as binaries.  Specifically it is geared towards
applications with foreign library dependencies that run some kind of GUI.")
      (license license:artistic2.0))))

(define-public cl-deploy
  (sbcl-package->cl-source-package sbcl-deploy))

(define-public ecl-deploy
  (sbcl-package->ecl-package sbcl-deploy))

(define-public sbcl-depot
  (let ((commit "73822d9f480cbad00971b45ee80117297a67fb53")
        (revision "1"))
    (package
      (name "sbcl-depot")
      (version (git-version "1.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/Shinmera/depot/")
               (commit commit)))
         (sha256
          (base32 "1v42pirdwbxy8l8i9a2jmbpri8a62vh0r4vm25xwaak0y4gr71va"))
         (file-name (git-file-name "depot" version))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-atomics
             sbcl-babel
             sbcl-documentation-utils
             sbcl-trivial-features
             sbcl-trivial-gray-streams
             sbcl-zippy))
      ;; TODO: Some 6 tests fail, why?  See https://github.com/Shinmera/depot/issues/2.
      (arguments
       '(#:asd-systems '("depot"
                         "depot-in-memory"
                         "depot-virtual"
                         "depot-zip")))
      (synopsis "Protocol for transparent collections of files")
      (description "This is a system presenting a protocol for \"file
systems\": things that present a collection of \"files,\" which are things
that have several attributes, and a central data payload.  Most notably this
includes the OS filesystem, but can also be used to address other
filesystem-like things like archives, object stores, etc. in the same
manner.")
      (home-page "https://shinmera.github.io/depot/")
      (license license:zlib))))

(define-public cl-depot
  (sbcl-package->cl-source-package sbcl-depot))

(define-public ecl-depot
  (sbcl-package->ecl-package sbcl-depot))

(define-public sbcl-dexador
  (let ((commit "d7ac217819e9156abe10cd28ba7a2d548be03cad")
        (revision "3"))
    (package
      (name "sbcl-dexador")
      (build-system asdf-build-system/sbcl)
      (version (git-version "0.9.15" revision commit))
      (home-page "https://github.com/fukamachi/dexador")
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url home-page)
               (commit commit)))
         (file-name (git-file-name "cl-dexador" version))
         (sha256
          (base32 "19y95k821665vcy7gbxhh4rqwk7fh4brv1sgkaykncpw2l2lll5r"))))
      (inputs
       (list sbcl-alexandria
             sbcl-babel
             sbcl-bordeaux-threads
             sbcl-chipz
             sbcl-chunga
             sbcl-cl+ssl
             sbcl-cl-base64
             sbcl-cl-cookie
             sbcl-cl-ppcre
             sbcl-fast-http
             sbcl-fast-io
             sbcl-quri
             sbcl-trivial-garbage
             sbcl-trivial-gray-streams
             sbcl-trivial-mimes
             sbcl-usocket))
      ;; These native-inputs are for tests only, which are disabled.
      ;; Leave them commented since they add a lot to the closure size.
      ;; (native-inputs
      ;;  (list sbcl-clack
      ;;        sbcl-lack
      ;;        sbcl-rove))
      (arguments
       ;; TODO: Circular dependency: tests depend on clack-test which depends on dexador.
       `(#:tests? #f
         #:phases
         (modify-phases %standard-phases
           (add-after 'unpack 'fix-permissions
             (lambda _ (make-file-writable "t/data/test.gz") #t)))))
      (synopsis "Yet another HTTP client for Common Lisp")
      (description "Dexador is yet another HTTP client for Common Lisp with
neat APIs and connection-pooling.  It is meant to supersede Drakma.")
      (license license:expat))))

(define-public cl-dexador
  (package
    (inherit (sbcl-package->cl-source-package sbcl-dexador))
    (arguments
     `(#:phases
       ;; asdf-build-system/source has its own phases and does not inherit
       ;; from asdf-build-system/sbcl phases.
       (modify-phases %standard-phases/source
         ;; Already done in SBCL package.
         (delete 'reset-gzip-timestamps))))))

(define-public ecl-dexador
  (sbcl-package->ecl-package sbcl-dexador))

(define-public sbcl-dfio
  (let ((commit "5caf473acb9bc464839e87395724cbd941167915")
        (revision "0"))
    (package
      (name "sbcl-dfio")
      (version (git-version "1.0.2" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/Lisp-Stat/dfio")
               (commit commit)))
         (file-name (git-file-name "cl-dfio" version))
         (sha256
          (base32 "1p53r7773939jnap518xp4b4wfvc1kbrz9jp6yd40xq0jpf9pbqg"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-alexandria
             sbcl-anaphora
             sbcl-data-frame
             sbcl-dexador
             sbcl-fare-csv
             sbcl-let-plus
             sbcl-yason))
      (native-inputs
       (list sbcl-clunit2))
      (home-page "https://lisp-stat.dev/docs/manuals/data-frame/")
      (synopsis "Read data to and from data frames")
      (description "This package provides tools for manipulating data
in files using data frames.")
      (license license:ms-pl))))

(define-public cl-dfio
  (sbcl-package->cl-source-package sbcl-dfio))

;; This depends on ecl-data-frame, which doesn't work yet.
;; (define-public ecl-dfio
;;   (sbcl-package->ecl-package sbcl-dfio))

(define-public sbcl-diff
  (let ((commit "9c84befa598d4e07c3d223242b5b3f83cd94f301")
        (revision "1"))
    (package
      (name "sbcl-diff")
      (version (git-version "0.4" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/froydnj/diff")
               (commit commit)))
         (file-name (git-file-name "cl-diff" version))
         (sha256
          (base32 "1giafck8qfvb688kx5bn9g32rfc12jjywg8vdav36aqbd6lxf5z5"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-cl-ppcre sbcl-trivial-gray-streams))
      (home-page "https://github.com/froydnj/diff")
      (synopsis "Common Lisp library for computing differences between files")
      (description
        "DIFF is a package for computing various forms of differences between
blobs of data and then doing neat things with those differences.  Currently diff
knows how to compute three common forms of differences: \"unified\" format
diffs, \"context\" format diffs, and \"vdelta\" format binary diffs.")
      (license license:bsd-3))))

(define-public cl-diff
  (sbcl-package->cl-source-package sbcl-diff))

(define-public ecl-diff
  (sbcl-package->ecl-package sbcl-diff))

(define-public clasp-diff
  (sbcl-package->clasp-package sbcl-diff))

(define-public sbcl-dissect
  (let ((commit "a70cabcd748cf7c041196efd711e2dcca2bbbb2c"))
    (package
      (name "sbcl-dissect")
      (version (git-version "1.0.0" "2" commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/Shinmera/dissect")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "1ym1zggwrj15l7y2mcz5l2gfk68prqxhdswffd9s5014pa6zyysr"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-cl-ppcre))
      (home-page "https://shinmera.github.io/dissect/")
      (synopsis
       "Introspection library for the call stack and restarts")
      (description
       "Dissect is a small Common Lisp library for introspecting the call stack
and active restarts.")
      (license license:zlib))))

(define-public cl-dissect
  (sbcl-package->cl-source-package sbcl-dissect))

(define-public ecl-dissect
  (sbcl-package->ecl-package sbcl-dissect))

(define-public clasp-dissect
  (sbcl-package->clasp-package sbcl-dissect))

(define-public sbcl-distributions
  (let ((commit "ea72622073ee7e005dfdc621ce1e5a83b22bb39e")
        (revision "0"))
    (package
      (name "sbcl-distributions")
      (version (git-version "1.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/Lisp-Stat/distributions")
               (commit commit)))
         (file-name (git-file-name "cl-distributions" version))
         (sha256
          (base32 "1fkzigd0s0s0mvszgmv04yc8jp9gm4812445hfh6kpz6cjy5zpsk"))))
      (build-system asdf-build-system/sbcl)
      ;; https://github.com/Lisp-Stat/distributions/issues/1
      (arguments (list #:tests? #f))
      (native-inputs (list sbcl-fiveam))
      (inputs
        (list sbcl-alexandria
              sbcl-anaphora
              sbcl-array-operations
              sbcl-cephes
              sbcl-float-features
              sbcl-let-plus
              sbcl-numerical-utilities
              sbcl-special-functions))
      (home-page "https://lisp-stat.dev/docs/manuals/distributions/")
      (synopsis "Statistical distributions for Common Lisp")
      (description "The Distributions package provides a collection of
probabilistic distributions and related functions")
      (license license:ms-pl))))

(define-public cl-distributions
  (sbcl-package->cl-source-package sbcl-distributions))

(define-public ecl-distributions
  (sbcl-package->ecl-package sbcl-distributions))

(define-public sbcl-djula
  (let ((commit "6f142594e0372437e64f610b796350ad89ba0be1")
        (revision "2"))
    (package
      (name "sbcl-djula")
      (version (git-version "0.2.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/mmontone/djula")
               (commit commit)))
         (file-name (git-file-name "cl-djula" version))
         (sha256
          (base32 "0yyg61hrql1vrwllyd23vidiff28ridh0avxyvnqb89v060d1j83"))))
      (build-system asdf-build-system/sbcl)
      (native-inputs
       (list sbcl-fiveam))
      (inputs
       (list sbcl-access
             sbcl-alexandria
             sbcl-anaphora
             sbcl-babel
             sbcl-cl-locale
             sbcl-cl-ppcre
             sbcl-cl-slice
             sbcl-closer-mop
             sbcl-gettext
             sbcl-iterate
             sbcl-local-time
             sbcl-parser-combinators
             sbcl-split-sequence
             sbcl-trivial-backtrace))
      (home-page "https://mmontone.github.io/djula/djula/")
      (synopsis "Common Lisp port of the Django templating language")
      (description
       "This package provides a Common Lisp templating system based on Python
Django with a syntax similar to Python Jinja2.")
      (license license:expat))))

(define-public cl-djula
  (sbcl-package->cl-source-package sbcl-djula))

(define-public ecl-djula
  (sbcl-package->ecl-package sbcl-djula))

(define-public sbcl-dns-client
  (let ((commit "9f252e9c2bb61c57a6cd367e21ad366b0d3e87e0")
        (revision "0"))
    (package
      (name "sbcl-dns-client")
      (version (git-version "1.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/Shinmera/dns-client")
               (commit commit)))
         (file-name (git-file-name "cl-dns-client" version))
         (sha256
          (base32 "1b6g2wvydwmv1k68favjyq4gfalfxfyl5i0hyh640wdaz2rfvi4n"))))
      (build-system asdf-build-system/sbcl)
      (arguments
       ;; No tests provided.
       `(#:tests? #f))
      (inputs
       (list sbcl-documentation-utils sbcl-usocket))
      (home-page "https://shinmera.github.io/dns-client/")
      (synopsis "DNS protocol client for Common Lisp")
      (description
       "This package provides a pure-lisp implementation of a DNS client.  It can be
used to resolve hostnames, reverse-lookup IP addresses, and fetch other kinds of
DNS records.")
      (license license:zlib))))

(define-public cl-dns-client
  (sbcl-package->cl-source-package sbcl-dns-client))

(define-public ecl-dns-client
  (sbcl-package->ecl-package sbcl-dns-client))

(define-public sbcl-do-urlencode
  (let ((commit "199846441dad5dfac5478b8dee4b4e20d107af6a")
        (revision "1"))
    (package
      (name "sbcl-do-urlencode")
      (version (git-version "0.0.0" revision commit))
      (home-page "https://github.com/drdo/do-urlencode")
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url home-page)
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "0k2i3d4k9cpci235mwfm0c5a4yqfkijr716bjv7cdlpzx88lazm9"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-alexandria sbcl-babel))
      (synopsis "Percent Encoding (aka URL Encoding) Common Lisp library")
      (description "This library provides trivial percent encoding and
decoding functions for URLs.")
      (license license:isc))))

(define-public cl-do-urlencode
  (sbcl-package->cl-source-package sbcl-do-urlencode))

(define-public ecl-do-urlencode
  (sbcl-package->ecl-package sbcl-do-urlencode))

(define-public sbcl-documentation-utils
  (let ((commit "98630dd5f7e36ae057fa09da3523f42ccb5d1f55")
        (revision "0"))
    (package
      (name "sbcl-documentation-utils")
      (version (git-version "1.2.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri
          (git-reference
           (url "https://github.com/Shinmera/documentation-utils")
           (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "098qhkqskmmrh4wix34mawf7p5c87yql28r51r75yjxj577k5idq"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-trivial-indent))
      (synopsis "Few simple tools to document Common Lisp libraries")
      (description
       "This is a small library to help you with managing the Common Lisp
docstrings for your library.")
      (home-page "https://shinmera.github.io/documentation-utils/")
      (license license:zlib))))

(define-public cl-documentation-utils
  (sbcl-package->cl-source-package sbcl-documentation-utils))

(define-public ecl-documentation-utils
  (sbcl-package->ecl-package sbcl-documentation-utils))

(define-public clasp-documentation-utils
  (sbcl-package->clasp-package sbcl-documentation-utils))

(define-public sbcl-documentation-utils-extensions
  (let ((commit "f67f8a05d583174662a594b79356b201c1d9d750"))
    (package
      (name "sbcl-documentation-utils-extensions")
      (version (git-version "0.0.0" "1" commit))
      (source
       (origin
         (method git-fetch)
         (uri
          (git-reference
           (url "https://github.com/sirherrbatka/documentation-utils-extensions/")
           (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "0pn45c9rbxlnhn5nvhqz6kyv0nlirwxpg4j27niwdq80yxzsn51f"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-documentation-utils))
      (home-page "https://github.com/sirherrbatka/documentation-utils-extensions")
      (synopsis "Set of extensions for documentation-utils")
      (description
       "Use @code{rich-formatter} to format documentation with sections @code{:syntax},
@code{:arguments}, @code{:examples}, @code{:description}, @code{:returns},
@code{:side-effects}, @code{:thread-safety}, @code{:affected-by},
@code{:see-also} and @code{:notes}.  Gather unformatted input by using
@code{rich-aggregating-formatter} and @code{*DOCUMENTATION*} variable.  Find
gathered documentation with find-documentation function.  Execute code stored
in documentation with @code{execute-documentation}.  See the examples in the
@code{src/documentation.lisp} file.  See the @code{documentation-utils} system
for more information.")
      (license license:expat))))

(define-public cl-documentation-utils-extensions
  (sbcl-package->cl-source-package sbcl-documentation-utils-extensions))

(define-public ecl-documentation-utils-extensions
  (sbcl-package->ecl-package sbcl-documentation-utils-extensions))

(define-public sbcl-docs-config
  (let ((commit "9f8f253b1e1cb451c91f3ec9ab700e99461f0fe8")
        (revision "0"))
    (package
      (name "sbcl-docs-config")
      (version (git-version "0.8.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/40ants/docs-builder")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "1w1fx5b193s5zifnp22sha8s4vqa15p3kg8fwl60yv90gk4wvwwm"))))
      (build-system asdf-build-system/sbcl)
      (arguments
       (list
        ;; We only build docs-config as sbcl-40ants-doc requires this project,
        ;; and the other systems here requires sbcl-40ants-doc
        #:asd-systems ''("docs-config")))
      (inputs
       (list sbcl-file-types
             sbcl-geneva
             sbcl-log4cl
             sbcl-macro-html
             sbcl-maxpc
             sbcl-texp
             sbcl-trivial-documentation))
      (home-page "https://github.com/40ants/docs-builder")
      (synopsis "Generic documentation builder for Common Lisp projects")
      (description "Generic documentation builder for Common Lisp projects.")
      (license license:unlicense))))

(define-public ecl-docs-config
  (sbcl-package->ecl-package sbcl-docs-config))

(define-public cl-docs-config
  (sbcl-package->cl-source-package sbcl-docs-config))

(define-public sbcl-doplus
  (package
    (name "sbcl-doplus")
    (version "1.1.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/alessiostalla/doplus")
             (commit (string-append "v" version))))
       (file-name (git-file-name "cl-doplus" version))
       (sha256
        (base32 "1yvda9psw9m08d3bzdb8a2drvhrnr07a0rhza5ibk30v1dkwfw7c"))))
    (build-system asdf-build-system/sbcl)
    (native-inputs
     (list sbcl-fiveam))
    (inputs
     (list sbcl-parse-declarations sbcl-fset))
    (arguments
     '(#:asd-systems '("doplus" "doplus-fset")))
    (synopsis "Iteration macro for Common Lisp")
    (description "@code{doplus} is an iteration macro for Common Lisp.")
    (home-page "https://github.com/alessiostalla/doplus")
    (license license:gpl3+)))

(define-public cl-doplus
  (sbcl-package->cl-source-package sbcl-doplus))

(define-public ecl-doplus
  (sbcl-package->ecl-package sbcl-doplus))

(define-public sbcl-drakma
  (package
    (name "sbcl-drakma")
    (version "2.0.8")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/edicl/drakma")
             (commit (string-append "v" version))))
       (file-name (git-file-name "cl-drakma" version))
       (sha256
        (base32
         "1wf2zivfvhsh6zvd6wcwfd67bm8s8a1p2fismszc8xb819dqk9yl"))))
    (build-system asdf-build-system/sbcl)
    (inputs
     (list sbcl-puri
           sbcl-cl-base64
           sbcl-chunga
           sbcl-flexi-streams
           sbcl-cl-ppcre
           sbcl-chipz
           sbcl-usocket
           sbcl-cl+ssl))
    (native-inputs
     (list sbcl-fiveam))
    (home-page "https://edicl.github.io/drakma/")
    (synopsis "HTTP client written in Common Lisp")
    (description
     "Drakma is a full-featured HTTP client implemented in Common Lisp.  It
knows how to handle HTTP/1.1 chunking, persistent connections, re-usable
sockets, SSL, continuable uploads, file uploads, cookies, and more.")
    (license license:bsd-2)))

(define-public cl-drakma
  (sbcl-package->cl-source-package sbcl-drakma))

(define-public ecl-drakma
  (sbcl-package->ecl-package sbcl-drakma))

(define-public sbcl-draw-cons-tree
  (let ((commit "04334f5885a85cd7127db8dda3f6d6686a0438b1")
        (revision "0"))
    (package
      (name "sbcl-draw-cons-tree")
      (version (git-version "1.0" revision commit))
      ;; https://github.com/quicklisp/quicklisp-projects/issues/2149
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/phoe/draw-cons-tree")
               (commit commit)))
         (file-name (git-file-name "cl-draw-cons-tree" version))
         (sha256
          (base32 "1523bdkq8a5qn0qp9q7r16w47y6jb0hkfj7hbjfj6mg3xv001s3x"))))
      (build-system asdf-build-system/sbcl)
      (native-inputs
       (list sbcl-fiveam sbcl-split-sequence))
      (inputs
       (list sbcl-alexandria))
      (synopsis "Draw an ascii picture of a cons tree")
      (description
       "@code{cl-draw-cons-tree} draws a cons tree in ASCII-art style.")
      (home-page "https://github.com/phoe/draw-cons-tree/")
      (license license:unlicense))))

(define-public cl-draw-cons-tree
  (sbcl-package->cl-source-package sbcl-draw-cons-tree))

(define-public ecl-draw-cons-tree
  (sbcl-package->ecl-package sbcl-draw-cons-tree))

(define-public sbcl-dufy
  (package
    (name "sbcl-dufy")
    (version "0.4.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/privet-kitty/dufy")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "15vrp1kayhjb5c1vc9x8wlm8rimk73vpa7yc101cf0gsg1fjazl6"))))
    (build-system asdf-build-system/sbcl)
    (inputs
     (list sbcl-alexandria sbcl-cl-ppcre))
    (native-inputs
     (list sbcl-fiveam sbcl-cl-csv sbcl-parse-float sbcl-lispbuilder-sdl
           sbcl-lparallel))
    (home-page "https://github.com/privet-kitty/dufy")
    (synopsis "Color library for Common Lisp")
    (description
     "Dufy is a library for exact color manipulation and conversion in various
color spaces, which supports many color models.")
    (license license:expat)))

(define-public cl-dufy
  (sbcl-package->cl-source-package sbcl-dufy))

(define-public ecl-dufy
  (sbcl-package->ecl-package sbcl-dufy))

(define-public sbcl-duologue
  (let ((commit "ea1ada244a81da65f85b548823c9a6d7c9c145e1")
        (revision "0"))
    (package
      (name "sbcl-duologue")
      (version (git-version "0.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/mmontone/duologue")
               (commit commit)))
         (file-name (git-file-name "cl-duologue" version))
         (sha256
          (base32 "1yg7f27im9h0m6jihcay1p7alfhzm9hafwm5dw5hsyacy8f2cwk2"))))
      (build-system asdf-build-system/sbcl)
      (native-inputs (list sbcl-stefil))
      (inputs
        (list sbcl-alexandria
              sbcl-anaphora
              sbcl-chronicity
              sbcl-cl-ansi-text
              sbcl-cl-fad
              sbcl-clavier
              sbcl-drakma))
      (home-page "https://github.com/mmontone/duologue/")
      (synopsis "High level user interaction library")
      (description
       "Duologue is high-level interaction library for Common Lisp.  It features
coloured printing via @code{cl-ansi-text} and readline completion.")
      (license (list license:expat
                     ;; https://github.com/mmontone/duologue/issues/9
                     license:gpl3+)))))

(define-public cl-duologue
  (sbcl-package->cl-source-package sbcl-duologue))

(define-public ecl-duologue
  (sbcl-package->ecl-package sbcl-duologue))

(define-public sbcl-dynamic-classes
  (let ((commit "ebd7405603f67b16e8f2bc08ce8e2bcfcf439501")
        (revision "0"))
    (package
      (name "sbcl-dynamic-classes")
      (version (git-version "1.0.2" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/hraban/dynamic-classes")
               (commit commit)))
         (file-name (git-file-name "dynamic-classes" version))
         (sha256
          (base32 "1k9lkchwyi2xhygp2v8ifq3kg1l3wcnihhzgr06jrivjxgdqpc1a"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       `(("metatilities-base" ,sbcl-metatilities-base)))
      (arguments
       ;; NOTE: (Sharlatan-20210106222900+0000) Circular dependencies and failing
       ;; test suites. lift-standard.config contains references to deprecated
       ;; functionality.
       ;; See https://github.com/hraban/dynamic-classes/issues/2
       `(#:tests? #f))
      (home-page "https://common-lisp.net/project/dynamic-classes/")
      (synopsis "Dynamic class definition for Common Lisp")
      (description "Dynamic-Classes helps to ease the prototyping process by
bringing dynamism to class definition.")
      (license license:expat))))

(define-public cl-dynamic-classes
  (sbcl-package->cl-source-package sbcl-dynamic-classes))

(define-public ecl-dynamic-classes
  (sbcl-package->ecl-package sbcl-dynamic-classes))

(define-public sbcl-dynamic-mixins
  (let ((commit "7cc09bee7d68527f37406671fabe910e8235b746"))
    (package
      (name "sbcl-dynamic-mixins")
      (version (git-version "0.0" "1" commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/rpav/dynamic-mixins")
               (commit commit)))
         (file-name (git-file-name "cl-dynamic-mixins" version))
         (sha256
          (base32 "00g3s509ysh2jp1qwsgb5bwl6qvhzcljwjz3z4mspbcak51484zj"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-alexandria
             sbcl-closer-mop))
      (home-page "https://github.com/rpav/dynamic-mixins")
      (synopsis "Simple, dynamic class combination for CLOS")
      (description
       "Dynamic-mixins is for simple, dynamic class combination; it allows
objects to be mixed and updated without manually defining many permutations.")
      (license license:bsd-2))))

(define-public cl-dynamic-mixins
  (sbcl-package->cl-source-package sbcl-dynamic-mixins))

(define-public ecl-dynamic-mixins
  (sbcl-package->ecl-package sbcl-dynamic-mixins))

(define-public sbcl-eager-future2
  (let ((commit "54df8effd9d9eccac917509590286b5ac5f9cb30"))
    (package
      (name "sbcl-eager-future2")
      (version (git-version "0.0.0" "1" commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://gitlab.common-lisp.net/vsedach/eager-future2.git")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "1qs1bv3m0ki8l5czhsflxcryh22r9d9g9a3a3b0cr0pl954q5rld"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-bordeaux-threads sbcl-trivial-garbage))
      (synopsis "Futures promises synchronization mechanism for Common Lisp")
      (description
       "Eager Future2 is a Common Lisp library that provides composable
concurrency primitives that unify parallel and lazy evaluation, are integrated
with the Common Lisp condition system, and have automatic resource
management.")
      (home-page "https://gitlab.common-lisp.net/vsedach/eager-future2")
      (license license:lgpl3+))))

(define-public cl-eager-future2
  (sbcl-package->cl-source-package sbcl-eager-future2))

(define-public ecl-eager-future2
  (sbcl-package->ecl-package sbcl-eager-future2))

(define-public sbcl-easy-routes
  (let ((commit "7832f8bf3d07825b5eb967a2ef04da7c40c18248")
        (revision "0"))
    (package
      (name "sbcl-easy-routes")
      (version (git-version "0.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/mmontone/easy-routes")
               (commit commit)))
         (file-name (git-file-name "cl-easy-routes" version))
         (sha256
          (base32 "1banw54kz2llzb9h5sm47ckfc9l348m7qncm0npsy0w837rxkyzx"))))
      (build-system asdf-build-system/sbcl)
      (arguments
       '(#:asd-systems '("easy-routes"
                         "easy-routes+djula"
                         "easy-routes+errors")))
      (native-inputs
       (list sbcl-stefil))
      (inputs
        (list sbcl-djula
              sbcl-hunchentoot
              sbcl-hunchentoot-errors
              sbcl-routes))
      (home-page "https://github.com/mmontone/easy-routes/")
      (synopsis "Routes handling utility on top of Hunchentoot")
      (description
       "EASY-ROUTES is yet another routes handling system on top of
Hunchentoot.  It's just glue code for Restas routing subsystem (CL-ROUTES).

It supports:
@itemize
@item dispatch based on HTTP method
@item arguments extraction from the url path
@item decorators
@item URL generation from route names
@end itemize

This package provides EASY-ROUTES, EASY-ROUTES+DJULA and EASY-ROUTES+ERRORS
systems.")
      (license license:expat))))

(define-public cl-easy-routes
  (sbcl-package->cl-source-package sbcl-easy-routes))

(define-public ecl-easy-routes
  (sbcl-package->ecl-package sbcl-easy-routes))

(define-public sbcl-eazy-gnuplot
  (let ((commit "2eb900fe2557e6c066a9851c166e572c25bc0996")
        (revision "0"))
    (package
      (name "sbcl-eazy-gnuplot")
      (version (git-version "0.2.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/guicho271828/eazy-gnuplot")
               (commit commit)))
         (file-name (git-file-name "cl-eazy-gnuplot" version))
         (sha256
          (base32 "0mpkx1z52riahydzvqv7kk15p0pv2k7k5a7j65fg571kcxmssx8s"))
         (patches (search-patches "sbcl-eazy-gnuplot-skip-path-check.patch"))))
      (build-system asdf-build-system/sbcl)
      (native-inputs
       (list sbcl-fiveam))
      (inputs
       (list gnuplot
             sbcl-alexandria
             sbcl-iterate
             sbcl-trivia))
      (arguments
       `(#:phases
         (modify-phases %standard-phases
           (add-after 'unpack 'fix-paths
             (lambda _
               (substitute* "src/package.lisp"
                 (("\"gnuplot\"")
                  (string-append "\"" (which "gnuplot") "\""))))))))
      (home-page "https://github.com/guicho271828/eazy-gnuplot")
      (synopsis "Common Lisp interface to gnuplot")
      (description
       "Eazy-Gnuplot is a Common Lisp interface to gnuplot which eschews CFFI,
CLOS and structures.  It communicates with @command{gnuplot} via
@code{*standard-output*}, and users can plot data by printing to that
stream.")
      (license license:llgpl))))

(define-public cl-eazy-gnuplot
  (sbcl-package->cl-source-package sbcl-eazy-gnuplot))

(define-public ecl-eazy-gnuplot
  (sbcl-package->ecl-package sbcl-eazy-gnuplot))

(define-public sbcl-eclector
  (let ((commit "28d29445556a0c03178e3daff7a2d8b378fa4340")
        (revision "0"))
    (package
      (name "sbcl-eclector")
      (version (git-version "0.10.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/s-expressionists/Eclector")
               (commit commit)))
         (file-name (git-file-name "cl-eclector" version))
         (sha256
          (base32 "06qhll5k0hq652gdzvvhcv4amqg9z7qillnn3z9cm8z9sv1n912v"))))
      (build-system asdf-build-system/sbcl)
      (native-inputs
       (list sbcl-fiveam))
      (inputs
       (list sbcl-acclimation
             sbcl-alexandria
             sbcl-closer-mop
             sbcl-concrete-syntax-tree))
      (arguments
       '(#:asd-systems '("eclector"
                         "eclector-concrete-syntax-tree")))
      (home-page "https://s-expressionists.github.io/Eclector/")
      (synopsis "Highly customizable, portable Common Lisp reader")
      (description
       "Eclector is a portable Common Lisp reader that is highly customizable,
can recover from errors and can return concrete syntax trees.

In contrast to many other reader implementations, eclector can recover from
most errors in the input supplied to it and continue reading.  This capability
is realized as a restart.

It can also produce instances of the concrete syntax tree classes provided by
the concrete syntax tree library.")
      (license license:bsd-2))))

(define-public cl-eclector
  (sbcl-package->cl-source-package sbcl-eclector))

(define-public ecl-eclector
  (sbcl-package->ecl-package sbcl-eclector))

(define-public sbcl-enchant
  (let ((commit "6af162a7bf10541cbcfcfa6513894900329713fa"))
    (package
      (name "sbcl-enchant")
      (version (git-version "0.0.0" "1" commit))
      (home-page "https://github.com/tlikonen/cl-enchant")
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url home-page)
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "19yh5ihirzi1d8xqy1cjqipzd6ly3245cfxa5s9xx496rryz0s01"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       `(("enchant" ,enchant)
         ("cffi" ,sbcl-cffi)))
      (arguments
       `(#:phases
         (modify-phases %standard-phases
           (add-after 'unpack 'fix-paths
             (lambda* (#:key inputs #:allow-other-keys)
               (substitute* "load-enchant.lisp"
                 (("libenchant")
                  (string-append
                   (assoc-ref inputs "enchant") "/lib/libenchant-2"))))))))
      (synopsis "Common Lisp interface for the Enchant spell-checker library")
      (description
       "Enchant is a Common Lisp interface for the Enchant spell-checker
library.  The Enchant library is a generic spell-checker library which uses
other spell-checkers transparently as back-end.  The library supports the
multiple checkers, including Aspell and Hunspell.")
      (license license:public-domain))))

(define-public cl-enchant
  (sbcl-package->cl-source-package sbcl-enchant))

(define-public ecl-enchant
  (sbcl-package->ecl-package sbcl-enchant))

(define-public sbcl-enhanced-boolean
  (package
    (name "sbcl-enhanced-boolean")
    (version "1.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/Hexstream/enhanced-boolean")
             (commit (string-append "v" version))))
       (file-name (git-file-name "cl-enhanced-boolean" version))
       (sha256
        (base32 "17l18lz07fk2kg835vs6c3189d230n1rm9vghk3ls4i356gbq0gy"))))
    (build-system asdf-build-system/sbcl)
    (native-inputs
     (list sbcl-parachute))
    (home-page "https://www.hexstreamsoft.com/libraries/enhanced-boolean/")
    (synopsis "Convert generalized booleans to booleans")
    (description
     "This package provides a canonical way of converting generalized booleans
to booleans.")
    (license license:unlicense)))

(define-public cl-enhanced-boolean
  (sbcl-package->cl-source-package sbcl-enhanced-boolean))

(define-public ecl-enhanced-boolean
  (sbcl-package->ecl-package sbcl-enhanced-boolean))

(define-public clasp-enhanced-boolean
  (sbcl-package->clasp-package sbcl-enhanced-boolean))

(define-public sbcl-enhanced-defclass
  (package
    (name "sbcl-enhanced-defclass")
    (version "2.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/Hexstream/enhanced-defclass")
             (commit (string-append "v" version))))
       (file-name (git-file-name "cl-enhanced-defclass" version))
       (sha256
        (base32 "142s5c3pl3x7xdawzsj8pdxiqp4wh6fcajf4la5msvnxgf66d8wg"))))
    (build-system asdf-build-system/sbcl)
    (native-inputs
     (list sbcl-parachute))
    (inputs
     (list sbcl-cesdi
           sbcl-closer-mop
           sbcl-compatible-metaclasses
           sbcl-enhanced-eval-when
           sbcl-object-class
           sbcl-shared-preferences
           sbcl-simple-guess))
    (home-page "https://www.hexstreamsoft.com/libraries/enhanced-defclass/")
    (synopsis "Extensible implementation of defclass")
    (description
     "This package provides an extensible implementation of defclass that can
accurately control the expansion according to the metaclass and automatically
detect the suitable metaclass by analyzing the @code{defclass} form.")
    (license license:unlicense)))

(define-public cl-enhanced-defclass
  (sbcl-package->cl-source-package sbcl-enhanced-defclass))

(define-public ecl-enhanced-defclass
  (sbcl-package->ecl-package sbcl-enhanced-defclass))

(define-public clasp-enhanced-defclass
  (sbcl-package->clasp-package sbcl-enhanced-defclass))

(define-public sbcl-enhanced-eval-when
  (package
    (name "sbcl-enhanced-eval-when")
    (version "1.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/Hexstream/enhanced-eval-when")
             (commit (string-append "v" version))))
          (file-name (git-file-name "cl-enhanced-eval-when" version))
          (sha256
           (base32 "1ws1v297plcbqmcvckg7vqzzgnrwfyx5kd7281r1wrhc26998rx2"))))
    (build-system asdf-build-system/sbcl)
    ;; https://github.com/Hexstream/enhanced-eval-when/issues/1
    (arguments
     (list #:tests? #f)) ; There are no tests in version 1.0.
    (home-page "https://www.hexstreamsoft.com/libraries/enhanced-eval-when/")
    (synopsis "Shortcuts for EVAL-WHEN")
    (description
     "This package provides an enhanced @code{EVAL-WHEN} macro that supports a
shorthand for @code{(eval-when (:compile-toplevel :load-toplevel :execute) ...)},
addressing concerns about verbosity.")
    (license license:unlicense)))

(define-public cl-enhanced-eval-when
  (sbcl-package->cl-source-package sbcl-enhanced-eval-when))

(define-public ecl-enhanced-eval-when
  (sbcl-package->ecl-package sbcl-enhanced-eval-when))

(define-public sbcl-enhanced-find-class
  (package
    (name "sbcl-enhanced-find-class")
    (version "1.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/Hexstream/enhanced-find-class")
             (commit (string-append "v" version))))
       (file-name (git-file-name "cl-enhanced-find-class" version))
       (sha256
        (base32 "1pf1mxb238zrmvgm9s0456s1x0m317ls23ls1d987riw69y3w9vx"))))
    (build-system asdf-build-system/sbcl)
    (native-inputs
     (list sbcl-parachute))
    (inputs
     (list sbcl-closer-mop))
    (home-page "https://www.hexstreamsoft.com/libraries/enhanced-find-class/")
    (synopsis "Canonical way of converting class designators to classes")
    (description
     "This package provides a canonical way of converting class designators
to classes.")
    (license license:unlicense)))

(define-public cl-enhanced-find-class
  (sbcl-package->cl-source-package sbcl-enhanced-find-class))

(define-public ecl-enhanced-find-class
  (sbcl-package->ecl-package sbcl-enhanced-find-class))

(define-public clasp-enhanced-find-class
  (sbcl-package->clasp-package sbcl-enhanced-find-class))

(define-public sbcl-enhanced-typep
  (package
    (name "sbcl-enhanced-typep")
    (version "1.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/Hexstream/enhanced-typep")
             (commit (string-append "v" version))))
       (file-name (git-file-name "cl-enhanced-typep" version))
       (sha256
        (base32 "0b22gddkbxnhmi71wa2h51495737lrvsqxnri7g1qdsl1hraml21"))))
    (build-system asdf-build-system/sbcl)
    (native-inputs
     (list sbcl-enhanced-boolean sbcl-parachute))
    (home-page "https://www.hexstreamsoft.com/libraries/enhanced-typep/")
    (synopsis "Enhanced version of typep")
    (description
     "This package provides an enhanced version of @code{typep} that is exactly
like the one in the Lisp spec, except it can also accept a single type argument,
in which case it returns the appropriate closure.")
      (license license:unlicense)))

(define-public cl-enhanced-typep
  (sbcl-package->cl-source-package sbcl-enhanced-typep))

(define-public ecl-enhanced-typep
  (sbcl-package->ecl-package sbcl-enhanced-typep))

(define-public clasp-enhanced-typep
  (sbcl-package->clasp-package sbcl-enhanced-typep))

(define-public sbcl-envy
  (let ((commit "26a7faadc981f2a047daa36f715a44faec5dd00c")
        (revision "2"))
    (package
      (name "sbcl-envy")
      (version (git-version "0.1" revision commit))
      (home-page "https://github.com/fukamachi/envy")
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/fukamachi/envy")
               (commit commit)))
         (file-name (git-file-name "cl-envy" version))
         (sha256
          (base32 "1r0wgimd7z57x8cv69sw76w3y5l70hq50882a9nq5l4v64lg55fq"))))
      (build-system asdf-build-system/sbcl)
      (native-inputs
       (list sbcl-osicat sbcl-prove))
      (arguments
       `(#:asd-systems '("envy-test" "envy")
         ;; FIXME: Tests fail with
         ;;   Component ENVY-ASD::ENVY-TEST not found, required by #<SYSTEM "envy">
         ;; https://github.com/fukamachi/envy/issues/10
         #:tests? #f))
      (synopsis "Common Lisp configuration switcher inspired by Perl's Config::ENV")
      (description "Envy is a configuration manager for various applications.
Envy uses an environment variable to determine a configuration to use.  This
can separate configuration system from an implementation.")
      (license license:bsd-2))))

(define-public cl-envy
  (sbcl-package->cl-source-package sbcl-envy))

(define-public ecl-envy
  (sbcl-package->ecl-package sbcl-envy))

(define-public sbcl-eris
  (package
    (name "sbcl-eris")
    (version "0.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://git.ykonai.net/eris-cl")
             (commit version)))
       (file-name (git-file-name "cl-eris" version))
       (sha256
        (base32 "0qm74ld70aic39giamvix88500flv86047a82rx9gkjwaisf58rc"))))
    (build-system asdf-build-system/sbcl)
    (native-inputs (list sbcl-fiveam))
    (inputs
     (list sbcl-alexandria
           sbcl-bordeaux-threads
           sbcl-function-cache
           sbcl-ironclad
           sbcl-mmap
           sbcl-osicat
           sbcl-serapeum
           sbcl-trivial-gray-streams))
    (home-page "https://git.ykonai.net/eris-cl/")
    (synopsis "ERIS implementation for Common Lisp")
    (description
     "This is a Common Lisp implementation of the Encoding for Robust Immutable
Storage specification (ERIS).")
    (license license:lgpl3+)))

(define-public cl-eris
  (sbcl-package->cl-source-package sbcl-eris))

(define-public sbcl-esrap
  (let ((commit "d806138342a6b27327649fd5f36e0fe2e0966867")
        (revision "4"))
    (package
      (name "sbcl-esrap")
      (version (git-version "0.18" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/scymtym/esrap")
               (commit commit)))
         (file-name (git-file-name "cl-esrap" version))
         (sha256
          (base32 "0gs0mfamldhaihnlk0qxg2q4bl8bamq68dif9js9fkl8apg3iykl"))))
      (build-system asdf-build-system/sbcl)
      (native-inputs
       (list sbcl-fiveam))
      (inputs
       (list sbcl-alexandria sbcl-trivial-with-current-source-form))
      (synopsis "Common Lisp packrat parser")
      (description
       "This is a packrat parser for Common Lisp.
In addition to regular Packrat / Parsing Grammar / TDPL features ESRAP supports:

@itemize
@item dynamic redefinition of nonterminals
@item inline grammars
@item semantic predicates
@item introspective facilities (describing grammars, tracing, setting breaks)
@item left-recursive grammars
@item functions as terminals
@item accurate, customizable parse error reports
@end itemize\n")
      (home-page "https://scymtym.github.io/esrap/")
      (license license:expat))))

(define-public cl-esrap
  (sbcl-package->cl-source-package sbcl-esrap))

(define-public ecl-esrap
  (sbcl-package->ecl-package sbcl-esrap))

(define-public sbcl-evaled-when
  (let ((commit "c59f8ab20b846cac81d4be80d056a3d65676e8eb")
        (revision "0"))
    (package
      (name "sbcl-evaled-when")
      (version (git-version "1.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/Hexstream/evaled-when")
               (commit commit)))
         (file-name (git-file-name "cl-evaled-when" version))
         (sha256
          (base32 "07g1a50aairvsj57issb18si5a9r3skpbk05nlixmlj0mva3gkl3"))))
      (build-system asdf-build-system/sbcl)
      (native-inputs
       (list sbcl-enhanced-boolean sbcl-parachute))
      (inputs
       (list sbcl-trivial-cltl2))
      (home-page "https://www.hexstreamsoft.com/libraries/evaled-when/")
      (synopsis "Extract and replicate the compile-time side-effects of forms")
      (description
       "This package provides a way of extracting and replicating the
compile-time side-effects of forms.")
      (license license:unlicense))))

(define-public cl-evaled-when
  (sbcl-package->cl-source-package sbcl-evaled-when))

(define-public ecl-evaled-when
  (sbcl-package->ecl-package sbcl-evaled-when))

(define-public clasp-evaled-when
  (sbcl-package->clasp-package sbcl-evaled-when))

(define-public sbcl-event-emitter
  (let ((commit "cb0e15f9de4c617cef3f5d5a22a41e28f9613d0b")
        (revision "0"))
    (package
     (name "sbcl-event-emitter")
     (version (git-version "0.0.1" revision commit))
     (home-page "https://github.com/fukamachi/event-emitter")
     (source
      (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/fukamachi/event-emitter")
             (commit commit)))
       (file-name (git-file-name "cl-event-emitter" version))
       (sha256
        (base32 "1i18xzfr6334db9dzj0lsl7wxw1r1l0ixvn883mjbyqw0czp21h6"))))
     (build-system asdf-build-system/sbcl)
     (native-inputs
      (list sbcl-prove))
     (synopsis "Event mechanism for Common Lisp objects")
     (description "Event Emitter provides an event mechanism like Node.js for
Common Lisp objects.  It is mostly ported from Node.js @code{events} module.")
     (license license:bsd-2))))

(define-public cl-event-emitter
  (sbcl-package->cl-source-package sbcl-event-emitter))

(define-public ecl-event-emitter
  (sbcl-package->ecl-package sbcl-event-emitter))

(define-public sbcl-eventbus
  (let ((commit "92c1fa3846ba0e3cc9e6d7605d765379c8658d84")
        (revision "1"))
    (package
      (name "sbcl-eventbus")
      (version (git-version "0.1.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/noloop/eventbus")
               (commit commit)))
         (file-name (git-file-name "eventbus" version))
         (sha256
          (base32 "0slqx3zq6sbz3rg4g79j8y25sx4405y6ff3x6l5v8v4v42m1s0p2"))))
      (build-system asdf-build-system/sbcl)
      (native-inputs (list sbcl-simplet))
      (home-page "https://github.com/noloop/eventbus")
      (synopsis "Event bus implementation in Common Lisp")
      (description "This package provides a Common Lisp system implementing event bus.")
      (license license:gpl3))))

(define-public cl-eventbus
  (sbcl-package->cl-source-package sbcl-eventbus))

(define-public ecl-eventbus
  (sbcl-package->ecl-package sbcl-eventbus))

(define-public sbcl-exit-hooks
  ;; No release.
  (let ((commit "78050f4f55c138fcea86a9d720928782021b6012"))
    (package
      (name "sbcl-exit-hooks")
      (version (git-version "0.0.0" "1" commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/ailisp/exit-hooks/")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "00rk0pr2cy3hy6giblh166b7yrg06d5lanipjcqv508gkfb0vi47"))))
      (build-system asdf-build-system/sbcl)
      (home-page "https://github.com/ailisp/exit-hooks")
      (synopsis "Call functions automatically when Common Lisp exits")
      (description
       "@code{exit-hooks} provides a portable way to automatically call some
user-defined function when exiting Common Lisp (both @code{quit} from the REPL
or a kill in a shell).  Like @code{atexit} in C and Python or Java’s
@code{Runtime.addShutdownHook()}.  It currently supports SBCL, CCL, ECL, ABCL,
Allegro CL, clisp and CMUCL.  Before exit-hooks, there was no portable way of
doing so and no staightforward way to use an exit hook on ABCL.  It can be used
for tasks like parmenantly save something when exiting Lisp.")
      (license license:bsd-2))))

(define-public cl-exit-hooks
  (sbcl-package->cl-source-package sbcl-exit-hooks))

(define-public ecl-exit-hooks
  (sbcl-package->ecl-package sbcl-exit-hooks))

(define-public sbcl-exponential-backoff
  (let ((commit "8d9e8444d8b3184a524c12ce3449f91613ab714f"))
    (package
      (name "sbcl-exponential-backoff")
      (version (git-version "0" "1" commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/death/exponential-backoff")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "1389hm9hxv85s0125ja4js1bvh8ay4dsy9q1gaynjv27ynik6gmv"))))
      (build-system asdf-build-system/sbcl)
      (home-page "https://github.com/death/exponential-backoff")
      (synopsis "Exponential backoff algorithm in Common Lisp")
      (description
       "An implementation of the exponential backoff algorithm in Common Lisp.
Inspired by the implementation found in Chromium.  Read the header file to
learn about each of the parameters.")
      (license license:expat))))

(define-public cl-exponential-backoff
  (sbcl-package->cl-source-package sbcl-exponential-backoff))

(define-public ecl-exponential-backoff
  (sbcl-package->ecl-package sbcl-exponential-backoff))

(define-public clasp-exponential-backoff
  (sbcl-package->clasp-package sbcl-exponential-backoff))

(define-public sbcl-external-program
  (let ((commit "5888b8f1fd3953feeeacecbba4384ddda584a749")
        (revision "1"))
    (package
      (name "sbcl-external-program")
      (version (git-version "0.0.6" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/sellout/external-program")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "0vww1x3yilb3bjwg6k184vaj4vxyxw4vralhnlm6lk4xac67kc9z"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-trivial-features))
      (native-inputs
       (list sbcl-fiveam))
      (synopsis "Common Lisp library for running external programs")
      (description
       "EXTERNAL-PROGRAM enables running programs outside the Lisp
process.  It is an attempt to make the RUN-PROGRAM functionality in
implementations like SBCL and CCL as portable as possible without
sacrificing much in the way of power.")
      (home-page "https://github.com/sellout/external-program")
      (license license:llgpl))))

(define-public cl-external-program
  (sbcl-package->cl-source-package sbcl-external-program))

(define-public ecl-external-program
  (sbcl-package->ecl-package sbcl-external-program))

(define-public sbcl-f-underscore
  (package
    (name "sbcl-f-underscore")
    (version "0.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://gitlab.common-lisp.net/bpm/f-underscore")
             (commit "7988171194cd259e12469dd7c30000be6ef1b31a")))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "0mqvb2rxa08y07lj6smp8gf1ig32802fxq7mw5a283f2nkrinnb5"))))
    (build-system asdf-build-system/sbcl)
    (synopsis "Lambda shorthand macros")
    (description "Convenient macros for common lambda patterns.")
    (license license:public-domain)
    (home-page "https://gitlab.common-lisp.net/bpm/f-underscore")))

(define-public ecl-f-underscore
  (sbcl-package->ecl-package sbcl-f-underscore))

(define-public cl-f-underscore
  (sbcl-package->cl-source-package sbcl-f-underscore))

(define-public sbcl-f2cl
  (let ((commit "a3dabbe429ff2fe6039a60c2546d287b4157f546")
        (revision "1"))
    (package
      (name "sbcl-f2cl")
      (version (git-version "1.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/rtoy/f2cl")
               (commit commit)))
         (file-name (git-file-name "cl-f2cl" version))
         (sha256
          (base32 "1fc54n3g7kah93yj99dkvac4i765sysvcc6pwajhp2srr1np204s"))
         (modules '((guix build utils)))
         (snippet #~(delete-file-recursively "debian"))))
      (build-system asdf-build-system/sbcl)
      (arguments
       (list #:phases
             #~(modify-phases %standard-phases
                 (add-after 'unpack 'fix-build
                   (lambda _
                     (substitute* "src/f2cl2.l"
                       (("\\(optimize \\(speed 3\\) \\(safety 1\\)\\)\\)" all)
                        (string-append all ")"))))))))
      (synopsis "Fortran 77 to Common Lisp translator")
      (description
       "F2cl is a Common Lisp library that can convert Fortran 77 code into
Common Lisp code.")
      (home-page "https://github.com/rtoy/f2cl")
      (license license:gpl2))))

(define-public cl-f2cl
  (sbcl-package->cl-source-package sbcl-f2cl))

(define-public ecl-f2cl
  (sbcl-package->ecl-package sbcl-f2cl))

(define-public clasp-f2cl
  (sbcl-package->clasp-package sbcl-f2cl))

(define-public sbcl-fakenil
  (package
    (name "sbcl-fakenil")
    (version "1.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/Hexstream/fakenil")
             (commit (string-append "v" version))))
       (file-name (git-file-name "cl-fakenil" version))
       (sha256
        (base32 "0ipqax3sgcs1dsgxz8d2pmfg324k6l35pn0nz89w5jl02fia61l3"))))
    (build-system asdf-build-system/sbcl)
    (native-inputs
     (list sbcl-parachute))
    (home-page "https://www.hexstreamsoft.com/libraries/fakenil/")
    (synopsis "Provides a canonical stand-in for NIL")
    (description
     "This package provides a canonical stand-in for NIL for contexts where
NIL means no value.")
    (license license:unlicense)))

(define-public cl-fakenil
  (sbcl-package->cl-source-package sbcl-fakenil))

(define-public ecl-fakenil
  (sbcl-package->ecl-package sbcl-fakenil))

(define-public clasp-fakenil
  (sbcl-package->clasp-package sbcl-fakenil))

(define-public sbcl-fare-csv
  (let ((commit "f877a238dcbf587a89359cccf2128919a94a348c")
        (revision "0"))
    (package
      (name "sbcl-fare-csv")
      (version (git-version "1.0.4" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://gitlab.common-lisp.net/frideau/fare-csv")
               (commit commit)))
         (file-name (git-file-name "cl-fare-csv" version))
         (sha256
          (base32 "0k3mf968w94m4yff1k2jh7xlnpsm016qs4448bvklacjrr72vk8x"))))
      (build-system asdf-build-system/sbcl)
      (native-inputs (list sbcl-hu.dwim.stefil))
      (home-page "https://gitlab.common-lisp.net/frideau/fare-csv/")
      (synopsis "Robust CSV parser and printer")
      (description
       "This package provides a robust CSV parser and printer that tries to
follow the fine print of de facto standards.  It can be configured to choose
which standard exactly.")
      (license license:expat))))

(define-public cl-fare-csv
  (sbcl-package->cl-source-package sbcl-fare-csv))

(define-public ecl-fare-csv
  (sbcl-package->ecl-package sbcl-fare-csv))

(define-public clasp-fare-csv
  (sbcl-package->clasp-package sbcl-fare-csv))

(define-public sbcl-fare-memoization
  (let ((commit "8b43ac6bcc0057d1a92052e39b6d34c05c2eb7e4")
        (revision "0"))
    (package
      (name "sbcl-fare-memoization")
      (version "1.2.0")
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://gitlab.common-lisp.net/frideau/fare-memoization")
               (commit commit)))
         (sha256
          (base32 "1blmrb4c9gsxj87scz74z1s8w9d1w2r48fyxj0y1sw3vr6bsbb8f"))
         (file-name (git-file-name name commit))))
      (build-system asdf-build-system/sbcl)
      (native-inputs
       (list sbcl-hu.dwim.stefil))
      (inputs
       (list sbcl-named-readtables))
      (home-page "https://gitlab.common-lisp.net/frideau/fare-memoization")
      (synopsis "Memoization library for Common Lisp")
      (description
       "This library builds on the venerable idea of dynamically memoizing functions.
A memoized function remembers results from previous computations and returns cached
results when called again with the same arguments rather than repeating the computation.")
      (license license:expat))))

(define-public cl-fare-memoization
  (sbcl-package->cl-source-package sbcl-fare-memoization))

(define-public ecl-fare-memoization
  (sbcl-package->ecl-package sbcl-fare-memoization))

(define-public clasp-fare-memoization
  (sbcl-package->clasp-package sbcl-fare-memoization))

(define-public sbcl-fare-mop
  (let ((commit "538aa94590a0354f382eddd9238934763434af30")
        (revision "1"))
    (package
      (name "sbcl-fare-mop")
      (version (git-version "1.0.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/fare/fare-mop")
               (commit commit)))
         (file-name (git-file-name "fare-mop" version))
         (sha256
          (base32
           "0maxs8392953fhnaa6zwnm2mdbhxjxipp4g4rvypm06ixr6pyv1c"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-closer-mop sbcl-fare-utils))
      (home-page "https://github.com/fare/fare-mop")
      (synopsis "General purpose Common Lisp utilities using the MOP")
      (description
       "FARE-MOP is a small collection of utilities using the MetaObject
Protocol.  It notably contains a SIMPLE-PRINT-OBJECT method, and
a SIMPLE-PRINT-OBJECT-MIXIN mixin that allow you to trivially define
PRINT-OBJECT methods that print the interesting slots in your objects, which is
great for REPL interaction and debugging.")
      (license license:unlicense))))

(define-public ecl-fare-mop
  (sbcl-package->ecl-package sbcl-fare-mop))

(define-public clasp-fare-mop
  (sbcl-package->clasp-package sbcl-fare-mop))

(define-public cl-fare-mop
  (sbcl-package->cl-source-package sbcl-fare-mop))

(define-public sbcl-fare-quasiquote
  (let ((commit "640d39a0451094071b3e093c97667b3947f43639")
        (revision "1"))
    (package
      (name "sbcl-fare-quasiquote")
      (build-system asdf-build-system/sbcl)
      (version (git-version "1.0.1" revision commit))
      (home-page "https://gitlab.common-lisp.net/frideau/fare-quasiquote")
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url (string-append "https://gitlab.common-lisp.net/frideau/"
                                   "fare-quasiquote.git"))
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "1g6q11l50kgija9f55lzqpcwvaq0ljiw8v1j265hnyg6nahjwjvg"))))
      (inputs
       `(("fare-utils" ,sbcl-fare-utils)
         ("named-readtables" ,sbcl-named-readtables)
         ("optima" ,sbcl-optima)))
      (arguments
       ;; XXX: Circular dependencies: Tests depend on subsystems,
       ;; which depend on the main systems.
       `(#:tests? #f
         #:asd-systems '("fare-quasiquote"
                         "fare-quasiquote-extras")
         #:phases
         (modify-phases %standard-phases
           ;; XXX: Require 1.0.0 version of fare-utils, and we package some
           ;; commits after 1.0.0.5, but ASDF fails to read the
           ;; "-REVISION-COMMIT" part generated by Guix.
           (add-after 'unpack 'patch-requirement
             (lambda _
               (substitute* "fare-quasiquote.asd"
                 (("\\(:version \"fare-utils\" \"1.0.0\"\\)")
                  "\"fare-utils\""))
               (substitute* "fare-quasiquote-optima.asd"
                 (("\\(:version \"optima\" \"1\\.0\"\\)")
                  "\"optima\""))
               #t)))))
      (synopsis "Pattern-matching friendly implementation of quasiquote")
      (description "The main purpose of this n+2nd reimplementation of
quasiquote is enable matching of quasiquoted patterns, using Optima or
Trivia.")
      (license license:expat))))

(define-public cl-fare-quasiquote
  (sbcl-package->cl-source-package sbcl-fare-quasiquote))

(define-public ecl-fare-quasiquote
  (sbcl-package->ecl-package sbcl-fare-quasiquote))

(define-public clasp-fare-quasiquote
  (sbcl-package->clasp-package sbcl-fare-quasiquote))

(define-public sbcl-fare-utils
  (let ((commit "66e9c6f1499140bc00ccc22febf2aa528cbb5724")
        (revision "1"))
    (package
      (name "sbcl-fare-utils")
      (version (git-version "1.0.0.5" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri
          (git-reference
           (url
            "https://gitlab.common-lisp.net/frideau/fare-utils.git")
           (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "01wsr1aap3jdzhn4hrqjbhsjx6qci9dbd3gh4gayv1p49rbg8aqr"))))
      (build-system asdf-build-system/sbcl)
      (native-inputs
       (list sbcl-hu.dwim.stefil))
      (synopsis "Collection of utilities and data structures")
      (description
       "fare-utils is a small collection of utilities.  It contains a lot of
basic everyday functions and macros.")
      (home-page "https://gitlab.common-lisp.net/frideau/fare-utils")
      ;; MIT License
      (license license:expat))))

(define-public cl-fare-utils
  (sbcl-package->cl-source-package sbcl-fare-utils))

(define-public ecl-fare-utils
  (sbcl-package->ecl-package sbcl-fare-utils))

(define-public clasp-fare-utils
  (sbcl-package->clasp-package sbcl-fare-utils))

(define-public sbcl-fast-generic-functions
  (let ((commit "6e9d690ec08dacf9ab4e14aa39a084ef7c7edabb")
        (revision "2"))
    (package
      (name "sbcl-fast-generic-functions")
      (version (git-version "0.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/marcoheisig/fast-generic-functions/")
               (commit commit)))
         (file-name (git-file-name "cl-fast-generic-functions" version))
         (sha256
          (base32 "1v2pwmhnyfvhx8hrl1zk2lm4k1a3kqglf696hnfx7zrpz9kwk15m"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-closer-mop
             sbcl-sealable-metaobjects
             sbcl-trivial-macroexpand-all))
      (arguments
       ;; Tests fail: https://github.com/marcoheisig/fast-generic-functions/issues/10
       '(#:tests? #f))
      (home-page "https://github.com/marcoheisig/fast-generic-functions/")
      (synopsis "Seal generic functions to boost performance")
      (description
       "This library introduces @emph{fast generic functions}, i.e. functions
that behave just like regular generic functions, except that the can be sealed
on certain domains.  If the compiler can then statically detect that the
arguments to a fast generic function fall within such a domain, it will
perform a variety of optimizations.")
      (license license:expat))))

(define-public cl-fast-generic-functions
  (sbcl-package->cl-source-package sbcl-fast-generic-functions))

(define-public ecl-fast-generic-functions
  (sbcl-package->ecl-package sbcl-fast-generic-functions))

(define-public sbcl-fast-http
  (let ((commit "502a37715dcb8544cc8528b78143a942de662c5a")
        (revision "2"))
    (package
      (name "sbcl-fast-http")
      (version (git-version "0.2.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/fukamachi/fast-http")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "0al2g7g219jjljsf7b23pbilpgacxy5as5gs2nqf76b5qni396mi"))))
      (build-system asdf-build-system/sbcl)
      (arguments
       '(#:asd-systems '("fast-http-test" "fast-http")))
      (native-inputs
       `(("sbcl-prove" ,sbcl-prove)
         ("cl-syntax" ,sbcl-cl-syntax)))
      (inputs
       (list sbcl-alexandria sbcl-proc-parse sbcl-xsubseq
             sbcl-smart-buffer sbcl-cl-utilities))
      (home-page "https://github.com/fukamachi/fast-http")
      (synopsis "HTTP request/response parser for Common Lisp")
      (description
       "@code{fast-http} is a HTTP request/response protocol parser for Common
Lisp.")
      ;; Author specified the MIT license
      (license license:expat))))

(define-public cl-fast-http
  (sbcl-package->cl-source-package sbcl-fast-http))

(define-public ecl-fast-http
  (sbcl-package->ecl-package sbcl-fast-http))

(define-public sbcl-fast-io
  (let ((commit "a4c5ad600425842e8b6233b1fa22610ffcd874c3")
        (revision "3"))
    (package
     (name "sbcl-fast-io")
     (version (git-version "1.0.0" revision commit))
     (source
      (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/rpav/fast-io")
             (commit commit)))
       (file-name (git-file-name "cl-fast-io" version))
       (sha256
        (base32 "0wh02yagbqahy9z6787jz5ggpagvr18qd0z13wvwq1vjf8xd2530"))))
     (build-system asdf-build-system/sbcl)
     (native-inputs
      (list sbcl-fiveam sbcl-checkl))
     (inputs
      (list sbcl-alexandria sbcl-trivial-gray-streams sbcl-static-vectors))
     (home-page "https://github.com/rpav/fast-io")
     (synopsis "Fast octet-vector/stream I/O for Common Lisp")
     (description
      "Fast-io is about improving performance to octet-vectors and octet
streams (though primarily the former, while wrapping the latter).")
     ;; Author specifies this as NewBSD which is an alias
     (license license:bsd-3))))

(define-public cl-fast-io
  (sbcl-package->cl-source-package sbcl-fast-io))

(define-public ecl-fast-io
  (sbcl-package->ecl-package sbcl-fast-io))

(define-public sbcl-fast-websocket
  (let ((commit "baeeaddf1447015863d708f840ef9dfc5ff5b7a2")
        (revision "1"))
    (package
     (name "sbcl-fast-websocket")
     (version (git-version "0.1" revision commit))
     (home-page "https://github.com/fukamachi/fast-websocket")
     (source
      (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/fukamachi/fast-websocket")
             (commit commit)))
       (file-name (git-file-name "cl-fast-websoclet" version))
       (sha256
        (base32 "1j7v00gbkzx4mq2v8y44jm4jx321hgrv9igfw23cvzzlyd3dzp6y"))))
     (build-system asdf-build-system/sbcl)
     (arguments
      ;; Test system must be loaded before, otherwise tests fail with:
      ;; Component FAST-WEBSOCKET-ASD::FAST-WEBSOCKET-TEST not found,
      ;; required by #<SYSTEM "fast-websocket">.
      '(#:asd-systems '("fast-websocket-test"
                        "fast-websocket")))
     (inputs
      (list sbcl-fast-io
            sbcl-babel
            sbcl-alexandria))
     (native-inputs
      (list sbcl-prove
            sbcl-trivial-utf-8))
     (synopsis "WebSocket protocol parser for Common Lisp")
     (description
      "@code{fast-websocket} is an optimized low-level WebSocket protocol
parser/composer.")
     (license license:bsd-2))))

(define-public cl-fast-websocket
  (sbcl-package->cl-source-package sbcl-fast-websocket))

(define-public ecl-fast-websocket
  (sbcl-package->ecl-package sbcl-fast-websocket))

(define-public sbcl-feeder
  ;; No release.
  (let ((commit "b05f517d7729564575cc809e086c262646a94d34")
        (revision "1"))
    (package
      (name "sbcl-feeder")
      (version (git-version "1.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/Shinmera/feeder")
               (commit commit)))
         (file-name (git-file-name "feeder" version))
         (sha256
          (base32 "1dpbzhycg50snl3j01c8dh8gdvhfhz0hnfl54xy55a3wbr3m6rp7"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-documentation-utils sbcl-local-time sbcl-plump))
      (home-page "https://shinmera.github.io/feeder/")
      (synopsis "RSS, Atom and general feed parsing and generating")
      (description
       "Feeder is a syndication feed library.  It presents a general protocol
for representation of feed items, as well as a framework to translate these
objects from and to external formats.  It also implements the RSS 2.0 and Atom
formats within this framework.")
      (license license:zlib))))

(define-public cl-feeder
  (sbcl-package->cl-source-package sbcl-feeder))

(define-public ecl-feeder
  (sbcl-package->ecl-package sbcl-feeder))

(define-public clasp-feeder
  (sbcl-package->clasp-package sbcl-feeder))

(define-public sbcl-ffa
  (let ((commit "b7012f51c4c37d1e759ff9cf78cea178504d8e07")
        (revision "1"))
    (package
      (name "sbcl-ffa")
      (version (git-version "0.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/tpapp/ffa")
               (commit commit)))
         (file-name (git-file-name "cl-ffa" version))
         (sha256
          (base32 "0l7kqcjp3sn1129hpwq6zhjqc0ydx9gc53z7k13i38x3z1asap7a"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-cffi sbcl-cl-utilities sbcl-iterate sbcl-metabang-bind))
      (synopsis "Foreign friendly arrays for Common Lisp")
      (description
       "This package provides a macro that allows foreign functions to access
the contents of the array at a given pointer, using the best available method
given the Common Lisp implementation.")
      (home-page "https://cliki.net/ffa")
      (license license:llgpl))))

(define-public cl-ffa
  (sbcl-package->cl-source-package sbcl-ffa))

(define-public ecl-ffa
  (sbcl-package->ecl-package sbcl-ffa))

(define-public sbcl-file-attributes
  (let ((commit "bbde396438f37d676de9775239115410bec4da2d"))
    (package
      (name "sbcl-file-attributes")
      (version (git-version "1.0.0" "2" commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/Shinmera/file-attributes/")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "0n8q818ry2shggjfhp8gjby8v5mla9pg97c5g19pcglpnwim7a74"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-cffi sbcl-documentation-utils sbcl-trivial-features))
      (home-page "https://shinmera.github.io/file-attributes/")
      (synopsis "Access to common file attributes in Common Lisp")
      (description
       "This is a small OS portability library to retrieve and set file
attributes not supported by the Common Lisp standard functions.")
      (license license:zlib))))

(define-public ecl-file-attributes
  (sbcl-package->ecl-package sbcl-file-attributes))

(define-public cl-file-attributes
  (sbcl-package->cl-source-package sbcl-file-attributes))

(define-public sbcl-file-finder
  (let ((commit "ec392d775eee33dbdea0d6532d20952438991f99")
        (revision "0"))
    (package
      (name "sbcl-file-finder")
      (version (git-version "0.2.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/lisp-maintainers/file-finder")
               (commit commit)))
         (file-name (git-file-name "cl-file-finder" version))
         (sha256
          (base32 "1mpasi7n0ysggx0inxdbzlwavh08m0jxvv220ammvcyn3xybbchj"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-alexandria
             sbcl-cl-str
             sbcl-file-attributes
             sbcl-local-time
             sbcl-named-readtables
             sbcl-serapeum))
      (synopsis "Enable rapid file search, inspection and manipulation")
      (description
       "This library provides modern file handling for Common Lisp, which
avoids many of the pitfalls of pathnames.")
      (home-page "https://github.com/lisp-maintainers/file-finder")
      (license license:gpl3+))))

(define-public ecl-file-finder
  (sbcl-package->ecl-package sbcl-file-finder))

(define-public cl-file-finder
  (sbcl-package->cl-source-package sbcl-file-finder))

(define-public sbcl-file-notify
  (let ((commit "f12dc2f2aae5fee13355cd93a8cae0c4c412b76d")
        (revision "0"))
    (package
      (name "sbcl-file-notify")
      (version (git-version "1.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/Shinmera/file-notify")
               (commit commit)))
         (file-name (git-file-name "cl-file-notify" version))
         (sha256
          (base32 "0788d98rqm1krl8nbfh8qshvyf6g336i9bqrdhkx06cfvbh0wcny"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-cffi
             sbcl-documentation-utils
             sbcl-trivial-features))
      (home-page "https://github.com/Shinmera/file-notify")
      (synopsis "Get notifications for file accesses and changes")
      (description
       "File-Notify is a Common Lisp library for getting notifications for file
accesses and changes.")
      (license license:zlib))))

(define-public cl-file-notify
  (sbcl-package->cl-source-package sbcl-file-notify))

(define-public ecl-file-notify
  (sbcl-package->ecl-package sbcl-file-notify))

(define-public sbcl-file-select
  (let ((commit "ef25f6d7c78ed9e0b62119979af8c4b5b0f8c774")
        (revision "1"))
    (package
      (name "sbcl-file-select")
      (version (git-version "1.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/Shinmera/file-select")
               (commit commit)))
         (file-name (git-file-name "file-select" version))
         (sha256
          (base32 "1qh32ymljw5c98zzbvjfq6jzwlzs4qxi8gh4gw8pixir6y1inxaa"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-cffi
             sbcl-documentation-utils
             sbcl-float-features))
      (home-page "https://shinmera.github.io/file-select/")
      (synopsis "Invoke the native file selection dialogs to open or save files")
      (description
       "This library allows you to open native file dialogs to open and save
files.  This is useful if you have an application that's primarily text based
and would like a more convenient file selection utility, or if you are working
with a UI toolkit that does not offer a way to access the native file dialogs
directly.")
      (license license:zlib))))

(define-public cl-file-select
  (sbcl-package->cl-source-package sbcl-file-select))

(define-public ecl-file-select
  (sbcl-package->ecl-package sbcl-file-select))

(define-public sbcl-file-types
  (let ((commit "6f5676b2781f617b6009ae4ce001496ea43b6fac")
        (revision "0"))
    (package
      (name "sbcl-file-types")
      (version (git-version "0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/eugeneia/file-types")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "09l67gzjwx7kx237grm709dsj9rkmmm8s3ya6irmcw8nh587inbs"))))
      (build-system asdf-build-system/sbcl)
      (home-page "https://github.com/eugeneia/file-types")
      (synopsis "Simple scheme to classify file types in a hierarchical
fashion")
      (description "Simple scheme to classify file types in a hierarchical
fashion.")
      (license license:agpl1))))

(define-public ecl-file-types
  (sbcl-package->ecl-package sbcl-file-types))

(define-public cl-file-types
  (sbcl-package->cl-source-package sbcl-file-types))

(define-public sbcl-filesystem-utils
  (let ((commit "a07e8b61b89d4b46408fb9294d9b8130e8c8a02e")
        (revision "2"))
    (package
      (name "sbcl-filesystem-utils")
      (version (git-version "1.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/Shinmera/filesystem-utils/")
               (commit commit)))
         (file-name (git-file-name "cl-filesystem-utils" version))
         (sha256
          (base32 "1zv2i2gndnbs7hz3bgkkq1qfx604wbndpc7qqlqvg23fssn9w59f"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-documentation-utils
             sbcl-pathname-utils
             sbcl-trivial-features))
      (home-page "https://shinmera.github.io/filesystem-utils/")
      (synopsis "Collection of utilities for filesystem interaction")
      (description
       "This is an extension library to @code{pathname-utils}, to allow
dealing with common problems with filesystems, such as listing files, probing
file types, determining default directories, etc.")
      (license license:zlib))))

(define-public cl-filesystem-utils
  (sbcl-package->cl-source-package sbcl-filesystem-utils))

(define-public ecl-filesystem-utils
  (sbcl-package->ecl-package sbcl-filesystem-utils))

(define-public sbcl-filtered-functions
  (let ((commit "130f69e7b9e1051bf569ef63364b09a3873f0ced"))
    (package
      (name "sbcl-filtered-functions")
      (version (git-version "0.2.0" "1" commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/pcostanza/filtered-functions")
               (commit commit)))
         (file-name (git-file-name "cl-filtered-functions" version))
         (sha256
          (base32 "0m13k8pl0gfll8ss83c0z3gax7zrrw2i4s26451jfbka1xr4fgy9"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-closer-mop))
      (home-page "https://github.com/pcostanza/filtered-functions")
      (synopsis "Extension of CLOS generic function invocation")
      (description
       "Filtered functions provide an extension of CLOS generic function
invocation that add a simple preprocessing step before the actual method
dispatch is performed and thus enable the use of arbitrary predicates for
selecting and applying methods.  See
@url{http://www.p-cos.net/documents/filtered-dispatch.pdf} for a paper that
introduces and explains filtered functions in detail.")
      (license license:expat))))

(define-public cl-filtered-functions
  (sbcl-package->cl-source-package sbcl-filtered-functions))

(define-public ecl-filtered-functions
  (sbcl-package->ecl-package sbcl-filtered-functions))

(define-public sbcl-find-port
  (let ((commit "811727f88d7f000623bf92fdb0e64678a7112a28")
        (revision "2"))
    (package
      (name "sbcl-find-port")
      (build-system asdf-build-system/sbcl)
      (version (git-version "0.1" revision commit))
      (home-page "https://github.com/eudoxia0/find-port")
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url home-page)
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "1fw6q7d2bxxb7fqk548ylq8mx4sz95yc0q5h0rwd0mnqjrbwbari"))))
      (native-inputs
       (list sbcl-fiveam))
      (inputs
       (list sbcl-usocket))
      (synopsis "Find open ports programmatically in Common Lisp")
      (description "This is a small Common Lisp library that finds an open
port within a range.")
      (license license:expat))))

(define-public cl-find-port
  (sbcl-package->cl-source-package sbcl-find-port))

(define-public ecl-find-port
  (sbcl-package->ecl-package sbcl-find-port))

(define-public sbcl-flamegraph
  (let ((commit "0b78cae83b1f5e71941c8804a6c1d945a11e4036")
        (revision "1"))
    (package
      (name "sbcl-flamegraph")
      (version (git-version "0.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/40ants/cl-flamegraph")
               (commit commit)))
         (file-name (git-file-name "cl-flamegraph" version))
         (sha256
          (base32 "1aj7hhvav9j9c66ssy11ry3p6xqb912yafi91g6sin6pdx84c2lw"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-alexandria))
      (home-page "https://github.com/40ants/cl-flamegraph")
      (synopsis "Generate flamegraphs of Common Lisp code")
      (description
       "@code{cl-flamegraph} is a wrapper around SBCL's statistical profiler.
It saves stack traces of profiled code in a form suitable for processing by
the @command{flamegraph.pl} script, which is available in the Guix package
@code{flamegraph}.")
      (license license:bsd-3))))

(define-public cl-flamegraph
  (sbcl-package->cl-source-package sbcl-flamegraph))

(define-public sbcl-flare
  (let ((commit "4f9f17a4fc5b368c2a1988b9a20288695b8d8c48")
        (revision "1"))
    (package
      (name "sbcl-flare")
      (version (git-version "1.1.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/Shinmera/flare")
               (commit commit)))
         (file-name (git-file-name "flare" version))
         (sha256
          (base32 "00nm3sjngbflj2gd5q0xs2m136w4kix6krww23nk64pkkyq2fs86"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-3d-vectors
             sbcl-array-utils
             sbcl-documentation-utils
             sbcl-for
             sbcl-lambda-fiddle
             sbcl-trivial-garbage))
      (home-page "https://shinmera.github.io/flare/")
      (synopsis "Easy particle systems with fine grained control")
      (description
       "FLARE is a library designed to allow quick and precise particle effect
creations.  It does not concern itself with displaying and only with the
management and movement of particles.  As such, it can easily be integrated into
any existing or future application.")
      (license license:zlib))))

(define-public cl-flare
  (sbcl-package->cl-source-package sbcl-flare))

(define-public ecl-flare
  (sbcl-package->ecl-package sbcl-flare))

(define-public sbcl-flexi-streams
  (let ((commit "4951d575b8f73270802a03cc5812b8310409caa9")
        (revision "1"))
    (package
      (name "sbcl-flexi-streams")
      (version (git-version "1.0.20" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/edicl/flexi-streams")
               (commit commit)))
         (file-name (git-file-name "cl-flexi-streams" version))
         (sha256
          (base32 "1bk224ryfiwsmnmq2gdfv9gld85z2rvnlx7fxcl2k122vc344akh"))))
      (build-system asdf-build-system/sbcl)
      (arguments
       (list #:phases
             #~(modify-phases %standard-phases
                 (add-after 'unpack 'make-git-checkout-writable
                   (lambda _
                     (for-each make-file-writable (find-files ".")))))))
      (inputs
       (list sbcl-trivial-gray-streams))
      (synopsis "Implementation of virtual bivalent streams for Common Lisp")
      (description "Flexi-streams is an implementation of \"virtual\" bivalent
streams that can be layered atop real binary or bivalent streams and that can
be used to read and write character data in various single- or multi-octet
encodings which can be changed on the fly.  It also supplies in-memory binary
streams which are similar to string streams.")
      (home-page "http://weitz.de/flexi-streams/")
      (license license:bsd-3))))

(define-public cl-flexi-streams
  (sbcl-package->cl-source-package sbcl-flexi-streams))

(define-public ecl-flexi-streams
  (sbcl-package->ecl-package sbcl-flexi-streams))

(define-public clasp-flexi-streams
  (package
    (inherit (sbcl-package->clasp-package sbcl-flexi-streams))
    (arguments
     ;; TODO: https://github.com/edicl/flexi-streams/issues/51
     '(#:tests? #f))))

(define-public sbcl-flexichain
  ;; There are no releases.
  (let ((commit "9af644a6323f303a936a391b956babcbfe7b0c67")
        (revision "2"))
    (package
      (name "sbcl-flexichain")
      (version (git-version "1.5.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/robert-strandh/Flexichain")
               (commit commit)))
         (file-name (git-file-name "cl-flexichain" version))
         (sha256
          (base32 "1ivkffnkc1iqmpl1p1rgyfbbgjmjcid4iszvdql1jjz324lq94g6"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-trivial-garbage))
      (home-page "https://github.com/robert-strandh/Flexichain.git")
      (synopsis "Dynamically add elements to or remove them from sequences")
      (description
       "This package provides an implementation of the flexichain protocol,
allowing client code to dynamically add elements to, and delete elements from
a sequence (or chain) of such elements.")
      (license license:lgpl2.1+))))

(define-public ecl-flexichain
  (sbcl-package->ecl-package sbcl-flexichain))

(define-public cl-flexichain
  (sbcl-package->cl-source-package sbcl-flexichain))

(define-public sbcl-float-features
  (let ((commit "c1f86aea91cfaa3aa59799162be23ef8a12b199d")
        (revision "2"))
    (package
      (name "sbcl-float-features")
      (version (git-version "1.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/Shinmera/float-features")
               (commit commit)))
         (file-name (git-file-name "float-features" version))
         (sha256
          (base32 "0vqm9xhn2i4vbjrxnp4hr1l3lydjflhjykdz6cmqg2j48c5kh3g3"))))
      (build-system asdf-build-system/sbcl)
      (synopsis "Common Lisp IEEE float portability library")
      (description
       "Portability library for IEEE float features that are not
covered by the Common Lisp standard.")
      (home-page "https://github.com/Shinmera/float-features")
      (license license:zlib)
      (inputs
       `(("documentation-utils" ,sbcl-documentation-utils)))
      (arguments
       `(#:tests? #f)))))

(define-public cl-float-features
  (sbcl-package->cl-source-package sbcl-float-features))

(define-public ecl-float-features
  (sbcl-package->ecl-package sbcl-float-features))

(define-public clasp-float-features
  (sbcl-package->clasp-package sbcl-float-features))

(define-public sbcl-flow
  (let ((commit "6d925af009cdfe033650d7048197a5e6ee937d15")
        (revision "1"))
    (package
      (name "sbcl-flow")
      (version (git-version "1.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/Shinmera/flow")
               (commit commit)))
         (file-name (git-file-name "flow" version))
         (sha256
          (base32 "0ysw1kwiqlf8kzllhnz8v3q40dmvwf83fzq8bfkbmwy5hfjh3pxp"))))
      (build-system asdf-build-system/sbcl)
      ;; FIXME: (Sharlatan-20210527T203118+0100): FLOW-VISUALIZER requires
      ;; COMMONQT which is not packed yet and required tweaks with QT. Remove
      ;; this when it's ready.
      (inputs
       `(("closer-mop" ,sbcl-closer-mop)
         ("documentation-utils" ,sbcl-documentation-utils)))
      (home-page "https://shinmera.github.io/flow/")
      (synopsis "Tools for the representation of graphs and flowcharts")
      (description
       "FLOW is a flowchart graph library.  Unlike other graphing libraries,
this one focuses on nodes in a graph having distinct @code{ports} through which
connections to other nodes are formed.  This helps in many concrete scenarios
where it is important to distinguish not only which nodes are connected, but
also how they are connected to each other.

Particularly, a lot of data flow and exchange problems can be reduced to such
a @code{flowchart}.  For example, an audio processing library may present its
pipeline as a flowchart of segments that communicate with each other through
audio sample buffers.  Flow gives a convenient view onto this kind of problem,
and even allows the generic visualisation of graphs in this format.")
      (license license:zlib))))

(define-public cl-flow
  (sbcl-package->cl-source-package sbcl-flow))

(define-public ecl-flow
  (sbcl-package->ecl-package sbcl-flow))

(define-public clasp-flow
  (sbcl-package->clasp-package sbcl-flow))

(define-public sbcl-flute
  (let ((commit "90ebcd6e82f637f49b6de7d625ccc51ec4c92900")
        (revision "1"))
    (package
      (name "sbcl-flute")
      (version (git-version "0.2-dev" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/ailisp/flute")
               (commit commit)))
         (file-name (git-file-name "cl-flute" version))
         (sha256
          (base32 "0q8jhp040cvpppyn820mm6a550yfxyr1lar298x13c42mm807f4f"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-assoc-utils sbcl-let-over-lambda))
      (native-inputs
       (list sbcl-fiveam))
      (home-page "https://github.com/ailisp/flute")
      (synopsis "HTML5 generation library in Common Lisp")
      (description
       "Flute is an easily composable HTML5 generation library in Common
Lisp.")
      (license license:expat))))

(define-public cl-flute
  (sbcl-package->cl-source-package sbcl-flute))

(define-public ecl-flute
  (sbcl-package->ecl-package sbcl-flute))

(define-public sbcl-fn
  (let ((commit "8d8587d03a7b5e26b306fc90018e385d9e5acc2c")
        (revision "1"))
    (package
      (name "sbcl-fn")
      (version (git-version "0.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/cbaggers/fn")
               (commit commit)))
         (file-name (git-file-name "fn" version))
         (sha256
          (base32 "0yyp9z6iwx476whz0n1rpjznjyqqhlylhzwpgg5xx92lxmskl752"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-named-readtables))
      (home-page "https://github.com/cbaggers/fn")
      (synopsis "Macros for lambda brevity")
      (description
       "This is a Common Lisp library providing lambda shorthand macros aiming
to be used in cases where the word @emph{lambda} and the arguments are longer
than the body of the lambda.")
      (license license:public-domain))))

(define-public cl-fn
  (sbcl-package->cl-source-package sbcl-fn))

(define-public ecl-fn
  (sbcl-package->ecl-package sbcl-fn))

(define-public clasp-fn
  (sbcl-package->clasp-package sbcl-fn))

(define-public sbcl-fof
  (let ((commit "522879e7da110ecf2e841998b197b34062c54b29")
        (revision "1"))
    (package
      (name "sbcl-fof")
      (version (git-version "0.2.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://gitlab.com/ambrevar/fof")
               (commit commit)))
         (file-name (git-file-name "cl-fof" version))
         (sha256
          (base32 "0ipy51q2fw03xk9rqcyzbq2b9c32npc1gl3c53rdjywpak7zwwg6"))))
      (build-system asdf-build-system/sbcl)
      (arguments
       `(#:asd-systems '("fof" "fof/mf")
         #:phases
         (modify-phases %standard-phases
           (add-after 'unpack 'fix-paths
             (lambda* (#:key inputs #:allow-other-keys)
               (substitute* "ffprobe.lisp"
                 (("\\(defvar \\*ffprobe-command\\* \"ffprobe\"\\)")
                  (format #f "(defvar *ffprobe-command* \"~a/bin/ffprobe\")"
                          (assoc-ref inputs "ffmpeg")))))))))
      (inputs
       (list sbcl-alexandria
             sbcl-cl-json
             sbcl-cl-str
             sbcl-hu.dwim.defclass-star
             sbcl-local-time
             sbcl-magicffi
             sbcl-named-readtables
             sbcl-osicat
             sbcl-serapeum
             sbcl-trivia
             sbcl-trivial-package-local-nicknames
             ;; Non-CL deps:
             ffmpeg))
      (home-page "https://gitlab.com/ambrevar/fof")
      (synopsis "File object finder library for Common Lisp")
      (description
       "This library enable rapid file search, inspection and manipulation
straight from the REPL.
It aims at replacing Unix tools such as @code{find} or @code{du}.
It also offers a replacement to the @code{pathname} Common Lisp API.
Slot writers which commit changes to disk, e.g. permissions, modification
time, etc.")
      (license license:gpl3+))))

(define-public cl-fof
  (sbcl-package->cl-source-package sbcl-fof))

(define-public ecl-fof
  (sbcl-package->ecl-package sbcl-fof))

(define-public sbcl-font-discovery
  (let ((commit "5101ca79151055f3ec9839aae73b8af42b884528")
        (revision "1"))
    (package
      (name "sbcl-font-discovery")
      (version (git-version "1.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/Shinmera/font-discovery")
               (commit commit)))
         (file-name (git-file-name "font-discovery" version))
         (sha256
          (base32 "1p9wkwc23rnif8vcjaj5ih1fmr5g57sidqjlz08qw6k0z4f6bia1"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-cffi sbcl-documentation-utils sbcl-trivial-indent))
      (home-page "https://shinmera.github.io/font-discovery/")
      (synopsis "Find system font files matching a font spec")
      (description
       "This is a library to find system font files.  It works on systems with
FontConfig on Linux, BSD.  It does not have any foreign dependencies that
aren't already directly available on the system.")
      (license license:zlib))))

(define-public cl-font-discovery
  (sbcl-package->cl-source-package sbcl-font-discovery))

(define-public ecl-font-discovery
  (sbcl-package->ecl-package sbcl-font-discovery))

(define-public sbcl-for
  (let ((commit "a39782991292e44ee3b5e2e25cddaa8115f6d363")
        (revision "1"))
    (package
      (name "sbcl-for")
      (version (git-version "1.2.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/Shinmera/for")
               (commit commit)))
         (file-name (git-file-name "cl-for" version))
         (sha256
          (base32 "07jdwqkyb3qd65mng60cs723z7p0bv2769hhalz4c0mfzn8qrn99"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-documentation-utils sbcl-form-fiddle sbcl-lambda-fiddle))
      (home-page "https://shinmera.github.io/for/")
      (synopsis "Extensible iteration macro library")
      (description
       "For is a library for an extensible iteration macro.  It allows you to write
concise looping constructs similar to @code{loop} and @code{iterate}.  Unlike
loop however it is extensible and sensible, and unlike iterate it does not
require code-walking and is easier to extend.")
      (license license:zlib))))

(define-public cl-for
  (sbcl-package->cl-source-package sbcl-for))

(define-public ecl-for
  (sbcl-package->ecl-package sbcl-for))

(define-public clasp-for
  (sbcl-package->clasp-package sbcl-for))

(define-public sbcl-forge
  (let ((commit "012324e251d91436f4a610e2fe2eb50674c3c3ce")
        (revision "1"))
    (package
      (name "sbcl-forge")
      (version (git-version "1.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/Shinmera/forge/")
               (commit commit)))
         (sha256
          (base32 "006vi2ihrn28pzrwa8b7axmv98bdaxzx7lacnh9pbacbjg3b7hb0"))
         (file-name (git-file-name "forge" version))))
      (build-system asdf-build-system/sbcl)
      (arguments
       '(#:asd-systems '("forge-support"
                         "forge-communication"
                         "forge")))
      (inputs
       (list sbcl-alexandria
             sbcl-bordeaux-threads
             sbcl-cffi
             sbcl-cl-ppcre
             sbcl-closer-mop
             sbcl-documentation-utils
             sbcl-ironclad
             sbcl-pathname-utils
             sbcl-promise
             sbcl-usocket
             sbcl-verbose))
      (synopsis "General, modular build system")
      (description "Forge is a generic build system.  Refer to documentation
for the specific kind of project you're building to get the full picture.")
      (home-page "https://github.com/shinmera/forge")
      (license license:zlib))))

(define-public cl-forge
  (sbcl-package->cl-source-package sbcl-forge))

(define-public sbcl-form-fiddle
  (let ((commit "e0c23599dbb8cff3e83e012f3d86d0764188ad18")
        (revision "0"))
    (package
      (name "sbcl-form-fiddle")
      (version (git-version "1.1.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri
          (git-reference
           (url "https://github.com/Shinmera/form-fiddle")
           (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "041iznc9mpfyrl0sv5893ys9pbb2pvbn9g3clarqi7gsfj483jln"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-documentation-utils))
      (synopsis "Utilities to destructure Common Lisp lambda forms")
      (description
       "Often times we need to destructure a form definition in a Common Lisp
macro.  This library provides a set of simple utilities to help with that.")
      (home-page "https://shinmera.github.io/form-fiddle/")
      (license license:zlib))))

(define-public cl-form-fiddle
  (sbcl-package->cl-source-package sbcl-form-fiddle))

(define-public ecl-form-fiddle
  (sbcl-package->ecl-package sbcl-form-fiddle))

(define-public clasp-form-fiddle
  (sbcl-package->clasp-package sbcl-form-fiddle))

(define-public sbcl-format-colors
  (let ((commit "fecb1d8c6e7a07ff9f10a7a4eb4c3bd629d4969f")
        (revision "0"))
    (package
      (name "sbcl-format-colors")
      (version (git-version "0.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/vindarel/format-colors")
               (commit commit)))
         (sha256
          (base32 "084ydjhic2dq0gb7wfm6plnjq3l7485hb3yhxl03mm64a6sr3fxv"))
         (file-name (git-file-name "cl-format-colors" version))))
      (build-system asdf-build-system/sbcl)
      (inputs (list sbcl-cl-ansi-text))
      (synopsis "Custom format functions for colorful output")
      (description "This package provides simple format directives to
      print in colors.")
      (home-page "https://github.com/vindarel/format-colors")
      (license license:llgpl))))

(define-public cl-format-colors
  (sbcl-package->cl-source-package sbcl-format-colors))

(define-public ecl-format-colors
  (sbcl-package->ecl-package sbcl-format-colors))

(define-public sbcl-formgrep
  (let ((commit "91238cdbdd0ad815ff5d574d032b4a502febd190")
        (revision "0"))
    (package
      (name "sbcl-formgrep")
      (version (git-version "0.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/death/formgrep")
               (commit commit)))
         (file-name (git-file-name "cl-formgrep" version))
         (sha256
          (base32 "1rqzkmz6nddg5ywvs3v0k8cvxdwas38mfwgbr3rs4fdsbps90k9r"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-alexandria
             sbcl-babel
             sbcl-cl-fad
             sbcl-cl-ppcre
             sbcl-eclector))
      (home-page "https://github.com/death/formgrep")
      (synopsis "Find top-level Lisp forms matching an operator pattern")
      (description
       "This library provides the @code{FORMGREP} function and related
utilities which find top-level Lisp forms matching the regular expression
corresponding to an operator name, returning the matched forms and the names
of the files and the line numbers where they were found.")
      (license license:expat))))

(define-public cl-formgrep
  (sbcl-package->cl-source-package sbcl-formgrep))

(define-public ecl-formgrep
  (sbcl-package->ecl-package sbcl-formgrep))

(define-public sbcl-fset
  (package
    (name "sbcl-fset")
    (version "1.4.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/slburson/fset")
             (commit (string-append "v" version))))
       (file-name (git-file-name "cl-fset" version))
       (sha256
        (base32 "16a3g9av8rvhvnhv5vfq2shim7b7i062wzyz6xwjk9sp9q9bqlva"))))
    (build-system asdf-build-system/sbcl)
    (inputs
     (list sbcl-misc-extensions sbcl-mt19937 sbcl-named-readtables))
    (synopsis "Functional set-theoretic collections library")
    (description
     "FSet is a functional set-theoretic collections library for Common Lisp.
Functional means that all update operations return a new collection rather than
modifying an existing one in place.  Set-theoretic means that collections may
be nested arbitrarily with no additional programmer effort; for instance, sets
may contain sets, maps may be keyed by sets, etc.")
    (home-page "https://common-lisp.net/project/fset/Site/index.html")
    (license license:llgpl)))

(define-public cl-fset
  (sbcl-package->cl-source-package sbcl-fset))

(define-public clasp-fset
  (sbcl-package->clasp-package sbcl-fset))

(define-public ecl-fset
  (package
    (inherit (sbcl-package->ecl-package sbcl-fset))
    (arguments
     ;; Tests fails on ECL with "The function FSET::MAKE-CHAR is undefined".
     '(#:tests? #f))))

(define-public sbcl-function-cache
  (package
    (name "sbcl-function-cache")
    (version "1.0.3")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/AccelerationNet/function-cache")
             (commit "6a5ada401e57da2c8abf046f582029926e61fce8")))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "000vmd3f5rx5hs9nvphfric0gkzaadns31c6mxaslpv0k7pkrmc6"))))
    (build-system asdf-build-system/sbcl)
    (synopsis "Function caching / memoization library for Common Lisp")
    (description
     "A common lisp library that provides extensible function result
caching based on arguments (an expanded form of memoization).")
    (home-page "https://github.com/AccelerationNet/function-cache")
    (license
     (license:non-copyleft
      "https://github.com/AccelerationNet/function-cache/blob/master/README.md"))
    (inputs
     (list sbcl-alexandria
           sbcl-cl-interpol
           sbcl-iterate
           sbcl-symbol-munger
           sbcl-closer-mop))
    (arguments
     `(#:tests? #f))))

(define-public cl-function-cache
  (sbcl-package->cl-source-package sbcl-function-cache))

(define-public ecl-function-cache
  (sbcl-package->ecl-package sbcl-function-cache))

(define-public sbcl-funds
  (let ((commit "39d425818876b898c20780a678803df506df8424")
        (revision "2"))
    (package
      (name "sbcl-funds")
      (version (git-version "1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/charJe/funds")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "13y1jhvnpzrs9daz6f3z67w6h2y21ggb10j3j4vnc5p3m8i7ps4p"))))
      (build-system asdf-build-system/sbcl)
      (synopsis "Purely functional data structure library in Common Lisp")
      (description
       "Funds provides portable, purely functional data structures in Common
Lisp.  It includes tree based implementations for Array, Hash, Queue, Stack, and
Heap.")
      (home-page "https://common-lisp.net/project/funds/")
      (license license:asl2.0))))

(define-public cl-funds
  (sbcl-package->cl-source-package sbcl-funds))

(define-public ecl-funds
  (sbcl-package->ecl-package sbcl-funds))

(define-public sbcl-fuzzy-dates
  (let ((commit "d6a2c229870a633594afc15a07fb16082960dfba")
        (revision "0"))
    (package
      (name "sbcl-fuzzy-dates")
      (version (git-version "1.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/shinmera/fuzzy-dates")
               (commit commit)))
         (file-name (git-file-name "cl-fuzzy-dates" version))
         (sha256
          (base32 "0qaig90b91nrwgxs55c8zaah5iq72rgxw1clmjqw0iilfg5wgllr"))))
      (build-system asdf-build-system/sbcl)
      (native-inputs (list sbcl-parachute))
      (inputs (list sbcl-cl-ppcre
                    sbcl-documentation-utils))
      (home-page "https://github.com/vindarel/fuzzy-dates")
      (synopsis "Fuzzily parse date and time strings")
      (description
       "Library to fuzzily parse time and date strings into a universal-time
timestamp.")
      (license license:zlib))))

(define-public cl-fuzzy-dates
  (sbcl-package->cl-source-package sbcl-fuzzy-dates))

(define-public ecl-fuzzy-dates
  (sbcl-package->ecl-package sbcl-fuzzy-dates))

(define-public clasp-fuzzy-dates
  (sbcl-package->clasp-package sbcl-fuzzy-dates))

(define-public sbcl-fuzzy-match
  (let ((commit "e46ca41ef4641461f7be006782e3cfdcf73ba98a")
        (revision "1"))
    (package
      (name "sbcl-fuzzy-match")
      (version (git-version "0.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/vindarel/fuzzy-match")
               (commit commit)))
         (file-name (git-file-name "cl-fuzzy-match" version))
         (sha256
          (base32 "1lawndmzkl6f9sviy7ngn2s3xkc4akp8l505kvpslaz6qq0ayyqv"))))
      (build-system asdf-build-system/sbcl)
      (inputs (list sbcl-cl-str
                    sbcl-mk-string-metrics))
      (home-page "https://github.com/vindarel/fuzzy-match")
      (synopsis "Common Lisp library for fuzzy matching")
      (description
       "From a string input and a list of candidates, return the most relevant
candidates first.")
      (license license:expat))))

(define-public cl-fuzzy-match
  (sbcl-package->cl-source-package sbcl-fuzzy-match))

(define-public ecl-fuzzy-match
  (sbcl-package->ecl-package sbcl-fuzzy-match))

(define-public sbcl-fxml
  ;; No release.
  (let ((commit "a0e73bb48ef03adea94a55986cc27f522074c8e1"))
    (package
      (name "sbcl-fxml")
      (version (git-version "0.0.0" "1" commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/ruricolist/fxml/")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "1vxdb1cjjqi986f72bggnw1s4yzv12g4li7vn4y49b6lphshr8lm"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-babel
             sbcl-named-readtables
             sbcl-serapeum
             sbcl-quri
             sbcl-flexi-streams
             sbcl-split-sequence
             sbcl-alexandria
             sbcl-trivial-gray-streams))
      (native-inputs
       (list sbcl-fiveam sbcl-cxml sbcl-cxml-rng sbcl-xpath))
      (home-page "https://github.com/ruricolist/fxml")
      (synopsis "XML parser and serializer in Common Lisp")
      (description
       "FXML is a secure-by-default, error-recovering XML parser and serializer.
It is a fork of CXML.

You should use FXML instead of CXML if:
@itemize
@item You are parsing potentially ill-formed XML.
@item You are parsing potentially malicious XML.
@item You need to use Klacks with namespaces.
@end itemize

FXML’s API is very close to CXML's, and for the most part you can refer to the
CXML documentation for usage.")
      (license license:llgpl))))

(define-public cl-fxml
  (sbcl-package->cl-source-package sbcl-fxml))

(define-public sbcl-garbage-pools
  (let ((commit "9a7cb7f48b04197c0495df3b6d2e8395ad13f790")
        (revision "1"))
    (package
      (name "sbcl-garbage-pools")
      (version (git-version "0.1.2" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/archimag/garbage-pools")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "04jqwr6j138him6wc4nrwjzm4lvyj5j31xqab02nkf8h9hmsf5v1"))))
      (build-system asdf-build-system/sbcl)
      (home-page "https://github.com/archimag/garbage-pools")
      (synopsis "Resource management pools for Common Lisp")
      (description "GARBAGE-POOLS is Common Lisp re-implementation of the APR
Pools for resource management.")
      (license license:expat))))

(define-public cl-garbage-pools
  (sbcl-package->cl-source-package sbcl-garbage-pools))

(define-public ecl-garbage-pools
  (sbcl-package->ecl-package sbcl-garbage-pools))

(define-public sbcl-geco
  (let ((commit "db13c9384491092975f46f6a837ccdc04681a93a")
        (revision "1"))
    (package
      (name "sbcl-geco")
      (version (git-version "2.1.2" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/gpwwjr/GECO")
               (commit commit)))
         (file-name (git-file-name "cl-geco" version))
         (sha256
          (base32 "1ncaf9ab7jz59zmga0p97blsjjb1m6db0qih57wipfhqdb5ylz17"))))
      (build-system asdf-build-system/sbcl)
      (home-page "https://github.com/gpwwjr/GECO")
      (synopsis "Genetic algorithm toolkit for Common Lisp")
      (description
       "GECO (Genetic Evolution through Combination of Objects) is an
extensible, object-oriented framework for prototyping genetic algorithms in
Common Lisp.")
      (license license:lgpl2.0+))))

(define-public cl-geco
  (sbcl-package->cl-source-package sbcl-geco))

(define-public ecl-geco
  (sbcl-package->ecl-package sbcl-geco))

(define-public sbcl-generic-cl
  (package
    (name "sbcl-generic-cl")
    (version "0.9")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/alex-gutev/generic-cl")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "1c40vqb49g0adfv17jxgk0ds1n6a2dph30cibq01sicmqdgrrbi8"))))
    (build-system asdf-build-system/sbcl)
    (arguments
     ;; Tests fail because SBCL head size is not high enough.
     ;; https://github.com/alex-gutev/generic-cl/issues/6
     `(#:tests? #f))
    (inputs
     (list sbcl-agutil
           sbcl-alexandria
           sbcl-anaphora
           sbcl-arrows
           sbcl-cl-form-types
           sbcl-custom-hash-table
           sbcl-static-dispatch
           sbcl-trivia))
    (native-inputs
     (list sbcl-prove))
    (home-page "https://alex-gutev.github.io/generic-cl/")
    (synopsis "Generic function interface to standard Common Lisp functions")
    (description "@code{generic-cl} provides a generic function wrapper over
various functions in the Common Lisp standard, such as equality predicates and
sequence operations.  The goal of this wrapper is to provide a standard
interface to common operations, such as testing for the equality of two
objects, which is extensible to user-defined types.")
    (license license:expat)))

(define-public cl-generic-cl
  (sbcl-package->cl-source-package sbcl-generic-cl))

(define-public ecl-generic-cl
  (sbcl-package->ecl-package sbcl-generic-cl))

(define-public sbcl-generic-comparability
  (let ((commit "53fc2846319a6eb46b36581e203e1f1542a8acff")
        (revision "1"))
    (package
      (name "sbcl-generic-comparability")
      (version (git-version "1.0.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/pnathan/generic-comparability")
               (commit commit)))
         (file-name (git-file-name "generic-comparability" version))
         (sha256
          (base32 "01ma0cwirxarwwmdwflnh8kmysmr2smh5kyvzhb2074ljxg8yq2p"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-alexandria))
      (native-inputs
       (list sbcl-fiveam))
      (home-page "https://github.com/pnathan/generic-comparability")
      (synopsis "Implementation of cdr-8")
      (description
        "GENERIC-COMPARABILITY is an implementation of CDR-8 (Generic Equality
and Comparison for Common Lisp).  CDR-8 provides an interface for the EQUALS
function, which is defined as a general equality predicate, as well as a set of
ordering (COMPARE) functions for comparison.  The semantics are described in
the CDR-8 standard.")
      (license license:llgpl))))

(define-public cl-generic-comparability
  (sbcl-package->cl-source-package sbcl-generic-comparability))

(define-public ecl-generic-comparability
  (sbcl-package->ecl-package sbcl-generic-comparability))

(define-public sbcl-geneva
  (let ((commit "126d330aec6c3b1cba212387888c738bf7196dec")
        (revision "0"))
    (package
      (name "sbcl-geneva")
      (version (git-version "0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/eugeneia/geneva")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "1pw18xkbndqssx6iix8a8zcw8bgjh88jxxxrklkgkghk04bmqxw3"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-split-sequence
             sbcl-named-readtables))
      (home-page "https://github.com/eugeneia/geneva")
      (synopsis "Portable document preparation system")
      (description "Portable document preparation system.")
      (license license:agpl1))))

(define-public ecl-geneva
  (sbcl-package->ecl-package sbcl-geneva))

(define-public cl-geneva
  (sbcl-package->cl-source-package sbcl-geneva))

(define-public sbcl-genhash
  (let ((commit "220ae1af8361dbd2005177f2ee11072b6a33934f")
        (revision "1"))
    (package
      (name "sbcl-genhash")
      (version (git-version "1.7" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/pnathan/genhash")
               (commit commit)))
         (file-name (git-file-name "cl-genhash" version))
         (sha256
          (base32 "1jnk1fix1zydhy0kn3cvlp6dy0241x7v8ahq001nlr6v152z1cwk"))))
      (build-system asdf-build-system/sbcl)
      (home-page "https://github.com/pnathan/genhash")
      (synopsis "Generic hash tables for Common Lisp")
      (description
       "This an implementation of CDR 2: generic hash tables for Common Lisp")
      (license license:public-domain))))

(define-public cl-genhash
  (sbcl-package->cl-source-package sbcl-genhash))

(define-public ecl-genhash
  (sbcl-package->ecl-package sbcl-genhash))

(define-public sbcl-germinal
  (let ((commit "5bfb371ea57dae8985c0e1c6f184f0338487d684")
        (revision "0"))
    (package
      (name "sbcl-germinal")
      (version (git-version "1.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://git.carcosa.net/jmcbray/germinal")
               (commit commit)))
         (file-name (git-file-name "cl-germinal" version))
         (sha256
          (base32 "12jypa8m10825lp5yxfcm1fyk3r4ziwcri7ndxa0m5dz0y7hggck"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-alexandria
             sbcl-babel
             sbcl-bordeaux-threads
             sbcl-cl+ssl
             sbcl-cl-fad
             sbcl-cl-interpol
             sbcl-cl-ppcre
             sbcl-cl-str
             sbcl-local-time
             sbcl-osicat
             sbcl-ppath
             sbcl-quri
             sbcl-trivial-mimes
             sbcl-uax-15
             sbcl-usocket))
      (home-page "https://git.carcosa.net/jmcbray/germinal")
      (synopsis "Gemini protocol server")
      (description "Germinal is a server for the Gemini protocol, written in
Common Lisp.")
      (license license:agpl3))))

(define-public cl-germinal
  (sbcl-package->cl-source-package sbcl-germinal))

(define-public ecl-germinal
  (sbcl-package->ecl-package sbcl-germinal))

(define-public sbcl-gettext
  (let ((commit "a432020cbad99fc22cbe6bb9aa8a83a35000d7aa")
        (revision "1"))
    (package
      (name "sbcl-gettext")
      (version (git-version "0.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/rotatef/gettext")
               (commit commit)))
         (file-name (git-file-name "gettext" version))
         (sha256
          (base32 "1pzhamgni6k5hi6bbvlb3dm659pcllrrr3vhhn3rpjn238zxg5ar"))))
      (build-system asdf-build-system/sbcl)
      (native-inputs
       (list sbcl-stefil))
      (inputs
       (list sbcl-flexi-streams sbcl-split-sequence sbcl-cl-yacc))
      (home-page "https://github.com/rotatef/gettext")
      (synopsis "Common Lisp implementation of Gettext")
      (description
       "This package provides GNU @code{gettext} completely implemented in
Common Lisp without any C library bindings.")
      (license license:lgpl3+))))

(define-public cl-gettext
  (sbcl-package->cl-source-package sbcl-gettext))

(define-public ecl-gettext
  (sbcl-package->ecl-package sbcl-gettext))

(define-public sbcl-glkit
  (let ((commit "0d8e7c5fed4231f2177afcf0f3ff66f196ed6a46"))
    (package
      (name "sbcl-glkit")
      (version (git-version "0.0" "1" commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/lispgames/glkit/")
               (commit commit)))
         (file-name (git-file-name "cl-glkit" version))
         (sha256
          (base32 "1x3y5jcr1f0v9sgn3y5b7b8fhgd6vv37nz73016gdwh511idi8jn"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-alexandria
             sbcl-cl-opengl
             sbcl-defpackage-plus
             sbcl-mathkit
             sbcl-sb-cga
             sbcl-sdl2
             sbcl-static-vectors))
      (home-page "https://github.com/lispgames/glkit/")
      (synopsis "OpenGL utilities for math, shaders, and more")
      (description
       "This is a utility kit for functionality related to OpenGL.  It provides the following:

@itemize
@item @code{kit.glm}: This re-exports @code{sb-cga} and @code{mathkit} for
convenience.
@item @code{kit.gl.shader}: This provides shader dictionary and compilation
functionality similar to what was originally found in @code{sdl2kit}.
@item @code{kit.gl.vao}: This provides an interface for Vertex Array Objects.
@end itemize\n")
      (license license:expat))))

(define-public cl-glkit
  (sbcl-package->cl-source-package sbcl-glkit))

(define-public ecl-glkit
  (sbcl-package->ecl-package sbcl-glkit))

(define-public sbcl-global-vars
  (let ((commit "c749f32c9b606a1457daa47d59630708ac0c266e")
        (revision "0"))
    (package
      (name "sbcl-global-vars")
      (version (git-version "1.0.0" revision commit))
      (home-page "https://github.com/lmj/global-vars")
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url home-page)
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "06m3xc8l3pgsapl8fvsi9wf6y46zs75cp9zn7zh6dc65v4s5wz3d"))))
      (build-system asdf-build-system/sbcl)
      (synopsis "Efficient global variables in Common Lisp")
      (description
       "In Common Lisp, a special variable that is never dynamically bound
typically serves as a stand-in for a global variable.  The @code{global-vars}
library provides true global variables that are implemented by some compilers.
An attempt to rebind a global variable properly results in a compiler error.
That is, a global variable cannot be dynamically bound.

Global variables therefore allow us to communicate an intended usage that
differs from special variables.  Global variables are also more efficient than
special variables, especially in the presence of threads.")
      (license license:expat))))

(define-public cl-global-vars
  (sbcl-package->cl-source-package sbcl-global-vars))

(define-public ecl-global-vars
  (sbcl-package->ecl-package sbcl-global-vars))

(define-public clasp-global-vars
  (sbcl-package->clasp-package sbcl-global-vars))

(define-public sbcl-glop
  (let ((commit "45e722ab4a0cd2944d550bf790206b3326041e38")
        (revision "1"))
    (package
      (name "sbcl-glop")
      (version (git-version "0.1.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/lispgames/glop")
               (commit commit)))
         (file-name (git-file-name "glop" version))
         (sha256
          (base32 "1nm35kvigflfjlmsa8zwdajc61f02fh4sq08jv0wnqylhx8yg2bv"))))
      (build-system asdf-build-system/sbcl)
      (arguments
       (list #:phases
             #~(modify-phases %standard-phases
                 (add-after 'unpack 'patch-lib-paths
                   (lambda* (#:key inputs #:allow-other-keys)
                     (substitute* "src/x11/xcomposite.lisp"
                       (("libXcomposite.so")
                        (search-input-file inputs "/lib/libXcomposite.so")))
                     (substitute* "src/x11/xlib.lisp"
                       (("libX11")
                        (string-drop-right
                         (search-input-file inputs "/lib/libX11.so") 3)))
                     (substitute* "src/utils.lisp"
                       (("libX11")
                        (string-drop-right
                         (search-input-file inputs "/lib/libX11.so") 3)))
                     (substitute* "src/utils.lisp"
                       (("libGL.so")
                        (search-input-file inputs "/lib/libGL.so.1")))
                     (substitute* "src/x11/glx.lisp"
                       (("libGL.so")
                        (search-input-file inputs "/lib/libGL.so")))
                     (substitute* "src/x11/display-ctrl.lisp"
                       (("libXrandr")
                        (string-drop-right
                         (search-input-file inputs "/lib/libXrandr.so") 3))))))))
      (native-inputs
       (list sbcl-cl-opengl))
      (inputs
       (list libx11
             libxcomposite
             libxrandr
             mesa
             sbcl-cffi
             sbcl-split-sequence
             sbcl-trivial-garbage))
      (home-page "https://github.com/lispgames/glop")
      (synopsis "Direct FFI bindings for OpenGL window and context management")
      (description
       "This package provides Common Lisp bindings to create OpenGL window and
context manipulation code as well as system input handling.  Direct FFI
bindings to system functions are used so no third party C lib is required
except system libraries.")
      (license license:expat))))

(define-public cl-glop
  (sbcl-package->cl-source-package sbcl-glop))

(define-public ecl-glop
  (sbcl-package->ecl-package sbcl-glop))

(define-public sbcl-glsl-packing
  (let ((commit "03628159468a8e5b7f2a1d5e78b77053e136794a")
        (revision "1"))
    (package
      (name "sbcl-glsl-packing")
      (version (git-version "0.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/3b/glsl-packing/")
               (commit commit)))
         (file-name (git-file-name "glsl-packing" version))
         (sha256
          (base32 "0k2f1771wd9kdrcasldy1r00k5bdgi9fd07in52zmjggc0i7dd80"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-alexandria))
      (home-page "https://github.com/3b/glsl-packing/")
      (synopsis "Common Lisp utilities to calculate OpenGL layouts")
      (description
       "This is a Common Lisp library to calculate std140 or std430 layouts for
a glsl UBO/SSBO.")
      (license license:expat))))

(define-public cl-glsl-packing
  (sbcl-package->cl-source-package sbcl-glsl-packing))

(define-public ecl-glsl-packing
  (sbcl-package->ecl-package sbcl-glsl-packing))

(define-public clasp-glsl-packing
  (sbcl-package->clasp-package sbcl-glsl-packing))

(define-public sbcl-glsl-spec
  (let ((commit "f04476f7da89355ae6856b33283c60ba95c6555d")
        (revision "1"))
    (package
      (name "sbcl-glsl-spec")
      (version (git-version "0.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/cbaggers/glsl-spec")
               (commit commit)))
         (file-name (git-file-name "glsl-spec" version))
         (sha256
          (base32 "01ipspr22fgfj3w8wq2y81lzrjc4vpfiwnr3dqhjlpzzra46am8c"))))
      (build-system asdf-build-system/sbcl)
      (arguments
       `(#:asd-systems '("glsl-spec" "glsl-symbols" "glsl-docs")))
      (home-page "https://github.com/cbaggers/glsl-spec")
      (synopsis "Common Lisp GLSL specification as a datastructure")
      (description
       "This package contains the specification of all functions and variables
from GLSL as data.")
      (license license:unlicense))))

(define-public cl-glsl-spec
  (sbcl-package->cl-source-package sbcl-glsl-spec))

(define-public ecl-glsl-spec
  (sbcl-package->ecl-package sbcl-glsl-spec))

(define-public clasp-glsl-spec
  (sbcl-package->clasp-package sbcl-glsl-spec))

(define-public sbcl-glsl-toolkit
  (let ((commit "4c4889e75c635772c4df70b11d6f14e7a596da43")
        (revision "2"))
    (package
      (name "sbcl-glsl-toolkit")
      (version (git-version "1.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/Shirakumo/glsl-toolkit")
               (commit commit)))
         (file-name (git-file-name "cl-glsl-toolkit" version))
         (sha256
          (base32 "0vrk8nqijqdi1rwf85rhd93yj7q8qkxnigxn3bw0cbrzvzrks9rl"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-cl-ppcre sbcl-documentation-utils sbcl-parse-float
             sbcl-trivial-indent))
      (home-page "https://shirakumo.github.io/glsl-toolkit/")
      (synopsis "Parser for OpenGL Shader Language source files")
      (description
       "This package provides Common Lisp system collecting tools written to
wrangle OpenGL Shader Language (GLSL) source files.")
      (license license:zlib))))

(define-public cl-glsl-toolkit
  (sbcl-package->cl-source-package sbcl-glsl-toolkit))

(define-public ecl-glsl-toolkit
  (sbcl-package->ecl-package sbcl-glsl-toolkit))

(define-public sbcl-glyphs
  (let ((commit "1ff5714e8c1dca327bc604dfe3e3d1f4b7755373"))
    (package
      (name "sbcl-glyphs")
      (version (git-version "0.0.0" "1" commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/ahungry/glyphs/")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "17kai1anbkk5dj5sbrsin2fc019cmcbglb900db60v38myj0y0wf"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-cl-ppcre sbcl-parenscript sbcl-named-readtables))
      (home-page "https://github.com/ahungry/glyphs/")
      (synopsis "Reduce Common Lisp verbosity")
      (description
       "This library is a little experiment in reducing verbosity in Common
Lisp, inspired by BODOL (@url{https://github.com/bodil/BODOL}).")
      (license license:gpl3))))

(define-public cl-glyphs
  (sbcl-package->cl-source-package sbcl-glyphs))

(define-public ecl-glyphs
  (sbcl-package->ecl-package sbcl-glyphs))

(define-public sbcl-golden-utils
  (let ((commit "e43914ad2bdb0c8e1b1f10ef591aafc3c55b89e7")
        (revision "4"))
    (package
      (name "sbcl-golden-utils")
      (version (git-version "0.0.0" revision commit))
      (home-page "https://github.com/lisp-mirror/golden-utils")
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url home-page)
               (commit commit)))
         (file-name (git-file-name "cl-golden-utils" version))
         (sha256
          (base32 "09vq29wjr3x7h3fshwxg8h1psy4p73yl61cjljarpqjhsgz7lmbp"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-alexandria))
      (synopsis "Common Lisp utility library")
      (description
       "This is a Common Lisp library providing various utilities.")
      (license license:expat))))

(define-public cl-golden-utils
  (sbcl-package->cl-source-package sbcl-golden-utils))

(define-public ecl-golden-utils
  (sbcl-package->ecl-package sbcl-golden-utils))

(define-public clasp-golden-utils
  (sbcl-package->clasp-package sbcl-golden-utils))

(define-public sbcl-graph
  (let ((commit "78bf9ec930d8eae4f0861b5be76765fb1e45e24f")
        (revision "0"))
    (package
      (name "sbcl-graph")
      (version (git-version "0.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri
          (git-reference
           (url "https://github.com/eschulte/graph")
           (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "1qpij4xh8bqwc2myahpilcbh916v7vg0acz2fij14d3y0jm02h0g"))))
      (build-system asdf-build-system/sbcl)
      (native-inputs
       (list sbcl-stefil))
      (inputs
       `(("alexandria" ,sbcl-alexandria)
         ("cl-heap" ,sbcl-cl-heap)
         ("cl-ppcre" ,sbcl-cl-ppcre)
         ("curry-compose-reader-macros" ,sbcl-curry-compose-reader-macros)
         ("metabang-bind" ,sbcl-metabang-bind)
         ("named-readtables" ,sbcl-named-readtables)
         ("yason" ,sbcl-yason)))
      (arguments
       '(#:asd-systems '("graph"
                         "graph/dot"
                         "graph/json")))
      (synopsis "Graph data structure and algorithms for Common Lisp")
      (description
       "The GRAPH Common Lisp library provides a data structures to represent
graphs, as well as some graph manipulation and analysis algorithms (shortest
path, maximum flow, minimum spanning tree, etc.).")
      (home-page "https://eschulte.github.io/graph/")
      (license license:gpl3+))))

(define-public cl-graph
  (sbcl-package->cl-source-package sbcl-graph))

(define-public ecl-graph
  (sbcl-package->ecl-package sbcl-graph))

(define-public sbcl-green-threads
  (let ((commit "fff5ebecb441a37e5c511773716aafd84a3c5840")
        (revision "1"))
    (package
      (name "sbcl-green-threads")
      (version (git-version "0.3" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/thezerobit/green-threads")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "1czw7nr0dwfps76h8hjvglk1wdh53yqbfbvv30whwbgqx33iippz"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       `(("cl-async-future" ,sbcl-cl-async-future)
         ("cl-cont" ,sbcl-cl-cont)))
      (native-inputs
       (list sbcl-prove))
      (arguments
       `(;; TODO: Fix the tests. They fail with:
         ;; "The function BLACKBIRD::PROMISE-VALUES is undefined"
         #:tests? #f
         #:phases
         (modify-phases %standard-phases
           (add-after 'unpack 'fix-tests
             (lambda _
               (substitute* "green-threads-test.asd"
                 (("cl-test-more")
                  "prove"))
               #t)))))
      (synopsis "Cooperative multitasking library for Common Lisp")
      (description
       "This library allows for cooperative multitasking with help of cl-cont
for continuations.  It tries to mimic the API of bordeaux-threads as much as
possible.")
      (home-page "https://github.com/thezerobit/green-threads")
      (license license:bsd-3))))

(define-public cl-green-threads
  (sbcl-package->cl-source-package sbcl-green-threads))

(define-public ecl-green-threads
  (sbcl-package->ecl-package sbcl-green-threads))

(define-public sbcl-gsll
  (let ((commit "1a8ada22f9cf5ed7372d352b2317f4ccdb6ab308")
        (revision "1"))
    (package
      (name "sbcl-gsll")
      (version (git-version "0.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://gitlab.common-lisp.net/antik/gsll.git")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "0z5nypfk26hxihb08p085644afawicrgb4xvadh3lmrn46qbjfn4"))))
      (build-system asdf-build-system/sbcl)
      (native-inputs
       (list sbcl-lisp-unit))
      (inputs
       `(("alexandria" ,sbcl-alexandria)
         ("antik-base" ,sbcl-antik-base)
         ("cffi" ,sbcl-cffi)
         ("gsl" ,gsl)
         ("metabang-bind" ,sbcl-metabang-bind)
         ("trivial-features" ,sbcl-trivial-features)
         ("trivial-garbage" ,sbcl-trivial-garbage)))
      (arguments
       `(#:tests? #f
         #:phases
         (modify-phases %standard-phases
           (add-after 'unpack 'fix-cffi-paths
             (lambda* (#:key inputs #:allow-other-keys)
               (substitute* "gsll.asd"
                 ((":depends-on \\(#:foreign-array")
                  ":depends-on (#:foreign-array #:cffi-libffi"))
               (substitute* "init/init.lisp"
                 (("libgslcblas.so" all)
                  (string-append
                   (assoc-ref inputs "gsl") "/lib/" all)))
               (substitute* "init/init.lisp"
                 (("libgsl.so" all)
                  (string-append
                   (assoc-ref inputs "gsl") "/lib/" all))))))))
      (synopsis "GNU Scientific Library for Lisp")
      (description
       "The GNU Scientific Library for Lisp (GSLL) allows the use of the
GNU Scientific Library (GSL) from Common Lisp.  This library provides a
full range of common mathematical operations useful to scientific and
engineering applications.  The design of the GSLL interface is such
that access to most of the GSL library is possible in a Lisp-natural
way; the intent is that the user not be hampered by the restrictions
of the C language in which GSL has been written.  GSLL thus provides
interactive use of GSL for getting quick answers, even for someone not
intending to program in Lisp.")
      (home-page "https://common-lisp.net/project/gsll/")
      (license license:gpl3))))

(define-public cl-gsll
  (sbcl-package->cl-source-package sbcl-gsll))

(define-public ecl-gsll
  (sbcl-package->ecl-package sbcl-gsll))

(define-public sbcl-gtwiwtg
  (package
    (name "sbcl-gtwiwtg")
    (version "0.1.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/cbeo/gtwiwtg/")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0lkraw0dwh4is4x5sp5rjrw6f93m0gr9849abrbi12s25ws7jbw4"))))
    (build-system asdf-build-system/sbcl)
    (native-inputs
     (list sbcl-osicat sbcl-prove))
    (home-page "https://github.com/cbeo/gtwiwtg/")
    (synopsis "Naive generators for Common Lisp")
    (description
     "The GTWIWTG library (Generators The Way I Want Them Generated --
technically not generators, but iterators) is meant to be small, explorable,
and understandable.")
    (license license:gpl3)))

(define-public cl-gtwiwtg
  (sbcl-package->cl-source-package sbcl-gtwiwtg))

(define-public ecl-gtwiwtg
  (sbcl-package->ecl-package sbcl-gtwiwtg))

(define-public sbcl-gtype
  (let ((commit "2442e32485635525af278ebd8fa69a27d5b8cf18")
        (revision "2"))
    (package
      (name "sbcl-gtype")
      (version (git-version "0.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/numcl/gtype")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "0hbkfdw00v7bsa6zbric34p5w6hfwxycccg8wc2faq0cxhsvpv9h"))))
      (build-system asdf-build-system/sbcl)
      (synopsis "C++/Julia-like parametric types in Common Lisp")
      (description
       "Support library for numcl that provides Julia-like runtime parametric
type correctness in Common Lisp.  It is based on CLtL2 extensions.")
      (home-page "https://github.com/numcl/gtype")
      (license license:lgpl3+)
      (inputs
       `(("trivialib.type-unify" ,sbcl-trivialib-type-unify)
         ("trivial-cltl2" ,sbcl-trivial-cltl2)
         ("trivia" ,sbcl-trivia)
         ("alexandria" ,sbcl-alexandria)
         ("iterate" ,sbcl-iterate)
         ("type-r" ,sbcl-type-r)))
      (native-inputs
       (list sbcl-fiveam)))))

(define-public cl-gtype
  (sbcl-package->cl-source-package sbcl-gtype))

(define-public ecl-gtype
  (let ((pkg (sbcl-package->ecl-package sbcl-gtype)))
    (package
      (inherit pkg)
      (arguments
       (substitute-keyword-arguments (package-arguments pkg)
         ;; The tests fail on ECL with a COMPILE-FILE-ERROR for t/package.lisp.
         ((#:tests? _ #f) #f))))))

(define-public sbcl-harmony
  (let ((commit "0b57483cc0341936c201b620f82a8542c606991f")
        (revision "0"))
    (package
      (name "sbcl-harmony")
      (version (git-version "2.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/Shirakumo/harmony")
               (commit commit)))
         (file-name (git-file-name "cl-harmony" version))
         (sha256
          (base32 "0pqmfi3yi3gi7b7dyayrb621hp60rn7hasq0cl0fis3vg0fp5dja"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-atomics
             sbcl-bordeaux-threads
             sbcl-cl-mixed
             sbcl-stealth-mixin
             sbcl-trivial-features))
      (home-page "https://shirakumo.github.io/harmony/")
      (synopsis "Common Lisp sound server and sound processing library")
      (description
       "HARMONY is a library that provides you with audio processing tools as
well as an audio server to play back music, sfx, and so forth.  It is most
suited for use in a game engine, but may feasibly also be used for more
advanced things such as a DAW")
      (license license:zlib))))

(define-public cl-harmony
  (sbcl-package->cl-source-package sbcl-harmony))

(define-public ecl-harmony
  (sbcl-package->ecl-package sbcl-harmony))

(define-public sbcl-hash-set
  (let ((commit "6feb20de457f14e24a83815be1097aa02cca5986")
        (revision "0"))
    (package
      (name "sbcl-hash-set")
      (version (git-version "0.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/samebchase/hash-set")
               (commit commit)))
         (file-name (git-file-name "cl-hash-set" version))
         (sha256
          (base32 "0a966y9yfarhmki4wwzg371ziaygnp13yc6r13w9zz327fkhz8na"))))
      (build-system asdf-build-system/sbcl)
      (native-inputs (list sbcl-fiveam))
      (inputs (list sbcl-alexandria))
      (home-page "https://github.com/samebchase/hash-set/")
      (synopsis "Implementation of a hash-set")
      (description "This package provides an implementation of the
hash-set data structure.  It has constant time lookup, insertion and
deletion.")
      (license license:unlicense))))

(define-public cl-hash-set
  (sbcl-package->cl-source-package sbcl-hash-set))

(define-public ecl-hash-set
  (sbcl-package->ecl-package sbcl-hash-set))

(define-public sbcl-hdf5-cffi
  (let ((commit "5b5c88f191e470e4fe96b462334e3ce0806eed5c")
        (revision "1"))
    (package
      (name "sbcl-hdf5-cffi")
      (version (git-version "1.8.18" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/hdfgroup/hdf5-cffi")
               (commit commit)))
         (file-name (git-file-name "cl-hdf5-cffi" version))
         (sha256
          (base32 "0vda3075423xz83qky998lpac5b04dwfv7bwgh9jq8cs5v0zrxjf"))))
      (build-system asdf-build-system/sbcl)
      (synopsis "Common Lisp bindings for the HDF5 library")
      (description
       "@code{hdf5-cffi} is a CFFI wrapper for the HDF5 library.")
      (home-page "https://github.com/hdfgroup/hdf5-cffi")
      (license (license:non-copyleft
                (string-append "https://github.com/HDFGroup/hdf5-cffi/raw/"
                               commit
                               "/LICENSE")))
      (inputs
       (list hdf5 sbcl-cffi))
      (native-inputs
       (list sbcl-fiveam))
      (arguments
       (list #:phases
             #~(modify-phases %standard-phases
                 (add-after 'unpack 'fix-paths
                   (lambda* (#:key inputs #:allow-other-keys)
                     (substitute* "src/library.lisp"
                       (("libhdf5.so")
                        (search-input-file inputs "/lib/libhdf5.so")))))
                 (add-after 'fix-paths 'fix-newer-hdf5-compatibility
                   (lambda _
                     (substitute* (list "src/h5-grovel.lisp"
                                        "src/h5a-grovel.lisp"
                                        "src/h5d-grovel.lisp"
                                        "src/h5f-grovel.lisp"
                                        "src/h5g-grovel.lisp"
                                        "src/h5i-grovel.lisp"
                                        "src/h5l-grovel.lisp"
                                        "src/h5o-grovel.lisp"
                                        "src/h5p-grovel.lisp"
                                        "src/h5pl-grovel.lisp"
                                        "src/h5r-grovel.lisp"
                                        "src/h5s-grovel.lisp"
                                        "src/h5t-grovel.lisp"
                                        "src/h5z-grovel.lisp")
                       (("_H5private_H")
                        "H5private_H")
                       (("\\(\\(:H5I-REFERENCE   \"H5I_REFERENCE\"\\)\\)")
                        ""))))
                 (add-after 'unpack 'fix-dependencies
                   (lambda* (#:key inputs #:allow-other-keys)
                     (substitute* "hdf5-cffi.asd"
                       ((":depends-on \\(:cffi\\)")
                        ":depends-on (:cffi :cffi-grovel)"))
                     (substitute* "hdf5-cffi.test.asd"
                       ((":depends-on \\(:cffi :hdf5-cffi")
                        ":depends-on (:cffi :cffi-grovel :hdf5-cffi"))))))))))

(define-public cl-hdf5-cffi
  (sbcl-package->cl-source-package sbcl-hdf5-cffi))

(define-public ecl-hdf5-cffi
  (sbcl-package->ecl-package sbcl-hdf5-cffi))

(define-public sbcl-helambdap
  (let ((commit "5bf65f57a36ee094cadb096caca6e90eb3ba46c4")
        (revision "0"))
    (package
      (name "sbcl-helambdap")
      (version (git-version "20220103" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://git.code.sf.net/p/helambdap/code")
               (commit commit)))
         (file-name (git-file-name "cl-helambdap" version))
         (sha256
          (base32 "1kzapbf9l2bw8i9m9sxv0dfnkksrxq81d5hbn34pm25abk0i937j"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-cl-fad
             sbcl-clad
             sbcl-split-sequence
             sbcl-xhtmlambda))
      (synopsis "Common Lisp documentation system")
      (description "HELambdap is a Common Lisp documentation system which
strives to be simple to use, yet easily customizable.")
      (home-page "https://helambdap.sourceforge.net")
      (license license:expat))))

(define-public cl-helambdap
  (sbcl-package->cl-source-package sbcl-helambdap))

(define-public sbcl-history-tree
  (package
    (name "sbcl-history-tree")
    (version "0.1.2")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/atlas-engineer/history-tree")
             (commit version)))
       (file-name (git-file-name "cl-history-tree" version))
       (sha256
        (base32 "1n3q6aqh0wm24pksj8371j5iinxpzy2kcnz97kmpndm1yhv4x5f2"))))
    (build-system asdf-build-system/sbcl)
    (inputs
     (list
      sbcl-alexandria
      sbcl-custom-hash-table
      sbcl-local-time
      sbcl-nclasses
      sbcl-trivial-package-local-nicknames))
    (native-inputs (list sbcl-lisp-unit2))
    (home-page "https://github.com/atlas-engineer/history-tree")
    (synopsis "Store the history of a browser's visited paths")
    (description
     "This data structure can be used to store the history of visited paths or
URLs with a file or web browser, in a way that no “forward” element is ever
forgotten.

The history tree is “global” in the sense that multiple owners (e.g. tabs) can
have overlapping histories.  On top of that, an owner can spawn another one,
starting from one of its nodes (typically when you open a URL in a new tab).")
    (license license:bsd-3)))

(define-public cl-history-tree
  (sbcl-package->cl-source-package sbcl-history-tree))

(define-public ecl-history-tree
  (sbcl-package->ecl-package sbcl-history-tree))

(define-public sbcl-html-encode
  (package
    (name "sbcl-html-encode")
    (version "1.2")
    (source
     (origin
       (method url-fetch)
       (uri (string-append
             "http://beta.quicklisp.org/archive/html-encode/2010-10-06/html-encode-"
             version ".tgz"))
       (sha256
        (base32
         "06mf8wn95yf5swhmzk4vp0xr4ylfl33dgfknkabbkd8n6jns8gcf"))))
    (build-system asdf-build-system/sbcl)
    (synopsis "Common Lisp library for encoding text in various web-savvy encodings")
    (description
     "A library for encoding text in various web-savvy encodings.")
    (home-page "https://quickdocs.org/html-encode/")
    (license license:expat)))

(define-public cl-html-encode
  (sbcl-package->cl-source-package sbcl-html-encode))

(define-public ecl-html-encode
  (sbcl-package->ecl-package sbcl-html-encode))

(define-public clasp-html-encode
  (sbcl-package->clasp-package sbcl-html-encode))

(define-public sbcl-html-entities
  (let ((commit "4af018048e891f41d77e7d680ed3aeb639e1eedb"))
    (package
      (name "sbcl-html-entities")
      (version (git-version "0.02" "1" commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/BnMcGn/html-entities/")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "1b2yl6lf6vis17y4n5s505p7ica96bdafcl6vydy1hg50fy33nfr"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-cl-ppcre))
      (native-inputs
       (list sbcl-fiveam))
      (home-page "https://github.com/BnMcGn/html-entities/")
      (synopsis "Encode and decode entities in HTML with Common Lisp")
      (description "Html-entities is a Common Lisp library that lets you
encode and decode entities in HTML.")
      (license license:expat))))

(define-public cl-html-entities
  (sbcl-package->cl-source-package sbcl-html-entities))

(define-public ecl-html-entities
  (sbcl-package->ecl-package sbcl-html-entities))

(define-public sbcl-html-template
  (package
    (name "sbcl-html-template")
    (version "0.9.2")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/edicl/html-template")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0wz3czvjsn4x971dsiia9f9nvvcmbkablcl75zsvxndkimc93wxb"))))
    (build-system asdf-build-system/sbcl)
    (home-page "https://edicl.github.io/html-template/")
    (synopsis "HTML templates from Common Lisp")
    (description
     "HTML-TEMPLATE is a Common Lisp library which can be used to fill
templates with arbitrary (string) values at runtime.  The result does not have
to be HTML.

It is loosely modeled after the Perl module @code{HTML::Template} and
partially compatible with a its syntax, though both libraries contain some
extensions that the other does not support.

HTML-TEMPLATE translates templates into efficient closures which can be
re-used as often as needed.  It uses a cache mechanism so you can update
templates while your program is running and have the changes take effect
immediately.")
    (license license:bsd-2)))

(define-public cl-html-template
  (sbcl-package->cl-source-package sbcl-html-template))

(define-public ecl-html-template
  (sbcl-package->ecl-package sbcl-html-template))

(define-public clasp-html-template
  (sbcl-package->clasp-package sbcl-html-template))

(define-public sbcl-http-body
  (let ((commit "3e4bedd6a9d9bc4e1dc0a45e5b55360ae30fd388")
        (revision "2"))
    (package
     (name "sbcl-http-body")
     (version (git-version "0.1.0" revision commit))
     (source
      (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/fukamachi/http-body")
             (commit commit)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0kcg43l5674drzid9cj938q0ki5z25glx296rl239dm7yfmxlzz2"))))
     (build-system asdf-build-system/sbcl)
     (arguments
      '(#:asd-systems '("http-body-test" "http-body")))
     (native-inputs
      (list sbcl-assoc-utils sbcl-prove sbcl-trivial-utf-8))
     (inputs
      (list sbcl-babel
            sbcl-cl-ppcre
            sbcl-fast-http
            sbcl-flexi-streams
            sbcl-jonathan
            sbcl-trivial-gray-streams
            sbcl-cl-utilities
            sbcl-quri))
     (home-page "https://github.com/fukamachi/http-body")
     (synopsis "HTTP POST data parser")
     (description
      "HTTP-Body parses HTTP POST data and returns POST parameters.  It
supports application/x-www-form-urlencoded, application/json, and
multipart/form-data.")
     (license license:bsd-2))))

(define-public cl-http-body
  (sbcl-package->cl-source-package sbcl-http-body))

(define-public ecl-http-body
  (sbcl-package->ecl-package sbcl-http-body))

(define-public sbcl-hu.dwim.asdf
  (let ((commit "67cdf84390e530af4303cc4bc815fdf2a5e48f59"))
    (package
      (name "sbcl-hu.dwim.asdf")
      (version "20200724")
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/hu-dwim/hu.dwim.asdf")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "0p81jalilkaqw832a12s35q0z6rrarxjasm1jy6h4fvyj9pf0zkx"))))
      (build-system asdf-build-system/sbcl)
      (home-page "https://hub.darcs.net/hu.dwim/hu.dwim.asdf")
      (synopsis "Extensions to ASDF")
      (description "Various ASDF extensions such as attached test and
documentation system, explicit development support, etc.")
      (license license:public-domain))))

(define-public cl-hu.dwim.asdf
  (sbcl-package->cl-source-package sbcl-hu.dwim.asdf))

(define-public ecl-hu.dwim.asdf
  (sbcl-package->ecl-package sbcl-hu.dwim.asdf))

(define-public clasp-hu.dwim.asdf
  (sbcl-package->clasp-package sbcl-hu.dwim.asdf))

(define-public sbcl-hu.dwim.common
  (package
    (name "sbcl-hu.dwim.common")
    (version "2015-07-09")
    (source
     (origin
       (method url-fetch)
       (uri (string-append
             "http://beta.quicklisp.org/archive/hu.dwim.common/"
             version "/hu.dwim.common-"
             (string-replace-substring version "-" "")
             "-darcs.tgz"))
       (sha256
        (base32 "12l1rr6w9m99w0b5gc6hv58ainjfhbc588kz6vwshn4gqsxyzbhp"))))
    (build-system asdf-build-system/sbcl)
    (native-inputs
     (list sbcl-hu.dwim.asdf))
    (inputs
     (list sbcl-alexandria
           sbcl-anaphora
           sbcl-closer-mop
           sbcl-hu.dwim.common-lisp
           sbcl-iterate
           sbcl-metabang-bind))
    (home-page "https://dwim.hu/")
    (synopsis "Common Lisp library shared by other hu.dwim systems")
    (description "This package contains a support library for other
hu.dwim systems.")
    (license license:public-domain)))

(define-public cl-hu.dwim.common
  (sbcl-package->cl-source-package sbcl-hu.dwim.common))

(define-public ecl-hu.dwim.common
  (sbcl-package->ecl-package sbcl-hu.dwim.common))

(define-public sbcl-hu.dwim.common-lisp
  (let ((commit "90558195773383142a57a16687d5e7f4adea6418"))
    (package
      (name "sbcl-hu.dwim.common-lisp")
      (version "2021-01-27")
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/hu-dwim/hu.dwim.common-lisp/")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "06zkdw3scnaw0d4nmsgkv7pi7sw00dikdgfgsqmbqfbz2yrsdabk"))))
      (build-system asdf-build-system/sbcl)
      (native-inputs
       (list sbcl-hu.dwim.asdf))
      (home-page "http://dwim.hu/project/hu.dwim.common-lisp")
      (synopsis "Redefine some standard Common Lisp names")
      (description "This library is a redefinition of the standard Common Lisp
package that includes a number of renames and shadows.")
      (license license:public-domain))))

(define-public cl-hu.dwim.common-lisp
  (sbcl-package->cl-source-package sbcl-hu.dwim.common-lisp))

(define-public ecl-hu.dwim.common-lisp
  (sbcl-package->ecl-package sbcl-hu.dwim.common-lisp))

(define-public sbcl-hu.dwim.defclass-star
  (let ((commit "3086878a485074f9b2913c58267a9b764cd632fd"))
    (package
      (name "sbcl-hu.dwim.defclass-star")
      ;; We used to set version from the date when it was a darcs repo, so we
      ;; keep the year so that package gets updated on previous installs.
      (version (git-version "2021" "2" commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/hu-dwim/hu.dwim.defclass-star")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "19ipds9r71qymfdp4izg0l7zmvinp06adr8rdalhaq7v7mzpg83z"))))
      (build-system asdf-build-system/sbcl)
      (native-inputs
       (list ;; These 2 inputs are only needed tests which are disabled, see below.
             ;; ("hu.dwim.common" ,sbcl-hu.dwim.common)
             ;; Need cl- package for the :hu.dwim.stefil+hu.dwim.def+swank system.
             ;; ("hu.dwim.stefil" ,cl-hu.dwim.stefil)
             sbcl-hu.dwim.asdf))
      (arguments
       `(;; Tests require a circular dependency: hu.dwim.stefil -> hu.dwim.def
         ;; -> hu.dwim.util -> hu.dwim.defclass-star.
         #:tests? #f))
      (home-page "https://github.com/hu-dwim/hu.dwim.defclass-star")
      (synopsis "Simplify definitions with defclass* and friends in Common Lisp")
      (description "@code{defclass-star} provides defclass* and defcondition* to
simplify class and condition declarations.  Features include:

@itemize
@item Automatically export all or select slots at compile time.
@item Define the @code{:initarg} and @code{:accessor} automatically.
@item Specify a name transformer for both the @code{:initarg} and
@code{:accessor}, etc.
@item Specify the @code{:initform} as second slot value.
@end itemize

See
@url{https://common-lisp.net/project/defclass-star/configuration.lisp.html}
for an example.")
      (license license:public-domain))))

(define-public cl-hu.dwim.defclass-star
  (sbcl-package->cl-source-package sbcl-hu.dwim.defclass-star))

(define-public ecl-hu.dwim.defclass-star
  (sbcl-package->ecl-package sbcl-hu.dwim.defclass-star))

(define-public sbcl-hu.dwim.graphviz
  (let ((commit "31522ca8b9a04d535b7cec20ef24d8bf3b26d52b")
        (revision "1"))
    (package
      (name "sbcl-hu.dwim.graphviz")
      (version (git-version "0.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/hu-dwim/hu.dwim.graphviz")
               (commit commit)))
         (file-name (git-file-name "cl-hu.dwim.graphviz" version))
         (sha256
          (base32 "0cz5g7d6817ajypp876k9m65sxxlf42x4bg04ya73aqci5s1vjwy"))))
      (build-system asdf-build-system/sbcl)
      (arguments
       (list #:phases
             #~(modify-phases %standard-phases
                 (add-after 'unpack 'patch-graphviz-lib-path
                   (lambda* (#:key inputs #:allow-other-keys)
                     (substitute* "source/package.lisp"
                       (("libgvc.so")
                        (search-input-file inputs "/lib/libgvc.so"))))))))
      (native-inputs
       (list sbcl-hu.dwim.common sbcl-hu.dwim.stefil))
      (inputs
       (list graphviz sbcl-cffi sbcl-metabang-bind))
      (home-page "https://github.com/hu-dwim/hu.dwim.graphviz")
      (synopsis "Graphviz layouting using CFFI bindings")
      (description
       "This package provides CFFI bindings to the Graphviz library in Common
Lisp.")
      (license license:public-domain))))

(define-public cl-hu.dwim.graphviz
  (sbcl-package->cl-source-package sbcl-hu.dwim.graphviz))

(define-public ecl-hu.dwim.graphviz
  (sbcl-package->ecl-package sbcl-hu.dwim.graphviz))

(define-public sbcl-hunchenissr
  (let ((commit "7df702f2e110999a2f31c7ebad81bfc39ac06670")
        (revision "1"))
    (package
      (name "sbcl-hunchenissr")
      (version (git-version "1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/interactive-ssr/hunchenissr")
               (commit commit)))
         (file-name (git-file-name "hunchenissr" version))
         (sha256
          (base32 "0826qrvk64pjspdklns29dv3zhzfhd6k42fq030xajv8a7hkcxda"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-cl-base64
             sbcl-cl-str
             sbcl-hunchentoot
             sbcl-issr-core
             sbcl-jonathan
             sbcl-plump
             sbcl-portal))
      (home-page "https://github.com/interactive-ssr/hunchenissr")
      (synopsis "Interactive Server Side Rendering backend for Hunchentoot")
      (description
       "Hunchenissr works together with issr.js for the development of
interactive (changing without page refreshes) websites making use of websocket
and Common Lisp server HTML generation instead of mountains of convoluted
Javascript.")
      (license license:llgpl))))

(define-public cl-hunchenissr
  (sbcl-package->cl-source-package sbcl-hunchenissr))

(define-public ecl-hunchenissr
  (sbcl-package->ecl-package sbcl-hunchenissr))

(define-public sbcl-hunchenissr-routes
  (let ((commit "2e831975dc2a6c030f1b518747cf429be8484b31")
        (revision "1"))
    (package
      (name "sbcl-hunchenissr-routes")
      (version (git-version "0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/interactive-ssr/hunchenissr-routes")
               (commit commit)))
         (file-name (git-file-name "hunchenissr-routes" version))
         (sha256
          (base32 "1xyqacihxwk4vnffqlg93czmalscglp6sh3bwy3qwb7hdxv6yxz6"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-alexandria sbcl-cl-ppcre sbcl-cl-unification
             sbcl-hunchenissr))
      (home-page "https://github.com/interactive-ssr/hunchenissr-routes")
      (synopsis "Enable path variables when using Hunchenissr")
      (description
       "This library enables path variables in networking routes when using
Hunchenissr for Common Lisp.  If a part of the path (between two slashes)
starts with a question mark (?), that symbol (without question mark) will be
bound to whatever value was in the same place in the URL (as a string).")
      (license license:llgpl))))

(define-public cl-hunchenissr-routes
  (sbcl-package->cl-source-package sbcl-hunchenissr-routes))

(define-public ecl-hunchenissr-routes
  (sbcl-package->ecl-package sbcl-hunchenissr-routes))

(define-public sbcl-hunchensocket
  (let ((commit "faf2c08452f18763e541bc7f121760669ac0f41a")
        (revision "0"))
    (package
      (name "sbcl-hunchensocket")
      (version (git-version "1.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/joaotavora/hunchensocket/")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "1vhd009lwl62l1czmhsalblxmyz4x9v3nspjflpajwm1db5rnd7h"))))
      (build-system asdf-build-system/sbcl)
      (native-inputs (list sbcl-fiasco))
      (inputs
       (list
        sbcl-hunchentoot
        sbcl-alexandria
        sbcl-cl-base64
        sbcl-sha1
        sbcl-flexi-streams
        sbcl-chunga
        sbcl-trivial-utf-8
        sbcl-trivial-backtrace
        sbcl-cl-fad))
      (home-page "https://github.com/joaotavora/hunchensocket")
      (synopsis "RFC6455 compliant WebSockets for Common Lisp")
      (description
       "This library provides a WebSockets extension for the Huchentoot web server.")
      (license license:expat))))

(define-public cl-hunchensocket
  (sbcl-package->cl-source-package sbcl-hunchensocket))

(define-public ecl-hunchensocket
  (sbcl-package->ecl-package sbcl-hunchensocket))

(define-public sbcl-hunchentoot
  ;; NOTE: (Sharlatan-20220520T213309+0100): The latest commit fixed tests,
  ;; switch to the version tag when release is ready.
  (let ((commit "76862391040c20255c7275e815c2175e46bfd080")
        (revision "1"))
    (package
      (name "sbcl-hunchentoot")
      (version (git-version "1.3.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/edicl/hunchentoot")
               (commit commit)))
         (file-name (git-file-name "cl-hunchentoot" version))
         (sha256
          (base32 "1h7ggmmzvgwr4p6j3ai0dqrw30q5309l13w4c03gqrapvwrb65l0"))))
      (build-system asdf-build-system/sbcl)
      (native-inputs
       (list sbcl-cl-who sbcl-drakma))
      (inputs
       (list sbcl-chunga
             sbcl-cl-base64
             sbcl-cl-fad
             sbcl-cl-ppcre
             sbcl-flexi-streams
             sbcl-cl+ssl
             sbcl-md5
             sbcl-rfc2388
             sbcl-trivial-backtrace
             sbcl-usocket))
      (home-page "https://edicl.github.io/hunchentoot/")
      (synopsis "Web server written in Common Lisp")
      (description
       "Hunchentoot is a web server written in Common Lisp and at the same
time a toolkit for building dynamic websites.  As a stand-alone web server,
Hunchentoot is capable of HTTP/1.1 chunking (both directions), persistent
connections (keep-alive), and SSL.")
      (license license:bsd-2))))

(define-public cl-hunchentoot
  (sbcl-package->cl-source-package sbcl-hunchentoot))

(define-public ecl-hunchentoot
  (package
    (inherit (sbcl-package->ecl-package sbcl-hunchentoot))
    (arguments
     ;; Tests fail on ECL with 'Socket error in "socket": EINVAL'.
     '(#:tests? #f))))

(define-public sbcl-hunchentoot-errors
  (let ((commit "69eb3bcea59ed1ccf3dd1960e6d48fb21f1dadab")
        (revision "0"))
    (package
      (name "sbcl-hunchentoot-errors")
      (version (git-version "0.0.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/mmontone/hunchentoot-errors")
               (commit commit)))
         (file-name (git-file-name "cl-hunchentoot-errors" version))
         (sha256
          (base32 "0fab7s8qhhs713cw014qqvzm5z61wmxm2fcbkarhg41cz3li9k1j"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-cl-mimeparse
             sbcl-hunchentoot
             sbcl-parse-number
             sbcl-string-case))
      (home-page "https://github.com/mmontone/hunchentoot-errors/")
      (synopsis "Hunchentoot error pages and logs with request and session information")
      (description
       "This package provides a functionality augmenting Hunchentoot error
pages and logs with request and session information.")
      (license license:expat))))

(define-public cl-hunchentoot-errors
  (sbcl-package->cl-source-package sbcl-hunchentoot-errors))

(define-public ecl-hunchentoot-errors
  (sbcl-package->ecl-package sbcl-hunchentoot-errors))

(define-public sbcl-hypergeometrica
  (let ((commit "db723ceb343d89a1c8d7f9174cf3a76fa91522b5")
        (revision "0"))
    (package
      (name "sbcl-hypergeometrica")
      (version (git-version "0.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/stylewarning/hypergeometrica")
               (commit commit)))
         (file-name (git-file-name "cl-hypergeometrica" version))
         (sha256
          (base32 "1dfd6w9djgfh7f4z79d8qsyggrwkjlqhs9rxpzpzv092nlwg3l35"))))
      (build-system asdf-build-system/sbcl)
      (native-inputs
       (list sbcl-fiasco))
      (inputs
       (list sbcl-alexandria
             sbcl-cffi
             sbcl-global-vars
             sbcl-lparallel
             sbcl-mmap
             sbcl-napa-fft3
             sbcl-trivial-garbage))
      (home-page "https://github.com/stylewarning/hypergeometrica")
      (synopsis "High-precision arithmetic")
      (description
       "Hypergeometrica is a Common Lisp library for performing high-precision
arithmetic, with a focus on performance.  At the heart of it all are routines
for multiplication.  Hypergeometrica aims to support:

@itemize
@item In-core multiplication using various algorithms, from schoolbook to
floating-point FFTs.
@item In-core multiplication for large numbers using exact convolutions via
number-theoretic transforms, which is enabled by 64-bit modular arithmetic.
@item Out-of-core multiplication using derivatives of the original
Cooley–Tukey algorithm.
@end itemize

On top of multiplication, one can build checkpointed algorithms for computing
various classical constants, like @math{\\pi}.")
      (license license:bsd-3))))

(define-public cl-hypergeometrica
  (sbcl-package->cl-source-package sbcl-hypergeometrica))

(define-public sbcl-idna
  (package
    (name "sbcl-idna")
    (build-system asdf-build-system/sbcl)
    (version "0.2.2")
    (home-page "https://github.com/antifuchs/idna")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url home-page)
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "00nbr3mffxhlq14gg9d16pa6691s4qh35inyw76v906s77khm5a2"))))
    (inputs
     (list sbcl-split-sequence))
    (synopsis "IDNA string encoding and decoding routines for Common Lisp")
    (description "This Common Lisp library provides string encoding and
decoding routines for IDNA, the International Domain Names in Applications.")
    (license license:expat)))

(define-public cl-idna
  (sbcl-package->cl-source-package sbcl-idna))

(define-public ecl-idna
  (sbcl-package->ecl-package sbcl-idna))

(define-public sbcl-ieee-floats
  (let ((commit "566b51a005e81ff618554b9b2f0b795d3b29398d")
        (revision "1"))
    (package
      (name "sbcl-ieee-floats")
      (build-system asdf-build-system/sbcl)
      (version (git-version "20170924" revision commit))
      (home-page "https://github.com/marijnh/ieee-floats/")
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url home-page)
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "1xyj49j9x3lc84cv3dhbf9ja34ywjk1c46dklx425fxw9mkwm83m"))))
      (native-inputs
       (list sbcl-fiveam))
      (synopsis "IEEE 754 binary representation for floats in Common Lisp")
      (description "This is a Common Lisp library that converts
floating point values to IEEE 754 binary representation.")
      (license license:bsd-3))))

(define-public cl-ieee-floats
  (sbcl-package->cl-source-package sbcl-ieee-floats))

(define-public ecl-ieee-floats
  (sbcl-package->ecl-package sbcl-ieee-floats))

(define-public sbcl-in-memory-streams
  (let ((commit "a0812140609d350e6d974711be6acd0566b360cc")
        (revision "1"))
    (package
      (name "sbcl-in-memory-streams")
      (version (git-version "2.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://codeberg.org/glv/cl-in-memory-streams")
               (commit commit)))
         (file-name (git-file-name "cl-in-memory-streams" version))
         (sha256
          (base32 "1mgdwgf98k5wsxrlvqjjkg6f8ass6gbhcbg1y489v17pwqjhbgaz"))))
      (build-system asdf-build-system/sbcl)
      (native-inputs
       (list sbcl-fiveam))
      (inputs
       (list sbcl-bordeaux-threads sbcl-trivial-gray-streams))
      (synopsis "In-memory streams for any element type")
      (description
       "This Common Lisp library provides an implementation of in-memory input
streams, output streams and io streams for any type of elements.")
      (home-page "https://codeberg.org/glv/cl-in-memory-streams")
      (license license:gpl3+))))

(define-public cl-in-memory-streams
  (sbcl-package->cl-source-package sbcl-in-memory-streams))

(define-public ecl-in-memory-streams
  (sbcl-package->ecl-package sbcl-in-memory-streams))

(define-public sbcl-incless
  (let ((commit "395accf484ffdff70f20b941f322e8329c585ca7")
        (revision "0"))
    (package
      (name "sbcl-incless")
      (version (git-version "0.0.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/s-expressionists/Incless")
               (commit commit)))
         (file-name (git-file-name "cl-incless" commit))
         (sha256
          (base32 "14bkb5zx8xq6wv6dsqi041dwq9scvw3kdjlnkfs2ndazj0rb2a1k"))))
      (build-system asdf-build-system/sbcl)
      (inputs (list sbcl-alexandria))
      ;; See https://github.com/s-expressionists/Incless/issues/6
      (arguments '(#:asd-systems '("incless")))
      (home-page "https://github.com/s-expressionists/incless")
      (synopsis "Implements print-object methods for many standard classes")
      (description
       "@code{cl-incless} implements print-object methods for many standard
classes.")
      (license license:bsd-2))))

(define-public cl-incless
  (sbcl-package->cl-source-package sbcl-incless))

(define-public ecl-incless
  (sbcl-package->ecl-package sbcl-incless))

(define-public clasp-incless
  (sbcl-package->clasp-package sbcl-incless))

(define-public sbcl-inferior-shell
  (let ((commit "15c2d04a7398db965ea1c3ba2d49efa7c851f2c2")
        (revision "1"))
    (package
      (name "sbcl-inferior-shell")
      (version (git-version "2.0.5" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/fare/inferior-shell")
               (commit commit)))
         (file-name (git-file-name "inferior-shell" version))
         (sha256
          (base32 "02qx37zzk5j4xmwh77k2qa2wvnzvaj6qml5dh2q7b6b1ljvgcj4m"))))
      (build-system asdf-build-system/sbcl)
      (native-inputs
       (list sbcl-hu.dwim.stefil))
      (inputs
       (list sbcl-alexandria sbcl-fare-mop sbcl-fare-quasiquote
             sbcl-fare-utils sbcl-trivia))
      (home-page "https://github.com/fare/inferior-shell")
      (synopsis "Spawn local or remote processes and shell pipes")
      (description
       "This package provides a Common Lisp system helping in scripting, it
uses @code{uiop:run-program} as a backend.")
      (license license:expat))))

(define-public cl-inferior-shell
  (sbcl-package->cl-source-package sbcl-inferior-shell))

(define-public ecl-inferior-shell
  (sbcl-package->ecl-package sbcl-inferior-shell))

(define-public sbcl-infix-math
  (let ((commit "f5155ae9709e518061ace79887d78f8e79c61cac")
        (revision "0"))
    (package
      (name "sbcl-infix-math")
      (version (git-version "0.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/ruricolist/infix-math")
               (commit commit)))
         (file-name (git-file-name "cl-infix-math" version))
         (sha256
          (base32 "1h6p254xl793wfq3qla5y95k6zimy477f8brblx6ran3rg3bydbg"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-alexandria sbcl-parse-number sbcl-serapeum sbcl-wu-decimal))
      (home-page "https://github.com/ruricolist/infix-math")
      (synopsis "Extensible infix syntax for math in Common Lisp")
      (description
       "Infix-Math is a library that provides a special-purpose syntax for
transcribing mathematical formulas into Lisp.")
      (license license:expat))))

(define-public cl-infix-math
  (sbcl-package->cl-source-package sbcl-infix-math))

(define-public ecl-infix-math
  (sbcl-package->ecl-package sbcl-infix-math))

(define-public sbcl-inheriting-readers
  (package
    (name "sbcl-inheriting-readers")
    (version "1.0.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/Hexstream/inheriting-readers")
             (commit (string-append "v" version))))
       (file-name (git-file-name "cl-inheriting-readers" version))
       (sha256
        (base32 "0km3mq6vx1q9qv6j3r4sqqcsdbnb5jar66bl0mzzpaacfvzbx68p"))))
    (build-system asdf-build-system/sbcl)
    (native-inputs
     (list sbcl-parachute))
    (inputs
     (list sbcl-class-options
           sbcl-closer-mop
           sbcl-compatible-metaclasses))
    (home-page "https://www.hexstreamsoft.com/libraries/inheriting-readers/")
    (synopsis "Simple yet powerful value inheritance scheme")
    (description
     "This package provides a simple yet powerful value inheritance scheme.")
    (license license:unlicense)))

(define-public cl-inheriting-readers
  (sbcl-package->cl-source-package sbcl-inheriting-readers))

(define-public ecl-inheriting-readers
  (sbcl-package->ecl-package sbcl-inheriting-readers))

(define-public sbcl-input-event-codes
  (package
    (name "sbcl-input-event-codes")
    (version "0.0.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://git.sr.ht/~shunter/input-event-codes")
             (commit (string-append "v" version))))
       (file-name (git-file-name "cl-input-event-codes" version))
       (sha256
        (base32 "0bygspj84jzyiy06z4q64z1nzsmvvrviqxw73wzqaq2wk2p56vs6"))))
    (build-system asdf-build-system/sbcl)
    (native-inputs
     (list pkg-config
           sbcl-parachute))
    (inputs
     (list sbcl-trivial-features))
    (home-page "https://git.sr.ht/~shunter/input-event-codes")
    (synopsis "Event codes for Common Lisp")
    (description
     "This library is a Common Lisp port of all the constants from the event
codes header file found on Linux and FreeBSD.")
    (license license:expat)))

(define-public cl-input-event-codes
  (sbcl-package->cl-source-package sbcl-input-event-codes))

(define-public ecl-input-event-codes
  (sbcl-package->ecl-package sbcl-input-event-codes))

(define-public clasp-input-event-codes
  (sbcl-package->clasp-package sbcl-input-event-codes))

(define-public sbcl-inquisitor
  (let ((commit "423fa9bdd4a68a6ae517b18406d81491409ccae8")
        (revision "0"))
    (package
      (name "sbcl-inquisitor")
      (version (git-version "0.5" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/t-sin/inquisitor/")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "08rkmqnwlq6v84wcz9yp31j5lxrsy33kv3dh7n3ccsg4kc54slzw"))))
      (build-system asdf-build-system/sbcl)
      (native-inputs (list sbcl-prove sbcl-babel))
      (inputs (list sbcl-flexi-streams sbcl-alexandria sbcl-anaphora))
      (home-page "https://github.com/t-sin/inquisitor")
      (synopsis
       "Encoding/end-of-line detection and external-format abstraction for Common Lisp")
      (description
       "Inquisitor is a cross-implementation library providing
encoding/end-of-line detection and external-format abstraction for Common Lisp.")
      (license license:expat))))

(define-public cl-inquisitor
  (sbcl-package->cl-source-package sbcl-inquisitor))

(define-public ecl-inquisitor
  (sbcl-package->ecl-package sbcl-inquisitor))

(define-public sbcl-interface
  (let ((commit "6d8bd74214053debcbc0b174d65ea73c271c1563")
        (revision "0"))
    (package
      (name "sbcl-interface")
      (version (git-version "0.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/stylewarning/interface")
               (commit commit)))
         (file-name (git-file-name "cl-interface" version))
         (sha256
          (base32 "0h1bckhyig2znl6nrd3agjzz7knrm2kyh2vfyk7j60kzki9rpzxy"))))
      (build-system asdf-build-system/sbcl)
      (inputs (list sbcl-alexandria sbcl-global-vars))
      (synopsis "System for defining interfaces")
      (description
       "This library contains an implementation of interfaces and
implementations.  They're sometimes called protocols in other
languages.  Broadly speaking, an @emph{interface} is some collection of
function @emph{prototypes} that a valid implementation must implement.")
      (home-page "https://github.com/stylewarning/interface")
      (license license:bsd-3))))

(define-public cl-interface
  (sbcl-package->cl-source-package sbcl-interface))

(define-public ecl-interface
  (sbcl-package->ecl-package sbcl-interface))

(define-public sbcl-introspect-environment
  (let ((commit "8fb20a1a33d29637a22943243d1482a20c32d6ae")
        (revision "2"))
    (package
      (name "sbcl-introspect-environment")
      (build-system asdf-build-system/sbcl)
      (version (git-version "0.1" revision commit))
      (home-page "https://github.com/Bike/introspect-environment")
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url home-page)
               (commit commit)))
         (file-name (git-file-name "cl-introspect-environment" version))
         (sha256
          (base32 "1p48jnr1im47529w0ciyar4hfwbivqi57zgllkmfrav09ffigk9s"))))
      (native-inputs
       (list sbcl-fiveam))
      (synopsis "Common Lisp environment introspection portability layer")
      (description "This library is a small interface to portable but
nonstandard introspection of Common Lisp environments.  It is intended to
allow a bit more compile-time introspection of environments in Common Lisp.

Quite a bit of information is available at the time a macro or compiler-macro
runs; inlining info, type declarations, that sort of thing.  This information
is all standard - any Common Lisp program can @code{(declare (integer x))} and
such.

This info ought to be accessible through the standard @code{&environment}
parameters, but it is not.  Several implementations keep the information for
their own purposes but do not make it available to user programs, because
there is no standard mechanism to do so.

This library uses implementation-specific hooks to make information available
to users.  This is currently supported on SBCL, CCL, and CMUCL.  Other
implementations have implementations of the functions that do as much as they
can and/or provide reasonable defaults.")
      (license license:wtfpl2))))

(define-public cl-introspect-environment
  (sbcl-package->cl-source-package sbcl-introspect-environment))

(define-public ecl-introspect-environment
  (sbcl-package->ecl-package sbcl-introspect-environment))

(define-public sbcl-iolib
  (let ((commit "010b7a6bdd2e918ebf2ec85edd3853179f01cb30")
        (revision "0"))
    (package
      (name "sbcl-iolib")
      (version (git-version "0.8.4" revision commit))
      (home-page "https://github.com/sionescu/iolib")
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url home-page)
               (commit commit)))
         (file-name (git-file-name "cl-iolib" version))
         (sha256
          (base32 "1qqy2yhprkmdn2vmi69akf818q3n99gv8cacv6456af0wjm5p1ga"))))
      (build-system asdf-build-system/sbcl)
      (native-inputs
       (list pkg-config sbcl-fiveam))
      (inputs
       (list libfixposix
             sbcl-alexandria
             sbcl-bordeaux-threads
             sbcl-cffi
             sbcl-idna
             sbcl-split-sequence
             sbcl-swap-bytes))
      (arguments
       '(#:asd-systems '("iolib"
                         "iolib/os")
         #:phases
         (modify-phases %standard-phases
           (add-after 'unpack 'fix-paths
             (lambda* (#:key inputs #:allow-other-keys)
               (substitute* "src/syscalls/ffi-functions-unix.lisp"
                 (("\\(:default \"libfixposix\"\\)")
                  (string-append
                   "(:default \""
                   (assoc-ref inputs "libfixposix") "/lib/libfixposix\")")))
               ;; Socket tests need Internet access, disable them.
               (substitute* "iolib.asd"
                 (("\\(:file \"sockets\" :depends-on \\(\"pkgdcl\" \"defsuites\"\\)\\)")
                  "")))))))
      (synopsis "Common Lisp I/O library")
      (description "IOlib is to be a better and more modern I/O library than
the standard Common Lisp library.  It contains a socket library, a DNS
resolver, an I/O multiplexer(which supports @code{select(2)}, @code{epoll(4)}
and @code{kqueue(2)}), a pathname library and file-system utilities.")
      (license license:expat))))

(define-public cl-iolib
  (let ((parent (sbcl-package->cl-source-package sbcl-iolib)))
    (package
      (inherit parent)
      (propagated-inputs
       ;; Need header to compile.
       (modify-inputs (package-propagated-inputs parent)
         (prepend libfixposix))))))

(define-public ecl-iolib
  (sbcl-package->ecl-package sbcl-iolib))

(define-public sbcl-ironclad
  (package
    (name "sbcl-ironclad")
    (version "0.61")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/sharplispers/ironclad/")
             (commit (string-append "v" version))))
       (sha256
        (base32 "1yszjy6a0q1jvdgd7fpmnvi9851s8ivp4plscw27lbnl7jlj1pmk"))
       (file-name (git-file-name "cl-ironclad" version))))
    (build-system asdf-build-system/sbcl)
    (native-inputs
     ;; Tests only.
     (list sbcl-rt))
    (inputs
     (list sbcl-bordeaux-threads sbcl-flexi-streams))
    (synopsis "Cryptographic toolkit written in Common Lisp")
    (description
     "Ironclad is a cryptography library written entirely in Common Lisp.
It includes support for several popular ciphers, digests, MACs and public key
cryptography algorithms.  For several implementations that support Gray
streams, support is included for convenient stream wrappers.")
    (home-page "https://github.com/sharplispers/ironclad")
    (license license:bsd-3)))

(define-public cl-ironclad
  (sbcl-package->cl-source-package sbcl-ironclad))

(define-public ecl-ironclad
  (sbcl-package->ecl-package sbcl-ironclad))

(define-public sbcl-issr-core
  (let ((commit "64e3b07a63a7ca3ad70ba42474f98ac4513580aa")
        (revision "1"))
    (package
      (name "sbcl-issr-core")
      (version (git-version "0.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/interactive-ssr/core")
               (commit commit)))
         (file-name (git-file-name "issr-core" version))
         (sha256
          (base32 "1bajb09crzadkirdpd6jrpcc55irjd4sxzavygr25l85pafyhniw"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-cl-str sbcl-global-vars sbcl-plump sbcl-tailrec))
      (home-page
       "https://github.com/interactive-ssr/client/blob/master/main.org")
      (synopsis "The core functionality for ISSR server modules")
      (description
       "ISSR core provides functions and variables for ISSR server modules so
that different servers can behave similarly.  The most important features are
Document Object Model differencing to generate instructions to update a DOM,
and DOM cleaning, to ensure that all remote DOMs are the same.")
      (license license:llgpl))))

(define-public cl-issr-core
  (sbcl-package->cl-source-package sbcl-issr-core))

(define-public ecl-issr-core
  (sbcl-package->ecl-package sbcl-issr-core))

(define-public sbcl-iterate
  (package
    (name "sbcl-iterate")
    (version "1.5.3")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://gitlab.common-lisp.net/iterate/iterate.git")
             (commit version)))
       (file-name (git-file-name "cl-iterate" version))
       (sha256
        (base32 "0l6l8fpgcpwpmi00jwmamxbspbqa8fil6dv11bf9gaxxbw41f8c2"))))
    (build-system asdf-build-system/sbcl)
    (native-inputs
     (list sbcl-rt))
    (home-page "https://common-lisp.net/project/iterate/")
    (synopsis "Iteration construct for Common Lisp")
    (description "@code{iterate} is an iteration construct for Common Lisp.
It is similar to the @code{CL:LOOP} macro, with these distinguishing marks:

@itemize
@item it is extensible,
@item it helps editors like Emacs indent iterate forms by having a more
  lisp-like syntax, and
@item it isn't part of the ANSI standard for Common Lisp.
@end itemize\n")
    (license license:expat)))

(define-public cl-iterate
  (sbcl-package->cl-source-package sbcl-iterate))

(define-public ecl-iterate
  (sbcl-package->ecl-package sbcl-iterate))

(define-public clasp-iterate
  (package
    (inherit (sbcl-package->clasp-package sbcl-iterate))
    (arguments
     ;; Tests are broken on clasp.
     (list #:tests? #f))))

(define-public sbcl-ixf
  (let ((commit "ed26f87e4127e4a9e3aac4ff1e60d1f39cca5183")
        (revision "1"))
    (package
      (name "sbcl-ixf")
      (version (git-version "0.1.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/dimitri/cl-ixf")
               (commit commit)))
         (file-name (git-file-name "cl-ixf" version))
         (sha256
          (base32 "1wjdnf4vr9z7lcfc49kl43g6l2i23q9n81siy494k17d766cdvqa"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-alexandria
             sbcl-babel
             sbcl-cl-ppcre
             sbcl-ieee-floats
             sbcl-local-time
             sbcl-md5
             sbcl-split-sequence))
      (home-page "https://github.com/dimitri/cl-ixf")
      (synopsis "Parse IBM IXF file format")
      (description
       "This is a Common Lisp library to handle the IBM PC version of the IXF
(Integration Exchange Format) file format.")
      (license license:public-domain))))

(define-public cl-ixf
  (sbcl-package->cl-source-package sbcl-ixf))

(define-public ecl-ixf
  (sbcl-package->ecl-package sbcl-ixf))

(define-public sbcl-jonathan
  (let ((commit "1f448b4f7ac8265e56e1c02b32ce383e65316300")
        (revision "1"))
    (package
     (name "sbcl-jonathan")
     (version (git-version "0.1.0" revision commit))
     (source
      (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/Rudolph-Miller/jonathan")
             (commit commit)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "14x4iwz3mbag5jzzzr4sb6ai0m9r4q4kyypbq32jmsk2dx1hi807"))))
     (build-system asdf-build-system/sbcl)
     (native-inputs
      (list sbcl-prove sbcl-legion))
     (inputs
      (list sbcl-cl-syntax sbcl-fast-io sbcl-proc-parse sbcl-cl-ppcre))
     (home-page "https://rudolph-miller.github.io/jonathan/overview.html")
     (synopsis "JSON encoder and decoder")
     (description
      "High performance JSON encoder and decoder.  Currently support: SBCL,
CCL.")
     ;; Author specifies the MIT license
     (license license:expat))))

(define-public cl-jonathan
  (sbcl-package->cl-source-package sbcl-jonathan))

(define-public ecl-jonathan
  (sbcl-package->ecl-package sbcl-jonathan))

(define-public sbcl-jose
  (let ((commit "5b9f42dd4144138e41d75ec67ca46e6e91728f2c")
        (revision "0"))
    (package
      (name "sbcl-jose")
      (build-system asdf-build-system/sbcl)
      (version (git-version "0.1.0" revision commit))
      (home-page "https://github.com/fukamachi/jose")
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url home-page)
               (commit commit)))
         (file-name (git-file-name "cl-jose" version))
         (sha256
          (base32 "1z7xjy4ihxa8ay5vznhnxkjflfx6xmfpgwxdakk9wmkw30p2yn4h"))))
      (native-inputs (list sbcl-pem sbcl-rove))
      (inputs
        (list sbcl-alexandria
              sbcl-assoc-utils
              sbcl-cl-base64
              sbcl-ironclad
              sbcl-jonathan
              sbcl-split-sequence
              sbcl-trivial-utf-8))
      (synopsis "JOSE implementation for Common Lisp")
      (description "A JSON Object Signing and Encryption (JOSE)
implementation for Common Lisp.")
      (license license:bsd-2))))

(define-public cl-jose
  (sbcl-package->cl-source-package sbcl-jose))

(define-public ecl-jose
  (sbcl-package->ecl-package sbcl-jose))

(define-public sbcl-jpeg-turbo
  (let ((commit "f79c646cc266c107bdace53572a31664754c6e0c")
        (revision "1"))
    (package
      (name "sbcl-jpeg-turbo")
      (version (git-version "1.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/shamazmazum/jpeg-turbo/")
               (commit commit)))
         (file-name (git-file-name "cl-jpeg-turbo" version))
         (sha256
          (base32 "1andd1ibbk3224idnpsnrn96flr5d1wm9ja3di57fs04wn577sag"))))
      (build-system asdf-build-system/sbcl)
      (arguments
       (list #:phases
             #~(modify-phases %standard-phases
                 (add-after 'unpack 'fix-lib-paths
                   (lambda* (#:key inputs #:allow-other-keys)
                     (substitute* "src/jpeg-turbo.lisp"
                       (("\"libturbojpeg\\.so\\.0\"")
                        (string-append "\""
                                       (search-input-file inputs
                                                          "/lib/libturbojpeg.so")
                                       "\""))))))))
      (native-inputs
       (list sbcl-fiveam))
      (inputs
       (list libjpeg-turbo sbcl-cffi))
      (synopsis "Common Lisp wrapper for libjpeg-turbo")
      (description
       "This is a Common Lisp wrapper for libjpeg-turbo library which provides
TurboJPEG API for compressing and decompressing JPEG images.")
      (home-page "https://github.com/shamazmazum/jpeg-turbo/")
      (license license:bsd-2))))

(define-public cl-jpeg-turbo
  (sbcl-package->cl-source-package sbcl-jpeg-turbo))

(define-public ecl-jpeg-turbo
  (sbcl-package->ecl-package sbcl-jpeg-turbo))

(define-public sbcl-jpl-queues
  (package
    (name "sbcl-jpl-queues")
    (version "0.1")
    (source
     (origin
       (method url-fetch)
       (uri (string-append
             "http://www.thoughtcrime.us/software/jpl-queues/jpl-queues-"
             version
             ".tar.gz"))
       (sha256
        (base32
         "1wvvv7j117h9a42qaj1g4fh4mji28xqs7s60rn6d11gk9jl76h96"))))
    (build-system asdf-build-system/sbcl)
    (inputs
     `(("jpl-util" ,sbcl-jpl-util)
       ("bordeaux-threads" ,sbcl-bordeaux-threads)))
    (arguments
     ;; Tests seem to be broken.
     `(#:tests? #f))
    (synopsis "Common Lisp library implementing a few different kinds of queues")
    (description
     "A Common Lisp library implementing a few different kinds of queues:

@itemize
@item Bounded and unbounded FIFO queues.
@item Lossy bounded FIFO queues that drop elements when full.
@item Unbounded random-order queues that use less memory than unbounded FIFO queues.
@end itemize

Additionally, a synchronization wrapper is provided to make any queue
conforming to the @command{jpl-queues} API thread-safe for lightweight
multithreading applications.  (See Calispel for a more sophisticated CL
multithreaded message-passing library with timeouts and alternation among
several blockable channels.)")
    (home-page "https://www.thoughtcrime.us/software/jpl-queues/")
    (license license:isc)))

(define-public cl-jpl-queues
  (sbcl-package->cl-source-package sbcl-jpl-queues))

(define-public ecl-jpl-queues
  (sbcl-package->ecl-package sbcl-jpl-queues))

(define-public sbcl-jpl-util
  (let ((commit "0311ed374e19a49d43318064d729fe3abd9a3b62"))
    (package
      (name "sbcl-jpl-util")
      (version "20151005")
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               ;; Quicklisp uses this fork.
               (url "https://github.com/hawkir/cl-jpl-util")
               (commit commit)))
         (file-name
          (git-file-name "jpl-util" version))
         (sha256
          (base32
           "0nc0rk9n8grkg3045xsw34whmcmddn2sfrxki4268g7kpgz0d2yz"))))
      (build-system asdf-build-system/sbcl)
      (synopsis "Collection of Common Lisp utility functions and macros")
      (description
       "@command{cl-jpl-util} is a collection of Common Lisp utility functions
and macros, primarily for software projects written in CL by the author.")
      (home-page "https://www.thoughtcrime.us/software/cl-jpl-util/")
      (license license:isc))))

(define-public cl-jpl-util
  (sbcl-package->cl-source-package sbcl-jpl-util))

(define-public ecl-jpl-util
  (sbcl-package->ecl-package sbcl-jpl-util))

(define-public clasp-jpl-util
  (sbcl-package->clasp-package sbcl-jpl-util))

(define-public sbcl-json-mop
  (let ((commit "66705776dec7056fabba09646d726782baf019d9")
        (revision "0"))
    (package
      (name "sbcl-json-mop")
      (version (git-version "0.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/gschjetne/json-mop")
               (commit commit)))
         (file-name (git-file-name name commit))
         (sha256
          (base32 "1q6mmq64hf4v448bnzfh8nxsxg5h18a9snh785r1fnvv1aij3fi1"))))
      (build-system asdf-build-system/sbcl)
      (arguments
       (list
        #:asd-systems ''("json-mop")))
      (native-inputs
       (list ))
      (inputs
       (list sbcl-closer-mop
             sbcl-yason
             sbcl-anaphora))
      (home-page "https://github.com/gschjetne/json-mop")
      (synopsis "Metaclass for bridging CLOS and JSON")
      (description "Small library aiming to cut down time spent moving data
between CLOS and JSON objects.  It depends on YASON and it should be possible to
use it alongside straight calls to functions from YASON.")
      (license license:expat))))

(define-public ecl-json-mop
  (sbcl-package->ecl-package sbcl-json-mop))

(define-public cl-json-mop
  (sbcl-package->cl-source-package sbcl-json-mop))

(define-public sbcl-json-streams
  (let ((commit "5da012e8133affbf75024e7500feb37394690752")
        (revision "1"))
    (package
      (name "sbcl-json-streams")
      (version (git-version "0.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/rotatef/json-streams")
               (commit commit)))
         (file-name (git-file-name "json-streams" version))
         (sha256
          (base32 "0cia3721im04q73dfkd688d8splgpz03qa4h8s3r39kar4w3xll2"))))
      (build-system asdf-build-system/sbcl)
      (native-inputs
       (list sbcl-cl-quickcheck sbcl-flexi-streams))
      (home-page "https://github.com/rotatef/json-streams")
      (synopsis "Common Lisp library for reading and writing JSON")
      (description
       "This package provides a stream based JSON parser/writer, well suited as
building block for higher level libraries.")
      (license license:gpl3+))))

(define-public cl-json-streams
  (sbcl-package->cl-source-package sbcl-json-streams))

(define-public ecl-json-streams
  (sbcl-package->ecl-package sbcl-json-streams))

(define-public clasp-json-streams
  (sbcl-package->clasp-package sbcl-json-streams))

(define-public sbcl-jsonrpc
  (let ((commit "2af1e0fad429ee8c706b86c4a853248cdd1be933")
        (revision "2"))
    (package
      (name "sbcl-jsonrpc")
      (version (git-version "0.3.2" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/cxxxr/jsonrpc")
               (commit commit)))
         (file-name (git-file-name "jsonrpc" version))
         (sha256
          (base32 "0kd550fsklsc4h0fj8jl6g4z5ldb8ba9dn68s7ykv3myaiwgsy1p"))))
      (build-system asdf-build-system/sbcl)
      (native-inputs (list sbcl-rove))
      (inputs (list sbcl-clack
                    sbcl-http-body
                    sbcl-lack
                    sbcl-yason
                    sbcl-bordeaux-threads
                    sbcl-event-emitter
                    sbcl-alexandria
                    sbcl-dissect
                    sbcl-trivial-timeout
                    sbcl-chanl
                    sbcl-vom
                    sbcl-usocket
                    sbcl-websocket-driver))
      (home-page "https://github.com/cxxxr/jsonrpc")
      (synopsis "JSON-RPC 2.0 server/client for Common Lisp")
      (description
       "This package provides a JSON-RPC 2.0 server/client for Common Lisp.")
      (license license:bsd-2))))

(define-public cl-jsonrpc
  (sbcl-package->cl-source-package sbcl-jsonrpc))

(define-public ecl-jsonrpc
  (sbcl-package->ecl-package sbcl-jsonrpc))

(define-public sbcl-jsown
  (let ((commit "744c4407bef58dfa876d9da0b5c0205d869e7977"))
    (package
      (name "sbcl-jsown")
      (version (git-version "1.0.1" "1" commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/madnificent/jsown")
               (commit commit)))
         (file-name (git-file-name name commit))
         (sha256
          (base32 "0gadvmf1d9bq35s61z76psrsnzwwk12svi66jigf491hv48wigw7"))))
      (build-system asdf-build-system/sbcl)
      (home-page "https://github.com/madnificent/jsown")
      (synopsis "Fast JSON reader / writer library for Common Lisp")
      (description
       "@code{jsown} is a high performance Common Lisp JSON parser.  Its aim
is to allow for the fast parsing of JSON objects in Common Lisp.  Recently,
functions and macros have been added to ease the burden of writing and editing
@code{jsown} objects.

@code{jsown} allows you to parse JSON objects quickly to a modifiable Lisp
list and write them back.  If you only need partial retrieval of objects,
@code{jsown} allows you to select the keys which you would like to see parsed.
@code{jsown} also has a JSON writer and some helper methods to alter the JSON
objects themselves.")
      (license license:expat))))

(define-public cl-jsown
  (sbcl-package->cl-source-package sbcl-jsown))

(define-public ecl-jsown
  (sbcl-package->ecl-package sbcl-jsown))

(define-public clasp-jsown
  (sbcl-package->clasp-package sbcl-jsown))

(define-public sbcl-just-getopt-parser
  (package
    (name "sbcl-just-getopt-parser")
    (version "2021.11")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/tlikonen/cl-just-getopt-parser")
             (commit version)))
       (sha256
        (base32 "0ngh8b51ngh3bqacl40j6wwiinhwxswsy02d9k7qlzv9sbjxay4s"))
       (file-name (git-file-name "cl-just-getopt-parser" version))))
    (build-system asdf-build-system/sbcl)
    (synopsis "Getopt-like command-line parser for Common Lisp")
    (description
     "This package provides the @code{getopt} function to parse command-line
options.  The options are organized in valid options, other arguments and
unknown arguments.  Optional Lisp conditions for error situations are also
defined.")
    (home-page "https://github.com/tlikonen/cl-just-getopt-parser")
    (license license:cc0)))

(define-public cl-just-getopt-parser
  (sbcl-package->cl-source-package sbcl-just-getopt-parser))

(define-public ecl-just-getopt-parser
  (sbcl-package->ecl-package sbcl-just-getopt-parser))

(define-public clasp-just-getopt-parser
  (sbcl-package->clasp-package sbcl-just-getopt-parser))

(define-public sbcl-jzon
  (package
    (name "sbcl-jzon")
    (version "1.1.4")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/Zulu-Inuoe/jzon")
             (commit (string-append "v" version))))
       (file-name (git-file-name "cl-jzon" version))
       (sha256
        (base32 "0z7xpylyk8rakz449rxqpz4hazn91ap2dnf0689iigdvvl3yqz3g"))))
    (build-system asdf-build-system/sbcl)
    (arguments
     '(#:asd-systems '("com.inuoe.jzon")
       #:asd-test-systems '("com.inuoe.jzon-tests")
       #:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'fix-test-asd
           (lambda _
             (substitute* "test/com.inuoe.jzon-tests.asd"
               ((":depends-on")
                (string-append
                 ":perform (test-op (op c) (symbol-call :fiveam :run!"
                 " (find-symbol \"JZON\" :com.inuoe.jzon-tests)))"
                 "\n"
                 "  :depends-on"))))))))
    (native-inputs
     (list sbcl-alexandria
           sbcl-fiveam))
    (inputs
     (list sbcl-closer-mop
           sbcl-flexi-streams
           sbcl-float-features
           sbcl-trivial-gray-streams))
    (home-page "https://github.com/Zulu-Inuoe/jzon/")
    (synopsis "Correct and safe JSON parser")
    (description
     "@code{jzon} is a correct and safe JSON RFC 8259 parser for Common Lisp.")
    (license license:expat)))

(define-public cl-jzon
  (sbcl-package->cl-source-package sbcl-jzon))

(define-public ecl-jzon
  (sbcl-package->ecl-package sbcl-jzon))

(define-public sbcl-kdlcl
  (let ((commit "dd4a48a3473c3c8fb34d4a37f87d6a1776c5875c")
        (revision "0"))
    (package
      (name "sbcl-kdlcl")
      (version (git-version "1.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/chee/kdlcl")
               (commit commit)))
         (file-name (git-file-name "cl-kdlcl" version))
         (sha256
          (base32 "0bqqxkd6s420ld2hmhvbbvpzss0m2kimmxaqhz7j1ksmq86bvvmj"))))
      (build-system asdf-build-system/sbcl)
      (arguments `(#:asd-systems '("kdl")))
      (inputs (list sbcl-esrap sbcl-parse-number))
      (home-page "https://github.com/chee/kdlcl/")
      (synopsis "KDL reader/printer for Common Lisp")
      (description "This package provides a KDL reader/writer for
      Common Lisp.")
      (license license:expat-0))))

(define-public cl-kdlcl
  (sbcl-package->cl-source-package sbcl-kdlcl))

(define-public ecl-kdlcl
  (sbcl-package->ecl-package sbcl-kdlcl))

(define-public sbcl-kebab
  (let ((commit "e7f77644c4e46131e7b8039d191d35fe6211f31b")
        (revision "1"))
    (package
      (name "sbcl-kebab")
      (version (git-version "0.1" revision commit))
      (home-page "https://github.com/pocket7878/kebab")
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url home-page)
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "0j5haabnvj0vz0rx9mwyfsb3qzpga9nickbjw8xs6vypkdzlqv1b"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       `(("cl-ppcre" ,sbcl-cl-ppcre)
         ("alexandria" ,sbcl-alexandria)
         ("cl-interpol" ,sbcl-cl-interpol)
         ("split-sequence" ,sbcl-split-sequence)))
      (native-inputs
       (list sbcl-prove))
      (arguments
       ;; Tests passes but the phase fails with
       ;; Component KEBAB-ASD::KEBAB-TEST not found, required by #<SYSTEM "kebab">.
       `(#:tests? #f))
      (synopsis "Common Lisp case converter")
      (description "This Common Lisp library converts strings, symbols and
keywords between any of the following typographical cases: PascalCase,
camelCase, snake_case, kebab-case (lisp-case).")
      (license license:llgpl))))

(define-public cl-kebab
  (sbcl-package->cl-source-package sbcl-kebab))

(define-public ecl-kebab
  (sbcl-package->ecl-package sbcl-kebab))

(define-public sbcl-kmrcl
  (let ((version "1.111")
        (commit "4a27407aad9deb607ffb8847630cde3d041ea25a")
        (revision "1"))
    (package
      (name "sbcl-kmrcl")
      (version (git-version version revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "http://git.kpe.io/kmrcl.git/")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "06gx04mah5nc8w78s0j8628divbf1s5w7af8w7pvzb2d5mgvrbd2"))
         (modules '((guix build utils)))
         (snippet
          ;; The useless bundled debian folder drags `make' into the closure.
          `(begin
             (delete-file-recursively "debian")
             #t))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-rt))
      (home-page "http://files.kpe.io/kmrcl/")
      (synopsis "General utilities for Common Lisp programs")
      (description
       "KMRCL is a collection of utilities used by a number of Kevin
Rosenberg's Common Lisp packages.")
      (license license:llgpl))))

(define-public cl-kmrcl
  (sbcl-package->cl-source-package sbcl-kmrcl))

(define-public ecl-kmrcl
  (sbcl-package->ecl-package sbcl-kmrcl))

(define-public clasp-kmrcl
  (sbcl-package->clasp-package sbcl-kmrcl))

(define-public sbcl-kons-9
  (let ((commit "fe0b3228ca28c316457d35f9e7c67edc83b2a4cc")
        (revision "0"))
    (package
      (name "sbcl-kons-9")
      (version (git-version "0.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/kaveh808/kons-9")
               (commit commit)))
         (file-name (git-file-name "cl-kons-9" version))
         (sha256
          (base32 "1kdwva4qj1s5vmbv6gbmpnk56ahaf8n2kvij5xjlfyk7nriy4bbi"))))
      (build-system asdf-build-system/sbcl)
      (arguments
       `(#:asd-systems '("kons-9")
         #:asd-test-systems '("kons-9/testsuite")))
      (native-inputs
       (list sbcl-alexandria sbcl-confidence))
      (inputs
       (list sbcl-closer-mop
             sbcl-cffi
             sbcl-cl-glfw3
             sbcl-cl-opengl
             sbcl-cl-vectors
             sbcl-clobber
             sbcl-origin
             sbcl-trivial-backtrace
             sbcl-trivial-main-thread
             sbcl-zpb-ttf))
      (home-page "https://github.com/kaveh808/kons-9")
      (synopsis "Common Lisp 3D graphics system")
      (description
       "This package provides KONS-9 which can be considered as a traditional user
interface driven 3D application for general artists, or as a REPL-based
development environment for technical artists and software developers.  These two
approaches can be seamlessly combined into a flexible and powerful workflow,
where non-technical users can immediately benefit from software tools and
extensions developed by technical users.")
      (license (list license:expat
                     ;; lib/JMC-font-libs/font-master
                     ;; lib/JMC-font-libs/font-zpb-ttf-master
                     license:lgpl2.1)))))

(define-public cl-kons-9
  (sbcl-package->cl-source-package sbcl-kons-9))

;; TODO: (Sharlatan-20221110T230620+0000): ECL is not supported yet.
;; https://github.com/kaveh808/kons-9/issues/176
;; (define-public ecl-kons-9
;;   (sbcl-package->ecl-package sbcl-kons-9))

(define-public sbcl-lack
  (let ((commit "35d3a8e03cab9204eec88c7dfe4d5366fc2ea922")
        (revision "1"))
    (package
      (name "sbcl-lack")
      (version (git-version "0.3.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/fukamachi/lack")
               (commit commit)))
         (file-name (git-file-name "cl-lack" version))
         (sha256
          (base32 "1yrhhzn8ywdjxwpaxzlnsm2lslhy45r89brn8gh5n08mdyjlp4l2"))
         (patches (search-patches "sbcl-lack-fix-tests.patch"))))
      (build-system asdf-build-system/sbcl)
      (native-inputs
       (list sbcl-cl-cookie
             sbcl-dexador
             sbcl-hunchentoot
             sbcl-prove))
      (inputs
       (list sbcl-alexandria
             sbcl-anypool
             sbcl-bordeaux-threads
             sbcl-circular-streams
             sbcl-cl-base64
             sbcl-cl-isaac
             sbcl-cl-redis
             sbcl-dbi
             sbcl-http-body
             sbcl-ironclad
             sbcl-local-time
             sbcl-quri
             sbcl-trivial-mimes
             sbcl-trivial-rfc-1123))
      (arguments
       '(#:asd-systems '("lack"
                         "lack-app-directory"
                         "lack-app-file"
                         "lack-component"
                         "lack-middleware-accesslog"
                         "lack-middleware-auth-basic"
                         "lack-middleware-backtrace"
                         "lack-middleware-csrf"
                         "lack-middleware-dbpool"
                         "lack-middleware-mount"
                         "lack-middleware-session"
                         "lack-middleware-static"
                         "lack-request"
                         "lack-response"
                         "lack-session-store-dbi"
                         "lack-session-store-redis"
                         "lack-util"
                         "lack-util-writer-stream")))
      (home-page "https://github.com/fukamachi/lack")
      (synopsis "Lack, the core of Clack")
      (description
       "Lack is a Common Lisp library which allows web applications to be
constructed of modular components.  It was originally a part of Clack, however
it's going to be rewritten as an individual project since Clack v2 with
performance and simplicity in mind.")
      (license license:expat))))

(define-public cl-lack
  (sbcl-package->cl-source-package sbcl-lack))

(define-public ecl-lack
  (sbcl-package->ecl-package sbcl-lack))

(define-public sbcl-lambda-fiddle
  (let ((commit "d16bba55acf6065b412f64ab8fdff679a4a32b1e") ;; no tagged branch
        (revision "1"))
    (package
      (name "sbcl-lambda-fiddle")
      (version (git-version "1.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/Shinmera/lambda-fiddle")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "1zarj1pqjqmk95kdx1axkgpwy2wq3canczk7f9z5hvaw5an6gand"))))
      (build-system asdf-build-system/sbcl)
      (home-page "https://github.com/Shinmera/lambda-fiddle")
      (synopsis "Collection of utilities to process lambda-lists")
      (description "This collection of utilities is useful in contexts where
you want a macro that uses lambda-lists in some fashion but need more precise
processing.")
      (license license:zlib))))

(define-public cl-lambda-fiddle
  (sbcl-package->cl-source-package sbcl-lambda-fiddle))

(define-public ecl-lambda-fiddle
  (sbcl-package->ecl-package sbcl-lambda-fiddle))

(define-public clasp-lambda-fiddle
  (sbcl-package->clasp-package sbcl-lambda-fiddle))

(define-public sbcl-language-codes
  (let ((commit "e7aa0e37cb97a3d37d6bc7316b479d01bff8f42e"))
    (package
      (name "sbcl-language-codes")
      (version (git-version "1.0.0" "1" commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/Shinmera/language-codes")
               (commit commit)))
         (file-name (git-file-name name commit))
         (sha256
          (base32 "0py176ibmsc01n5r0q1bs1ykqf5jwdbh8kx0j1a814l9y51241v0"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-documentation-utils))
      (home-page "https://shinmera.github.io/language-codes/")
      (synopsis "Map ISO language codes to language names in Common Lisp")
      (description
       "This is a small library providing the ISO-639 language code to
language name mapping.")
      (license license:zlib))))

(define-public cl-language-codes
  (sbcl-package->cl-source-package sbcl-language-codes))

(define-public ecl-language-codes
  (sbcl-package->ecl-package sbcl-language-codes))

(define-public clasp-language-codes
  (sbcl-package->clasp-package sbcl-language-codes))

(define-public sbcl-langutils
  (let ((commit "38beec7a82eeb35b0bfb0824a41d13ed94fc648b")
        (revision "0"))
    (package
      (name "sbcl-langutils")
      (version (git-version "1.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/eslick/cl-langutils")
               (commit commit)))
         (file-name (git-file-name "cl-langutils" version))
         (sha256
          (base32 "15y9x5wkg3fqndc04w2sc650fnwimxp4gjgpv9xvvdm9x4v433x6"))))
      (build-system asdf-build-system/sbcl)
      (inputs
        (list sbcl-stdutils
              sbcl-s-xml-rpc))
      (arguments
       (list #:tests? #f ; There are no tests.
             #:phases
             #~(modify-phases %standard-phases
                 (add-after 'unpack 'fix-build
                   (lambda _
                     ;; Remove a declaration causing a type conflict with
                     ;; recent versions of SBCL.
                     (substitute* "src/my-meta.lisp"
                       (("\\(type simple-base-string ,source-symbol\\)")
                        "")))))))
      (home-page "https://langutils.common-lisp.dev/")
      (synopsis "Common Lisp natural language processing toolkit")
      (description
       "This package provides a hierarchy of major functions and auxiliary
functions related to the structured analysis and processing of open
text.")
      (license license:bsd-3))))

(define-public cl-langutils
  (sbcl-package->cl-source-package sbcl-langutils))

(define-public ecl-langutils
  (sbcl-package->ecl-package sbcl-langutils))

(define-public sbcl-lass
  (let ((commit "1f2418dbf2d8d6f5892171057616b2ca9d6e5008")
        (revision "1"))
    (package
      (name "sbcl-lass")
      (version (git-version "0.6.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri
          (git-reference
           (url "https://github.com/Shinmera/LASS")
           (commit commit)))
         (file-name (git-file-name "cl-lass" version))
         (sha256
          (base32 "1wax2kykc9ff0sk2linp9v8fcsm5ay6idpq365vivady9fh504r5"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-cl-base64 sbcl-trivial-indent sbcl-trivial-mimes))
      (synopsis "LASS (Lisp Augmented Style Sheets) compiles Lisp to CSS")
      (description
       "With lispy syntax, shortcuts, and improvements, LASS aims to help you
out in writing CSS quick and easy.  LASS was largely inspired by SASS.  LASS
supports two modes, one being directly in your lisp code, the other in pure
LASS files.")
      (home-page "https://shinmera.github.io/LASS/")
      (license license:zlib))))

(define-public cl-lass
  (sbcl-package->cl-source-package sbcl-lass))

(define-public ecl-lass
  (sbcl-package->ecl-package sbcl-lass))

(define-public sbcl-legion
  (let ((commit "599cca19f0e34246814621f7fe90322221c2e263")
        (revision "1"))
    (package
     (name "sbcl-legion")
     (version (git-version "0.1.1" revision commit))
     (source
      (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/fukamachi/legion/")
             (commit commit)))
       (file-name (git-file-name "cl-legion" version))
       (sha256
        (base32 "0583pw0mf8bd4dj42w2xrlzcwfkl8q28n1bh8dpxxfg93crx4si6"))))
     (build-system asdf-build-system/sbcl)
     (native-inputs
      (list sbcl-prove sbcl-local-time))
     (inputs
      (list
       sbcl-bordeaux-threads
       sbcl-cl-speedy-queue
       sbcl-vom))
     (home-page "https://github.com/fukamachi/legion")
     (synopsis "Simple multithreading worker mechanism for Common Lisp")
     (description
      "This library provides a simple multithreading worker mechanism.")
     (license license:bsd-3))))

(define-public cl-legion
  (sbcl-package->cl-source-package sbcl-legion))

(define-public ecl-legion
  (package
    (inherit (sbcl-package->ecl-package sbcl-legion))
    (arguments
     ;; Tests get stuck forever
     (list #:tests? #f))))

(define-public sbcl-legit
  (let ((commit "877147a3b4b17dff49a4ca21a30e067b7750aee8")
        (revision "4"))
    (package
      (name "sbcl-legit")
      (version (git-version "1.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://codeberg.org/shinmera/legit")
               (commit commit)))
         (file-name (git-file-name "cl-legit" version))
         (sha256
          (base32 "06cvplibn21nm9l4k3j4rik549wrcbscjfrz00l0gmxh68qsqy31"))))
      (build-system asdf-build-system/sbcl)
      (arguments
       `(#:phases
         (modify-phases %standard-phases
           (add-after 'unpack 'patch-git-executable
             (lambda* (#:key inputs #:allow-other-keys)
               (substitute* "process.lisp"
                 (("\"git")
                  (string-append "\"" (search-input-file inputs
                                                         "/bin/git")))))))))
      (inputs
       (list git
             sbcl-cl-ppcre
             sbcl-documentation-utils
             sbcl-lambda-fiddle
             sbcl-simple-inferiors))
      (home-page "https://codeberg.org/shinmera/legit")
      (synopsis "Interface to the git binary")
      (description
       "This is an interface to the @code{git} binary to make controlling it
from within Common Lisp much easier.  It might not ever reach full coverage of
all features given git's immense size, but features will be added as they are
needed.  The low-level command API is fully mapped however.")
      (license license:zlib))))

(define-public cl-legit
  (sbcl-package->cl-source-package sbcl-legit))

(define-public ecl-legit
  (sbcl-package->ecl-package sbcl-legit))

(define-public sbcl-lem-extension-manager
  (let ((commit "cb19321345d6fd13dc3ca59d4d5b9a6b14cc00b1")
        (revision "0"))
    (package
      (name "sbcl-lem-extension-manager")
      (version (git-version "0.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
                (url "https://github.com/lem-project/lem-extension-manager")
                (commit commit)))
         (sha256
          (base32 "1g210cfrbjbdb395wnzb5hax2isq0d5990jhzcxj7kp171dydynf"))
         (file-name (git-file-name "cl-lem-extension-manager" version))))
      (build-system asdf-build-system/sbcl)
      (inputs (list sbcl-alexandria))
      (synopsis "Configuration library for the Lem editor")
      (description
       "This package provides a configuration library that adds the ability for
Lem to manage packages within the user configuration directory.")
      (home-page "https://lem-project.github.io/")
      (license license:expat))))

(define-public cl-lem-extension-manager
  (sbcl-package->cl-source-package sbcl-lem-extension-manager))

(define-public ecl-lem-extension-manager
  (sbcl-package->ecl-package sbcl-lem-extension-manager))

(define-public clasp-lem-extension-manager
  (sbcl-package->clasp-package sbcl-lem-extension-manager))

(define-public sbcl-lem-mailbox
  (let ((commit "12d629541da440fadf771b0225a051ae65fa342a")
        (revision "0"))
    (package
      (name "sbcl-lem-mailbox")
      (version (git-version "0.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/lem-project/lem-mailbox")
               (commit commit)))
         (sha256
          (base32 "1qh9yq9ks0paplmbx0vj4nynx86igkv9kli396plpg9vc14qdgl5"))
         (file-name (git-file-name "cl-lem-mailbox" version))))
      (build-system asdf-build-system/sbcl)
      (native-inputs (list sbcl-rove))
      (inputs
       (list sbcl-bordeaux-threads
             sbcl-bt-semaphore
             sbcl-queues))
      (synopsis "ANSI CL adaptation of the SBCL mailbox utility")
      (description
       "This package provides an ANSI CL adaptation of the SBCL mailbox utility.")
      (home-page "https://github.com/lem-project/lem-mailbox")
      (license license:expat))))

(define-public cl-lem-mailbox
  (sbcl-package->cl-source-package sbcl-lem-mailbox))

(define-public ecl-lem-mailbox
  (sbcl-package->ecl-package sbcl-lem-mailbox))

(define-public sbcl-let-over-lambda
  (let ((commit "481b2e3ab4646186451dfdd2062113203287d520")
        (revision "1"))
    (package
      (name "sbcl-let-over-lambda")
      (version (git-version "1.0.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/thephoeron/let-over-lambda")
               (commit commit)))
         (file-name (git-file-name "cl-let-over-lambda" version))
         (sha256
          (base32 "114p781lwi9lrbzg27dnkymz9m4cvm1k430j7qsykwd0b58d8qbk"))))
      (build-system asdf-build-system/sbcl)
      (arguments
       ;; All test cases pass, but tests successfully fail at the end:
       ;;
       ;; Summary:
       ;; All 1 file passed.
       ;; Unhandled ASDF/FIND-COMPONENT:MISSING-DEPENDENCY in thread
       ;; #<SB-THREAD:THREAD "main thread" RUNNING {1001860103}>:
       ;;   Component LET-OVER-LAMBDA-ASD::LET-OVER-LAMBDA-TEST not found,
       ;;   required by #<SYSTEM "let-over-lambda">
       `(#:tests? #f))
      (inputs
       `(("alexandria" ,sbcl-alexandria)
         ("cl-ppcre" ,sbcl-cl-ppcre)
         ("named-readtables" ,sbcl-named-readtables)))
      (native-inputs
       (list sbcl-prove))
      (home-page "https://github.com/thephoeron/let-over-lambda")
      (synopsis "Macros from Let Over Lambda")
      (description
       "This package provides Doug Hoyte's \"Production\" version of macros
from the Let Over Lambda book, including community updates.")
      (license license:bsd-3))))

(define-public cl-let-over-lambda
  (sbcl-package->cl-source-package sbcl-let-over-lambda))

(define-public ecl-let-over-lambda
  (sbcl-package->ecl-package sbcl-let-over-lambda))

(define-public sbcl-let-plus
  (let ((commit "455e657e077235829b197f7ccafd596fcda69e30")
        (revision "2"))
    (package
      (name "sbcl-let-plus")
      (version (git-version "0.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/sharplispers/let-plus")
               (commit commit)))
         (sha256
          (base32 "00c0nq6l4zb692rzsc9aliqzj3avrssfyz4bhxzl7f1jsz3m29jb"))
         (file-name (git-file-name "cl-let-plus" version))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-alexandria sbcl-anaphora))
      (native-inputs
       (list sbcl-lift))
      (synopsis "Destructuring extension of let*")
      (description
       "This library implements the let+ macro, which is a dectructuring
extension of let*.  It features:

@itemize
@item Clean, consistent syntax and small implementation (less than 300 LOC,
not counting tests)
@item Placeholder macros allow editor hints and syntax highlighting
@item @command{&ign} for ignored values (in forms where that makes sense)
@item Very easy to extend
@end itemize\n")
      (home-page "https://github.com/sharplispers/let-plus")
      (license license:boost1.0))))

(define-public cl-let-plus
  (sbcl-package->cl-source-package sbcl-let-plus))

(define-public ecl-let-plus
  (sbcl-package->ecl-package sbcl-let-plus))

(define-public sbcl-lev
  (let ((commit "7d03c68dad44f1cc4ac2aeeab2d24eb525ad941a")
        (revision "1"))
    (package
      (name "sbcl-lev")
      (version (git-version "0.1.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/fukamachi/lev")
               (commit commit)))
         (file-name (git-file-name "lev" version))
         (sha256
          (base32 "14lfnrvfyg2nnvlwck896p6vgarzc6g4kijmvhi2d8wra7gxzifh"))))
      (build-system asdf-build-system/sbcl)
      (arguments
       ;; NOTE: (Sharlatan-20210520T163300+0100): No tests in upstream
       `(#:tests? #f
         #:phases
         (modify-phases %standard-phases
           (add-after 'unpack 'patch-libev-lib-path
             (lambda* (#:key inputs #:allow-other-keys)
               (substitute* "src/lev.lisp"
                 (("libev.so" _)
                  (search-input-file inputs "/lib/libev.so"))))))))
      (inputs
       `(("cffi" ,sbcl-cffi)
         ("libev" ,libev)))
      (home-page "https://github.com/fukamachi/lev")
      (synopsis "Common Lisp bindings for libev")
      (description "This package provides Common Lisp bindings for libev.")
      (license license:bsd-2))))

(define-public cl-lev
  (sbcl-package->cl-source-package sbcl-lev))

(define-public ecl-lev
  (sbcl-package->ecl-package sbcl-lev))

(define-public sbcl-linear-programming
  (package
    (name "sbcl-linear-programming")
    (version "2.3.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/neil-lindquist/linear-programming")
             (commit (string-append "v" version))))
       (file-name (git-file-name "cl-linear-programming" version))
       (sha256
        (base32 "1gygqq02qh73mpswwrsjvdsjv4hjiqspky1vf4wcyllybai0jxn1"))))
    (build-system asdf-build-system/sbcl)
    (native-inputs (list sbcl-fiveam))
    (inputs (list sbcl-alexandria sbcl-iterate))
    (arguments
     (list #:phases
           #~(modify-phases %standard-phases
               (add-after 'unpack 'fix-build
                 (lambda _
                   ;; Modify a type check causing a type conflict warning
                   ;; with SBCL 2.5.2.
                   (substitute* "src/simplex.lisp"
                     (("\\(check-type tableau tableau\\)")
                      "(unless (typep tableau 'tableau)
                         (error 'type-error
                                :datum tableau
                                :expected-type 'tableau))")))))))
    (synopsis "Common Lisp linear programming")
    (description
     "This is a Common Lisp library for solving linear programming problems.")
    (home-page "https://neil-lindquist.github.io/linear-programming/")
    (license license:expat)))

(define-public cl-linear-programming
  (sbcl-package->cl-source-package sbcl-linear-programming))

(define-public ecl-linear-programming
  (sbcl-package->ecl-package sbcl-linear-programming))

(define-public sbcl-linear-programming-glpk
  (package
    (name "sbcl-linear-programming-glpk")
    (version "1.0.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/neil-lindquist/linear-programming-glpk")
             (commit (string-append "v" version))))
       (file-name (git-file-name "cl-linear-programming-glpk" version))
       (sha256
        (base32 "1ci7i41z20vql3rj4cd2ss8r4baqsqcq5xkmq1yd7ls5w3qdh9h2"))))
    (build-system asdf-build-system/sbcl)
    (native-inputs (list sbcl-fiveam))
    (inputs (list glpk sbcl-cffi sbcl-linear-programming))
    (arguments
     (list #:phases
           #~(modify-phases %standard-phases
               (add-after 'unpack 'fix-paths
                 (lambda* (#:key inputs #:allow-other-keys)
                   (substitute* "src/ffi.lisp"
                     (("libglpk.so")
                      (search-input-file inputs "/lib/libglpk.so"))))))))
    (synopsis "GLPK backend for linear-programming library")
    (description
     "This is a backend for the linear-programming Common Lisp library using
the GNU Linear Programming Kit (GLPK) library.")
    (home-page "https://github.com/neil-lindquist/linear-programming-glpk")
    (license license:gpl3)))

(define-public cl-linear-programming-glpk
  (sbcl-package->cl-source-package sbcl-linear-programming-glpk))

(define-public ecl-linear-programming-glpk
  (sbcl-package->ecl-package sbcl-linear-programming-glpk))

(define-public sbcl-linedit
  (let ((commit "0561c97dfca2f5854fcc66558a567a9875ddcb8f")
        (revision "1"))
    (package
      (name "sbcl-linedit")
      (version (git-version "0.17.6" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/sharplispers/linedit")
               (commit commit)))
         (file-name (git-file-name "cl-linedit" version))
         (sha256
          (base32 "0hhh7xn6q12rviayfihg1ym6x6csa0pdjgb88ykqbrz2rs3pgpz5"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-alexandria sbcl-cffi sbcl-osicat sbcl-terminfo))
      (home-page "https://github.com/sharplispers/linedit")
      (synopsis "Readline-style line-editor for Common Lisp")
      (description
       "Linedit is a readline-style library written in Common Lisp that
provides customizable line-editing for Common Lisp programs.")
      (license license:expat))))

(define-public cl-linedit
  (sbcl-package->cl-source-package sbcl-linedit))

(define-public ecl-linedit
  (sbcl-package->ecl-package sbcl-linedit))

(define-public sbcl-lisp-namespace
  (let ((commit "699fccb6727027343bb5fca69162a3113996edfc")
        (revision "2"))
    (package
      (name "sbcl-lisp-namespace")
      (build-system asdf-build-system/sbcl)
      (version (git-version "0.1" revision commit))
      (home-page "https://github.com/guicho271828/lisp-namespace")
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url home-page)
               (commit commit)))
         (file-name (git-file-name "cl-lisp-namespace" version))
         (sha256
          (base32 "1p5db9mab4whapy1pl38ajw5fkrrdw266n05mnhf4xx2fb9sbx6p"))))
      (inputs
       (list sbcl-alexandria))
      (native-inputs
       (list sbcl-fiveam))
      (synopsis "LISP-N, or extensible namespaces in Common Lisp")
      (description "Common Lisp already has major 2 namespaces, function
namespace and value namespace (or variable namespace), but there are actually
more — e.g., class namespace.
This library offers macros to deal with symbols from any namespace.")
      (license license:llgpl))))

(define-public cl-lisp-namespace
  (sbcl-package->cl-source-package sbcl-lisp-namespace))

(define-public ecl-lisp-namespace
  (sbcl-package->ecl-package sbcl-lisp-namespace))

(define-public sbcl-lisp-pay
  (let ((commit "c4de776f0a284709931ff3674160ced3b41bd000")
        (revision "0"))
    (package
      (name "sbcl-lisp-pay")
      (version (git-version "0.0.5" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/K1D77A/lisp-pay")
               (commit commit)))
         (file-name (git-file-name "cl-lisp-pay" version))
         (sha256
          (base32 "09r6qy4fipriqa0d6g9qm6dq992lr58vh24g5j0adm19i5fnjavh"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-alexandria
             sbcl-babel
             sbcl-cl-base64
             sbcl-cl-str
             sbcl-cl-tls
             sbcl-closer-mop
             sbcl-dexador
             sbcl-hu.dwim.defclass-star
             sbcl-hunchentoot
             sbcl-ironclad
             sbcl-jonathan
             sbcl-lack
             sbcl-ningle
             sbcl-shasht))
      (home-page "https://github.com/K1D77A/lisp-pay/")
      (synopsis "Wrappers over multiple Payment Processor APIs")
      (description "This library provides payment API wrappers over
BTCPay, Paypal, and Stripe.")
      (license license:expat))))

(define-public cl-lisp-pay
  (sbcl-package->cl-source-package sbcl-lisp-pay))

(define-public ecl-lisp-pay
  (sbcl-package->ecl-package sbcl-lisp-pay))

(define-public sbcl-lisp-preprocessor
  (let ((commit "cbed5952f3d98c84448c52d12255df9580451383")
        (revision "0"))
    (package
      (name "sbcl-lisp-preprocessor")
      (version (git-version "0.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/cxxxr/lisp-preprocessor/")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "0v0qhawcvgbxk06nfwyvcqwmqvzn2svq80l2rb12myr0znschhpi"))))
      (build-system asdf-build-system/sbcl)
      (native-inputs (list sbcl-rove))
      (inputs
       (list
        sbcl-alexandria
        sbcl-trivial-gray-streams
        sbcl-split-sequence
        sbcl-trivia
        sbcl-cl-ppcre))
      (home-page "https://github.com/cxxxr/lisp-preprocessor")
      (synopsis "Common Lisp embedded template engine")
      (description "This package provides an embedded template engine for Common Lisp.")
      (license license:expat))))

(define-public cl-lisp-preprocessor
  (sbcl-package->cl-source-package sbcl-lisp-preprocessor))

(define-public ecl-lisp-preprocessor
  (sbcl-package->ecl-package sbcl-lisp-preprocessor))

(define-public sbcl-lisp-stat
  (let ((commit "357a0d2b5f68a5ff925776235c2b7455e12b78ba")
        (revision "0"))
    (package
      (name "sbcl-lisp-stat")
      (version (git-version "1.2.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/Lisp-Stat/lisp-stat")
               (commit commit)))
         (file-name (git-file-name "cl-lisp-stat" version))
         (sha256
          (base32 "0qwlxrbwj884mr67sf6aj0zwrndv33aiiid4bqrkji41kjhqfcz5"))))
      (build-system asdf-build-system/sbcl)
      ;; https://github.com/Lisp-Stat/lisp-stat/issues/22
      (arguments (list #:tests? #f))
      (native-inputs (list sbcl-parachute))
      (inputs
        (list sbcl-alexandria
              sbcl-alexandria-plus
              sbcl-array-operations
              sbcl-conduit-packages
              sbcl-data-frame
              sbcl-dexador
              sbcl-dfio
              sbcl-distributions
              sbcl-numerical-utilities
              sbcl-select
              sbcl-statistics))
      (home-page "https://lisp-stat.github.io/lisp-stat/")
      (synopsis "Statistical Computing in Common Lisp")
      (description "This package provides a statistical computing
environment for Common Lisp.")
      (license license:ms-pl))))

(define-public cl-lisp-stat
  (sbcl-package->cl-source-package sbcl-lisp-stat))

;; This depends on ecl-data-frame and ecl-dfio, which don't work yet.
;; (define-public ecl-lisp-stat
;;   (sbcl-package->ecl-package sbcl-lisp-stat))

(define-public sbcl-lispbuilder-sdl
  (let ((commit "9590d70044aa9054292357cf416571ba7b1e08fc")
        (revision "2"))
    (package
      (name "sbcl-lispbuilder-sdl")
      (version (git-version "0.9.8.2" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/lispbuilder/lispbuilder")
               (commit commit)))
         (file-name (git-file-name "cl-lispbuilder-sdl" version))
         (sha256
          (base32 "018sapnhqb60v7144h34n1an8njz88j35z7kanvnc6fj9gm8vhj1"))))
      (build-system asdf-build-system/sbcl)
      (arguments
       `(#:phases
         (modify-phases %standard-phases
           (add-after 'unpack 'cd-sdl
             (lambda _
               (chdir "lispbuilder-sdl")))
           (add-after 'cd-sdl 'fix-paths
             (lambda* (#:key inputs #:allow-other-keys)
               (substitute* "cffi/library.lisp"
                 (("libSDL-1.2.so" _)
                  (search-input-file inputs "/lib/libSDL-1.2.so"))))))))
      (inputs
       (list sbcl-cffi
             sbcl-trivial-garbage
             sdl))
      (home-page "https://github.com/lispbuilder/lispbuilder/wiki/LispbuilderSDL")
      (synopsis "Common Lisp wrapper for SDL")
      (description
       "This library is an SDL wrapper as part of an umbrella project that
provides cross-platform packages for building large, interactive applications
in Common Lisp.")
      (license license:expat))))

(define-public cl-lispbuilder-sdl
  (sbcl-package->cl-source-package sbcl-lispbuilder-sdl))

(define-public ecl-lispbuilder-sdl
  (sbcl-package->ecl-package sbcl-lispbuilder-sdl))

(define-public sbcl-list-named-class
  (let ((commit "2955791a7469131bcab42d800883f27993ee1d62")
        (revision "0"))
    (package
      (name "sbcl-list-named-class")
      (version (git-version "0.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/phoe/list-named-class")
               (commit commit)))
         (file-name (git-file-name "cl-list-named-class" version))
         (sha256
          (base32 "1bdi9q9wvfj66jji3n9hpjrj9271ial2awsb0xw80bmy6wqbg8kq"))))
      (build-system asdf-build-system/sbcl)
      (native-inputs
       (list sbcl-1am))
      (inputs
       (list sbcl-alexandria sbcl-closer-mop))
      (home-page "https://github.com/phoe/list-named-class/")
      (synopsis "Name classes after lists of symbols")
      (description
       "This package makes it possible to name classes by lists of symbols
instead of symbols.")
      (license license:expat))))

(define-public cl-list-named-class
  (sbcl-package->cl-source-package sbcl-list-named-class))

(define-public ecl-list-named-class
  (sbcl-package->ecl-package sbcl-list-named-class))

(define-public sbcl-listopia
  (package
    (name "sbcl-listopia")
    (version "0.12.0")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/Dimercel/listopia")
                    (commit version)))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "07xa2s2s60h9f40az3zdacybl5pk1x8bhvga9phsra0czbv44lx2"))))
    (build-system asdf-build-system/sbcl)
    (native-inputs
     (list sbcl-prove))
    (home-page "https://github.com/Dimercel/listopia")
    (synopsis "List manipulation library for Common Lisp")
    (description "This package is a list manipulation library for Common Lisp
inspired by Haskell package @code{Data.List}.")
    (license license:llgpl)))

(define-public cl-listopia
  (sbcl-package->cl-source-package sbcl-listopia))

(define-public ecl-listopia
  (sbcl-package->ecl-package sbcl-listopia))

(define-public sbcl-literate-lisp
  (let ((commit "76d4d2c16ab08296d58e0ef3c41861b615e697c0")
        (revision "1"))
    (package
      (name "sbcl-literate-lisp")
      (version (git-version "0.6" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/jingtaozf/literate-lisp")
               (commit commit)))
         (file-name (git-file-name "cl-literate-lisp" version))
         (sha256
          (base32 "0smxf0a62dnwcfxsbsdkx4n5nqx9dlxdz6c2vfivxpqld6d6ap02"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-cl-fad
             sbcl-cl-ppcre
             sbcl-iterate))
      (native-inputs
       (list sbcl-fiveam))
      (home-page "https://github.com/jingtaozf/literate-lisp")
      (synopsis "Load Common Lisp code blocks from Org-mode files")
      (description "This package extends the Common Lisp reader
syntax such that is accepts Org files as Lisp source code files.")
      (license license:expat))))

(define-public cl-literate-lisp
  (sbcl-package->cl-source-package sbcl-literate-lisp))

(define-public ecl-literate-lisp
  (sbcl-package->ecl-package sbcl-literate-lisp))

(define-public sbcl-livesupport
  (let ((commit "71e6e412df9f3759ad8378fabb203913d82e228a")
        (revision "1"))
    (package
      (name "sbcl-livesupport")
      (version (git-version "0.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/cbaggers/livesupport")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "1rvnl0mncylbx63608pz5llss7y92j7z3ydambk9mcnjg2mjaapg"))))
      (build-system asdf-build-system/sbcl)
      (home-page "https://github.com/cbaggers/livesupport")
      (synopsis "Some helpers that make livecoding a little easier")
      (description "This package provides a macro commonly used in livecoding to
enable continuing when errors are raised.  Simply wrap around a chunk of code
and it provides a restart called @code{continue} which ignores the error and
carrys on from the end of the body.")
      (license license:bsd-2))))

(define-public cl-livesupport
  (sbcl-package->cl-source-package sbcl-livesupport))

(define-public ecl-livesupport
  (sbcl-package->ecl-package sbcl-livesupport))

(define-public sbcl-lla
  (let ((commit "4008d363a43647adc39579a48b549650a0742e61")
        (revision "2"))
    (package
      (name "sbcl-lla")
      (version (git-version "0.4.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/Lisp-Stat/lla")
               (commit commit)))
         (file-name (git-file-name "cl-lla" version))
         (sha256
          (base32 "19j11z8m00ry2bfn3ahai155b6qz995qqg7ipzvjdr05sj4gfb58"))))
      (build-system asdf-build-system/sbcl)
      (native-inputs
       (list sbcl-clunit))
      (inputs
       (list openblas
             sbcl-anaphora
             sbcl-alexandria
             sbcl-cffi
             sbcl-let-plus
             sbcl-numerical-utilities
             sbcl-select))
      (arguments
       (list #:phases
             #~(modify-phases %standard-phases
                 (add-after 'unpack 'fix-paths
                   (lambda* (#:key inputs #:allow-other-keys)
                     (substitute* "src/configuration.lisp"
                       (("\"libblas.so.3gf\"")
                        (string-append "\""
                                       (search-input-file inputs
                                                          "/lib/libopenblas.so")
                                       "\""))
                       (("\"liblapack.so.3gf\"")
                        (string-append "\""
                                       (search-input-file inputs
                                                          "/lib/libopenblas.so")
                                       "\""))))))))
      (home-page "https://lisp-stat.github.io/lla/")
      (synopsis "Linear algebra library for Common Lisp")
      (description
       "LLA is a high-level Common Lisp library built on BLAS and LAPACK, but
providing a much more abstract interface with the purpose of freeing the user
from low-level concerns and reducing the number of bugs in numerical code.")
      (license license:ms-pl))))

(define-public cl-lla
  (sbcl-package->cl-source-package sbcl-lla))

(define-public ecl-lla
  (sbcl-package->ecl-package sbcl-lla))

(define-public sbcl-lmdb
  (let ((commit "f439b707939a52769dc9747838ff4a616fab14a3")
        (revision "0"))
    (package
      (name "sbcl-lmdb")
      (version (git-version "0.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/antimer/lmdb")
               (commit commit)))
         (file-name (git-file-name "cl-lmdb" version))
         (sha256
          (base32 "0akvimmvd4kcx6gh1j1dzvcclhc0jc4hc9vkh3ldgzb8wyf4vl8q"))))
      (build-system asdf-build-system/sbcl)
      (arguments
       (list
        #:phases
        #~(modify-phases %standard-phases
            (add-after 'unpack 'fix-paths
              (lambda* (#:key inputs #:allow-other-keys)
                (substitute* "src/lmdb.lisp"
                  (("\"liblmdb.so\"")
                   (string-append
                    "\"" (search-input-file inputs "/lib/liblmdb.so") "\""))))))))
      (inputs
       (list lmdb
             sbcl-alexandria
             sbcl-bordeaux-threads
             sbcl-cl-reexport
             sbcl-mgl-pax
             sbcl-osicat
             sbcl-trivial-features
             sbcl-trivial-garbage
             sbcl-trivial-utf-8))
      (native-inputs
       (list sbcl-try))
      (home-page "https://github.com/antimer/lmdb")
      (synopsis "LMDB bindings for Common Lisp")
      (description
       "LMDB, the Lightning Memory-mapped Database, is an ACID key-value
database with multiversion concurrency control.  This package is a Common Lisp
wrapper around the C LMDB library.  It covers most of C LMDB's functionality,
has a simplified API, much needed safety checks, and comprehensive
documentation.")
      (license license:expat))))

(define-public cl-lmdb
  (sbcl-package->cl-source-package sbcl-lmdb))

(define-public sbcl-local-time
  (let ((commit "40169fe26d9639f3d9560ec0255789bf00b30036")
        (revision "4"))
    (package
     (name "sbcl-local-time")
     (version (git-version "1.0.6" revision commit))
     (source
      (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/dlowe-net/local-time")
             (commit commit)))
       (file-name (git-file-name "cl-local-time" version))
       (sha256
        (base32 "1dbp33zmkqzzshmf5k76pxqgli285wvy0p0dhcz816fdikpwn2jg"))))
     (build-system asdf-build-system/sbcl)
     (arguments
       `(#:phases
         (modify-phases %standard-phases
           ;; Delete the extension provided by sbcl-cl-postgres+local-time
           (add-after 'unpack 'delete-local-time
             (lambda _
               (delete-file "cl-postgres+local-time.asd")
               (delete-file "src/integration/cl-postgres.lisp"))))))
     (native-inputs
      (list sbcl-hu.dwim.stefil))
     (home-page "https://common-lisp.net/project/local-time/")
     (synopsis "Time manipulation library for Common Lisp")
     (description
      "The LOCAL-TIME library is a Common Lisp library for the manipulation of
dates and times.  It is based almost entirely upon Erik Naggum's paper \"The
Long Painful History of Time\".")
     (license license:expat))))

(define-public cl-local-time
  (sbcl-package->cl-source-package sbcl-local-time))

(define-public ecl-local-time
  (sbcl-package->ecl-package sbcl-local-time))

(define-public clasp-local-time
  (sbcl-package->clasp-package sbcl-local-time))

(define-public sbcl-cl-postgres+local-time
  (package
    (inherit sbcl-local-time)
    (name "sbcl-cl-postgres+local-time")
    (inputs (list sbcl-local-time sbcl-postmodern))
    (arguments
     `(#:asd-systems '("cl-postgres+local-time")
       #:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'delete-local-time
           (lambda _
             (delete-file "local-time.asd")
             (delete-file "src/package.lisp")
             (delete-file "src/local-time.lisp")
             (delete-file-recursively "doc")
             (delete-file-recursively "test")
             (delete-file-recursively "zoneinfo"))))))
    (synopsis "Integration between cl-postgres and local-time")
    (description
     "This package provides the LOCAL-TIME extensions for the cl-postgres
ASDF system of postmodern.")
    (license license:expat)))

(define-public cl-postgres+local-time
  (sbcl-package->cl-source-package sbcl-cl-postgres+local-time))

(define-public ecl-cl-postgres+local-time
  (sbcl-package->ecl-package sbcl-cl-postgres+local-time))

(define-public sbcl-log4cl
  (let ((commit "fe3da517147d023029782ced7cd989ba24f1e62d")
        (revision "2"))
    (package
      (name "sbcl-log4cl")
      (version (git-version "1.1.4" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/sharplispers/log4cl")
               (commit commit)))
         (file-name (git-file-name "cl-log4cl" version))
         (sha256
          (base32 "0n119sy35k9yl4n18az1sw9a7saa5jh3v44863b305by1p5xdy7k"))))
      (build-system asdf-build-system/sbcl)
      (native-inputs
       (list sbcl-stefil))
      (inputs
       (list sbcl-bordeaux-threads))
      (home-page "https://github.com/7max/log4cl")
      (synopsis "Common Lisp logging framework, modeled after Log4J")
      (description
       "This is a Common Lisp logging framework that can log at various levels
and mix text with expressions.")
      (license license:asl2.0))))

(define-public cl-log4cl
  (sbcl-package->cl-source-package sbcl-log4cl))

(define-public ecl-log4cl
  (sbcl-package->ecl-package sbcl-log4cl))

(define-public sbcl-log4cl-extras
  (let ((commit "7df9566cfecf6ed418ea85c2aa2f886dfb6f12af")
        (revision "0"))
    (package
      (name "sbcl-log4cl-extras")
      (version (git-version "0.7.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/40ants/log4cl-extras")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "17p8y884163j0gab0idra297kivzdgagl2im0gkmdhgrh0dw3b53"))))
      (build-system asdf-build-system/sbcl)
      (arguments
       (list
        #:phases
        #~(modify-phases %standard-phases
            ;; The package is explicitly not included to avoid pulling in a
            ;; dependency, but the tests are included. We ignore the test to
            ;; truly ignore the module.
            (add-after 'unpack 'do-not-test-ignored-secrets-system
              (lambda _
                (substitute* "log4cl-extras-test.asd"
                  (("\"log4cl-extras-test/secrets")
                   "#+nil\"log4cl-extras-test/secrets")))))))
      (native-inputs
       (list sbcl-hamcrest
             sbcl-40ants-asdf-system))
      (inputs
       (list sbcl-with-output-to-stream
             sbcl-pythonic-string-reader
             sbcl-log4cl
             sbcl-cl-strings
             sbcl-jonathan
             sbcl-40ants-doc))
      (home-page "https://github.com/40ants/log4cl-extras")
      (synopsis "Addons to LOG4CL: JSON appender, context fields, cross-finger
appender, etc.")
      (description
       "This library extends LOG4CL system in a few ways:

* It helps with configuration of multiple appenders and layouts.
* Has a facility to catch context fields and to log them.
* Has a macro to log unhandled errors.
* Adds a layout to write messages as JSON, which is useful for production as
makes easier to parse and process such logs.
* Uses the appenders which are not disabled in case of some error which again,
should be useful for production.")
      (license license:bsd-0))))

(define-public ecl-log4cl-extras
  (sbcl-package->ecl-package sbcl-log4cl-extras))

(define-public cl-log4cl-extras
  (sbcl-package->cl-source-package sbcl-log4cl-extras))

(define-public sbcl-lorem-ipsum
  (let ((commit "04a1839a03b53c954e799b9cf570ac915b032ce8")
        (revision "0"))
    (package
      (name "sbcl-lorem-ipsum")
      (version (git-version "1.0" revision commit))
      (source
        (origin
          (method git-fetch)
          (uri (git-reference
                (url "https://github.com/phoe/lorem-ipsum")
                (commit commit)))
          (sha256
           (base32 "1530qq0bk3xr25m77q96pbi1idnxdkax8cwmvq4ch03rfjy34j7n"))
          (file-name (git-file-name "cl-lorem-ipsum" commit))))
      (build-system asdf-build-system/sbcl)
      (home-page "https://github.com/phoe/lorem-ipsum")
      (synopsis "Lorem ipsum generator in portable Common Lisp")
      (description
       "This package provides functions for generating lorem ipsum text.")
      (license license:expat))))

(define-public cl-lorem-ipsum
  (sbcl-package->cl-source-package sbcl-lorem-ipsum))

(define-public ecl-lorem-ipsum
  (sbcl-package->ecl-package sbcl-lorem-ipsum))

(define-public clasp-lorem-ipsum
  (sbcl-package->clasp-package sbcl-lorem-ipsum))

(define-public sbcl-lparallel
  (let ((commit "80fc2952a074776abd343d6b5d3ab157f0e1df7a")
        (revision "1"))
    (package
      (name "sbcl-lparallel")
      (version (git-version "2.8.4" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/sharplispers/lparallel/")
               (commit commit)))
         (file-name (git-file-name "cl-lparallel" version))
         (sha256
          (base32 "0nv2dx8cl25g68icqhw95yr5mygm86lcjzmzijql51na1p60g6y9"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-alexandria
             sbcl-bordeaux-threads
             sbcl-trivial-garbage))
      (arguments
       `(#:phases
         (modify-phases %standard-phases
           (add-after 'unpack 'fix-dependency
             ;; lparallel loads a SBCL specific system in its asd file. This is
             ;; not carried over into the fasl which is generated. In order for
             ;; it to be carried over, it needs to be listed as a dependency.
             (lambda _
               (substitute* "lparallel.asd"
                 ((":depends-on \\(:alexandria" all)
                  (string-append all " #+sbcl :sb-cltl2"))))))))
      (home-page "https://lparallel.org/")
      (synopsis "Parallelism for Common Lisp")
      (description
       "@command{lparallel} is a library for parallel programming in Common
Lisp, featuring:

@itemize
@item a simple model of task submission with receiving queue,
@item constructs for expressing fine-grained parallelism,
@item asynchronous condition handling across thread boundaries,
@item parallel versions of map, reduce, sort, remove, and many others,
@item promises, futures, and delayed evaluation constructs,
@item computation trees for parallelizing interconnected tasks,
@item bounded and unbounded FIFO queues,
@item high and low priority tasks,
@item task killing by category,
@item integrated timeouts.
@end itemize\n")
      (license license:expat))))

(define-public cl-lparallel
  (sbcl-package->cl-source-package sbcl-lparallel))

(define-public ecl-lparallel
  (sbcl-package->ecl-package sbcl-lparallel))

(define-public sbcl-lquery
  (let ((revision "2")
        (commit "08c9cb6c2b169bf71d4444bc80e87e5b19f8499c"))
    (package
      (name "sbcl-lquery")
      (version (git-version "3.2.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri
          (git-reference
           (url "https://codeberg.org/shinmera/lquery")
           (commit commit)))
         (sha256
          (base32 "11l03pwlvv76lxrmvjs3prkrjsgl70wz7vbl1n6rhg9kmyv91a74"))
         (file-name (git-file-name name version))))
      (native-inputs
       (list sbcl-fiveam))
      (inputs
       (list sbcl-array-utils sbcl-form-fiddle sbcl-plump sbcl-clss))
      (build-system asdf-build-system/sbcl)
      (synopsis "Library to allow jQuery-like HTML/DOM manipulation")
      (description "@code{lQuery} is a DOM manipulation library written in
Common Lisp, inspired by and based on the jQuery syntax and
functions.  It uses Plump and CLSS as DOM and selector engines.  The
main idea behind lQuery is to provide a simple interface for crawling
and modifying HTML sites, as well as to allow for an alternative
approach to templating.")
      (home-page "https://codeberg.org/shinmera/lquery")
      (license license:zlib))))

(define-public cl-lquery
  (sbcl-package->cl-source-package sbcl-lquery))

(define-public ecl-lquery
  (sbcl-package->ecl-package sbcl-lquery))

(define-public sbcl-ltk
  (let ((commit "ff14a781d211c19c35e65a7ecaece67dda0b3ebb")
        (revision "0"))
    (package
      (name "sbcl-ltk")
      (version (git-version "0.992" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/herth/ltk")
               (commit commit)))
         (file-name (git-file-name "cl-ltk" version))
         (sha256
          (base32 "0f1xgsj2j7bq21cq2pa9rw3ybxd9vyknisl6z307lxx7lvhm3xac"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list imagemagick tk))
      (arguments
       `(#:asd-systems '("ltk"
                         "ltk-mw"
                         "ltk-remote")
         #:tests? #f
         #:phases
         (modify-phases %standard-phases
           (add-after 'unpack 'fix-paths
             (lambda* (#:key inputs #:allow-other-keys)
               (substitute* "ltk/ltk.lisp"
                 (("#-freebsd \"wish\"")
                  (string-append "#-freebsd \""
                                 (assoc-ref inputs "tk")
                                 "/bin/wish\""))
                 (("do-execute \"convert\"")
                  (string-append "do-execute \""
                                 (assoc-ref inputs "imagemagick")
                                 "/bin/convert\"")))
               #t))
           (add-after 'unpack 'fix-build
             (lambda _
               (substitute* "ltk/ltk-remote.lisp"
                 (("\\(:export")
                  "(:shadow #:raise) (:export"))
               #t)))))
      (synopsis "Common Lisp bindings for the Tk GUI toolkit")
      (description
       "LTK is a Common Lisp binding for the Tk graphics toolkit.  It is
written in pure Common Lisp and does not require any Tk knowledge for its
usage.")
      (home-page "http://www.peter-herth.de/ltk/")
      (license license:llgpl))))

(define-public cl-ltk
  (sbcl-package->cl-source-package sbcl-ltk))

(define-public ecl-ltk
  (sbcl-package->ecl-package sbcl-ltk))

(define-public sbcl-lunamech-matrix-api
  (let ((commit "aa54a820149584c237b03d500ad83397fe25dc92")
        (revision "0"))
    (package
      (name "sbcl-lunamech-matrix-api")
      (version (git-version "0.0.2" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/K1D77A/lunamech-matrix-api")
               (commit commit)))
         (file-name (git-file-name "cl-lunamech-matrix-api" version))
         (sha256
          (base32 "0a664qq4m5gk4iv5ck63gmsl3218jhjsalawklj56wn2pw0cf8a0"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-cl-json
             sbcl-cl-str
             sbcl-closer-mop
             sbcl-dexador
             sbcl-do-urlencode
             sbcl-drakma
             sbcl-jonathan
             sbcl-plump
             sbcl-quri
             sbcl-reader
             sbcl-shasht))
      (home-page "https://github.com/K1D77A/lunamech-matrix-api/")
      (synopsis "Implementation of the Matrix API")
      (description "This package provides an implementation of the Matrix
API for Common Lisp.")
      (license license:expat))))

(define-public cl-lunamech-matrix-api
  (sbcl-package->cl-source-package sbcl-lunamech-matrix-api))

(define-public ecl-lunamech-matrix-api
  (sbcl-package->ecl-package sbcl-lunamech-matrix-api))

(define-public sbcl-lw-compat
  ;; No release since 2013.
  (let ((commit "aabfe28c6c1a4949f9d7b3cb30319367c9fd1c0d"))
    (package
      (name "sbcl-lw-compat")
      (version (git-version "1.0.0" "1" commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/pcostanza/lw-compat/")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "131rq5k2mlv9bfhmafiv6nfsivl4cxx13d9wr06v5jrqnckh4aav"))))
      (build-system asdf-build-system/sbcl)
      (home-page "https://github.com/pcostanza/lw-compat/")
      (synopsis "LispWorks utilities ported to other Common Lisp implementations")
      (description "This package contains a few utility functions from the
LispWorks library that are used in software such as ContextL.")
      (license license:expat))))

(define-public cl-lw-compat
  (sbcl-package->cl-source-package sbcl-lw-compat))

(define-public ecl-lw-compat
  (sbcl-package->ecl-package sbcl-lw-compat))

(define-public clasp-lw-compat
  (sbcl-package->clasp-package sbcl-lw-compat))

(define-public sbcl-lwcells
  (let ((commit "e7446ac146a31b630e74c9bce7dab34b50cc333d")
        (revision "0"))
    (package
     (name "sbcl-lwcells")
     (version (git-version "0.0.1" revision commit))
     (source
      (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/kchanqvq/lwcells")
             (commit commit)))
       (file-name (git-file-name "lwcells" version))
       (sha256
        (base32 "1p8a5j52isp14w6pxy6c6fsrwwvnyb9r6yvd8bxh7sjh6mnvp3nc"))))
     (build-system asdf-build-system/sbcl)
     (inputs
      (list sbcl-alexandria
            sbcl-named-closure
            sbcl-damn-fast-priority-queue))
     (synopsis "Light-weight cells for dataflow programming")
     (description
      "A dataflow extension to Common Lisp that maintains a consistent state of
cells according to functions specifying their relation.")
     (home-page "https://github.com/kchanqvq/lwcells")
     (license license:gpl3+))))

(define-public cl-lwcells
  (sbcl-package->cl-source-package sbcl-lwcells))

(define-public ecl-lwcells
  (sbcl-package->ecl-package sbcl-lwcells))

(define-public sbcl-lzlib
  (let ((commit "22767ca12d1c1bd59a7ae1f9c5ef7d2e937206bb")
        (revision "2"))
    (package
      (name "sbcl-lzlib")
      (version (git-version "2.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://codeberg.org/glv/cl-lzlib")
               (commit commit)))
         (file-name (git-file-name "cl-lzlib" version))
         (sha256
          (base32 "1dxzlkay7aqcs65h2f7j7rl4sdjija60dshlahzyllfw174p9d3m"))))
      (build-system asdf-build-system/sbcl)
      (native-inputs
       (list sbcl-fiveam))
      (inputs
       (list lzlib
             sbcl-cffi
             sbcl-cl-octet-streams
             sbcl-lparallel))
      (arguments
       (list #:phases
             #~(modify-phases %standard-phases
                 (add-after 'unpack 'fix-paths
                   (lambda* (#:key inputs #:allow-other-keys)
                     (substitute* "src/lzlib.lisp"
                       (("liblz\\.so")
                        (search-input-file inputs "/lib/liblz.so"))))))))
      (synopsis "Common Lisp library for lzip (de)compression")
      (description
       "This Common Lisp library provides functions for lzip (LZMA)
compression/decompression using bindings to the lzlib C library.")
      (home-page "https://codeberg.org/glv/cl-lzlib")
      (license license:gpl3+))))

(define-public cl-lzlib
  (sbcl-package->cl-source-package sbcl-lzlib))

(define-public ecl-lzlib
  (sbcl-package->ecl-package sbcl-lzlib))

(define-public sbcl-machine-state
  (let ((commit "3d258eea63942e7d2fd7212f1ad8bbcf505634a2")
        (revision "2"))
    (package
      (name "sbcl-machine-state")
      (version (git-version "1.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/Shinmera/machine-state")
               (commit commit)))
         (file-name (git-file-name "cl-machine-state" version))
         (sha256
          (base32 "1fjf2v8agx75qnna1n8fn54lvb01w1rk1vddi3p45a2xw1kwhzml"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-bordeaux-threads
             sbcl-cffi
             sbcl-cl-opengl
             sbcl-documentation-utils))
      (arguments
       '(#:tests? #f                    ; No tests.
         #:asd-systems '("machine-state" "machine-state/opengl")))
      (home-page "https://shinmera.github.io/machine-state/")
      (synopsis "Retrieve machine state information about CPU time, memory usage and more")
      (description
       "This library implements various functions to access status information
about the machine, process, etc.")
      (license license:zlib))))

(define-public cl-machine-state
  (sbcl-package->cl-source-package sbcl-machine-state))

(define-public ecl-machine-state
  (sbcl-package->ecl-package sbcl-machine-state))

(define-public sbcl-macro-html
  (let ((commit "c769b5db9da6dd61365a21fc61ba07ea0f5f1963")
        (revision "0"))
    (package
      (name "sbcl-macro-html")
      (version (git-version "1.2" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/eugeneia/macro-html")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "05gzgijz8r3dw3ilz7d5i0g0mbcyv9k8w2dgvw7n478njp1gfj4b"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-named-readtables))
      (home-page "https://github.com/eugeneia/macro-html")
      (synopsis "HTML generation library")
      (description "Aims to be fast, modular, cachable and concise.  It does so
by defining each tag as a macro which expands to code printing the respective
HTML source.  Also employs a DSL for element attributes.")
      (license license:agpl1))))

(define-public ecl-macro-html
  (sbcl-package->ecl-package sbcl-macro-html))

(define-public cl-macro-html
  (sbcl-package->cl-source-package sbcl-macro-html))

(define-public sbcl-magic-ed
  (let ((commit "30bb27832d4e3e362578e7320934638f9889a8c4")
        (revision "1"))
    (package
      (name "sbcl-magic-ed")
      (version (git-version "0.2" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/sanel/magic-ed")
               (commit commit)))
         (file-name (git-file-name "cl-magic-ed" version))
         (sha256
          (base32 "1j6il4lif0dy6hqiz6n91yl8dvii9pk1i9vz0faq5mnr42mr7i5f"))))
      (build-system asdf-build-system/sbcl)
      (home-page "https://github.com/sanel/magic-ed")
      (synopsis "Editing facility for Common Lisp REPL")
      (description
       "Magic (ed) is a tiny editing facility for Common Lisp, where you can
directly load, edit, manipulate and evaluate file or file content from REPL.
This package also can be a starting point for people who are not accustomed to
Emacs or SLIME and would like to continue using their default terminal/console
editor with Common Lisp.")
      (license license:expat))))

(define-public cl-magic-ed
  (sbcl-package->cl-source-package sbcl-magic-ed))

(define-public ecl-magic-ed
  (sbcl-package->ecl-package sbcl-magic-ed))

(define-public sbcl-magicffi
  (let ((commit "d88f2f280c31f639e4e05be75215d8a8dce6aef2"))
    (package
      (name "sbcl-magicffi")
      (version (git-version "0.0.0" "1" commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/dochang/magicffi/")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "0p6ysa92fk34bhxpw7bycbfgw150fv11z9x8jr9xb4lh8cm2hvp6"))))
      (build-system asdf-build-system/sbcl)
      (native-inputs
       (list sbcl-alexandria))
      (inputs
       `(("cffi" ,sbcl-cffi)
         ("ppcre" ,sbcl-cl-ppcre)
         ("libmagic" ,file)))
      (arguments
       `(#:phases
         (modify-phases %standard-phases
           (add-after 'unpack 'fix-paths
             (lambda* (#:key inputs #:allow-other-keys)
               (let ((magic (assoc-ref inputs "libmagic")))
                 (substitute* "grovel.lisp"
                   (("/usr/include/magic.h")
                    (string-append magic "/include/magic.h")))
                 (substitute* "api.lisp"
                   ((":default \"libmagic\"" all)
                    (string-append ":default \"" magic "/lib/libmagic\"")))))))))
      (home-page "https://common-lisp.net/project/magicffi/")
      (synopsis "Common Lisp interface to libmagic based on CFFI")
      (description
       "MAGICFFI is a Common Lisp CFFI interface to libmagic(3), the file type
determination library using @emph{magic} numbers.")
      (license license:bsd-2))))

(define-public ecl-magicffi
  (sbcl-package->ecl-package sbcl-magicffi))

(define-public cl-magicffi
  (sbcl-package->cl-source-package sbcl-magicffi))

(define-public sbcl-magicl
  (package
    (name "sbcl-magicl")
    (version "0.11.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/quil-lang/magicl")
             (commit (string-append "v" version))))
       (file-name (git-file-name "cl-magicl" version))
       (sha256
        (base32 "10scw5qhrgjhfrlia5iqn2yy2zj1d57m45g479vg56lw849whscw"))))
    (build-system asdf-build-system/sbcl)
    (native-inputs (list gfortran sbcl-fiasco))
    (inputs
     (list lapack
           sbcl-abstract-classes
           sbcl-alexandria
           sbcl-cffi
           sbcl-interface
           sbcl-policy-cond
           sbcl-static-vectors
           sbcl-trivial-garbage))
    (arguments
     (list
      #:asd-systems ''("magicl" "magicl/ext-expokit")
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'fix-paths
            (lambda* (#:key inputs #:allow-other-keys)
              (substitute* "src/extensions/blas/load-libs.lisp"
                (("libblas.so")
                 (search-input-file inputs "/lib/libblas.so")))
              (substitute* "src/extensions/lapack/load-libs.lisp"
                (("liblapack.so")
                 (search-input-file inputs "/lib/liblapack.so"))))))))
    (synopsis "Matrix Algebra proGrams In Common Lisp")
    (description
     "This package provides matrix algebra functions for Common Lisp.")
    (home-page "https://github.com/quil-lang/magicl")
    (license license:bsd-3)))

(define-public cl-magicl
  (sbcl-package->cl-source-package sbcl-magicl))

(define-public sbcl-maiden
  (let ((commit "164e8df1b513fcbf097315b51242d337c183a5ef")
        (revision "1"))
    (package
      (name "sbcl-maiden")
      (version (git-version "3.1.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/Shirakumo/maiden/")
               (commit commit)))
         (sha256
          (base32 "1m16qi019cmfpfs6538hc4qsplpb8nl9ly1qlckgfxgjag0z3wdr"))
         (file-name (git-file-name "maiden" version))))
      (build-system asdf-build-system/sbcl)
      (arguments
       '(#:asd-systems '("maiden"
                         "maiden-commands"
                         "maiden-networking"
                         "maiden-client-entities"
                         "maiden-irc"
                         "maiden-silly")))
      (inputs
       (list sbcl-alexandria
             sbcl-babel
             sbcl-bordeaux-threads
             sbcl-cl-base64
             sbcl-cl+ssl
             sbcl-closer-mop
             sbcl-deeds
             sbcl-documentation-utils
             sbcl-drakma
             sbcl-form-fiddle
             sbcl-jsown
             sbcl-lambda-fiddle
             sbcl-lquery
             sbcl-pathname-utils
             sbcl-trivial-garbage
             sbcl-trivial-indent
             sbcl-ubiquitous
             sbcl-usocket
             sbcl-uuid
             sbcl-verbose))
      (synopsis "Modern and extensible chat bot framework")
      (description "Maiden is a collection of systems to help you build
applications and libraries that interact with chat servers.  It can help you
build a chat bot, or a general chat client.  It also offers a variety of parts
that should make it much easier to write a client for a new chat protocol.")
      (home-page "http://shirakumo.github.io/maiden/")
      (license license:zlib))))

(define-public maiden
  (sbcl-package->cl-source-package sbcl-maiden))

(define-public sbcl-maidenhead
  (let ((commit "4b9c38e4845dda56ae7fb0355c5260c9ade0ac12")
        (revision "1"))
    (package
      (name "sbcl-maidenhead")
      (version (git-version "1.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://codeberg.org/glv/maidenhead")
               (commit commit)))
         (file-name (git-file-name "cl-maidenhead" version))
         (sha256
          (base32 "10pcx2ngyj6lkfbg1b58lzcm02xl1a3smnad5lvvw30pbalwcq46"))))
      (build-system asdf-build-system/sbcl)
      (native-inputs
       (list sbcl-fiveam))
      (synopsis
       "Convert coordinates between latitude/longitude and Maidenhead")
      (description
       "This a Common Lisp library to convert geographic coordinates between
latitude/longitude and Maidenhead locator system.")
      (home-page "https://codeberg.org/glv/maidenhead")
      (license license:gpl3+))))

(define-public cl-maidenhead
  (sbcl-package->cl-source-package sbcl-maidenhead))

(define-public ecl-maidenhead
  (sbcl-package->ecl-package sbcl-maidenhead))

(define-public sbcl-make-hash
  ;; no tagged branch
  (let ((revision "1")
        (commit "ae0909cd8e697520a1085fac6f54ac2b448ebd21"))
    (package
      (name "sbcl-make-hash")
      (version (git-version "1.0.2" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/genovese/make-hash")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "1qa4mcmb3pv44py0j129dd8hjx09c2akpnds53b69151mgwv5qz8"))))
      (build-system asdf-build-system/sbcl)
      (home-page "https://github.com/genovese/make-hash")
      (synopsis "Common Lisp package for flexible hash table creation")
      (description
       "This is a Common Lisp package for hash table creation with flexible,
extensible initializers.")
      (license license:bsd-3))))

(define-public cl-make-hash
  (sbcl-package->cl-source-package sbcl-make-hash))

(define-public ecl-make-hash
  (sbcl-package->ecl-package sbcl-make-hash))

(define-public clasp-make-hash
  (sbcl-package->clasp-package sbcl-make-hash))

(define-public sbcl-map-bind
  (let ((commit "532d55d93540c632e22b2cd264b5daa5f9d3d900")
        (revision "0"))
    (package
      (name "sbcl-map-bind")
      (version (git-version "1.0" revision commit))
      (source
        (origin
          (method git-fetch)
          (uri (git-reference
                (url "https://github.com/Hexstream/map-bind")
                (commit commit)))
          (file-name (git-file-name "cl-map-bind" version))
          (sha256
           (base32 "0hfy65xyqc4zqfncn11pp3hjjkdz7m91cynnv91s3lgcl3kffva0"))))
      (build-system asdf-build-system/sbcl)
      (native-inputs
        (list sbcl-parachute))
      (home-page "https://www.hexstreamsoft.com/libraries/map-bind/")
      (synopsis "Macro favouring positional references over naming")
      (description
       "@code{MAP-BIND} is a macro that allows visual grouping of variables with
their corresponding values in calls to mapping operators when using an
inline @code{LAMBDA}.")
      (license license:unlicense))))

(define-public cl-map-bind
  (sbcl-package->cl-source-package sbcl-map-bind))

(define-public ecl-cl-map-bind
  (sbcl-package->ecl-package sbcl-map-bind))

(define-public sbcl-map-set
  (let ((commit "7b4b545b68b8")
        (revision "1"))
    (package
      (name "sbcl-map-set")
      (version (git-version "0.0.0" revision commit))
      (source
       (origin
         (method url-fetch)
         (uri (string-append
               "https://bitbucket.org/tarballs_are_good/map-set/get/"
               commit ".tar.gz"))
         (sha256
          (base32 "1sx5j5qdsy5fklspfammwb16kjrhkggdavm922a9q86jm5l0b239"))))
      (build-system asdf-build-system/sbcl)
      (home-page "https://bitbucket.org/tarballs_are_good/map-set")
      (synopsis "Set-like data structure")
      (description
       "Implementation of a set-like data structure with constant time
addition, removal, and random selection.")
      (license license:bsd-3))))

(define-public cl-map-set
  (sbcl-package->cl-source-package sbcl-map-set))

(define-public ecl-map-set
  (sbcl-package->ecl-package sbcl-map-set))

(define-public clasp-map-set
  (sbcl-package->clasp-package sbcl-map-set))

;;; The following package is renamed from "markup" to "markup-reader" in order
;;; not to conflict with the "cl-markup" package.
(define-public sbcl-markup-reader
  (let ((commit "d2d4d7b073554f47c24223a9304452966608702e")
        (revision "1"))
    (package
      (name "sbcl-markup-reader")
      (version (git-version "0.0.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/moderninterpreters/markup")
               (commit commit)))
         (file-name (git-file-name "markup-reader" version))
         (sha256
          (base32 "0i3v938j8zpzkd6p9j8gadp5zndjcdxhswj1qgsp592v6497rpzj"))))
      (build-system asdf-build-system/sbcl)
      (arguments
       '(#:asd-systems '("markup")))
      (native-inputs
       (list sbcl-fiveam))
      (inputs
       `(("alexandria" ,sbcl-alexandria)
         ("cl-str" ,sbcl-cl-str)
         ("named-readtables" ,sbcl-named-readtables)
         ("trivial-gray-streams" ,sbcl-trivial-gray-streams)))
      (home-page "https://github.com/moderninterpreters/markup")
      (synopsis "Reader-macro to read HTML tags inside of Common Lisp code")
      (description
       "Markup allows the use of HTML syntax with in Common Lisp code.
This has the advantage of being able to copy HTML snippets and have them
instantly be functional, less double quotes than a s-expression approach,
and designers will be able to understand the embedded HTML.")
      (license license:asl2.0))))

(define-public cl-markup-reader
  (sbcl-package->cl-source-package sbcl-markup-reader))

(define-public ecl-markup-reader
  (sbcl-package->ecl-package sbcl-markup-reader))

(define-public sbcl-marray
  (let ((commit "0352f316b6830f0b119088ba9be836e4726bd7d8")
        (revision "0"))
    (package
      (name "sbcl-marray")
      (version (git-version "0.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/death/marray")
               (commit commit)))
         (file-name (git-file-name "cl-marray" version))
         (sha256
          (base32 "0l4kvzpiw14vqhlsaflp3c7y51vznjjgbdi0q3axqk1wxvzy1zlx"))))
      (build-system asdf-build-system/sbcl)
      (arguments
       '(#:phases
         (modify-phases %standard-phases
           (add-after 'unpack 'fix-dependencies
             (lambda _
               (substitute* "marray.asd"
                 ((":components")
                  ":depends-on (#+sbcl \"sb-posix\")\n  :components")))))))
      (home-page "https://github.com/death/marray")
      (synopsis "Memory-mapped files as Common Lisp arrays")
      (description
       "MARRAY is a library which provides access to memory-mapped files
through Common Lisp arrays.")
      (license license:expat))))

(define-public cl-marray
  (sbcl-package->cl-source-package sbcl-marray))

;; ECL support not implemented yet.
;; (define-public ecl-marray
;;   (sbcl-package->ecl-package sbcl-marray))

(define-public sbcl-marshal
  (let ((commit "eff1b15f2b0af2f26f71ad6a4dd5c4beab9299ec")
        (revision "1"))
    (package
     (name "sbcl-marshal")
     (version (git-version "1.3.0" revision commit))
     (source
      (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/wlbr/cl-marshal")
             (commit commit)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "08qs6fhk38xpkkjkpcj92mxx0lgy4ygrbbzrmnivdx281syr0gwh"))))
     (build-system asdf-build-system/sbcl)
     (home-page "https://github.com/wlbr/cl-marshal")
     (synopsis "Simple (de)serialization of Lisp datastructures")
     (description
      "Simple and fast marshalling of Lisp datastructures.  Convert any object
into a string representation, put it on a stream an revive it from there.
Only minimal changes required to make your CLOS objects serializable.")
     (license license:expat))))

(define-public cl-marshal
  (sbcl-package->cl-source-package sbcl-marshal))

(define-public ecl-marshal
  (sbcl-package->ecl-package sbcl-marshal))

(define-public clasp-marshal
  (sbcl-package->clasp-package sbcl-marshal))

(define-public sbcl-mathkit
  (let ((commit "fd884f94b36ef5e9bc19459ad0b3cda6303d2a2a"))
    (package
      (name "sbcl-mathkit")
      (version (git-version "0.0" "1" commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/lispgames/mathkit/")
               (commit commit)))
         (file-name (git-file-name "cl-mathkit" version))
         (sha256
          (base32 "174y6ndmf52h8sml87qjfl48llmynvdizzk2h0mr85zbaysx73i3"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-alexandria
             sbcl-sb-cga))
      (home-page "https://github.com/lispgames/mathkit/")
      (synopsis "Pure math functions useful for games, 3D, and GL in general")
      (description
       "This is a purely math-related utility kit, providing functions which
can be useful for games, 3D, and GL in general.")
      (license license:expat))))

(define-public cl-mathkit
  (sbcl-package->cl-source-package sbcl-mathkit))

(define-public ecl-mathkit
  (sbcl-package->ecl-package sbcl-mathkit))

(define-public sbcl-maxpc
  (let ((commit "e5e58d053039517d30fd59ab2d128256b87790d5")
        (revision "1"))
    (package
      (name "sbcl-maxpc")
      (version (git-version "0.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/eugeneia/maxpc")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "15wrjbr2js6j67c1dd4p2qxj49q9iqv1lhb7cwdcwpn79crr39gf"))))
      (build-system asdf-build-system/sbcl)
      (arguments
       ;; FIXME: A test fails with:
       ;;   The assertion
       ;;   (EQUAL (MULTIPLE-VALUE-LIST (MAXPC:GET-INPUT-POSITION))
       ;;          '(7 2 2))
       ;;   failed with
       ;;   (MULTIPLE-VALUE-LIST (MAXPC:GET-INPUT-POSITION)) = (7).
       (list #:tests? #f))
      (home-page "https://mr.gy/software/maxpc/api.html")
      (synopsis
       "Library for writing parsers and lexers based on combinatory parsing")
      (description
       "@emph{Max’s Parser Combinators} is a simple and pragmatic library for
writing parsers and lexers based on combinatory parsing.  MaxPC is capable of
parsing deterministic, context-free languages, provides powerful tools for
parse tree transformation and error handling, and can operate on
@dfn{sequences} and @dfn{streams}.  It supports unlimited backtracking, but
does not implement @url{http://pdos.csail.mit.edu/~baford/packrat/thesis/,
Packrat Parsing}.  Instead, MaxPC achieves good performance through its
optimized primitives, and explicit separation of matching and capturing input.
In practice, MaxPC parsers perform better on typical computer languages—when
compared to Packrat parsers—at the expense of not producing linear-time
parsers.")
      (license license:agpl3))))

(define-public cl-maxpc
  (sbcl-package->cl-source-package sbcl-maxpc))

(define-public ecl-maxpc
  (sbcl-package->ecl-package sbcl-maxpc))

(define-public sbcl-mcclim
  (package
    (name "sbcl-mcclim")
    (version "0.9.9")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://codeberg.org/McCLIM/McCLIM")
             (commit (string-append version "-ostara"))))
       (file-name (git-file-name "cl-mcclim" version))
       (sha256
        (base32 "0lf0af7c9kl2gzjm3j1p8z596iws86gn93ckhrba52ia5vz1iq4k"))))
    (build-system asdf-build-system/sbcl)
    (native-inputs
     (list sbcl-fiveam pkg-config))
    (inputs
     (list fontconfig
           freetype
           harfbuzz
           sbcl-alexandria
           sbcl-babel
           sbcl-bordeaux-threads
           sbcl-cffi
           sbcl-cl-base64
           sbcl-cl-dejavu
           sbcl-cl-freetype2
           sbcl-cl-pdf
           sbcl-cl-unicode
           sbcl-cl-vectors
           sbcl-cl-who
           sbcl-closer-mop
           sbcl-cluffer
           sbcl-clx
           sbcl-flexi-streams
           sbcl-flexichain
           sbcl-log4cl
           sbcl-lorem-ipsum
           sbcl-opticl
           sbcl-slime-swank
           sbcl-spatial-trees
           sbcl-trivial-features
           sbcl-trivial-garbage
           sbcl-trivial-gray-streams
           sbcl-zpb-ttf))
    (arguments
     '(#:asd-systems '("mcclim"
                       "clim-examples"
                       ;; clim-debugger is required by cleavir.
                       "clim-debugger")
       #:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'fix-paths
           (lambda* (#:key inputs #:allow-other-keys)
             (substitute* "Extensions/fontconfig/src/functions.lisp"
               (("libfontconfig\\.so")
                (search-input-file inputs "/lib/libfontconfig.so")))
             (substitute* "Extensions/harfbuzz/src/functions.lisp"
               (("libharfbuzz\\.so")
                (search-input-file inputs "/lib/libharfbuzz.so"))))))))
    (home-page "https://mcclim.common-lisp.dev/")
    (synopsis "Common Lisp GUI toolkit")
    (description
     "McCLIM is an implementation of the @emph{Common Lisp Interface Manager
specification}, a toolkit for writing GUIs in Common Lisp.")
    (license license:lgpl2.1+)))

(define-public cl-mcclim
  (sbcl-package->cl-source-package sbcl-mcclim))

(define-public ecl-mcclim
  (let ((pkg (sbcl-package->ecl-package sbcl-mcclim)))
    (package
      (inherit pkg)
      (arguments
       (substitute-keyword-arguments (package-arguments pkg)
         ;; Tests fail with "FUNCTION: Not a valid argument (R1
         ;; (GENERATE-REGION))."  on ECL.
         ((#:tests? _ #f) #f))))))

(define-public sbcl-md5
  (package
    (name "sbcl-md5")
    (version "2.0.5")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
              (url "https://github.com/pmai/md5")
              (commit (string-append "release-" version))))
       (file-name (git-file-name "md5" version))
       (sha256
        (base32 "1g20np6rhn3y08z8mlmlk721mw2207s52v2pwp4smm3lz25sx3q5"))))
    (build-system asdf-build-system/sbcl)
    (home-page "https://github.com/pmai/md5")
    (synopsis
     "Common Lisp implementation of the MD5 Message-Digest Algorithm (RFC 1321)")
    (description
     "This package implements The MD5 Message-Digest Algorithm, as defined in
RFC 1321 by R. Rivest, published April 1992.")
    (license license:public-domain)))

(define-public cl-md5
  (sbcl-package->cl-source-package sbcl-md5))

(define-public ecl-md5
  (package
    (inherit (sbcl-package->ecl-package sbcl-md5))
    (inputs
     (list ecl-flexi-streams))))

(define-public sbcl-messagebox
  (let ((commit "ea3688d9a9954bee7079c0173bc7b3f327021e9f")
        (revision "1"))
    (package
      (name "sbcl-messagebox")
      (version (git-version "1.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/Shinmera/messagebox")
               (commit commit)))
         (file-name (git-file-name "messagebox" version))
         (sha256
          (base32 "0jkbzlca0wvspgsfj0b0hjwlyyy8jlywsldsbkp79q48fc3aa8jd"))))
      (build-system asdf-build-system/sbcl)
      (arguments
       `(#:phases
         (modify-phases %standard-phases
           (add-after 'unpack 'patch-zenity-path
             (lambda* (#:key inputs #:allow-other-keys)
               (substitute* "zenity.lisp"
                 (("\"zenity\"")
                  (string-append "\"" (assoc-ref inputs "zenity")
                                 "/bin/zenity\""))))))))
      (inputs
       `(("documentation-utils" ,sbcl-documentation-utils)
         ("trivial-features" ,sbcl-trivial-features)
         ("zenity" ,zenity)))
      (home-page "https://shinmera.github.io/messagebox/")
      (synopsis "Display a native GUI message box")
      (description
       "This is a small library to display a native GUI message box.  This can be
useful to show error messages and other informational pieces should the
application fail and be unable to do so using its standard UI.")
      (license license:zlib))))

(define-public cl-messagebox
  (sbcl-package->cl-source-package sbcl-messagebox))

(define-public ecl-messagebox
  (sbcl-package->ecl-package sbcl-messagebox))

(define-public sbcl-meta
  (let ((commit "74faea662139fbbfb9c99341aaed989f5b0e9da3")
        (revision "0"))
    (package
      (name "sbcl-meta")
      (version (git-version "1.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://gitlab.common-lisp.net/frideau/meta")
               (commit commit)))
         (file-name (git-file-name "cl-meta" version))
         (sha256
          (base32 "08s53zj3mcx82kszp1bg2vsb4kydvkc70kj4hpq9h1l5a1wh44cy"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-named-readtables))
      (home-page "https://gitlab.common-lisp.net/frideau/meta")
      (synopsis "Recursive-descent parser DSL for Common Lisp")
      (description
       "This package provides a recursive-descent parser DSL for Common Lisp.
It's intended as a simpler alternative to parser generators.")
      (license license:bsd-2))))

(define-public cl-meta
  (sbcl-package->cl-source-package sbcl-meta))

(define-public ecl-meta
  (sbcl-package->ecl-package sbcl-meta))

(define-public sbcl-metabang-bind
  (let ((commit "08196426cb099db0623e6cae2aeca566e0b788b2")
        (revision "2"))
    (package
      (name "sbcl-metabang-bind")
      (version (git-version "0.8.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/hraban/metabang-bind")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "14g7k3zhm8cd6bssc5mm5h6iq1dv5lfhiq33aimcmj5a6vbiq47d"))))
      (build-system asdf-build-system/sbcl)
      (native-inputs
       (list sbcl-lift))
      (synopsis "Macro that generalizes @code{multiple-value-bind} etc.")
      (description
       "Bind extends the idea of of let and destructing to provide a uniform
syntax for all your accessor needs.  It combines @code{let},
@code{destructuring-bind}, @code{with-slots}, @code{with-accessors}, structure
editing, property or association-lists, and @code{multiple-value-bind} and a
whole lot more into a single form.")
      (home-page "https://common-lisp.net/project/metabang-bind/")
      ;; MIT License
      (license license:expat))))

(define-public cl-metabang-bind
  (sbcl-package->cl-source-package sbcl-metabang-bind))

(define-public ecl-metabang-bind
  (sbcl-package->ecl-package sbcl-metabang-bind))

(define-public sbcl-metacopy
  (let ((commit "df7856f2a43fa91124fe780ef22f792040bc130c")
        (revision "2"))
    (package
      (name "sbcl-metacopy")
      (version (git-version "0.2.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               ;; Upstream changed the maintainer.
               ;; legacy https://github.com/gwkkwg/metacopy
               (url "https://github.com/hraban/metacopy")
               (commit commit)))
         (file-name (git-file-name "cl-metacopy" version))
         (sha256
          (base32 "0l5ryg8pvqz9sn9s8bsvd0plvcnm7crsx86iqk5wxblkialaizip"))))
      (build-system asdf-build-system/sbcl)
      (native-inputs
       (list sbcl-asdf-system-connections sbcl-lift))
      (inputs
       (list sbcl-contextl sbcl-moptilities))
      (home-page "https://github.com/hraban/metacopy")
      (synopsis "Flexible Common Lisp shallow/deep copy mechanism")
      (description
       "This package provides a flexible shallow/deep copy mechanism for
Common Lisp.")
      (license license:expat))))

(define-public cl-metacopy
  (sbcl-package->cl-source-package sbcl-metacopy))

(define-public ecl-metacopy
  (sbcl-package->ecl-package sbcl-metacopy))

(define-public sbcl-metatilities-base
  (let ((commit "ef04337759972fd622c9b27b53149f3d594a841f")
        (revision "2"))
    (package
      (name "sbcl-metatilities-base")
      (version (git-version "0.6.6" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/hraban/metatilities-base")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "069rk5ncwvjnnzvvky6xiriynl72yzvjpnzl6jw9jf3b8na14zrk"))))
      (build-system asdf-build-system/sbcl)
      (native-inputs
       (list sbcl-lift))
      (synopsis "Core of the metatilities Common Lisp library")
      (description
       "Metatilities-base is the core of the metatilities Common Lisp library
which implements a set of utilities.")
      (home-page "https://common-lisp.net/project/metatilities-base/")
      (license license:expat))))

(define-public cl-metatilities-base
  (sbcl-package->cl-source-package sbcl-metatilities-base))

(define-public ecl-metatilities-base
  (sbcl-package->ecl-package sbcl-metatilities-base))

(define-public sbcl-metering
  (let ((commit "62dbaa5e8d29d2f213b881d740114941c2c3d1be")
        (revision "0"))
    (package
      (name "sbcl-metering")
      (version (git-version "3.2" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://gitlab.common-lisp.net/dkochmanski/metering")
               (commit commit)))
         (file-name (git-file-name "cl-metering" version))
         (sha256
          (base32 "0jx3ypk8m815yp7208xkcxkvila847mvna25a2p22ihnj0ms9rn1"))))
      (build-system asdf-build-system/sbcl)
      (native-inputs (list sbcl-fiveam))
      (synopsis "Common Lisp code profiling tool")
      (description
       "The Metering System is a portable Common Lisp code profiling tool.
It gathers timing and consing statistics for specified functions while
a program is running.")
      (home-page "https://gitlab.common-lisp.net/dkochmanski/metering")
      (license license:public-domain))))

(define-public cl-metering
  (sbcl-package->cl-source-package sbcl-metering))

(define-public ecl-metering
  (sbcl-package->ecl-package sbcl-metering))

(define-public sbcl-mgl-gpr
  (let ((commit "cb6ce51e2f87bf1d589f3703c13eea6e25780afe")
        (revision "1"))
    (package
      (name "sbcl-mgl-gpr")
      (version (git-version "0.0.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/melisgl/mgl-gpr")
               (commit commit)))
         (file-name (git-file-name "cl-mgl-gpr" version))
         (sha256
          (base32 "0w51dqixh277k6sl8bqvvp1400y6kd1l5h3d9q2f40l9bpxy8gjx"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-cl-random sbcl-mgl-pax))
      (home-page "https://melisgl.github.io/mgl-gpr/")
      (synopsis "Common Lisp library of evolutionary algorithms")
      (description
       "@code{MGL-GPR} is a library of evolutionary algorithms such as
Genetic Programming (evolving typed expressions from a set of operators and
constants) and Differential Evolution.")
      (license license:expat))))

(define-public cl-mgl-gpr
  (sbcl-package->cl-source-package sbcl-mgl-gpr))

(define-public ecl-mgl-gpr
  (sbcl-package->ecl-package sbcl-mgl-gpr))

(define-public sbcl-mgl-pax
  (let ((commit "6782eb041c152721972420dfafa192692d16b7ce")
        (revision "1"))
    (package
      (name "sbcl-mgl-pax")
      (version (git-version "0.3.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/melisgl/mgl-pax")
               (commit commit)))
         (sha256
          (base32 "0fjbzc2fn17m80lfsc8121sa0bk7fg42fqlwhm01sk1fj4s48pma"))
         (file-name (git-file-name "cl-mgl-pax" version))))
      (build-system asdf-build-system/sbcl)
      ;; (native-inputs
      ;;  (list sbcl-try))
      (inputs
       (list sbcl-3bmd
             sbcl-alexandria
             sbcl-colorize
             sbcl-md5
             sbcl-named-readtables
             sbcl-pythonic-string-reader
             sbcl-slime-swank
             sbcl-trivial-utf-8))
      (arguments
       `(#:asd-systems '("mgl-pax"
                         "mgl-pax/navigate"
                         "mgl-pax/document"
                         "mgl-pax/transcribe")
         ;; Tests disabled because of a circular dependency
         ;;   try -> mgl-pax -> try
         #:tests? #f))
      (synopsis "Exploratory programming environment and documentation generator")
      (description
       "PAX provides an extremely poor man's Explorable Programming
environment.  Narrative primarily lives in so called sections that mix markdown
docstrings with references to functions, variables, etc, all of which should
probably have their own docstrings.

The primary focus is on making code easily explorable by using SLIME's
@command{M-.} (@command{slime-edit-definition}).  See how to enable some
fanciness in Emacs Integration.  Generating documentation from sections and all
the referenced items in Markdown or HTML format is also implemented.

With the simplistic tools provided, one may accomplish similar effects as with
Literate Programming, but documentation is generated from code, not vice versa
and there is no support for chunking yet.  Code is first, code must look
pretty, documentation is code.")
      (home-page "https://melisgl.github.io/mgl-pax/")
      (license license:expat))))

(define-public cl-mgl-pax
  (sbcl-package->cl-source-package sbcl-mgl-pax))

(define-public ecl-mgl-pax
  (sbcl-package->ecl-package sbcl-mgl-pax))

(define-public sbcl-mgrs
  (let ((commit "c06f268f9ccb00dfc94c8a07771ce1ca82df26a2")
        (revision "1"))
    (package
      (name "sbcl-mgrs")
      (version (git-version "1.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://codeberg.org/glv/mgrs")
               (commit commit)))
         (file-name (git-file-name "cl-mgrs" version))
         (sha256
          (base32 "1n4kd734qjj7mrcg0q28hml3npam1rm067iwljwc87zshnxh5gmn"))))
      (build-system asdf-build-system/sbcl)
      (native-inputs
       (list sbcl-fiveam))
      (inputs
       (list sbcl-utm-ups))
      (synopsis
       "Convert coordinates between latitude/longitude and MGRS")
      (description
       "This a Common Lisp library to convert geographic coordinates between
latitude/longitude and MGRS.")
      (home-page "https://codeberg.org/glv/mgrs")
      (license license:gpl3+))))

(define-public cl-mgrs
  (sbcl-package->cl-source-package sbcl-mgrs))

(define-public ecl-mgrs
  (sbcl-package->ecl-package sbcl-mgrs))

(define-public sbcl-misc-extensions
  (package
    (name "sbcl-misc-extensions")
    (version "4.0.3")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://gitlab.common-lisp.net/misc-extensions/misc-extensions.git")
             (commit (string-append "v" version))))
       (file-name (git-file-name "cl-misc-extensions" version))
       (sha256
        (base32
         "02hw5k7zfzs736dhpcii8ncvx3ia4l5byw5ngzmhydqscbi4hcvc"))))
    (build-system asdf-build-system/sbcl)
    (synopsis "Collection of small macros and extensions for Common Lisp")
    (description
     "This project is intended as a catchall for small, general-purpose
extensions to Common Lisp.  It contains:

@itemize
@item @code{new-let}, a macro that combines and generalizes @code{let},
@code{let*} and @code{multiple-value-bind},
@item @code{gmap}, an iteration macro that generalizes @code{map}.
@end itemize\n")
    (home-page "https://common-lisp.net/project/misc-extensions/")
    (license license:public-domain)))

(define-public cl-misc-extensions
  (sbcl-package->cl-source-package sbcl-misc-extensions))

(define-public ecl-misc-extensions
  (sbcl-package->ecl-package sbcl-misc-extensions))

(define-public clasp-misc-extensions
  (sbcl-package->clasp-package sbcl-misc-extensions))

(define-public sbcl-mito
  (let ((commit "10c22b64047053b079beb5168d21222abe4d4b1d")
        (revision "4"))
    (package
      (name "sbcl-mito")
      (version (git-version "0.2.0" revision commit))
      (home-page "https://github.com/fukamachi/mito")
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url home-page)
               (commit commit)))
         (file-name (git-file-name "mito" version))
         (sha256
          (base32 "0yx1hf22k3wgl0b274i25i6cnshijzy7wppi6clgmhi2y5svgddr"))))
      (build-system asdf-build-system/sbcl)
      (native-inputs
       (list sbcl-prove))
      (inputs
       (list sbcl-alexandria
             sbcl-chipz
             sbcl-cl-package-locks
             sbcl-cl-ppcre
             sbcl-cl-reexport
             sbcl-closer-mop
             sbcl-dbi
             sbcl-dissect
             sbcl-esrap
             sbcl-local-time
             sbcl-sxql
             sbcl-trivia
             sbcl-uuid))
      (arguments
       '(#:phases
         (modify-phases %standard-phases
           (add-after 'unpack 'remove-non-functional-tests
             (lambda _
               (substitute* "mito-test.asd"
                 (("\\(:test-file \"db/mysql\"\\)") "")
                 (("\\(:test-file \"db/postgres\"\\)") "")
                 (("\\(:test-file \"dao\"\\)") "")
                 ;; TODO: migration/sqlite3 should work, re-enable once
                 ;; upstream has fixed it:
                 ;; https://github.com/fukamachi/mito/issues/70
                 (("\\(:test-file \"migration/sqlite3\"\\)") "")
                 (("\\(:test-file \"migration/mysql\"\\)") "")
                 (("\\(:test-file \"migration/postgres\"\\)") "")
                 (("\\(:test-file \"postgres-types\"\\)") "")
                 (("\\(:test-file \"mixin\"\\)") ""))
               #t)))
         #:asd-systems '("mito-test" "mito")))
      (synopsis "ORM for Common Lisp with migrations and relationships support")
      (description "Mito is yet another object relational mapper, and it aims
to be a successor of Integral.

@itemize
@item Support MySQL, PostgreSQL and SQLite3.
@item Add id (serial/uuid primary key), created_at and updated_at by default
like Ruby's ActiveRecord.
@item Migrations.
@item Database schema versioning.
@end itemize\n")
      (license license:llgpl))))

(define-public cl-mito
  (sbcl-package->cl-source-package sbcl-mito))

(define-public ecl-mito
  (let ((pkg (sbcl-package->ecl-package sbcl-mito)))
    (package
      (inherit pkg)
      (arguments
       ;; FIXME: Tests never end.
       '(#:tests? #f)))))

(define-public sbcl-mito-auth
  (let ((commit "262f0f1c132195daa8840e69ece2780111383d05")
        (revision "0"))
    (package
      (name "sbcl-mito-auth")
      (version (git-version "0.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/fukamachi/mito-auth/")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "03k4wgyyvyx7f6nznfyl1mrms9z39pkwn4wnpwj8jfsg3zcny0k3"))))
      (build-system asdf-build-system/sbcl)
      (inputs (list sbcl-mito sbcl-ironclad sbcl-babel))
      (home-page "https://github.com/fukamachi/mito-auth/")
      (synopsis "Mito mixin class for user authorization")
      (description
       "@code{mito-auth} provides a @code{mito} mixin class for user
authorization.")
      (license license:llgpl))))

(define-public cl-mito-auth
  (sbcl-package->cl-source-package sbcl-mito-auth))

(define-public ecl-mito-auth
  (sbcl-package->ecl-package sbcl-mito-auth))

(define-public sbcl-mk-string-metrics
  (package
    (name "sbcl-mk-string-metrics")
    (version "0.1.2")
    (home-page "https://github.com/cbaggers/mk-string-metrics/")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url home-page)
                    (commit version)))
              (sha256
               (base32 "0bg0bv2mfd4k0g3x72x563hvmrx18xavaffr6xk5rh4if5j7kcf6"))
              (file-name (git-file-name name version))))
    (build-system asdf-build-system/sbcl)
    (synopsis "Calculate various string metrics efficiently in Common Lisp")
    (description "This library implements efficient algorithms that calculate
various string metrics in Common Lisp:

@itemize
@item Damerau-Levenshtein distance
@item Hamming distance
@item Jaccard similarity coefficient
@item Jaro distance
@item Jaro-Winkler distance
@item Levenshtein distance
@item Normalized Damerau-Levenshtein distance
@item Normalized Levenshtein distance
@item Overlap coefficient
@end itemize\n")
    (license license:x11)))

(define-public cl-mk-string-metrics
  (sbcl-package->cl-source-package sbcl-mk-string-metrics))

(define-public ecl-mk-string-metrics
  (sbcl-package->ecl-package sbcl-mk-string-metrics))

(define-public sbcl-mmap
  (let ((commit "ba2e98c67e25f0fb8ff838238561120a23903ce7")
        (revision "0"))
    (package
      (name "sbcl-mmap")
      (version (git-version "1.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/Shinmera/mmap")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "0qd0xp20i1pcfn12kkapv9pirb6hd4ns7kz4zf1mmjwykpsln96q"))))
      (build-system asdf-build-system/sbcl)
      (native-inputs
       (list sbcl-alexandria sbcl-cffi sbcl-parachute
             sbcl-trivial-features))
      (inputs
       (list sbcl-cffi sbcl-documentation-utils))
      (home-page "https://shinmera.github.io/mmap/")
      (synopsis "File memory mapping for Common Lisp")
      (description
       "This is a utility library providing access to the @emph{mmap} family of
functions in a portable way.  It allows you to directly map a file into the
address space of your process without having to manually read it into memory
sequentially.  Typically this is much more efficient for files that are larger
than a few Kb.")
      (license license:zlib))))

(define-public cl-mmap
  (sbcl-package->cl-source-package sbcl-mmap))

(define-public ecl-mmap
  (sbcl-package->ecl-package sbcl-mmap))

(define-public sbcl-modf
  (let ((commit "dea93fe62c6bf7f66f32f52ac0c555aedbf7abad")
        (revision "0"))
    (package
      (name "sbcl-modf")
      (version (git-version "0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/smithzvk/modf")
               (commit commit)))
         (file-name (git-file-name "cl-modf" version))
         (sha256
          (base32
           "1aap7ldy7lv942khp026pgndgdzfkkqa9xcq1ykinrmflrgdazay"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-alexandria
             sbcl-closer-mop
             sbcl-iterate))
      (native-inputs
       (list sbcl-stefil))
      (home-page "https://github.com/smithzvk/modf")
      (synopsis "SETF like macro for functional programming in Common Lisp")
      (description "This library simplifies functional programming in Common
Lisp by making it easier to make new data structures with specified changes in
place.")
      (license license:bsd-3))))

(define-public cl-modf
  (sbcl-package->cl-source-package sbcl-modf))

(define-public ecl-modf
  (sbcl-package->ecl-package sbcl-modf))

(define-public sbcl-modularize
  (let ((commit "86c5d9a11fbd2df9f0f03ac10b5d71837c8934ba")
        (revision "1"))
    (package
      (name "sbcl-modularize")
      (version (git-version "1.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/Shinmera/modularize")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "1zys29rfkb649rkgl3snxhajk8d5yf7ryxkrwy020kwdh7zdsg7d"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       `(("documentation-utils" ,sbcl-documentation-utils)
         ("trivial-package-local-nicknames" ,sbcl-trivial-package-local-nicknames)))
      (home-page "https://shinmera.github.io/modularize/")
      (synopsis "Common Lisp modularization framework")
      (description
       "@code{MODULARIZE} is an attempt at providing a common interface to
segregate major application components.  This is achieved by adding special
treatment to packages.  Each module is a package that is specially registered,
which allows it to interact and co-exist with other modules in better ways.  For
instance, by adding module definition options you can introduce mechanisms to
tie modules together in functionality, hook into each other and so on.")
      (license license:zlib))))

(define-public ecl-modularize
  (sbcl-package->ecl-package sbcl-modularize))

(define-public cl-modularize
  (sbcl-package->cl-source-package sbcl-modularize))

(define-public sbcl-modularize-hooks
  (let ((commit "e0348ed3ffd59a9ec31ca4ab28289e748bfbf96a")
        (revision "1"))
    (package
      (name "sbcl-modularize-hooks")
      (version (git-version "1.0.2" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/Shinmera/modularize-hooks")
               (commit commit)))
         (file-name (git-file-name "modularize-hooks" version))
         (sha256
          (base32 "12kjvin8hxidwkzfb7inqv5b6g5qzcssnj9wc497v2ixc56fqdz7"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-closer-mop sbcl-lambda-fiddle sbcl-modularize
             sbcl-trivial-arguments))
      (home-page "https://shinmera.github.io/modularize-hooks/")
      (synopsis "Generic hooks and triggers extension for Modularize")
      (description
       "This is a simple extension to @code{MODULARIZE} that allows modules to
define and trigger hooks, which other modules can hook on to.")
      (license license:zlib))))

(define-public ecl-modularize-hooks
  (sbcl-package->ecl-package sbcl-modularize-hooks))

(define-public cl-modularize-hooks
  (sbcl-package->cl-source-package sbcl-modularize-hooks))

(define-public sbcl-modularize-interfaces
  (let ((commit "96353657afb8c7aeba7ef5b51eb04c5ed3bcb6ef")
        (revision "1"))
    (package
      (name "sbcl-modularize-interfaces")
      (version (git-version "0.9.3" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/Shinmera/modularize-interfaces")
               (commit commit)))
         (file-name (git-file-name "modularize-interfaces" version))
         (sha256
          (base32 "0bjf4wy39cwf75m7vh0r7mmcchs09yz2lrbyap98hnq8blq70fhc"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-lambda-fiddle sbcl-modularize sbcl-trivial-arguments
             sbcl-trivial-indent))
      (home-page "https://shinmera.github.io/modularize-interfaces/")
      (synopsis "Programmatical interfaces extension for Modularize")
      (description
       "This is an extension to @code{MODULARIZE} that allows your application
to define interfaces in-code that serve both as a primary documentation and as
compliance control.")
      (license license:zlib))))

(define-public ecl-modularize-interfaces
  (sbcl-package->ecl-package sbcl-modularize-interfaces))

(define-public cl-modularize-interfaces
  (sbcl-package->cl-source-package sbcl-modularize-interfaces))

(define-public sbcl-moira
  (let ((commit "448d8e77b95f5de7b41d2897a2167c4b1fb85a76")
        (revision "1"))
    (package
      (name "sbcl-moira")
      (version (git-version "0.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/ruricolist/moira")
               (commit commit)))
         (file-name (git-file-name "cl-moira" version))
         (sha256
          (base32 "01wxjg122flla4pgys57hya3fwrkyjkpp26j5ypl5885zz1ip5b7"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-alexandria
             sbcl-bordeaux-threads
             sbcl-osicat
             sbcl-serapeum
             sbcl-trivial-features
             sbcl-trivial-garbage))
      (home-page "https://github.com/ruricolist/moira")
      (synopsis "Monitor and restart background threads")
      (description
       "Moira is a library for monitoring and, if necessary, restarting
long-running threads.  In principle, it is like an in-Lisp process supervisor.")
      (license license:expat))))

(define-public cl-moira
  (sbcl-package->cl-source-package sbcl-moira))

(define-public ecl-moira
  (sbcl-package->ecl-package sbcl-moira))

(define-public sbcl-more-conditions
  (let ((commit "b4859fb119b3b88719c3c4d5f6d7a620052fefc2")
        (revision "1"))
    (package
      (name "sbcl-more-conditions")
      (version (git-version "0.4.5" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/scymtym/more-conditions")
               (commit commit)))
         (file-name (git-file-name "cl-more-conditions" version))
         (sha256
          (base32 "1n0xbz0yiqn9dxf0ycm57wqvsr4gh2q4hs5fskjbv87c47d7l7zr"))))
      (build-system asdf-build-system/sbcl)
      (native-inputs
       (list sbcl-fiveam sbcl-let-plus))
      (inputs
       (list sbcl-alexandria sbcl-closer-mop))
      (synopsis "General condition classes and signalling helpers")
      (description
       "This package provides some condition classes, functions and macros
which may be useful when building slightly complex systems.")
      (home-page "https://github.com/scymtym/more-conditions")
      (license license:llgpl))))

(define-public cl-more-conditions
  (sbcl-package->cl-source-package sbcl-more-conditions))

(define-public ecl-more-conditions
  (sbcl-package->ecl-package sbcl-more-conditions))

(define-public sbcl-montezuma
  (let ((commit "ee2129eece7065760de4ebbaeffaadcb27644738")
        (revision "1"))
    (package
      (name "sbcl-montezuma")
      (version (git-version "0.1.3" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/sharplispers/montezuma")
               (commit commit)))
         (file-name (git-file-name "cl-montezuma" version))
         (sha256
          (base32 "0svmvsbsirydk3c1spzfvj8qmkzcs9i69anpfvk1843i62wb7x2c"))))
      (build-system asdf-build-system/sbcl)
      (arguments
       `(#:phases
         (modify-phases %standard-phases
           ;; The _darcs directory contains a second copy of
           ;; montezuma-indexfiles.asd. Remove the directory to
           ;; prevent build failure caused by .asd files that have
           ;; the same filename.
           (add-after 'unpack 'remove-darcs-directory
             (lambda _
               (delete-file-recursively
                "contrib/montezuma-indexfiles/_darcs")))
           ;; Tests fail with: :FORCE and :FORCE-NOT arguments not
           ;; allowed in a nested call to ASDF/OPERATE:OPERATE unless
           ;; identically to toplevel.
           (add-after 'unpack 'fix-tests
             (lambda _
               (substitute* "montezuma.asd"
                 ((":force t") "")))))))
      (inputs
       `(("babel" ,sbcl-babel)
         ("cl-fad" ,sbcl-cl-fad)
         ("cl-ppcre" ,sbcl-cl-ppcre)))
      (native-inputs
       (list sbcl-trivial-timeout))
      (home-page "https://github.com/sharplispers/montezuma")
      (synopsis "Full-text indexing and search for Common Lisp")
      (description
       "Montezuma is a text search engine library for Lisp based on the Ferret
library for Ruby, which is itself based on the Lucene library for Java.")
      (license (list license:expat       ; montezuma
                     license:gpl3+)))))  ; contrib/montezuma-indexfiles

(define-public cl-montezuma
  (sbcl-package->cl-source-package sbcl-montezuma))

(define-public ecl-montezuma
  (let ((pkg (sbcl-package->ecl-package sbcl-montezuma)))
    (package
      (inherit pkg)
      (arguments
       (substitute-keyword-arguments (package-arguments pkg)
         ;; Tests fail with "Pathname without a physical namestring" error
         ;; on ECL.
         ((#:tests? _ #f) #f))))))

(define-public sbcl-moptilities
  (let ((commit "a436f16b357c96b82397ec018ea469574c10dd41"))
    (package
      (name "sbcl-moptilities")
      (version (git-version "0.3.13" "1" commit))
      (home-page "https://github.com/gwkkwg/moptilities/")
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url home-page)
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "1q12bqjbj47lx98yim1kfnnhgfhkl80102fkgp9pdqxg0fp6g5fc"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       `(("closer-mop" ,sbcl-closer-mop)))
      (native-inputs
       (list sbcl-lift))
      (arguments
       `(#:phases
         (modify-phases %standard-phases
           (add-after 'unpack 'fix-tests
             (lambda _
               (substitute* "lift-standard.config"
                 ((":relative-to lift-test")
                  ":relative-to moptilities-test"))
               #t))
           (add-after 'check 'remove-test-results
             ;; Otherwise the drag the SBCL package into the closure of the CL
             ;; package.
             (lambda* (#:key outputs #:allow-other-keys)
               (let* ((out (assoc-ref outputs "out"))
                      (source-path (string-append out "/share/common-lisp/"
                                                  (%lisp-type) "/moptilities/")))
                 (delete-file-recursively
                  (string-append source-path "/test-results")))
               #t)))))
      (synopsis "Compatibility layer for Common Lisp MOP implementation differences")
      (description
       "MOP utilities provide a common interface between Lisps and make the
MOP easier to use.")
      (license license:expat))))

(define-public cl-moptilities
  (sbcl-package->cl-source-package sbcl-moptilities))

(define-public ecl-moptilities
  (let ((pkg (sbcl-package->ecl-package sbcl-moptilities)))
    (package
      (inherit pkg)
      (arguments
       ;; Tests fail with "The function LIFT::GET-BACKTRACE-AS-STRING is
       ;; undefined" on ECL.
       '(#:tests? #f)))))

(define-public sbcl-mssql
  (let ((commit "045602a19a32254108f2b75871049293f49731eb")
        (revision "1"))
    (package
      (name "sbcl-mssql")
      (version (git-version "0.0.3" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/archimag/cl-mssql")
               (commit commit)))
         (file-name (git-file-name "cl-mssql" version))
         (sha256
          (base32 "09i50adppgc1ybm3ka9vbindhwa2x29f9n3n0jkrryymdhb8zknm"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       `(("cffi" ,sbcl-cffi)
         ("freetds" ,freetds)
         ("garbage-pools" ,sbcl-garbage-pools)
         ("iterate" ,sbcl-iterate)
         ("parse-number" ,sbcl-parse-number)))
      (arguments
       `(#:phases
         (modify-phases %standard-phases
           (add-after 'unpack 'fix-paths
             (lambda* (#:key inputs #:allow-other-keys)
               (substitute* "src/mssql.lisp"
                 (("libsybdb" all)
                  (string-append (assoc-ref inputs "freetds") "/lib/" all)))
               #t)))))
      (home-page "https://github.com/archimag/cl-mssql")
      (synopsis "Common Lisp library to interact with MS SQL Server databases")
      (description
       "@code{cl-mssql} provides an interface to connect to Microsoft SQL
server.  It uses the @code{libsybdb} foreign library provided by the FreeTDS
project.")
      (license license:llgpl))))

(define-public cl-mssql
  (sbcl-package->cl-source-package sbcl-mssql))

(define-public ecl-mssql
  (sbcl-package->ecl-package sbcl-mssql))

(define-public sbcl-mt19937
  (package
    (name "sbcl-mt19937")
    (version "1.1")
    (source
     (origin
       (method url-fetch)
       (uri (string-append "https://common-lisp.net/project/asdf-packaging/"
                           "mt19937-latest.tar.gz"))
       (sha256
        (base32
         "1iw636b0iw5ygkv02y8i41lh7xj0acglv0hg5agryn0zzi2nf1xv"))))
    (build-system asdf-build-system/sbcl)
    (synopsis "Mersenne Twister pseudo-random number generator")
    (description
     "MT19937 is a portable Mersenne Twister pseudo-random number generator
for Common Lisp.")
    (home-page "https://www.cliki.net/mt19937")
    (license license:public-domain)))

(define-public cl-mt19937
  (sbcl-package->cl-source-package sbcl-mt19937))

(define-public ecl-mt19937
  (sbcl-package->ecl-package sbcl-mt19937))

(define-public clasp-mt19937
  (sbcl-package->clasp-package sbcl-mt19937))

(define-public sbcl-multilang-documentation
  (let ((commit "59e798a07e949e8957a20927f52aca425d84e4a0"))
    (package
      (name "sbcl-multilang-documentation")
      (version (git-version "1.0.0" "1" commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/Shinmera/multilang-documentation")
               (commit commit)))
         (file-name (git-file-name name commit))
         (sha256
          (base32 "13y5jskx8n2b7kimpfarr8v777w3b7zj5swg1b99nj3hk0843ixw"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-documentation-utils sbcl-language-codes
             sbcl-system-locale))
      (home-page "https://shinmera.github.io/multilang-documentation/")
      (synopsis "Add multiple languages support to Common Lisp documentation")
      (description
       "This library provides a drop-in replacement function for
cl:documentation that supports multiple docstrings per-language, allowing you
to write documentation that can be internationalised.")
      (license license:zlib))))

(define-public cl-multilang-documentation
  (sbcl-package->cl-source-package sbcl-multilang-documentation))

(define-public ecl-multilang-documentation
  (sbcl-package->ecl-package sbcl-multilang-documentation))

(define-public sbcl-music-spelling
  (let ((commit "a2d492af440ad30a21042140cf8ffce4b73fbd42")
        (revision "0"))
    (package
      (name "sbcl-music-spelling")
      (version (git-version "0.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/ntrocado/music-spelling")
               (commit commit)))
         (file-name (git-file-name "cl-music-spelling" version))
         (sha256
          (base32 "0fgahb0jjr4sp2739d55gylmx8alsghnx3spyaqfqci4cxfrys52"))))
      (build-system asdf-build-system/sbcl)
      (inputs (list sbcl-alexandria))
      (home-page "https://github.com/ntrocado/music-spelling/")
      (synopsis "Automatically spell musical pitches and rhythms")
      (description "This package implements an algorithm for the spelling
of enharmonics and dealing with ties and dots in rhythm notation.")
      (license license:asl2.0))))

(define-public cl-music-spelling
  (sbcl-package->cl-source-package sbcl-music-spelling))

(define-public ecl-music-spelling
  (sbcl-package->ecl-package sbcl-music-spelling))

(define-public clasp-music-spelling
  (sbcl-package->clasp-package sbcl-music-spelling))

(define-public sbcl-mw-equiv
  (let ((commit "3ae871458685b1ef7cd6a996ee22c8c5e738a03d")
        (revision "1"))
    (package
      (name "sbcl-mw-equiv")
      (version (git-version "0.1.2" revision commit))
      (home-page "https://github.com/sharplispers/mw-equiv/")
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/sharplispers/mw-equiv/")
               (commit commit)))
         (file-name (git-file-name "cl-mw-equiv" version))
         (sha256
          (base32 "1fl90wp0jp7l90mps53fq0kzb28f10qfr739527h03xwqccyylad"))))
      (build-system asdf-build-system/sbcl)
      (synopsis "Extensible object equivalence protocol for Common Lisp")
      (description "Common Lisp comes with quite some functions to compare
objects for equality, yet none is applicable in every situation and in general
this is hard, as equality of objects depends on the semantics of operations on
them.  As consequence, users find themselves regularly in a situation where
they have to roll their own specialized equality test.

This module provides one of many possible equivalence relations between
standard Common Lisp objects.  However, it can be extended for new objects
through a simple CLOS protocol.  The rules when two objects are considered
equivalent distinguish between @emph{mutating} and @emph{frozen objects}.  A
frozen object is promised not to be mutated in the future in a way that
operations on it can notice the difference.

We have chosen to compare mutating objects only for identity (pointer
equality), to avoid various problems.  Equivalence for frozen objects on the
other hand is established by recursing on the objects' constituent parts and
checking their equivalence.  Hence, two objects are equivalent under the
@code{OBJECT=} relation, if they are either identical, or if they are frozen
and structurally equivalent, i.e. their constituents are point-wise
equivalent.

Since many objects are potentially mutable, but are not necessarily mutated
from a certain point in their life time on, it is possible to promise to the
equivalence relation that they remain frozen for the rest of their life time,
thus enabling coarser equivalence than the often too fine-grained pointer
equality.")
      (license license:bsd-2))))

(define-public cl-mw-equiv
  (sbcl-package->cl-source-package sbcl-mw-equiv))

(define-public ecl-mw-equiv
  (sbcl-package->ecl-package sbcl-mw-equiv))

(define-public clasp-mw-equiv
  (sbcl-package->clasp-package sbcl-mw-equiv))

(define-public sbcl-myway
  (let ((commit "286230082a11f879c18b93f17ca571c5f676bfb7")
        (revision "1"))
    (package
     (name "sbcl-myway")
     (version (git-version "0.1.0" revision commit))
     (source
      (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/fukamachi/myway")
             (commit commit)))
       (file-name (git-file-name "myway" version))
       (sha256
        (base32 "0briia9bk3lbr0frnx39d1qg6i38dm4j6z9w3yga3d40k6df4a90"))))
     (build-system asdf-build-system/sbcl)
     (arguments
      '(#:asd-systems '("myway-test" "myway")))
     (native-inputs
      (list sbcl-prove))
     (inputs
      (list sbcl-cl-ppcre sbcl-quri sbcl-map-set))
     (home-page "https://github.com/fukamachi/myway")
     (synopsis "Sinatra-compatible URL routing library for Common Lisp")
     (description "My Way is a Sinatra-compatible URL routing library.")
     (license license:llgpl))))

(define-public cl-myway
  (sbcl-package->cl-source-package sbcl-myway))

(define-public ecl-myway
  (sbcl-package->ecl-package sbcl-myway))

(define-public sbcl-nactivitypub
  (package
    (name "sbcl-nactivitypub")
    (version "0.0.5")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/atlas-engineer/nactivitypub")
                    (commit version)))
              (file-name (git-file-name "cl-nactivitypub" version))
              (sha256
               (base32
                "0m2vwi11zp0bpvr0hglq1svdxlp3cc70yvix30yksfzp6kk3amyn"))))
    (build-system asdf-build-system/sbcl)
    (inputs (list sbcl-cl-str
                  sbcl-dexador
                  sbcl-local-time
                  sbcl-lparallel
                  sbcl-njson
                  sbcl-quri
                  sbcl-serapeum))
    (home-page "https://github.com/atlas-engineer/nactivitypub")
    (synopsis
     "Common Lisp implementation of ActivityPub and ActivityStreams standards")
    (description
     "This package provides a Common Lisp implementation of ActivityPub and
ActivityStreams standards for social networking.

Features:
@itemize

@item Parsing and un-parsing ActivityStreams JSON-LD objects to/from CLOS
objects with convenient accessors on those.

@item Sending and fetching ActivityStreams objects to/from the
ActivityStreams-enabled HTTP(S) URLs.

@item Semantic info extraction with methods like @code{name*}, @code{url*},
@code{author*}, and @code{published*}.

@item No reliance on JSON parser.  @code{njson} is used for parser-independent
JSON handling.  Load the parser backend you prefer!

@end itemize")
    (license license:bsd-3)))

(define-public cl-nactivitypub
  (sbcl-package->cl-source-package sbcl-nactivitypub))

(define-public ecl-nactivitypub
  (sbcl-package->ecl-package sbcl-nactivitypub))

(define-public sbcl-named-closure
  (let ((commit "d57305582137a24d6c8f8375fba496c653bb5699")
        (revision "0"))
    (package
     (name "sbcl-named-closure")
     (version (git-version "0.0.1" revision commit))
     (source
      (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/kchanqvq/named-closure")
             (commit commit)))
       (file-name (git-file-name "named-closure" version))
       (sha256
        (base32 "17lpslk7amh9pghjpjdnd1aj50r1kdc4iyai2h2xas7wampg5xf5"))))
     (build-system asdf-build-system/sbcl)
     (inputs
      (list sbcl-alexandria
            sbcl-serapeum
            sbcl-iterate
            sbcl-trivial-cltl2))
     (synopsis "Introspectable, readably-printable and redefinable closures")
     (description
      "A CLOS class that defines callable objects whose behavior is similar to
closures but adds conveniences such as introspectability.")
     (home-page "https://github.com/kchanqvq/named-closure")
     (license license:expat))))

(define-public cl-named-closure
  (sbcl-package->cl-source-package sbcl-named-closure))

(define-public ecl-named-closure
  (sbcl-package->ecl-package sbcl-named-closure))

(define-public sbcl-named-readtables
  (let ((commit "d5ff162ce02035ec7de1acc9721385f325e928c0")
        (revision "4"))
    (package
      (name "sbcl-named-readtables")
      (version (git-version "0.9" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/melisgl/named-readtables")
               (commit commit)))
         (sha256
          (base32 "0gfgxywzbmavy0kpnxav11vz10qfzxwwrpgqaak9sgzg17g8x5yv"))
         (file-name (git-file-name "cl-named-readtables" version))))
      (build-system asdf-build-system/sbcl)
      ;; (native-inputs (list sbcl-try))
      ;; Tests disabled because of a circular dependency issue:
      ;;   try -> named-readtables -> mgl-pax -> try
      (arguments
       (list #:tests? #f))
      (home-page "https://github.com/melisgl/named-readtables/")
      (synopsis "Library that creates a namespace for named readtables")
      (description
       "Named readtables is a library that creates a namespace for named
readtables, which is akin to package namespacing in Common Lisp.")
      (license license:bsd-3))))

(define-public cl-named-readtables
  (sbcl-package->cl-source-package sbcl-named-readtables))

(define-public ecl-named-readtables
  (sbcl-package->ecl-package sbcl-named-readtables))

(define-public clasp-named-readtables
  (sbcl-package->clasp-package sbcl-named-readtables))

(define-public sbcl-napa-fft3
  (let ((commit "f2d9614c7167da327c9ceebefb04ff6eae2d2236")
        (revision "0"))
    (package
      (name "sbcl-napa-fft3")
      (version (git-version "0.0.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/pkhuong/Napa-FFT3")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "1hxjf599xgwm28gbryy7q96j9ys6hfszmv0qxpr5698hxnhknscp"))))
      (build-system asdf-build-system/sbcl)
      (home-page "https://github.com/pkhuong/Napa-FFT3")
      (synopsis "Fast Fourier Transform routines in Common Lisp")
      (description
       "Napa-FFT3 provides Discrete Fourier Transform (DFT) routines, but also
buildings blocks to express common operations that involve DFTs: filtering,
convolutions, etc.")
      (license license:bsd-3))))

(define-public cl-napa-fft3
  (sbcl-package->cl-source-package sbcl-napa-fft3))

(define-public sbcl-nasdf
  (let ((commit "ab7a018f3a67a999c72710644b10b4545130c139"))
    (package
      (name "sbcl-nasdf")
      (version "0.1.8")
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/atlas-engineer/ntemplate")
               (commit commit)))
         (file-name (git-file-name "cl-ntemplate" version))
         (sha256
          (base32 "15j7kqxvn0blr0i2xgk0il0ia91p28clfqxdh00vlp423v9a2wbx"))))
      (build-system asdf-build-system/sbcl)
      (arguments
       `(#:phases
         (modify-phases %standard-phases
           (add-after 'unpack 'cd-sdl
             (lambda _
               (chdir "nasdf"))))))
      (home-page "https://github.com/atlas-engineer/ntemplate")
      (synopsis "ASDF helpers for system setup, testing and installation")
      (description
       "NASDF is an ASDF extension providing utilities to ease system setup,
testing and installation.

@itemize
@item Simple way to fetch Git submodules and “do the right thing” for
setup.  This may effectively supersede Quicklisp.  A benefit of using Git
submodules over the default Quicklisp distribution is improved
reproducibility.
@item Test helpers, like distinction between offline and online tests, or
continuous integration options, and warning reports.
@item Installation helpers, for instance to install libraries, icons and
desktop files to the right directories.
@end itemize\n")
      (license license:bsd-3))))

(define-public cl-nasdf
  (sbcl-package->cl-source-package sbcl-nasdf))

(define-public ecl-nasdf
  (sbcl-package->ecl-package sbcl-nasdf))

(define-public sbcl-nclasses
  (package
    (name "sbcl-nclasses")
    (version "0.6.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/atlas-engineer/nclasses")
             (commit version)))
       (file-name (git-file-name "cl-nclasses" version))
       (sha256
        (base32
         "00is7fg1jsj9r3jawphbk5gh8kmiixl7g60xg1ic2q2cpilfd1by"))))
    (build-system asdf-build-system/sbcl)
    (inputs
     (list sbcl-moptilities))
    (native-inputs
     (list sbcl-lisp-unit2))
    (home-page "https://github.com/atlas-engineer/nclasses")
    (synopsis "Simplify class, condition, and generic function definitions")
    (description
     "NClasses provides helper macros to help write classes, conditions,
generic functions, and CLOS code in general with less boilerplate.

It's a fork of @code{hu.dwim.defclass-star}.  It includes some bug fixes and
extra features like type inference.")
    (license license:public-domain)))

(define-public cl-nclasses
  (sbcl-package->cl-source-package sbcl-nclasses))

(define-public ecl-nclasses
  (sbcl-package->ecl-package sbcl-nclasses))

(define-public sbcl-ndebug
  (package
    (name "sbcl-ndebug")
    (version "0.2.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/atlas-engineer/ndebug")
             (commit version)))
       (file-name (git-file-name "cl-ndebug" version))
       (sha256
        (base32 "1sndg4qclkdr53xkxrfjskx8gcqx0bn4r0vslzfx1kgznl4hbf1d"))))
    (build-system asdf-build-system/sbcl)
    (inputs
     (list sbcl-dissect
           sbcl-trivial-custom-debugger
           sbcl-bordeaux-threads
           sbcl-trivial-gray-streams))
    (native-inputs
     (list sbcl-lisp-unit2))
    (home-page "https://github.com/atlas-engineer/ndebug/")
    (synopsis "Toolkit to build UI-aware Common Lisp debugger hooks")
    (description
     "NDebug provides a small set of utilities to make graphical (or, rather
non-REPL-resident) Common Lisp applications easier to integrate with the
standard Lisp debugger (@code{*debugger-hook*}, namely) and
implementation-specific debugger hooks (via @code{trivial-custom-debugger}),
especially in a multi-threaded context.")
    (license license:bsd-3)))

(define-public cl-ndebug
  (sbcl-package->cl-source-package sbcl-ndebug))

(define-public ecl-ndebug
  (sbcl-package->ecl-package sbcl-ndebug))

(define-public sbcl-net.didierverna.asdf-flv
  (package
    (name "sbcl-net.didierverna.asdf-flv")
    (version "2.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/didierverna/asdf-flv")
             (commit (string-append "version-" version))))
       (file-name (git-file-name "asdf-flv" version))
       (sha256
        (base32 "1fi2y4baxan103jbg4idjddzihy03kwnj2mzbwrknw4d4x7xlgwj"))))
    (build-system asdf-build-system/sbcl)
    (synopsis "Common Lisp ASDF extension to provide support for file-local variables")
    (description "ASDF-FLV provides support for file-local variables through
ASDF.  A file-local variable behaves like @code{*PACKAGE*} and
@code{*READTABLE*} with respect to @code{LOAD} and @code{COMPILE-FILE}: a new
dynamic binding is created before processing the file, so that any
modification to the variable becomes essentially file-local.

In order to make one or several variables file-local, use the macros
@code{SET-FILE-LOCAL-VARIABLE(S)}.")
    (home-page "https://www.lrde.epita.fr/~didier/software/lisp/misc.php#asdf-flv")
    (license (license:non-copyleft
              "https://www.gnu.org/prep/maintain/html_node/License-Notices-for-Other-Files.html"
              "GNU All-Permissive License"))))

(define-public cl-net.didierverna.asdf-flv
  (sbcl-package->cl-source-package sbcl-net.didierverna.asdf-flv))

(define-public ecl-net.didierverna.asdf-flv
  (sbcl-package->ecl-package sbcl-net.didierverna.asdf-flv))

(define-public clasp-net.didierverna.asdf-flv
  (sbcl-package->clasp-package sbcl-net.didierverna.asdf-flv))

(define-public sbcl-nfiles
  (package
   (name "sbcl-nfiles")
   (version "1.1.4")
   (source
    (origin
     (method git-fetch)
     (uri (git-reference
           (url "https://github.com/atlas-engineer/nfiles")
           (commit version)))
     (file-name (git-file-name "cl-nfiles" version))
     (sha256
      (base32
       "1a8zsphbbl9r4sdm95kgm4ljd9b148c9fnwlq7f930fh9826kf72"))))
   (build-system asdf-build-system/sbcl)
   (inputs
    (list gnupg
          sbcl-alexandria
          sbcl-nclasses
          sbcl-quri
          sbcl-serapeum
          sbcl-trivial-garbage
          sbcl-trivial-package-local-nicknames
          sbcl-trivial-types))
   (native-inputs
    (list sbcl-lisp-unit2))
   (arguments
    `(#:phases
      (modify-phases %standard-phases
        (add-after 'unpack 'fix-paths
          (lambda* (#:key inputs #:allow-other-keys)
            (substitute* "gpg.lisp"
              (("\"gpg\"")
               (string-append "\"" (assoc-ref inputs "gnupg") "/bin/gpg\""))))))))
   (home-page "https://github.com/atlas-engineer/nfiles")
   (synopsis "Manage file persistence and loading in Common Lisp")
   (description
    "NFiles is a Common Lisp library to help manage file persistence and
loading, in particular user-centric files like configuration files.  It boasts
the following features:

@itemize
@item Dynamic and customizable path expansion.

@item Extensible serialization and deserialization.

@item Cached reads and writes.  When a file object expands to the same path as
another one, a read or write on it won’t do anything in case there was no
change since last write.

@item (Experimental!) On-the-fly PGP encryption.

@item Profile support.

@item On read error, existing files are backed up.

@item On write error, no file is written to disk, the existing file is preserved.
@end itemize\n")
   (license license:bsd-3)))

(define-public cl-nfiles
  (package
    (inherit (sbcl-package->cl-source-package sbcl-nfiles))
    (inputs
     (cons (list "iolib" cl-iolib)
           (package-inputs sbcl-nfiles)))))

(define-public ecl-nfiles
  (let ((pkg (sbcl-package->ecl-package sbcl-nfiles)))
    (package
      (inherit pkg)
      (inputs
       (cons (list "iolib" ecl-iolib)
             (package-inputs pkg))))))

(define-public sbcl-nhooks
  (package
    (name "sbcl-nhooks")
    (version "1.2.2")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/atlas-engineer/nhooks")
             (commit version)))
       (file-name (git-file-name "cl-nhooks" version))
       (sha256
        (base32
         "1m9dfp7wjm8k16x45qnw258ca8gnic3k2ik79sdn5gxcx6qxy3g8"))))
    (build-system asdf-build-system/sbcl)
    (inputs
     (list sbcl-serapeum))
    (native-inputs
     (list sbcl-lisp-unit2))
    (home-page "https://github.com/atlas-engineer/nhooks")
    (synopsis "Hook facility for Common Lisp")
    (description "This package holds an enhanced implementation of
hooks (extension points).  It works similarly to Emacs hooks with crucial
improvements:

@itemize

@item If the compiler allows it (such as SBCL), type-checking is performed at
compile-time and at run-time when adding handlers to a hook.

@item On failure, multiple restarts are offered, such as disabling the
offending handler or simply continuing to the next function.

@item The hook handler execution order and combination can be customized.

@item Anonymous functions (lambdas) can be added to hooks as handler objects.
When inspecting hooks, readable names are thus exposed instead of lambda
blackboxes.  Handlers are compared through their names (through the mandatory
name slot).  A hook can not contain multiple handlers with the same name.

@item A special provision is taken for “setters”, handlers that are meant to
set a given place to a given values.  Such handler objects can be compared and
identified uniquely.

@end itemize\n")
    (license license:expat)))

(define-public cl-nhooks
  (sbcl-package->cl-source-package sbcl-nhooks))

(define-public ecl-nhooks
  (sbcl-package->ecl-package sbcl-nhooks))

(define-public sbcl-nibbles
  ;; No tagged release since 2018.
  (let ((commit "a46a67736e07b548cdd7485cb36834f7942313f1")
        (revision "3"))
    (package
      (name "sbcl-nibbles")
      (version (git-version "0.14" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/sharplispers/nibbles/")
               (commit commit)))
         (file-name (git-file-name "cl-nibbles" version))
         (sha256
          (base32 "12qjich11hp31dhbvbsixyjbddmr6faaajigrivgbxy9kw6d279j"))))
      (build-system asdf-build-system/sbcl)
      (native-inputs
       ;; Tests only.
       (list sbcl-rt))
      (synopsis
       "Common Lisp library for accessing octet-addressed blocks of data")
      (description
       "When dealing with network protocols and file formats, it's common to
have to read or write 16-, 32-, or 64-bit datatypes in signed or unsigned
flavors.  Common Lisp sort of supports this by specifying :element-type for
streams, but that facility is underspecified and there's nothing similar for
read/write from octet vectors.  What most people wind up doing is rolling their
own small facility for their particular needs and calling it a day.

This library attempts to be comprehensive and centralize such
facilities.  Functions to read 16-, 32-, and 64-bit quantities from octet
vectors in signed or unsigned flavors are provided; these functions are also
SETFable.  Since it's sometimes desirable to read/write directly from streams,
functions for doing so are also provided.  On some implementations,
reading/writing IEEE singles/doubles (i.e. single-float and double-float) will
also be supported.")
      (home-page "https://github.com/sharplispers/nibbles")
      (license license:bsd-3))))

(define-public cl-nibbles
  (sbcl-package->cl-source-package sbcl-nibbles))

(define-public ecl-nibbles
  (sbcl-package->ecl-package sbcl-nibbles))

(define-public clasp-nibbles
  (sbcl-package->clasp-package sbcl-nibbles))

(define-public sbcl-ningle
  (let ((commit "2e85675bbb668d6ef341514fc9f22391a0f506b1")
        (revision "2"))
    (package
      (name "sbcl-ningle")
      (version (git-version "0.3.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/fukamachi/ningle")
               (commit commit)))
         (file-name (git-file-name "cl-ningle" version))
         (sha256
          (base32 "0s9nn8ml1j4839rycvdjcbsynkqnhxw1zmrgpjz48smscwdf1f8p"))))
      (build-system asdf-build-system/sbcl)
      (arguments
       '(#:tests? #f)) ; TODO: pull in clack-test
      (native-inputs
       (list sbcl-prove))
      (inputs
       (list sbcl-cl-syntax sbcl-myway sbcl-lack sbcl-alexandria
             sbcl-babel))
      (home-page "https://8arrow.org/ningle/")
      (synopsis "Super micro framework for Common Lisp")
      (description
       "Ningle is a lightweight web application framework for Common Lisp.")
      (license license:llgpl))))

(define-public cl-ningle
  (sbcl-package->cl-source-package sbcl-ningle))

(define-public ecl-ningle
  (sbcl-package->ecl-package sbcl-ningle))

(define-public sbcl-njson
  (package
    (name "sbcl-njson")
    (version "1.2.2")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/atlas-engineer/njson")
                    (commit version)))
              (file-name (git-file-name "cl-njson" version))
              (sha256
               (base32
                "05v5bk3l47mds4ihxs8jlqm19gqq7hb4q0161bgg99w9847l63lk"))))
    (build-system asdf-build-system/sbcl)
    (inputs (list sbcl-cl-json sbcl-jzon))
    (native-inputs (list sbcl-lisp-unit2))
    (arguments
     '(#:asd-systems '("njson" "njson/cl-json" "njson/jzon")))
    (home-page "https://github.com/atlas-engineer/njson")
    (synopsis "JSON handling framework for Common Lisp")
    (description
     "NJSON aims to make it convenient for one to decode, encode,
and process JSON data, in the minimum keystrokes/minutes possible.

NJSON is parser-independent, with existing Common Lisp JSON parsers being
loadable as additional system.  @code{jzon} is included by default, though.
Conveniences that NJSON provides are:

@itemize
@item @code{encode} and @code{decode} as single entry points for JSON reading
and writing, be it from streams/string/files, or from those.

@item @code{jget}, @code{jcopy}, @code{jkeys}, and their aliases to
manipulate the decoded objects' properties without the need to worry
about the low-level details of how these values are decoded.

@item @code{jif}, @code{jwhen}, @code{jor}, @code{jand}, and other macros
mimicking Lisp ones, while using truth values of JSON-decoded data.

@item @code{jbind} and @code{jmatch} macros to destructure and
validate parsed JSON.

@item @code{njson/aliases} package to nickname to @code{j} for all the
forms conveniently accessible as @code{j:get}, @code{j:copy},
@code{j:if} etc.

@end itemize\n")
    (license license:bsd-3)))

(define-public cl-njson
  (sbcl-package->cl-source-package sbcl-njson))

(define-public ecl-njson
  (sbcl-package->ecl-package sbcl-njson))

(define-public sbcl-nkeymaps
  (package
    (name "sbcl-nkeymaps")
    (version "1.1.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/atlas-engineer/nkeymaps")
             (commit version)))
       (file-name (git-file-name "cl-nkeymaps" version))
       (sha256
        (base32 "179hrnkn3pkwkp4ap6ax0zgp7xcr9cq7icff42r79gh43ri3kpzy"))))
    (build-system asdf-build-system/sbcl)
    (inputs
     (list sbcl-alexandria
           sbcl-fset
           sbcl-cl-str
           sbcl-trivial-package-local-nicknames))
    (native-inputs
     (list sbcl-lisp-unit2))
    (home-page "https://github.com/atlas-engineer/nkeymaps")
    (synopsis "Keymap facility for Common Lisp")
    (description
     "This is a keymap facility for Common Lisp inspired by Emacsy
(keymap.scm) which is inspired by Emacs.
@itemize

@item Support prefix keys to other keymaps.  For instance, if you prefix
my-mode-map with C-c, then all bindings for my-mode will be accessible after
pressing C-c.

@item List all bindings matching a given prefix.  (Also known as which-key in
Emacs.)

@item List the bindings associated to a command.

@item Support multiple inheritance.

@item Support keycode.

@item Validate keyspec at compile time.

@item define-key can set multiple bindings in a single call.

@item Support multiple scheme to make it easy to switch between, say,
Emacs-style and VI-style bindings.  This orthogonality to keymaps composes
better than having multiple keymaps: changing scheme applies to the entire
program, which is easier than looping through all keymaps to change them.

@item Translate keyspecs as a fallback.  For instance if shift-a is not bound,
check A.

@item Behaviour can be customized with global parameters such as
*print-shortcut*.

@item The compose function can merge multiple keymaps together.

@item Support multiple arguments when that makes sense (e.g. multiple keymaps
for lookup-key).

@item Key remapping à-la Emacs.

@item Typed keymaps, i.e. keymaps where bound values can only be of a given
type.  This is convenient to catch typos, for instance when binding 'FOO
instead of #'FOO.
@end itemize")
    (license license:bsd-3)))

(define-public cl-nkeymaps
  (sbcl-package->cl-source-package sbcl-nkeymaps))

(define-public ecl-nkeymaps
  (sbcl-package->ecl-package sbcl-nkeymaps))

(define-public sbcl-nodgui
  (package
    (name "sbcl-nodgui")
    (version "0.7.6.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
              (url "https://codeberg.org/cage/nodgui.git")
              (commit (string-append "v" version))))
       (file-name (git-file-name "cl-nodgui" version))
       (sha256
        (base32 "0c2f7g6swd9fkzjnmlkm22cds4v2y67g09w7s66ak3zcxaxppdbj"))))
    (build-system asdf-build-system/sbcl)
    (native-inputs
     (list sbcl-clunit2))
    (inputs
     (list sbcl-alexandria
           sbcl-bordeaux-threads
           sbcl-cl-colors2
           sbcl-cl-ppcre-unicode
           sbcl-cl-unicode
           sbcl-esrap
           sbcl-flexi-streams
           sbcl-jpeg-turbo
           sbcl-named-readtables
           sbcl-cl-opengl
           sbcl-parse-number
           sbcl-pngload
           sbcl-sdl2
           sbcl-sdl2-ttf
           sbcl-static-vectors
           sbcl-trivial-garbage
           sbcl-zpng
           tk
           tklib
           tcllib))
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'fix-paths
            (lambda* (#:key inputs #:allow-other-keys)
              (substitute* "src/wish-communication.lisp"
                (("\\(guess-wish-interpreter-path\\)")
                 (string-append "\""
                                (search-input-file inputs "/bin/wish")
                                "\""))))))))
    (synopsis "Common Lisp bindings for the Tk GUI toolkit")
    (description
     "Nodgui (@emph{No Drama GUI}) is a Common Lisp binding for the Tk GUI
toolkit.  It also provides a few additional widgets more than the standard Tk
ones.")
    (home-page "https://www.autistici.org/interzona/nodgui.html")
    (license license:llgpl)))

(define-public cl-nodgui
  (sbcl-package->cl-source-package sbcl-nodgui))

(define-public ecl-nodgui
  (sbcl-package->ecl-package sbcl-nodgui))

(define-public sbcl-nontrivial-gray-streams
  (let ((commit "7ed842fe98f6ebafd472a5768e28d0c35f82114e")
        (revision "0"))
    (package
      (name "sbcl-nontrivial-gray-streams")
      (version (git-version "1.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/yitzchak/nontrivial-gray-streams")
               (commit commit)))
         (file-name (git-file-name "cl-nontrivial-gray-streams" commit))
         (sha256
          (base32 "1x5b2fw3kr1227vr4hab08cls5f7rzz7kf31xinvafbl5hpd2ynf"))))
      (build-system asdf-build-system/sbcl)
      (native-inputs
       (list sbcl-alexandria
             sbcl-parachute))
      (home-page "https://github.com/yitzchak/nontrivial-gray-streams")
      (synopsis "Compatibility layer for Gray streams, including extensions")
      (description
       "@code{nontrivial-gray-streams} is a compatibility system for Gray
streams, which is an extension to Common Lisp that makes it possible to
implement Common Lisp streams using generic functions.")
      (license license:expat))))

(define-public cl-nontrivial-gray-streams
  (sbcl-package->cl-source-package sbcl-nontrivial-gray-streams))

(define-public ecl-nontrivial-gray-streams
  (sbcl-package->ecl-package sbcl-nontrivial-gray-streams))

(define-public clasp-nontrivial-gray-streams
  (sbcl-package->clasp-package sbcl-nontrivial-gray-streams))

(define-public sbcl-nsymbols
  (package
   (name "sbcl-nsymbols")
   (version "0.3.2")
   (source
    (origin
     (method git-fetch)
     (uri (git-reference
           (url "https://github.com/atlas-engineer/nsymbols")
           (commit version)))
     (file-name (git-file-name "cl-nsymbols" version))
     (sha256
      (base32 "1awh793s4fwhddllfcjz4sbkxwinh5w54s3glxh7rv00c7skdjd6"))))
   (build-system asdf-build-system/sbcl)
   (native-inputs (list sbcl-lisp-unit2))
   (inputs (list cl-closer-mop))
   (arguments
    '(#:asd-systems '("nsymbols" "nsymbols/star")))
   (synopsis
    "Functions to search, filter, and group symbols in chosen packages")
   (home-page "https://github.com/atlas-engineer/nsymbols")
   (description "Nsymbols extends the regular package API of ANSI CL with more
operations, allowing one to list:

@itemize
@item @code{package-symbols}.
@item @code{package-variables}.
@item @code{package-functions}.
@item @code{package-generic-functions}.
@item @code{package-macros}.
@item @code{package-classes}.
@item @code{package-structures}.
@item And other symbol types, given @code{define-symbol-type} for those.
@end itemize

Nsymbols can also find symbols by their name/matching symbol with
@code{resolve-symbol}.  All these operations are aware of symbol
visibility in the given packages, due to a @code{symbol-visibility}
function.

An additional @code{nsymbols/star} system has a set of functions
mirroring the regular Nsymbols ones, but using @code{closer-mop} to
provide better results and returning structured data instead of
symbols.")
   (license license:bsd-3)))

(define-public cl-nsymbols
  (sbcl-package->cl-source-package sbcl-nsymbols))

(define-public ecl-nsymbols
  (sbcl-package->ecl-package sbcl-nsymbols))

(define-public sbcl-numcl
  (let ((commit "a28f612d072e5f93137584de5155a42243b3bd6b")
        (revision "3"))
    (package
      (name "sbcl-numcl")
      (version (git-version "0.2.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/numcl/numcl")
               (commit commit)))
         (file-name (git-file-name "numcl" version))
         (sha256
          (base32 "15m4spbgayawnw5jjz04zfp0jnk9g6hgq5fmr648hzjzj50j1d78"))))
      (build-system asdf-build-system/sbcl)
      (arguments
       `(;; Tests often fail because they require a dynamic-space-size much
         ;; bigger than the default one. Disable them for now.
         #:tests? #f))
      (native-inputs
       (list sbcl-fiveam))
      (inputs
       `(("alexandria" ,sbcl-alexandria)
         ("cl-randist" ,sbcl-cl-randist)
         ("constantfold" ,sbcl-constantfold)
         ("float-features" ,sbcl-float-features)
         ("function-cache" ,sbcl-function-cache)
         ("gtype" ,sbcl-gtype)
         ("iterate" ,sbcl-iterate)
         ("lisp-namespace" ,sbcl-lisp-namespace)
         ("specialized-function" ,sbcl-specialized-function)
         ("trivia" ,sbcl-trivia)
         ("type-r" ,sbcl-type-r)))
      (home-page "https://numcl.github.io/numcl/")
      (synopsis "Numpy clone in Common Lisp")
      (description
       "This package is a Python Numpy clone implemented in pure Common Lisp.")
      (license license:lgpl3+))))

(define-public cl-numcl
  (sbcl-package->cl-source-package sbcl-numcl))

(define-public ecl-numcl
  (sbcl-package->ecl-package sbcl-numcl))

(define-public sbcl-numerical-utilities
  (let ((commit "44f45ba952b35675640630e40cf90df6f8279746")
        (revision "0"))
    (package
      (name "sbcl-numerical-utilities")
      (version (git-version "1.2.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/Lisp-Stat/numerical-utilities")
               (commit commit)))
         (file-name (git-file-name "cl-numerical-utilities" version))
         (sha256
          (base32 "1dwz8zxhqzi31qp863zj1cn1lgljny14snycb9nk871qs121kmsd"))))
      (build-system asdf-build-system/sbcl)
      (arguments
       '(#:asd-systems '("num-utils" "num-utils/tests")))
      (inputs
       (list sbcl-alexandria
             sbcl-alexandria-plus
             sbcl-anaphora
             sbcl-array-operations
             sbcl-let-plus
             sbcl-select))
      (native-inputs
       (list sbcl-fiveam))
      (home-page "https://lisp-stat.github.io/numerical-utilities")
      (synopsis "Utilities for numerical programming")
      (description
       "@code{cl-numerical-utilities} is a collection of packages useful in
numerical applications, each big enough to be its own package, but too small
to split out into a separate ASDF system.")
      (license license:ms-pl))))

(define-public cl-numerical-utilities
  (sbcl-package->cl-source-package sbcl-numerical-utilities))

(define-public ecl-numerical-utilities
  (sbcl-package->ecl-package sbcl-numerical-utilities))

(define-public sbcl-numpy-file-format
  (let ((commit "e440c7bbc0d86b9abf73acb0fa665b77b82a6c98")
        (revision "2"))
    (package
      (name "sbcl-numpy-file-format")
      (version (git-version "0.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/marcoheisig/numpy-file-format")
               (commit commit)))
         (file-name (git-file-name "cl-numpy-file-format" version))
         (sha256
          (base32 "1n0nixc44z1cymm20wif0l2100ydv0h69l6i6xz5bmwcb2zc4gqr"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-ieee-floats sbcl-trivial-features))
      (home-page "https://github.com/marcoheisig/numpy-file-format")
      (synopsis "Read and write NumPy .npy and .npz files")
      (description
       "The NUMPY-FILE-FORMAT library is a Common Lisp library for reading and
writing NumPy @file{.npy} and @file{.npz} files.")
      (license license:expat))))

(define-public cl-numpy-file-format
  (sbcl-package->cl-source-package sbcl-numpy-file-format))

(define-public ecl-numpy-file-format
  (sbcl-package->ecl-package sbcl-numpy-file-format))

(define-public sbcl-object-class
  (package
    (name "sbcl-object-class")
    (version "1.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/Hexstream/object-class")
             (commit (string-append "v" version))))
       (file-name (git-file-name "cl-object-class" version))
       (sha256
        (base32 "0qagmd2mxbr8b60l0y3jccj0maxjchds96p935pd3q805ry50683"))))
    (build-system asdf-build-system/sbcl)
    (native-inputs
     (list sbcl-parachute))
    (inputs
     (list sbcl-closer-mop
           sbcl-compatible-metaclasses
           sbcl-enhanced-find-class))
    (home-page "https://www.hexstreamsoft.com/libraries/object-class/")
    (synopsis "Cluster special subclasses of the standard-object")
    (description
     "This package ensures that special subclasses of standard-object cluster
right in front of standard-object in the class precedence list.")
    (license license:unlicense)))

(define-public cl-object-class
  (sbcl-package->cl-source-package sbcl-object-class))

(define-public ecl-object-class
  (sbcl-package->ecl-package sbcl-object-class))

(define-public sbcl-olc
  (let ((commit "0269ed747477d967f7d9331964906b6a0f18a9c4")
        (revision "1"))
    (package
      (name "sbcl-olc")
      (version (git-version "1.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://codeberg.org/glv/olc")
               (commit commit)))
         (file-name (git-file-name "cl-olc" version))
         (sha256
          (base32 "02r6w9kfa6v4a12y2azmyjkxbn54r1y18c6a024vq4y6zp20fqnz"))))
      (build-system asdf-build-system/sbcl)
      (native-inputs
       (list sbcl-fiveam))
      (synopsis
       "Convert coordinates between latitude/longitude and Open Location Code")
      (description
       "This a Common Lisp library to convert geographic coordinates between
latitude/longitude and Open Location Code.")
      (home-page "https://codeberg.org/glv/olc")
      (license license:gpl3+))))

(define-public cl-olc
  (sbcl-package->cl-source-package sbcl-olc))

(define-public ecl-olc
  (sbcl-package->ecl-package sbcl-olc))

(define-public sbcl-one-more-re-nightmare
  (let ((commit "5b0b02e59f90964baf5737abd13300fa82f27667")
        (revision "1"))
    (package
      (name "sbcl-one-more-re-nightmare")
      (version (git-version "0.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/telekons/one-more-re-nightmare")
               (commit commit)))
         (file-name (git-file-name "cl-one-more-re-nightmare" version))
         (sha256
          (base32 "0mwgjgnp8dsf2zn0290px5q89z93zs0v4dhvs3rcir4mpiw8rbsn"))))
      (build-system asdf-build-system/sbcl)
      (arguments
       '(#:asd-test-systems '("one-more-re-nightmare-tests")
         #:phases
         (modify-phases %standard-phases
           (add-after 'unpack 'fix-tests
             (lambda _
               (substitute* "Tests/one-more-re-nightmare-tests.asd"
                 ((":depends-on")
                  (string-append
                   ":perform (test-op (o c) (symbol-call :one-more-re-nightmare-tests '#:run-tests))"
                   "\n  :depends-on"))))))))
      (native-inputs
       (list sbcl-lparallel sbcl-parachute))
      (inputs
       (list sbcl-alexandria
             sbcl-babel
             sbcl-bordeaux-threads
             sbcl-dynamic-mixins
             sbcl-esrap
             sbcl-stealth-mixin
             sbcl-trivia
             sbcl-trivial-indent))
      (home-page "https://github.com/telekons/one-more-re-nightmare")
      (synopsis "Regular expression compiler in Common Lisp")
      (description "@code{one-more-re-nightmare} is a regular expression engine
that uses the technique presented in Regular-expression derivatives
re-examined (Owens, Reppy and Turon, 2009;
@url{doi:10.1017/S0956796808007090}) to interpret and compile regular
expressions.")
      (license license:bsd-2))))

(define-public cl-one-more-re-nightmare
  (sbcl-package->cl-source-package sbcl-one-more-re-nightmare))

(define-public ecl-one-more-re-nightmare
  (sbcl-package->ecl-package sbcl-one-more-re-nightmare))

(define-public sbcl-open-with
  (let ((commit "f0682e42ac48311d1a5bb9eb7ca646baacd88a80")
        (revision "0"))
    (package
      (name "sbcl-open-with")
      (version (git-version "1.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
                (url "https://github.com/Shinmera/open-with")
                (commit commit)))
         (file-name (git-file-name "cl-open-with" version))
         (sha256
          (base32 "0j0qv1389wbr84y3mis4qd2zz9qybnq4frvc01pamidsbryxss0r"))))
      (build-system asdf-build-system/sbcl)
      (arguments
       (list
        #:phases
        #~(modify-phases %standard-phases
            (add-after 'unpack 'fix-paths
              (lambda* (#:key inputs #:allow-other-keys)
                (substitute* "toolkit.lisp"
                  (("xdg-open")
                   (search-input-file inputs "/bin/xdg-open"))))))))
      (inputs
       (list sbcl-documentation-utils
             sbcl-trivial-features
             xdg-utils))
      (synopsis "Open a file in a suitable external program")
      (description
       "This package provides a small utility library to open a thing (usually
a file or URL) in an appropriate handler (usually an external file manager or
browser).")
      (home-page "https://shinmera.github.io/open-with/")
      (license license:zlib))))

(define-public cl-open-with
  (sbcl-package->cl-source-package sbcl-open-with))

(define-public ecl-open-with
  (sbcl-package->ecl-package sbcl-open-with))

(define-public clasp-open-with
  (sbcl-package->clasp-package sbcl-open-with))

(define-public sbcl-openapi-generator
  (let ((commit "7c3842a6ed36ba2796dcd35fd1d65d488eecf749")
        (revision "0"))
    (package
      (name "sbcl-openapi-generator")
      (version (git-version "0.0.2" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://codeberg.org/kilianmh/openapi-generator.git")
               (commit commit)))
         (file-name (git-file-name name commit))
         (sha256
          (base32 "0cv0p4lv6kb7kv8fnnbrhrdqk2n79pl6ddlh0jz0a0n44f96vm0h"))))
      (build-system asdf-build-system/sbcl)
      (arguments
       (list
        #:asd-systems ''("openapi-generator")
        #:phases
        #~(modify-phases %standard-phases
            ;; This file makes a remote call at compile time
            (add-after 'unpack 'ignore-collections
              (lambda _
                (substitute* "openapi-generator.asd"
                  (("\\(:file \"collection") "#+nil(:file \"collection")))))))
      (native-inputs
       (list sbcl-fiveam))
      (inputs
       (list sbcl-cl-str
             sbcl-cl-hash-util
             sbcl-cl-semver
             sbcl-pathname-utils
             sbcl-json-mop
             sbcl-yason
             sbcl-jzon
             sbcl-cl-project
             sbcl-listopia
             sbcl-alexandria
             sbcl-serapeum
             sbcl-quri
             sbcl-dexador
             sbcl-cl-json-pointer
             sbcl-moptilities
             sbcl-parse-float
             sbcl-cl-yaml))
      (home-page "https://gitlab.com/lockie/trivial-adjust-simple-array")
      (synopsis "OpenAPI client system generator")
      (description "OpenAPI client system generator.")
      (license license:agpl3+))))

(define-public ecl-openapi-generator
  (sbcl-package->ecl-package sbcl-openapi-generator))

(define-public cl-openapi-generator
  (sbcl-package->cl-source-package sbcl-openapi-generator))

(define-public sbcl-opticl
  (let ((commit "f6fc4dc5fa61ae3f2527b77e4bda99001ba37dcb")
        (revision "1"))
    (package
      (name "sbcl-opticl")
      (version (git-version "0.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/slyrus/opticl")
               (commit commit)))
         (file-name (git-file-name "cl-opticl" version))
         (sha256
          (base32 "1jx9n78d4lf53iz24yid34l92zrpqxfihv6049ixcy0xigf7j4ac"))))
      (build-system asdf-build-system/sbcl)
      (native-inputs
       (list sbcl-fiveam))
      (inputs
       (list sbcl-alexandria
             sbcl-cl-jpeg
             sbcl-cl-tga
             sbcl-opticl-core
             sbcl-png-read
             sbcl-pngload
             sbcl-retrospectiff
             sbcl-skippy
             sbcl-zpng))
      (home-page "https://github.com/slyrus/opticl")
      (synopsis "Image processing library for Common Lisp")
      (description
       "Opticl is a Common Lisp library for representing, processing, loading,
and saving 2-dimensional pixel-based images.")
      (license license:bsd-2))))

(define-public cl-opticl
  (sbcl-package->cl-source-package sbcl-opticl))

(define-public ecl-opticl
  (sbcl-package->ecl-package sbcl-opticl))

(define-public sbcl-opticl-core
  (let ((commit "b7cd13d26df6b824b216fbc360dc27bfadf04999")
        (revision "0"))
    (package
      (name "sbcl-opticl-core")
      (version (git-version "0.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/slyrus/opticl-core")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "0458bllabcdjghfrqx6aki49c9qmvfmkk8jl75cfpi7q0i12kh95"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-alexandria))
      (home-page "https://github.com/slyrus/opticl-core")
      (synopsis "Core classes and pixel access macros for Opticl")
      (description
       "This Common Lisp library contains the core classes and pixel access
macros for the Opticl image processing library.")
      (license license:bsd-2))))

(define-public cl-opticl-core
  (sbcl-package->cl-source-package sbcl-opticl-core))

(define-public ecl-opticl-core
  (sbcl-package->ecl-package sbcl-opticl-core))

(define-public sbcl-optima
  (let ((commit "373b245b928c1a5cce91a6cb5bfe5dd77eb36195")
        (revision "1"))
    (package
      (name "sbcl-optima")
      (build-system asdf-build-system/sbcl)
      (version (git-version "1.0" revision commit))
      (home-page "https://github.com/m2ym/optima")
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url home-page)
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "1yw4ymq7ms89342kkvb3aqxgv0w38m9kd8ikdqxxzyybnkjhndal"))))
      (inputs
       `(("alexandria" ,sbcl-alexandria)
         ("closer-mop" ,sbcl-closer-mop)))
      (native-inputs
       (list sbcl-eos))
      (arguments
       ;; XXX: Circular dependencies: tests depend on optima.ppcre which depends on optima.
       `(#:tests? #f))
      (synopsis "Optimized pattern matching library for Common Lisp")
      (description "Optima is a fast pattern matching library which uses
optimizing techniques widely used in the functional programming world.")
      (license license:expat))))

(define-public cl-optima
  (sbcl-package->cl-source-package sbcl-optima))

(define-public ecl-optima
  (sbcl-package->ecl-package sbcl-optima))

(define-public clasp-optima
  (sbcl-package->clasp-package sbcl-optima))

(define-public sbcl-org-sampler
  (let ((commit "ee135a417750e5b1d810bb9574eb85223cb3038a")
        (revision "1"))
    (package
     (name "sbcl-org-sampler")
     (version (git-version "0.2.1" revision commit))
     (source
      (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/jphmrst/cl-org-sampler")
             (commit commit)))
       (file-name (git-file-name "cl-org-sampler" version))
       (sha256
        (base32 "1dg029in14928qfxvfshyxmdwhzskzhxx3na0zy98ybx69b21qla"))))
     (build-system asdf-build-system/sbcl)
     (inputs
      (list sbcl-iterate))
     (home-page "https://github.com/jphmrst/cl-org-sampler")
     (synopsis "Extracting Common Lisp docstrings as Emacs Org-mode documents")
     (description
      "ORG-SAMPLER allows using Lisp docstrings and reflection to make org-mode
text for inclusion into a larger document.")
     (license license:llgpl))))

(define-public cl-org-sampler
  (sbcl-package->cl-source-package sbcl-org-sampler))

(define-public ecl-org-sampler
  (sbcl-package->ecl-package sbcl-org-sampler))

(define-public clasp-org-sampler
  (sbcl-package->clasp-package sbcl-org-sampler))

(define-public sbcl-origin
  (let ((commit "d646134302456408d6d43580bb05299f1695ab8e")
        (revision "1"))
    (package
      (name "sbcl-origin")
      (version (git-version "2.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://git.mfiano.net/mfiano/origin")
               (commit commit)))
         (file-name (git-file-name "origin" version))
         (sha256
          (base32 "1n9aszaif3yh8prs5r8v51fbj4r5jd1a048mivd5yij3hplkm82b"))))
      (build-system asdf-build-system/sbcl)
      (native-inputs
       (list sbcl-parachute))
      (inputs
       (list sbcl-golden-utils sbcl-specialization-store))
      (home-page "https://git.mfiano.net/mfiano/origin")
      (synopsis "Common Lisp graphics math library")
      (description
       "This is a native Common Lisp graphics math library with an emphasis on
performance and correctness.")
      (license license:expat))))

(define-public ecl-origin
  (sbcl-package->ecl-package sbcl-origin))

(define-public cl-origin
  (sbcl-package->cl-source-package sbcl-origin))

(define-public sbcl-osc
  (let ((commit "f647738ccc22925ed740a8ca9132fda76a05baeb")
        (revision "0"))
    (package
     (name "sbcl-osc")
     (version (git-version "0.9" revision commit))
     (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/zzkt/osc")
               (commit commit)))
         (file-name (git-file-name "cl-osc" version))
         (sha256
          (base32 "1x4cavspaxcr604g0hwak1ncy4m9cqq03ji4v56g2h1443n7h48a"))))
     (build-system asdf-build-system/sbcl)
     (native-inputs (list sbcl-fiveam))
     (inputs (list sbcl-ieee-floats))
     (synopsis "Implementation of the Open Sound Control protocol")
     (description "This is a lisp implementation of the Open Sound Control
protocol (or more accurately “data transport specification” or
“encoding”).  The code should be close to ANSI standard common lisp and
provides self contained code for encoding and decoding of OSC data, messages,
and bundles.")
     (home-page "https://github.com/zzkt/osc/")
     (license license:gpl3+))))

(define-public cl-osc
  (sbcl-package->cl-source-package sbcl-osc))

(define-public ecl-osc
  (sbcl-package->ecl-package sbcl-osc))

(define-public sbcl-osicat
  (let ((commit "982327905b8980ff3173344ca87282e046565732")
        (revision "4"))
    (package
      (name "sbcl-osicat")
      (version (git-version "0.7.0" revision commit))
      (home-page "https://www.common-lisp.net/project/osicat/")
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/osicat/osicat")
               (commit commit)))
         (file-name (git-file-name "cl-osicat" version))
         (sha256
          (base32 "10q1dfkhrvp5ia860q10y4wdm11fmxf7xv8zl4viz2np9xzf5v22"))
         (snippet
          '(begin
             ;; The useless release.sh drags `bash' into the closure.
             (delete-file "scripts/release.sh")
             #t))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-alexandria sbcl-cffi sbcl-trivial-features))
      (native-inputs
       (list sbcl-rt))
      (synopsis "Operating system interface for Common Lisp")
      (description
       "Osicat is a lightweight operating system interface for Common Lisp on
Unix-platforms.  It is not a POSIX-style API, but rather a simple lispy
accompaniment to the standard ANSI facilities.")
      (license license:expat))))

(define-public cl-osicat
  (sbcl-package->cl-source-package sbcl-osicat))

(define-public ecl-osicat
  (sbcl-package->ecl-package sbcl-osicat))

(define-public sbcl-ospm
  (package
    (name "sbcl-ospm")
    (version "0.0.2")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/atlas-engineer/ospm")
             (commit version)))
       (file-name (git-file-name "cl-ospm" version))
       (sha256
        (base32 "1z2wz2xg7rn7p1lladdhj789iz2f3wfjgpi2hjr08vkf1pkp15xf"))))
    (build-system asdf-build-system/sbcl)
    (inputs
     (list sbcl-alexandria
           sbcl-calispel
           sbcl-hu.dwim.defclass-star
           sbcl-local-time
           sbcl-moptilities
           sbcl-named-readtables
           sbcl-serapeum
           sbcl-trivia))
    (native-inputs
     ;; FIXME: Tests have execution errors because of Guix being run in a container.
     (list sbcl-lisp-unit2 guix))
    (home-page "https://github.com/atlas-engineer/ospm")
    (synopsis "System package manager in Common Lisp")
    (description
     "This library is a universal interface to the operating system package manager.
It has extensive support for Guix, among others:

@itemize
@item package listing and searching;
@item package installation and uninstallation;
@item package file listing;
@item profile listing;
@item manifest listing and installation;
@item generation listing, switching and deletion.
@end itemize\n")
    (license license:bsd-3)))

(define-public cl-ospm
  (let ((pkg (sbcl-package->cl-source-package sbcl-ospm)))
    (package
      (inherit pkg)
      (inputs
       (cons (list "osicat" cl-osicat)
             (package-inputs pkg))))))

(define-public sbcl-overlord
  ;; No release.
  (let ((commit "a8f37b321a8aae1652fc50b78e74e57c771cc763"))
    (package
      (name "sbcl-overlord")
      (version (git-version "0.0.0" "1" commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/ruricolist/overlord/")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "1maqm53yhlhaa3cka8xcc4sq24ifrr4y3y0s5dyyn682xsh14hb4"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       `(("babel" ,sbcl-babel)
         ("bit-smasher" ,sbcl-bit-smasher)
         ("bordeaux-threads" ,sbcl-bordeaux-threads)
         ("cl-strftime" ,sbcl-cl-strftime)
         ("cmd" ,sbcl-cmd)
         ("drakma" ,sbcl-drakma)
         ("exit-hooks" ,sbcl-exit-hooks)
         ("fset" ,sbcl-fset)
         ("local-time" ,sbcl-local-time)
         ("lparallel" ,sbcl-lparallel)
         ("md5" ,sbcl-md5)
         ("murmurhash" ,sbcl-cl-murmurhash)
         ("named-readtables" ,sbcl-named-readtables)
         ("ppcre" ,sbcl-cl-ppcre)
         ("serapeum" ,sbcl-serapeum)
         ("trivia" ,sbcl-trivia)
         ("trivial-file-size" ,sbcl-trivial-file-size)))
      (propagated-inputs
       `(("quickproject" ,sbcl-quickproject)))
      (native-inputs
       (list sbcl-fiveam))
      (arguments
       `(#:phases
         (modify-phases %standard-phases
           (add-after 'unpack 'include-overlord/net
             (lambda _
               (substitute* "all.lisp"
                 (("\\(:import-from :overlord/kernel :nproc\\)")
                  (string-append
                   "(:import-from :overlord/kernel :nproc)"
                   "\n"
                   "(:import-from :overlord/net)")))
               #t)))))
      (home-page "https://github.com/ruricolist/overlord")
      (synopsis "Build system in Common Lisp")
      (description
       "Overlord is a build system in Common Lisp.  It is a real build system,
with all the modern features: rules with multiple outputs, parallel builds,
immunity to clock issues, and dynamic dependencies.

But Overlord is more than another build system.  Overlord is a uniform
approach to dependencies inside or outside of a Lisp image.  Overlord is to
Make what Lisp macros are to C macros.

Overlord is designed to be used from the Lisp REPL.  A command line interface
is available in a separate repository.  See
@url{https://github.com/ruricolist/overlord-cli}.")
      (license license:expat))))

(define-public cl-overlord
  (sbcl-package->cl-source-package sbcl-overlord))

;; FIXME: Broken on ECL? https://github.com/ruricolist/overlord/issues/25
;; (define-public ecl-overlord
;;   (sbcl-package->ecl-package sbcl-overlord))

(define-public sbcl-parenscript
  ;; Source archives are overwritten on every release, we use the Git repo instead.
  (let ((commit "7a1ac46353cecd144fc91915ba9f122aafcf4766"))
    (package
      (name "sbcl-parenscript")
      (version (git-version "2.7.1" "1" commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://gitlab.common-lisp.net/parenscript/parenscript")
               (commit commit)))
         (file-name (git-file-name "parenscript" version))
         (sha256
          (base32
           "0c22lqarrpbq82dg1sb3y6mp6w2faczp34ymzhnmff88yfq1xzsf"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-cl-ppcre sbcl-anaphora sbcl-named-readtables))
      (home-page "https://common-lisp.net/project/parenscript/")
      (synopsis "Translator from a subset of Common Lisp to JavaScript")
      (description
       "Parenscript is a translator from an extended subset of Common Lisp to
JavaScript.  Parenscript code can run almost identically on both the
browser (as JavaScript) and server (as Common Lisp).

Parenscript code is treated the same way as Common Lisp code, making the full
power of Lisp macros available for JavaScript.  This provides a web
development environment that is unmatched in its ability to reduce code
duplication and provide advanced meta-programming facilities to web
developers.

At the same time, Parenscript is different from almost all other \"language
X\" to JavaScript translators in that it imposes almost no overhead:

@itemize
@item No run-time dependencies: Any piece of Parenscript code is runnable
as-is.  There are no JavaScript files to include.
@item Native types: Parenscript works entirely with native JavaScript data
types.  There are no new types introduced, and object prototypes are not
touched.
@item Native calling convention: Any JavaScript code can be called without the
need for bindings.  Likewise, Parenscript can be used to make efficient,
self-contained JavaScript libraries.
@item Readable code: Parenscript generates concise, formatted, idiomatic
JavaScript code.  Identifier names are preserved.  This enables seamless
debugging in tools like Firebug.
@item Efficiency: Parenscript introduces minimal overhead for advanced Common
Lisp features.  The generated code is almost as fast as hand-written
JavaScript.
@end itemize\n")
      (license license:bsd-3))))

(define-public cl-parenscript
  (sbcl-package->cl-source-package sbcl-parenscript))

(define-public ecl-parenscript
  (sbcl-package->ecl-package sbcl-parenscript))

(define-public sbcl-parse
  (let ((commit "2351ee78acac065fcf10b8713d3f404e2e910786")
        (revision "1"))
    (package
     (name "sbcl-parse")
      (version (git-version "1.0" revision commit))
     (source
      (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/massung/parse")
             (commit commit)))
       (file-name (git-file-name "parse" version))
       (sha256
        (base32 "0l18yabyh7jizm5lgvra0jxi8s1cfwghidi6ix1pyixjkdbjlmvy"))))
     (build-system asdf-build-system/sbcl)
     (home-page "https://github.com/massung/parse")
     (synopsis "Monadic parsing for Common Lisp")
     (description
      "PARSE is a simple token parsing library for Common Lisp.")
     (license license:asl2.0))))

(define-public cl-parse
  (sbcl-package->cl-source-package sbcl-parse))

(define-public ecl-parse
  (sbcl-package->ecl-package sbcl-parse))

(define-public sbcl-parse-declarations
  (let ((commit "549aebbfb9403a7fe948654126b9c814f443f4f2")
        (revision "1"))
    (package
      (name "sbcl-parse-declarations")
      (version (git-version "1.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url (string-append
                     "https://gitlab.common-lisp.net/parse-declarations/"
                     "parse-declarations.git"))
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "03g5qks4c59nmxa48pbslxkfh77h8hn8566jddp6m9pl15dzzpxd"))))
      (build-system asdf-build-system/sbcl)
      (arguments
       `(#:asd-systems '("parse-declarations-1.0")))
      (home-page "https://common-lisp.net/project/parse-declarations/")
      (synopsis "Parse, filter, and build declarations")
      (description
       "Parse-Declarations is a Common Lisp library to help writing
macros which establish bindings.  To be semantically correct, such
macros must take user declarations into account, as these may affect
the bindings they establish.  Yet the ANSI standard of Common Lisp does
not provide any operators to work with declarations in a convenient,
high-level way.  This library provides such operators.")
      ;; MIT License
      (license license:expat))))

(define-public cl-parse-declarations
  (sbcl-package->cl-source-package sbcl-parse-declarations))

(define-public ecl-parse-declarations
  (sbcl-package->ecl-package sbcl-parse-declarations))

(define-public clasp-parse-declarations
  (sbcl-package->clasp-package sbcl-parse-declarations))

(define-public sbcl-parse-float
  (let ((commit "3074765101e41222b6b624a66aaf1e6416379f9c")
        (revision "2"))
    (package
      (name "sbcl-parse-float")
      (version (git-version "0.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/soemraws/parse-float")
               (commit commit)))
         (sha256
          (base32 "0jd2spawc3v8vzqf8ky4cngl45jm65fhkrdf20mf6dcbn3mzpkmr"))
         (file-name (git-file-name "proc-parse" version))))
      (build-system asdf-build-system/sbcl)
      (arguments
       ;; FIXME: https://github.com/soemraws/parse-float/issues/12
       `(#:asd-systems '("parse-float" "parse-float-tests")))
      (native-inputs
       (list sbcl-lisp-unit))
      (inputs
       `(("alexandria" ,sbcl-alexandria)))
      (home-page "https://github.com/soemraws/parse-float")
      (synopsis "Parse a floating point value from a string in Common Lisp")
      (description
       "This package exports the following function to parse floating-point
values from a string in Common Lisp.")
      (license license:public-domain))))

(define-public cl-parse-float
  (sbcl-package->cl-source-package sbcl-parse-float))

(define-public ecl-parse-float
  (sbcl-package->ecl-package sbcl-parse-float))

(define-public clasp-parse-float
  (sbcl-package->clasp-package sbcl-parse-float))

(define-public sbcl-parse-js
  (let ((commit "fbadc6029bec7039602abfc06c73bb52970998f6")
        (revision "1"))
    (package
      (name "sbcl-parse-js")
      (version (git-version "0.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "http://marijn.haverbeke.nl/git/parse-js")
               (commit commit)))
         (file-name (git-file-name "cl-parse-js" version))
         (sha256
          (base32
           "1wddrnr5kiya5s3gp4cdq6crbfy9fqcz7fr44p81502sj3bvdv39"))))
      (build-system asdf-build-system/sbcl)
      (home-page "https://marijnhaverbeke.nl/parse-js/")
      (synopsis "Parse JavaScript")
      (description "Parse-js is a Common Lisp package for parsing
JavaScript (ECMAScript 3).  It has basic support for ECMAScript 5.")
      (license license:zlib))))

(define-public cl-parse-js
  (sbcl-package->cl-source-package sbcl-parse-js))

(define-public ecl-parse-js
  (sbcl-package->ecl-package sbcl-parse-js))

(define-public clasp-parse-js
  (sbcl-package->clasp-package sbcl-parse-js))

(define-public sbcl-parse-number
  (package
    (name "sbcl-parse-number")
    (version "1.7")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
              (url "https://github.com/sharplispers/parse-number/")
              (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "0sk06ib1bhqv9y39vwnnw44vmbc4b0kvqm37xxmkxd4dwchq82d7"))))
    (build-system asdf-build-system/sbcl)
    (home-page "https://www.cliki.net/PARSE-NUMBER")
    (synopsis "Parse numbers")
    (description "@code{parse-number} is a library of functions for parsing
strings into one of the standard Common Lisp number types without using the
reader.  @code{parse-number} accepts an arbitrary string and attempts to parse
the string into one of the standard Common Lisp number types, if possible, or
else @code{parse-number} signals an error of type @code{invalid-number}.")
    (license license:bsd-3)))

(define-public cl-parse-number
  (sbcl-package->cl-source-package sbcl-parse-number))

(define-public ecl-parse-number
  (sbcl-package->ecl-package sbcl-parse-number))

(define-public clasp-parse-number
  (sbcl-package->clasp-package sbcl-parse-number))

(define-public sbcl-parseq
  (package
    (name "sbcl-parseq")
    (version "0.5.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/mrossini-ethz/parseq")
             (commit (string-append "v" version))))
       (file-name (git-file-name "cl-parseq" version))
       (sha256
        (base32 "0b4lnhwqdlaqccanyssdj2v0am2ygw6qr4543b49kz2rwirykw0w"))))
    (build-system asdf-build-system/sbcl)
    (home-page "https://github.com/mrossini-ethz/parseq")
    (synopsis "Parsing expression grammars for sequences")
    (description
     "Parseq (pronounced parsec) is a parsing library for common lisp.  It can
be used for parsing lisp's sequences types: strings, vectors (e.g. binary
data) and lists.  Furthermore, parseq is able to parse nested structures such
as trees (e.g. lists of lists, lists of vectors, vectors of strings).

Parseq uses parsing expression grammars (PEG) that can be defined through a
simple interface.  Extensions to the standard parsing expressions are
available.  Parsing expressions can be parameterised and made context
aware.  Additionally, the definition of each parsing expression allows the
arbitrary transformation of the parsing tree.

The library is inspired by Esrap and uses a very similar interface.  No code
is shared between the two projects, however.  The features of Esrap are are
mostly included in parseq and complemented with additional, orthogonal
features.  Any resemblance to esrap-liquid is merely coincidental.")
    (license license:gpl2)))

(define-public cl-parseq
  (sbcl-package->cl-source-package sbcl-parseq))

(define-public ecl-parseq
  (sbcl-package->ecl-package sbcl-parseq))

(define-public clasp-parseq
  (sbcl-package->clasp-package sbcl-parseq))

(define-public sbcl-parser-combinators
  (let ((commit "9c7569a4f6af5e60c0d3a51d9c15c16d1714c845")
        (revision "1"))
    (package
      (name "sbcl-parser-combinators")
      (version (git-version "0.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/Ramarren/cl-parser-combinators")
               (commit commit)))
         (file-name (git-file-name "parser-combinators" version))
         (sha256
          (base32 "1k49vha5xm2cklayzpqwg73n4v93xwsbs5in6342pkkiimnidhs8"))))
      (build-system asdf-build-system/sbcl)
      (arguments
       ;; FIXME: (Sharlatan-20210523T184237+0100): Tests require `femlisp', which
       ;; is quite chunky not packaged system yet, enable them when it's packed.
       `(#:tests? #f))
      ;; (native-inputs
      ;;  `(("hu.dwim.stefil" ,sbcl-hu.dwim.stefil)
      ;;    ("infix" ,sbcl-femlisp)))
      (inputs
       `(("alexandria" ,sbcl-alexandria)
         ("cl-containers" ,sbcl-cl-containers)
         ("cl-ppcre" ,sbcl-cl-ppcre)
         ("iterate" ,sbcl-iterate)))
      (home-page "https://github.com/Ramarren/cl-parser-combinators")
      (synopsis "Parser combinators in Common Lisp")
      (description
       "PARSER-COMBINATORS is a library implementing monadic parser
combinators in Common Lisp, similar in concept to Haskell Parsec system.")
      (license license:bsd-3))))

(define-public cl-parser-combinators
  (sbcl-package->cl-source-package sbcl-parser-combinators))

(define-public ecl-parser-combinators
  (sbcl-package->ecl-package sbcl-parser-combinators))

(define-public sbcl-path-parse
  (let ((commit "86183f3752374435f8933394b4c5d8e75a37a113")
        (revision "1"))
    (package
      (name "sbcl-path-parse")
      (version (git-version "0.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/eudoxia0/path-parse")
               (commit commit)))
         (file-name (git-file-name "cl-path-parse" version))
         (sha256
          (base32 "10mxm6q62cfpv3hw2w8k968ba8a1xglqdkwlkqs4l4nby3b11aaq"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-split-sequence))
      (native-inputs
       (list sbcl-fiveam))
      (home-page "https://github.com/eudoxia0/path-parse")
      (synopsis "Parse the PATH environment variable in Common Lisp")
      (description
       "This package provides a function to parse the @code{PATH} environment
variable portably in Common Lisp.")
      (license license:expat))))

(define-public cl-path-parse
  (sbcl-package->cl-source-package sbcl-path-parse))

(define-public ecl-path-parse
  (sbcl-package->ecl-package sbcl-path-parse))

(define-public sbcl-pathname-utils
  (let ((commit "3309d65a568acc392ade6a4096c940eb15e1149e")
        (revision "4"))
    (package
      (name "sbcl-pathname-utils")
      (version (git-version "1.1.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/Shinmera/pathname-utils")
               (commit commit)))
         (file-name (git-file-name "cl-pathname-utils" version))
         (sha256
          (base32 "0w7h0qhi53myakfbwvwgr9srbz5mmgsdcbynzkh5vjiibwjg1c3i"))))
      (build-system asdf-build-system/sbcl)
      (native-inputs
       (list sbcl-parachute))
      (inputs
       (list sbcl-trivial-features))
      (home-page "https://shinmera.github.io/pathname-utils/")
      (synopsis "Collection of utilities to help with pathname operations")
      (description
       "This package provides a Common Lisp system with a collection of common
tests and operations to help handling pathnames.  It does not actually deal in
handling the accessing of files on the underlying system however.")
      (license license:zlib))))

(define-public cl-pathname-utils
  (sbcl-package->cl-source-package sbcl-pathname-utils))

(define-public ecl-pathname-utils
  (package
    (inherit (sbcl-package->ecl-package sbcl-pathname-utils))
    (arguments
     `(;; FIXME: It might be an issue in implementation of UIOP for ECL:
       ;;
       ;; Condition of type: TYPE-ERROR
       ;; :HOME is not of type SEQUENCE.
       ;; Available restarts:
       ;; 1. (RESTART-TOPLEVEL) Go back to Top-Level REPL.
       ;; Broken at SI:BYTECODES. [Evaluation of: (MAKE-PATHNAME :DIRECTORY
       ;; '(:ABSOLUTE :HOME))] In: #<process TOP-LEVEL 0x7faa2f991f80>.
       ;;
       #:tests? #f))))

(define-public sbcl-pem
  (let ((commit "1ffb17efaa786574928b5cf5089695d37e4ec550")
        (revision "0"))
    (package
      (name "sbcl-pem")
      (build-system asdf-build-system/sbcl)
      (version (git-version "0.1.0" revision commit))
      (home-page "https://github.com/fukamachi/pem")
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url home-page)
               (commit commit)))
         (file-name (git-file-name "cl-pem" version))
         (sha256
          (base32 "1mi34anznbz12wzng4lma8vcskb20ph5ap6lpsbg0h3pc40kxrzv"))))
      (native-inputs (list sbcl-rove))
      (inputs
        (list sbcl-asn1
              sbcl-cl-ppcre
              sbcl-trivia
              sbcl-ironclad
              sbcl-cl-base64))
      (synopsis "PEM parser for Common Lisp")
      (description "This package provides a PEM (Privacy-Enhanced Mail)
parser for Common Lisp.")
      (license license:bsd-2))))

(define-public cl-pem
  (sbcl-package->cl-source-package sbcl-pem))

(define-public ecl-pem
  (sbcl-package->ecl-package sbcl-pem))

(define-public sbcl-percent-encoding
  (let ((commit "c1224e22bc8048fbd3ebbc9329715a0c1b673170")
        (revision "1"))
    (package
      (name "sbcl-percent-encoding")
      (version (git-version "0.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/llibra/percent-encoding")
               (commit commit)))
         (file-name (git-file-name "percent-encoding" version))
         (sha256
          (base32 "0q1lh3sa6mkjr5gcdkgimkpc29rgf9cjhv90f61h8ridj28grq0h"))))
      (build-system asdf-build-system/sbcl)
      (native-inputs
       (list sbcl-fiveam))
      (inputs
       (list sbcl-anaphora sbcl-babel))
      (synopsis "RFC 3986 percent-encoding library")
      (description
       "This is a Common Lisp library providing RFC 3986 percent-encoding.")
      (home-page "https://github.com/llibra/percent-encoding")
      (license license:expat))))

(define-public ecl-percent-encoding
  (sbcl-package->ecl-package sbcl-percent-encoding))

(define-public cl-percent-encoding
  (sbcl-package->cl-source-package sbcl-percent-encoding))

(define-public sbcl-periodic-table
  (package
    (name "sbcl-periodic-table")
    (version "1.0")
    (source
     (origin
       (method url-fetch)
       (uri (string-append
             "https://common-lisp.net/project/chemboy/periodic-table-"
             version ".tar.gz"))
       (sha256
        (base32 "1ircvqm3q93ma4rxbxprb1i9rcax10ld6xmdzdhfnigr27sh5jvg"))))
    (build-system asdf-build-system/sbcl)
    (home-page "https://common-lisp.net/project/chemboy/")
    (synopsis "Periodic table for Common Lisp")
    (description
     "This package defines a Common Lisp package, @code{:elements}, with an
@code{ELEMENT} structure and a number of functions to search the periodic
table.")
    (license license:llgpl)))

(define-public cl-periodic-table
  (sbcl-package->cl-source-package sbcl-periodic-table))

(define-public ecl-periodic-table
  (sbcl-package->ecl-package sbcl-periodic-table))

(define-public clasp-periodic-table
  (sbcl-package->clasp-package sbcl-periodic-table))

(define-public sbcl-periods
  (let ((commit "1494b8f6887c3ce33d0bf094fd7ec7b77d38c998")
        (revision "3"))
    (package
      (name "sbcl-periods")
      (version (git-version "0.0.2" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/jwiegley/periods")
               (commit commit)))
         (file-name (git-file-name "cl-periods" version))
         (sha256
          (base32 "1m958891rl3sin6h6pgfjdh6ay1s7kfxbxpqvlnzk9rqid0hcs15"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-local-time
             sbcl-series))
      (arguments
       '(#:asd-systems '("periods"
                         "periods-series")))
      (synopsis "Common Lisp library for manipulating date/time objects")
      (description
       "Periods is a Common Lisp library providing a set of utilities for
manipulating times, distances between times, and both contiguous and
discontiguous ranges of time.")
      (home-page "https://github.com/jwiegley/periods")
      (license license:bsd-3))))

(define-public cl-periods
  (sbcl-package->cl-source-package sbcl-periods))

(define-public ecl-periods
  (sbcl-package->ecl-package sbcl-periods))

(define-public sbcl-phos
  (let ((commit "6620b82b091cdfed655e1093ef045dbe518d5474"))
    (package
      (name "sbcl-phos")
      (version (git-version "0.0.1" "1" commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/omar-polo/phos")
               (commit commit)))
         (file-name (git-file-name "phos" version))
         (sha256
          (base32
           "1zwci86rkbaiix0w2gd5q6nr8v2vv945pkvwp0j240iyzd4hfxr3"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-quri sbcl-cl-ppcre sbcl-trivia sbcl-usocket sbcl-cl+ssl
             ;; For the experimental GUI:
             sbcl-nodgui))
      (native-inputs
       (list sbcl-clunit2))
      (home-page "https://github.com/omar-polo/phos")
      (synopsis "Gemini client library and experimental GUI")
      (description "This package contains a Gemini client library for Common
Lisp.  A subsystem offers an experimental GUI Gemini client.")
      (license license:isc))))

(define-public cl-phos
  (sbcl-package->cl-source-package sbcl-phos))

(define-public ecl-phos
  (sbcl-package->ecl-package sbcl-phos))

(define-public sbcl-physical-quantities
  (package
    (name "sbcl-physical-quantities")
    (version "0.2.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/mrossini-ethz/physical-quantities")
             (commit (string-append "v" version))))
       (file-name (git-file-name "cl-physical-quantities" version))
       (sha256
        (base32 "0mb2s94s6fhw5vfa89naalw7ld11sdsszlqpz0c65dvpfyfmmdmh"))))
    (build-system asdf-build-system/sbcl)
    (inputs
     (list sbcl-parseq))
    (home-page "https://github.com/mrossini-ethz/physical-quantities")
    (synopsis "Numeric type with optional unit and/or uncertainty for physics")
    (description
     "This lisp library handles physical quantities which consist of

@itemize
@item value / magnitude
@item uncertainty / error
@item unit
@end itemize

where the type of the value can be any subtype of real.  For the uncertainty,
both absolute and relative values are possible.  Combinations of lisp symbols
or strings are used to describe units.  User defined units including
abbreviations and prefixes are supported.  Error propagation and unit checking
is performed for all defined operations.")
    (license license:gpl2)))

(define-public cl-physical-quantities
  (sbcl-package->cl-source-package sbcl-physical-quantities))

(define-public ecl-physical-quantities
  (sbcl-package->ecl-package sbcl-physical-quantities))

(define-public sbcl-pileup
  (let ((commit "f269473a570a8e55881082545ee63cfe5c7d3e72")
        (revision "1"))
    (package
      (name "sbcl-pileup")
      (version (git-version "1.0.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/nikodemus/pileup")
               (commit commit)))
         (file-name (git-file-name "cl-pileup" version))
         (sha256
          (base32 "01gvshpxil0ggjgfmgcymbgmpsfaxy6aggm0bywkn40rck3038vb"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-alexandria sbcl-bordeaux-threads))
      (native-inputs
       (list sbcl-hu.dwim.stefil))
      (home-page "https://github.com/nikodemus/pileup")
      (synopsis "Simple thread-safe binary heap implementation for Common Lisp")
      (description
       "@code{Pileup} is a portable, performant, and thread-safe binary heap
for Common Lisp.")
      (license license:expat))))

(define-public cl-pileup
  (sbcl-package->cl-source-package sbcl-pileup))

(define-public ecl-pileup
  (sbcl-package->ecl-package sbcl-pileup))

(define-public sbcl-piping
  (let ((commit "c7a4163c00dea7e72bf6ad33d6abac0d5826a656")
        (revision "1"))
    (package
      (name "sbcl-piping")
      (version (git-version "2.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/Shinmera/piping/")
               (commit commit)))
         (file-name (git-file-name "piping" version))
         (sha256
          (base32 "0in84qnfkynm36d4n4d6v87vprpi27xrydnga462wfhplji6klv5"))))
      (build-system asdf-build-system/sbcl)
      (home-page "https://shinmera.github.io/piping/")
      (synopsis "Library to enable simple message pipelines")
      (description
       "This is a Common Lisp library to enable simple message pipelines.")
      (license license:zlib))))

(define-public cl-piping
  (sbcl-package->cl-source-package sbcl-piping))

(define-public ecl-piping
  (sbcl-package->ecl-package sbcl-piping))

(define-public clasp-piping
  (sbcl-package->clasp-package sbcl-piping))

(define-public sbcl-plump
  (let ((commit "251fbe02e9bcdb5940d881788b880d51f7f35303")
        (revision "4"))
    (package
      (name "sbcl-plump")
      (version (git-version "2.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri
          (git-reference
           (url "https://codeberg.org/shinmera/plump")
           (commit commit)))
         (file-name (git-file-name "cl-plump" version))
         (sha256
          (base32 "0w2n5wskgqvazb721amfd7smydnj3mxsyzg03xk2k1vaizzxdzvk"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-array-utils sbcl-documentation-utils))
      (synopsis "Lenient XML / XHTML / HTML parser for Common Lisp")
      (description
       "Plump is a parser for HTML/XML-like documents, focusing on being
lenient towards invalid markup.  It can handle things like invalid attributes,
bad closing tag order, unencoded entities, inexistent tag types, self-closing
tags and so on.  It parses documents to a class representation and offers a
small set of DOM functions to manipulate it.  It can be extended to parse to
your own classes.")
      (home-page "https://codeberg.org/shinmera/plump")
      (license license:zlib))))

(define-public cl-plump
  (sbcl-package->cl-source-package sbcl-plump))

(define-public ecl-plump
  (sbcl-package->ecl-package sbcl-plump))

(define-public clasp-plump
  (sbcl-package->clasp-package sbcl-plump))

(define-public sbcl-plump-sexp
  (let ((commit "a40f66dbc7bf9d5957b1f85b184ce6798519ab96")
        (revision "1"))
    (package
      (name "sbcl-plump-sexp")
      (version (git-version "0.1.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri
          (git-reference
           (url "https://codeberg.org/shinmera/plump-sexp")
           (commit commit)))
         (file-name (git-file-name "cl-plump-sexp" version))
         (sha256
          (base32
           "0iyz4xn7sk6pxx9avc2ajcy9268zdfr3xyvi16hgpajwcbqi5sjq"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-plump))
      (synopsis "Convert S-expressions into a Plump DOM and back")
      (description
       "The Plump-SEXP library is a backend for Plump which can convert
between S-expressions and the Plump DOM.")
      (home-page "https://codeberg.org/shinmera/plump-sexp")
      (license license:zlib))))

(define-public cl-plump-sexp
  (sbcl-package->cl-source-package sbcl-plump-sexp))

(define-public ecl-plump-sexp
  (sbcl-package->ecl-package sbcl-plump-sexp))

(define-public clasp-plump-sexp
  (sbcl-package->clasp-package sbcl-plump-sexp))

(define-public sbcl-png
  (let ((commit "11b965fe378fd0561abe3616b18ff03af5179648")
        (revision "1"))
    (package
      (name "sbcl-png")
      (version (git-version "0.6" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/ljosa/cl-png")
               (commit commit)))
         (file-name (git-file-name "cl-png" version))
         (sha256
          (base32 "173hqwpd0rwqf95mfx1h9l9c3i8bb0gvnpspzmmz3g5x3440czy4"))
         ;; Patch to fix compiling with SBCL >= 2.1.6.
         (patches (search-patches "sbcl-png-fix-sbcl-compatibility.patch"))))
      (build-system asdf-build-system/sbcl)
      (arguments
       `(#:phases
         (modify-phases %standard-phases
           (add-after 'unpack 'fix-lib-paths
             (lambda* (#:key inputs #:allow-other-keys)
               (substitute* "libpng.lisp"
                 (("\"libpng\"")
                  (string-append "\""
                                 (assoc-ref inputs "libpng")
                                 "/lib/libpng\""))))))))
      (inputs
       `(("cffi" ,sbcl-cffi)
         ("libpng" ,libpng)))
      (home-page "https://github.com/ljosa/cl-png")
      (synopsis "Read and write PNG file format")
      (description
       "This package provides a @code{PNG} Common Lisp system to operate with
Portable Network Graphics file format.")
      (license license:lgpl2.1))))

(define-public ecl-png
  (sbcl-package->ecl-package sbcl-png))

(define-public cl-png
  (sbcl-package->cl-source-package sbcl-png))

(define-public sbcl-png-read
  (let ((commit "ec29f38a689972b9f1373f13bbbcd6b05deada88")
        (revision "1"))
    (package
      (name "sbcl-png-read")
      (version (git-version "0.3.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/Ramarren/png-read")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "0vyczbcwskrygrf1hgrsnk0jil8skmvf1kiaalw5jps4fjrfdkw0"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-babel sbcl-chipz sbcl-iterate))
      (synopsis "PNG decoder for Common Lisp")
      (description "This is a Common Lisp library for reading PNG images.")
      (home-page "https://github.com/Ramarren/png-read")
      (license license:bsd-3))))

(define-public cl-png-read
  (sbcl-package->cl-source-package sbcl-png-read))

(define-public ecl-png-read
  (sbcl-package->ecl-package sbcl-png-read))

(define-public sbcl-pngload
  (let ((commit "91f1d703c65bb6a94d6fee06ddbbbbbc5778b71f")
        (revision "2"))
    (package
      (name "sbcl-pngload")
      (version (git-version "2.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://git.mfiano.net/mfiano/pngload.git")
               (commit commit)))
         (file-name (git-file-name "pngload" version))
         (sha256
          (base32 "0s94fdbrbqj12qvgyn2g4lfwvz7qhhzbclrpz5ni7adwxgrmvxl1"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       `(("3bz" ,sbcl-3bz)
         ("alexandria" ,sbcl-alexandria)
         ("cffi" ,sbcl-cffi)
         ("mmap" ,sbcl-mmap)
         ("parse-float" ,sbcl-parse-float)
         ("static-vectors" ,sbcl-static-vectors)
         ("swap-bytes" ,sbcl-swap-bytes)
         ("zpb-exif" ,sbcl-zpb-exif)))
      (arguments
       ;; Test suite disabled because of a dependency cycle.
       ;; pngload tests depend on opticl which depends on pngload.
       '(#:tests? #f))
      (home-page "https://git.mfiano.net/mfiano/pngload.git")
      (synopsis "PNG image decoder for Common Lisp")
      (description
       "This is a Common Lisp library to load images in the PNG image format,
both from files on disk, or streams in memory.")
      (license license:expat))))

(define-public cl-pngload
  (sbcl-package->cl-source-package sbcl-pngload))

(define-public ecl-pngload
  (sbcl-package->ecl-package sbcl-pngload))

(define-public sbcl-policy-cond
  (let ((commit "eedb625520175bfdf44d385ff3b21039b7f75706")
        (revision "0"))
    (package
      (name "sbcl-policy-cond")
      (version (git-version "0.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/stylewarning/policy-cond")
               (commit commit)))
         (file-name (git-file-name "cl-policy-cond" version))
         (sha256
          (base32 "0xj2a6lcg7i7g4038sc4f641din6m8vdiha8c5afz9fik80bshxk"))))
      (build-system asdf-build-system/sbcl)
      (home-page "https://github.com/stylewarning/policy-cond")
      (synopsis "Insert code based on compiler policy")
      (description "POLICY-COND provides tools to insert and execute code
based on a compiler's OPTIMIZE policy.  It also contains a contract-like notion
of expectations, which allow dynamic checking or inclusion of various things
that should happen depending on compiler policy.")
      (license license:bsd-3))))

(define-public cl-policy-cond
  (sbcl-package->cl-source-package sbcl-policy-cond))

(define-public ecl-policy-cond
  (sbcl-package->ecl-package sbcl-policy-cond))

(define-public sbcl-polymorphic-functions
  (package
    (name "sbcl-polymorphic-functions")
    (version "0.5.2")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/digikar99/polymorphic-functions/")
             (commit (string-append "v" version))))
       (file-name (git-file-name "cl-polymorphic-functions" version))
       (sha256
        (base32 "1bawhbj5rh1q6qrcjnx48n78841mgri5n63pmicxxyhif2il0zq3"))))
    (build-system asdf-build-system/sbcl)
    (inputs
     (list sbcl-alexandria
           sbcl-cl-form-types
           sbcl-closer-mop
           sbcl-compiler-macro-notes
           sbcl-ctype
           sbcl-fiveam
           sbcl-introspect-environment
           sbcl-slime-swank))
    (arguments
     ;; Tests fail: https://github.com/digikar99/polymorphic-functions/issues/8
     (list #:tests? #f
           #:phases
           #~(modify-phases %standard-phases
               (add-after 'unpack 'fix-build
                 (lambda _
                   ;; SBCL 2.4.10 doesn't allow user code to
                   ;; rebind *IN-COMPILATION-UNIT*.
                   (substitute* "src/nonlite/dispatch.lisp"
                     (("#\\+sbcl \\(sb-c::\\*in-compilation-unit\\* nil\\)")
                      "")))))))
    (home-page "https://github.com/digikar99/polymorphic-functions/")
    (synopsis "Function type to dispatch on types instead of classes")
    (description
     "This library provides all of

@itemize
@item ad hoc polymorphism and
@item subtype polymorphism
@item parametric polymorphism (in a very limited sense)
@end itemize

to dispatch on the basis of types rather than classes.")
    (license license:expat)))

(define-public cl-polymorphic-functions
  (sbcl-package->cl-source-package sbcl-polymorphic-functions))

(define-public ecl-polymorphic-functions
  (sbcl-package->ecl-package sbcl-polymorphic-functions))

(define-public sbcl-portable-condition-system
  (let ((commit "1307ec146d227a9d8ea42312c1ba2a5206a9eb3c")
        (revision "0"))
    (package
      (name "sbcl-portable-condition-system")
      (version (git-version "1.1.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/phoe/portable-condition-system")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "099lb9f4bavj95wik99wla5rf6fk1gdw9pvn0cqlaf0wf20csd3h"))))
      (build-system asdf-build-system/sbcl)
      (arguments
       '(#:asd-systems '("portable-condition-system")))
      (native-inputs
       (list sbcl-1am))
      (inputs
       (list sbcl-alexandria
             sbcl-split-sequence))
      (home-page "https://github.com/phoe/portable-condition-system")
      (synopsis "Portable condition system for Common Lisp")
      (description
       "This package provides an example implementation of the Common Lisp
condition system and library, based on the original condition system
implementation by Kent M. Pitman.")
      (license license:cc0))))

(define-public cl-portable-condition-system
  (sbcl-package->cl-source-package sbcl-portable-condition-system))

(define-public ecl-portable-condition-system
  (sbcl-package->ecl-package sbcl-portable-condition-system))

(define-public sbcl-portable-threads
  (let ((commit "aa26bf38338a6b068bf8bfb3375d8d8c3b0a28df"))
    (package
      (name "sbcl-portable-threads")
      (version (git-version "2.3" "2" commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/binghe/portable-threads/")
               (commit commit)))
         (file-name (git-file-name "portable-threads" version))
         (sha256
          (base32 "058ksi07vfdmhrf5mdlc833s82m1rcqfja2266520m3r8bzs8bvs"))))
      (build-system asdf-build-system/sbcl)
      (arguments
       `(;; Tests seem broken.
         #:tests? #f))
      (home-page "https://github.com/binghe/portable-threads")
      (synopsis "Portable threads API for Common Lisp")
      (description
       "Portable Threads (and Scheduled and Periodic Functions) API for Common
Lisp (from GBBopen project).")
      (license license:asl2.0))))

(define-public cl-portable-threads
  (sbcl-package->cl-source-package sbcl-portable-threads))

(define-public ecl-portable-threads
  (sbcl-package->ecl-package sbcl-portable-threads))

(define-public sbcl-portal
  (let ((commit "416589fa04cb239971422a1272acba236c8333be")
        (revision "2"))
    (package
      (name "sbcl-portal")
      (version (git-version "1.2" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/charJe/portal")
               (commit commit)))
         (file-name (git-file-name "portal" version))
         (sha256
          (base32 "1012jc068qdd8df6mmbn8vmmqlniqm5j2jbyrraw3yz8c13c8280"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-alexandria
             sbcl-arrows
             sbcl-cl-base64
             sbcl-cl-str
             sbcl-flexi-streams
             sbcl-global-vars
             sbcl-ironclad
             sbcl-parse-float
             sbcl-usocket))
      (home-page "https://github.com/charJe/portal")
      (synopsis "Portable Websocket Server for Common Lisp")
      (description
       "This is a websocket server for Common Lisp using usockets to be
portable between implementations and operating systems.  It has a programming
interface that allows for multiple websocket apps per server using Common Lisp
keywords for different websocket events.  It has useful restarts and
customizable errors.")
      (license license:llgpl))))

(define-public cl-portal
  (sbcl-package->cl-source-package sbcl-portal))

(define-public ecl-portal
  (sbcl-package->ecl-package sbcl-portal))

(define-public sbcl-positional-lambda
  (let ((commit "a43a7bb4ef6faa277e6a7440ec9839711c4b9d28")
        (revision "0"))
    (package
      (name "sbcl-positional-lambda")
      (version (git-version "2.0" revision commit))
      (source
        (origin
          (method git-fetch)
          (uri (git-reference
                (url "https://github.com/Hexstream/positional-lambda")
                (commit commit)))
          (file-name (git-file-name "cl-positional-lambda" version))
          (sha256
           (base32 "1l27mw5ciqz7rnjq1lwslgk220i8iqcr39rs8b7hxkp1yqmah5zq"))))
      (build-system asdf-build-system/sbcl)
      (native-inputs
        (list sbcl-parachute))
      (inputs
        (list sbcl-map-bind))
      (home-page "https://www.hexstreamsoft.com/libraries/positional-lambda/")
      (synopsis "Macro favouring positional references over naming")
      (description
       "This package provides a concise, intuitive and flexible macro for
trivial lambdas that eschews explicit naming of parameter variables in favor
of positional references, with support for a used or ignored &rest parameter
and automatic declaration of ignored parameters when logical @code{gaps}
are left in the positional references.  Further convenience features
are provided.")
      (license license:unlicense))))

(define-public cl-positional-lambda
  (sbcl-package->cl-source-package sbcl-positional-lambda))

(define-public ecl-cl-positional-lambda
  (sbcl-package->ecl-package sbcl-positional-lambda))

(define-public sbcl-posix-shm
  (package
    (name "sbcl-posix-shm")
    (version "0.0.7")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://git.sr.ht/~shunter/posix-shm")
             (commit (string-append "v" version))))
       (file-name (git-file-name "cl-posix-shm" version))
       (sha256
        (base32 "1lk8sach64zgj81988q3z8i153gi3dkda3fkb11cxgsmymawddk9"))))
    (build-system asdf-build-system/sbcl)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'fix-paths
            (lambda* (#:key inputs #:allow-other-keys)
              (substitute* "ffi/ffi.lisp"
                (("libc.so.6")
                 (search-input-file inputs "/lib/libc.so.6"))
                (("librt.so.1")
                 (search-input-file inputs "/lib/librt.so.1"))))))))
    (native-inputs
     (list sbcl-osicat
           sbcl-parachute))
    (inputs
     (list sbcl-alexandria
           sbcl-cffi
           sbcl-trivial-features))
    (home-page "https://git.sr.ht/~shunter/posix-shm")
    (synopsis "Common Lisp bindings and wrapper for POSIX shared memory API")
    (description
     "This library provides two strata to access the POSIX shm API:

@itemize
@item the package @code{posix-shm/ffi}, a collection of slim bindings to the
POSIX API

@item the package @code{posix-shm}, a lispy wrapper around the FFI that
integrates more closely to the features of Common Lisp, and provides a handful
of utilities and macros
@end itemize

Features include:

@itemize
@item open, close, create, resize, change ownership of, change permissions of,
and memory map to shared memory objects
@item @code{open-shm} appears more like @code{open} from the standard library
@item @code{open-shm*}, for creating anonymous shm objects
@item @code{with-open-shm}, @code{with-mmap} and similar @code{with-} macros
for safely accessing resources with dynamic extent
@end itemize")
    (license license:bsd-3)))

(define-public cl-posix-shm
  (sbcl-package->cl-source-package sbcl-posix-shm))

;; XXX: An error occurred during initialization: Attempt to redefine
;; function FTRUNCATE in locked package.
;; (define-public ecl-posix-shm
;;   (sbcl-package->ecl-package sbcl-posix-shm))

(define-public sbcl-postmodern
  (package
    (name "sbcl-postmodern")
    (version "1.33.12")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/marijnh/Postmodern")
             (commit (string-append "v" version))))
       (file-name (git-file-name "cl-postmodern" version))
       (sha256
        (base32 "14js3pz0jbvf11liqbrxhndb98vasib4bzkv7im87mysxzk8glqz"))))
    (build-system asdf-build-system/sbcl)
    (native-inputs
     (list sbcl-fiveam sbcl-trivial-octet-streams))
    (inputs
     (list sbcl-alexandria
           sbcl-bordeaux-threads
           sbcl-cl-base64
           sbcl-cl-unicode
           sbcl-closer-mop
           sbcl-global-vars
           sbcl-ironclad
           sbcl-local-time
           sbcl-md5
           sbcl-split-sequence
           sbcl-uax-15
           sbcl-usocket))
    (arguments
     ;; TODO: (Sharlatan-20210114T171037+0000) tests still failing but on other
     ;; step, some functionality in `local-time' prevents passing tests.
     ;; Error:
     ;;
     ;; Can't create directory
     ;; /gnu/store
     ;;  /4f47agf1kyiz057ppy6x5p98i7mcbfsv-sbcl-local-time-1.0.6-2.a177eb9
     ;;   /lib/common-lisp/sbcl/local-time/src/integration/
     ;;
     ;; NOTE: (Sharlatan-20210124T191940+0000): When set env HOME to /tmp above
     ;; issue is resolved but it required live test database to connect to now.
     ;; Keep tests switched off.
     `(#:tests? #f
       #:asd-systems '("cl-postgres"
                       "s-sql"
                       "postmodern"
                       "simple-date"
                       "simple-date/postgres-glue")))
    (synopsis "Common Lisp library for interacting with PostgreSQL")
    (description
     "@code{postmodern} is a Common Lisp library for interacting with
PostgreSQL databases.  It provides the following features:

@itemize
@item Efficient communication with the database server without need for
foreign libraries.
@item Support for UTF-8 on Unicode-aware Lisp implementations.
@item A syntax for mixing SQL and Lisp code.
@item Convenient support for prepared statements and stored procedures.
@item A metaclass for simple database-access objects.
@end itemize\n

This package produces 4 systems: postmodern, cl-postgres, s-sql, simple-date

@code{SIMPLE-DATE} is a very basic implementation of date and time objects, used
to support storing and retrieving time-related SQL types.  It is not loaded by
default and you can use local-time (which has support for timezones) instead.

@code{S-SQL} is used to compile s-expressions to strings of SQL code, escaping
any Lisp values inside, and doing as much as possible of the work at compile
time.

@code{CL-POSTGRES} is the low-level library used for interfacing with a PostgreSQL
server over a socket.

@code{POSTMODERN} itself is a wrapper around these packages and provides higher
level functions, a very simple data access object that can be mapped directly to
database tables and some convenient utilities.  It then tries to put all these
things together into a convenient programming interface")
    (home-page "https://marijnhaverbeke.nl/postmodern/")
    (license license:zlib)))

(define-public cl-postmodern
  (sbcl-package->cl-source-package sbcl-postmodern))

(define-public ecl-postmodern
  (sbcl-package->ecl-package sbcl-postmodern))

(define-public sbcl-pp-toml
  (let ((commit "54f7d08c939d18b24363342c98c19b6812d7afb9")
        (revision "0"))
    (package
      (name "sbcl-pp-toml")
      (version (git-version "1.0.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/pnathan/pp-toml")
               (commit commit)))
         (file-name (git-file-name "cl-pp-toml" version))
         (sha256
          (base32 "136d7jzz7l2ck9wwld0ac46jmpm94lvja6m50sy73s232slka2hg"))))
      (build-system asdf-build-system/sbcl)
      (native-inputs
       (list sbcl-fiveam))
      (inputs
       (list sbcl-alexandria
             sbcl-cl-ppcre
             sbcl-esrap
             sbcl-generic-comparability
             sbcl-local-time
             sbcl-parse-number
             sbcl-split-sequence))
      (home-page "https://github.com/pnathan/pp-toml")
      (synopsis "TOML parser for Common Lisp")
      (description
       "PP-TOML is a Common Lisp library for parsing strings in the TOML
configuration file format.  It implements only the 0.1.0 specification of
TOML.")
      (license license:llgpl))))

(define-public cl-pp-toml
  (sbcl-package->cl-source-package sbcl-pp-toml))

(define-public ecl-pp-toml
  (sbcl-package->ecl-package sbcl-pp-toml))

(define-public sbcl-ppath
  (let ((commit "eb1a8173b4d1d691ea9a7699412123462f58c3ce"))
    (package
      (name "sbcl-ppath")
      (version (git-version "0.1" "1" commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/fourier/ppath/")
               (commit commit)))
         (file-name (git-file-name name commit))
         (sha256
          (base32 "1c46q9lmzqv14z80d3fwdawgn3pn4922x31fyqvsvbcjm4hd16fb"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-alexandria
             sbcl-cffi
             sbcl-osicat
             sbcl-cl-ppcre
             sbcl-split-sequence
             sbcl-trivial-features))
      (native-inputs
       (list sbcl-cl-fad sbcl-prove))
      (home-page "https://github.com/fourier/ppath")
      (synopsis "Common Lisp's implementation of the Python's os.path module")
      (description
       "This library is a path strings manipulation library inspired by
Python's @code{os.path}.  All functionality from @code{os.path} is supported on
major operation systems.

The philosophy behind is to use simple strings and \"dumb\" string
manipulation functions to handle paths and filenames.  Where possible the
corresponding OS system functions are called.")
      (license license:bsd-2))))

(define-public ecl-ppath
  (sbcl-package->ecl-package sbcl-ppath))

(define-public cl-ppath
  (sbcl-package->cl-source-package sbcl-ppath))

(define-public sbcl-print-licenses
  (let ((commit "3949663318fb736f4ee660e3aa810875187d531c")
        (revision "0"))
    (package
      (name "sbcl-print-licenses")
      (build-system asdf-build-system/sbcl)
      (version (git-version "0.1.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/vindarel/print-licenses")
               (commit commit)))
         (file-name (git-file-name "cl-print-licenses" version))
         (sha256
          (base32 "14i6r6mf16dlj1g4xk0alg2912y3wy0qbfpyvvgsgxkkar63cmi5"))))
      (inputs (list sbcl-alexandria sbcl-iterate))
      (home-page "https://github.com/vindarel/print-licenses/")
      (synopsis "Print licenses used by a Common Lisp project")
      (description
       "This library can be used to print the licenses used by a Common Lisp
project and its dependencies.")
      (license license:expat))))

(define-public ecl-print-licenses
  (sbcl-package->ecl-package sbcl-print-licenses))

(define-public clasp-print-licenses
  (sbcl-package->clasp-package sbcl-print-licenses))

(define-public cl-print-licenses
  (sbcl-package->cl-source-package sbcl-print-licenses))

(define-public sbcl-printv
  (let ((commit "e717a7fe076dae861a96117b2f9af29db8d2294d")
        (revision "2"))
    (package
      (name "sbcl-printv")
      (version (git-version "0.1.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/danlentz/printv")
               (commit commit)))
         (file-name (git-file-name "cl-printv" version))
         (sha256
          (base32 "07agyzkwp3w2r4d2anrmr8h00yngpr5dq9mjd3m4kzhn1jcmilfb"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list figlet))
      (arguments
       `(#:phases
         (modify-phases %standard-phases
           (add-after 'unpack 'patch-figlet-executable
             (lambda* (#:key inputs #:allow-other-keys)
               (substitute* "printv.lisp"
                 (("\"figlet")
                  (string-append "\"" (search-input-file inputs
                                                         "/bin/figlet")))))))))
      (home-page "https://github.com/danlentz/printv")
      (synopsis "Common Lisp tracing and debug-logging macro")
      (description
       "@code{PRINTV} is a \"batteries-included\" tracing and debug-logging
macro for Common Lisp.")
      (license license:asl2.0))))

(define-public ecl-printv
  (sbcl-package->ecl-package sbcl-printv))

(define-public cl-printv
  (sbcl-package->cl-source-package sbcl-printv))

(define-public sbcl-priority-queue
  (let ((commit "011b8d52ef7ba7f8e6bc26608eedef222b38aaa8")
        (revision "0"))
    (package
      (name "sbcl-priority-queue")
      (version (git-version "0.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/dsorokin/priority-queue")
               (commit commit)))
         (file-name (git-file-name "cl-priority-queue" version))
         (sha256
          (base32 "0y5a1fid8xzzl58hfdj64n8mrzq0kr06a0lnmdjpgi0czc3x0jcy"))))
      (build-system asdf-build-system/sbcl)
      (synopsis "Priority queue for Common Lisp")
      (description "This package provides a priority queue implemented with
an array-based heap.")
      (home-page "https://github.com/dsorokin/priority-queue")
      (license license:expat))))

(define-public cl-priority-queue
  (sbcl-package->cl-source-package sbcl-priority-queue))

(define-public ecl-priority-queue
  (sbcl-package->ecl-package sbcl-priority-queue))

(define-public clasp-priority-queue
  (sbcl-package->clasp-package sbcl-priority-queue))

(define-public sbcl-proc-parse
  (let ((commit "ac3636834d561bdc2686c956dbd82494537285fd"))
    (package
      (name "sbcl-proc-parse")
      (version (git-version "0.0.0" "1" commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/fukamachi/proc-parse")
               (commit commit)))
         (sha256
          (base32
           "06rnl0h4cx6xv2wj3jczmmcxqn2703inmmvg1s4npbghmijsybfh"))
         (file-name (git-file-name "proc-parse" version))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-alexandria
             sbcl-babel))
      (native-inputs
       (list sbcl-prove))
      (arguments
       '(#:asd-systems '("proc-parse-test"
                         "proc-parse")))
      (synopsis "Procedural vector parser")
      (description
       "This is a string/octets parser library for Common Lisp with speed and
readability in mind.  Unlike other libraries, the code is not a
pattern-matching-like, but a char-by-char procedural parser.")
      (home-page "https://github.com/fukamachi/proc-parse")
      (license license:bsd-2))))

(define-public cl-proc-parse
  (sbcl-package->cl-source-package sbcl-proc-parse))

(define-public ecl-proc-parse
  (sbcl-package->ecl-package sbcl-proc-parse))

(define-public sbcl-progressons
  (let ((commit "69a8092e43876d66943aef709ab641818d52f2da")
        (revision "0"))
    (package
      (name "sbcl-progressons")
      (version (git-version "0.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/vindarel/progressons")
               (commit commit)))
         (file-name (git-file-name "cl-progressons" version))
         (sha256
          (base32 "1i93khd0l1aphzh6qb4yy9cpi2nmqac08b90yx95p4zymap03nly"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-cl-ansi-text
             sbcl-cl-str))
      (synopsis "Display a progress bar on one line")
      (description
       "This library can be used to display a progress bar on one line.")
      (home-page "https://github.com/vindarel/progressons")
      (license license:expat))))

(define-public cl-progressons
  (sbcl-package->cl-source-package sbcl-progressons))

(define-public ecl-progressons
  (sbcl-package->ecl-package sbcl-progressons))

(define-public sbcl-prometheus
  (package
    (name "sbcl-prometheus")
    (version "0.4.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/deadtrickster/prometheus.cl")
             (commit "7352b92296996ff383503e19bdd3bcea30409a15")))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "0fzczls2kfgdx18pja4lqxjrz72i583185d8nq0pb3s331hhzh0z"))))
    (build-system asdf-build-system/sbcl)
    (inputs
     `(("alexandria" ,sbcl-alexandria)
       ("bordeaux-threads" ,sbcl-bordeaux-threads)
       ("cffi" ,sbcl-cffi)
       ("cl-fad" ,sbcl-cl-fad)
       ("cl-ppcre" ,sbcl-cl-ppcre)
       ("drakma" ,sbcl-drakma)
       ("hunchentoot" ,sbcl-hunchentoot)
       ("local-time" ,sbcl-local-time)
       ("quantile-estimator" ,sbcl-quantile-estimator)
       ("salza2" ,sbcl-salza2)
       ("split-sequence" ,sbcl-split-sequence)
       ("trivial-utf-8" ,sbcl-trivial-utf-8)))
    (arguments
     '(#:asd-systems '("prometheus"
                       "prometheus.collectors.sbcl"
                       "prometheus.collectors.process"
                       "prometheus.formats.text"
                       "prometheus.exposers.hunchentoot"
                       "prometheus.pushgateway")))
    (home-page "https://github.com/deadtrickster/prometheus.cl")
    (synopsis "Prometheus.io Common Lisp client")
    (description "Prometheus.io Common Lisp client.")
    (license license:expat)))

(define-public cl-prometheus
  (sbcl-package->cl-source-package sbcl-prometheus))

(define-public ecl-prometheus
  (sbcl-package->ecl-package sbcl-prometheus))

(define-public sbcl-promise
  (let ((commit "801db8f853da7935ae2e487fd7f8763acbc5ad2a")
        (revision "0"))
    (package
      (name "sbcl-promise")
      (version (git-version "1.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/Shinmera/promise")
               (commit commit)))
         (file-name (git-file-name "cl-promise" version))
         (sha256
          (base32 "07cvz6vb5y1d9vndcwq7q1cp54aqvyqzv6wk8vmymbz3lawq2wsn"))))
      (build-system asdf-build-system/sbcl)
      (native-inputs
       (list sbcl-parachute))
      (inputs
       (list sbcl-documentation-utils))
      (home-page "https://shinmera.github.io/promise/")
      (synopsis "Promise mechanism for asynchronous operations")
      (description
       "This library implements a basic promise datastructure, which is useful
for dealing with asynchronous behaviours.  Importantly, this library does not
use any other libraries or frameworks, and instead leaves the execution and
state transition of promise objects in your control, making it easy to
integrate.")
      (license license:zlib))))

(define-public cl-promise
  (sbcl-package->cl-source-package sbcl-promise))

(define-public ecl-promise
  (sbcl-package->ecl-package sbcl-promise))

(define-public clasp-promise
  (sbcl-package->clasp-package sbcl-promise))

(define-public sbcl-prompter
  (let ((commit "7890ed5d02e70aba01ceb964c6ee4f40776e7dc0")
        (revision "0"))
    (package
      (name "sbcl-prompter")
      (version (git-version "0.1.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/atlas-engineer/prompter")
               (commit commit)))
         (file-name (git-file-name "cl-prompter" version))
         (sha256
          (base32
           "0r15a6cagyp5x8aqx92ln2anni737h73bdshkvpzrac04ajss4md"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list
        sbcl-alexandria
        sbcl-calispel
        sbcl-cl-containers
        sbcl-cl-str
        sbcl-closer-mop
        sbcl-lparallel
        sbcl-moptilities
        sbcl-nclasses
        sbcl-serapeum
        sbcl-trivial-package-local-nicknames))
      (native-inputs
       (list sbcl-lisp-unit2))
      (home-page "https://github.com/atlas-engineer/prompter")
      (synopsis "Live-narrowing, fuzzy-matching, extensible prompt framework")
      (description
       "This prompter library is heavily inspired by Emacs' minibuffer and
Helm (@url{https://emacs-helm.github.io/helm/}).  It only deals with the
backend side of things, it does not handle any display.  Features include
asynchronous suggestion computation, multiple sources, actions and resumable
prompters.")
      (license license:bsd-3))))

(define-public cl-prompter
  (sbcl-package->cl-source-package sbcl-prompter))

(define-public ecl-prompter
  (sbcl-package->ecl-package sbcl-prompter))

(define-public sbcl-purgatory
  (let ((commit "3afd8f6bb4093ffb2f39ffdedf11278b3617fff9")
        (revision "1"))
    (package
      (name "sbcl-purgatory")
      (version (git-version "0.1.2" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://notabug.org/cage/purgatory")
               (commit commit)))
         (file-name (git-file-name "cl-purgatory" version))
         (sha256
          (base32 "0iy2jdgrwqrq9cph7bwf79d8l4zdsgcd9sfcn0lclzai2v0yizp9"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-alexandria
             sbcl-babel
             sbcl-bordeaux-threads
             sbcl-cl-ppcre-unicode
             sbcl-usocket))
      (synopsis "Common Lisp implementation of the 9p protocol")
      (description "This is a Common Lisp library that implements
the 9p network filesystem protocol.")
      (home-page "https://notabug.org/cage/purgatory/")
      (license license:llgpl))))

(define-public cl-purgatory
  (sbcl-package->cl-source-package sbcl-purgatory))

(define-public ecl-purgatory
  (sbcl-package->ecl-package sbcl-purgatory))

(define-public sbcl-puri
  (let ((commit "4bbab89d9ccbb26346899d1f496c97604fec567b")
        (revision "2"))
    (package
      (name "sbcl-puri")
      (version (git-version "1.5.7" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "http://git.kpe.io/puri.git")
               (commit commit)))
         (file-name (git-file-name "puri" version))
         (sha256
          (base32 "0gq2rsr0aihs0z20v4zqvmdl4szq53b52rh97pvnmwrlbn4mapmd"))
         (modules '((guix build utils)))
         (snippet
          ;; The useless bundled debian folder drags `make' into the closure.
          `(begin
             (delete-file-recursively "debian")
             #t))))
      (build-system asdf-build-system/sbcl)
      (native-inputs
       (list sbcl-ptester))
      (home-page "http://puri.kpe.io/")
      (synopsis "Portable URI Library")
      (description
       "This is a portable Universal Resource Identifier library for Common
Lisp programs.  It parses URI according to the RFC 2396 specification.")
      (license license:llgpl))))

(define-public cl-puri
  (sbcl-package->cl-source-package sbcl-puri))

(define-public ecl-puri
  (sbcl-package->ecl-package sbcl-puri))

(define-public clasp-puri
  (sbcl-package->clasp-package sbcl-puri))

(define-public sbcl-py-configparser
  ;; NOTE: (Sharlatan <2021-01-05 Tue> <19:52:19 UTC+0000>) Project updated last
  ;; time 8y ago, it looks like abandoned. VCS of the project:
  ;; https://svn.common-lisp.net/py-configparser/trunk
  (package
    (name "sbcl-py-configparser")
    (version "1.0.3")
    (source
     (origin
       (method url-fetch)
       (uri (string-append
             "https://common-lisp.net/project/py-configparser/releases/"
             "py-configparser-" version ".tar.gz"))
       (sha256
        (base32 "0i4rqz5cv7d7c2w81x5lwy05s6fbi3zikf4k5kpi3bkx3cabwdxj"))))
    (build-system asdf-build-system/sbcl)
    (inputs
     (list sbcl-parse-number))
    (home-page "https://common-lisp.net/project/py-configparser/")
    (synopsis "ConfigParser Python module functionality for Common Lisp")
    (description "The py-configparser package implements the ConfigParser
Python module functionality in Common Lisp.  In short, it implements reading
and writing of .INI-file style configuration files with sections containing
key/value pairs of configuration options.  In line with the functionalities in
the python module, does this package implement basic interpolation of option
values in other options.")
    (license license:expat)))

(define-public cl-py-configparser
  (sbcl-package->cl-source-package sbcl-py-configparser))

(define-public ecl-py-configparser
  (sbcl-package->ecl-package sbcl-py-configparser))

(define-public clasp-py-configparser
  (sbcl-package->clasp-package sbcl-py-configparser))

(define-public sbcl-py4cl
  (let ((commit "2f2a008dd6162d4446803971292fe1b323fe0dd5")
        (revision "2"))
    (package
      (name "sbcl-py4cl")
      (version (git-version "0.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/bendudson/py4cl")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "1zx1kpfpd8mi1qaa7gr32mki6nvl6pqcs3437fvn4xa3yf7ybsha"))
         (modules '((guix build utils)))))
      (build-system asdf-build-system/sbcl)
      (native-inputs
       (list sbcl-clunit))
      (inputs
       (list python sbcl-trivial-garbage))
      (propagated-inputs
       (list ;; For multi-dimensional array support
             python-numpy))
      (arguments
       '(#:phases
         (modify-phases %standard-phases
           (add-after 'unpack 'fix-python3-path
             (lambda* (#:key inputs #:allow-other-keys)
               (substitute* "src/python-process.lisp"
                 (("\\*python-command\\* \"python\"")
                  (string-append "*python-command* "
                                 "\""
                                 (search-input-file inputs "/bin/python3")
                                 "\"")))))
           (add-after 'unpack 'replace-*base-directory*-var
             (lambda* (#:key outputs #:allow-other-keys)
               ;; In the ASD, the author makes an attempt to
               ;; programmatically determine the location of the
               ;; source-code so lisp can call into "py4cl.py". We can
               ;; hard-code this since we know where this file will
               ;; reside.
               (substitute* "src/python-process.lisp"
                 (("py4cl/config:\\*base-directory\\*")
                  (string-append
                   "\""
                   (assoc-ref outputs "out")
                   "/share/common-lisp/"
                   (%lisp-type)
                   "/py4cl/"
                   "\""))))))))
      (synopsis "Call python from Common Lisp")
      (description
       "Py4CL is a bridge between Common Lisp and Python, which enables Common
Lisp to interact with Python code.  It uses streams to communicate with a
separate python process, the approach taken by cl4py.  This is different to
the CFFI approach used by burgled-batteries, but has the same goal.")
      (home-page "https://github.com/bendudson/py4cl")
      ;; MIT License
      (license license:expat))))

(define-public cl-py4cl
  (sbcl-package->cl-source-package sbcl-py4cl))

(define-public ecl-py4cl
  (sbcl-package->ecl-package sbcl-py4cl))

(define-public clasp-py4cl
  (sbcl-package->clasp-package sbcl-py4cl))

(define-public sbcl-pythonic-string-reader
  (let ((commit "47a70ba1e32362e03dad6ef8e6f36180b560f86a"))
    (package
      (name "sbcl-pythonic-string-reader")
      (version (git-version "0.0.0" "1" commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/smithzvk/pythonic-string-reader/")
               (commit commit)))
         (sha256
          (base32 "1b5iryqw8xsh36swckmz8rrngmc39k92si33fgy5pml3n9l5rq3j"))
         (file-name (git-file-name "pythonic-string-reader" version))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-named-readtables))
      (home-page "https://github.com/smithzvk/pythonic-string-reader")
      (synopsis "Read table modification inspired by Python's three quote strings")
      (description "This piece of code sets up some reader macros that make it
simpler to input string literals which contain backslashes and double quotes
This is very useful for writing complicated docstrings and, as it turns out,
writing code that contains string literals that contain code themselves.")
      (license license:bsd-3))))

(define-public cl-pythonic-string-reader
  (sbcl-package->cl-source-package sbcl-pythonic-string-reader))

(define-public ecl-pythonic-string-reader
  (sbcl-package->ecl-package sbcl-pythonic-string-reader))

(define-public clasp-pythonic-string-reader
  (sbcl-package->clasp-package sbcl-pythonic-string-reader))

(define-public sbcl-pzmq
  (let ((commit "6f7b2ca02c23ea53510a9b0e0f181d5364ce9d32")
        (revision "2"))
    (package
      (name "sbcl-pzmq")
      (version (git-version "0.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/orivej/pzmq")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "19mdhxhzzghlmff1fic4chg5iz0psglkim09z6dgpijm26biny05"))))
      (build-system asdf-build-system/sbcl)
      (native-inputs
       `(("bordeaux-threads" ,sbcl-bordeaux-threads)
         ("fiveam" ,sbcl-fiveam)
         ("let-plus" ,sbcl-let-plus)))
      (inputs
       `(("cffi" ,sbcl-cffi)
         ("zeromq" ,zeromq)))
      (arguments
       `(#:phases (modify-phases %standard-phases
                    (add-after 'unpack 'fix-paths
                      (lambda* (#:key inputs #:allow-other-keys)
                        (substitute* "c-api.lisp"
                          (("\"libzmq")
                           (string-append "\""
                                          (assoc-ref inputs "zeromq")
                                          "/lib/libzmq")))
                        #t)))))
      (synopsis "Common Lisp bindings for the ZeroMQ library")
      (description "This Common Lisp library provides bindings for the ZeroMQ
lightweight messaging kernel.")
      (home-page "https://github.com/orivej/pzmq")
      (license license:unlicense))))

(define-public cl-pzmq
  (sbcl-package->cl-source-package sbcl-pzmq))

(define-public ecl-pzmq
  (sbcl-package->ecl-package sbcl-pzmq))

(define-public sbcl-qbase64
  (package
    (name "sbcl-qbase64")
    (version "0.3.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/chaitanyagupta/qbase64")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1dir0s70ca3hagxv9x15zq4p4ajgl7jrcgqsza2n2y7iqbxh0dwi"))))
    (build-system asdf-build-system/sbcl)
    (inputs
     (list sbcl-metabang-bind sbcl-trivial-gray-streams))
    (native-inputs
     (list sbcl-fiveam))
    (home-page "https://github.com/chaitanyagupta/qbase64")
    (synopsis "Base64 encoder and decoder for Common Lisp")
    (description "@code{qbase64} provides a fast and flexible base64 encoder
and decoder for Common Lisp.")
    (license license:bsd-3)))

(define-public cl-qbase64
  (sbcl-package->cl-source-package sbcl-qbase64))

(define-public ecl-qbase64
  (sbcl-package->ecl-package sbcl-qbase64))

(define-public sbcl-qmynd
  (let ((commit "7e56daf73f0ed5f49a931c01af75fb874bcf3445")
        (revision "1"))
    (package
      (name "sbcl-qmynd")
      (version (git-version "1.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/qitab/qmynd")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "06gw5wxcpdclb6a5i5k9lbmdlyqsp182czrm9bm1cpklzbj0ihrl"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-asdf-finalizers
             sbcl-babel
             sbcl-chipz
             sbcl-cl+ssl
             sbcl-flexi-streams
             sbcl-ironclad
             sbcl-salza2
             sbcl-trivial-gray-streams
             sbcl-usocket))
      (home-page "https://github.com/qitab/qmynd")
      (synopsis "QITAB MySQL Native Driver for Common Lisp")
      (description "QMyND, the QITAB MySQL Native Driver, is a MySQL client
library that directly talks to a MySQL server in its native network protocol.

It's a part of QITAB umbrella project.")
      (license license:expat))))

(define-public cl-qmynd
  (sbcl-package->cl-source-package sbcl-qmynd))

(define-public ecl-qmynd
  (sbcl-package->ecl-package sbcl-qmynd))

(define-public sbcl-quantile-estimator
  (package
    (name "sbcl-quantile-estimator")
    (version "0.0.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/deadtrickster/quantile-estimator.cl")
             (commit "84d0ea405d793f5e808c68c4ddaf25417b0ff8e5")))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "0rlswkf0siaabsvvch3dgxmg45fw5w8pd9b7ri2w7a298aya52z9"))))
    (build-system asdf-build-system/sbcl)
    (arguments
     '(#:asd-test-systems '("quantile-estimator.test")))
    (inputs
     (list sbcl-alexandria))
    (native-inputs
     (list sbcl-mw-equiv sbcl-prove sbcl-log4cl))
    (home-page "https://github.com/deadtrickster/quantile-estimator.cl")
    (synopsis
     "Effective computation of biased quantiles over data streams")
    (description
     "Common Lisp implementation of Graham Cormode and S.
Muthukrishnan's Effective Computation of Biased Quantiles over Data
Streams in ICDE’05.")
    (license license:expat)))

(define-public cl-quantile-estimator
  (sbcl-package->cl-source-package sbcl-quantile-estimator))

(define-public ecl-quantile-estimator
  (sbcl-package->ecl-package sbcl-quantile-estimator))

(define-public sbcl-queues
  (let ((commit "47d4da65e9ea20953b74aeeab7e89a831b66bc94"))
    (package
      (name "sbcl-queues")
      (version (git-version "0.0.0" "1" commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/oconnore/queues")
               (commit commit)))
         (file-name (git-file-name "queues" version))
         (sha256
          (base32
           "0wdhfnzi4v6d97pggzj2aw55si94w4327br94jrmyvwf351wqjvv"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       `(("bordeaux-threads" ,sbcl-bordeaux-threads)))
      (arguments
       '(#:asd-systems '("queues"
                         "queues.simple-queue"
                         "queues.simple-cqueue"
                         "queues.priority-queue"
                         "queues.priority-cqueue")))
      (home-page "https://github.com/oconnore/queues")
      (synopsis "Common Lisp queue library")
      (description
       "This is a simple queue library for Common Lisp with features such as
non-consing thread safe queues and fibonacci priority queues.")
      (license license:expat))))

(define-public cl-queues
  (sbcl-package->cl-source-package sbcl-queues))

(define-public ecl-queues
  (sbcl-package->ecl-package sbcl-queues))

(define-public sbcl-quicklisp-stats
  (let ((commit "953b45c2212ae513d48a611d3dd09c846a6102cd")
        (revision "0"))
    (package
      (name "sbcl-quicklisp-stats")
      (version (git-version "0.0.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/phoe/quicklisp-stats")
               (commit commit)))
         (file-name (git-file-name "cl-quicklisp-stats" version))
         (sha256
          (base32 "0v8dgmlgd283n1g486q4sj2mghgdvgywg2nqp43nnrfc04mkvgc0"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-alexandria
             sbcl-drakma
             sbcl-split-sequence))
      (arguments
       `(#:tests? #f)) ; There are no tests.
      (synopsis "Fetches and operates on Quicklisp download statistics")
      (description
       "@code{cl-quicklisp-stats} is a system that fetches and performs basic
operations on the Quicklisp download statistics.")
      (home-page "https://github.com/phoe/quicklisp-stats/")
      (license license:expat))))

(define-public cl-quicklisp-stats
  (sbcl-package->cl-source-package sbcl-quicklisp-stats))

(define-public ecl-quicklisp-stats
  (sbcl-package->ecl-package sbcl-quicklisp-stats))

(define-public sbcl-quickproject
  (package
    (name "sbcl-quickproject")
    (version "1.4.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/xach/quickproject")
             (commit (string-append "release-" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1szs8p2wr1yr9mjmj3h3557l6wxzzga0iszimb68z0hb1jj3lva6"))))
    (build-system asdf-build-system/sbcl)
    (inputs
     `(("cl-fad" ,sbcl-cl-fad)
       ("html-template" ,sbcl-html-template)))
    (home-page "https://xach.com/lisp/quickproject/")
    (synopsis "Create Common Lisp project skeletons")
    (description
     "Quickproject provides a quick way to make a Common Lisp project.  After
creating a project, it extends the ASDF registry so the project may be
immediately loaded.")
    (license license:expat)))

(define-public cl-quickproject
  (sbcl-package->cl-source-package sbcl-quickproject))

(define-public ecl-quickproject
  (sbcl-package->ecl-package sbcl-quickproject))

(define-public sbcl-quicksearch
  (let ((commit "fb02ecf7c876ec580ab18c7d2c8c7814c06af599"))
    (package
      (name "sbcl-quicksearch")
      (version (git-version "0.01.04" "1" commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/tkych/quicksearch/")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "16k19zjkhh7r64vjq371k5jwjs7cdfjz83flh561n4h4v1z89fps"))))
      (build-system asdf-build-system/sbcl)
      (inputs
       (list sbcl-bordeaux-threads
             sbcl-iterate
             sbcl-alexandria
             sbcl-anaphora
             sbcl-cl-ppcre
             sbcl-drakma
             sbcl-html-entities
             sbcl-yason
             sbcl-flexi-streams
             sbcl-do-urlencode))
      (home-page "https://github.com/tkych/quicksearch/")
      (synopsis "Search Engine Interface for Common Lisp packages")
      (description "Quicksearch is a search-engine-interface for Common Lisp.
The goal of Quicksearch is to find the Common Lisp library quickly.  For
example, if you will find the library about json, just type @code{(qs:?
'json)} at REPL.

The function @code{quicksearch} searches for Common Lisp projects in
Quicklisp, Cliki, GitHub and BitBucket, then outputs results in REPL.  The
function @code{?} is abbreviation wrapper for @code{quicksearch}.")
      (license license:expat))))

(define-public cl-quicksearch
  (sbcl-package->cl-source-package sbcl-quicksearch))

(define-public ecl-quicksearch
  (sbcl-package->ecl-package sbcl-quicksearch))

(define-public sbcl-quri
  (let ((commit "03ecaf3771561d713e58a9c5c22b4d95a7592527")
        (revision "0"))
    (package
      (name "sbcl-quri")
      (version (git-version "0.7.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/fukamachi/quri")
               (commit commit)))
         (file-name (git-file-name "cl-quri" version))
         (sha256
          (base32 "1dd96mvgwbs799qzh7amc7kgwy84qhi1gw1yj08n83wmy5k4b9k2"))))
      (build-system asdf-build-system/sbcl)
      (native-inputs (list sbcl-prove))
      (inputs (list sbcl-babel sbcl-split-sequence sbcl-cl-utilities
                    sbcl-alexandria))
      (home-page "https://github.com/fukamachi/quri")
      (synopsis "Yet another URI library for Common Lisp")
      (description
       "QURI (pronounced \"Q-ree\") is yet another URI library for Common
Lisp.  It is intended to be a replacement of PURI.")
      (license license:bsd-3))))

(define-public cl-quri
  (sbcl-package->cl-source-package sbcl-quri))

(define-public ecl-quri
  (sbcl-package->ecl-package sbcl-quri))

(define-public sbcl-radiance
  (let ((commit "8d826c7fe1935338565580931db43f46181e0e85")
        (revision "3"))
    (package
      (name "sbcl-radiance")
      (version (git-version "2.1.2" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/Shirakumo/radiance")
               (commit commit)))
         (file-name (git-file-name "radiance" version))
         (sha256
          (base32 "1j823dgp87www0sjbcbv9j025bfxlkwhjd7kz6635mrqwmmlki4l"))))
      (build-system asdf-build-system/sbcl)
      (arguments
       `(#:tests? #f  ; TODO: The tests require some configuration.
         #:phases
         (modify-phases %standard-phases
           (add-after 'unpack 'disable-quicklisp
             (lambda _
               ;; Disable the automatic installation of systems by Quicklisp.
               ;; (Maybe there would be a way to package Quicklisp and make it
               ;; install things in the user's directory instead of
               ;; /gnu/store/...).
               (substitute* "interfaces.lisp"
                 (("\\(unless \\(asdf:find-system configured-implementation NIL\\)"
                   all)
                  (string-append "#+quicklisp " all))))))))
      (native-inputs
       (list sbcl-alexandria
             sbcl-dexador
             sbcl-parachute
         